
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Rate for a Room. Used in Response
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Rates" minOccurs="0">
 *       &lt;!-- Reference to inner class Rates -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="RatePlanDescription" minOccurs="0">
 *       &lt;!-- Reference to inner class RatePlanDescription -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AdditionalDetailsType" name="AdditionalDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:FeesType" name="Fees" minOccurs="0"/>
 *     &lt;xs:element type="ns:LodgingTaxesType" name="Taxes" minOccurs="0"/>
 *     &lt;xs:element type="ns:CancelPenalties" name="CancelPenalties" minOccurs="0"/>
 *     &lt;xs:element type="ns:GuaranteeType" name="Guarantee" minOccurs="0"/>
 *     &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
 *     &lt;xs:element type="ns:Discounts" name="Discounts" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="AmountBeforeTax"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="AmountAfterTax"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AppliedDiscount"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="NightlyRate"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AdditionalFeesExcludedIndicator"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="SupplierChangedAmount"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Changed"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AdditionalFeesInclusive"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="TaxInclusive"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="LocalFeesInclusive"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="IncidentalsInclusive"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RateInfoType implements Serializable
{
    private Rates rates;
    private RatePlanDescription ratePlanDescription;
    private AdditionalDetailsType additionalDetails;
    private FeesType fees;
    private LodgingTaxesType taxes;
    private CancelPenalties cancelPenalties;
    private GuaranteeType guarantee;
    private CommissionType commission;
    private Discounts discounts;
    private BigDecimal amountBeforeTax;
    private BigDecimal amountAfterTax;
    private String currencyCode;
    private Boolean appliedDiscount;
    private BigDecimal nightlyRate;
    private Boolean additionalFeesExcludedIndicator;
    private BigDecimal supplierChangedAmount;
    private Boolean changed;
    private Boolean additionalFeesInclusive;
    private Boolean taxInclusive;
    private Boolean localFeesInclusive;
    private Boolean incidentalsInclusive;

    /** 
     * Get the 'Rates' element value.
     * 
     * @return value
     */
    public Rates getRates() {
        return rates;
    }

    /** 
     * Set the 'Rates' element value.
     * 
     * @param rates
     */
    public void setRates(Rates rates) {
        this.rates = rates;
    }

    /** 
     * Get the 'RatePlanDescription' element value.
     * 
     * @return value
     */
    public RatePlanDescription getRatePlanDescription() {
        return ratePlanDescription;
    }

    /** 
     * Set the 'RatePlanDescription' element value.
     * 
     * @param ratePlanDescription
     */
    public void setRatePlanDescription(RatePlanDescription ratePlanDescription) {
        this.ratePlanDescription = ratePlanDescription;
    }

    /** 
     * Get the 'AdditionalDetails' element value. CheckIn Instruction Code is 8 in ADT table 
     * 
     * @return value
     */
    public AdditionalDetailsType getAdditionalDetails() {
        return additionalDetails;
    }

    /** 
     * Set the 'AdditionalDetails' element value. CheckIn Instruction Code is 8 in ADT table 
     * 
     * @param additionalDetails
     */
    public void setAdditionalDetails(AdditionalDetailsType additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    /** 
     * Get the 'Fees' element value.
     * 
     * @return value
     */
    public FeesType getFees() {
        return fees;
    }

    /** 
     * Set the 'Fees' element value.
     * 
     * @param fees
     */
    public void setFees(FeesType fees) {
        this.fees = fees;
    }

    /** 
     * Get the 'Taxes' element value.
     * 
     * @return value
     */
    public LodgingTaxesType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value.
     * 
     * @param taxes
     */
    public void setTaxes(LodgingTaxesType taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'CancelPenalties' element value.
     * 
     * @return value
     */
    public CancelPenalties getCancelPenalties() {
        return cancelPenalties;
    }

    /** 
     * Set the 'CancelPenalties' element value.
     * 
     * @param cancelPenalties
     */
    public void setCancelPenalties(CancelPenalties cancelPenalties) {
        this.cancelPenalties = cancelPenalties;
    }

    /** 
     * Get the 'Guarantee' element value.
     * 
     * @return value
     */
    public GuaranteeType getGuarantee() {
        return guarantee;
    }

    /** 
     * Set the 'Guarantee' element value.
     * 
     * @param guarantee
     */
    public void setGuarantee(GuaranteeType guarantee) {
        this.guarantee = guarantee;
    }

    /** 
     * Get the 'Commission' element value.
     * 
     * @return value
     */
    public CommissionType getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value.
     * 
     * @param commission
     */
    public void setCommission(CommissionType commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'Discounts' element value.
     * 
     * @return value
     */
    public Discounts getDiscounts() {
        return discounts;
    }

    /** 
     * Set the 'Discounts' element value.
     * 
     * @param discounts
     */
    public void setDiscounts(Discounts discounts) {
        this.discounts = discounts;
    }

    /** 
     * Get the 'AmountBeforeTax' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmountBeforeTax() {
        return amountBeforeTax;
    }

    /** 
     * Set the 'AmountBeforeTax' attribute value.
     * 
     * @param amountBeforeTax
     */
    public void setAmountBeforeTax(BigDecimal amountBeforeTax) {
        this.amountBeforeTax = amountBeforeTax;
    }

    /** 
     * Get the 'AmountAfterTax' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmountAfterTax() {
        return amountAfterTax;
    }

    /** 
     * Set the 'AmountAfterTax' attribute value.
     * 
     * @param amountAfterTax
     */
    public void setAmountAfterTax(BigDecimal amountAfterTax) {
        this.amountAfterTax = amountAfterTax;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'AppliedDiscount' attribute value.
     * 
     * @return value
     */
    public Boolean getAppliedDiscount() {
        return appliedDiscount;
    }

    /** 
     * Set the 'AppliedDiscount' attribute value.
     * 
     * @param appliedDiscount
     */
    public void setAppliedDiscount(Boolean appliedDiscount) {
        this.appliedDiscount = appliedDiscount;
    }

    /** 
     * Get the 'NightlyRate' attribute value.
     * 
     * @return value
     */
    public BigDecimal getNightlyRate() {
        return nightlyRate;
    }

    /** 
     * Set the 'NightlyRate' attribute value.
     * 
     * @param nightlyRate
     */
    public void setNightlyRate(BigDecimal nightlyRate) {
        this.nightlyRate = nightlyRate;
    }

    /** 
     * Get the 'AdditionalFeesExcludedIndicator' attribute value.
     * 
     * @return value
     */
    public Boolean getAdditionalFeesExcludedIndicator() {
        return additionalFeesExcludedIndicator;
    }

    /** 
     * Set the 'AdditionalFeesExcludedIndicator' attribute value.
     * 
     * @param additionalFeesExcludedIndicator
     */
    public void setAdditionalFeesExcludedIndicator(
            Boolean additionalFeesExcludedIndicator) {
        this.additionalFeesExcludedIndicator = additionalFeesExcludedIndicator;
    }

    /** 
     * Get the 'SupplierChangedAmount' attribute value.
     * 
     * @return value
     */
    public BigDecimal getSupplierChangedAmount() {
        return supplierChangedAmount;
    }

    /** 
     * Set the 'SupplierChangedAmount' attribute value.
     * 
     * @param supplierChangedAmount
     */
    public void setSupplierChangedAmount(BigDecimal supplierChangedAmount) {
        this.supplierChangedAmount = supplierChangedAmount;
    }

    /** 
     * Get the 'Changed' attribute value. Denotes that total is changed since shopping
     * 
     * @return value
     */
    public Boolean getChanged() {
        return changed;
    }

    /** 
     * Set the 'Changed' attribute value. Denotes that total is changed since shopping
     * 
     * @param changed
     */
    public void setChanged(Boolean changed) {
        this.changed = changed;
    }

    /** 
     * Get the 'AdditionalFeesInclusive' attribute value.
     * 
     * @return value
     */
    public Boolean getAdditionalFeesInclusive() {
        return additionalFeesInclusive;
    }

    /** 
     * Set the 'AdditionalFeesInclusive' attribute value.
     * 
     * @param additionalFeesInclusive
     */
    public void setAdditionalFeesInclusive(Boolean additionalFeesInclusive) {
        this.additionalFeesInclusive = additionalFeesInclusive;
    }

    /** 
     * Get the 'TaxInclusive' attribute value.
     * 
     * @return value
     */
    public Boolean getTaxInclusive() {
        return taxInclusive;
    }

    /** 
     * Set the 'TaxInclusive' attribute value.
     * 
     * @param taxInclusive
     */
    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    /** 
     * Get the 'LocalFeesInclusive' attribute value.
     * 
     * @return value
     */
    public Boolean getLocalFeesInclusive() {
        return localFeesInclusive;
    }

    /** 
     * Set the 'LocalFeesInclusive' attribute value.
     * 
     * @param localFeesInclusive
     */
    public void setLocalFeesInclusive(Boolean localFeesInclusive) {
        this.localFeesInclusive = localFeesInclusive;
    }

    /** 
     * Get the 'IncidentalsInclusive' attribute value.
     * 
     * @return value
     */
    public Boolean getIncidentalsInclusive() {
        return incidentalsInclusive;
    }

    /** 
     * Set the 'IncidentalsInclusive' attribute value.
     * 
     * @param incidentalsInclusive
     */
    public void setIncidentalsInclusive(Boolean incidentalsInclusive) {
        this.incidentalsInclusive = incidentalsInclusive;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rates" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Rate" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Rate -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Rates implements Serializable
    {
        private List<Rate> rateList = new ArrayList<Rate>();

        /** 
         * Get the list of 'Rate' element items.
         * 
         * @return list
         */
        public List<Rate> getRateList() {
            return rateList;
        }

        /** 
         * Set the list of 'Rate' element items.
         * 
         * @param list
         */
        public void setRateList(List<Rate> list) {
            rateList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rate" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:date" use="optional" name="StartDate"/>
         *     &lt;xs:attribute type="xs:date" use="optional" name="EndDate"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="AmountBeforeTax"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="AmountAfterTax"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rate implements Serializable
        {
            private Date startDate;
            private Date endDate;
            private BigDecimal amountBeforeTax;
            private BigDecimal amountAfterTax;
            private String currencyCode;

            /** 
             * Get the 'StartDate' attribute value.
             * 
             * @return value
             */
            public Date getStartDate() {
                return startDate;
            }

            /** 
             * Set the 'StartDate' attribute value.
             * 
             * @param startDate
             */
            public void setStartDate(Date startDate) {
                this.startDate = startDate;
            }

            /** 
             * Get the 'EndDate' attribute value.
             * 
             * @return value
             */
            public Date getEndDate() {
                return endDate;
            }

            /** 
             * Set the 'EndDate' attribute value.
             * 
             * @param endDate
             */
            public void setEndDate(Date endDate) {
                this.endDate = endDate;
            }

            /** 
             * Get the 'AmountBeforeTax' attribute value.
             * 
             * @return value
             */
            public BigDecimal getAmountBeforeTax() {
                return amountBeforeTax;
            }

            /** 
             * Set the 'AmountBeforeTax' attribute value.
             * 
             * @param amountBeforeTax
             */
            public void setAmountBeforeTax(BigDecimal amountBeforeTax) {
                this.amountBeforeTax = amountBeforeTax;
            }

            /** 
             * Get the 'AmountAfterTax' attribute value.
             * 
             * @return value
             */
            public BigDecimal getAmountAfterTax() {
                return amountAfterTax;
            }

            /** 
             * Set the 'AmountAfterTax' attribute value.
             * 
             * @param amountAfterTax
             */
            public void setAmountAfterTax(BigDecimal amountAfterTax) {
                this.amountAfterTax = amountAfterTax;
            }

            /** 
             * Get the 'CurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RatePlanDescription" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RatePlanDescription implements Serializable
    {
        private String text;

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
}
