
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * For tracking potential PNR booking for further review
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Review">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="Candidate"/>
 *     &lt;xs:element type="xs:string" name="Reporter"/>
 *     &lt;xs:element type="xs:int" name="Value" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Review implements Serializable
{
    private boolean candidate;
    private String reporter;
    private Integer value;
    private String description;

    /** 
     * Get the 'Candidate' element value. Indicator for potential PNR booking for further review
     * 
     * @return value
     */
    public boolean isCandidate() {
        return candidate;
    }

    /** 
     * Set the 'Candidate' element value. Indicator for potential PNR booking for further review
     * 
     * @param candidate
     */
    public void setCandidate(boolean candidate) {
        this.candidate = candidate;
    }

    /** 
     * Get the 'Reporter' element value. TN or Airline Code reporting potential PNR booking for further review
     * 
     * @return value
     */
    public String getReporter() {
        return reporter;
    }

    /** 
     * Set the 'Reporter' element value. TN or Airline Code reporting potential PNR booking for further review
     * 
     * @param reporter
     */
    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    /** 
     * Get the 'Value' element value. Numeric value of the potential PNR booking for further review
     * 
     * @return value
     */
    public Integer getValue() {
        return value;
    }

    /** 
     * Set the 'Value' element value. Numeric value of the potential PNR booking for further review
     * 
     * @param value
     */
    public void setValue(Integer value) {
        this.value = value;
    }

    /** 
     * Get the 'Description' element value. Short description of reason for reporting potential PNR booking for further review
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Short description of reason for reporting potential PNR booking for further review
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }
}
