
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * List of Extended Rooms. Used in response
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rooms">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RoomInformation" name="Room" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="optional" name="NumberOfRooms"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="GuestCount"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Rooms implements Serializable
{
    private List<RoomInformation> roomList = new ArrayList<RoomInformation>();
    private Integer numberOfRooms;
    private Integer guestCount;

    /** 
     * Get the list of 'Room' element items.
     * 
     * @return list
     */
    public List<RoomInformation> getRoomList() {
        return roomList;
    }

    /** 
     * Set the list of 'Room' element items.
     * 
     * @param list
     */
    public void setRoomList(List<RoomInformation> list) {
        roomList = list;
    }

    /** 
     * Get the 'NumberOfRooms' attribute value.
     * 
     * @return value
     */
    public Integer getNumberOfRooms() {
        return numberOfRooms;
    }

    /** 
     * Set the 'NumberOfRooms' attribute value.
     * 
     * @param numberOfRooms
     */
    public void setNumberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    /** 
     * Get the 'GuestCount' attribute value.
     * 
     * @return value
     */
    public Integer getGuestCount() {
        return guestCount;
    }

    /** 
     * Set the 'GuestCount' attribute value.
     * 
     * @param guestCount
     */
    public void setGuestCount(Integer guestCount) {
        this.guestCount = guestCount;
    }
}
