
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceRefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Description" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Description -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="PassengerReferences" minOccurs="0">
 *       &lt;!-- Reference to inner class PassengerReferences -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Accommodation" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Occupancy" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="NoOfServices" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TravellerAllocation" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceType" name="ServicePrice" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StealBoarding" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:SegmentCommonAttributes"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceRefType implements Serializable
{
    private List<Description> descriptionList = new ArrayList<Description>();
    private PassengerReferences passengerReferences;
    private String accommodation;
    private String occupancy;
    private Integer noOfServices;
    private String travellerAllocation;
    private PriceType servicePrice;
    private String stealBoarding;
    private SegmentCommonAttributes segmentCommonAttributes;
    private String id;

    /** 
     * Get the list of 'Description' element items.
     * 
     * @return list
     */
    public List<Description> getDescriptionList() {
        return descriptionList;
    }

    /** 
     * Set the list of 'Description' element items.
     * 
     * @param list
     */
    public void setDescriptionList(List<Description> list) {
        descriptionList = list;
    }

    /** 
     * Get the 'PassengerReferences' element value.
     * 
     * @return value
     */
    public PassengerReferences getPassengerReferences() {
        return passengerReferences;
    }

    /** 
     * Set the 'PassengerReferences' element value.
     * 
     * @param passengerReferences
     */
    public void setPassengerReferences(PassengerReferences passengerReferences) {
        this.passengerReferences = passengerReferences;
    }

    /** 
     * Get the 'Accommodation' element value.
     * 
     * @return value
     */
    public String getAccommodation() {
        return accommodation;
    }

    /** 
     * Set the 'Accommodation' element value.
     * 
     * @param accommodation
     */
    public void setAccommodation(String accommodation) {
        this.accommodation = accommodation;
    }

    /** 
     * Get the 'Occupancy' element value.
     * 
     * @return value
     */
    public String getOccupancy() {
        return occupancy;
    }

    /** 
     * Set the 'Occupancy' element value.
     * 
     * @param occupancy
     */
    public void setOccupancy(String occupancy) {
        this.occupancy = occupancy;
    }

    /** 
     * Get the 'NoOfServices' element value.
     * 
     * @return value
     */
    public Integer getNoOfServices() {
        return noOfServices;
    }

    /** 
     * Set the 'NoOfServices' element value.
     * 
     * @param noOfServices
     */
    public void setNoOfServices(Integer noOfServices) {
        this.noOfServices = noOfServices;
    }

    /** 
     * Get the 'TravellerAllocation' element value.
     * 
     * @return value
     */
    public String getTravellerAllocation() {
        return travellerAllocation;
    }

    /** 
     * Set the 'TravellerAllocation' element value.
     * 
     * @param travellerAllocation
     */
    public void setTravellerAllocation(String travellerAllocation) {
        this.travellerAllocation = travellerAllocation;
    }

    /** 
     * Get the 'ServicePrice' element value.
     * 
     * @return value
     */
    public PriceType getServicePrice() {
        return servicePrice;
    }

    /** 
     * Set the 'ServicePrice' element value.
     * 
     * @param servicePrice
     */
    public void setServicePrice(PriceType servicePrice) {
        this.servicePrice = servicePrice;
    }

    /** 
     * Get the 'StealBoarding' element value.
     * 
     * @return value
     */
    public String getStealBoarding() {
        return stealBoarding;
    }

    /** 
     * Set the 'StealBoarding' element value.
     * 
     * @param stealBoarding
     */
    public void setStealBoarding(String stealBoarding) {
        this.stealBoarding = stealBoarding;
    }

    /** 
     * Get the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @return value
     */
    public SegmentCommonAttributes getSegmentCommonAttributes() {
        return segmentCommonAttributes;
    }

    /** 
     * Set the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @param segmentCommonAttributes
     */
    public void setSegmentCommonAttributes(
            SegmentCommonAttributes segmentCommonAttributes) {
        this.segmentCommonAttributes = segmentCommonAttributes;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Description" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="lang"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Description implements Serializable
    {
        private String string;
        private String lang;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'lang' attribute value.
         * 
         * @return value
         */
        public String getLang() {
            return lang;
        }

        /** 
         * Set the 'lang' attribute value.
         * 
         * @param lang
         */
        public void setLang(String lang) {
            this.lang = lang;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerReferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerRef" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PassengerRef -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerReferences implements Serializable
    {
        private List<PassengerRef> passengerRefList = new ArrayList<PassengerRef>();

        /** 
         * Get the list of 'PassengerRef' element items.
         * 
         * @return list
         */
        public List<PassengerRef> getPassengerRefList() {
            return passengerRefList;
        }

        /** 
         * Set the list of 'PassengerRef' element items.
         * 
         * @param list
         */
        public void setPassengerRefList(List<PassengerRef> list) {
            passengerRefList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerRef" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:anySimpleType" name="id"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerRef implements Serializable
        {
            private String id;

            /** 
             * Get the 'id' attribute value.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'id' attribute value.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }
        }
    }
}
