
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceRequestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FullText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:choice minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="actionCode"/>
 *   &lt;xs:attribute type="xs:string" name="airlineCode"/>
 *   &lt;xs:attribute type="xs:string" name="code"/>
 *   &lt;xs:attribute type="xs:string" name="serviceCount"/>
 *   &lt;xs:attribute type="xs:string" name="serviceType"/>
 *   &lt;xs:attribute type="xs:string" name="ssrType"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceRequestType implements Serializable
{
    private String comment;
    private String freeText;
    private String fullText;
    private Choice choice;
    private String actionCode;
    private String airlineCode;
    private String code;
    private String serviceCount;
    private String serviceType;
    private String ssrType;

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'FreeText' element value.
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value.
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'FullText' element value.
     * 
     * @return value
     */
    public String getFullText() {
        return fullText;
    }

    /** 
     * Set the 'FullText' element value.
     * 
     * @param fullText
     */
    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'actionCode' attribute value. NN,HK,KK ... etc.
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'actionCode' attribute value. NN,HK,KK ... etc.
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'airlineCode' attribute value. ex. EY
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'airlineCode' attribute value. ex. EY
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the 'code' attribute value. DOCS,DOCO ... etc.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. DOCS,DOCO ... etc.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'serviceCount' attribute value. count of service items
     * 
     * @return value
     */
    public String getServiceCount() {
        return serviceCount;
    }

    /** 
     * Set the 'serviceCount' attribute value. count of service items
     * 
     * @param serviceCount
     */
    public void setServiceCount(String serviceCount) {
        this.serviceCount = serviceCount;
    }

    /** 
     * Get the 'serviceType' attribute value. OSI/SSR or O/S
     * 
     * @return value
     */
    public String getServiceType() {
        return serviceType;
    }

    /** 
     * Set the 'serviceType' attribute value. OSI/SSR or O/S
     * 
     * @param serviceType
     */
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    /** 
     * Get the 'ssrType' attribute value. AFX/GFX or A/G
     * 
     * @return value
     */
    public String getSsrType() {
        return ssrType;
    }

    /** 
     * Set the 'ssrType' attribute value. AFX/GFX or A/G
     * 
     * @param ssrType
     */
    public void setSsrType(String ssrType) {
        this.ssrType = ssrType;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="1">
     *   &lt;xs:element type="ns:ServiceRequestType.PassengerAddressInformation" name="PassengerAddressInformation" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="ns:ServiceRequestType.OtherSupplementaryInformation" name="OtherSupplementaryInformation" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="ns:ServiceRequestType.TravelDocument" name="TravelDocument" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="ns:ServiceRequestType.PassengerProvidedContactForPassenger" name="PassengerProvidedContactForPassenger" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="ns:ServiceRequestType.PassengerContactEmail" name="PassengerContactEmail" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="ns:ServiceRequestType.PassengerContactMobilePhone" name="PassengerContactMobilePhone" minOccurs="0" maxOccurs="1"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int PASSENGER_ADDRESS_INFORMATION_CHOICE = 0;
        private static final int OTHER_SUPPLEMENTARY_INFORMATION_CHOICE = 1;
        private static final int TRAVEL_DOCUMENT_CHOICE = 2;
        private static final int PASSENGER_PROVIDED_CONTACT_FOR_PASSENGER_CHOICE = 3;
        private static final int PASSENGER_CONTACT_EMAIL_CHOICE = 4;
        private static final int PASSENGER_CONTACT_MOBILE_PHONE_CHOICE = 5;
        private ServiceRequestTypePassengerAddressInformation passengerAddressInformation;
        private ServiceRequestTypeOtherSupplementaryInformation otherSupplementaryInformation;
        private ServiceRequestTypeTravelDocument travelDocument;
        private ServiceRequestTypePassengerProvidedContactForPassenger passengerProvidedContactForPassenger;
        private ServiceRequestTypePassengerContactEmail passengerContactEmail;
        private ServiceRequestTypePassengerContactMobilePhone passengerContactMobilePhone;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if PassengerAddressInformation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPassengerAddressInformation() {
            return choiceSelect == PASSENGER_ADDRESS_INFORMATION_CHOICE;
        }

        /** 
         * Get the 'PassengerAddressInformation' element value.
         * 
         * @return value
         */
        public ServiceRequestTypePassengerAddressInformation getPassengerAddressInformation() {
            return passengerAddressInformation;
        }

        /** 
         * Set the 'PassengerAddressInformation' element value.
         * 
         * @param passengerAddressInformation
         */
        public void setPassengerAddressInformation(
                ServiceRequestTypePassengerAddressInformation passengerAddressInformation) {
            setChoiceSelect(PASSENGER_ADDRESS_INFORMATION_CHOICE);
            this.passengerAddressInformation = passengerAddressInformation;
        }

        /** 
         * Check if OtherSupplementaryInformation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOtherSupplementaryInformation() {
            return choiceSelect == OTHER_SUPPLEMENTARY_INFORMATION_CHOICE;
        }

        /** 
         * Get the 'OtherSupplementaryInformation' element value.
         * 
         * @return value
         */
        public ServiceRequestTypeOtherSupplementaryInformation getOtherSupplementaryInformation() {
            return otherSupplementaryInformation;
        }

        /** 
         * Set the 'OtherSupplementaryInformation' element value.
         * 
         * @param otherSupplementaryInformation
         */
        public void setOtherSupplementaryInformation(
                ServiceRequestTypeOtherSupplementaryInformation otherSupplementaryInformation) {
            setChoiceSelect(OTHER_SUPPLEMENTARY_INFORMATION_CHOICE);
            this.otherSupplementaryInformation = otherSupplementaryInformation;
        }

        /** 
         * Check if TravelDocument is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelDocument() {
            return choiceSelect == TRAVEL_DOCUMENT_CHOICE;
        }

        /** 
         * Get the 'TravelDocument' element value.
         * 
         * @return value
         */
        public ServiceRequestTypeTravelDocument getTravelDocument() {
            return travelDocument;
        }

        /** 
         * Set the 'TravelDocument' element value.
         * 
         * @param travelDocument
         */
        public void setTravelDocument(
                ServiceRequestTypeTravelDocument travelDocument) {
            setChoiceSelect(TRAVEL_DOCUMENT_CHOICE);
            this.travelDocument = travelDocument;
        }

        /** 
         * Check if PassengerProvidedContactForPassenger is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPassengerProvidedContactForPassenger() {
            return choiceSelect == PASSENGER_PROVIDED_CONTACT_FOR_PASSENGER_CHOICE;
        }

        /** 
         * Get the 'PassengerProvidedContactForPassenger' element value.
         * 
         * @return value
         */
        public ServiceRequestTypePassengerProvidedContactForPassenger getPassengerProvidedContactForPassenger() {
            return passengerProvidedContactForPassenger;
        }

        /** 
         * Set the 'PassengerProvidedContactForPassenger' element value.
         * 
         * @param passengerProvidedContactForPassenger
         */
        public void setPassengerProvidedContactForPassenger(
                ServiceRequestTypePassengerProvidedContactForPassenger passengerProvidedContactForPassenger) {
            setChoiceSelect(PASSENGER_PROVIDED_CONTACT_FOR_PASSENGER_CHOICE);
            this.passengerProvidedContactForPassenger = passengerProvidedContactForPassenger;
        }

        /** 
         * Check if PassengerContactEmail is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPassengerContactEmail() {
            return choiceSelect == PASSENGER_CONTACT_EMAIL_CHOICE;
        }

        /** 
         * Get the 'PassengerContactEmail' element value.
         * 
         * @return value
         */
        public ServiceRequestTypePassengerContactEmail getPassengerContactEmail() {
            return passengerContactEmail;
        }

        /** 
         * Set the 'PassengerContactEmail' element value.
         * 
         * @param passengerContactEmail
         */
        public void setPassengerContactEmail(
                ServiceRequestTypePassengerContactEmail passengerContactEmail) {
            setChoiceSelect(PASSENGER_CONTACT_EMAIL_CHOICE);
            this.passengerContactEmail = passengerContactEmail;
        }

        /** 
         * Check if PassengerContactMobilePhone is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPassengerContactMobilePhone() {
            return choiceSelect == PASSENGER_CONTACT_MOBILE_PHONE_CHOICE;
        }

        /** 
         * Get the 'PassengerContactMobilePhone' element value.
         * 
         * @return value
         */
        public ServiceRequestTypePassengerContactMobilePhone getPassengerContactMobilePhone() {
            return passengerContactMobilePhone;
        }

        /** 
         * Set the 'PassengerContactMobilePhone' element value.
         * 
         * @param passengerContactMobilePhone
         */
        public void setPassengerContactMobilePhone(
                ServiceRequestTypePassengerContactMobilePhone passengerContactMobilePhone) {
            setChoiceSelect(PASSENGER_CONTACT_MOBILE_PHONE_CHOICE);
            this.passengerContactMobilePhone = passengerContactMobilePhone;
        }
    }
}
