
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxGroupsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TaxGroup" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class TaxGroup -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxGroupsType implements Serializable
{
    private List<TaxGroup> taxGroupList = new ArrayList<TaxGroup>();

    /** 
     * Get the list of 'TaxGroup' element items.
     * 
     * @return list
     */
    public List<TaxGroup> getTaxGroupList() {
        return taxGroupList;
    }

    /** 
     * Set the list of 'TaxGroup' element items.
     * 
     * @param list
     */
    public void setTaxGroupList(List<TaxGroup> list) {
        taxGroupList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxGroup" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TaxDescription">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TaxGroup implements Serializable
    {
        private List<String> taxDescriptionList = new ArrayList<String>();
        private String code;
        private BigDecimal amount;
        private String currencyCode;

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTaxDescriptionList() {
            return taxDescriptionList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTaxDescriptionList(List<String> list) {
            taxDescriptionList = list;
        }

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'CurrencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
}
