
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Describes Total and various charge for the trip
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalCharges">
 *   &lt;xs:attribute type="xs:decimal" use="optional" default="0.00" name="AmountAfterTax"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="AmountBeforeTax"/>
 *   &lt;xs:attribute type="xs:string" use="optional" default="USD" name="CurrencyCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Changed"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="BalanceAmount"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="SupplierChangedAmount"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TotalCharges implements Serializable
{
    private BigDecimal amountAfterTax;
    private BigDecimal amountBeforeTax;
    private String currencyCode;
    private Boolean changed;
    private BigDecimal balanceAmount;
    private BigDecimal supplierChangedAmount;

    /** 
     * Get the 'AmountAfterTax' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmountAfterTax() {
        return amountAfterTax;
    }

    /** 
     * Set the 'AmountAfterTax' attribute value.
     * 
     * @param amountAfterTax
     */
    public void setAmountAfterTax(BigDecimal amountAfterTax) {
        this.amountAfterTax = amountAfterTax;
    }

    /** 
     * Get the 'AmountBeforeTax' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmountBeforeTax() {
        return amountBeforeTax;
    }

    /** 
     * Set the 'AmountBeforeTax' attribute value.
     * 
     * @param amountBeforeTax
     */
    public void setAmountBeforeTax(BigDecimal amountBeforeTax) {
        this.amountBeforeTax = amountBeforeTax;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'Changed' attribute value. Denotes that total is changed since shopping
     * 
     * @return value
     */
    public Boolean getChanged() {
        return changed;
    }

    /** 
     * Set the 'Changed' attribute value. Denotes that total is changed since shopping
     * 
     * @param changed
     */
    public void setChanged(Boolean changed) {
        this.changed = changed;
    }

    /** 
     * Get the 'BalanceAmount' attribute value. Some aggregators return a balance amount that needs to be paid after cancellation
     * 
     * @return value
     */
    public BigDecimal getBalanceAmount() {
        return balanceAmount;
    }

    /** 
     * Set the 'BalanceAmount' attribute value. Some aggregators return a balance amount that needs to be paid after cancellation
     * 
     * @param balanceAmount
     */
    public void setBalanceAmount(BigDecimal balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    /** 
     * Get the 'SupplierChangedAmount' attribute value.
     * 
     * @return value
     */
    public BigDecimal getSupplierChangedAmount() {
        return supplierChangedAmount;
    }

    /** 
     * Set the 'SupplierChangedAmount' attribute value.
     * 
     * @param supplierChangedAmount
     */
    public void setSupplierChangedAmount(BigDecimal supplierChangedAmount) {
        this.supplierChangedAmount = supplierChangedAmount;
    }
}
