
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Customer Value Scores and Frequent Flyer Tiers for one traveler. It
 can influence Availability results when provided.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerRatingType">
 *   &lt;xs:sequence>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:ScoreType" name="Score" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="ns:FrequentFlyerType" name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerRatingType implements Serializable
{
    private List<ScoreType> scoreList = new ArrayList<ScoreType>();
    private List<FrequentFlyerType> frequentFlyerList = new ArrayList<FrequentFlyerType>();

    /** 
     * Get the list of 'Score' element items.
     * 
     * @return list
     */
    public List<ScoreType> getScoreList() {
        return scoreList;
    }

    /** 
     * Set the list of 'Score' element items.
     * 
     * @param list
     */
    public void setScoreList(List<ScoreType> list) {
        scoreList = list;
    }

    /** 
     * Get the list of 'FrequentFlyer' element items.
     * 
     * @return list
     */
    public List<FrequentFlyerType> getFrequentFlyerList() {
        return frequentFlyerList;
    }

    /** 
     * Set the list of 'FrequentFlyer' element items.
     * 
     * @param list
     */
    public void setFrequentFlyerList(List<FrequentFlyerType> list) {
        frequentFlyerList = list;
    }
}
