
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ChangePolicy" minOccurs="0">
 *       &lt;!-- Reference to inner class ChangePolicy -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DirectConnect" minOccurs="0"/>
 *     &lt;xs:element type="ns:POSType" name="POS" minOccurs="0"/>
 *     &lt;xs:element name="VehicleRentalCore" minOccurs="0">
 *       &lt;!-- Reference to inner class VehicleRentalCore -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="VehicleVendorAvail" minOccurs="0">
 *       &lt;!-- Reference to inner class VehicleVendorAvail -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PricingElementsType" name="PricingElements" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="dayOfWeekInd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="linkCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="mergedSegmentInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VehicleType implements Serializable
{
    private ChangePolicy changePolicy;
    private String confirmationNumber;
    private String directConnect;
    private POSType POS;
    private VehicleRentalCore vehicleRentalCore;
    private VehicleVendorAvail vehicleVendorAvail;
    private PricingElementsType pricingElements;
    private String dayOfWeekInd;
    private String linkCode;
    private String mergedSegmentInd;

    /** 
     * Get the 'ChangePolicy' element value.
     * 
     * @return value
     */
    public ChangePolicy getChangePolicy() {
        return changePolicy;
    }

    /** 
     * Set the 'ChangePolicy' element value.
     * 
     * @param changePolicy
     */
    public void setChangePolicy(ChangePolicy changePolicy) {
        this.changePolicy = changePolicy;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. "ConfirmationNumber" is used to return the vehicle rental confirmation number.
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. "ConfirmationNumber" is used to return the vehicle rental confirmation number.
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'DirectConnect' element value. "DirectConnect" is used to return miscellaneous direct connect-related information.
     * 
     * @return value
     */
    public String getDirectConnect() {
        return directConnect;
    }

    /** 
     * Set the 'DirectConnect' element value. "DirectConnect" is used to return miscellaneous direct connect-related information.
     * 
     * @param directConnect
     */
    public void setDirectConnect(String directConnect) {
        this.directConnect = directConnect;
    }

    /** 
     * Get the 'POS' element value.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'VehicleRentalCore' element value.
     * 
     * @return value
     */
    public VehicleRentalCore getVehicleRentalCore() {
        return vehicleRentalCore;
    }

    /** 
     * Set the 'VehicleRentalCore' element value.
     * 
     * @param vehicleRentalCore
     */
    public void setVehicleRentalCore(VehicleRentalCore vehicleRentalCore) {
        this.vehicleRentalCore = vehicleRentalCore;
    }

    /** 
     * Get the 'VehicleVendorAvail' element value.
     * 
     * @return value
     */
    public VehicleVendorAvail getVehicleVendorAvail() {
        return vehicleVendorAvail;
    }

    /** 
     * Set the 'VehicleVendorAvail' element value.
     * 
     * @param vehicleVendorAvail
     */
    public void setVehicleVendorAvail(VehicleVendorAvail vehicleVendorAvail) {
        this.vehicleVendorAvail = vehicleVendorAvail;
    }

    /** 
     * Get the 'PricingElements' element value.
     * 
     * @return value
     */
    public PricingElementsType getPricingElements() {
        return pricingElements;
    }

    /** 
     * Set the 'PricingElements' element value.
     * 
     * @param pricingElements
     */
    public void setPricingElements(PricingElementsType pricingElements) {
        this.pricingElements = pricingElements;
    }

    /** 
     * Get the 'dayOfWeekInd' attribute value. "dayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @return value
     */
    public String getDayOfWeekInd() {
        return dayOfWeekInd;
    }

    /** 
     * Set the 'dayOfWeekInd' attribute value. "dayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @param dayOfWeekInd
     */
    public void setDayOfWeekInd(String dayOfWeekInd) {
        this.dayOfWeekInd = dayOfWeekInd;
    }

    /** 
     * Get the 'linkCode' attribute value. "LinkCode" - Identifier of accounting line assigned to segment
     * 
     * @return value
     */
    public String getLinkCode() {
        return linkCode;
    }

    /** 
     * Set the 'linkCode' attribute value. "LinkCode" - Identifier of accounting line assigned to segment
     * 
     * @param linkCode
     */
    public void setLinkCode(String linkCode) {
        this.linkCode = linkCode;
    }

    /** 
     * Get the 'mergedSegmentInd' attribute value. "mergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
     * 
     * @return value
     */
    public String getMergedSegmentInd() {
        return mergedSegmentInd;
    }

    /** 
     * Set the 'mergedSegmentInd' attribute value. "mergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
     * 
     * @param mergedSegmentInd
     */
    public void setMergedSegmentInd(String mergedSegmentInd) {
        this.mergedSegmentInd = mergedSegmentInd;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangePolicy" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ChangePolicy implements Serializable
    {
        private String comment;

        /** 
         * Get the 'Comment' element value.
         * 
         * @return value
         */
        public String getComment() {
            return comment;
        }

        /** 
         * Set the 'Comment' element value.
         * 
         * @param comment
         */
        public void setComment(String comment) {
            this.comment = comment;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleRentalCore" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="DropOffLocationDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class DropOffLocationDetails -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightSegment" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightSegment -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LocationDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class LocationDetails -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="pickUpDateTime"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="returnDateTime"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VehicleRentalCore implements Serializable
    {
        private DropOffLocationDetails dropOffLocationDetails;
        private FlightSegment flightSegment;
        private LocationDetails locationDetails;
        private String pickUpDateTime;
        private String returnDateTime;

        /** 
         * Get the 'DropOffLocationDetails' element value.
         * 
         * @return value
         */
        public DropOffLocationDetails getDropOffLocationDetails() {
            return dropOffLocationDetails;
        }

        /** 
         * Set the 'DropOffLocationDetails' element value.
         * 
         * @param dropOffLocationDetails
         */
        public void setDropOffLocationDetails(
                DropOffLocationDetails dropOffLocationDetails) {
            this.dropOffLocationDetails = dropOffLocationDetails;
        }

        /** 
         * Get the 'FlightSegment' element value.
         * 
         * @return value
         */
        public FlightSegment getFlightSegment() {
            return flightSegment;
        }

        /** 
         * Set the 'FlightSegment' element value.
         * 
         * @param flightSegment
         */
        public void setFlightSegment(FlightSegment flightSegment) {
            this.flightSegment = flightSegment;
        }

        /** 
         * Get the 'LocationDetails' element value.
         * 
         * @return value
         */
        public LocationDetails getLocationDetails() {
            return locationDetails;
        }

        /** 
         * Set the 'LocationDetails' element value.
         * 
         * @param locationDetails
         */
        public void setLocationDetails(LocationDetails locationDetails) {
            this.locationDetails = locationDetails;
        }

        /** 
         * Get the 'pickUpDateTime' attribute value. "pickUpDateTime" follows this format: MM-DDTHH:MM
         * 
         * @return value
         */
        public String getPickUpDateTime() {
            return pickUpDateTime;
        }

        /** 
         * Set the 'pickUpDateTime' attribute value. "pickUpDateTime" follows this format: MM-DDTHH:MM
         * 
         * @param pickUpDateTime
         */
        public void setPickUpDateTime(String pickUpDateTime) {
            this.pickUpDateTime = pickUpDateTime;
        }

        /** 
         * Get the 'returnDateTime' attribute value. "returnDateTime" follows this format: MM-DDTHH:MM
         * 
         * @return value
         */
        public String getReturnDateTime() {
            return returnDateTime;
        }

        /** 
         * Set the 'returnDateTime' attribute value. "returnDateTime" follows this format: MM-DDTHH:MM
         * 
         * @param returnDateTime
         */
        public void setReturnDateTime(String returnDateTime) {
            this.returnDateTime = returnDateTime;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DropOffLocationDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="locationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="extendedLocationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="locationName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DropOffLocationDetails implements Serializable
        {
            private String locationCode;
            private String extendedLocationCode;
            private String locationName;

            /** 
             * Get the 'locationCode' attribute value. "LocationCode" is used to return the vehicle drop off rental location code.
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'locationCode' attribute value. "LocationCode" is used to return the vehicle drop off rental location code.
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }

            /** 
             * Get the 'extendedLocationCode' attribute value. "extendedLocationCode" is used to return the extended vehicle pick up rental location code.
             * 
             * @return value
             */
            public String getExtendedLocationCode() {
                return extendedLocationCode;
            }

            /** 
             * Set the 'extendedLocationCode' attribute value. "extendedLocationCode" is used to return the extended vehicle pick up rental location code.
             * 
             * @param extendedLocationCode
             */
            public void setExtendedLocationCode(String extendedLocationCode) {
                this.extendedLocationCode = extendedLocationCode;
            }

            /** 
             * Get the 'locationName' attribute value. "locationName" is used to return the vehicle pick up rental location name.
             * 
             * @return value
             */
            public String getLocationName() {
                return locationName;
            }

            /** 
             * Set the 'locationName' attribute value. "locationName" is used to return the vehicle pick up rental location name.
             * 
             * @param locationName
             */
            public void setLocationName(String locationName) {
                this.locationName = locationName;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="MarketingAirline" minOccurs="0">
         *         &lt;!-- Reference to inner class MarketingAirline -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="flightNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegment implements Serializable
        {
            private MarketingAirline marketingAirline;
            private String flightNumber;

            /** 
             * Get the 'MarketingAirline' element value.
             * 
             * @return value
             */
            public MarketingAirline getMarketingAirline() {
                return marketingAirline;
            }

            /** 
             * Set the 'MarketingAirline' element value.
             * 
             * @param marketingAirline
             */
            public void setMarketingAirline(MarketingAirline marketingAirline) {
                this.marketingAirline = marketingAirline;
            }

            /** 
             * Get the 'flightNumber' attribute value. "flightNumber" is used to return the flight number associated with the particular flight segment.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'flightNumber' attribute value. "flightNumber" is used to return the flight number associated with the particular flight segment.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="code"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="flightNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MarketingAirline implements Serializable
            {
                private String code;
                private String flightNumber;

                /** 
                 * Get the 'code' attribute value. "code" is used to return the marketing airline code associated with the particular vehicle segment.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. "code" is used to return the marketing airline code associated with the particular vehicle segment.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'flightNumber' attribute value. "flightNumber" is used to return the flight number associated with the particular vehicle segment.
                 * 
                 * @return value
                 */
                public String getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'flightNumber' attribute value. "flightNumber" is used to return the flight number associated with the particular vehicle segment.
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PhoneType" name="ContactNumber" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="extendedLocationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="locationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="locationName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LocationDetails implements Serializable
        {
            private PhoneType contactNumber;
            private String extendedLocationCode;
            private String locationCode;
            private String locationName;

            /** 
             * Get the 'ContactNumber' element value.
             * 
             * @return value
             */
            public PhoneType getContactNumber() {
                return contactNumber;
            }

            /** 
             * Set the 'ContactNumber' element value.
             * 
             * @param contactNumber
             */
            public void setContactNumber(PhoneType contactNumber) {
                this.contactNumber = contactNumber;
            }

            /** 
             * Get the 'extendedLocationCode' attribute value. "extendedLocationCode" is used to return the extended vehicle pick up rental location code.
             * 
             * @return value
             */
            public String getExtendedLocationCode() {
                return extendedLocationCode;
            }

            /** 
             * Set the 'extendedLocationCode' attribute value. "extendedLocationCode" is used to return the extended vehicle pick up rental location code.
             * 
             * @param extendedLocationCode
             */
            public void setExtendedLocationCode(String extendedLocationCode) {
                this.extendedLocationCode = extendedLocationCode;
            }

            /** 
             * Get the 'locationCode' attribute value. "locationCode" is used to return the vehicle pick up rental location code.
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'locationCode' attribute value. "locationCode" is used to return the vehicle pick up rental location code.
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }

            /** 
             * Get the 'locationName' attribute value. "locationName" is used to return the vehicle pick up rental location name.
             * 
             * @return value
             */
            public String getLocationName() {
                return locationName;
            }

            /** 
             * Set the 'locationName' attribute value. "locationName" is used to return the vehicle pick up rental location name.
             * 
             * @param locationName
             */
            public void setLocationName(String locationName) {
                this.locationName = locationName;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleVendorAvail" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="VehicleResCore" minOccurs="0">
     *         &lt;!-- Reference to inner class VehicleResCore -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Vendor" minOccurs="0">
     *         &lt;!-- Reference to inner class Vendor -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VehicleVendorAvail implements Serializable
    {
        private VehicleResCore vehicleResCore;
        private Vendor vendor;

        /** 
         * Get the 'VehicleResCore' element value.
         * 
         * @return value
         */
        public VehicleResCore getVehicleResCore() {
            return vehicleResCore;
        }

        /** 
         * Set the 'VehicleResCore' element value.
         * 
         * @param vehicleResCore
         */
        public void setVehicleResCore(VehicleResCore vehicleResCore) {
            this.vehicleResCore = vehicleResCore;
        }

        /** 
         * Get the 'Vendor' element value.
         * 
         * @return value
         */
        public Vendor getVendor() {
            return vendor;
        }

        /** 
         * Set the 'Vendor' element value.
         * 
         * @param vendor
         */
        public void setVendor(Vendor vendor) {
            this.vendor = vendor;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleResCore" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="CollectionDeliveryInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class CollectionDeliveryInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="GuaranteePrepaid" minOccurs="0">
         *         &lt;!-- Reference to inner class GuaranteePrepaid -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PricedEquipment" minOccurs="0">
         *         &lt;!-- Reference to inner class PricedEquipment -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RentalRate" minOccurs="0">
         *         &lt;!-- Reference to inner class RentalRate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Charge" minOccurs="0">
         *         &lt;!-- Reference to inner class Charge -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VehicleResCore implements Serializable
        {
            private CollectionDeliveryInfo collectionDeliveryInfo;
            private GuaranteePrepaid guaranteePrepaid;
            private PricedEquipment pricedEquipment;
            private RentalRate rentalRate;
            private Charge charge;

            /** 
             * Get the 'CollectionDeliveryInfo' element value.
             * 
             * @return value
             */
            public CollectionDeliveryInfo getCollectionDeliveryInfo() {
                return collectionDeliveryInfo;
            }

            /** 
             * Set the 'CollectionDeliveryInfo' element value.
             * 
             * @param collectionDeliveryInfo
             */
            public void setCollectionDeliveryInfo(
                    CollectionDeliveryInfo collectionDeliveryInfo) {
                this.collectionDeliveryInfo = collectionDeliveryInfo;
            }

            /** 
             * Get the 'GuaranteePrepaid' element value.
             * 
             * @return value
             */
            public GuaranteePrepaid getGuaranteePrepaid() {
                return guaranteePrepaid;
            }

            /** 
             * Set the 'GuaranteePrepaid' element value.
             * 
             * @param guaranteePrepaid
             */
            public void setGuaranteePrepaid(GuaranteePrepaid guaranteePrepaid) {
                this.guaranteePrepaid = guaranteePrepaid;
            }

            /** 
             * Get the 'PricedEquipment' element value.
             * 
             * @return value
             */
            public PricedEquipment getPricedEquipment() {
                return pricedEquipment;
            }

            /** 
             * Set the 'PricedEquipment' element value.
             * 
             * @param pricedEquipment
             */
            public void setPricedEquipment(PricedEquipment pricedEquipment) {
                this.pricedEquipment = pricedEquipment;
            }

            /** 
             * Get the 'RentalRate' element value.
             * 
             * @return value
             */
            public RentalRate getRentalRate() {
                return rentalRate;
            }

            /** 
             * Set the 'RentalRate' element value.
             * 
             * @param rentalRate
             */
            public void setRentalRate(RentalRate rentalRate) {
                this.rentalRate = rentalRate;
            }

            /** 
             * Get the 'Charge' element value.
             * 
             * @return value
             */
            public Charge getCharge() {
                return charge;
            }

            /** 
             * Set the 'Charge' element value.
             * 
             * @param charge
             */
            public void setCharge(Charge charge) {
                this.charge = charge;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionDeliveryInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CollectionInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class CollectionInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="DeliveryInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class DeliveryInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CollectionDeliveryInfo implements Serializable
            {
                private CollectionInfo collectionInfo;
                private DeliveryInfo deliveryInfo;

                /** 
                 * Get the 'CollectionInfo' element value.
                 * 
                 * @return value
                 */
                public CollectionInfo getCollectionInfo() {
                    return collectionInfo;
                }

                /** 
                 * Set the 'CollectionInfo' element value.
                 * 
                 * @param collectionInfo
                 */
                public void setCollectionInfo(CollectionInfo collectionInfo) {
                    this.collectionInfo = collectionInfo;
                }

                /** 
                 * Get the 'DeliveryInfo' element value.
                 * 
                 * @return value
                 */
                public DeliveryInfo getDeliveryInfo() {
                    return deliveryInfo;
                }

                /** 
                 * Set the 'DeliveryInfo' element value.
                 * 
                 * @param deliveryInfo
                 */
                public void setDeliveryInfo(DeliveryInfo deliveryInfo) {
                    this.deliveryInfo = deliveryInfo;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0"/>
                 *       &lt;xs:element type="ns:PhoneType" name="ContactNumber" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="siteID"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="siteName"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CollectionInfo implements Serializable
                {
                    private AddressType address;
                    private PhoneType contactNumber;
                    private String siteID;
                    private String siteName;

                    /** 
                     * Get the 'Address' element value.
                     * 
                     * @return value
                     */
                    public AddressType getAddress() {
                        return address;
                    }

                    /** 
                     * Set the 'Address' element value.
                     * 
                     * @param address
                     */
                    public void setAddress(AddressType address) {
                        this.address = address;
                    }

                    /** 
                     * Get the 'ContactNumber' element value. "phone" is used to return the collection site phone number associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public PhoneType getContactNumber() {
                        return contactNumber;
                    }

                    /** 
                     * Set the 'ContactNumber' element value. "phone" is used to return the collection site phone number associated with the vehicle reservation if applicable.
                     * 
                     * @param contactNumber
                     */
                    public void setContactNumber(PhoneType contactNumber) {
                        this.contactNumber = contactNumber;
                    }

                    /** 
                     * Get the 'siteID' attribute value. "siteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getSiteID() {
                        return siteID;
                    }

                    /** 
                     * Set the 'siteID' attribute value. "siteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
                     * 
                     * @param siteID
                     */
                    public void setSiteID(String siteID) {
                        this.siteID = siteID;
                    }

                    /** 
                     * Get the 'siteName' attribute value. "siteName" is used to return the collection site name associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getSiteName() {
                        return siteName;
                    }

                    /** 
                     * Set the 'siteName' attribute value. "siteName" is used to return the collection site name associated with the vehicle reservation if applicable.
                     * 
                     * @param siteName
                     */
                    public void setSiteName(String siteName) {
                        this.siteName = siteName;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeliveryInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="CollectionFee" minOccurs="0"/>
                 *       &lt;xs:element type="ns:PhoneType" name="ContactNumber" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="siteID"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="siteName"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DeliveryInfo implements Serializable
                {
                    private AddressType address;
                    private String collectionFee;
                    private PhoneType contactNumber;
                    private String siteID;
                    private String siteName;

                    /** 
                     * Get the 'Address' element value.
                     * 
                     * @return value
                     */
                    public AddressType getAddress() {
                        return address;
                    }

                    /** 
                     * Set the 'Address' element value.
                     * 
                     * @param address
                     */
                    public void setAddress(AddressType address) {
                        this.address = address;
                    }

                    /** 
                     * Get the 'CollectionFee' element value. "CollectionFee" is used to return the Collection fee details associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getCollectionFee() {
                        return collectionFee;
                    }

                    /** 
                     * Set the 'CollectionFee' element value. "CollectionFee" is used to return the Collection fee details associated with the vehicle reservation if applicable.
                     * 
                     * @param collectionFee
                     */
                    public void setCollectionFee(String collectionFee) {
                        this.collectionFee = collectionFee;
                    }

                    /** 
                     * Get the 'ContactNumber' element value.
                     * 
                     * @return value
                     */
                    public PhoneType getContactNumber() {
                        return contactNumber;
                    }

                    /** 
                     * Set the 'ContactNumber' element value.
                     * 
                     * @param contactNumber
                     */
                    public void setContactNumber(PhoneType contactNumber) {
                        this.contactNumber = contactNumber;
                    }

                    /** 
                     * Get the 'siteID' attribute value. "siteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getSiteID() {
                        return siteID;
                    }

                    /** 
                     * Set the 'siteID' attribute value. "siteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
                     * 
                     * @param siteID
                     */
                    public void setSiteID(String siteID) {
                        this.siteID = siteID;
                    }

                    /** 
                     * Get the 'siteName' attribute value. "siteName" is used to return the collection site name associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getSiteName() {
                        return siteName;
                    }

                    /** 
                     * Set the 'siteName' attribute value. "siteName" is used to return the collection site name associated with the vehicle reservation if applicable.
                     * 
                     * @param siteName
                     */
                    public void setSiteName(String siteName) {
                        this.siteName = siteName;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteePrepaid" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CancellationRefundAmount" minOccurs="0" maxOccurs="4">
             *         &lt;!-- Reference to inner class CancellationRefundAmount -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="amount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="amountPercentage"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="currencyCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="typeOfGuarantee"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class GuaranteePrepaid implements Serializable
            {
                private List<CancellationRefundAmount> cancellationRefundAmountList = new ArrayList<CancellationRefundAmount>();
                private String amount;
                private String amountPercentage;
                private String currencyCode;
                private String typeOfGuarantee;

                /** 
                 * Get the list of 'CancellationRefundAmount' element items.
                 * 
                 * @return list
                 */
                public List<CancellationRefundAmount> getCancellationRefundAmountList() {
                    return cancellationRefundAmountList;
                }

                /** 
                 * Set the list of 'CancellationRefundAmount' element items.
                 * 
                 * @param list
                 */
                public void setCancellationRefundAmountList(
                        List<CancellationRefundAmount> list) {
                    cancellationRefundAmountList = list;
                }

                /** 
                 * Get the 'amount' attribute value. "amount" is used to return the guarantee amount.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'amount' attribute value. "amount" is used to return the guarantee amount.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'amountPercentage' attribute value. "amountPercentage" is used to indicate whether the CancellationRefundAmount is an amount or a percentage.
                 * 
                 * @return value
                 */
                public String getAmountPercentage() {
                    return amountPercentage;
                }

                /** 
                 * Set the 'amountPercentage' attribute value. "amountPercentage" is used to indicate whether the CancellationRefundAmount is an amount or a percentage.
                 * 
                 * @param amountPercentage
                 */
                public void setAmountPercentage(String amountPercentage) {
                    this.amountPercentage = amountPercentage;
                }

                /** 
                 * Get the 'currencyCode' attribute value. "currencyCode" is used to return the guarantee currency code.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value. "currencyCode" is used to return the guarantee currency code.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'typeOfGuarantee' attribute value. "typeOfGuarantee" is used to return the type of guarantee, i.e. guarantee or a prepaid.
                 * 
                 * @return value
                 */
                public String getTypeOfGuarantee() {
                    return typeOfGuarantee;
                }

                /** 
                 * Set the 'typeOfGuarantee' attribute value. "typeOfGuarantee" is used to return the type of guarantee, i.e. guarantee or a prepaid.
                 * 
                 * @param typeOfGuarantee
                 */
                public void setTypeOfGuarantee(String typeOfGuarantee) {
                    this.typeOfGuarantee = typeOfGuarantee;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancellationRefundAmount" minOccurs="0" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" use="optional" name="numDays"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CancellationRefundAmount implements
                    Serializable
                {
                    private String string;
                    private String numDays;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'numDays' attribute value. "numDays" is used to return the number of days associated with the particular CancellationRefundAmount.
                     * 
                     * @return value
                     */
                    public String getNumDays() {
                        return numDays;
                    }

                    /** 
                     * Set the 'numDays' attribute value. "numDays" is used to return the number of days associated with the particular CancellationRefundAmount.
                     * 
                     * @param numDays
                     */
                    public void setNumDays(String numDays) {
                        this.numDays = numDays;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedEquipment" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:SpecialEquipmentsType" name="SpecialEquipments" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="equipmentType"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="quantity"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="specialEquipmentConfirmed"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PricedEquipment implements Serializable
            {
                private SpecialEquipmentsType specialEquipments;
                private String equipmentType;
                private String quantity;
                private String specialEquipmentConfirmed;

                /** 
                 * Get the 'SpecialEquipments' element value. Holds list of Special equipments in this item.
                 * 
                 * @return value
                 */
                public SpecialEquipmentsType getSpecialEquipments() {
                    return specialEquipments;
                }

                /** 
                 * Set the 'SpecialEquipments' element value. Holds list of Special equipments in this item.
                 * 
                 * @param specialEquipments
                 */
                public void setSpecialEquipments(
                        SpecialEquipmentsType specialEquipments) {
                    this.specialEquipments = specialEquipments;
                }

                /** 
                 * Get the 'equipmentType' attribute value. "equipType" is used to return the category of vehicle associated with the vehicle rental.
                 * 
                 * @return value
                 */
                public String getEquipmentType() {
                    return equipmentType;
                }

                /** 
                 * Set the 'equipmentType' attribute value. "equipType" is used to return the category of vehicle associated with the vehicle rental.
                 * 
                 * @param equipmentType
                 */
                public void setEquipmentType(String equipmentType) {
                    this.equipmentType = equipmentType;
                }

                /** 
                 * Get the 'quantity' attribute value. "quantity" is used to return the number of reserved vehicles associated with the vehicle rental.
                 * 
                 * @return value
                 */
                public String getQuantity() {
                    return quantity;
                }

                /** 
                 * Set the 'quantity' attribute value. "quantity" is used to return the number of reserved vehicles associated with the vehicle rental.
                 * 
                 * @param quantity
                 */
                public void setQuantity(String quantity) {
                    this.quantity = quantity;
                }

                /** 
                 * Get the 'specialEquipmentConfirmed' attribute value. "specialEquipConfirmed" is used to denote whether or not the special equipment is confirmed.
                 * 
                 * @return value
                 */
                public String getSpecialEquipmentConfirmed() {
                    return specialEquipmentConfirmed;
                }

                /** 
                 * Set the 'specialEquipmentConfirmed' attribute value. "specialEquipConfirmed" is used to denote whether or not the special equipment is confirmed.
                 * 
                 * @param specialEquipmentConfirmed
                 */
                public void setSpecialEquipmentConfirmed(
                        String specialEquipmentConfirmed) {
                    this.specialEquipmentConfirmed = specialEquipmentConfirmed;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RentalRate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Billing" minOccurs="0">
             *         &lt;!-- Reference to inner class Billing -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Client" minOccurs="0">
             *         &lt;!-- Reference to inner class Client -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Corporate" minOccurs="0">
             *         &lt;!-- Reference to inner class Corporate -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="CustLoyalty" minOccurs="0">
             *         &lt;!-- Reference to inner class CustLoyalty -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="InvoiceRemarks" minOccurs="0">
             *         &lt;!-- Reference to inner class InvoiceRemarks -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Remarks" minOccurs="0">
             *         &lt;!-- Reference to inner class Remarks -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ReserveUnderName" minOccurs="0"/>
             *       &lt;xs:element name="ServiceInformation" minOccurs="0">
             *         &lt;!-- Reference to inner class ServiceInformation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TourCode" minOccurs="0">
             *         &lt;!-- Reference to inner class TourCode -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="VehicleTypes" minOccurs="0">
             *         &lt;!-- Reference to inner class VehicleTypes -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Voucher" minOccurs="0">
             *         &lt;!-- Reference to inner class Voucher -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="changed"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="guaranteedQuoted"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="rateCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="stmRatePlan"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RentalRate implements Serializable
            {
                private Billing billing;
                private Client client;
                private Corporate corporate;
                private CustLoyalty custLoyalty;
                private InvoiceRemarks invoiceRemarks;
                private Remarks remarks;
                private String reserveUnderName;
                private ServiceInformation serviceInformation;
                private TourCode tourCode;
                private VehicleTypes vehicleTypes;
                private Voucher voucher;
                private String changed;
                private String guaranteedQuoted;
                private String rateCode;
                private String stmRatePlan;

                /** 
                 * Get the 'Billing' element value.
                 * 
                 * @return value
                 */
                public Billing getBilling() {
                    return billing;
                }

                /** 
                 * Set the 'Billing' element value.
                 * 
                 * @param billing
                 */
                public void setBilling(Billing billing) {
                    this.billing = billing;
                }

                /** 
                 * Get the 'Client' element value.
                 * 
                 * @return value
                 */
                public Client getClient() {
                    return client;
                }

                /** 
                 * Set the 'Client' element value.
                 * 
                 * @param client
                 */
                public void setClient(Client client) {
                    this.client = client;
                }

                /** 
                 * Get the 'Corporate' element value.
                 * 
                 * @return value
                 */
                public Corporate getCorporate() {
                    return corporate;
                }

                /** 
                 * Set the 'Corporate' element value.
                 * 
                 * @param corporate
                 */
                public void setCorporate(Corporate corporate) {
                    this.corporate = corporate;
                }

                /** 
                 * Get the 'CustLoyalty' element value.
                 * 
                 * @return value
                 */
                public CustLoyalty getCustLoyalty() {
                    return custLoyalty;
                }

                /** 
                 * Set the 'CustLoyalty' element value.
                 * 
                 * @param custLoyalty
                 */
                public void setCustLoyalty(CustLoyalty custLoyalty) {
                    this.custLoyalty = custLoyalty;
                }

                /** 
                 * Get the 'InvoiceRemarks' element value.
                 * 
                 * @return value
                 */
                public InvoiceRemarks getInvoiceRemarks() {
                    return invoiceRemarks;
                }

                /** 
                 * Set the 'InvoiceRemarks' element value.
                 * 
                 * @param invoiceRemarks
                 */
                public void setInvoiceRemarks(InvoiceRemarks invoiceRemarks) {
                    this.invoiceRemarks = invoiceRemarks;
                }

                /** 
                 * Get the 'Remarks' element value.
                 * 
                 * @return value
                 */
                public Remarks getRemarks() {
                    return remarks;
                }

                /** 
                 * Set the 'Remarks' element value.
                 * 
                 * @param remarks
                 */
                public void setRemarks(Remarks remarks) {
                    this.remarks = remarks;
                }

                /** 
                 * Get the 'ReserveUnderName' element value. "ReserveUnderName" is used to return the name of the customer associated with the vehicle reservation.
                 * 
                 * @return value
                 */
                public String getReserveUnderName() {
                    return reserveUnderName;
                }

                /** 
                 * Set the 'ReserveUnderName' element value. "ReserveUnderName" is used to return the name of the customer associated with the vehicle reservation.
                 * 
                 * @param reserveUnderName
                 */
                public void setReserveUnderName(String reserveUnderName) {
                    this.reserveUnderName = reserveUnderName;
                }

                /** 
                 * Get the 'ServiceInformation' element value.
                 * 
                 * @return value
                 */
                public ServiceInformation getServiceInformation() {
                    return serviceInformation;
                }

                /** 
                 * Set the 'ServiceInformation' element value.
                 * 
                 * @param serviceInformation
                 */
                public void setServiceInformation(
                        ServiceInformation serviceInformation) {
                    this.serviceInformation = serviceInformation;
                }

                /** 
                 * Get the 'TourCode' element value.
                 * 
                 * @return value
                 */
                public TourCode getTourCode() {
                    return tourCode;
                }

                /** 
                 * Set the 'TourCode' element value.
                 * 
                 * @param tourCode
                 */
                public void setTourCode(TourCode tourCode) {
                    this.tourCode = tourCode;
                }

                /** 
                 * Get the 'VehicleTypes' element value.
                 * 
                 * @return value
                 */
                public VehicleTypes getVehicleTypes() {
                    return vehicleTypes;
                }

                /** 
                 * Set the 'VehicleTypes' element value.
                 * 
                 * @param vehicleTypes
                 */
                public void setVehicleTypes(VehicleTypes vehicleTypes) {
                    this.vehicleTypes = vehicleTypes;
                }

                /** 
                 * Get the 'Voucher' element value.
                 * 
                 * @return value
                 */
                public Voucher getVoucher() {
                    return voucher;
                }

                /** 
                 * Set the 'Voucher' element value.
                 * 
                 * @param voucher
                 */
                public void setVoucher(Voucher voucher) {
                    this.voucher = voucher;
                }

                /** 
                 * Get the 'changed' attribute value. ‘@’ preceding rate item or any other car segment field indicating update by car supplier - /RG-¤USD52.72 UNL DY XH8.79 UNL
                 * 
                 * @return value
                 */
                public String getChanged() {
                    return changed;
                }

                /** 
                 * Set the 'changed' attribute value. ‘@’ preceding rate item or any other car segment field indicating update by car supplier - /RG-¤USD52.72 UNL DY XH8.79 UNL
                 * 
                 * @param changed
                 */
                public void setChanged(String changed) {
                    this.changed = changed;
                }

                /** 
                 * Get the 'guaranteedQuoted' attribute value. Indication of Guaranteed or Subject to Change Rate – ‘/RG-’ and ‘/RQ-’
                 * 
                 * @return value
                 */
                public String getGuaranteedQuoted() {
                    return guaranteedQuoted;
                }

                /** 
                 * Set the 'guaranteedQuoted' attribute value. Indication of Guaranteed or Subject to Change Rate – ‘/RG-’ and ‘/RQ-’
                 * 
                 * @param guaranteedQuoted
                 */
                public void setGuaranteedQuoted(String guaranteedQuoted) {
                    this.guaranteedQuoted = guaranteedQuoted;
                }

                /** 
                 * Get the 'rateCode' attribute value. Rate item Rate Code – ‘/RC-¤STDR’
                 * 
                 * @return value
                 */
                public String getRateCode() {
                    return rateCode;
                }

                /** 
                 * Set the 'rateCode' attribute value. Rate item Rate Code – ‘/RC-¤STDR’
                 * 
                 * @param rateCode
                 */
                public void setRateCode(String rateCode) {
                    this.rateCode = rateCode;
                }

                /** 
                 * Get the 'stmRatePlan' attribute value. Rate item rate plan – ‘/RG-¤USD52.72 UNL DY XH8.79 UNL’
                 * 
                 * @return value
                 */
                public String getStmRatePlan() {
                    return stmRatePlan;
                }

                /** 
                 * Set the 'stmRatePlan' attribute value. Rate item rate plan – ‘/RG-¤USD52.72 UNL DY XH8.79 UNL’
                 * 
                 * @param stmRatePlan
                 */
                public void setStmRatePlan(String stmRatePlan) {
                    this.stmRatePlan = stmRatePlan;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Billing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="reference"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Billing implements Serializable
                {
                    private String number;
                    private String reference;

                    /** 
                     * Get the 'number' attribute value. "number" is used to return the billing number.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'number' attribute value. "number" is used to return the billing number.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'reference' attribute value. "reference" is used to return the billing reference number.
                     * 
                     * @return value
                     */
                    public String getReference() {
                        return reference;
                    }

                    /** 
                     * Set the 'reference' attribute value. "reference" is used to return the billing reference number.
                     * 
                     * @param reference
                     */
                    public void setReference(String reference) {
                        this.reference = reference;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Client" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="ID" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Client implements Serializable
                {
                    private String ID;

                    /** 
                     * Get the 'ID' element value. "ID" is used to return the client ID associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getID() {
                        return ID;
                    }

                    /** 
                     * Set the 'ID' element value. "ID" is used to return the client ID associated with the vehicle reservation if applicable.
                     * 
                     * @param ID
                     */
                    public void setID(String ID) {
                        this.ID = ID;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="ID" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Corporate implements Serializable
                {
                    private String ID;

                    /** 
                     * Get the 'ID' element value. "ID" is used to return the corporate ID associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getID() {
                        return ID;
                    }

                    /** 
                     * Set the 'ID' element value. "ID" is used to return the corporate ID associated with the vehicle reservation if applicable.
                     * 
                     * @param ID
                     */
                    public void setID(String ID) {
                        this.ID = ID;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="membershipID"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CustLoyalty implements Serializable
                {
                    private String membershipID;

                    /** 
                     * Get the 'membershipID' attribute value. "membershipID" is used to return the frequent flyer number associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getMembershipID() {
                        return membershipID;
                    }

                    /** 
                     * Set the 'membershipID' attribute value. "membershipID" is used to return the frequent flyer number associated with the vehicle reservation if applicable.
                     * 
                     * @param membershipID
                     */
                    public void setMembershipID(String membershipID) {
                        this.membershipID = membershipID;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceRemarks" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="5"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class InvoiceRemarks implements Serializable
                {
                    private List<String> textList = new ArrayList<String>();

                    /** 
                     * Get the list of 'Text' element items. "Text" is used to return miscellaneous invoice remark-related information if applicable.
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items. "Text" is used to return miscellaneous invoice remark-related information if applicable.
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remarks" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Remarks implements Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value. "Text" is used to return miscellaneous remark-related information if applicable.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. "Text" is used to return miscellaneous remark-related information if applicable.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceInformation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ServiceInformation implements Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value. "Text" is used to return service-related information.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. "Text" is used to return service-related information.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TourCode implements Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value. "Text" is used to return tour code-related information.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. "Text" is used to return tour code-related information.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleTypes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Transmission" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="VehType" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="UpgradedVehType" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VehicleTypes implements Serializable
                {
                    private String transmission;
                    private String vehType;
                    private String upgradedVehType;

                    /** 
                     * Get the 'Transmission' element value.
                     * 
                     * @return value
                     */
                    public String getTransmission() {
                        return transmission;
                    }

                    /** 
                     * Set the 'Transmission' element value.
                     * 
                     * @param transmission
                     */
                    public void setTransmission(String transmission) {
                        this.transmission = transmission;
                    }

                    /** 
                     * Get the 'VehType' element value. "VehType" is used to return the vehicle type associated with the vehicle reservation.
                     * 
                     * @return value
                     */
                    public String getVehType() {
                        return vehType;
                    }

                    /** 
                     * Set the 'VehType' element value. "VehType" is used to return the vehicle type associated with the vehicle reservation.
                     * 
                     * @param vehType
                     */
                    public void setVehType(String vehType) {
                        this.vehType = vehType;
                    }

                    /** 
                     * Get the 'UpgradedVehType' element value. Vehicle Upgrade field – indicates upgrade field provided by supplier – ‘/UPG-@ECAR’
                     * 
                     * @return value
                     */
                    public String getUpgradedVehType() {
                        return upgradedVehType;
                    }

                    /** 
                     * Set the 'UpgradedVehType' element value. Vehicle Upgrade field – indicates upgrade field provided by supplier – ‘/UPG-@ECAR’
                     * 
                     * @param upgradedVehType
                     */
                    public void setUpgradedVehType(String upgradedVehType) {
                        this.upgradedVehType = upgradedVehType;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Voucher" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="billingNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="format"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="id"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Voucher implements Serializable
                {
                    private String billingNumber;
                    private String format;
                    private String id;
                    private String type;

                    /** 
                     * Get the 'billingNumber' attribute value. "billingNumber" used to return the voucher billing number associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getBillingNumber() {
                        return billingNumber;
                    }

                    /** 
                     * Set the 'billingNumber' attribute value. "billingNumber" used to return the voucher billing number associated with the vehicle reservation if applicable.
                     * 
                     * @param billingNumber
                     */
                    public void setBillingNumber(String billingNumber) {
                        this.billingNumber = billingNumber;
                    }

                    /** 
                     * Get the 'format' attribute value. "format" is used to return the voucher format associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getFormat() {
                        return format;
                    }

                    /** 
                     * Set the 'format' attribute value. "format" is used to return the voucher format associated with the vehicle reservation if applicable.
                     * 
                     * @param format
                     */
                    public void setFormat(String format) {
                        this.format = format;
                    }

                    /** 
                     * Get the 'id' attribute value. "id" is used to return the voucher ID associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'id' attribute value. "id" is used to return the voucher ID associated with the vehicle reservation if applicable.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }

                    /** 
                     * Get the 'type' attribute value. "type" is used to return the type of voucher associated with the vehicle reservation if applicable.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. "type" is used to return the type of voucher associated with the vehicle reservation if applicable.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Charge" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Amount" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="ConversionRate" minOccurs="0">
             *         &lt;!-- Reference to inner class ConversionRate -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ChargeDetails" minOccurs="0">
             *         &lt;!-- Reference to inner class ChargeDetails -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Mileage" minOccurs="0">
             *         &lt;!-- Reference to inner class Mileage -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ExcessRate" minOccurs="0">
             *         &lt;!-- Reference to inner class ExcessRate -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="dropOffCharge"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="typeOfGuarantee"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Charge implements Serializable
            {
                private List<String> amountList = new ArrayList<String>();
                private ConversionRate conversionRate;
                private ChargeDetails chargeDetails;
                private Commission commission;
                private Mileage mileage;
                private ExcessRate excessRate;
                private String dropOffCharge;
                private String typeOfGuarantee;

                /** 
                 * Get the list of 'Amount' element items. "Amount" is used to return the vehicle charge amount.
                 * 
                 * @return list
                 */
                public List<String> getAmountList() {
                    return amountList;
                }

                /** 
                 * Set the list of 'Amount' element items. "Amount" is used to return the vehicle charge amount.
                 * 
                 * @param list
                 */
                public void setAmountList(List<String> list) {
                    amountList = list;
                }

                /** 
                 * Get the 'ConversionRate' element value.
                 * 
                 * @return value
                 */
                public ConversionRate getConversionRate() {
                    return conversionRate;
                }

                /** 
                 * Set the 'ConversionRate' element value.
                 * 
                 * @param conversionRate
                 */
                public void setConversionRate(ConversionRate conversionRate) {
                    this.conversionRate = conversionRate;
                }

                /** 
                 * Get the 'ChargeDetails' element value.
                 * 
                 * @return value
                 */
                public ChargeDetails getChargeDetails() {
                    return chargeDetails;
                }

                /** 
                 * Set the 'ChargeDetails' element value.
                 * 
                 * @param chargeDetails
                 */
                public void setChargeDetails(ChargeDetails chargeDetails) {
                    this.chargeDetails = chargeDetails;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'Mileage' element value.
                 * 
                 * @return value
                 */
                public Mileage getMileage() {
                    return mileage;
                }

                /** 
                 * Set the 'Mileage' element value.
                 * 
                 * @param mileage
                 */
                public void setMileage(Mileage mileage) {
                    this.mileage = mileage;
                }

                /** 
                 * Get the 'ExcessRate' element value.
                 * 
                 * @return value
                 */
                public ExcessRate getExcessRate() {
                    return excessRate;
                }

                /** 
                 * Set the 'ExcessRate' element value.
                 * 
                 * @param excessRate
                 */
                public void setExcessRate(ExcessRate excessRate) {
                    this.excessRate = excessRate;
                }

                /** 
                 * Get the 'dropOffCharge' attribute value. "dropOffCharge" is used to return drop off charge amount.
                 * 
                 * @return value
                 */
                public String getDropOffCharge() {
                    return dropOffCharge;
                }

                /** 
                 * Set the 'dropOffCharge' attribute value. "dropOffCharge" is used to return drop off charge amount.
                 * 
                 * @param dropOffCharge
                 */
                public void setDropOffCharge(String dropOffCharge) {
                    this.dropOffCharge = dropOffCharge;
                }

                /** 
                 * Get the 'typeOfGuarantee' attribute value. "typeOfGuarantee" is used to return the type of guarantee associated with the vehicle rental.
                 * 
                 * @return value
                 */
                public String getTypeOfGuarantee() {
                    return typeOfGuarantee;
                }

                /** 
                 * Set the 'typeOfGuarantee' attribute value. "typeOfGuarantee" is used to return the type of guarantee associated with the vehicle rental.
                 * 
                 * @param typeOfGuarantee
                 */
                public void setTypeOfGuarantee(String typeOfGuarantee) {
                    this.typeOfGuarantee = typeOfGuarantee;
                }
                /** 
                 * "Conversion rate" is used to return currency and conversion rate for payment in foreign currency
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConversionRate" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:decimal" name="value"/>
                 *     &lt;xs:attribute type="xs:string" name="currency"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ConversionRate implements Serializable
                {
                    private BigDecimal value;
                    private String currency;

                    /** 
                     * Get the 'value' attribute value.
                     * 
                     * @return value
                     */
                    public BigDecimal getValue() {
                        return value;
                    }

                    /** 
                     * Set the 'value' attribute value.
                     * 
                     * @param value
                     */
                    public void setValue(BigDecimal value) {
                        this.value = value;
                    }

                    /** 
                     * Get the 'currency' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrency() {
                        return currency;
                    }

                    /** 
                     * Set the 'currency' attribute value.
                     * 
                     * @param currency
                     */
                    public void setCurrency(String currency) {
                        this.currency = currency;
                    }
                }
                /** 
                 * 
                													Car segment Approximate price fields – ‘/AP-¤USD281.27 UNL 3DY 0HR 41.97SSQ 123.11MC/RC-¤STDR/CF-G31214927E8-‘
                												
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChargeDetails" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="ApproximateTotalCharge" minOccurs="0" maxOccurs="20">
                 *         &lt;!-- Reference to inner class ApproximateTotalCharge -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ChargeDetails implements Serializable
                {
                    private List<ApproximateTotalCharge> approximateTotalChargeList = new ArrayList<ApproximateTotalCharge>();

                    /** 
                     * Get the list of 'ApproximateTotalCharge' element items.
                     * 
                     * @return list
                     */
                    public List<ApproximateTotalCharge> getApproximateTotalChargeList() {
                        return approximateTotalChargeList;
                    }

                    /** 
                     * Set the list of 'ApproximateTotalCharge' element items.
                     * 
                     * @param list
                     */
                    public void setApproximateTotalChargeList(
                            List<ApproximateTotalCharge> list) {
                        approximateTotalChargeList = list;
                    }
                    /** 
                     * ‘/AP-¤USD281.27’
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApproximateTotalCharge" minOccurs="0" maxOccurs="20">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="mileageAllowance"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="numDays"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="numHours"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="rateType"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="totalMandatoryCharges"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ApproximateTotalCharge implements
                        Serializable
                    {
                        private String amount;
                        private String mileageAllowance;
                        private String numDays;
                        private String numHours;
                        private String rateType;
                        private String totalMandatoryCharges;

                        /** 
                         * Get the 'amount' attribute value. ‘/AP-¤USD281.27’
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'amount' attribute value. ‘/AP-¤USD281.27’
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'mileageAllowance' attribute value. Unlimited or Free Miles allowed – ‘UNL’
                         * 
                         * @return value
                         */
                        public String getMileageAllowance() {
                            return mileageAllowance;
                        }

                        /** 
                         * Set the 'mileageAllowance' attribute value. Unlimited or Free Miles allowed – ‘UNL’
                         * 
                         * @param mileageAllowance
                         */
                        public void setMileageAllowance(String mileageAllowance) {
                            this.mileageAllowance = mileageAllowance;
                        }

                        /** 
                         * Get the 'numDays' attribute value. Number of days of rental – ‘3DY 0HR’
                         * 
                         * @return value
                         */
                        public String getNumDays() {
                            return numDays;
                        }

                        /** 
                         * Set the 'numDays' attribute value. Number of days of rental – ‘3DY 0HR’
                         * 
                         * @param numDays
                         */
                        public void setNumDays(String numDays) {
                            this.numDays = numDays;
                        }

                        /** 
                         * Get the 'numHours' attribute value. Number of hours of rental – ‘3DY 0HR’
                         * 
                         * @return value
                         */
                        public String getNumHours() {
                            return numHours;
                        }

                        /** 
                         * Set the 'numHours' attribute value. Number of hours of rental – ‘3DY 0HR’
                         * 
                         * @param numHours
                         */
                        public void setNumHours(String numHours) {
                            this.numHours = numHours;
                        }

                        /** 
                         * Get the 'rateType' attribute value. Specifies rate code as defined by the product / service provider
                         * 
                         * @return value
                         */
                        public String getRateType() {
                            return rateType;
                        }

                        /** 
                         * Set the 'rateType' attribute value. Specifies rate code as defined by the product / service provider
                         * 
                         * @param rateType
                         */
                        public void setRateType(String rateType) {
                            this.rateType = rateType;
                        }

                        /** 
                         * Get the 'totalMandatoryCharges' attribute value. Mandatory Charges – Taxes + Fees + etc… - ‘123.11MC’
                         * 
                         * @return value
                         */
                        public String getTotalMandatoryCharges() {
                            return totalMandatoryCharges;
                        }

                        /** 
                         * Set the 'totalMandatoryCharges' attribute value. Mandatory Charges – Taxes + Fees + etc… - ‘123.11MC’
                         * 
                         * @param totalMandatoryCharges
                         */
                        public void setTotalMandatoryCharges(
                                String totalMandatoryCharges) {
                            this.totalMandatoryCharges = totalMandatoryCharges;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="percent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private String amount;
                    private String percent;

                    /** 
                     * Get the 'amount' attribute value. "amount" is used to return the commission amount if applicable.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'amount' attribute value. "amount" is used to return the commission amount if applicable.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'percent' attribute value. "percent" is used to return the commission percentage if applicable.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'percent' attribute value. "percent" is used to return the commission percentage if applicable.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Mileage" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="currencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="extraMileageCharge"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="unitOfMeasure"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Mileage implements Serializable
                {
                    private String currencyCode;
                    private String extraMileageCharge;
                    private String unitOfMeasure;

                    /** 
                     * Get the 'currencyCode' attribute value. "currencyCode" is used to return the currency code associated with mileage charges.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value. "currencyCode" is used to return the currency code associated with mileage charges.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'extraMileageCharge' attribute value. "extraMileageCharge" is used to return extra mileage charge-related information.
                     * 
                     * @return value
                     */
                    public String getExtraMileageCharge() {
                        return extraMileageCharge;
                    }

                    /** 
                     * Set the 'extraMileageCharge' attribute value. "extraMileageCharge" is used to return extra mileage charge-related information.
                     * 
                     * @param extraMileageCharge
                     */
                    public void setExtraMileageCharge(String extraMileageCharge) {
                        this.extraMileageCharge = extraMileageCharge;
                    }

                    /** 
                     * Get the 'unitOfMeasure' attribute value. "unitOfMeasure" is used to return the unit of measurement, i.e. miles or kilometers.
                     * 
                     * @return value
                     */
                    public String getUnitOfMeasure() {
                        return unitOfMeasure;
                    }

                    /** 
                     * Set the 'unitOfMeasure' attribute value. "unitOfMeasure" is used to return the unit of measurement, i.e. miles or kilometers.
                     * 
                     * @param unitOfMeasure
                     */
                    public void setUnitOfMeasure(String unitOfMeasure) {
                        this.unitOfMeasure = unitOfMeasure;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcessRate" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="currencyCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ExcessRate implements Serializable
                {
                    private String amount;
                    private String currencyCode;

                    /** 
                     * Get the 'amount' attribute value. "amount" is used to return excess rate amount.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'amount' attribute value. "amount" is used to return excess rate amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value. "currencyCode" is used to return the currency code associated with excess rate charges.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value. "currencyCode" is used to return the currency code associated with excess rate charges.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="code"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="companyShortName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Vendor implements Serializable
        {
            private String code;
            private String companyShortName;

            /** 
             * Get the 'code' attribute value. "code" is used to return the vehicle vendor code.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'code' attribute value. "code" is used to return the vehicle vendor code.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'companyShortName' attribute value. "companyShortName" is used to return the company name associated with the particular vehicle vendor code.
             * 
             * @return value
             */
            public String getCompanyShortName() {
                return companyShortName;
            }

            /** 
             * Set the 'companyShortName' attribute value. "companyShortName" is used to return the company name associated with the particular vehicle vendor code.
             * 
             * @param companyShortName
             */
            public void setCompanyShortName(String companyShortName) {
                this.companyShortName = companyShortName;
            }
        }
    }
}
