
package com.sabre.services.res.tir.v310;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItineraryReadRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="MessagingDetails">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="SubjectAreas" minOccurs="0">
 *               &lt;!-- Reference to inner class SubjectAreas -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="UniqueID" minOccurs="0">
 *         &lt;!-- Reference to inner class UniqueID -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="EchoToken" minOccurs="0"/>
 *       &lt;xs:element name="ReturnOptions" minOccurs="0">
 *         &lt;!-- Reference to inner class ReturnOptions -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TravelItineraryReadRQ implements Serializable
{
    private SubjectAreas messagingDetails;
    private UniqueID uniqueID;
    private String echoToken;
    private ReturnOptions returnOptions;
    private java.util.Date timeStamp;
    private String version;

    /** 
     * Get the 'SubjectAreas' element value.
     * 
     * @return value
     */
    public SubjectAreas getMessagingDetails() {
        return messagingDetails;
    }

    /** 
     * Set the 'SubjectAreas' element value.
     * 
     * @param messagingDetails
     */
    public void setMessagingDetails(SubjectAreas messagingDetails) {
        this.messagingDetails = messagingDetails;
    }

    /** 
     * Get the 'UniqueID' element value.
     * 
     * @return value
     */
    public UniqueID getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' element value.
     * 
     * @param uniqueID
     */
    public void setUniqueID(UniqueID uniqueID) {
        this.uniqueID = uniqueID;
    }

    /** 
     * Get the 'EchoToken' element value.
     * 
     * @return value
     */
    public String getEchoToken() {
        return echoToken;
    }

    /** 
     * Set the 'EchoToken' element value.
     * 
     * @param echoToken
     */
    public void setEchoToken(String echoToken) {
        this.echoToken = echoToken;
    }

    /** 
     * Get the 'ReturnOptions' element value.
     * 
     * @return value
     */
    public ReturnOptions getReturnOptions() {
        return returnOptions;
    }

    /** 
     * Set the 'ReturnOptions' element value.
     * 
     * @param returnOptions
     */
    public void setReturnOptions(ReturnOptions returnOptions) {
        this.returnOptions = returnOptions;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public java.util.Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(java.util.Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubjectAreas" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="SubjectArea" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SubjectAreas implements Serializable
    {
        private List<String> subjectAreaList = new ArrayList<String>();

        /** 
         * Get the list of 'SubjectArea' element items.
         * 
         * @return list
         */
        public List<String> getSubjectAreaList() {
            return subjectAreaList;
        }

        /** 
         * Set the list of 'SubjectArea' element items.
         * 
         * @param list
         */
        public void setSubjectAreaList(List<String> list) {
            subjectAreaList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="ID"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SnapshotId"/>
     *     &lt;xs:attribute type="xs:date" use="optional" name="CreateDate"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class UniqueID implements Serializable
    {
        private String ID;
        private String snapshotId;
        private Date createDate;

        /** 
         * Get the 'ID' attribute value.
         * 
         * @return value
         */
        public String getID() {
            return ID;
        }

        /** 
         * Set the 'ID' attribute value.
         * 
         * @param ID
         */
        public void setID(String ID) {
            this.ID = ID;
        }

        /** 
         * Get the 'SnapshotId' attribute value.
         * 
         * @return value
         */
        public String getSnapshotId() {
            return snapshotId;
        }

        /** 
         * Set the 'SnapshotId' attribute value.
         * 
         * @param snapshotId
         */
        public void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        /** 
         * Get the 'CreateDate' attribute value. Pnr creation date used for retrieve inactive pnr
         * 
         * @return value
         */
        public Date getCreateDate() {
            return createDate;
        }

        /** 
         * Set the 'CreateDate' attribute value. Pnr creation date used for retrieve inactive pnr
         * 
         * @param createDate
         */
        public void setCreateDate(Date createDate) {
            this.createDate = createDate;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReturnOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" default="false" name="UnmaskCreditCard"/>
     *     &lt;xs:attribute type="xs:boolean" default="false" name="ShowTicketStatus"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Language"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReturnOptions implements Serializable
    {
        private Boolean unmaskCreditCard;
        private Boolean showTicketStatus;
        private String language;

        /** 
         * Get the 'UnmaskCreditCard' attribute value.
         * 
         * @return value
         */
        public Boolean getUnmaskCreditCard() {
            return unmaskCreditCard;
        }

        /** 
         * Set the 'UnmaskCreditCard' attribute value.
         * 
         * @param unmaskCreditCard
         */
        public void setUnmaskCreditCard(Boolean unmaskCreditCard) {
            this.unmaskCreditCard = unmaskCreditCard;
        }

        /** 
         * Get the 'ShowTicketStatus' attribute value. "ShowTicketStatus" is for specifying whether user wants status for each ticket or not.
                               
         * 
         * @return value
         */
        public Boolean getShowTicketStatus() {
            return showTicketStatus;
        }

        /** 
         * Set the 'ShowTicketStatus' attribute value. "ShowTicketStatus" is for specifying whether user wants status for each ticket or not.
                               
         * 
         * @param showTicketStatus
         */
        public void setShowTicketStatus(Boolean showTicketStatus) {
            this.showTicketStatus = showTicketStatus;
        }

        /** 
         * Get the 'Language' attribute value. "Language" is used to translate attributes (like Cabin name).
        							
         * 
         * @return value
         */
        public String getLanguage() {
            return language;
        }

        /** 
         * Set the 'Language' attribute value. "Language" is used to translate attributes (like Cabin name).
        							
         * 
         * @param language
         */
        public void setLanguage(String language) {
            this.language = language;
        }
    }
}
