
package com.sabre.services.sp.air.ticket.v13;

import com.sabre.services.stlpayload.v0201.STLPayload1;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:ns1="http://services.sabre.com/STL_Payload/v02_01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTicketRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns1:STL_Payload">
 *         &lt;xs:sequence>
 *           &lt;xs:element name="DesignatePrinter" minOccurs="0">
 *             &lt;!-- Reference to inner class DesignatePrinter -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="Itinerary" minOccurs="1">
 *             &lt;xs:complexType>
 *               &lt;xs:attribute type="xs:string" use="required" name="ID"/>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *           &lt;xs:element name="AccountingLines" minOccurs="0">
 *             &lt;!-- Reference to inner class AccountingLines -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="Ticketing" minOccurs="1" maxOccurs="99">
 *             &lt;!-- Reference to inner class Ticketing -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="PostProcessing" minOccurs="0">
 *             &lt;!-- Reference to inner class PostProcessing -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:attribute type="xs:boolean" name="haltOnInvalidMCT"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="targetCity"/>
 *         &lt;xs:attribute type="xs:string" use="optional" default="false" name="healthCheck"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirTicketRQ extends STLPayload1 implements Serializable
{
    private DesignatePrinter designatePrinter;
    private String itinerary;
    private AccountingLines accountingLines;
    private List<Ticketing> ticketingList = new ArrayList<Ticketing>();
    private PostProcessing postProcessing;
    private Boolean haltOnInvalidMCT;
    private String targetCity;
    private String healthCheck;

    /** 
     * Get the 'DesignatePrinter' element value.
     * 
     * @return value
     */
    public DesignatePrinter getDesignatePrinter() {
        return designatePrinter;
    }

    /** 
     * Set the 'DesignatePrinter' element value.
     * 
     * @param designatePrinter
     */
    public void setDesignatePrinter(DesignatePrinter designatePrinter) {
        this.designatePrinter = designatePrinter;
    }

    /** 
     * Get the 'ID' attribute value. "ID" is used to specify a record locator.
     * 
     * @return value
     */
    public String getItinerary() {
        return itinerary;
    }

    /** 
     * Set the 'ID' attribute value. "ID" is used to specify a record locator.
     * 
     * @param itinerary
     */
    public void setItinerary(String itinerary) {
        this.itinerary = itinerary;
    }

    /** 
     * Get the 'AccountingLines' element value.
     * 
     * @return value
     */
    public AccountingLines getAccountingLines() {
        return accountingLines;
    }

    /** 
     * Set the 'AccountingLines' element value.
     * 
     * @param accountingLines
     */
    public void setAccountingLines(AccountingLines accountingLines) {
        this.accountingLines = accountingLines;
    }

    /** 
     * Get the list of 'Ticketing' element items.
     * 
     * @return list
     */
    public List<Ticketing> getTicketingList() {
        return ticketingList;
    }

    /** 
     * Set the list of 'Ticketing' element items.
     * 
     * @param list
     */
    public void setTicketingList(List<Ticketing> list) {
        ticketingList = list;
    }

    /** 
     * Get the 'PostProcessing' element value.
     * 
     * @return value
     */
    public PostProcessing getPostProcessing() {
        return postProcessing;
    }

    /** 
     * Set the 'PostProcessing' element value.
     * 
     * @param postProcessing
     */
    public void setPostProcessing(PostProcessing postProcessing) {
        this.postProcessing = postProcessing;
    }

    /** 
     * Get the 'haltOnInvalidMCT' attribute value. Used to specify whether the service should check and stop processing upon encountering an error indicating that minimum connection time between air itinerary segments is not met.
     * 
     * @return value
     */
    public Boolean getHaltOnInvalidMCT() {
        return haltOnInvalidMCT;
    }

    /** 
     * Set the 'haltOnInvalidMCT' attribute value. Used to specify whether the service should check and stop processing upon encountering an error indicating that minimum connection time between air itinerary segments is not met.
     * 
     * @param haltOnInvalidMCT
     */
    public void setHaltOnInvalidMCT(Boolean haltOnInvalidMCT) {
        this.haltOnInvalidMCT = haltOnInvalidMCT;
    }

    /** 
     * Get the 'targetCity' attribute value. "TargetCity" is used to specify to which city service should change context using ContextChange (AAA) and the rest of the service uses new security. If empty or equals current city the context doesn't change.
     * 
     * @return value
     */
    public String getTargetCity() {
        return targetCity;
    }

    /** 
     * Set the 'targetCity' attribute value. "TargetCity" is used to specify to which city service should change context using ContextChange (AAA) and the rest of the service uses new security. If empty or equals current city the context doesn't change.
     * 
     * @param targetCity
     */
    public void setTargetCity(String targetCity) {
        this.targetCity = targetCity;
    }

    /** 
     * Get the 'healthCheck' attribute value. Health Check.
     * 
     * @return value
     */
    public String getHealthCheck() {
        return healthCheck;
    }

    /** 
     * Set the 'healthCheck' attribute value. Health Check.
     * 
     * @param healthCheck
     */
    public void setHealthCheck(String healthCheck) {
        this.healthCheck = healthCheck;
    }
    /** 
     * Used to control printer designation process.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DesignatePrinter" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Printers" minOccurs="0">
     *         &lt;!-- Reference to inner class Printers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Profile" minOccurs="0">
     *         &lt;!-- Reference to inner class Profile -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DesignatePrinter implements Serializable
    {
        private Printers printers;
        private Profile profile;

        /** 
         * Get the 'Printers' element value.
         * 
         * @return value
         */
        public Printers getPrinters() {
            return printers;
        }

        /** 
         * Set the 'Printers' element value.
         * 
         * @param printers
         */
        public void setPrinters(Printers printers) {
            this.printers = printers;
        }

        /** 
         * Get the 'Profile' element value.
         * 
         * @return value
         */
        public Profile getProfile() {
            return profile;
        }

        /** 
         * Set the 'Profile' element value.
         * 
         * @param profile
         */
        public void setProfile(Profile profile) {
            this.profile = profile;
        }
        /** 
         * Used to designate printers.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Printers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BagTag" minOccurs="0">
         *         &lt;!-- Reference to inner class BagTag -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BoardingPass" minOccurs="0">
         *         &lt;!-- Reference to inner class BoardingPass -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Hardcopy" minOccurs="0">
         *         &lt;!-- Reference to inner class Hardcopy -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="InvoiceItinerary" minOccurs="0">
         *         &lt;!-- Reference to inner class InvoiceItinerary -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ListLabel" minOccurs="0">
         *         &lt;!-- Reference to inner class ListLabel -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MiniItinerary" minOccurs="0">
         *         &lt;!-- Reference to inner class MiniItinerary -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Report" minOccurs="0">
         *         &lt;!-- Reference to inner class Report -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Ticket" minOccurs="0">
         *         &lt;!-- Reference to inner class Ticket -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Printers implements Serializable
        {
            private BagTag bagTag;
            private BoardingPass boardingPass;
            private Hardcopy hardcopy;
            private InvoiceItinerary invoiceItinerary;
            private ListLabel listLabel;
            private MiniItinerary miniItinerary;
            private Report report;
            private Ticket ticket;

            /** 
             * Get the 'BagTag' element value.
             * 
             * @return value
             */
            public BagTag getBagTag() {
                return bagTag;
            }

            /** 
             * Set the 'BagTag' element value.
             * 
             * @param bagTag
             */
            public void setBagTag(BagTag bagTag) {
                this.bagTag = bagTag;
            }

            /** 
             * Get the 'BoardingPass' element value.
             * 
             * @return value
             */
            public BoardingPass getBoardingPass() {
                return boardingPass;
            }

            /** 
             * Set the 'BoardingPass' element value.
             * 
             * @param boardingPass
             */
            public void setBoardingPass(BoardingPass boardingPass) {
                this.boardingPass = boardingPass;
            }

            /** 
             * Get the 'Hardcopy' element value.
             * 
             * @return value
             */
            public Hardcopy getHardcopy() {
                return hardcopy;
            }

            /** 
             * Set the 'Hardcopy' element value.
             * 
             * @param hardcopy
             */
            public void setHardcopy(Hardcopy hardcopy) {
                this.hardcopy = hardcopy;
            }

            /** 
             * Get the 'InvoiceItinerary' element value.
             * 
             * @return value
             */
            public InvoiceItinerary getInvoiceItinerary() {
                return invoiceItinerary;
            }

            /** 
             * Set the 'InvoiceItinerary' element value.
             * 
             * @param invoiceItinerary
             */
            public void setInvoiceItinerary(InvoiceItinerary invoiceItinerary) {
                this.invoiceItinerary = invoiceItinerary;
            }

            /** 
             * Get the 'ListLabel' element value.
             * 
             * @return value
             */
            public ListLabel getListLabel() {
                return listLabel;
            }

            /** 
             * Set the 'ListLabel' element value.
             * 
             * @param listLabel
             */
            public void setListLabel(ListLabel listLabel) {
                this.listLabel = listLabel;
            }

            /** 
             * Get the 'MiniItinerary' element value.
             * 
             * @return value
             */
            public MiniItinerary getMiniItinerary() {
                return miniItinerary;
            }

            /** 
             * Set the 'MiniItinerary' element value.
             * 
             * @param miniItinerary
             */
            public void setMiniItinerary(MiniItinerary miniItinerary) {
                this.miniItinerary = miniItinerary;
            }

            /** 
             * Get the 'Report' element value.
             * 
             * @return value
             */
            public Report getReport() {
                return report;
            }

            /** 
             * Set the 'Report' element value.
             * 
             * @param report
             */
            public void setReport(Report report) {
                this.report = report;
            }

            /** 
             * Get the 'Ticket' element value.
             * 
             * @return value
             */
            public Ticket getTicket() {
                return ticket;
            }

            /** 
             * Set the 'Ticket' element value.
             * 
             * @param ticket
             */
            public void setTicket(Ticket ticket) {
                this.ticket = ticket;
            }
            /** 
             * Bag Tag printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagTag" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BagTag implements Serializable
            {
                private String LNIATA;

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify a bag tag printer address.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify a bag tag printer address.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
            /** 
             * Boarding Pass printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BoardingPass" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="HostedCarrier"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BoardingPass implements Serializable
            {
                private Boolean hostedCarrier;
                private String LNIATA;

                /** 
                 * Get the 'HostedCarrier' attribute value. "HostedCarrier" is used by airline customers to indicate that this request is for an airline-based boarding pass printer.
                 * 
                 * @return value
                 */
                public Boolean getHostedCarrier() {
                    return hostedCarrier;
                }

                /** 
                 * Set the 'HostedCarrier' attribute value. "HostedCarrier" is used by airline customers to indicate that this request is for an airline-based boarding pass printer.
                 * 
                 * @param hostedCarrier
                 */
                public void setHostedCarrier(Boolean hostedCarrier) {
                    this.hostedCarrier = hostedCarrier;
                }

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify a boarding pass printer address.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify a boarding pass printer address.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
            /** 
             * Hardcopy printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hardcopy" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute use="optional" name="Spacing">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Spacing -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Hardcopy implements Serializable
            {
                private Spacing spacing;
                private String LNIATA;

                /** 
                 * Get the 'Spacing' attribute value. "Spacing" is used to specify the spacing, either 1, or 2.
                 * 
                 * @return value
                 */
                public Spacing getSpacing() {
                    return spacing;
                }

                /** 
                 * Set the 'Spacing' attribute value. "Spacing" is used to specify the spacing, either 1, or 2.
                 * 
                 * @param spacing
                 */
                public void setSpacing(Spacing spacing) {
                    this.spacing = spacing;
                }

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify a hard copy printer address.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify a hard copy printer address.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="1"/>
                 *     &lt;xs:enumeration value="2"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Spacing implements Serializable {
                    _1("1"), _2("2");
                    private final String value;

                    private Spacing(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static Spacing convert(String value) {
                        for (Spacing inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
            /** 
             * Invoice/itinerary printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceItinerary" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class InvoiceItinerary implements Serializable
            {
                private String LNIATA;

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify an invoice/itinerary printer address.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify an invoice/itinerary printer address.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
            /** 
             * List/label printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListLabel" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ListLabel implements Serializable
            {
                private String LNIATA;

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify a list/label printer address.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify a list/label printer address.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
            /** 
             * Mini itinerary printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiniItinerary" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MiniItinerary implements Serializable
            {
                private String LNIATA;

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify a mini itinerary printer address.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify a mini itinerary printer address.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
            /** 
             * Report printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Report" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Report implements Serializable
            {
                private String LNIATA;

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify a report printer address. Please note that the user account attempting to designate to a report printer must be signed in under duty code 9.  To set duty code 9 the client application can utilize the ContextChangeLLSRQ service.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify a report printer address. Please note that the user account attempting to designate to a report printer must be signed in under duty code 9.  To set duty code 9 the client application can utilize the ContextChangeLLSRQ service.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
            /** 
             * Ticket printer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MiniItinerary" minOccurs="0">
             *         &lt;!-- Reference to inner class MiniItinerary -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Remote" minOccurs="0">
             *         &lt;!-- Reference to inner class Remote -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Ticket implements Serializable
            {
                private MiniItinerary miniItinerary;
                private Remote remote;
                private String countryCode;
                private String LNIATA;

                /** 
                 * Get the 'MiniItinerary' element value.
                 * 
                 * @return value
                 */
                public MiniItinerary getMiniItinerary() {
                    return miniItinerary;
                }

                /** 
                 * Set the 'MiniItinerary' element value.
                 * 
                 * @param miniItinerary
                 */
                public void setMiniItinerary(MiniItinerary miniItinerary) {
                    this.miniItinerary = miniItinerary;
                }

                /** 
                 * Get the 'Remote' element value.
                 * 
                 * @return value
                 */
                public Remote getRemote() {
                    return remote;
                }

                /** 
                 * Set the 'Remote' element value.
                 * 
                 * @param remote
                 */
                public void setRemote(Remote remote) {
                    this.remote = remote;
                }

                /** 
                 * Get the 'CountryCode' attribute value. Countery code.
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' attribute value. Countery code.
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }

                /** 
                 * Get the 'LNIATA' attribute value. "LNIATA" is used to specify a ticket printer address.
                															Clients should only associate 255 sessions to a single printer address. Additional sessions beyond the initial 255 need to be designated to a different printer address.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value. "LNIATA" is used to specify a ticket printer address.
                															Clients should only associate 255 sessions to a single printer address. Additional sessions beyond the initial 255 need to be designated to a different printer address.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
                /** 
                 * Used by ATB1, or ATB2 customers to also designate a mini itinerary printer at the same time they are designating their ticket printer.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiniItinerary" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MiniItinerary implements Serializable
                {
                    private String LNIATA;

                    /** 
                     * Get the 'LNIATA' attribute value. "LNIATA" is used by ATB1, or ATB2 customers to also designate a mini itinerary printer at the same time they are designating their ticket printer.
                     * 
                     * @return value
                     */
                    public String getLNIATA() {
                        return LNIATA;
                    }

                    /** 
                     * Set the 'LNIATA' attribute value. "LNIATA" is used by ATB1, or ATB2 customers to also designate a mini itinerary printer at the same time they are designating their ticket printer.
                     * 
                     * @param LNIATA
                     */
                    public void setLNIATA(String LNIATA) {
                        this.LNIATA = LNIATA;
                    }
                }
                /** 
                 * Used by customers to designate an ATB or ATB2 ticket printer along with a remote printer.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remote" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Remote implements Serializable
                {
                    private String LNIATA;

                    /** 
                     * Get the 'LNIATA' attribute value. "LNIATA" is used by customers to designate an ATB or ATB2 ticket printer along with a remote printer.
                     * 
                     * @return value
                     */
                    public String getLNIATA() {
                        return LNIATA;
                    }

                    /** 
                     * Set the 'LNIATA' attribute value. "LNIATA" is used by customers to designate an ATB or ATB2 ticket printer along with a remote printer.
                     * 
                     * @param LNIATA
                     */
                    public void setLNIATA(String LNIATA) {
                        this.LNIATA = LNIATA;
                    }
                }
            }
        }
        /** 
         * Used to pass printer profile information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profile" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Profile implements Serializable
        {
            private BigInteger number;

            /** 
             * Get the 'Number' attribute value. "Number" is used to specify a previously established printer number.
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value. "Number" is used to specify a previously established printer number.
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }
        }
    }
    /** 
     * Used to control accounting line deletion prior ticketing. As a default logic, the API will always attempt to delete all accounting lines prior ticketing. However, if you wish the system to behave differently you may request to delete specific accounting line numbers only ("Number", "EndNumber") or prevent the deletion altogether: ("None").
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingLines" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Delete" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Delete -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="All"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="None"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AccountingLines implements Serializable
    {
        private List<Delete> deleteList = new ArrayList<Delete>();
        private Boolean all;
        private Boolean none;

        /** 
         * Get the list of 'Delete' element items.
         * 
         * @return list
         */
        public List<Delete> getDeleteList() {
            return deleteList;
        }

        /** 
         * Set the list of 'Delete' element items.
         * 
         * @param list
         */
        public void setDeleteList(List<Delete> list) {
            deleteList = list;
        }

        /** 
         * Get the 'All' attribute value. "All" is used to delete all accounting lines, cannot combine with "None" attribute.
         * 
         * @return value
         */
        public Boolean getAll() {
            return all;
        }

        /** 
         * Set the 'All' attribute value. "All" is used to delete all accounting lines, cannot combine with "None" attribute.
         * 
         * @param all
         */
        public void setAll(Boolean all) {
            this.all = all;
        }

        /** 
         * Get the 'None' attribute value. "None" is used to indicate not to delete any of the accounting lines, cannot combine with "All" attribute.
         * 
         * @return value
         */
        public Boolean getNone() {
            return none;
        }

        /** 
         * Set the 'None' attribute value. "None" is used to indicate not to delete any of the accounting lines, cannot combine with "All" attribute.
         * 
         * @param none
         */
        public void setNone(Boolean none) {
            this.none = none;
        }
        /** 
         * Used to specify accounting line numbers to be deleted.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Delete" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Delete implements Serializable
        {
            private BigInteger endNumber;
            private BigInteger number;

            /** 
             * Get the 'EndNumber' attribute value. "EndNumber" when used with @Number to specify a range of accounting lines to delete.
             * 
             * @return value
             */
            public BigInteger getEndNumber() {
                return endNumber;
            }

            /** 
             * Set the 'EndNumber' attribute value. "EndNumber" when used with @Number to specify a range of accounting lines to delete.
             * 
             * @param endNumber
             */
            public void setEndNumber(BigInteger endNumber) {
                this.endNumber = endNumber;
            }

            /** 
             * Get the 'Number' attribute value. "Number" is used to specify particular accounting lines.
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value. "Number" is used to specify particular accounting lines.
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }
        }
    }
    /** 
     * Main element for the ticket issuance. Repeat the node as many times as many tickets/ ticket types/EMDs are to be issued.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="1" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FOP_Qualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class FOPQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiscQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PricingQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class PricingQualifiers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Ticketing implements Serializable
    {
        private FlightQualifiers flightQualifiers;
        private FOPQualifiers FOPQualifiers1;
        private MiscQualifiers miscQualifiers;
        private PricingQualifiers pricingQualifiers;

        /** 
         * Get the 'FlightQualifiers' element value.
         * 
         * @return value
         */
        public FlightQualifiers getFlightQualifiers() {
            return flightQualifiers;
        }

        /** 
         * Set the 'FlightQualifiers' element value.
         * 
         * @param flightQualifiers
         */
        public void setFlightQualifiers(FlightQualifiers flightQualifiers) {
            this.flightQualifiers = flightQualifiers;
        }

        /** 
         * Get the 'FOP_Qualifiers' element value.
         * 
         * @return value
         */
        public FOPQualifiers getFOPQualifiers1() {
            return FOPQualifiers1;
        }

        /** 
         * Set the 'FOP_Qualifiers' element value.
         * 
         * @param FOPQualifiers1
         */
        public void setFOPQualifiers1(FOPQualifiers FOPQualifiers1) {
            this.FOPQualifiers1 = FOPQualifiers1;
        }

        /** 
         * Get the 'MiscQualifiers' element value.
         * 
         * @return value
         */
        public MiscQualifiers getMiscQualifiers() {
            return miscQualifiers;
        }

        /** 
         * Set the 'MiscQualifiers' element value.
         * 
         * @param miscQualifiers
         */
        public void setMiscQualifiers(MiscQualifiers miscQualifiers) {
            this.miscQualifiers = miscQualifiers;
        }

        /** 
         * Get the 'PricingQualifiers' element value.
         * 
         * @return value
         */
        public PricingQualifiers getPricingQualifiers() {
            return pricingQualifiers;
        }

        /** 
         * Set the 'PricingQualifiers' element value.
         * 
         * @param pricingQualifiers
         */
        public void setPricingQualifiers(PricingQualifiers pricingQualifiers) {
            this.pricingQualifiers = pricingQualifiers;
        }
        /** 
         * Used to pass flight related qualifiers.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="VendorPrefs" minOccurs="0">
         *         &lt;!-- Reference to inner class VendorPrefs -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightQualifiers implements Serializable
        {
            private VendorPrefs vendorPrefs;

            /** 
             * Get the 'VendorPrefs' element value.
             * 
             * @return value
             */
            public VendorPrefs getVendorPrefs() {
                return vendorPrefs;
            }

            /** 
             * Set the 'VendorPrefs' element value.
             * 
             * @param vendorPrefs
             */
            public void setVendorPrefs(VendorPrefs vendorPrefs) {
                this.vendorPrefs = vendorPrefs;
            }
            /** 
             * Used to pass an airline code to issue tickets for - optional.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Airline">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class VendorPrefs implements Serializable
            {
                private String airline;

                /** 
                 * Get the 'Code' attribute value. "Code" is used to specify a particular vendor code.
                 * 
                 * @return value
                 */
                public String getAirline() {
                    return airline;
                }

                /** 
                 * Set the 'Code' attribute value. "Code" is used to specify a particular vendor code.
                 * 
                 * @param airline
                 */
                public void setAirline(String airline) {
                    this.airline = airline;
                }
            }
        }
        /** 
         * Used to pass form of payment related qualifiers.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Qualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BasicFOP" minOccurs="0">
         *         &lt;!-- Reference to inner class BasicFOP -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BSP_Ticketing" minOccurs="0">
         *         &lt;!-- Reference to inner class BSPTicketing -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MultipleCC_FOP" minOccurs="0">
         *         &lt;!-- Reference to inner class MultipleCCFOP -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SabreSonicTicketing" minOccurs="0">
         *         &lt;!-- Reference to inner class SabreSonicTicketing -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FOPQualifiers implements Serializable
        {
            private BasicFOP basicFOP;
            private BSPTicketing BSPTicketing1;
            private MultipleCCFOP multipleCCFOP;
            private SabreSonicTicketing sabreSonicTicketing;

            /** 
             * Get the 'BasicFOP' element value.
             * 
             * @return value
             */
            public BasicFOP getBasicFOP() {
                return basicFOP;
            }

            /** 
             * Set the 'BasicFOP' element value.
             * 
             * @param basicFOP
             */
            public void setBasicFOP(BasicFOP basicFOP) {
                this.basicFOP = basicFOP;
            }

            /** 
             * Get the 'BSP_Ticketing' element value.
             * 
             * @return value
             */
            public BSPTicketing getBSPTicketing1() {
                return BSPTicketing1;
            }

            /** 
             * Set the 'BSP_Ticketing' element value.
             * 
             * @param BSPTicketing1
             */
            public void setBSPTicketing1(BSPTicketing BSPTicketing1) {
                this.BSPTicketing1 = BSPTicketing1;
            }

            /** 
             * Get the 'MultipleCC_FOP' element value.
             * 
             * @return value
             */
            public MultipleCCFOP getMultipleCCFOP() {
                return multipleCCFOP;
            }

            /** 
             * Set the 'MultipleCC_FOP' element value.
             * 
             * @param multipleCCFOP
             */
            public void setMultipleCCFOP(MultipleCCFOP multipleCCFOP) {
                this.multipleCCFOP = multipleCCFOP;
            }

            /** 
             * Get the 'SabreSonicTicketing' element value.
             * 
             * @return value
             */
            public SabreSonicTicketing getSabreSonicTicketing() {
                return sabreSonicTicketing;
            }

            /** 
             * Set the 'SabreSonicTicketing' element value.
             * 
             * @param sabreSonicTicketing
             */
            public void setSabreSonicTicketing(
                    SabreSonicTicketing sabreSonicTicketing) {
                this.sabreSonicTicketing = sabreSonicTicketing;
            }
            /** 
             * BasicFOP cannot combine with .../BSP_Ticketing, or .../SabreSonicTicketing, or .../Multiple CC_FOP.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CC_Info" minOccurs="0">
             *         &lt;!-- Reference to inner class CCInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CostCenter"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Virtual"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BasicFOP implements Serializable
            {
                private CCInfo CCInfo1;
                private String costCenter;
                private BigInteger reference;
                private String type;
                private String virtual;

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo getCCInfo1() {
                    return CCInfo1;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCInfo1
                 */
                public void setCCInfo1(CCInfo CCInfo1) {
                    this.CCInfo1 = CCInfo1;
                }

                /** 
                 * Get the 'CostCenter' attribute value. "CostCenter" is used to pass cost center information. It cannot combine with @Reference and @Virtual.
                 * 
                 * @return value
                 */
                public String getCostCenter() {
                    return costCenter;
                }

                /** 
                 * Set the 'CostCenter' attribute value. "CostCenter" is used to pass cost center information. It cannot combine with @Reference and @Virtual.
                 * 
                 * @param costCenter
                 */
                public void setCostCenter(String costCenter) {
                    this.costCenter = costCenter;
                }

                /** 
                 * Get the 'Reference' attribute value. "Reference" is used to refer a line number from PNR Form of Payment (FOP) field. This capability is only available once the agency has activated Sabre's new FOP functionality in the corresponding PCC (TJR setting: PNAPNR), for additional information please contact your Sabre Account Team.
                 * 
                 * @return value
                 */
                public BigInteger getReference() {
                    return reference;
                }

                /** 
                 * Set the 'Reference' attribute value. "Reference" is used to refer a line number from PNR Form of Payment (FOP) field. This capability is only available once the agency has activated Sabre's new FOP functionality in the corresponding PCC (TJR setting: PNAPNR), for additional information please contact your Sabre Account Team.
                 * 
                 * @param reference
                 */
                public void setReference(BigInteger reference) {
                    this.reference = reference;
                }

                /** 
                 * Get the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque).  If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque).  If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'Virtual' attribute value. "Virtual" is used to pass virtual form of payment information.
                 * 
                 * @return value
                 */
                public String getVirtual() {
                    return virtual;
                }

                /** 
                 * Set the 'Virtual' attribute value. "Virtual" is used to pass virtual form of payment information.
                 * 
                 * @param virtual
                 */
                public void setVirtual(String virtual) {
                    this.virtual = virtual;
                }
                /** 
                 * Payment card details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardManualOBFee;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value. "Code" is used to specify a credit card vendor code.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value. "Code" is used to specify a credit card vendor code.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify a credit card expiration date, follows this format: YYYY-MM.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify a credit card expiration date, follows this format: YYYY-MM.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualOBFee() {
                        return paymentCardManualOBFee;
                    }

                    /** 
                     * Set the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card.
                     * 
                     * @param paymentCardManualOBFee
                     */
                    public void setPaymentCardManualOBFee(
                            String paymentCardManualOBFee) {
                        this.paymentCardManualOBFee = paymentCardManualOBFee;
                    }

                    /** 
                     * Get the 'Number' attribute value. "Number" is used to specify a credit card number.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value. "Number" is used to specify a credit card number.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
            }
            /** 
             * Valid for BSP-based clients.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSP_Ticketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultipleMiscFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleMiscFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PayLaterPlan" minOccurs="0">
             *         &lt;!-- Reference to inner class PayLaterPlan -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BSPTicketing implements Serializable
            {
                private MultipleFOP multipleFOP;
                private MultipleMiscFOP multipleMiscFOP;
                private PayLaterPlan payLaterPlan;

                /** 
                 * Get the 'MultipleFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleFOP getMultipleFOP() {
                    return multipleFOP;
                }

                /** 
                 * Set the 'MultipleFOP' element value.
                 * 
                 * @param multipleFOP
                 */
                public void setMultipleFOP(MultipleFOP multipleFOP) {
                    this.multipleFOP = multipleFOP;
                }

                /** 
                 * Get the 'MultipleMiscFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleMiscFOP getMultipleMiscFOP() {
                    return multipleMiscFOP;
                }

                /** 
                 * Set the 'MultipleMiscFOP' element value.
                 * 
                 * @param multipleMiscFOP
                 */
                public void setMultipleMiscFOP(MultipleMiscFOP multipleMiscFOP) {
                    this.multipleMiscFOP = multipleMiscFOP;
                }

                /** 
                 * Get the 'PayLaterPlan' element value.
                 * 
                 * @return value
                 */
                public PayLaterPlan getPayLaterPlan() {
                    return payLaterPlan;
                }

                /** 
                 * Set the 'PayLaterPlan' element value.
                 * 
                 * @param payLaterPlan
                 */
                public void setPayLaterPlan(PayLaterPlan payLaterPlan) {
                    this.payLaterPlan = payLaterPlan;
                }
                /** 
                 * MultipleFOP cannot combine with .../MultipleMiscFOP, or .../PayLaterPlan.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private BigInteger FOPOneReference;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private BigInteger FOPTwoReference;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to specify the amount to be applied to the second FOP.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to specify the amount to be applied to the second FOP.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value. First form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value. First form of payment.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPOneReference() {
                        return FOPOneReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @param FOPOneReference
                     */
                    public void setFOPOneReference(BigInteger FOPOneReference) {
                        this.FOPOneReference = FOPOneReference;
                    }

                    /** 
                     * Get the 'CC_Info' element value. Second form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value. Second form of payment.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPTwoReference() {
                        return FOPTwoReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @param FOPTwoReference
                     */
                    public void setFOPTwoReference(BigInteger FOPTwoReference) {
                        this.FOPTwoReference = FOPTwoReference;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardCardSecurityCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private String paymentCardManualOBFee;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the PRICE-MANUAL tag at the bottom of the *PQ
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualOBFee() {
                            return paymentCardManualOBFee;
                        }

                        /** 
                         * Set the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the PRICE-MANUAL tag at the bottom of the *PQ
                         * 
                         * @param paymentCardManualOBFee
                         */
                        public void setPaymentCardManualOBFee(
                                String paymentCardManualOBFee) {
                            this.paymentCardManualOBFee = paymentCardManualOBFee;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardCardSecurityCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private String paymentCardManualOBFee;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the PRICE-MANUAL tag at the bottom of the *PQ
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualOBFee() {
                            return paymentCardManualOBFee;
                        }

                        /** 
                         * Set the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the PRICE-MANUAL tag at the bottom of the *PQ
                         * 
                         * @param paymentCardManualOBFee
                         */
                        public void setPaymentCardManualOBFee(
                                String paymentCardManualOBFee) {
                            this.paymentCardManualOBFee = paymentCardManualOBFee;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Used to pass tax details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" maxOccurs="3">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private List<Tax> taxList = new ArrayList<Tax>();

                        /** 
                         * Get the list of 'Tax' element items.
                         * 
                         * @return list
                         */
                        public List<Tax> getTaxList() {
                            return taxList;
                        }

                        /** 
                         * Set the list of 'Tax' element items.
                         * 
                         * @param list
                         */
                        public void setTaxList(List<Tax> list) {
                            taxList = list;
                        }
                        /** 
                         * Individual tax details.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="3">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;
                            private String taxCode;

                            /** 
                             * Get the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                             * 
                             * @return value
                             */
                            public String getTaxCode() {
                                return taxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                             * 
                             * @param taxCode
                             */
                            public void setTaxCode(String taxCode) {
                                this.taxCode = taxCode;
                            }
                        }
                    }
                }
                /** 
                 * MultipleMiscFOP cannot combine with .../MultipleFOP, or .../PayLaterPlan.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleMiscFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="ExtendedPayment" minOccurs="0">
                 *               &lt;!-- Reference to inner class ExtendedPayment -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleMiscFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo1;
                    private String FOPOneType;
                    private BigInteger FOPOneReference;
                    private ExtendedPayment extendedPayment;
                    private String FOPTwoType;
                    private BigInteger FOPTwoReference;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to specify the fare amount to be applied to the second FOP.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to specify the fare amount to be applied to the second FOP.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value. First form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value. First form of payment.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPOneReference() {
                        return FOPOneReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @param FOPOneReference
                     */
                    public void setFOPOneReference(BigInteger FOPOneReference) {
                        this.FOPOneReference = FOPOneReference;
                    }

                    /** 
                     * Get the 'ExtendedPayment' element value. Second form of payment.
                     * 
                     * @return value
                     */
                    public ExtendedPayment getExtendedPayment() {
                        return extendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' element value. Second form of payment.
                     * 
                     * @param extendedPayment
                     */
                    public void setExtendedPayment(
                            ExtendedPayment extendedPayment) {
                        this.extendedPayment = extendedPayment;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the misc payment.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the misc payment.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPTwoReference() {
                        return FOPTwoReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @param FOPTwoReference
                     */
                    public void setFOPTwoReference(BigInteger FOPTwoReference) {
                        this.FOPTwoReference = FOPTwoReference;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Used to pass number of months for extended payment.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExtendedPayment" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="required" name="NumMonths"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ExtendedPayment implements Serializable
                    {
                        private BigInteger numMonths;

                        /** 
                         * Get the 'NumMonths' attribute value. Number of months.
                         * 
                         * @return value
                         */
                        public BigInteger getNumMonths() {
                            return numMonths;
                        }

                        /** 
                         * Set the 'NumMonths' attribute value. Number of months.
                         * 
                         * @param numMonths
                         */
                        public void setNumMonths(BigInteger numMonths) {
                            this.numMonths = numMonths;
                        }
                    }
                    /** 
                     * Used to pass tax details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" maxOccurs="2">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private List<Tax> taxList = new ArrayList<Tax>();

                        /** 
                         * Get the list of 'Tax' element items.
                         * 
                         * @return list
                         */
                        public List<Tax> getTaxList() {
                            return taxList;
                        }

                        /** 
                         * Set the list of 'Tax' element items.
                         * 
                         * @param list
                         */
                        public void setTaxList(List<Tax> list) {
                            taxList = list;
                        }
                        /** 
                         * Individual tax details.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="2">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;
                            private String taxCode;

                            /** 
                             * Get the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                             * 
                             * @return value
                             */
                            public String getTaxCode() {
                                return taxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                             * 
                             * @param taxCode
                             */
                            public void setTaxCode(String taxCode) {
                                this.taxCode = taxCode;
                            }
                        }
                    }
                }
                /** 
                 * "PayLaterPlan" is only applicable to Brazil, cannot combine with MultipleFOP, or MultipleMiscFOP.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayLaterPlan" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Installment">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Count"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="PayLaterReferenceNumber"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PayLaterPlan implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo1;
                    private String FOPType;
                    private BigInteger FOPReference;
                    private String installmentCount;
                    private String installmentPayLaterReferenceNumber;
                    private String installmentValue;

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to specify the remaining fare amount.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to specify the remaining fare amount.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value. First form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value. First form of payment.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @return value
                     */
                    public String getFOPType() {
                        return FOPType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @param FOPType
                     */
                    public void setFOPType(String FOPType) {
                        this.FOPType = FOPType;
                    }

                    /** 
                     * Get the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPReference() {
                        return FOPReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value. "Reference" is used to reference a line number from PNR FOP field.
                     * 
                     * @param FOPReference
                     */
                    public void setFOPReference(BigInteger FOPReference) {
                        this.FOPReference = FOPReference;
                    }

                    /** 
                     * Get the 'Count' attribute value. "Count" is used to specify the number of installments.
                     * 
                     * @return value
                     */
                    public String getInstallmentCount() {
                        return installmentCount;
                    }

                    /** 
                     * Set the 'Count' attribute value. "Count" is used to specify the number of installments.
                     * 
                     * @param installmentCount
                     */
                    public void setInstallmentCount(String installmentCount) {
                        this.installmentCount = installmentCount;
                    }

                    /** 
                     * Get the 'PayLaterReferenceNumber' attribute value. "PayLaterReferenceNumber" is used to specify the pay later reference number.
                     * 
                     * @return value
                     */
                    public String getInstallmentPayLaterReferenceNumber() {
                        return installmentPayLaterReferenceNumber;
                    }

                    /** 
                     * Set the 'PayLaterReferenceNumber' attribute value. "PayLaterReferenceNumber" is used to specify the pay later reference number.
                     * 
                     * @param installmentPayLaterReferenceNumber
                     */
                    public void setInstallmentPayLaterReferenceNumber(
                            String installmentPayLaterReferenceNumber) {
                        this.installmentPayLaterReferenceNumber = installmentPayLaterReferenceNumber;
                    }

                    /** 
                     * Get the 'Value' attribute value. "Value" is used to specify the value of the installments. Please note that decimals are not permitted.
                     * 
                     * @return value
                     */
                    public String getInstallmentValue() {
                        return installmentValue;
                    }

                    /** 
                     * Set the 'Value' attribute value. "Value" is used to specify the value of the installments. Please note that decimals are not permitted.
                     * 
                     * @param installmentValue
                     */
                    public void setInstallmentValue(String installmentValue) {
                        this.installmentValue = installmentValue;
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                }
            }
            /** 
             * Multiple CC_FOP cannot combine with .../BSP_Ticketing, or .../SabreSonicTicketing.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleCC_FOP" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Fare">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="CC_One">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="CC_Info" minOccurs="0">
             *               &lt;!-- Reference to inner class CCInfo -->
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="CC_Two">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="CC_Info" minOccurs="0">
             *               &lt;!-- Reference to inner class CCInfo1 -->
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MultipleCCFOP implements Serializable
            {
                private String fare;
                private CCInfo CCOne;
                private CCInfo1 CCTwo;

                /** 
                 * Get the 'Amount' attribute value. "Amount" is used to specify the amount to be applied to the second CC.
                 * 
                 * @return value
                 */
                public String getFare() {
                    return fare;
                }

                /** 
                 * Set the 'Amount' attribute value. "Amount" is used to specify the amount to be applied to the second CC.
                 * 
                 * @param fare
                 */
                public void setFare(String fare) {
                    this.fare = fare;
                }

                /** 
                 * Get the 'CC_Info' element value. First Payment Card details.
                 * 
                 * @return value
                 */
                public CCInfo getCCOne() {
                    return CCOne;
                }

                /** 
                 * Set the 'CC_Info' element value. First Payment Card details.
                 * 
                 * @param CCOne
                 */
                public void setCCOne(CCInfo CCOne) {
                    this.CCOne = CCOne;
                }

                /** 
                 * Get the 'CC_Info' element value. Second Payment Card details.
                 * 
                 * @return value
                 */
                public CCInfo1 getCCTwo() {
                    return CCTwo;
                }

                /** 
                 * Set the 'CC_Info' element value. Second Payment Card details.
                 * 
                 * @param CCTwo
                 */
                public void setCCTwo(CCInfo1 CCTwo) {
                    this.CCTwo = CCTwo;
                }
                /** 
                 * Payment card details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                 *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardManualOBFee;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card if applicable.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card if applicable.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the PRICE-MANUAL tag at the bottom of the *PQ
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualOBFee() {
                        return paymentCardManualOBFee;
                    }

                    /** 
                     * Set the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the PRICE-MANUAL tag at the bottom of the *PQ
                     * 
                     * @param paymentCardManualOBFee
                     */
                    public void setPaymentCardManualOBFee(
                            String paymentCardManualOBFee) {
                        this.paymentCardManualOBFee = paymentCardManualOBFee;
                    }

                    /** 
                     * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
                /** 
                 * Payment card details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                 *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo1 implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardManualOBFee;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card Card Security Code number.
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card if applicable.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card if applicable.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the 'PRICE-MANUAL' tag at the bottom of the *PQ
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualOBFee() {
                        return paymentCardManualOBFee;
                    }

                    /** 
                     * Set the 'ManualOBFee' attribute value. "ManualOBFee" is used to indicate that the manual OB fee should be associated to the card. A manual OB fee can ONLY be added to a ticketing entry that references a PQ that has the 'PRICE-MANUAL' tag at the bottom of the *PQ
                     * 
                     * @param paymentCardManualOBFee
                     */
                    public void setPaymentCardManualOBFee(
                            String paymentCardManualOBFee) {
                        this.paymentCardManualOBFee = paymentCardManualOBFee;
                    }

                    /** 
                     * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
            }
            /** 
             * "SabreSonicTicketing" is only valid for SabreSonic-based airlines, cannot combine with .../BSP_Ticketing, or .../Multiple CC_FOP.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreSonicTicketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BasicFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class BasicFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EnhancedMultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class EnhancedMultipleFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleFOP -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SabreSonicTicketing implements Serializable
            {
                private BasicFOP basicFOP;
                private EnhancedMultipleFOP enhancedMultipleFOP;
                private MultipleFOP multipleFOP;

                /** 
                 * Get the 'BasicFOP' element value.
                 * 
                 * @return value
                 */
                public BasicFOP getBasicFOP() {
                    return basicFOP;
                }

                /** 
                 * Set the 'BasicFOP' element value.
                 * 
                 * @param basicFOP
                 */
                public void setBasicFOP(BasicFOP basicFOP) {
                    this.basicFOP = basicFOP;
                }

                /** 
                 * Get the 'EnhancedMultipleFOP' element value.
                 * 
                 * @return value
                 */
                public EnhancedMultipleFOP getEnhancedMultipleFOP() {
                    return enhancedMultipleFOP;
                }

                /** 
                 * Set the 'EnhancedMultipleFOP' element value.
                 * 
                 * @param enhancedMultipleFOP
                 */
                public void setEnhancedMultipleFOP(
                        EnhancedMultipleFOP enhancedMultipleFOP) {
                    this.enhancedMultipleFOP = enhancedMultipleFOP;
                }

                /** 
                 * Get the 'MultipleFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleFOP getMultipleFOP() {
                    return multipleFOP;
                }

                /** 
                 * Set the 'MultipleFOP' element value.
                 * 
                 * @param multipleFOP
                 */
                public void setMultipleFOP(MultipleFOP multipleFOP) {
                    this.multipleFOP = multipleFOP;
                }
                /** 
                 * BasicFOP cannot combine with .../EnhancedMultipleFOP, or .../MultipleFOP.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CC_Info" minOccurs="0">
                 *         &lt;!-- Reference to inner class CCInfo -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BasicFOP implements Serializable
                {
                    private CCInfo CCInfo1;
                    private String manualApprovalCode;
                    private String type;

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual approval code for non-credit card forms of payment.
                     * 
                     * @return value
                     */
                    public String getManualApprovalCode() {
                        return manualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual approval code for non-credit card forms of payment.
                     * 
                     * @param manualApprovalCode
                     */
                    public void setManualApprovalCode(String manualApprovalCode) {
                        this.manualApprovalCode = manualApprovalCode;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque) "PT", "PTACA" (PTA cash), "PTAGTCK" (PTA agency check) or "PTCK" (PTA check).  If utilizing a credit card please omit @Type, and populate the .../CC_Info child node, unless needing to specify a PTA credit card form of payment.  For a PTA credit card form of payment the client should pass Type="PT" and populate the .../CC_Info child node with the relevant credit card information.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque) "PT", "PTACA" (PTA cash), "PTAGTCK" (PTA agency check) or "PTCK" (PTA check).  If utilizing a credit card please omit @Type, and populate the .../CC_Info child node, unless needing to specify a PTA credit card form of payment.  For a PTA credit card form of payment the client should pass Type="PT" and populate the .../CC_Info child node with the relevant credit card information.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private BigInteger paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card security code.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card security code.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                BigInteger paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify a credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify a credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify a credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify a credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify a credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify a credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value. "Suppress" is used to specify whether or not to suppress credit card information on an itinerary.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                }
                /** 
                 * EnhancedMultipleFOP is only valid for SabreSonic-based airlines who have activated  the enhanced multiple form of payment option, cannot combine with .../MultipleFOP.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnhancedMultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="Tax">
                 *               &lt;xs:complexType>
                 *                 &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *                 &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                 *               &lt;/xs:complexType>
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EnhancedMultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private String taxesTaxAmount;
                    private String taxesTaxTaxCode;

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to specify the fare amount to be applied to the second FOP.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to specify the fare amount to be applied to the second FOP.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value. First form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value. First form of payment.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'CC_Info' element value. Second form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value. Second form of payment.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type. Acceptable values are "CA", "CK" or "CQ". If utilizing a credit card please omit @Type, and populate the .../CC_Info child node.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                     * 
                     * @return value
                     */
                    public String getTaxesTaxAmount() {
                        return taxesTaxAmount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                     * 
                     * @param taxesTaxAmount
                     */
                    public void setTaxesTaxAmount(String taxesTaxAmount) {
                        this.taxesTaxAmount = taxesTaxAmount;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                     * 
                     * @return value
                     */
                    public String getTaxesTaxTaxCode() {
                        return taxesTaxTaxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                     * 
                     * @param taxesTaxTaxCode
                     */
                    public void setTaxesTaxTaxCode(String taxesTaxTaxCode) {
                        this.taxesTaxTaxCode = taxesTaxTaxCode;
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card security code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card security code.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card security code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value. "CardSecurityCode" is used to specify a credit card security code.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value. "ExpireDate" is used to specify the credit card expiration date, follows this format: YYYY-MM.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value. "ExtendedPayment" is used to specify extended payment if applicable.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                }
                /** 
                 * MultipleFOP cannot combine with .../EnhancedMultipleFOP.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to specify the fare amount to be applied to the second FOP.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to specify the fare amount to be applied to the second FOP.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value. First form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value. First form of payment.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque) "PT", "PTACA" (PTA cash), "PTAGTCK" (PTA agency check) or "PTCK" (PTA check).  If utilizing a credit card please omit @Type, and populate the .../CC_Info child node, unless needing to specify a PTA credit card form of payment.  For a PTA credit card form of payment the client should pass Type="PT" and populate the .../CC_Info child node with the relevant credit card information.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA" (cash), "CK" (check), "CQ" (cheque) "PT", "PTACA" (PTA cash), "PTAGTCK" (PTA agency check) or "PTCK" (PTA check).  If utilizing a credit card please omit @Type, and populate the .../CC_Info child node, unless needing to specify a PTA credit card form of payment.  For a PTA credit card form of payment the client should pass Type="PT" and populate the .../CC_Info child node with the relevant credit card information.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'CC_Info' element value. Second form of payment.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value. Second form of payment.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ".  If utilizing a credit card please omit @Type, and populate the .../CCInfo child node.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value. "Type" is used to specify the payment type.  Acceptable values are "CA", "CK" or "CQ".  If utilizing a credit card please omit @Type, and populate the .../CCInfo child node.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Payment card details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the credit card vendor code.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value. "ManualApprovalCode" is used to specify a manual credit card approval code if applicable.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify the credit card number.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Used to pass tax details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private String taxAmount;
                        private String taxTaxCode;

                        /** 
                         * Get the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                         * 
                         * @return value
                         */
                        public String getTaxAmount() {
                            return taxAmount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. "Amount" is used to specify the tax amount.
                         * 
                         * @param taxAmount
                         */
                        public void setTaxAmount(String taxAmount) {
                            this.taxAmount = taxAmount;
                        }

                        /** 
                         * Get the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                         * 
                         * @return value
                         */
                        public String getTaxTaxCode() {
                            return taxTaxCode;
                        }

                        /** 
                         * Set the 'TaxCode' attribute value. "TaxCode" is used to specify the tax code.
                         * 
                         * @param taxTaxCode
                         */
                        public void setTaxTaxCode(String taxTaxCode) {
                            this.taxTaxCode = taxTaxCode;
                        }
                    }
                }
            }
        }
        /** 
         * Used to pass miscelleaneous qualifiers.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirExtras" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class AirExtras -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BaggageAllowance" minOccurs="0">
         *         &lt;!-- Reference to inner class BaggageAllowance -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Certificate" minOccurs="0" maxOccurs="2">
         *         &lt;!-- Reference to inner class Certificate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Discount" minOccurs="0">
         *         &lt;!-- Reference to inner class Discount -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="DateOfBirth" minOccurs="0"/>
         *       &lt;xs:element name="Endorsement" minOccurs="0">
         *         &lt;!-- Reference to inner class Endorsement -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FutureTicket" minOccurs="0">
         *         &lt;!-- Reference to inner class FutureTicket -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Invoice" minOccurs="0">
         *         &lt;!-- Reference to inner class Invoice -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MISF" minOccurs="0">
         *         &lt;!-- Reference to inner class MISF -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NeedPrint" minOccurs="0">
         *         &lt;!-- Reference to inner class NeedPrint -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetRemit" minOccurs="0">
         *         &lt;!-- Reference to inner class NetRemit -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Ticket" minOccurs="0">
         *         &lt;!-- Reference to inner class Ticket -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TourCode" minOccurs="0">
         *         &lt;!-- Reference to inner class TourCode -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiscQualifiers implements Serializable
        {
            private List<AirExtras> airExtraList = new ArrayList<AirExtras>();
            private BaggageAllowance baggageAllowance;
            private List<Certificate> certificateList = new ArrayList<Certificate>();
            private Commission commission;
            private Discount discount;
            private String dateOfBirth;
            private Endorsement endorsement;
            private FutureTicket futureTicket;
            private Invoice invoice;
            private MISF MISF1;
            private NeedPrint needPrint;
            private NetRemit netRemit;
            private Ticket ticket;
            private TourCode tourCode;

            /** 
             * Get the list of 'AirExtras' element items.
             * 
             * @return list
             */
            public List<AirExtras> getAirExtraList() {
                return airExtraList;
            }

            /** 
             * Set the list of 'AirExtras' element items.
             * 
             * @param list
             */
            public void setAirExtraList(List<AirExtras> list) {
                airExtraList = list;
            }

            /** 
             * Get the 'BaggageAllowance' element value.
             * 
             * @return value
             */
            public BaggageAllowance getBaggageAllowance() {
                return baggageAllowance;
            }

            /** 
             * Set the 'BaggageAllowance' element value.
             * 
             * @param baggageAllowance
             */
            public void setBaggageAllowance(BaggageAllowance baggageAllowance) {
                this.baggageAllowance = baggageAllowance;
            }

            /** 
             * Get the list of 'Certificate' element items.
             * 
             * @return list
             */
            public List<Certificate> getCertificateList() {
                return certificateList;
            }

            /** 
             * Set the list of 'Certificate' element items.
             * 
             * @param list
             */
            public void setCertificateList(List<Certificate> list) {
                certificateList = list;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the 'Discount' element value.
             * 
             * @return value
             */
            public Discount getDiscount() {
                return discount;
            }

            /** 
             * Set the 'Discount' element value.
             * 
             * @param discount
             */
            public void setDiscount(Discount discount) {
                this.discount = discount;
            }

            /** 
             * Get the 'DateOfBirth' element value. "DOB" is used to instruct the system to take the passenger's date of birth-related information from the SSR PNR field, and pass it into the host-based ticketing application. This is required for clients based in the Russian Federation.
             * 
             * @return value
             */
            public String getDateOfBirth() {
                return dateOfBirth;
            }

            /** 
             * Set the 'DateOfBirth' element value. "DOB" is used to instruct the system to take the passenger's date of birth-related information from the SSR PNR field, and pass it into the host-based ticketing application. This is required for clients based in the Russian Federation.
             * 
             * @param dateOfBirth
             */
            public void setDateOfBirth(String dateOfBirth) {
                this.dateOfBirth = dateOfBirth;
            }

            /** 
             * Get the 'Endorsement' element value.
             * 
             * @return value
             */
            public Endorsement getEndorsement() {
                return endorsement;
            }

            /** 
             * Set the 'Endorsement' element value.
             * 
             * @param endorsement
             */
            public void setEndorsement(Endorsement endorsement) {
                this.endorsement = endorsement;
            }

            /** 
             * Get the 'FutureTicket' element value.
             * 
             * @return value
             */
            public FutureTicket getFutureTicket() {
                return futureTicket;
            }

            /** 
             * Set the 'FutureTicket' element value.
             * 
             * @param futureTicket
             */
            public void setFutureTicket(FutureTicket futureTicket) {
                this.futureTicket = futureTicket;
            }

            /** 
             * Get the 'Invoice' element value.
             * 
             * @return value
             */
            public Invoice getInvoice() {
                return invoice;
            }

            /** 
             * Set the 'Invoice' element value.
             * 
             * @param invoice
             */
            public void setInvoice(Invoice invoice) {
                this.invoice = invoice;
            }

            /** 
             * Get the 'MISF' element value.
             * 
             * @return value
             */
            public MISF getMISF1() {
                return MISF1;
            }

            /** 
             * Set the 'MISF' element value.
             * 
             * @param MISF1
             */
            public void setMISF1(MISF MISF1) {
                this.MISF1 = MISF1;
            }

            /** 
             * Get the 'NeedPrint' element value.
             * 
             * @return value
             */
            public NeedPrint getNeedPrint() {
                return needPrint;
            }

            /** 
             * Set the 'NeedPrint' element value.
             * 
             * @param needPrint
             */
            public void setNeedPrint(NeedPrint needPrint) {
                this.needPrint = needPrint;
            }

            /** 
             * Get the 'NetRemit' element value.
             * 
             * @return value
             */
            public NetRemit getNetRemit() {
                return netRemit;
            }

            /** 
             * Set the 'NetRemit' element value.
             * 
             * @param netRemit
             */
            public void setNetRemit(NetRemit netRemit) {
                this.netRemit = netRemit;
            }

            /** 
             * Get the 'Ticket' element value.
             * 
             * @return value
             */
            public Ticket getTicket() {
                return ticket;
            }

            /** 
             * Set the 'Ticket' element value.
             * 
             * @param ticket
             */
            public void setTicket(Ticket ticket) {
                this.ticket = ticket;
            }

            /** 
             * Get the 'TourCode' element value.
             * 
             * @return value
             */
            public TourCode getTourCode() {
                return tourCode;
            }

            /** 
             * Set the 'TourCode' element value.
             * 
             * @param tourCode
             */
            public void setTourCode(TourCode tourCode) {
                this.tourCode = tourCode;
            }
            /** 
             * Used to specify EMD numbers to be issued.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirExtras" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirExtras implements Serializable
            {
                private BigInteger endNumber;
                private BigInteger number;

                /** 
                 * Get the 'EndNumber' attribute value. "EndNumber" is used to specify the final EMD number when specifying a range.
                 * 
                 * @return value
                 */
                public BigInteger getEndNumber() {
                    return endNumber;
                }

                /** 
                 * Set the 'EndNumber' attribute value. "EndNumber" is used to specify the final EMD number when specifying a range.
                 * 
                 * @param endNumber
                 */
                public void setEndNumber(BigInteger endNumber) {
                    this.endNumber = endNumber;
                }

                /** 
                 * Get the 'Number' attribute value. "Number" is used to specify and EMD number.
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. "Number" is used to specify and EMD number.
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
            }
            /** 
             * Cannot combine with PhaseIV.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SegmentSelect">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
             *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Weight"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private BigInteger segmentSelectEndNumber;
                private BigInteger segmentSelectNumber;
                private String number;
                private String weight;

                /** 
                 * Get the 'EndNumber' attribute value. "EndNumber" is used to identify end of range for specified itinerary segments.
                 * 
                 * @return value
                 */
                public BigInteger getSegmentSelectEndNumber() {
                    return segmentSelectEndNumber;
                }

                /** 
                 * Set the 'EndNumber' attribute value. "EndNumber" is used to identify end of range for specified itinerary segments.
                 * 
                 * @param segmentSelectEndNumber
                 */
                public void setSegmentSelectEndNumber(
                        BigInteger segmentSelectEndNumber) {
                    this.segmentSelectEndNumber = segmentSelectEndNumber;
                }

                /** 
                 * Get the 'Number' attribute value. "Number" is used to instruct the system to price specified itinerary segments.
                 * 
                 * @return value
                 */
                public BigInteger getSegmentSelectNumber() {
                    return segmentSelectNumber;
                }

                /** 
                 * Set the 'Number' attribute value. "Number" is used to instruct the system to price specified itinerary segments.
                 * 
                 * @param segmentSelectNumber
                 */
                public void setSegmentSelectNumber(
                        BigInteger segmentSelectNumber) {
                    this.segmentSelectNumber = segmentSelectNumber;
                }

                /** 
                 * Get the 'Number' attribute value. "Number" is used to specify the quantity of checked bags if applicable.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. "Number" is used to specify the quantity of checked bags if applicable.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'Weight' attribute value. "Weight" is used to specify the weight in kilos of checked bags if applicable.
                 * 
                 * @return value
                 */
                public String getWeight() {
                    return weight;
                }

                /** 
                 * Set the 'Weight' attribute value. "Weight" is used to specify the weight in kilos of checked bags if applicable.
                 * 
                 * @param weight
                 */
                public void setWeight(String weight) {
                    this.weight = weight;
                }
            }
            /** 
             * Used to pss certificate numbers.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Certificate" minOccurs="0" maxOccurs="2">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Certificate implements Serializable
            {
                private String number;

                /** 
                 * Get the 'Number' attribute value. "Number" is used to specify a ticket number. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. "Number" is used to specify a ticket number. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }
            }
            /** 
             * Used to pass details of the commission being claimed.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Net"/>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="Percent"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private BigDecimal amount;
                private Boolean net;
                private BigDecimal percent;

                /** 
                 * Get the 'Amount' attribute value. "Amount" is used to specify the numeric amount of commission being claimed if applicable.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. "Amount" is used to specify the numeric amount of commission being claimed if applicable.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Net' attribute value. "Net" is used to claim commission on the Net Fare. It must be combined with @Percent.
                 * 
                 * @return value
                 */
                public Boolean getNet() {
                    return net;
                }

                /** 
                 * Set the 'Net' attribute value. "Net" is used to claim commission on the Net Fare. It must be combined with @Percent.
                 * 
                 * @param net
                 */
                public void setNet(Boolean net) {
                    this.net = net;
                }

                /** 
                 * Get the 'Percent' attribute value. "Percent" is used to specify the percentage of commission being claimed if applicable.
                 * 
                 * @return value
                 */
                public BigDecimal getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' attribute value. "Percent" is used to specify the percentage of commission being claimed if applicable.
                 * 
                 * @param percent
                 */
                public void setPercent(BigDecimal percent) {
                    this.percent = percent;
                }
            }
            /** 
             * "Discount" is used to specify the discount.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Discount implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value. "Code" is used to specify an 8 digit discount approval code.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. "Code" is used to specify an 8 digit discount approval code.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Used to pass miscellaneous text in the endorsements field.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsement" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Override"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Endorsement implements Serializable
            {
                private String text;
                private Boolean override;

                /** 
                 * Get the 'Text' element value. "Text" is used to pass miscellaneous text in the endorsements field.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. "Text" is used to pass miscellaneous text in the endorsements field.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Override' attribute value. Used to override existing endorsement.
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'Override' attribute value. Used to override existing endorsement.
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }
            }
            /** 
             * Used to issue tickets from specific FP lines.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FutureTicket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Line" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Line -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FutureTicket implements Serializable
            {
                private List<Line> lineList = new ArrayList<Line>();

                /** 
                 * Get the list of 'Line' element items.
                 * 
                 * @return list
                 */
                public List<Line> getLineList() {
                    return lineList;
                }

                /** 
                 * Set the list of 'Line' element items.
                 * 
                 * @param list
                 */
                public void setLineList(List<Line> list) {
                    lineList = list;
                }
                /** 
                 * "Line" and its associated attributes are used to issue tickets from specific FP lines.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Line implements Serializable
                {
                    private BigInteger endNumber;
                    private String nameNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value. End number in range.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value. End number in range.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Name number.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Name number.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value. Line number.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Line number.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * "Invoice" is used to specify to print invoice at time of ticketing. Both parameters will print a passenger electronic ticketing receipt as well as an invoice.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ETReceipt"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Invoice implements Serializable
            {
                private Boolean ind;
                private Boolean ETReceipt;

                /** 
                 * Get the 'Ind' attribute value. Used to print invoice.
                 * 
                 * @return value
                 */
                public Boolean getInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Used to print invoice.
                 * 
                 * @param ind
                 */
                public void setInd(Boolean ind) {
                    this.ind = ind;
                }

                /** 
                 * Get the 'ETReceipt' attribute value. "ETReceipt" is used to print a passenger electronic ticketing receipt at time of ticketing.
                 * 
                 * @return value
                 */
                public Boolean getETReceipt() {
                    return ETReceipt;
                }

                /** 
                 * Set the 'ETReceipt' attribute value. "ETReceipt" is used to print a passenger electronic ticketing receipt at time of ticketing.
                 * 
                 * @param ETReceipt
                 */
                public void setETReceipt(Boolean ETReceipt) {
                    this.ETReceipt = ETReceipt;
                }
            }
            /** 
             * "MISF" is used to issue a paperless service fee request, using the service fee amount stored in the TJR. You can combine this attribute with form of payment details .../OptionalQualifiers/FOP_Qualifiers/BasicFOP.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MISF" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Override" minOccurs="0">
             *         &lt;!-- Reference to inner class Override -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MISF implements Serializable
            {
                private Override override;
                private Boolean ind;

                /** 
                 * Get the 'Override' element value.
                 * 
                 * @return value
                 */
                public Override getOverride() {
                    return override;
                }

                /** 
                 * Set the 'Override' element value.
                 * 
                 * @param override
                 */
                public void setOverride(Override override) {
                    this.override = override;
                }

                /** 
                 * Get the 'Ind' attribute value. "Ind" is used to issue a paperless service fee request, using the service fee amount stored in the TJR. You can combine this attribute with form of payment details /AirTicketRQ/OptionalQualifiers/FOP_Qualifiers/BasicFOP.
                 * 
                 * @return value
                 */
                public Boolean getInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. "Ind" is used to issue a paperless service fee request, using the service fee amount stored in the TJR. You can combine this attribute with form of payment details /AirTicketRQ/OptionalQualifiers/FOP_Qualifiers/BasicFOP.
                 * 
                 * @param ind
                 */
                public void setInd(Boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Override" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeDescription"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CustomerReference"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Override implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String serviceFeeDescription;
                    private String customerReference;

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to issue a paperless service fee request and specify a service fee amount override.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to issue a paperless service fee request and specify a service fee amount override.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify currency.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify currency.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'ServiceFeeDescription' attribute value. "ServiceFeeDescription" is used to add service fee description.
                     * 
                     * @return value
                     */
                    public String getServiceFeeDescription() {
                        return serviceFeeDescription;
                    }

                    /** 
                     * Set the 'ServiceFeeDescription' attribute value. "ServiceFeeDescription" is used to add service fee description.
                     * 
                     * @param serviceFeeDescription
                     */
                    public void setServiceFeeDescription(
                            String serviceFeeDescription) {
                        this.serviceFeeDescription = serviceFeeDescription;
                    }

                    /** 
                     * Get the 'CustomerReference' attribute value. "CustomerReference" is used to add customer reference. Applies only to BSP Canada customers.
                     * 
                     * @return value
                     */
                    public String getCustomerReference() {
                        return customerReference;
                    }

                    /** 
                     * Set the 'CustomerReference' attribute value. "CustomerReference" is used to add customer reference. Applies only to BSP Canada customers.
                     * 
                     * @param customerReference
                     */
                    public void setCustomerReference(String customerReference) {
                        this.customerReference = customerReference;
                    }
                }
            }
            /** 
             * Please note that only two of the three attributes can be set to true simultaneously.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NeedPrint" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="AuditorCoupon"/>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Itinerary"/>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="PassengerReceipt"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NeedPrint implements Serializable
            {
                private boolean auditorCoupon;
                private boolean itinerary;
                private boolean passengerReceipt;

                /** 
                 * Get the 'AuditorCoupon' attribute value. "AuditorCoupon" is used to specify to print an auditor coupon. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @return value
                 */
                public boolean isAuditorCoupon() {
                    return auditorCoupon;
                }

                /** 
                 * Set the 'AuditorCoupon' attribute value. "AuditorCoupon" is used to specify to print an auditor coupon. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @param auditorCoupon
                 */
                public void setAuditorCoupon(boolean auditorCoupon) {
                    this.auditorCoupon = auditorCoupon;
                }

                /** 
                 * Get the 'Itinerary' attribute value. "Itinerary" is used to specify to print an itinerary. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @return value
                 */
                public boolean isItinerary() {
                    return itinerary;
                }

                /** 
                 * Set the 'Itinerary' attribute value. "Itinerary" is used to specify to print an itinerary. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @param itinerary
                 */
                public void setItinerary(boolean itinerary) {
                    this.itinerary = itinerary;
                }

                /** 
                 * Get the 'PassengerReceipt' attribute value. "PassengerReceipt" is used to specify to print a passenger receipt. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @return value
                 */
                public boolean isPassengerReceipt() {
                    return passengerReceipt;
                }

                /** 
                 * Set the 'PassengerReceipt' attribute value. "PassengerReceipt" is used to specify to print a passenger receipt. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @param passengerReceipt
                 */
                public void setPassengerReceipt(boolean passengerReceipt) {
                    this.passengerReceipt = passengerReceipt;
                }
            }
            /** 
             * Used to pass net remit amount/codes.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="DiscountAmount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SellingFareAmount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ContractAgreementCode"/>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="NetCreditAmount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="TourCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ValueCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetRemit implements Serializable
            {
                private String amount;
                private String discountAmount;
                private String sellingFareAmount;
                private String contractAgreementCode;
                private BigDecimal netCreditAmount;
                private String tourCode;
                private String valueCode;

                /** 
                 * Get the 'Amount' attribute value. "Amount" is used to enter manual/NET amount.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. "Amount" is used to enter manual/NET amount.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'DiscountAmount' attribute value. "DiscountAmount" is used to enter discount amount.
                 * 
                 * @return value
                 */
                public String getDiscountAmount() {
                    return discountAmount;
                }

                /** 
                 * Set the 'DiscountAmount' attribute value. "DiscountAmount" is used to enter discount amount.
                 * 
                 * @param discountAmount
                 */
                public void setDiscountAmount(String discountAmount) {
                    this.discountAmount = discountAmount;
                }

                /** 
                 * Get the 'SellingFareAmount' attribute value. "SellingFareAmount" is used to enter total selling amount.
                 * 
                 * @return value
                 */
                public String getSellingFareAmount() {
                    return sellingFareAmount;
                }

                /** 
                 * Set the 'SellingFareAmount' attribute value. "SellingFareAmount" is used to enter total selling amount.
                 * 
                 * @param sellingFareAmount
                 */
                public void setSellingFareAmount(String sellingFareAmount) {
                    this.sellingFareAmount = sellingFareAmount;
                }

                /** 
                 * Get the 'ContractAgreementCode' attribute value. "ContractAgreementCode" is used to enter manual NET/net code with contract agreement reference code.
                 * 
                 * @return value
                 */
                public String getContractAgreementCode() {
                    return contractAgreementCode;
                }

                /** 
                 * Set the 'ContractAgreementCode' attribute value. "ContractAgreementCode" is used to enter manual NET/net code with contract agreement reference code.
                 * 
                 * @param contractAgreementCode
                 */
                public void setContractAgreementCode(
                        String contractAgreementCode) {
                    this.contractAgreementCode = contractAgreementCode;
                }

                /** 
                 * Get the 'NetCreditAmount' attribute value. "NetCreditAmount" is used to enter credit card amount.
                 * 
                 * @return value
                 */
                public BigDecimal getNetCreditAmount() {
                    return netCreditAmount;
                }

                /** 
                 * Set the 'NetCreditAmount' attribute value. "NetCreditAmount" is used to enter credit card amount.
                 * 
                 * @param netCreditAmount
                 */
                public void setNetCreditAmount(BigDecimal netCreditAmount) {
                    this.netCreditAmount = netCreditAmount;
                }

                /** 
                 * Get the 'TourCode' attribute value. "TourCode" is used to pass tour code details.
                 * 
                 * @return value
                 */
                public String getTourCode() {
                    return tourCode;
                }

                /** 
                 * Set the 'TourCode' attribute value. "TourCode" is used to pass tour code details.
                 * 
                 * @param tourCode
                 */
                public void setTourCode(String tourCode) {
                    this.tourCode = tourCode;
                }

                /** 
                 * Get the 'ValueCode' attribute value. "ValueCode" is used to enter manual NET/net code with value code.
                 * 
                 * @return value
                 */
                public String getValueCode() {
                    return valueCode;
                }

                /** 
                 * Set the 'ValueCode' attribute value. "ValueCode" is used to enter manual NET/net code with value code.
                 * 
                 * @param valueCode
                 */
                public void setValueCode(String valueCode) {
                    this.valueCode = valueCode;
                }
            }
            /** 
             * Used to specify ticket types to issue.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Ticket implements Serializable
            {
                private String action;
                private String type;

                /** 
                 * Get the 'Action' attribute value. "Action" is used to specify an action code. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @return value
                 */
                public String getAction() {
                    return action;
                }

                /** 
                 * Set the 'Action' attribute value. "Action" is used to specify an action code. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
                 * 
                 * @param action
                 */
                public void setAction(String action) {
                    this.action = action;
                }

                /** 
                 * Get the 'Type' attribute value. "Type" is used to specify the type of ticket to issue. Acceptable values for Type: ETR = electronic ticket (default), EMD= Electronic Miscellaneous Document, XETR = paper ticket, VCR = paper ticket (for airline use only).
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. "Type" is used to specify the type of ticket to issue. Acceptable values for Type: ETR = electronic ticket (default), EMD= Electronic Miscellaneous Document, XETR = paper ticket, VCR = paper ticket (for airline use only).
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
            /** 
             * Used to pass tourcode information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SuppressFareReplaceWithBT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressFareReplaceWithBT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressFareReplaceWithIT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressFareReplaceWithIT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressIT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressIT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressITSupressFare" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressITSupressFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TourCode implements Serializable
            {
                private SuppressFareReplaceWithBT suppressFareReplaceWithBT;
                private SuppressFareReplaceWithIT suppressFareReplaceWithIT;
                private SuppressIT suppressIT;
                private SuppressITSupressFare suppressITSupressFare;
                private String text;

                /** 
                 * Get the 'SuppressFareReplaceWithBT' element value.
                 * 
                 * @return value
                 */
                public SuppressFareReplaceWithBT getSuppressFareReplaceWithBT() {
                    return suppressFareReplaceWithBT;
                }

                /** 
                 * Set the 'SuppressFareReplaceWithBT' element value.
                 * 
                 * @param suppressFareReplaceWithBT
                 */
                public void setSuppressFareReplaceWithBT(
                        SuppressFareReplaceWithBT suppressFareReplaceWithBT) {
                    this.suppressFareReplaceWithBT = suppressFareReplaceWithBT;
                }

                /** 
                 * Get the 'SuppressFareReplaceWithIT' element value.
                 * 
                 * @return value
                 */
                public SuppressFareReplaceWithIT getSuppressFareReplaceWithIT() {
                    return suppressFareReplaceWithIT;
                }

                /** 
                 * Set the 'SuppressFareReplaceWithIT' element value.
                 * 
                 * @param suppressFareReplaceWithIT
                 */
                public void setSuppressFareReplaceWithIT(
                        SuppressFareReplaceWithIT suppressFareReplaceWithIT) {
                    this.suppressFareReplaceWithIT = suppressFareReplaceWithIT;
                }

                /** 
                 * Get the 'SuppressIT' element value.
                 * 
                 * @return value
                 */
                public SuppressIT getSuppressIT() {
                    return suppressIT;
                }

                /** 
                 * Set the 'SuppressIT' element value.
                 * 
                 * @param suppressIT
                 */
                public void setSuppressIT(SuppressIT suppressIT) {
                    this.suppressIT = suppressIT;
                }

                /** 
                 * Get the 'SuppressITSupressFare' element value.
                 * 
                 * @return value
                 */
                public SuppressITSupressFare getSuppressITSupressFare() {
                    return suppressITSupressFare;
                }

                /** 
                 * Set the 'SuppressITSupressFare' element value.
                 * 
                 * @param suppressITSupressFare
                 */
                public void setSuppressITSupressFare(
                        SuppressITSupressFare suppressITSupressFare) {
                    this.suppressITSupressFare = suppressITSupressFare;
                }

                /** 
                 * Get the 'Text' element value. "Text" is used to specify tour code.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. "Text" is used to specify tour code.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }
                /** 
                 * This is not applicable to ARC subscribers.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithBT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressFareReplaceWithBT implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. "Ind" is used to specify to suppress the fare amount on the ticket and replace with BT.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. "Ind" is used to specify to suppress the fare amount on the ticket and replace with BT.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Suppress the fare amount on the ticket and replace with IT.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithIT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressFareReplaceWithIT implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. "Ind" is used to specify to suppress the fare amount on the ticket and replace with IT.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. "Ind" is used to specify to suppress the fare amount on the ticket and replace with IT.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Suppress the IT in the tour code box from printing.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressIT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressIT implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. "Ind" is used to specify to to suppress the IT in the tour code box from printing.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. "Ind" is used to specify to to suppress the IT in the tour code box from printing.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Suppress IT from printing in the tour box on the ticket and to suppress fare amounts from printing on the ticket.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressITSupressFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressITSupressFare implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. "Ind" is used to specify to specify to suppress IT from printing in the tour box on the ticket and to suppress fare amounts from printing on the ticket.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. "Ind" is used to specify to specify to suppress IT from printing in the tour box on the ticket and to suppress fare amounts from printing on the ticket.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
            }
        }
        /** 
         * Used to pass pricing qualifiers.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Brand" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Brand -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FareFocusExclude" minOccurs="0">
         *         &lt;!-- Reference to inner class FareFocusExclude -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Fare" minOccurs="0">
         *         &lt;!-- Reference to inner class Fare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
         *         &lt;!-- Reference to inner class ItineraryOptions -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class NameSelect -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PhaseIV" minOccurs="0" maxOccurs="7">
         *         &lt;!-- Reference to inner class PhaseIV -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PriceQuote" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PriceQuote -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RefundableBalance" minOccurs="0">
         *         &lt;!-- Reference to inner class RefundableBalance -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SpanishLargeFamilyDiscountLevel" minOccurs="0">
         *         &lt;xs:simpleType>
         *           &lt;!-- Reference to inner class SpanishLargeFamilyDiscountLevel -->
         *         &lt;/xs:simpleType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SpecificFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SpecificPenalty" minOccurs="0">
         *         &lt;!-- Reference to inner class SpecificPenalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Taxes" minOccurs="0">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ValidityDates -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingQualifiers implements Serializable
        {
            private List<Brand> brandList = new ArrayList<Brand>();
            private FareFocusExclude fareFocusExclude;
            private Fare fare;
            private ItineraryOptions itineraryOptions;
            private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
            private List<PhaseIV> phaseIVList = new ArrayList<PhaseIV>();
            private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();
            private RefundableBalance refundableBalance;
            private SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel;
            private List<SpecificFare> specificFareList = new ArrayList<SpecificFare>();
            private SpecificPenalty specificPenalty;
            private Taxes taxes;
            private List<ValidityDates> validityDateList = new ArrayList<ValidityDates>();

            /** 
             * Get the list of 'Brand' element items.
             * 
             * @return list
             */
            public List<Brand> getBrandList() {
                return brandList;
            }

            /** 
             * Set the list of 'Brand' element items.
             * 
             * @param list
             */
            public void setBrandList(List<Brand> list) {
                brandList = list;
            }

            /** 
             * Get the 'FareFocusExclude' element value.
             * 
             * @return value
             */
            public FareFocusExclude getFareFocusExclude() {
                return fareFocusExclude;
            }

            /** 
             * Set the 'FareFocusExclude' element value.
             * 
             * @param fareFocusExclude
             */
            public void setFareFocusExclude(FareFocusExclude fareFocusExclude) {
                this.fareFocusExclude = fareFocusExclude;
            }

            /** 
             * Get the 'Fare' element value.
             * 
             * @return value
             */
            public Fare getFare() {
                return fare;
            }

            /** 
             * Set the 'Fare' element value.
             * 
             * @param fare
             */
            public void setFare(Fare fare) {
                this.fare = fare;
            }

            /** 
             * Get the 'ItineraryOptions' element value.
             * 
             * @return value
             */
            public ItineraryOptions getItineraryOptions() {
                return itineraryOptions;
            }

            /** 
             * Set the 'ItineraryOptions' element value.
             * 
             * @param itineraryOptions
             */
            public void setItineraryOptions(ItineraryOptions itineraryOptions) {
                this.itineraryOptions = itineraryOptions;
            }

            /** 
             * Get the list of 'NameSelect' element items.
             * 
             * @return list
             */
            public List<NameSelect> getNameSelectList() {
                return nameSelectList;
            }

            /** 
             * Set the list of 'NameSelect' element items.
             * 
             * @param list
             */
            public void setNameSelectList(List<NameSelect> list) {
                nameSelectList = list;
            }

            /** 
             * Get the list of 'PhaseIV' element items.
             * 
             * @return list
             */
            public List<PhaseIV> getPhaseIVList() {
                return phaseIVList;
            }

            /** 
             * Set the list of 'PhaseIV' element items.
             * 
             * @param list
             */
            public void setPhaseIVList(List<PhaseIV> list) {
                phaseIVList = list;
            }

            /** 
             * Get the list of 'PriceQuote' element items.
             * 
             * @return list
             */
            public List<PriceQuote> getPriceQuoteList() {
                return priceQuoteList;
            }

            /** 
             * Set the list of 'PriceQuote' element items.
             * 
             * @param list
             */
            public void setPriceQuoteList(List<PriceQuote> list) {
                priceQuoteList = list;
            }

            /** 
             * Get the 'RefundableBalance' element value.
             * 
             * @return value
             */
            public RefundableBalance getRefundableBalance() {
                return refundableBalance;
            }

            /** 
             * Set the 'RefundableBalance' element value.
             * 
             * @param refundableBalance
             */
            public void setRefundableBalance(RefundableBalance refundableBalance) {
                this.refundableBalance = refundableBalance;
            }

            /** 
             * Get the 'SpanishLargeFamilyDiscountLevel' element value. "SpanishLargeFamilyDiscountLevel" is used to specify the Spanish large family discount level. Please note that this qualifier is only applicable to Spain-based subscribers.
             * 
             * @return value
             */
            public SpanishLargeFamilyDiscountLevel getSpanishLargeFamilyDiscountLevel() {
                return spanishLargeFamilyDiscountLevel;
            }

            /** 
             * Set the 'SpanishLargeFamilyDiscountLevel' element value. "SpanishLargeFamilyDiscountLevel" is used to specify the Spanish large family discount level. Please note that this qualifier is only applicable to Spain-based subscribers.
             * 
             * @param spanishLargeFamilyDiscountLevel
             */
            public void setSpanishLargeFamilyDiscountLevel(
                    SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel) {
                this.spanishLargeFamilyDiscountLevel = spanishLargeFamilyDiscountLevel;
            }

            /** 
             * Get the list of 'SpecificFare' element items.
             * 
             * @return list
             */
            public List<SpecificFare> getSpecificFareList() {
                return specificFareList;
            }

            /** 
             * Set the list of 'SpecificFare' element items.
             * 
             * @param list
             */
            public void setSpecificFareList(List<SpecificFare> list) {
                specificFareList = list;
            }

            /** 
             * Get the 'SpecificPenalty' element value.
             * 
             * @return value
             */
            public SpecificPenalty getSpecificPenalty() {
                return specificPenalty;
            }

            /** 
             * Set the 'SpecificPenalty' element value.
             * 
             * @param specificPenalty
             */
            public void setSpecificPenalty(SpecificPenalty specificPenalty) {
                this.specificPenalty = specificPenalty;
            }

            /** 
             * Get the 'Taxes' element value.
             * 
             * @return value
             */
            public Taxes getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value.
             * 
             * @param taxes
             */
            public void setTaxes(Taxes taxes) {
                this.taxes = taxes;
            }

            /** 
             * Get the list of 'ValidityDates' element items.
             * 
             * @return list
             */
            public List<ValidityDates> getValidityDateList() {
                return validityDateList;
            }

            /** 
             * Set the list of 'ValidityDates' element items.
             * 
             * @param list
             */
            public void setValidityDateList(List<ValidityDates> list) {
                validityDateList = list;
            }
            /** 
             * "Brand" is used to specify a brand.  Please note that it's not possible to request more than 1 brand for an entire journey, or for the same segment.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Brand" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Brand implements Serializable
            {
                private String string;
                private BigInteger RPH;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'RPH' attribute value. "RPH" is used to match up with ".../ItineraryOptions/Segment".
                 * 
                 * @return value
                 */
                public BigInteger getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. "RPH" is used to match up with ".../ItineraryOptions/Segment".
                 * 
                 * @param RPH
                 */
                public void setRPH(BigInteger RPH) {
                    this.RPH = RPH;
                }
            }
            /** 
             * "FareFocusExclude" is used to exclude fare focus fares based on business rules of the agency. Please note that this qualifier cannot be combined with .../PriceQuote.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareFocusExclude" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareFocusExclude implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value. Used to exclude fare focus fares based on business rules of the agency.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Used to exclude fare focus fares based on business rules of the agency.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Please note that this functionality is restricted to Sabre's Asian joint venture customers.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fare implements Serializable
            {
                private String type;

                /** 
                 * Get the 'Type' attribute value. "Type" is used to specify a fare type. Acceptable values are "NL" for normal fare, "EX" for special fare, and "IT" for inclusive tour.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. "Type" is used to specify a fare type. Acceptable values are "NL" for normal fare, "EX" for special fare, and "IT" for inclusive tour.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
            /** 
             * Used to issue tickets on specific itinerary segments.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class SegmentSelect -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SideTrip" minOccurs="0">
             *         &lt;!-- Reference to inner class SideTrip -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ItineraryOptions implements Serializable
            {
                private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();
                private SideTrip sideTrip;

                /** 
                 * Get the list of 'SegmentSelect' element items.
                 * 
                 * @return list
                 */
                public List<SegmentSelect> getSegmentSelectList() {
                    return segmentSelectList;
                }

                /** 
                 * Set the list of 'SegmentSelect' element items.
                 * 
                 * @param list
                 */
                public void setSegmentSelectList(List<SegmentSelect> list) {
                    segmentSelectList = list;
                }

                /** 
                 * Get the 'SideTrip' element value.
                 * 
                 * @return value
                 */
                public SideTrip getSideTrip() {
                    return sideTrip;
                }

                /** 
                 * Set the 'SideTrip' element value.
                 * 
                 * @param sideTrip
                 */
                public void setSideTrip(SideTrip sideTrip) {
                    this.sideTrip = sideTrip;
                }
                /** 
                 * "SegmentSelect" is used to instruct the system to price specified itinerary segments.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SegmentSelect implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;
                    private String RPH;

                    /** 
                     * Get the 'EndNumber' attribute value. End number in range.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value. End number in range.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value. Segment number.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Segment number.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'RPH' attribute value. "RPH" is used to match up with ".../SpecificFare/@RPH" or .../Brand.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. "RPH" is used to match up with ".../SpecificFare/@RPH" or .../Brand.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                }
                /** 
                 * "SideTrip" is used to instruct the system to price the specified itinerary segments as a side trip.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SideTrip" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SideTrip implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value. End number in range.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value. End number in range.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value. Segment number.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Segment number.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * "NameSelect" is used to instruct the system to price the itinerary based upon a particular name field.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="EndNameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NameSelect implements Serializable
            {
                private String endNameNumber;
                private String nameNumber;

                /** 
                 * Get the 'EndNameNumber' attribute value. End number in range.
                 * 
                 * @return value
                 */
                public String getEndNameNumber() {
                    return endNameNumber;
                }

                /** 
                 * Set the 'EndNameNumber' attribute value. End number in range.
                 * 
                 * @param endNameNumber
                 */
                public void setEndNameNumber(String endNameNumber) {
                    this.endNameNumber = endNameNumber;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Name number for example: "1.1."
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Name number for example: "1.1."
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
            /** 
             * "PhaseIV" is used to issue a Phase IV ticket. Cannot combine with .../PriceQuote.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PhaseIV" minOccurs="0" maxOccurs="7">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class NameSelect -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PhaseIV implements Serializable
            {
                private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
                private BigInteger number;

                /** 
                 * Get the list of 'NameSelect' element items.
                 * 
                 * @return list
                 */
                public List<NameSelect> getNameSelectList() {
                    return nameSelectList;
                }

                /** 
                 * Set the list of 'NameSelect' element items.
                 * 
                 * @param list
                 */
                public void setNameSelectList(List<NameSelect> list) {
                    nameSelectList = list;
                }

                /** 
                 * Get the 'Number' attribute value. Phase IV number.
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. Phase IV number.
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
                /** 
                 * "NameSelect" is used to instruct the system to price theitinerary based upon a particular name field.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="EndNameNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NameSelect implements Serializable
                {
                    private String endNameNumber;
                    private String nameNumber;

                    /** 
                     * Get the 'EndNameNumber' attribute value. End number in range.
                     * 
                     * @return value
                     */
                    public String getEndNameNumber() {
                        return endNameNumber;
                    }

                    /** 
                     * Set the 'EndNameNumber' attribute value. End number in range.
                     * 
                     * @param endNameNumber
                     */
                    public void setEndNameNumber(String endNameNumber) {
                        this.endNameNumber = endNameNumber;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Name number for example: "1.1."
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Name number for example: "1.1."
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                }
            }
            /** 
             * Cannot combine with .../NameSelect. Cannot combine with .../PhaseIV.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class NameSelect -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Record" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Record -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PriceQuote implements Serializable
            {
                private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
                private List<Record> recordList = new ArrayList<Record>();

                /** 
                 * Get the list of 'NameSelect' element items.
                 * 
                 * @return list
                 */
                public List<NameSelect> getNameSelectList() {
                    return nameSelectList;
                }

                /** 
                 * Set the list of 'NameSelect' element items.
                 * 
                 * @param list
                 */
                public void setNameSelectList(List<NameSelect> list) {
                    nameSelectList = list;
                }

                /** 
                 * Get the list of 'Record' element items.
                 * 
                 * @return list
                 */
                public List<Record> getRecordList() {
                    return recordList;
                }

                /** 
                 * Set the list of 'Record' element items.
                 * 
                 * @param list
                 */
                public void setRecordList(List<Record> list) {
                    recordList = list;
                }
                /** 
                 * "NameSelect" is used to instruct the system to price theitinerary based upon a particular name field.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:decimal" use="optional" name="EndNameNumber"/>
                 *     &lt;xs:attribute type="xs:decimal" use="required" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NameSelect implements Serializable
                {
                    private BigDecimal endNameNumber;
                    private BigDecimal nameNumber;

                    /** 
                     * Get the 'EndNameNumber' attribute value. End number in range.
                     * 
                     * @return value
                     */
                    public BigDecimal getEndNameNumber() {
                        return endNameNumber;
                    }

                    /** 
                     * Set the 'EndNameNumber' attribute value. End number in range.
                     * 
                     * @param endNameNumber
                     */
                    public void setEndNameNumber(BigDecimal endNameNumber) {
                        this.endNameNumber = endNameNumber;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Name number for example: "1.1."
                     * 
                     * @return value
                     */
                    public BigDecimal getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Name number for example: "1.1."
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(BigDecimal nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                }
                /** 
                 * In order to specify multiple PQR records to be issued please specify a range or specific record numbers by means of the element repetition. .../Ticketing/PricingQualifiers/PriceQuote/Record/@Reissue cannot be combined with .../Ticketing/MiscQualifiers/Ticket.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Record" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Reissue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Record implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;
                    private Boolean reissue;

                    /** 
                     * Get the 'EndNumber' attribute value. "EndNumber" is used to specify the ending PQ number in a range.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value. "EndNumber" is used to specify the ending PQ number in a range.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value. "Number" is used to specify a PQ number.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. "Number" is used to specify a PQ number.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'Reissue' attribute value. "Reissue" is used to indicate that the particular PQ record is a PQ Reissue record.
                     * 
                     * @return value
                     */
                    public Boolean getReissue() {
                        return reissue;
                    }

                    /** 
                     * Set the 'Reissue' attribute value. "Reissue" is used to indicate that the particular PQ record is a PQ Reissue record.
                     * 
                     * @param reissue
                     */
                    public void setReissue(Boolean reissue) {
                        this.reissue = reissue;
                    }
                }
            }
            /** 
             * "RefundableBalance" is used to issue PQR with Refundable Balance EMD-S.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundableBalance" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Taxes" minOccurs="0">
             *         &lt;!-- Reference to inner class Taxes -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RefundableBalance implements Serializable
            {
                private Taxes taxes;
                private String amount;

                /** 
                 * Get the 'Taxes' element value.
                 * 
                 * @return value
                 */
                public Taxes getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value.
                 * 
                 * @param taxes
                 */
                public void setTaxes(Taxes taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the 'Amount' attribute value. Refundable balance amount.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. Refundable balance amount.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }
                /** 
                 * Tax details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Tax" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Taxes implements Serializable
                {
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Individual tax details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private String amount;
                        private String code;

                        /** 
                         * Get the 'Amount' attribute value. "Amount" is used to specify the value associated with the tax in PQR Exchange.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. "Amount" is used to specify the value associated with the tax in PQR Exchange.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Code' attribute value. "Code" is used to specify the tax code associated with the tax in PQR Exchange.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value. "Code" is used to specify the tax code associated with the tax in PQR Exchange.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="1"/>
             *     &lt;xs:enumeration value="2"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum SpanishLargeFamilyDiscountLevel
                    implements
                        Serializable {
                _1("1"), _2("2");
                private final String value;

                private SpanishLargeFamilyDiscountLevel(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static SpanishLargeFamilyDiscountLevel convert(
                        String value) {
                    for (SpanishLargeFamilyDiscountLevel inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
            /** 
             * Please note that the element is only applicable to Abacus.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SpecificFare implements Serializable
            {
                private String fareBasis;
                private String RPH;

                /** 
                 * Get the 'FareBasis' element value. "FareBasis" is used to specify a particular fare basis that will, in turn, be validated.
                 * 
                 * @return value
                 */
                public String getFareBasis() {
                    return fareBasis;
                }

                /** 
                 * Set the 'FareBasis' element value. "FareBasis" is used to specify a particular fare basis that will, in turn, be validated.
                 * 
                 * @param fareBasis
                 */
                public void setFareBasis(String fareBasis) {
                    this.fareBasis = fareBasis;
                }

                /** 
                 * Get the 'RPH' attribute value. "RPH" is used to match up with ../OptionalQualifiers/PricingQualifiers/ItineraryOptions/Segment.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. "RPH" is used to match up with ../OptionalQualifiers/PricingQualifiers/ItineraryOptions/Segment.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
            }
            /** 
             * "SpecificPenalty" is used to specify change or cancellation amounts for an itinerary.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Changeable" minOccurs="0">
             *         &lt;!-- Reference to inner class Changeable -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EitherOr" minOccurs="0">
             *         &lt;!-- Reference to inner class EitherOr -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Refundable" minOccurs="0">
             *         &lt;!-- Reference to inner class Refundable -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AdditionalInfo"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SpecificPenalty implements Serializable
            {
                private Changeable changeable;
                private EitherOr eitherOr;
                private Refundable refundable;
                private Boolean additionalInfo;

                /** 
                 * Get the 'Changeable' element value.
                 * 
                 * @return value
                 */
                public Changeable getChangeable() {
                    return changeable;
                }

                /** 
                 * Set the 'Changeable' element value.
                 * 
                 * @param changeable
                 */
                public void setChangeable(Changeable changeable) {
                    this.changeable = changeable;
                }

                /** 
                 * Get the 'EitherOr' element value.
                 * 
                 * @return value
                 */
                public EitherOr getEitherOr() {
                    return eitherOr;
                }

                /** 
                 * Set the 'EitherOr' element value.
                 * 
                 * @param eitherOr
                 */
                public void setEitherOr(EitherOr eitherOr) {
                    this.eitherOr = eitherOr;
                }

                /** 
                 * Get the 'Refundable' element value.
                 * 
                 * @return value
                 */
                public Refundable getRefundable() {
                    return refundable;
                }

                /** 
                 * Set the 'Refundable' element value.
                 * 
                 * @param refundable
                 */
                public void setRefundable(Refundable refundable) {
                    this.refundable = refundable;
                }

                /** 
                 * Get the 'AdditionalInfo' attribute value. "AdditionalInfo" is used to receive additional tags with information on fare flexibility.
                 * 
                 * @return value
                 */
                public Boolean getAdditionalInfo() {
                    return additionalInfo;
                }

                /** 
                 * Set the 'AdditionalInfo' attribute value. "AdditionalInfo" is used to receive additional tags with information on fare flexibility.
                 * 
                 * @param additionalInfo
                 */
                public void setAdditionalInfo(Boolean additionalInfo) {
                    this.additionalInfo = additionalInfo;
                }
                /** 
                 * It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Changeable" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Changeable implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value. "Any" is used to specify only changeable fare options.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value. "Any" is used to specify only changeable fare options.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify the specific currency for maximum exchange penalty.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify the specific currency for maximum exchange penalty.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value. "MaxPenalty" is used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value. "MaxPenalty" is used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value. "BeforeDeparture" is used to query for before depature fees.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value. "BeforeDeparture" is used to query for before depature fees.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value. "AfterDeparture" is used to query for after depature fees.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value. "AfterDeparture" is used to query for after depature fees.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
                /** 
                 * It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EitherOr" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EitherOr implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value. "Any" is used to specify only changeable fare options.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value. "Any" is used to specify only changeable fare options.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify the specific currency for maximum exchange penalty.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify the specific currency for maximum exchange penalty.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value. "MaxPenalty" is used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value. "MaxPenalty" is used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value. "BeforeDeparture" is used to query for before depature fees.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value. "BeforeDeparture" is used to query for before depature fees.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value. "AfterDeparture" is used to query for after depature fees.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value. "AfterDeparture" is used to query for after depature fees.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
                /** 
                 * It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Refundable" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Refundable implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value. "Any" is used to specify only changeable fare options.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value. "Any" is used to specify only changeable fare options.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify the specific currency for maximum exchange penalty.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to specify the specific currency for maximum exchange penalty.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value. "MaxPenalty" is used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value. "MaxPenalty" is used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a decimal is not allowed.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value. "BeforeDeparture" is used to query for before depature fees.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value. "BeforeDeparture" is used to query for before depature fees.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value. "AfterDeparture" is used to query for after depature fees.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value. "AfterDeparture" is used to query for after depature fees.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
            }
            /** 
             * Used to exempt taxes.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NoTax" minOccurs="0">
             *         &lt;!-- Reference to inner class NoTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxExempt" minOccurs="0" maxOccurs="5">
             *         &lt;!-- Reference to inner class TaxExempt -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private NoTax noTax;
                private List<TaxExempt> taxExemptList = new ArrayList<TaxExempt>();

                /** 
                 * Get the 'NoTax' element value.
                 * 
                 * @return value
                 */
                public NoTax getNoTax() {
                    return noTax;
                }

                /** 
                 * Set the 'NoTax' element value.
                 * 
                 * @param noTax
                 */
                public void setNoTax(NoTax noTax) {
                    this.noTax = noTax;
                }

                /** 
                 * Get the list of 'TaxExempt' element items.
                 * 
                 * @return list
                 */
                public List<TaxExempt> getTaxExemptList() {
                    return taxExemptList;
                }

                /** 
                 * Set the list of 'TaxExempt' element items.
                 * 
                 * @param list
                 */
                public void setTaxExemptList(List<TaxExempt> list) {
                    taxExemptList = list;
                }
                /** 
                 * Used to specify whether or not to exempt all taxes during EMD issuance.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NoTax implements Serializable
                {
                    private Boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. "Ind" is used to specify whether or not to exempt all taxes during EMD issuance.
                     * 
                     * @return value
                     */
                    public Boolean getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. "Ind" is used to specify whether or not to exempt all taxes during EMD issuance.
                     * 
                     * @param ind
                     */
                    public void setInd(Boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Used to specify a tax code to exempt during EMD issuance.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExempt" minOccurs="0" maxOccurs="5">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxExempt implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value. "Code" is used to specify a tax code to exempt during EMD issuance.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. "Code" is used to specify a tax code to exempt during EMD issuance.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * This node is used to specify ticket validity dates. Cannot combine with PhaseIV.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="NotValidAfter" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="NotValidBefore" minOccurs="0"/>
             *       &lt;xs:element name="Segment" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ValidityDates implements Serializable
            {
                private String notValidAfter;
                private String notValidBefore;
                private List<Segment> segmentList = new ArrayList<Segment>();

                /** 
                 * Get the 'NotValidAfter' element value. "NotValidAfter" is used to specify the ending validity date.
                 * 
                 * @return value
                 */
                public String getNotValidAfter() {
                    return notValidAfter;
                }

                /** 
                 * Set the 'NotValidAfter' element value. "NotValidAfter" is used to specify the ending validity date.
                 * 
                 * @param notValidAfter
                 */
                public void setNotValidAfter(String notValidAfter) {
                    this.notValidAfter = notValidAfter;
                }

                /** 
                 * Get the 'NotValidBefore' element value. "NotValidBefore" is used to specify the beginning validity date.
                 * 
                 * @return value
                 */
                public String getNotValidBefore() {
                    return notValidBefore;
                }

                /** 
                 * Set the 'NotValidBefore' element value. "NotValidBefore" is used to specify the beginning validity date.
                 * 
                 * @param notValidBefore
                 */
                public void setNotValidBefore(String notValidBefore) {
                    this.notValidBefore = notValidBefore;
                }

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }
                /** 
                 * "Segment" is used to specify the relevant itinerary segments.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value. End numbe rin range.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value. End numbe rin range.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value. Segment number.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Segment number.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
        }
    }
    /** 
     * Additional ticket issuance options, mostly related to post issuance actions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PostProcessing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="EndTransaction" minOccurs="0">
     *         &lt;!-- Reference to inner class EndTransaction -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CreditVerificationInterval" minOccurs="0">
     *         &lt;!-- Reference to inner class CreditVerificationInterval -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="GhostTicketCheck" minOccurs="0">
     *         &lt;!-- Reference to inner class GhostTicketCheck -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TicketingInterval" minOccurs="0">
     *         &lt;!-- Reference to inner class TicketingInterval -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="acceptNegotiatedFare"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="acceptPriceChanges"/>
     *     &lt;xs:attribute use="optional" name="actionOnPQExpired">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class ActionOnPQExpired -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute name="actionOnBackDatePrice">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class ActionOnBackDatePrice -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PostProcessing implements Serializable
    {
        private EndTransaction endTransaction;
        private CreditVerificationInterval creditVerificationInterval;
        private GhostTicketCheck ghostTicketCheck;
        private TicketingInterval ticketingInterval;
        private Boolean acceptNegotiatedFare;
        private Boolean acceptPriceChanges;
        private ActionOnPQExpired actionOnPQExpired;
        private ActionOnBackDatePrice actionOnBackDatePrice;

        /** 
         * Get the 'EndTransaction' element value.
         * 
         * @return value
         */
        public EndTransaction getEndTransaction() {
            return endTransaction;
        }

        /** 
         * Set the 'EndTransaction' element value.
         * 
         * @param endTransaction
         */
        public void setEndTransaction(EndTransaction endTransaction) {
            this.endTransaction = endTransaction;
        }

        /** 
         * Get the 'CreditVerificationInterval' element value.
         * 
         * @return value
         */
        public CreditVerificationInterval getCreditVerificationInterval() {
            return creditVerificationInterval;
        }

        /** 
         * Set the 'CreditVerificationInterval' element value.
         * 
         * @param creditVerificationInterval
         */
        public void setCreditVerificationInterval(
                CreditVerificationInterval creditVerificationInterval) {
            this.creditVerificationInterval = creditVerificationInterval;
        }

        /** 
         * Get the 'GhostTicketCheck' element value.
         * 
         * @return value
         */
        public GhostTicketCheck getGhostTicketCheck() {
            return ghostTicketCheck;
        }

        /** 
         * Set the 'GhostTicketCheck' element value.
         * 
         * @param ghostTicketCheck
         */
        public void setGhostTicketCheck(GhostTicketCheck ghostTicketCheck) {
            this.ghostTicketCheck = ghostTicketCheck;
        }

        /** 
         * Get the 'TicketingInterval' element value.
         * 
         * @return value
         */
        public TicketingInterval getTicketingInterval() {
            return ticketingInterval;
        }

        /** 
         * Set the 'TicketingInterval' element value.
         * 
         * @param ticketingInterval
         */
        public void setTicketingInterval(TicketingInterval ticketingInterval) {
            this.ticketingInterval = ticketingInterval;
        }

        /** 
         * Get the 'acceptNegotiatedFare' attribute value. "acceptNegotiatedFare" is used to accept a negotiated fare when it is not possible to ticket the stored fare.
         * 
         * @return value
         */
        public Boolean getAcceptNegotiatedFare() {
            return acceptNegotiatedFare;
        }

        /** 
         * Set the 'acceptNegotiatedFare' attribute value. "acceptNegotiatedFare" is used to accept a negotiated fare when it is not possible to ticket the stored fare.
         * 
         * @param acceptNegotiatedFare
         */
        public void setAcceptNegotiatedFare(Boolean acceptNegotiatedFare) {
            this.acceptNegotiatedFare = acceptNegotiatedFare;
        }

        /** 
         * Get the 'acceptPriceChanges' attribute value. "acceptPriceChanges" is used to specify that system should issue a ticket even if price increases while processing.
         * 
         * @return value
         */
        public Boolean getAcceptPriceChanges() {
            return acceptPriceChanges;
        }

        /** 
         * Set the 'acceptPriceChanges' attribute value. "acceptPriceChanges" is used to specify that system should issue a ticket even if price increases while processing.
         * 
         * @param acceptPriceChanges
         */
        public void setAcceptPriceChanges(Boolean acceptPriceChanges) {
            this.acceptPriceChanges = acceptPriceChanges;
        }

        /** 
         * Get the 'actionOnPQExpired' attribute value. "actionOnPQExpired" is used to specify appropriate action when Price Quote expires. Available options are "R" - reprice, "Q" Quit, "O" Override.
         * 
         * @return value
         */
        public ActionOnPQExpired getActionOnPQExpired() {
            return actionOnPQExpired;
        }

        /** 
         * Set the 'actionOnPQExpired' attribute value. "actionOnPQExpired" is used to specify appropriate action when Price Quote expires. Available options are "R" - reprice, "Q" Quit, "O" Override.
         * 
         * @param actionOnPQExpired
         */
        public void setActionOnPQExpired(ActionOnPQExpired actionOnPQExpired) {
            this.actionOnPQExpired = actionOnPQExpired;
        }

        /** 
         * Get the 'actionOnBackDatePrice' attribute value. Used to specify appropriate action when Price Quote contains back date price. Available options are "R" - reprice, "Q" Quit, "O" Override. If no action is specified, system will automatically perform the reprice.
         * 
         * @return value
         */
        public ActionOnBackDatePrice getActionOnBackDatePrice() {
            return actionOnBackDatePrice;
        }

        /** 
         * Set the 'actionOnBackDatePrice' attribute value. Used to specify appropriate action when Price Quote contains back date price. Available options are "R" - reprice, "Q" Quit, "O" Override. If no action is specified, system will automatically perform the reprice.
         * 
         * @param actionOnBackDatePrice
         */
        public void setActionOnBackDatePrice(
                ActionOnBackDatePrice actionOnBackDatePrice) {
            this.actionOnBackDatePrice = actionOnBackDatePrice;
        }
        /** 
         * "EndTransaction" is used to end the transaction and finalize the record.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EndTransaction" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Source" minOccurs="0">
         *         &lt;!-- Reference to inner class Source -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Email" minOccurs="0">
         *         &lt;!-- Reference to inner class Email -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="generateSingleInvoice"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class EndTransaction implements Serializable
        {
            private Source source;
            private Email email;
            private Boolean generateSingleInvoice;

            /** 
             * Get the 'Source' element value.
             * 
             * @return value
             */
            public Source getSource() {
                return source;
            }

            /** 
             * Set the 'Source' element value.
             * 
             * @param source
             */
            public void setSource(Source source) {
                this.source = source;
            }

            /** 
             * Get the 'Email' element value.
             * 
             * @return value
             */
            public Email getEmail() {
                return email;
            }

            /** 
             * Set the 'Email' element value.
             * 
             * @param email
             */
            public void setEmail(Email email) {
                this.email = email;
            }

            /** 
             * Get the 'generateSingleInvoice' attribute value. When set to "true" the API will send a single commit message after issuing multiple tickets. This alters the default mechanism in which each ticket is committed to the PNR immediately after issuance.
             * 
             * @return value
             */
            public Boolean getGenerateSingleInvoice() {
                return generateSingleInvoice;
            }

            /** 
             * Set the 'generateSingleInvoice' attribute value. When set to "true" the API will send a single commit message after issuing multiple tickets. This alters the default mechanism in which each ticket is committed to the PNR immediately after issuance.
             * 
             * @param generateSingleInvoice
             */
            public void setGenerateSingleInvoice(Boolean generateSingleInvoice) {
                this.generateSingleInvoice = generateSingleInvoice;
            }
            /** 
             * Used to receive the record.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="ReceivedFrom"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Source implements Serializable
            {
                private String receivedFrom;

                /** 
                 * Get the 'ReceivedFrom' attribute value. "ReceivedFrom" is used to receive the record.
                 * 
                 * @return value
                 */
                public String getReceivedFrom() {
                    return receivedFrom;
                }

                /** 
                 * Set the 'ReceivedFrom' attribute value. "ReceivedFrom" is used to receive the record.
                 * 
                 * @param receivedFrom
                 */
                public void setReceivedFrom(String receivedFrom) {
                    this.receivedFrom = receivedFrom;
                }
            }
            /** 
             * "Email" is used to send an email notification upon end transaction to any email addresses contained within the particular record.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Email" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="eTicket" minOccurs="0">
             *         &lt;!-- Reference to inner class ETicket -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Invoice" minOccurs="0">
             *         &lt;!-- Reference to inner class Invoice -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Itinerary" minOccurs="0">
             *         &lt;!-- Reference to inner class Itinerary -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PersonName" minOccurs="0">
             *         &lt;!-- Reference to inner class PersonName -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Email implements Serializable
            {
                private ETicket ETicket;
                private Invoice invoice;
                private Itinerary itinerary;
                private PersonName personName;
                private boolean ind;

                /** 
                 * Get the 'eTicket' element value.
                 * 
                 * @return value
                 */
                public ETicket getETicket() {
                    return ETicket;
                }

                /** 
                 * Set the 'eTicket' element value.
                 * 
                 * @param eTicket
                 */
                public void setETicket(ETicket eTicket) {
                    ETicket = eTicket;
                }

                /** 
                 * Get the 'Invoice' element value.
                 * 
                 * @return value
                 */
                public Invoice getInvoice() {
                    return invoice;
                }

                /** 
                 * Set the 'Invoice' element value.
                 * 
                 * @param invoice
                 */
                public void setInvoice(Invoice invoice) {
                    this.invoice = invoice;
                }

                /** 
                 * Get the 'Itinerary' element value.
                 * 
                 * @return value
                 */
                public Itinerary getItinerary() {
                    return itinerary;
                }

                /** 
                 * Set the 'Itinerary' element value.
                 * 
                 * @param itinerary
                 */
                public void setItinerary(Itinerary itinerary) {
                    this.itinerary = itinerary;
                }

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonName getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonName personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'Ind' attribute value. Used to send an email notification upon end transaction.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Used to send an email notification upon end transaction.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * "eTicket" is used to send an email notification containing a text-based copy of the eTicket, cannot combine with .../Invoice, or .../Itinerary..
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="eTicket" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PDF" minOccurs="0">
                 *         &lt;!-- Reference to inner class PDF -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ETicket implements Serializable
                {
                    private PDF PDF1;
                    private boolean ind;

                    /** 
                     * Get the 'PDF' element value.
                     * 
                     * @return value
                     */
                    public PDF getPDF1() {
                        return PDF1;
                    }

                    /** 
                     * Set the 'PDF' element value.
                     * 
                     * @param PDF1
                     */
                    public void setPDF1(PDF PDF1) {
                        this.PDF1 = PDF1;
                    }

                    /** 
                     * Get the 'Ind' attribute value. Uused to send an email notification containing a text-based copy of the eTicket.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Uused to send an email notification containing a text-based copy of the eTicket.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                    /** 
                     * "PDF" is used to send an email notification containing a PDF-based copy of the eTicket.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PDF implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to request a PDF copy of the eTicket.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to request a PDF copy of the eTicket.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                }
                /** 
                 * "Invoice" is used to send an email notification containing a text-based copy of the invoice. Invoice cannot combine with .../eTicket, or .../Itinerary.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Invoice implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. Ucontaining a text-based copy of the invoice.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Ucontaining a text-based copy of the invoice.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * "Itinerary" is used to send an email notification containing a text-based copy of the itinerary. Itinerary cannot combine with .../eTicket, or .../Invoice.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Itinerary" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PDF" minOccurs="0">
                 *         &lt;!-- Reference to inner class PDF -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Segment -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Itinerary implements Serializable
                {
                    private PDF PDF1;
                    private List<Segment> segmentList = new ArrayList<Segment>();
                    private boolean ind;

                    /** 
                     * Get the 'PDF' element value.
                     * 
                     * @return value
                     */
                    public PDF getPDF1() {
                        return PDF1;
                    }

                    /** 
                     * Set the 'PDF' element value.
                     * 
                     * @param PDF1
                     */
                    public void setPDF1(PDF PDF1) {
                        this.PDF1 = PDF1;
                    }

                    /** 
                     * Get the list of 'Segment' element items.
                     * 
                     * @return list
                     */
                    public List<Segment> getSegmentList() {
                        return segmentList;
                    }

                    /** 
                     * Set the list of 'Segment' element items.
                     * 
                     * @param list
                     */
                    public void setSegmentList(List<Segment> list) {
                        segmentList = list;
                    }

                    /** 
                     * Get the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the itinerary.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Used to send an email notification containing a text-based copy of the itinerary.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                    /** 
                     * "PDF" is used to send an email notification containing a PDF-based copy of the itinerary.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PDF implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Used to send an email notification containing a PDF-based copy of the itinerary.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Used to send an email notification containing a PDF-based copy of the itinerary.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                     *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Segment implements Serializable
                    {
                        private BigInteger endNumber;
                        private BigInteger number;

                        /** 
                         * Get the 'EndNumber' attribute value. "EndNumber" is used to specify an ending segment in the range to include in the email message.
                         * 
                         * @return value
                         */
                        public BigInteger getEndNumber() {
                            return endNumber;
                        }

                        /** 
                         * Set the 'EndNumber' attribute value. "EndNumber" is used to specify an ending segment in the range to include in the email message.
                         * 
                         * @param endNumber
                         */
                        public void setEndNumber(BigInteger endNumber) {
                            this.endNumber = endNumber;
                        }

                        /** 
                         * Get the 'Number' attribute value. "Number" is used to specify a segment number to include in the email message.
                         * 
                         * @return value
                         */
                        public BigInteger getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value. "Number" is used to specify a segment number to include in the email message.
                         * 
                         * @param number
                         */
                        public void setNumber(BigInteger number) {
                            this.number = number;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PersonName implements Serializable
                {
                    private String nameNumber;

                    /** 
                     * Get the 'NameNumber' attribute value. "NameNumber" is used to specify a particular passenger name number to send the email notification to. Please note that the email address in the PNR's email field must be name associated to the specified name number.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. "NameNumber" is used to specify a particular passenger name number to send the email notification to. Please note that the email address in the PNR's email field must be name associated to the specified name number.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                }
            }
        }
        /** 
         * Specifies the wait interval before committing changes to the ticket in the instance of system encountering 'CREDIT VERIFICATION' message.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreditVerificationInterval" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" name="waitInterval"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CreditVerificationInterval implements Serializable
        {
            private BigInteger waitInterval;

            /** 
             * Get the 'waitInterval' attribute value.
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'waitInterval' attribute value.
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GhostTicketCheck" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" name="waitInterval"/>
         *     &lt;xs:attribute type="xs:integer" name="numAttempts"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class GhostTicketCheck implements Serializable
        {
            private BigInteger waitInterval;
            private BigInteger numAttempts;

            /** 
             * Get the 'waitInterval' attribute value.
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'waitInterval' attribute value.
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }

            /** 
             * Get the 'numAttempts' attribute value.
             * 
             * @return value
             */
            public BigInteger getNumAttempts() {
                return numAttempts;
            }

            /** 
             * Set the 'numAttempts' attribute value.
             * 
             * @param numAttempts
             */
            public void setNumAttempts(BigInteger numAttempts) {
                this.numAttempts = numAttempts;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInterval" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" name="waitInterval"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketingInterval implements Serializable
        {
            private BigInteger waitInterval;

            /** 
             * Get the 'waitInterval' attribute value.
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'waitInterval' attribute value.
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="O"/>
         *     &lt;xs:enumeration value="Q"/>
         *     &lt;xs:enumeration value="R"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum ActionOnPQExpired implements Serializable {
            O, Q, R
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="O"/>
         *     &lt;xs:enumeration value="Q"/>
         *     &lt;xs:enumeration value="R"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum ActionOnBackDatePrice implements Serializable {
            O, Q, R
        }
    }
}
