
package com.sabre.services.sp.air.ticket.v13;

import com.sabre.services.stlpayload.v0201.STLResponsePayload1;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:ns1="http://services.sabre.com/STL_Payload/v02_01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTicketRS">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns1:STL_Response_Payload">
 *         &lt;xs:sequence>
 *           &lt;xs:element name="Summary" minOccurs="0" maxOccurs="unbounded">
 *             &lt;!-- Reference to inner class Summary -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="Diagnostics" minOccurs="0">
 *             &lt;!-- Reference to inner class Diagnostics -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirTicketRS extends STLResponsePayload1 implements Serializable
{
    private List<Summary> summaryList = new ArrayList<Summary>();
    private Diagnostics diagnostics;

    /** 
     * Get the list of 'Summary' element items.
     * 
     * @return list
     */
    public List<Summary> getSummaryList() {
        return summaryList;
    }

    /** 
     * Set the list of 'Summary' element items.
     * 
     * @param list
     */
    public void setSummaryList(List<Summary> list) {
        summaryList = list;
    }

    /** 
     * Get the 'Diagnostics' element value.
     * 
     * @return value
     */
    public Diagnostics getDiagnostics() {
        return diagnostics;
    }

    /** 
     * Set the 'Diagnostics' element value.
     * 
     * @param diagnostics
     */
    public void setDiagnostics(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }
    /** 
     * "Summary" element is used to return a summary information about the documents that were found.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Summary" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0"/>
     *       &lt;xs:element type="xs:dateTime" name="LocalIssueDateTime" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="DocumentType" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="IssuingLocation" minOccurs="0"/>
     *       &lt;xs:element name="Reservation" minOccurs="0">
     *         &lt;!-- Reference to inner class Reservation -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="FirstName" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LastName" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="DocumentStatus" minOccurs="0"/>
     *       &lt;xs:element name="TotalAmount" minOccurs="0">
     *         &lt;!-- Reference to inner class TotalAmount -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="committed"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Summary implements Serializable
    {
        private String documentNumber;
        private Date localIssueDateTime;
        private String documentType;
        private String issuingLocation;
        private Reservation reservation;
        private String firstName;
        private String lastName;
        private String documentStatus;
        private TotalAmount totalAmount;
        private Boolean committed;

        /** 
         * Get the 'DocumentNumber' element value. Document serial number.
         * 
         * @return value
         */
        public String getDocumentNumber() {
            return documentNumber;
        }

        /** 
         * Set the 'DocumentNumber' element value. Document serial number.
         * 
         * @param documentNumber
         */
        public void setDocumentNumber(String documentNumber) {
            this.documentNumber = documentNumber;
        }

        /** 
         * Get the 'LocalIssueDateTime' element value. Document issue date and time - in local time zone of the station that issued it.
         * 
         * @return value
         */
        public Date getLocalIssueDateTime() {
            return localIssueDateTime;
        }

        /** 
         * Set the 'LocalIssueDateTime' element value. Document issue date and time - in local time zone of the station that issued it.
         * 
         * @param localIssueDateTime
         */
        public void setLocalIssueDateTime(Date localIssueDateTime) {
            this.localIssueDateTime = localIssueDateTime;
        }

        /** 
         * Get the 'DocumentType' element value. Document type. Possible values are TKT, MSR and EMD.
         * 
         * @return value
         */
        public String getDocumentType() {
            return documentType;
        }

        /** 
         * Set the 'DocumentType' element value. Document type. Possible values are TKT, MSR and EMD.
         * 
         * @param documentType
         */
        public void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        /** 
         * Get the 'IssuingLocation' element value. Station location code (usually city code) of the station that issued the document.
         * 
         * @return value
         */
        public String getIssuingLocation() {
            return issuingLocation;
        }

        /** 
         * Set the 'IssuingLocation' element value. Station location code (usually city code) of the station that issued the document.
         * 
         * @param issuingLocation
         */
        public void setIssuingLocation(String issuingLocation) {
            this.issuingLocation = issuingLocation;
        }

        /** 
         * Get the 'Reservation' element value.
         * 
         * @return value
         */
        public Reservation getReservation() {
            return reservation;
        }

        /** 
         * Set the 'Reservation' element value.
         * 
         * @param reservation
         */
        public void setReservation(Reservation reservation) {
            this.reservation = reservation;
        }

        /** 
         * Get the 'FirstName' element value. First name of the customer.
         * 
         * @return value
         */
        public String getFirstName() {
            return firstName;
        }

        /** 
         * Set the 'FirstName' element value. First name of the customer.
         * 
         * @param firstName
         */
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        /** 
         * Get the 'LastName' element value. Last name (family name or surname) of the customer.
         * 
         * @return value
         */
        public String getLastName() {
            return lastName;
        }

        /** 
         * Set the 'LastName' element value. Last name (family name or surname) of the customer.
         * 
         * @param lastName
         */
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        /** 
         * Get the 'DocumentStatus' element value. Status of the document found (of the whole document, not particular coupon). Possible values:
        											V - VOIDED
        											E - EXCHANGED
        											R - REFUNDED
        										
         * 
         * @return value
         */
        public String getDocumentStatus() {
            return documentStatus;
        }

        /** 
         * Set the 'DocumentStatus' element value. Status of the document found (of the whole document, not particular coupon). Possible values:
        											V - VOIDED
        											E - EXCHANGED
        											R - REFUNDED
        										
         * 
         * @param documentStatus
         */
        public void setDocumentStatus(String documentStatus) {
            this.documentStatus = documentStatus;
        }

        /** 
         * Get the 'TotalAmount' element value.
         * 
         * @return value
         */
        public TotalAmount getTotalAmount() {
            return totalAmount;
        }

        /** 
         * Set the 'TotalAmount' element value.
         * 
         * @param totalAmount
         */
        public void setTotalAmount(TotalAmount totalAmount) {
            this.totalAmount = totalAmount;
        }

        /** 
         * Get the 'committed' attribute value. commited="true" indicates that the ticket number has been commited to the face of the PNR
         * 
         * @return value
         */
        public Boolean getCommitted() {
            return committed;
        }

        /** 
         * Set the 'committed' attribute value. commited="true" indicates that the ticket number has been commited to the face of the PNR
         * 
         * @param committed
         */
        public void setCommitted(Boolean committed) {
            this.committed = committed;
        }
        /** 
         * PNR locator of the PNR containing this document. Returned if the document is a part of a PNR.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reservation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="provider"/>
         *         &lt;xs:attribute type="xs:dateTime" name="purgeDate"/>
         *         &lt;xs:attribute type="xs:dateTime" name="createDate"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Reservation implements Serializable
        {
            private String string;
            private String provider;
            private Date purgeDate;
            private Date createDate;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'provider' attribute value. Attribute provider informs about the code of the airline that owns the PNR. Optional.
             * 
             * @return value
             */
            public String getProvider() {
                return provider;
            }

            /** 
             * Set the 'provider' attribute value. Attribute provider informs about the code of the airline that owns the PNR. Optional.
             * 
             * @param provider
             */
            public void setProvider(String provider) {
                this.provider = provider;
            }

            /** 
             * Get the 'purgeDate' attribute value. Attribute purgeDate informs about the purge date of the  PNR. Optional.
             * 
             * @return value
             */
            public Date getPurgeDate() {
                return purgeDate;
            }

            /** 
             * Set the 'purgeDate' attribute value. Attribute purgeDate informs about the purge date of the  PNR. Optional.
             * 
             * @param purgeDate
             */
            public void setPurgeDate(Date purgeDate) {
                this.purgeDate = purgeDate;
            }

            /** 
             * Get the 'createDate' attribute value. Attribute createDate informs about the creation date of the  PNR. Optional.
             * 
             * @return value
             */
            public Date getCreateDate() {
                return createDate;
            }

            /** 
             * Set the 'createDate' attribute value. Attribute createDate informs about the creation date of the  PNR. Optional.
             * 
             * @param createDate
             */
            public void setCreateDate(Date createDate) {
                this.createDate = createDate;
            }
        }
        /** 
         * Total amount of money paid for this document.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalAmount" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
         *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TotalAmount implements Serializable
        {
            private String string;
            private String currencyCode;
            private BigInteger decimalPlace;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'currencyCode' attribute value. "currencyCode" is the code of the currency in which the amount is expressed.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'currencyCode' attribute value. "currencyCode" is the code of the currency in which the amount is expressed.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'decimalPlace' attribute value. "decimalPlace" indicates the number of decimal places required by the currency.
             * 
             * @return value
             */
            public BigInteger getDecimalPlace() {
                return decimalPlace;
            }

            /** 
             * Set the 'decimalPlace' attribute value. "decimalPlace" indicates the number of decimal places required by the currency.
             * 
             * @param decimalPlace
             */
            public void setDecimalPlace(BigInteger decimalPlace) {
                this.decimalPlace = decimalPlace;
            }
        }
    }
    /** 
     * For internal use only
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/air/ticket/v1_3" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostics" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ESSM_Data">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:boolean" default="false" name="AutoEnd"/>
     *             &lt;xs:element type="xs:boolean" default="false" name="AutoEndAndRetrieve"/>
     *             &lt;xs:element type="xs:boolean" default="false" name="AbacusPrimeHost"/>
     *             &lt;xs:element type="xs:boolean" default="false" name="InfiniPrimeHost"/>
     *             &lt;xs:element type="xs:boolean" default="false" name="AutoEndDetected"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Diagnostics implements Serializable
    {
        private boolean ESSMDataAutoEnd;
        private boolean ESSMDataAutoEndAndRetrieve;
        private boolean ESSMDataAbacusPrimeHost;
        private boolean ESSMDataInfiniPrimeHost;
        private boolean ESSMDataAutoEndDetected;

        /** 
         * Get the 'AutoEnd' element value. AutoEnd - for internal use only
         * 
         * @return value
         */
        public boolean isESSMDataAutoEnd() {
            return ESSMDataAutoEnd;
        }

        /** 
         * Set the 'AutoEnd' element value. AutoEnd - for internal use only
         * 
         * @param ESSMDataAutoEnd
         */
        public void setESSMDataAutoEnd(boolean ESSMDataAutoEnd) {
            this.ESSMDataAutoEnd = ESSMDataAutoEnd;
        }

        /** 
         * Get the 'AutoEndAndRetrieve' element value. AutoEndAndRetrieve - for internal use only
         * 
         * @return value
         */
        public boolean isESSMDataAutoEndAndRetrieve() {
            return ESSMDataAutoEndAndRetrieve;
        }

        /** 
         * Set the 'AutoEndAndRetrieve' element value. AutoEndAndRetrieve - for internal use only
         * 
         * @param ESSMDataAutoEndAndRetrieve
         */
        public void setESSMDataAutoEndAndRetrieve(
                boolean ESSMDataAutoEndAndRetrieve) {
            this.ESSMDataAutoEndAndRetrieve = ESSMDataAutoEndAndRetrieve;
        }

        /** 
         * Get the 'AbacusPrimeHost' element value. AbacusPrimeHost - for internal use only
         * 
         * @return value
         */
        public boolean isESSMDataAbacusPrimeHost() {
            return ESSMDataAbacusPrimeHost;
        }

        /** 
         * Set the 'AbacusPrimeHost' element value. AbacusPrimeHost - for internal use only
         * 
         * @param ESSMDataAbacusPrimeHost
         */
        public void setESSMDataAbacusPrimeHost(boolean ESSMDataAbacusPrimeHost) {
            this.ESSMDataAbacusPrimeHost = ESSMDataAbacusPrimeHost;
        }

        /** 
         * Get the 'InfiniPrimeHost' element value. InfiniPrimeHost - for internal use only
         * 
         * @return value
         */
        public boolean isESSMDataInfiniPrimeHost() {
            return ESSMDataInfiniPrimeHost;
        }

        /** 
         * Set the 'InfiniPrimeHost' element value. InfiniPrimeHost - for internal use only
         * 
         * @param ESSMDataInfiniPrimeHost
         */
        public void setESSMDataInfiniPrimeHost(boolean ESSMDataInfiniPrimeHost) {
            this.ESSMDataInfiniPrimeHost = ESSMDataInfiniPrimeHost;
        }

        /** 
         * Get the 'AutoEndDetected' element value. AutoEndDetected - for internal use only
         * 
         * @return value
         */
        public boolean isESSMDataAutoEndDetected() {
            return ESSMDataAutoEndDetected;
        }

        /** 
         * Set the 'AutoEndDetected' element value. AutoEndDetected - for internal use only
         * 
         * @param ESSMDataAutoEndDetected
         */
        public void setESSMDataAutoEndDetected(boolean ESSMDataAutoEndDetected) {
            this.ESSMDataAutoEndDetected = ESSMDataAutoEndDetected;
        }
    }
}
