
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information about the person traveling. Gender - the gender of the customer,
 if needed. BirthDate - Date of Birth. Currency - the preferred currency in which monetary amounts should be returned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTravelerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CustLoyaltyType" name="CustLoyalty" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:PassengerTypeQuantityType" name="PassengerTypeQuantity" minOccurs="0"/>
 *     &lt;xs:element type="ns:TravelerRefNumberType" name="TravelerRefNumber"/>
 *     &lt;xs:element type="ns:FlightSegmentRPHsType" name="FlightSegmentRPHs" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="currencyCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="passengerTypeCode"/>
 *   &lt;xs:attribute type="xs:boolean" name="accompaniedByInfant"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirTravelerType implements Serializable
{
    private List<CustLoyaltyType> custLoyaltyList = new ArrayList<CustLoyaltyType>();
    private PassengerTypeQuantityType passengerTypeQuantity;
    private TravelerRefNumberType travelerRefNumber;
    private FlightSegmentRPHsType flightSegmentRPHs;
    private String currencyCode;
    private String passengerTypeCode;
    private Boolean accompaniedByInfant;

    /** 
     * Get the list of 'CustLoyalty' element items. Specify a customer loyalty program.
     * 
     * @return list
     */
    public List<CustLoyaltyType> getCustLoyaltyList() {
        return custLoyaltyList;
    }

    /** 
     * Set the list of 'CustLoyalty' element items. Specify a customer loyalty program.
     * 
     * @param list
     */
    public void setCustLoyaltyList(List<CustLoyaltyType> list) {
        custLoyaltyList = list;
    }

    /** 
     * Get the 'PassengerTypeQuantity' element value. Define information on the number of passengers of a specific type.
     * 
     * @return value
     */
    public PassengerTypeQuantityType getPassengerTypeQuantity() {
        return passengerTypeQuantity;
    }

    /** 
     * Set the 'PassengerTypeQuantity' element value. Define information on the number of passengers of a specific type.
     * 
     * @param passengerTypeQuantity
     */
    public void setPassengerTypeQuantity(
            PassengerTypeQuantityType passengerTypeQuantity) {
        this.passengerTypeQuantity = passengerTypeQuantity;
    }

    /** 
     * Get the 'TravelerRefNumber' element value. Direct reference of traveler assigned by requesting system.
                          Used as a cross reference between data segments.
     * 
     * @return value
     */
    public TravelerRefNumberType getTravelerRefNumber() {
        return travelerRefNumber;
    }

    /** 
     * Set the 'TravelerRefNumber' element value. Direct reference of traveler assigned by requesting system.
                          Used as a cross reference between data segments.
     * 
     * @param travelerRefNumber
     */
    public void setTravelerRefNumber(TravelerRefNumberType travelerRefNumber) {
        this.travelerRefNumber = travelerRefNumber;
    }

    /** 
     * Get the 'FlightSegmentRPHs' element value. Reference pointers to flight segments
     * 
     * @return value
     */
    public FlightSegmentRPHsType getFlightSegmentRPHs() {
        return flightSegmentRPHs;
    }

    /** 
     * Set the 'FlightSegmentRPHs' element value. Reference pointers to flight segments
     * 
     * @param flightSegmentRPHs
     */
    public void setFlightSegmentRPHs(FlightSegmentRPHsType flightSegmentRPHs) {
        this.flightSegmentRPHs = flightSegmentRPHs;
    }

    /** 
     * Get the 'currencyCode' attribute value. The preferred currency in which monetary amounts should be returned.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value. The preferred currency in which monetary amounts should be returned.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'passengerTypeCode' attribute value. A three-letter code representing passenger type (e.g. .ADT. for adult, .CNN. for child)
     * 
     * @return value
     */
    public String getPassengerTypeCode() {
        return passengerTypeCode;
    }

    /** 
     * Set the 'passengerTypeCode' attribute value. A three-letter code representing passenger type (e.g. .ADT. for adult, .CNN. for child)
     * 
     * @param passengerTypeCode
     */
    public void setPassengerTypeCode(String passengerTypeCode) {
        this.passengerTypeCode = passengerTypeCode;
    }

    /** 
     * Get the 'accompaniedByInfant' attribute value. Indicates if an infant accompanying a traveler is with or without a seat.
     * 
     * @return value
     */
    public Boolean getAccompaniedByInfant() {
        return accompaniedByInfant;
    }

    /** 
     * Set the 'accompaniedByInfant' attribute value. Indicates if an infant accompanying a traveler is with or without a seat.
     * 
     * @param accompaniedByInfant
     */
    public void setAccompaniedByInfant(Boolean accompaniedByInfant) {
        this.accompaniedByInfant = accompaniedByInfant;
    }
}
