
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicAncillaryServicesDataGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CommercialName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RficCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RficSubcode"/>
 *     &lt;xs:element type="xs:string" name="SSRCode" minOccurs="0"/>
 *     &lt;xs:element name="ProductTextDetails" minOccurs="0">
 *       &lt;!-- Reference to inner class ProductTextDetails -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ProductText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OwningCarrierCode"/>
 *     &lt;xs:element type="xs:string" name="SsimCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BookingIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Vendor" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDCoupon" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryServiceETicketNumberUpdate" name="ETicketNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceFeeLineNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="DisplayOnlyIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ConsumptionIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PresentTo" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AtCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Endorsements" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StationIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceCityDestination" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceType" minOccurs="0"/>
 *     &lt;xs:element name="RuleSet" minOccurs="0">
 *       &lt;!-- Reference to inner class RuleSet -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OriginalPrice" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginalPrice -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:byte" name="NewMiscIndicator" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class BasicAncillaryServicesDataGroup implements Serializable
{
    private String commercialName;
    private String rficCode;
    private String rficSubcode;
    private String SSRCode;
    private ProductTextDetails productTextDetails;
    private String productText;
    private String owningCarrierCode;
    private String ssimCode;
    private String bookingIndicator;
    private String vendor;
    private String EMDType;
    private String EMDNumber;
    private String EMDCoupon;
    private AncillaryServiceETicketNumberUpdate ETicketNumber;
    private String serviceFeeLineNumber;
    private Boolean displayOnlyIndicator;
    private String consumptionIndicator;
    private String presentTo;
    private String atCity;
    private String endorsements;
    private String stationIndicator;
    private String serviceCity;
    private String serviceCityDestination;
    private String serviceType;
    private RuleSet ruleSet;
    private OriginalPrice originalPrice;
    private Byte newMiscIndicator;

    /** 
     * Get the 'CommercialName' element value.
     * 
     * @return value
     */
    public String getCommercialName() {
        return commercialName;
    }

    /** 
     * Set the 'CommercialName' element value.
     * 
     * @param commercialName
     */
    public void setCommercialName(String commercialName) {
        this.commercialName = commercialName;
    }

    /** 
     * Get the 'RficCode' element value.
     * 
     * @return value
     */
    public String getRficCode() {
        return rficCode;
    }

    /** 
     * Set the 'RficCode' element value.
     * 
     * @param rficCode
     */
    public void setRficCode(String rficCode) {
        this.rficCode = rficCode;
    }

    /** 
     * Get the 'RficSubcode' element value.
     * 
     * @return value
     */
    public String getRficSubcode() {
        return rficSubcode;
    }

    /** 
     * Set the 'RficSubcode' element value.
     * 
     * @param rficSubcode
     */
    public void setRficSubcode(String rficSubcode) {
        this.rficSubcode = rficSubcode;
    }

    /** 
     * Get the 'SSRCode' element value.
     * 
     * @return value
     */
    public String getSSRCode() {
        return SSRCode;
    }

    /** 
     * Set the 'SSRCode' element value.
     * 
     * @param SSRCode
     */
    public void setSSRCode(String SSRCode) {
        this.SSRCode = SSRCode;
    }

    /** 
     * Get the 'ProductTextDetails' element value.
     * 
     * @return value
     */
    public ProductTextDetails getProductTextDetails() {
        return productTextDetails;
    }

    /** 
     * Set the 'ProductTextDetails' element value.
     * 
     * @param productTextDetails
     */
    public void setProductTextDetails(ProductTextDetails productTextDetails) {
        this.productTextDetails = productTextDetails;
    }

    /** 
     * Get the 'ProductText' element value. ProductTextDetails and ProductText are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public String getProductText() {
        return productText;
    }

    /** 
     * Set the 'ProductText' element value. ProductTextDetails and ProductText are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param productText
     */
    public void setProductText(String productText) {
        this.productText = productText;
    }

    /** 
     * Get the 'OwningCarrierCode' element value.
     * 
     * @return value
     */
    public String getOwningCarrierCode() {
        return owningCarrierCode;
    }

    /** 
     * Set the 'OwningCarrierCode' element value.
     * 
     * @param owningCarrierCode
     */
    public void setOwningCarrierCode(String owningCarrierCode) {
        this.owningCarrierCode = owningCarrierCode;
    }

    /** 
     * Get the 'SsimCode' element value.
     * 
     * @return value
     */
    public String getSsimCode() {
        return ssimCode;
    }

    /** 
     * Set the 'SsimCode' element value.
     * 
     * @param ssimCode
     */
    public void setSsimCode(String ssimCode) {
        this.ssimCode = ssimCode;
    }

    /** 
     * Get the 'BookingIndicator' element value.
     * 
     * @return value
     */
    public String getBookingIndicator() {
        return bookingIndicator;
    }

    /** 
     * Set the 'BookingIndicator' element value.
     * 
     * @param bookingIndicator
     */
    public void setBookingIndicator(String bookingIndicator) {
        this.bookingIndicator = bookingIndicator;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public String getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'EMDType' element value.
     * 
     * @return value
     */
    public String getEMDType() {
        return EMDType;
    }

    /** 
     * Set the 'EMDType' element value.
     * 
     * @param EMDType
     */
    public void setEMDType(String EMDType) {
        this.EMDType = EMDType;
    }

    /** 
     * Get the 'EMDNumber' element value.
     * 
     * @return value
     */
    public String getEMDNumber() {
        return EMDNumber;
    }

    /** 
     * Set the 'EMDNumber' element value.
     * 
     * @param EMDNumber
     */
    public void setEMDNumber(String EMDNumber) {
        this.EMDNumber = EMDNumber;
    }

    /** 
     * Get the 'EMDCoupon' element value.
     * 
     * @return value
     */
    public String getEMDCoupon() {
        return EMDCoupon;
    }

    /** 
     * Set the 'EMDCoupon' element value.
     * 
     * @param EMDCoupon
     */
    public void setEMDCoupon(String EMDCoupon) {
        this.EMDCoupon = EMDCoupon;
    }

    /** 
     * Get the 'ETicketNumber' element value.
     * 
     * @return value
     */
    public AncillaryServiceETicketNumberUpdate getETicketNumber() {
        return ETicketNumber;
    }

    /** 
     * Set the 'ETicketNumber' element value.
     * 
     * @param ETicketNumber
     */
    public void setETicketNumber(
            AncillaryServiceETicketNumberUpdate ETicketNumber) {
        this.ETicketNumber = ETicketNumber;
    }

    /** 
     * Get the 'ServiceFeeLineNumber' element value.
     * 
     * @return value
     */
    public String getServiceFeeLineNumber() {
        return serviceFeeLineNumber;
    }

    /** 
     * Set the 'ServiceFeeLineNumber' element value.
     * 
     * @param serviceFeeLineNumber
     */
    public void setServiceFeeLineNumber(String serviceFeeLineNumber) {
        this.serviceFeeLineNumber = serviceFeeLineNumber;
    }

    /** 
     * Get the 'DisplayOnlyIndicator' element value.
     * 
     * @return value
     */
    public Boolean getDisplayOnlyIndicator() {
        return displayOnlyIndicator;
    }

    /** 
     * Set the 'DisplayOnlyIndicator' element value.
     * 
     * @param displayOnlyIndicator
     */
    public void setDisplayOnlyIndicator(Boolean displayOnlyIndicator) {
        this.displayOnlyIndicator = displayOnlyIndicator;
    }

    /** 
     * Get the 'ConsumptionIndicator' element value.
     * 
     * @return value
     */
    public String getConsumptionIndicator() {
        return consumptionIndicator;
    }

    /** 
     * Set the 'ConsumptionIndicator' element value.
     * 
     * @param consumptionIndicator
     */
    public void setConsumptionIndicator(String consumptionIndicator) {
        this.consumptionIndicator = consumptionIndicator;
    }

    /** 
     * Get the 'PresentTo' element value.
     * 
     * @return value
     */
    public String getPresentTo() {
        return presentTo;
    }

    /** 
     * Set the 'PresentTo' element value.
     * 
     * @param presentTo
     */
    public void setPresentTo(String presentTo) {
        this.presentTo = presentTo;
    }

    /** 
     * Get the 'AtCity' element value.
     * 
     * @return value
     */
    public String getAtCity() {
        return atCity;
    }

    /** 
     * Set the 'AtCity' element value.
     * 
     * @param atCity
     */
    public void setAtCity(String atCity) {
        this.atCity = atCity;
    }

    /** 
     * Get the 'Endorsements' element value.
     * 
     * @return value
     */
    public String getEndorsements() {
        return endorsements;
    }

    /** 
     * Set the 'Endorsements' element value.
     * 
     * @param endorsements
     */
    public void setEndorsements(String endorsements) {
        this.endorsements = endorsements;
    }

    /** 
     * Get the 'StationIndicator' element value.
     * 
     * @return value
     */
    public String getStationIndicator() {
        return stationIndicator;
    }

    /** 
     * Set the 'StationIndicator' element value.
     * 
     * @param stationIndicator
     */
    public void setStationIndicator(String stationIndicator) {
        this.stationIndicator = stationIndicator;
    }

    /** 
     * Get the 'ServiceCity' element value.
     * 
     * @return value
     */
    public String getServiceCity() {
        return serviceCity;
    }

    /** 
     * Set the 'ServiceCity' element value.
     * 
     * @param serviceCity
     */
    public void setServiceCity(String serviceCity) {
        this.serviceCity = serviceCity;
    }

    /** 
     * Get the 'ServiceCityDestination' element value. Destination city or off point, Ex "BLR"
     * 
     * @return value
     */
    public String getServiceCityDestination() {
        return serviceCityDestination;
    }

    /** 
     * Set the 'ServiceCityDestination' element value. Destination city or off point, Ex "BLR"
     * 
     * @param serviceCityDestination
     */
    public void setServiceCityDestination(String serviceCityDestination) {
        this.serviceCityDestination = serviceCityDestination;
    }

    /** 
     * Get the 'ServiceType' element value. Need to know the Service Type to e.g. 'A'llowance - indicate registered bag that is part of allowance;
                          'C'harges; 'F'light Related; 'P'repaid
     * 
     * @return value
     */
    public String getServiceType() {
        return serviceType;
    }

    /** 
     * Set the 'ServiceType' element value. Need to know the Service Type to e.g. 'A'llowance - indicate registered bag that is part of allowance;
                          'C'harges; 'F'light Related; 'P'repaid
     * 
     * @param serviceType
     */
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    /** 
     * Get the 'RuleSet' element value.
     * 
     * @return value
     */
    public RuleSet getRuleSet() {
        return ruleSet;
    }

    /** 
     * Set the 'RuleSet' element value.
     * 
     * @param ruleSet
     */
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    /** 
     * Get the 'OriginalPrice' element value.
     * 
     * @return value
     */
    public OriginalPrice getOriginalPrice() {
        return originalPrice;
    }

    /** 
     * Set the 'OriginalPrice' element value.
     * 
     * @param originalPrice
     */
    public void setOriginalPrice(OriginalPrice originalPrice) {
        this.originalPrice = originalPrice;
    }

    /** 
     * Get the 'NewMiscIndicator' element value.
     * 
     * @return value
     */
    public Byte getNewMiscIndicator() {
        return newMiscIndicator;
    }

    /** 
     * Set the 'NewMiscIndicator' element value.
     * 
     * @param newMiscIndicator
     */
    public void setNewMiscIndicator(Byte newMiscIndicator) {
        this.newMiscIndicator = newMiscIndicator;
    }
    /** 
     * ProductTextDetails and ProductText are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductTextDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ProductTextDetailsItem" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ProductTextDetailsItem -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProductTextDetails implements Serializable
    {
        private List<ProductTextDetailsItem> productTextDetailsItemList = new ArrayList<ProductTextDetailsItem>();

        /** 
         * Get the list of 'ProductTextDetailsItem' element items.
         * 
         * @return list
         */
        public List<ProductTextDetailsItem> getProductTextDetailsItemList() {
            return productTextDetailsItemList;
        }

        /** 
         * Set the list of 'ProductTextDetailsItem' element items.
         * 
         * @param list
         */
        public void setProductTextDetailsItemList(
                List<ProductTextDetailsItem> list) {
            productTextDetailsItemList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductTextDetailsItem" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="ItemName"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="ItemValue"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ProductTextDetailsItem implements Serializable
        {
            private String itemName;
            private String itemValue;

            /** 
             * Get the 'ItemName' attribute value.
             * 
             * @return value
             */
            public String getItemName() {
                return itemName;
            }

            /** 
             * Set the 'ItemName' attribute value.
             * 
             * @param itemName
             */
            public void setItemName(String itemName) {
                this.itemName = itemName;
            }

            /** 
             * Get the 'ItemValue' attribute value.
             * 
             * @return value
             */
            public String getItemValue() {
                return itemValue;
            }

            /** 
             * Set the 'ItemValue' attribute value.
             * 
             * @param itemValue
             */
            public void setItemValue(String itemValue) {
                this.itemValue = itemValue;
            }
        }
    }
    /** 
     * Needed to keep track of companion benefits for example. Will come from the Rules Processor
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleSet" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="RuleName" minOccurs="0"/>
     *       &lt;xs:element name="Deal" minOccurs="0">
     *         &lt;!-- Reference to inner class Deal -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:unsignedLong" name="RuleId"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleSet implements Serializable
    {
        private String ruleName;
        private Deal deal;
        private String ruleId;

        /** 
         * Get the 'RuleName' element value.
         * 
         * @return value
         */
        public String getRuleName() {
            return ruleName;
        }

        /** 
         * Set the 'RuleName' element value.
         * 
         * @param ruleName
         */
        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        /** 
         * Get the 'Deal' element value.
         * 
         * @return value
         */
        public Deal getDeal() {
            return deal;
        }

        /** 
         * Set the 'Deal' element value.
         * 
         * @param deal
         */
        public void setDeal(Deal deal) {
            this.deal = deal;
        }

        /** 
         * Get the 'RuleId' attribute value.
         * 
         * @return value
         */
        public String getRuleId() {
            return ruleId;
        }

        /** 
         * Set the 'RuleId' attribute value.
         * 
         * @param ruleId
         */
        public void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }
        /** 
         * Information about applied discount/markup for this ancillary
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deal" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
         *       &lt;xs:element name="Amount" minOccurs="0">
         *         &lt;!-- Reference to inner class Amount -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="required" name="type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Deal implements Serializable
        {
            private BigDecimal percentage;
            private Amount amount;
            private Type type;

            /** 
             * Get the 'Percentage' element value. Percentage as defined in RULE for percentage discounts/markups.
                                                      Percentage and Amount are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                                                      For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
             * 
             * @return value
             */
            public BigDecimal getPercentage() {
                return percentage;
            }

            /** 
             * Set the 'Percentage' element value. Percentage as defined in RULE for percentage discounts/markups.
                                                      Percentage and Amount are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                                                      For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
             * 
             * @param percentage
             */
            public void setPercentage(BigDecimal percentage) {
                this.percentage = percentage;
            }

            /** 
             * Get the 'Amount' element value.
             * 
             * @return value
             */
            public Amount getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value.
             * 
             * @param amount
             */
            public void setAmount(Amount amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'type' attribute value.
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value.
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }
            /** 
             * Amount as defined in RULE for monetary discounts/markups.
                                                      Percentage and Amount are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                                                      For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currency"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amount implements Serializable
            {
                private BigDecimal decimal;
                private String currency;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currency' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrency() {
                    return currency;
                }

                /** 
                 * Set the 'currency' attribute value.
                 * 
                 * @param currency
                 */
                public void setCurrency(String currency) {
                    this.currency = currency;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="DISCOUNT"/>
             *     &lt;xs:enumeration value="RISE"/>
             *     &lt;xs:enumeration value="OVERRIDE"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                DISCOUNT, RISE, OVERRIDE
            }
        }
    }
    /** 
     * Original Price from Pricing - will need to be persisted with the waiver code
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalPrice" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:decimal">
     *         &lt;xs:attribute type="xs:string" use="required" name="WaiverCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginalPrice implements Serializable
    {
        private BigDecimal decimal;
        private String waiverCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getDecimal() {
            return decimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param decimal
         */
        public void setDecimal(BigDecimal decimal) {
            this.decimal = decimal;
        }

        /** 
         * Get the 'WaiverCode' attribute value. To override the price, waiver code is required
         * 
         * @return value
         */
        public String getWaiverCode() {
            return waiverCode;
        }

        /** 
         * Set the 'WaiverCode' attribute value. To override the price, waiver code is required
         * 
         * @param waiverCode
         */
        public void setWaiverCode(String waiverCode) {
            this.waiverCode = waiverCode;
        }
    }
}
