
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingChannelType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CompanyNameType" name="CompanyName" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="Type"/>
 *   &lt;xs:attribute type="xs:boolean" name="Primary"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BookingChannelType implements Serializable
{
    private CompanyNameType companyName;
    private String type;
    private Boolean primary;

    /** 
     * Get the 'CompanyName' element value. Identifies the company that is associated with the booking channel.
     * 
     * @return value
     */
    public CompanyNameType getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' element value. Identifies the company that is associated with the booking channel.
     * 
     * @param companyName
     */
    public void setCompanyName(CompanyNameType companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'Type' attribute value. The type of booking channel
                      (e.g. Global Distribution System (GDS), Alternative Distribution System (ADS), Sales and Catering System (SCS),
                      Property Management System (PMS), Central Reservation System (CRS), Tour Operator System (TOS), Internet and ALL).
                      Refer to OTA Code List Booking Channel Type (BCT).
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. The type of booking channel
                      (e.g. Global Distribution System (GDS), Alternative Distribution System (ADS), Sales and Catering System (SCS),
                      Property Management System (PMS), Central Reservation System (CRS), Tour Operator System (TOS), Internet and ALL).
                      Refer to OTA Code List Booking Channel Type (BCT).
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Primary' attribute value. Indicates whether the enumerated booking channel is the primary means of connectivity used by the source.
     * 
     * @return value
     */
    public Boolean getPrimary() {
        return primary;
    }

    /** 
     * Set the 'Primary' attribute value. Indicates whether the enumerated booking channel is the primary means of connectivity used by the source.
     * 
     * @param primary
     */
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }
}
