
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarRateQualifiersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Corporate" minOccurs="0">
 *       &lt;!-- Reference to inner class Corporate -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CustLoyalty" minOccurs="0">
 *       &lt;!-- Reference to inner class CustLoyalty -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="GuaranteePrepaid" minOccurs="0">
 *       &lt;!-- Reference to inner class GuaranteePrepaid -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ID" minOccurs="0">
 *       &lt;!-- Reference to inner class ID -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Promotion" minOccurs="0">
 *       &lt;!-- Reference to inner class Promotion -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="RateCode" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element name="TourCode" minOccurs="0">
 *       &lt;!-- Reference to inner class TourCode -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="VehiclePreferences" minOccurs="0">
 *       &lt;!-- Reference to inner class VehiclePreferences -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="LocationPreferences" minOccurs="0">
 *       &lt;!-- Reference to inner class LocationPreferences -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="VendorPreferences" minOccurs="0">
 *       &lt;!-- Reference to inner class VendorPreferences -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SpecialEquipmentPreferences" minOccurs="0">
 *       &lt;!-- Reference to inner class SpecialEquipmentPreferences -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="ccRate"/>
 *   &lt;xs:attribute type="xs:boolean" name="commission"/>
 *   &lt;xs:attribute type="xs:string" name="currencyCode"/>
 *   &lt;xs:attribute type="xs:string" name="mileagePlan"/>
 *   &lt;xs:attribute type="xs:boolean" name="rateAssured"/>
 *   &lt;xs:attribute type="xs:string" name="rateCategory"/>
 *   &lt;xs:attribute type="xs:string" name="ratePlan"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarRateQualifiersType implements Serializable
{
    private Corporate corporate;
    private CustLoyalty custLoyalty;
    private GuaranteePrepaid guaranteePrepaid;
    private ID ID1;
    private Promotion promotion;
    private List<String> rateCodeList = new ArrayList<String>();
    private TourCode tourCode;
    private VehiclePreferences vehiclePreferences;
    private LocationPreferences locationPreferences;
    private VendorPreferences vendorPreferences;
    private SpecialEquipmentPreferences specialEquipmentPreferences;
    private String ccRate;
    private Boolean commission;
    private String currencyCode;
    private String mileagePlan;
    private Boolean rateAssured;
    private String rateCategory;
    private String ratePlan;

    /** 
     * Get the 'Corporate' element value.
     * 
     * @return value
     */
    public Corporate getCorporate() {
        return corporate;
    }

    /** 
     * Set the 'Corporate' element value.
     * 
     * @param corporate
     */
    public void setCorporate(Corporate corporate) {
        this.corporate = corporate;
    }

    /** 
     * Get the 'CustLoyalty' element value.
     * 
     * @return value
     */
    public CustLoyalty getCustLoyalty() {
        return custLoyalty;
    }

    /** 
     * Set the 'CustLoyalty' element value.
     * 
     * @param custLoyalty
     */
    public void setCustLoyalty(CustLoyalty custLoyalty) {
        this.custLoyalty = custLoyalty;
    }

    /** 
     * Get the 'GuaranteePrepaid' element value.
     * 
     * @return value
     */
    public GuaranteePrepaid getGuaranteePrepaid() {
        return guaranteePrepaid;
    }

    /** 
     * Set the 'GuaranteePrepaid' element value.
     * 
     * @param guaranteePrepaid
     */
    public void setGuaranteePrepaid(GuaranteePrepaid guaranteePrepaid) {
        this.guaranteePrepaid = guaranteePrepaid;
    }

    /** 
     * Get the 'ID' element value.
     * 
     * @return value
     */
    public ID getID1() {
        return ID1;
    }

    /** 
     * Set the 'ID' element value.
     * 
     * @param ID1
     */
    public void setID1(ID ID1) {
        this.ID1 = ID1;
    }

    /** 
     * Get the 'Promotion' element value.
     * 
     * @return value
     */
    public Promotion getPromotion() {
        return promotion;
    }

    /** 
     * Set the 'Promotion' element value.
     * 
     * @param promotion
     */
    public void setPromotion(Promotion promotion) {
        this.promotion = promotion;
    }

    /** 
     * Get the list of 'RateCode' element items.
     * 
     * @return list
     */
    public List<String> getRateCodeList() {
        return rateCodeList;
    }

    /** 
     * Set the list of 'RateCode' element items.
     * 
     * @param list
     */
    public void setRateCodeList(List<String> list) {
        rateCodeList = list;
    }

    /** 
     * Get the 'TourCode' element value.
     * 
     * @return value
     */
    public TourCode getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value.
     * 
     * @param tourCode
     */
    public void setTourCode(TourCode tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'VehiclePreferences' element value.
     * 
     * @return value
     */
    public VehiclePreferences getVehiclePreferences() {
        return vehiclePreferences;
    }

    /** 
     * Set the 'VehiclePreferences' element value.
     * 
     * @param vehiclePreferences
     */
    public void setVehiclePreferences(VehiclePreferences vehiclePreferences) {
        this.vehiclePreferences = vehiclePreferences;
    }

    /** 
     * Get the 'LocationPreferences' element value.
     * 
     * @return value
     */
    public LocationPreferences getLocationPreferences() {
        return locationPreferences;
    }

    /** 
     * Set the 'LocationPreferences' element value.
     * 
     * @param locationPreferences
     */
    public void setLocationPreferences(LocationPreferences locationPreferences) {
        this.locationPreferences = locationPreferences;
    }

    /** 
     * Get the 'VendorPreferences' element value.
     * 
     * @return value
     */
    public VendorPreferences getVendorPreferences() {
        return vendorPreferences;
    }

    /** 
     * Set the 'VendorPreferences' element value.
     * 
     * @param vendorPreferences
     */
    public void setVendorPreferences(VendorPreferences vendorPreferences) {
        this.vendorPreferences = vendorPreferences;
    }

    /** 
     * Get the 'SpecialEquipmentPreferences' element value.
     * 
     * @return value
     */
    public SpecialEquipmentPreferences getSpecialEquipmentPreferences() {
        return specialEquipmentPreferences;
    }

    /** 
     * Set the 'SpecialEquipmentPreferences' element value.
     * 
     * @param specialEquipmentPreferences
     */
    public void setSpecialEquipmentPreferences(
            SpecialEquipmentPreferences specialEquipmentPreferences) {
        this.specialEquipmentPreferences = specialEquipmentPreferences;
    }

    /** 
     * Get the 'ccRate' attribute value.
     * 
     * @return value
     */
    public String getCcRate() {
        return ccRate;
    }

    /** 
     * Set the 'ccRate' attribute value.
     * 
     * @param ccRate
     */
    public void setCcRate(String ccRate) {
        this.ccRate = ccRate;
    }

    /** 
     * Get the 'commission' attribute value.
     * 
     * @return value
     */
    public Boolean getCommission() {
        return commission;
    }

    /** 
     * Set the 'commission' attribute value.
     * 
     * @param commission
     */
    public void setCommission(Boolean commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'currencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'mileagePlan' attribute value.
     * 
     * @return value
     */
    public String getMileagePlan() {
        return mileagePlan;
    }

    /** 
     * Set the 'mileagePlan' attribute value.
     * 
     * @param mileagePlan
     */
    public void setMileagePlan(String mileagePlan) {
        this.mileagePlan = mileagePlan;
    }

    /** 
     * Get the 'rateAssured' attribute value.
     * 
     * @return value
     */
    public Boolean getRateAssured() {
        return rateAssured;
    }

    /** 
     * Set the 'rateAssured' attribute value.
     * 
     * @param rateAssured
     */
    public void setRateAssured(Boolean rateAssured) {
        this.rateAssured = rateAssured;
    }

    /** 
     * Get the 'rateCategory' attribute value.
     * 
     * @return value
     */
    public String getRateCategory() {
        return rateCategory;
    }

    /** 
     * Set the 'rateCategory' attribute value.
     * 
     * @param rateCategory
     */
    public void setRateCategory(String rateCategory) {
        this.rateCategory = rateCategory;
    }

    /** 
     * Get the 'ratePlan' attribute value.
     * 
     * @return value
     */
    public String getRatePlan() {
        return ratePlan;
    }

    /** 
     * Set the 'ratePlan' attribute value.
     * 
     * @param ratePlan
     */
    public void setRatePlan(String ratePlan) {
        this.ratePlan = ratePlan;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ID" maxOccurs="50"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Corporate implements Serializable
    {
        private List<String> IDList = new ArrayList<String>();

        /** 
         * Get the list of 'ID' element items.
         * 
         * @return list
         */
        public List<String> getIDList() {
            return IDList;
        }

        /** 
         * Set the list of 'ID' element items.
         * 
         * @param list
         */
        public void setIDList(List<String> list) {
            IDList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="programID"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="membershipId"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CustLoyalty implements Serializable
    {
        private String programID;
        private String membershipId;

        /** 
         * Get the 'programID' attribute value.
         * 
         * @return value
         */
        public String getProgramID() {
            return programID;
        }

        /** 
         * Set the 'programID' attribute value.
         * 
         * @param programID
         */
        public void setProgramID(String programID) {
            this.programID = programID;
        }

        /** 
         * Get the 'membershipId' attribute value.
         * 
         * @return value
         */
        public String getMembershipId() {
            return membershipId;
        }

        /** 
         * Set the 'membershipId' attribute value.
         * 
         * @param membershipId
         */
        public void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteePrepaid" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" name="returnGuaranteedRates"/>
     *     &lt;xs:attribute type="xs:boolean" name="returnPrepaidRates"/>
     *     &lt;xs:attribute type="xs:boolean" name="returnRegularRates"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class GuaranteePrepaid implements Serializable
    {
        private Boolean returnGuaranteedRates;
        private Boolean returnPrepaidRates;
        private Boolean returnRegularRates;

        /** 
         * Get the 'returnGuaranteedRates' attribute value.
         * 
         * @return value
         */
        public Boolean getReturnGuaranteedRates() {
            return returnGuaranteedRates;
        }

        /** 
         * Set the 'returnGuaranteedRates' attribute value.
         * 
         * @param returnGuaranteedRates
         */
        public void setReturnGuaranteedRates(Boolean returnGuaranteedRates) {
            this.returnGuaranteedRates = returnGuaranteedRates;
        }

        /** 
         * Get the 'returnPrepaidRates' attribute value.
         * 
         * @return value
         */
        public Boolean getReturnPrepaidRates() {
            return returnPrepaidRates;
        }

        /** 
         * Set the 'returnPrepaidRates' attribute value.
         * 
         * @param returnPrepaidRates
         */
        public void setReturnPrepaidRates(Boolean returnPrepaidRates) {
            this.returnPrepaidRates = returnPrepaidRates;
        }

        /** 
         * Get the 'returnRegularRates' attribute value.
         * 
         * @return value
         */
        public Boolean getReturnRegularRates() {
            return returnRegularRates;
        }

        /** 
         * Set the 'returnRegularRates' attribute value.
         * 
         * @param returnRegularRates
         */
        public void setReturnRegularRates(Boolean returnRegularRates) {
            this.returnRegularRates = returnRegularRates;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Number" maxOccurs="50"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ID implements Serializable
    {
        private List<String> numberList = new ArrayList<String>();

        /** 
         * Get the list of 'Number' element items.
         * 
         * @return list
         */
        public List<String> getNumberList() {
            return numberList;
        }

        /** 
         * Set the list of 'Number' element items.
         * 
         * @param list
         */
        public void setNumberList(List<String> list) {
            numberList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotion" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Code" minOccurs="0" maxOccurs="50"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="ns:PromotionEnumtype" name="type"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotion implements Serializable
    {
        private List<String> codeList = new ArrayList<String>();
        private PromotionEnumtype type;

        /** 
         * Get the list of 'Code' element items.
         * 
         * @return list
         */
        public List<String> getCodeList() {
            return codeList;
        }

        /** 
         * Set the list of 'Code' element items.
         * 
         * @param list
         */
        public void setCodeList(List<String> list) {
            codeList = list;
        }

        /** 
         * Get the 'type' attribute value.
         * 
         * @return value
         */
        public PromotionEnumtype getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value.
         * 
         * @param type
         */
        public void setType(PromotionEnumtype type) {
            this.type = type;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TourCode implements Serializable
    {
        private String text;

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehiclePreferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Preference">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="VehicleType" maxOccurs="10"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VehiclePreferences implements Serializable
    {
        private List<String> preferenceList = new ArrayList<String>();

        /** 
         * Get the list of 'VehicleType' element items.
         * 
         * @return list
         */
        public List<String> getPreferenceList() {
            return preferenceList;
        }

        /** 
         * Set the list of 'VehicleType' element items.
         * 
         * @param list
         */
        public void setPreferenceList(List<String> list) {
            preferenceList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationPreferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="locationCode"/>
     *     &lt;xs:attribute name="cityLocation">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class CityLocation -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class LocationPreferences implements Serializable
    {
        private String locationCode;
        private CityLocation cityLocation;

        /** 
         * Get the 'locationCode' attribute value.
         * 
         * @return value
         */
        public String getLocationCode() {
            return locationCode;
        }

        /** 
         * Set the 'locationCode' attribute value.
         * 
         * @param locationCode
         */
        public void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        /** 
         * Get the 'cityLocation' attribute value.
         * 
         * @return value
         */
        public CityLocation getCityLocation() {
            return cityLocation;
        }

        /** 
         * Set the 'cityLocation' attribute value.
         * 
         * @param cityLocation
         */
        public void setCityLocation(CityLocation cityLocation) {
            this.cityLocation = cityLocation;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="E"/>
         *     &lt;xs:enumeration value="N"/>
         *     &lt;xs:enumeration value="S"/>
         *     &lt;xs:enumeration value="W"/>
         *     &lt;xs:enumeration value="C"/>
         *     &lt;xs:enumeration value="R"/>
         *     &lt;xs:enumeration value="A"/>
         *     &lt;xs:enumeration value="I"/>
         *     &lt;xs:enumeration value="O"/>
         *     &lt;xs:enumeration value="P"/>
         *     &lt;xs:enumeration value="X"/>
         *     &lt;xs:enumeration value="H"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum CityLocation implements Serializable {
            E, N, S, W, C, R, A, I, O, P, X, H
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPreferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="VendorPreference" minOccurs="0" maxOccurs="20">
     *         &lt;!-- Reference to inner class VendorPreference -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" name="exclude"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VendorPreferences implements Serializable
    {
        private List<VendorPreference> vendorPreferenceList = new ArrayList<VendorPreference>();
        private Boolean exclude;

        /** 
         * Get the list of 'VendorPreference' element items.
         * 
         * @return list
         */
        public List<VendorPreference> getVendorPreferenceList() {
            return vendorPreferenceList;
        }

        /** 
         * Set the list of 'VendorPreference' element items.
         * 
         * @param list
         */
        public void setVendorPreferenceList(List<VendorPreference> list) {
            vendorPreferenceList = list;
        }

        /** 
         * Get the 'exclude' attribute value.
         * 
         * @return value
         */
        public Boolean getExclude() {
            return exclude;
        }

        /** 
         * Set the 'exclude' attribute value.
         * 
         * @param exclude
         */
        public void setExclude(Boolean exclude) {
            this.exclude = exclude;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPreference" minOccurs="0" maxOccurs="20">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VendorPreference implements Serializable
        {
            private String code;

            /** 
             * Get the 'code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialEquipmentPreferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Preference" maxOccurs="10">
     *         &lt;!-- Reference to inner class Preference -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpecialEquipmentPreferences implements Serializable
    {
        private List<Preference> preferenceList = new ArrayList<Preference>();

        /** 
         * Get the list of 'Preference' element items.
         * 
         * @return list
         */
        public List<Preference> getPreferenceList() {
            return preferenceList;
        }

        /** 
         * Set the list of 'Preference' element items.
         * 
         * @param list
         */
        public void setPreferenceList(List<Preference> list) {
            preferenceList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preference" maxOccurs="10">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="equipType"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Preference implements Serializable
        {
            private String equipType;

            /** 
             * Get the 'equipType' attribute value.
             * 
             * @return value
             */
            public String getEquipType() {
                return equipType;
            }

            /** 
             * Set the 'equipType' attribute value.
             * 
             * @param equipType
             */
            public void setEquipType(String equipType) {
                this.equipType = equipType;
            }
        }
    }
}
