
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Program rewarding frequent use by accumulating credits for services provided by vendors.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyaltyType">
 *   &lt;xs:attribute type="xs:string" name="programID"/>
 *   &lt;xs:attribute type="xs:string" name="membershipID"/>
 *   &lt;xs:attribute type="xs:string" name="travelSector"/>
 *   &lt;xs:attribute type="xs:string" name="loyalLevel"/>
 *   &lt;xs:attribute type="ns:SingleVendorIndType" name="singleVendorInd"/>
 *   &lt;xs:attribute type="xs:date" name="signupDate"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustLoyaltyType implements Serializable
{
    private String programID;
    private String membershipID;
    private String travelSector;
    private String loyalLevel;
    private SingleVendorIndType singleVendorInd;
    private Date signupDate;
    private String RPH;

    /** 
     * Get the 'programID' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getProgramID() {
        return programID;
    }

    /** 
     * Set the 'programID' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param programID
     */
    public void setProgramID(String programID) {
        this.programID = programID;
    }

    /** 
     * Get the 'membershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @return value
     */
    public String getMembershipID() {
        return membershipID;
    }

    /** 
     * Set the 'membershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @param membershipID
     */
    public void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    /** 
     * Get the 'travelSector' attribute value. Identifies the travel sector. Refer to OTA Code List Travel Sector (TVS).
     * 
     * @return value
     */
    public String getTravelSector() {
        return travelSector;
    }

    /** 
     * Set the 'travelSector' attribute value. Identifies the travel sector. Refer to OTA Code List Travel Sector (TVS).
     * 
     * @param travelSector
     */
    public void setTravelSector(String travelSector) {
        this.travelSector = travelSector;
    }

    /** 
     * Get the 'loyalLevel' attribute value.
     * 
     * @return value
     */
    public String getLoyalLevel() {
        return loyalLevel;
    }

    /** 
     * Set the 'loyalLevel' attribute value.
     * 
     * @param loyalLevel
     */
    public void setLoyalLevel(String loyalLevel) {
        this.loyalLevel = loyalLevel;
    }

    /** 
     * Get the 'singleVendorInd' attribute value.
     * 
     * @return value
     */
    public SingleVendorIndType getSingleVendorInd() {
        return singleVendorInd;
    }

    /** 
     * Set the 'singleVendorInd' attribute value.
     * 
     * @param singleVendorInd
     */
    public void setSingleVendorInd(SingleVendorIndType singleVendorInd) {
        this.singleVendorInd = singleVendorInd;
    }

    /** 
     * Get the 'signupDate' attribute value.
     * 
     * @return value
     */
    public Date getSignupDate() {
        return signupDate;
    }

    /** 
     * Set the 'signupDate' attribute value.
     * 
     * @param signupDate
     */
    public void setSignupDate(Date signupDate) {
        this.signupDate = signupDate;
    }

    /** 
     * Get the 'RPH' attribute value. Reference place holder, to reference it back in the response.
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. Reference place holder, to reference it back in the response.
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
