
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OpenReservationElementType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:SocialMediaContact" minOccurs="0"/>
 *     &lt;xs:element ref="ns:AgencyFees" minOccurs="0"/>
 *     &lt;xs:element ref="ns:LangDetails" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FormOfPayment" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Loyalty" minOccurs="0"/>
 *     &lt;xs:element ref="ns:AncillaryProduct" minOccurs="0"/>
 *     &lt;xs:element ref="ns:InvoiceData" minOccurs="0"/>
 *     &lt;xs:element ref="ns:AccountingField" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ServiceRequest" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Email" minOccurs="0"/>
 *     &lt;xs:element ref="ns:PriceCache" minOccurs="0"/>
 *     &lt;xs:element ref="ns:TripProposalReference" minOccurs="0"/>
 *     &lt;xs:element ref="ns:InsuranceOptOut" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Profile" minOccurs="0"/>
 *     &lt;xs:group ref="ns:Associations" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 *   &lt;xs:attribute type="xs:int" name="displayIndex"/>
 *   &lt;xs:attribute type="xs:string" name="elementId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OpenReservationElementType implements Serializable
{
    private SocialMediaContactType socialMediaContact;
    private AgencyFeesType agencyFees;
    private LangDetailsType langDetails;
    private FormOfPayment formOfPayment;
    private Loyalty loyalty;
    private AncillaryProductObject ancillaryProduct;
    private InvoiceData invoiceData;
    private AccountingField accountingField;
    private ServiceRequestType serviceRequest;
    private Email email;
    private PriceCache priceCache;
    private TripProposalReference tripProposalReference;
    private InsuranceOptOut insuranceOptOut;
    private ProfileType profile;
    private Associations associations;
    private String id;
    private String type;
    private Integer displayIndex;
    private String elementId;

    /** 
     * Get the 'SocialMediaContact' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public SocialMediaContactType getSocialMediaContact() {
        return socialMediaContact;
    }

    /** 
     * Set the 'SocialMediaContact' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param socialMediaContact
     */
    public void setSocialMediaContact(SocialMediaContactType socialMediaContact) {
        this.socialMediaContact = socialMediaContact;
    }

    /** 
     * Get the 'AgencyFees' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public AgencyFeesType getAgencyFees() {
        return agencyFees;
    }

    /** 
     * Set the 'AgencyFees' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param agencyFees
     */
    public void setAgencyFees(AgencyFeesType agencyFees) {
        this.agencyFees = agencyFees;
    }

    /** 
     * Get the 'LangDetails' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public LangDetailsType getLangDetails() {
        return langDetails;
    }

    /** 
     * Set the 'LangDetails' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param langDetails
     */
    public void setLangDetails(LangDetailsType langDetails) {
        this.langDetails = langDetails;
    }

    /** 
     * Get the 'FormOfPayment' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public FormOfPayment getFormOfPayment() {
        return formOfPayment;
    }

    /** 
     * Set the 'FormOfPayment' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param formOfPayment
     */
    public void setFormOfPayment(FormOfPayment formOfPayment) {
        this.formOfPayment = formOfPayment;
    }

    /** 
     * Get the 'Loyalty' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public Loyalty getLoyalty() {
        return loyalty;
    }

    /** 
     * Set the 'Loyalty' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param loyalty
     */
    public void setLoyalty(Loyalty loyalty) {
        this.loyalty = loyalty;
    }

    /** 
     * Get the 'AncillaryProduct' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public AncillaryProductObject getAncillaryProduct() {
        return ancillaryProduct;
    }

    /** 
     * Set the 'AncillaryProduct' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param ancillaryProduct
     */
    public void setAncillaryProduct(AncillaryProductObject ancillaryProduct) {
        this.ancillaryProduct = ancillaryProduct;
    }

    /** 
     * Get the 'InvoiceData' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public InvoiceData getInvoiceData() {
        return invoiceData;
    }

    /** 
     * Set the 'InvoiceData' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param invoiceData
     */
    public void setInvoiceData(InvoiceData invoiceData) {
        this.invoiceData = invoiceData;
    }

    /** 
     * Get the 'AccountingField' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public AccountingField getAccountingField() {
        return accountingField;
    }

    /** 
     * Set the 'AccountingField' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param accountingField
     */
    public void setAccountingField(AccountingField accountingField) {
        this.accountingField = accountingField;
    }

    /** 
     * Get the 'ServiceRequest' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public ServiceRequestType getServiceRequest() {
        return serviceRequest;
    }

    /** 
     * Set the 'ServiceRequest' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param serviceRequest
     */
    public void setServiceRequest(ServiceRequestType serviceRequest) {
        this.serviceRequest = serviceRequest;
    }

    /** 
     * Get the 'Email' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public Email getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param email
     */
    public void setEmail(Email email) {
        this.email = email;
    }

    /** 
     * Get the 'PriceCache' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public PriceCache getPriceCache() {
        return priceCache;
    }

    /** 
     * Set the 'PriceCache' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param priceCache
     */
    public void setPriceCache(PriceCache priceCache) {
        this.priceCache = priceCache;
    }

    /** 
     * Get the 'TripProposalReference' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public TripProposalReference getTripProposalReference() {
        return tripProposalReference;
    }

    /** 
     * Set the 'TripProposalReference' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param tripProposalReference
     */
    public void setTripProposalReference(
            TripProposalReference tripProposalReference) {
        this.tripProposalReference = tripProposalReference;
    }

    /** 
     * Get the 'InsuranceOptOut' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public InsuranceOptOut getInsuranceOptOut() {
        return insuranceOptOut;
    }

    /** 
     * Set the 'InsuranceOptOut' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param insuranceOptOut
     */
    public void setInsuranceOptOut(InsuranceOptOut insuranceOptOut) {
        this.insuranceOptOut = insuranceOptOut;
    }

    /** 
     * Get the 'Profile' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public ProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. SocialMediaContact, AgencyFees, LangDetails, FormOfPayment, Loyalty, AncillaryProduct, InvoiceData, AccountingField, ServiceRequest, Email, PriceCache, TripProposalReference, InsuranceOptOut, Profile are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param profile
     */
    public void setProfile(ProfileType profile) {
        this.profile = profile;
    }

    /** 
     * Get the 'Associations' group value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' group value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'id' attribute value. Hold reference ID
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. Hold reference ID
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. Open reservation element type, like SF for Agency Fees
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Open reservation element type, like SF for Agency Fees
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'displayIndex' attribute value. Used to order items sequentially for presentation purposes
     * 
     * @return value
     */
    public Integer getDisplayIndex() {
        return displayIndex;
    }

    /** 
     * Set the 'displayIndex' attribute value. Used to order items sequentially for presentation purposes
     * 
     * @param displayIndex
     */
    public void setDisplayIndex(Integer displayIndex) {
        this.displayIndex = displayIndex;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }
}
