
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonNameType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Prefix" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Given" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Middle" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Surname"/>
 *     &lt;xs:element type="xs:string" name="Suffix" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PreferredFirstName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PreferredSurname" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PersonNameType implements Serializable
{
    private String prefix;
    private String given;
    private String middle;
    private String surname;
    private String suffix;
    private String type;
    private String preferredFirstName;
    private String preferredSurname;

    /** 
     * Get the 'Prefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.)
     * 
     * @return value
     */
    public String getPrefix() {
        return prefix;
    }

    /** 
     * Set the 'Prefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.)
     * 
     * @param prefix
     */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    /** 
     * Get the 'Given' element value. Given name, first name or names
     * 
     * @return value
     */
    public String getGiven() {
        return given;
    }

    /** 
     * Set the 'Given' element value. Given name, first name or names
     * 
     * @param given
     */
    public void setGiven(String given) {
        this.given = given;
    }

    /** 
     * Get the 'Middle' element value. The middle name of the person name
     * 
     * @return value
     */
    public String getMiddle() {
        return middle;
    }

    /** 
     * Set the 'Middle' element value. The middle name of the person name
     * 
     * @param middle
     */
    public void setMiddle(String middle) {
        this.middle = middle;
    }

    /** 
     * Get the 'Surname' element value. Family name also known as last name.
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. Family name also known as last name.
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the 'Suffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @return value
     */
    public String getSuffix() {
        return suffix;
    }

    /** 
     * Set the 'Suffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @param suffix
     */
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    /** 
     * Get the 'Type' element value.
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'PreferredFirstName' element value. Any preferred names for first name used instead of GivenName
     * 
     * @return value
     */
    public String getPreferredFirstName() {
        return preferredFirstName;
    }

    /** 
     * Set the 'PreferredFirstName' element value. Any preferred names for first name used instead of GivenName
     * 
     * @param preferredFirstName
     */
    public void setPreferredFirstName(String preferredFirstName) {
        this.preferredFirstName = preferredFirstName;
    }

    /** 
     * Get the 'PreferredSurname' element value. Any preferred names for last names used instead of surname
     * 
     * @return value
     */
    public String getPreferredSurname() {
        return preferredSurname;
    }

    /** 
     * Set the 'PreferredSurname' element value. Any preferred names for last names used instead of surname
     * 
     * @param preferredSurname
     */
    public void setPreferredSurname(String preferredSurname) {
        this.preferredSurname = preferredSurname;
    }
}
