
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Price Quote information stored in single PNR

 Ticketing System can get more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time
 and attempt to seach for Price Quotes in more than one PNR will result in error
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteInfo">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Reservation" minOccurs="0">
 *         &lt;!-- Reference to inner class Reservation -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Summary">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="NameAssociation" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class NameAssociation -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="NoNameAssociation" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class NoNameAssociation -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="SummaryByPassengerType" minOccurs="0">
 *               &lt;!-- Reference to inner class SummaryByPassengerType -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:choice>
 *         &lt;xs:element name="Details" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Details -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="CustomDetails" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class CustomDetails -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PriceQuoteInfo implements Serializable
{
    private Reservation reservation;
    private List<NameAssociation> nameAssociationList = new ArrayList<NameAssociation>();
    private List<NoNameAssociation> noNameAssociationList = new ArrayList<NoNameAssociation>();
    private SummaryByPassengerType summaryByPassengerType;
    private int choiceSelect = -1;
    private static final int DETAIL_LIST_CHOICE = 0;
    private static final int CUSTOM_DETAIL_LIST_CHOICE = 1;
    private List<Details> detailList = new ArrayList<Details>();
    private List<CustomDetails> customDetailList = new ArrayList<CustomDetails>();

    /** 
     * Get the 'Reservation' element value.
     * 
     * @return value
     */
    public Reservation getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value.
     * 
     * @param reservation
     */
    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }

    /** 
     * Get the list of 'NameAssociation' element items.
     * 
     * @return list
     */
    public List<NameAssociation> getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the list of 'NameAssociation' element items.
     * 
     * @param list
     */
    public void setNameAssociationList(List<NameAssociation> list) {
        nameAssociationList = list;
    }

    /** 
     * Get the list of 'NoNameAssociation' element items.
     * 
     * @return list
     */
    public List<NoNameAssociation> getNoNameAssociationList() {
        return noNameAssociationList;
    }

    /** 
     * Set the list of 'NoNameAssociation' element items.
     * 
     * @param list
     */
    public void setNoNameAssociationList(List<NoNameAssociation> list) {
        noNameAssociationList = list;
    }

    /** 
     * Get the 'SummaryByPassengerType' element value.
     * 
     * @return value
     */
    public SummaryByPassengerType getSummaryByPassengerType() {
        return summaryByPassengerType;
    }

    /** 
     * Set the 'SummaryByPassengerType' element value.
     * 
     * @param summaryByPassengerType
     */
    public void setSummaryByPassengerType(
            SummaryByPassengerType summaryByPassengerType) {
        this.summaryByPassengerType = summaryByPassengerType;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if DetailList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDetailList() {
        return choiceSelect == DETAIL_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Details' element items.
     * 
     * @return list
     */
    public List<Details> getDetailList() {
        return detailList;
    }

    /** 
     * Set the list of 'Details' element items.
     * 
     * @param list
     */
    public void setDetailList(List<Details> list) {
        setChoiceSelect(DETAIL_LIST_CHOICE);
        detailList = list;
    }

    /** 
     * Check if CustomDetailList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDetailList() {
        return choiceSelect == CUSTOM_DETAIL_LIST_CHOICE;
    }

    /** 
     * Get the list of 'CustomDetails' element items.
     * 
     * @return list
     */
    public List<CustomDetails> getCustomDetailList() {
        return customDetailList;
    }

    /** 
     * Set the list of 'CustomDetails' element items.
     * 
     * @param list
     */
    public void setCustomDetailList(List<CustomDetails> list) {
        setChoiceSelect(CUSTOM_DETAIL_LIST_CHOICE);
        customDetailList = list;
    }
    /** 
     * Includes the PNR number
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reservation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:dateTime" name="createDate"/>
     *         &lt;xs:attribute type="xs:string" use="required" name="updateToken"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Reservation implements Serializable
    {
        private String string;
        private Date createDate;
        private String updateToken;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'createDate' attribute value. The date when the reservation has been made
         * 
         * @return value
         */
        public Date getCreateDate() {
            return createDate;
        }

        /** 
         * Set the 'createDate' attribute value. The date when the reservation has been made
         * 
         * @param createDate
         */
        public void setCreateDate(Date createDate) {
            this.createDate = createDate;
        }

        /** 
         * Get the 'updateToken' attribute value. Update token indicator which is required value to be passed in any update operation
         * 
         * @return value
         */
        public String getUpdateToken() {
            return updateToken;
        }

        /** 
         * Set the 'updateToken' attribute value. Update token indicator which is required value to be passed in any update operation
         * 
         * @param updateToken
         */
        public void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }
    }
    /** 
     * Defines association of a passenger to the Price Quote and the Price Quote items. This information is equivalent
                                                      to *PQS
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameAssociation" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceQuote" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceQuote -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="nameNumber"/>
     *     &lt;xs:attribute type="xs:integer" use="required" name="nameId"/>
     *     &lt;xs:attribute type="xs:string" name="firstName"/>
     *     &lt;xs:attribute type="xs:string" name="lastName"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NameAssociation implements Serializable
    {
        private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();
        private String nameNumber;
        private BigInteger nameId;
        private String firstName;
        private String lastName;

        /** 
         * Get the list of 'PriceQuote' element items.
         * 
         * @return list
         */
        public List<PriceQuote> getPriceQuoteList() {
            return priceQuoteList;
        }

        /** 
         * Set the list of 'PriceQuote' element items.
         * 
         * @param list
         */
        public void setPriceQuoteList(List<PriceQuote> list) {
            priceQuoteList = list;
        }

        /** 
         * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
         * 
         * @return value
         */
        public String getNameNumber() {
            return nameNumber;
        }

        /** 
         * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
         * 
         * @param nameNumber
         */
        public void setNameNumber(String nameNumber) {
            this.nameNumber = nameNumber;
        }

        /** 
         * Get the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
         * 
         * @return value
         */
        public BigInteger getNameId() {
            return nameId;
        }

        /** 
         * Set the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
         * 
         * @param nameId
         */
        public void setNameId(BigInteger nameId) {
            this.nameId = nameId;
        }

        /** 
         * Get the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
         * 
         * @return value
         */
        public String getFirstName() {
            return firstName;
        }

        /** 
         * Set the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
         * 
         * @param firstName
         */
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        /** 
         * Get the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
         * 
         * @return value
         */
        public String getLastName() {
            return lastName;
        }

        /** 
         * Set the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
         * 
         * @param lastName
         */
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Indicators" minOccurs="0">
         *         &lt;!-- Reference to inner class Indicators -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Passenger" minOccurs="0">
         *         &lt;!-- Reference to inner class Passenger -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
         *       &lt;xs:element name="Fee" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Fee -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0" maxOccurs="2"/>
         *       &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
         *       &lt;xs:element name="Amounts" minOccurs="0">
         *         &lt;!-- Reference to inner class Amounts -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
         *       &lt;xs:element name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class MessageInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="required" name="type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
         *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
         *     &lt;xs:attribute type="xs:string" name="reissueType"/>
         *     &lt;xs:attribute type="xs:boolean" name="latestPQFlag"/>
         *     &lt;xs:attribute type="xs:boolean" name="viewershipRestricted"/>
         *     &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceQuote implements Serializable
        {
            private Indicators indicators;
            private Passenger passenger;
            private String itineraryType;
            private List<Fee> feeList = new ArrayList<Fee>();
            private List<String> ticketDesignatorList = new ArrayList<String>();
            private String validatingCarrier;
            private Amounts amounts;
            private Date localCreateDateTime;
            private List<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
            private Type type;
            private BigInteger number;
            private String status;
            private String pricingType;
            private String pricingStatus;
            private String reissueType;
            private Boolean latestPQFlag;
            private Boolean viewershipRestricted;
            private Boolean lowCostCarrier;

            /** 
             * Get the 'Indicators' element value.
             * 
             * @return value
             */
            public Indicators getIndicators() {
                return indicators;
            }

            /** 
             * Set the 'Indicators' element value.
             * 
             * @param indicators
             */
            public void setIndicators(Indicators indicators) {
                this.indicators = indicators;
            }

            /** 
             * Get the 'Passenger' element value.
             * 
             * @return value
             */
            public Passenger getPassenger() {
                return passenger;
            }

            /** 
             * Set the 'Passenger' element value.
             * 
             * @param passenger
             */
            public void setPassenger(Passenger passenger) {
                this.passenger = passenger;
            }

            /** 
             * Get the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @return value
             */
            public String getItineraryType() {
                return itineraryType;
            }

            /** 
             * Set the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @param itineraryType
             */
            public void setItineraryType(String itineraryType) {
                this.itineraryType = itineraryType;
            }

            /** 
             * Get the list of 'Fee' element items.
             * 
             * @return list
             */
            public List<Fee> getFeeList() {
                return feeList;
            }

            /** 
             * Set the list of 'Fee' element items.
             * 
             * @param list
             */
            public void setFeeList(List<Fee> list) {
                feeList = list;
            }

            /** 
             * Get the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @return list
             */
            public List<String> getTicketDesignatorList() {
                return ticketDesignatorList;
            }

            /** 
             * Set the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @param list
             */
            public void setTicketDesignatorList(List<String> list) {
                ticketDesignatorList = list;
            }

            /** 
             * Get the 'ValidatingCarrier' element value. Validating Carrier.
                                                                                  Ref: DM0Z_65_CRXC
             * 
             * @return value
             */
            public String getValidatingCarrier() {
                return validatingCarrier;
            }

            /** 
             * Set the 'ValidatingCarrier' element value. Validating Carrier.
                                                                                  Ref: DM0Z_65_CRXC
             * 
             * @param validatingCarrier
             */
            public void setValidatingCarrier(String validatingCarrier) {
                this.validatingCarrier = validatingCarrier;
            }

            /** 
             * Get the 'Amounts' element value.
             * 
             * @return value
             */
            public Amounts getAmounts() {
                return amounts;
            }

            /** 
             * Set the 'Amounts' element value.
             * 
             * @param amounts
             */
            public void setAmounts(Amounts amounts) {
                this.amounts = amounts;
            }

            /** 
             * Get the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @return value
             */
            public Date getLocalCreateDateTime() {
                return localCreateDateTime;
            }

            /** 
             * Set the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @param localCreateDateTime
             */
            public void setLocalCreateDateTime(Date localCreateDateTime) {
                this.localCreateDateTime = localCreateDateTime;
            }

            /** 
             * Get the list of 'MessageInfo' element items.
             * 
             * @return list
             */
            public List<MessageInfo> getMessageInfoList() {
                return messageInfoList;
            }

            /** 
             * Set the list of 'MessageInfo' element items.
             * 
             * @param list
             */
            public void setMessageInfoList(List<MessageInfo> list) {
                messageInfoList = list;
            }

            /** 
             * Get the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }

            /** 
             * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @return value
             */
            public String getStatus() {
                return status;
            }

            /** 
             * Set the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @param status
             */
            public void setStatus(String status) {
                this.status = status;
            }

            /** 
             * Get the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @return value
             */
            public String getPricingType() {
                return pricingType;
            }

            /** 
             * Set the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @param pricingType
             */
            public void setPricingType(String pricingType) {
                this.pricingType = pricingType;
            }

            /** 
             * Get the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @return value
             */
            public String getPricingStatus() {
                return pricingStatus;
            }

            /** 
             * Set the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @param pricingStatus
             */
            public void setPricingStatus(String pricingStatus) {
                this.pricingStatus = pricingStatus;
            }

            /** 
             * Get the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @return value
             */
            public String getReissueType() {
                return reissueType;
            }

            /** 
             * Set the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @param reissueType
             */
            public void setReissueType(String reissueType) {
                this.reissueType = reissueType;
            }

            /** 
             * Get the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @return value
             */
            public Boolean getLatestPQFlag() {
                return latestPQFlag;
            }

            /** 
             * Set the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @param latestPQFlag
             */
            public void setLatestPQFlag(Boolean latestPQFlag) {
                this.latestPQFlag = latestPQFlag;
            }

            /** 
             * Get the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @return value
             */
            public Boolean getViewershipRestricted() {
                return viewershipRestricted;
            }

            /** 
             * Set the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @param viewershipRestricted
             */
            public void setViewershipRestricted(Boolean viewershipRestricted) {
                this.viewershipRestricted = viewershipRestricted;
            }

            /** 
             * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @return value
             */
            public Boolean getLowCostCarrier() {
                return lowCostCarrier;
            }

            /** 
             * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @param lowCostCarrier
             */
            public void setLowCostCarrier(Boolean lowCostCarrier) {
                this.lowCostCarrier = lowCostCarrier;
            }
            /** 
             * PQ indicators with boolen values; default to 'false'
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Indicators" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ManualPricing" minOccurs="0">
             *         &lt;!-- Reference to inner class ManualPricing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="segmentSelect"/>
             *     &lt;xs:attribute type="xs:boolean" name="ticketed"/>
             *     &lt;xs:attribute type="xs:boolean" name="override"/>
             *     &lt;xs:attribute type="xs:boolean" name="deleted"/>
             *     &lt;xs:attribute type="xs:boolean" name="itineraryChange"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Indicators implements Serializable
            {
                private ManualPricing manualPricing;
                private Boolean segmentSelect;
                private Boolean ticketed;
                private Boolean override;
                private Boolean deleted;
                private Boolean itineraryChange;

                /** 
                 * Get the 'ManualPricing' element value.
                 * 
                 * @return value
                 */
                public ManualPricing getManualPricing() {
                    return manualPricing;
                }

                /** 
                 * Set the 'ManualPricing' element value.
                 * 
                 * @param manualPricing
                 */
                public void setManualPricing(ManualPricing manualPricing) {
                    this.manualPricing = manualPricing;
                }

                /** 
                 * Get the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @return value
                 */
                public Boolean getSegmentSelect() {
                    return segmentSelect;
                }

                /** 
                 * Set the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @param segmentSelect
                 */
                public void setSegmentSelect(Boolean segmentSelect) {
                    this.segmentSelect = segmentSelect;
                }

                /** 
                 * Get the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @return value
                 */
                public Boolean getTicketed() {
                    return ticketed;
                }

                /** 
                 * Set the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @param ticketed
                 */
                public void setTicketed(Boolean ticketed) {
                    this.ticketed = ticketed;
                }

                /** 
                 * Get the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }

                /** 
                 * Get the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @return value
                 */
                public Boolean getDeleted() {
                    return deleted;
                }

                /** 
                 * Set the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @param deleted
                 */
                public void setDeleted(Boolean deleted) {
                    this.deleted = deleted;
                }

                /** 
                 * Get the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @return value
                 */
                public Boolean getItineraryChange() {
                    return itineraryChange;
                }

                /** 
                 * Set the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @param itineraryChange
                 */
                public void setItineraryChange(Boolean itineraryChange) {
                    this.itineraryChange = itineraryChange;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManualPricing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="verifyFareCalculation"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ManualPricing implements Serializable
                {
                    private Boolean verifyFareCalculation;

                    /** 
                     * Get the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @return value
                     */
                    public Boolean getVerifyFareCalculation() {
                        return verifyFareCalculation;
                    }

                    /** 
                     * Set the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @param verifyFareCalculation
                     */
                    public void setVerifyFareCalculation(
                            Boolean verifyFareCalculation) {
                        this.verifyFareCalculation = verifyFareCalculation;
                    }
                }
            }
            /** 
             * Passenger data related to PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="requestedType"/>
             *     &lt;xs:attribute type="xs:string" name="pricedType"/>
             *     &lt;xs:attribute type="xs:int" name="passengerTypeCount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passenger implements Serializable
            {
                private String type;
                private String requestedType;
                private String pricedType;
                private Integer passengerTypeCount;

                /** 
                 * Get the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @return value
                 */
                public String getRequestedType() {
                    return requestedType;
                }

                /** 
                 * Set the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @param requestedType
                 */
                public void setRequestedType(String requestedType) {
                    this.requestedType = requestedType;
                }

                /** 
                 * Get the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @return value
                 */
                public String getPricedType() {
                    return pricedType;
                }

                /** 
                 * Set the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @param pricedType
                 */
                public void setPricedType(String pricedType) {
                    this.pricedType = pricedType;
                }

                /** 
                 * Get the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @return value
                 */
                public Integer getPassengerTypeCount() {
                    return passengerTypeCount;
                }

                /** 
                 * Set the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @param passengerTypeCount
                 */
                public void setPassengerTypeCount(Integer passengerTypeCount) {
                    this.passengerTypeCount = passengerTypeCount;
                }
            }
            /** 
             * Only 50 fee items can be stored per PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Waiver" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="itemId"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fee implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private String waiver;
                private String type;
                private String code;
                private BigInteger itemId;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Get the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @return value
                 */
                public String getWaiver() {
                    return waiver;
                }

                /** 
                 * Set the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @param waiver
                 */
                public void setWaiver(String waiver) {
                    this.waiver = waiver;
                }

                /** 
                 * Get the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @return value
                 */
                public BigInteger getItemId() {
                    return itemId;
                }

                /** 
                 * Set the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @param itemId
                 */
                public void setItemId(BigInteger itemId) {
                    this.itemId = itemId;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amounts" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Total" minOccurs="0">
             *         &lt;!-- Reference to inner class Total -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ReissueDifference" minOccurs="0">
             *         &lt;!-- Reference to inner class ReissueDifference -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amounts implements Serializable
            {
                private Total total;
                private ReissueDifference reissueDifference;

                /** 
                 * Get the 'Total' element value.
                 * 
                 * @return value
                 */
                public Total getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value.
                 * 
                 * @param total
                 */
                public void setTotal(Total total) {
                    this.total = total;
                }

                /** 
                 * Get the 'ReissueDifference' element value.
                 * 
                 * @return value
                 */
                public ReissueDifference getReissueDifference() {
                    return reissueDifference;
                }

                /** 
                 * Set the 'ReissueDifference' element value.
                 * 
                 * @param reissueDifference
                 */
                public void setReissueDifference(
                        ReissueDifference reissueDifference) {
                    this.reissueDifference = reissueDifference;
                }
                /** 
                 * Total fare inclusive taxes per PQ type
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Total implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Reissue  difference amount (for add collect, refund or even exchange)
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissueDifference" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ReissueDifference implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *         &lt;xs:attribute type="xs:integer" name="number"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MessageInfo implements Serializable
            {
                private String string;
                private String type;
                private BigInteger number;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="PQ"/>
             *     &lt;xs:enumeration value="PQR"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                PQ, PQR
            }
        }
    }
    /** 
     * Defines Price Quotes that are not name associated in the summary (part of  equivalent *PQS)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoNameAssociation" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceQuote" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceQuote -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NoNameAssociation implements Serializable
    {
        private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();

        /** 
         * Get the list of 'PriceQuote' element items.
         * 
         * @return list
         */
        public List<PriceQuote> getPriceQuoteList() {
            return priceQuoteList;
        }

        /** 
         * Set the list of 'PriceQuote' element items.
         * 
         * @param list
         */
        public void setPriceQuoteList(List<PriceQuote> list) {
            priceQuoteList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Indicators" minOccurs="0">
         *         &lt;!-- Reference to inner class Indicators -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Passenger" minOccurs="0">
         *         &lt;!-- Reference to inner class Passenger -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
         *       &lt;xs:element name="Fee" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Fee -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0" maxOccurs="2"/>
         *       &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
         *       &lt;xs:element name="Amounts" minOccurs="0">
         *         &lt;!-- Reference to inner class Amounts -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
         *       &lt;xs:element name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class MessageInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="required" name="type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
         *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
         *     &lt;xs:attribute type="xs:string" name="reissueType"/>
         *     &lt;xs:attribute type="xs:boolean" name="latestPQFlag"/>
         *     &lt;xs:attribute type="xs:boolean" name="viewershipRestricted"/>
         *     &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceQuote implements Serializable
        {
            private Indicators indicators;
            private Passenger passenger;
            private String itineraryType;
            private List<Fee> feeList = new ArrayList<Fee>();
            private List<String> ticketDesignatorList = new ArrayList<String>();
            private String validatingCarrier;
            private Amounts amounts;
            private Date localCreateDateTime;
            private List<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
            private Type type;
            private BigInteger number;
            private String status;
            private String pricingType;
            private String pricingStatus;
            private String reissueType;
            private Boolean latestPQFlag;
            private Boolean viewershipRestricted;
            private Boolean lowCostCarrier;

            /** 
             * Get the 'Indicators' element value.
             * 
             * @return value
             */
            public Indicators getIndicators() {
                return indicators;
            }

            /** 
             * Set the 'Indicators' element value.
             * 
             * @param indicators
             */
            public void setIndicators(Indicators indicators) {
                this.indicators = indicators;
            }

            /** 
             * Get the 'Passenger' element value.
             * 
             * @return value
             */
            public Passenger getPassenger() {
                return passenger;
            }

            /** 
             * Set the 'Passenger' element value.
             * 
             * @param passenger
             */
            public void setPassenger(Passenger passenger) {
                this.passenger = passenger;
            }

            /** 
             * Get the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @return value
             */
            public String getItineraryType() {
                return itineraryType;
            }

            /** 
             * Set the 'ItineraryType' element value. Possible values
                                                                                  I - International
                                                                                  D- Domestic

                                                                                  Ref:DM0Z_65_ID01
             * 
             * @param itineraryType
             */
            public void setItineraryType(String itineraryType) {
                this.itineraryType = itineraryType;
            }

            /** 
             * Get the list of 'Fee' element items.
             * 
             * @return list
             */
            public List<Fee> getFeeList() {
                return feeList;
            }

            /** 
             * Set the list of 'Fee' element items.
             * 
             * @param list
             */
            public void setFeeList(List<Fee> list) {
                feeList = list;
            }

            /** 
             * Get the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @return list
             */
            public List<String> getTicketDesignatorList() {
                return ticketDesignatorList;
            }

            /** 
             * Set the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
             * 
             * @param list
             */
            public void setTicketDesignatorList(List<String> list) {
                ticketDesignatorList = list;
            }

            /** 
             * Get the 'ValidatingCarrier' element value. Validating Carrier.
                                                                                  Ref: DM0Z_65_CRXC
             * 
             * @return value
             */
            public String getValidatingCarrier() {
                return validatingCarrier;
            }

            /** 
             * Set the 'ValidatingCarrier' element value. Validating Carrier.
                                                                                  Ref: DM0Z_65_CRXC
             * 
             * @param validatingCarrier
             */
            public void setValidatingCarrier(String validatingCarrier) {
                this.validatingCarrier = validatingCarrier;
            }

            /** 
             * Get the 'Amounts' element value.
             * 
             * @return value
             */
            public Amounts getAmounts() {
                return amounts;
            }

            /** 
             * Set the 'Amounts' element value.
             * 
             * @param amounts
             */
            public void setAmounts(Amounts amounts) {
                this.amounts = amounts;
            }

            /** 
             * Get the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @return value
             */
            public Date getLocalCreateDateTime() {
                return localCreateDateTime;
            }

            /** 
             * Set the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
                                                                                  Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @param localCreateDateTime
             */
            public void setLocalCreateDateTime(Date localCreateDateTime) {
                this.localCreateDateTime = localCreateDateTime;
            }

            /** 
             * Get the list of 'MessageInfo' element items.
             * 
             * @return list
             */
            public List<MessageInfo> getMessageInfoList() {
                return messageInfoList;
            }

            /** 
             * Set the list of 'MessageInfo' element items.
             * 
             * @param list
             */
            public void setMessageInfoList(List<MessageInfo> list) {
                messageInfoList = list;
            }

            /** 
             * Get the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Price Quote Type

                                                                              Possible values can be:
                                                                              PQ - Price Quote Record
                                                                              PQR - Price Quote Reissue
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }

            /** 
             * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @return value
             */
            public String getStatus() {
                return status;
            }

            /** 
             * Set the 'status' attribute value. PQ status
                                                                              Possible values are:
                                                                              A - Active
                                                                              H - History
                                                                              below values applicable only for airlines and not subscriber
                                                                              I - Inactive
                                                                              M - Manual
                                                                              X - Expired
                                                                              U - Unretained
                                                                              F - FSC Manual
             * 
             * @param status
             */
            public void setStatus(String status) {
                this.status = status;
            }

            /** 
             * Get the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @return value
             */
            public String getPricingType() {
                return pricingType;
            }

            /** 
             * Set the 'pricingType' attribute value. Code associated to the status as to how pricing was done

                                                                              Possible values:
                                                                              S - System
                                                                              M - Manual
                                                                              A - Amended
             * 
             * @param pricingType
             */
            public void setPricingType(String pricingType) {
                this.pricingType = pricingType;
            }

            /** 
             * Get the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @return value
             */
            public String getPricingStatus() {
                return pricingStatus;
            }

            /** 
             * Set the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

                                                                              Possible values:

                                                                              Abacus GDS
                                                                              AUTO PRICED
                                                                              MANUAL
                                                                              RATE DESK

                                                                              INFINI GDS
                                                                              C-Guaranteed
                                                                              W - With warning/Not guaranteed
                                                                              M - amendments/Not guaranteed
                                                                              A- overrides/Not guaranteed
             * 
             * @param pricingStatus
             */
            public void setPricingStatus(String pricingStatus) {
                this.pricingStatus = pricingStatus;
            }

            /** 
             * Get the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @return value
             */
            public String getReissueType() {
                return reissueType;
            }

            /** 
             * Set the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
                                                                              Possible values:
                                                                              INVOL
                                                                              SKED CHG
                                                                              EXCH EVEN
                                                                              EXCH CF
                                                                              EXCH AC
                                                                              EXCH AC/CF
                                                                              EXCH RFND
                                                                              LTA
                                                                              AFFIDAVIT
                                                                              LTA/CF
                                                                              AFFIDAVIT/CF
                                                                              REFUND
                                                                              REFUND CF
             * 
             * @param reissueType
             */
            public void setReissueType(String reissueType) {
                this.reissueType = reissueType;
            }

            /** 
             * Get the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @return value
             */
            public Boolean getLatestPQFlag() {
                return latestPQFlag;
            }

            /** 
             * Set the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
             * 
             * @param latestPQFlag
             */
            public void setLatestPQFlag(Boolean latestPQFlag) {
                this.latestPQFlag = latestPQFlag;
            }

            /** 
             * Get the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @return value
             */
            public Boolean getViewershipRestricted() {
                return viewershipRestricted;
            }

            /** 
             * Set the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
             * 
             * @param viewershipRestricted
             */
            public void setViewershipRestricted(Boolean viewershipRestricted) {
                this.viewershipRestricted = viewershipRestricted;
            }

            /** 
             * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @return value
             */
            public Boolean getLowCostCarrier() {
                return lowCostCarrier;
            }

            /** 
             * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
                                                                              Ref: #DM0Z_40_HCPQ
                                                                              Value is false if attribute not present.
             * 
             * @param lowCostCarrier
             */
            public void setLowCostCarrier(Boolean lowCostCarrier) {
                this.lowCostCarrier = lowCostCarrier;
            }
            /** 
             * PQ indicators with boolen values; default to 'false'
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Indicators" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ManualPricing" minOccurs="0">
             *         &lt;!-- Reference to inner class ManualPricing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="segmentSelect"/>
             *     &lt;xs:attribute type="xs:boolean" name="ticketed"/>
             *     &lt;xs:attribute type="xs:boolean" name="override"/>
             *     &lt;xs:attribute type="xs:boolean" name="deleted"/>
             *     &lt;xs:attribute type="xs:boolean" name="itineraryChange"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Indicators implements Serializable
            {
                private ManualPricing manualPricing;
                private Boolean segmentSelect;
                private Boolean ticketed;
                private Boolean override;
                private Boolean deleted;
                private Boolean itineraryChange;

                /** 
                 * Get the 'ManualPricing' element value.
                 * 
                 * @return value
                 */
                public ManualPricing getManualPricing() {
                    return manualPricing;
                }

                /** 
                 * Set the 'ManualPricing' element value.
                 * 
                 * @param manualPricing
                 */
                public void setManualPricing(ManualPricing manualPricing) {
                    this.manualPricing = manualPricing;
                }

                /** 
                 * Get the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @return value
                 */
                public Boolean getSegmentSelect() {
                    return segmentSelect;
                }

                /** 
                 * Set the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
                 * 
                 * @param segmentSelect
                 */
                public void setSegmentSelect(Boolean segmentSelect) {
                    this.segmentSelect = segmentSelect;
                }

                /** 
                 * Get the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @return value
                 */
                public Boolean getTicketed() {
                    return ticketed;
                }

                /** 
                 * Set the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
                 * 
                 * @param ticketed
                 */
                public void setTicketed(Boolean ticketed) {
                    this.ticketed = ticketed;
                }

                /** 
                 * Get the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'override' attribute value. Indicator to specify PQ has been override
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }

                /** 
                 * Get the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @return value
                 */
                public Boolean getDeleted() {
                    return deleted;
                }

                /** 
                 * Set the 'deleted' attribute value. Specifies that this is a deleted PQ
                 * 
                 * @param deleted
                 */
                public void setDeleted(Boolean deleted) {
                    this.deleted = deleted;
                }

                /** 
                 * Get the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @return value
                 */
                public Boolean getItineraryChange() {
                    return itineraryChange;
                }

                /** 
                 * Set the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
                 * 
                 * @param itineraryChange
                 */
                public void setItineraryChange(Boolean itineraryChange) {
                    this.itineraryChange = itineraryChange;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManualPricing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="verifyFareCalculation"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ManualPricing implements Serializable
                {
                    private Boolean verifyFareCalculation;

                    /** 
                     * Get the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @return value
                     */
                    public Boolean getVerifyFareCalculation() {
                        return verifyFareCalculation;
                    }

                    /** 
                     * Set the 'verifyFareCalculation' attribute value. Ref:  DM0Z_40_PID1
                                                                                                          #DM0Z_40_VRF
                     * 
                     * @param verifyFareCalculation
                     */
                    public void setVerifyFareCalculation(
                            Boolean verifyFareCalculation) {
                        this.verifyFareCalculation = verifyFareCalculation;
                    }
                }
            }
            /** 
             * Passenger data related to PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="requestedType"/>
             *     &lt;xs:attribute type="xs:string" name="pricedType"/>
             *     &lt;xs:attribute type="xs:int" name="passengerTypeCount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passenger implements Serializable
            {
                private String type;
                private String requestedType;
                private String pricedType;
                private Integer passengerTypeCount;

                /** 
                 * Get the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Passenger Type
                                                                                            Ref: DM0Z_40_PTCD
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @return value
                 */
                public String getRequestedType() {
                    return requestedType;
                }

                /** 
                 * Set the 'requestedType' attribute value. Input Passenger Type.
                                                                                            Ref: DM0Z_40_PTCI
                 * 
                 * @param requestedType
                 */
                public void setRequestedType(String requestedType) {
                    this.requestedType = requestedType;
                }

                /** 
                 * Get the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @return value
                 */
                public String getPricedType() {
                    return pricedType;
                }

                /** 
                 * Set the 'pricedType' attribute value. Passenger Type priced.
                                                                                            Ref: DM0Z_40_TPTC
                 * 
                 * @param pricedType
                 */
                public void setPricedType(String pricedType) {
                    this.pricedType = pricedType;
                }

                /** 
                 * Get the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @return value
                 */
                public Integer getPassengerTypeCount() {
                    return passengerTypeCount;
                }

                /** 
                 * Set the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
                 * 
                 * @param passengerTypeCount
                 */
                public void setPassengerTypeCount(Integer passengerTypeCount) {
                    this.passengerTypeCount = passengerTypeCount;
                }
            }
            /** 
             * Only 50 fee items can be stored per PQ
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Waiver" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="itemId"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fee implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private String waiver;
                private String type;
                private String code;
                private BigInteger itemId;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Get the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @return value
                 */
                public String getWaiver() {
                    return waiver;
                }

                /** 
                 * Set the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
                                                                                                override functionality is used, the transaction will be logged to the overrride report.
                 * 
                 * @param waiver
                 */
                public void setWaiver(String waiver) {
                    this.waiver = waiver;
                }

                /** 
                 * Get the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Group or type which the fee belongs to.

                                                                                            Possible Values:
                                                                                            OB
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the fee.

                                                                                            Possible values:
                                                                                            R01
                                                                                            R02-R12
                                                                                            T01
                                                                                            T02-T20
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @return value
                 */
                public BigInteger getItemId() {
                    return itemId;
                }

                /** 
                 * Set the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
                 * 
                 * @param itemId
                 */
                public void setItemId(BigInteger itemId) {
                    this.itemId = itemId;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amounts" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Total" minOccurs="0">
             *         &lt;!-- Reference to inner class Total -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ReissueDifference" minOccurs="0">
             *         &lt;!-- Reference to inner class ReissueDifference -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amounts implements Serializable
            {
                private Total total;
                private ReissueDifference reissueDifference;

                /** 
                 * Get the 'Total' element value.
                 * 
                 * @return value
                 */
                public Total getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value.
                 * 
                 * @param total
                 */
                public void setTotal(Total total) {
                    this.total = total;
                }

                /** 
                 * Get the 'ReissueDifference' element value.
                 * 
                 * @return value
                 */
                public ReissueDifference getReissueDifference() {
                    return reissueDifference;
                }

                /** 
                 * Set the 'ReissueDifference' element value.
                 * 
                 * @param reissueDifference
                 */
                public void setReissueDifference(
                        ReissueDifference reissueDifference) {
                    this.reissueDifference = reissueDifference;
                }
                /** 
                 * Total fare inclusive taxes per PQ type
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Total implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Reissue  difference amount (for add collect, refund or even exchange)
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissueDifference" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ReissueDifference implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *         &lt;xs:attribute type="xs:integer" name="number"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MessageInfo implements Serializable
            {
                private String string;
                private String type;
                private BigInteger number;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ERROR
                                                                                                    WARNING
                                                                                                    INFO

                                                                                                    Ref:  DM0Z_60_TYPE

                                                                                                    x'0C,04,11,03,13
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'number' attribute value. Message number

                                                                                                    Ref: DM0Z_60_MNBR
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="PQ"/>
             *     &lt;xs:enumeration value="PQR"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                PQ, PQR
            }
        }
    }
    /** 
     * Price Quote Record :  This information is equivalent to *PQSB/*PQST
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SummaryByPassengerType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Total" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Total -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SummaryByPassengerType implements Serializable
    {
        private List<FareInfo> fareInfoList = new ArrayList<FareInfo>();
        private List<Total> totalList = new ArrayList<Total>();

        /** 
         * Get the list of 'FareInfo' element items.
         * 
         * @return list
         */
        public List<FareInfo> getFareInfoList() {
            return fareInfoList;
        }

        /** 
         * Set the list of 'FareInfo' element items.
         * 
         * @param list
         */
        public void setFareInfoList(List<FareInfo> list) {
            fareInfoList = list;
        }

        /** 
         * Get the list of 'Total' element items.
         * 
         * @return list
         */
        public List<Total> getTotalList() {
            return totalList;
        }

        /** 
         * Set the list of 'Total' element items.
         * 
         * @param list
         */
        public void setTotalList(List<Total> list) {
            totalList = list;
        }
        /** 
         * Fare details in the PriceQuote
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EquivalentFare" minOccurs="0">
         *         &lt;!-- Reference to inner class EquivalentFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalTax" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalTax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalFare" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalFare -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="passengerType"/>
         *     &lt;xs:attribute type="xs:int" name="passengerTypeCount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareInfo implements Serializable
        {
            private BaseFare baseFare;
            private EquivalentFare equivalentFare;
            private TotalTax totalTax;
            private TotalFare totalFare;
            private String passengerType;
            private Integer passengerTypeCount;

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value.
             * 
             * @return value
             */
            public EquivalentFare getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value.
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(EquivalentFare equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value.
             * 
             * @return value
             */
            public TotalTax getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value.
             * 
             * @param totalTax
             */
            public void setTotalTax(TotalTax totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalFare' element value.
             * 
             * @return value
             */
            public TotalFare getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value.
             * 
             * @param totalFare
             */
            public void setTotalFare(TotalFare totalFare) {
                this.totalFare = totalFare;
            }

            /** 
             * Get the 'passengerType' attribute value. Passenger Type - 			Ref: DM0Z_40_PTCD, DM0Z_40_TPTC
             * 
             * @return value
             */
            public String getPassengerType() {
                return passengerType;
            }

            /** 
             * Set the 'passengerType' attribute value. Passenger Type - 			Ref: DM0Z_40_PTCD, DM0Z_40_TPTC
             * 
             * @param passengerType
             */
            public void setPassengerType(String passengerType) {
                this.passengerType = passengerType;
            }

            /** 
             * Get the 'passengerTypeCount' attribute value. Number of passengers for a particular-
                                                                              passenger type, applicable only for PQST
             * 
             * @return value
             */
            public Integer getPassengerTypeCount() {
                return passengerTypeCount;
            }

            /** 
             * Set the 'passengerTypeCount' attribute value. Number of passengers for a particular-
                                                                              passenger type, applicable only for PQST
             * 
             * @param passengerTypeCount
             */
            public void setPassengerTypeCount(Integer passengerTypeCount) {
                this.passengerTypeCount = passengerTypeCount;
            }
            /** 
             * Base fare - passenger type
                                                                                  Ref: DM0Z_85_BFAR(Group) Value: DM0Z_85_BAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Equivalent Fare - passenger type
                                                                                  Ref: DM0Z_85_EFAR(Group) Value: DM0Z_85_EAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EquivalentFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Tax Total - passenger type
                                                                                  Ref:DM0Z_85_TTAC(Group) Value: DM0Z_85_TTAX (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalTax implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Total fare inclusive of taxes -  passenger type
                                                                                  Ref: DM0Z_85_TFAR	(Group) Value: DM0Z_85_TAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
        }
        /** 
         * Sum of price quote fares for all passenger types
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EquivalentFare" minOccurs="0">
         *         &lt;!-- Reference to inner class EquivalentFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalTax" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalTax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalFare" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalFare -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Total implements Serializable
        {
            private BaseFare baseFare;
            private EquivalentFare equivalentFare;
            private TotalTax totalTax;
            private TotalFare totalFare;

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value.
             * 
             * @return value
             */
            public EquivalentFare getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value.
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(EquivalentFare equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value.
             * 
             * @return value
             */
            public TotalTax getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value.
             * 
             * @param totalTax
             */
            public void setTotalTax(TotalTax totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalFare' element value.
             * 
             * @return value
             */
            public TotalFare getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value.
             * 
             * @param totalFare
             */
            public void setTotalFare(TotalFare totalFare) {
                this.totalFare = totalFare;
            }
            /** 
             * Base fare - passenger type
                                                                                  Ref: DM0Z_85_BFAR(Group) Value: DM0Z_85_BAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Equivalent Fare - passenger type
                                                                                  Ref: DM0Z_85_EFAR(Group) Value: DM0Z_85_EAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EquivalentFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Tax Total - passenger type
                                                                                  Ref:DM0Z_85_TTAC(Group) Value: DM0Z_85_TTAX (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalTax implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Total fare inclusive of taxes -  passenger type
                                                                                  Ref: DM0Z_85_TFAR	(Group) Value: DM0Z_85_TAMT (totals per type)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
        }
    }
    /** 
     * Price Quote details. This information is equivalent to *PQ
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AgentInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="HomeLocation"/>
     *             &lt;xs:element type="xs:string" name="WorkLocation" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" name="sine"/>
     *           &lt;xs:attribute type="xs:string" name="duty"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="TransactionInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:dateTime" name="CreateDateTime"/>
     *             &lt;xs:element type="xs:dateTime" name="UpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalUpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class NameAssociationInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SegmentInfo" minOccurs="0" maxOccurs="30">
     *         &lt;!-- Reference to inner class SegmentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AdditionalFareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AdditionalFareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FeeInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FeeInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiscellaneousInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscellaneousInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaymentInfo" minOccurs="0" maxOccurs="2">
     *         &lt;!-- Reference to inner class PaymentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MessageInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MessageInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="HistoryInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HistoryInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute use="required" name="type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
     *     &lt;xs:attribute type="xs:string" name="passengerType"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
     *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
     *     &lt;xs:attribute type="xs:boolean" name="displayOnly"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private String agentInfoHomeLocation;
        private String agentInfoWorkLocation;
        private String agentInfoSine;
        private String agentInfoDuty;
        private Date transactionInfoCreateDateTime;
        private Date transactionInfoUpdateDateTime;
        private Date transactionInfoLastDateToPurchase;
        private Date transactionInfoLocalCreateDateTime;
        private Date transactionInfoLocalUpdateDateTime;
        private Date transactionInfoExpiryDateTime;
        private String transactionInfoInputEntry;
        private List<NameAssociationInfo> nameAssociationInfoList = new ArrayList<NameAssociationInfo>();
        private List<SegmentInfo> segmentInfoList = new ArrayList<SegmentInfo>();
        private FareInfo fareInfo;
        private AdditionalFareInfo additionalFareInfo;
        private List<FeeInfo> feeInfoList = new ArrayList<FeeInfo>();
        private MiscellaneousInfo miscellaneousInfo;
        private List<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>();
        private MessageInfo messageInfo;
        private List<HistoryInfo> historyInfoList = new ArrayList<HistoryInfo>();
        private Type type;
        private BigInteger number;
        private String passengerType;
        private String status;
        private String pricingType;
        private String pricingStatus;
        private Boolean displayOnly;

        /** 
         * Get the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @return value
         */
        public String getAgentInfoHomeLocation() {
            return agentInfoHomeLocation;
        }

        /** 
         * Set the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @param agentInfoHomeLocation
         */
        public void setAgentInfoHomeLocation(String agentInfoHomeLocation) {
            this.agentInfoHomeLocation = agentInfoHomeLocation;
        }

        /** 
         * Get the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @return value
         */
        public String getAgentInfoWorkLocation() {
            return agentInfoWorkLocation;
        }

        /** 
         * Set the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @param agentInfoWorkLocation
         */
        public void setAgentInfoWorkLocation(String agentInfoWorkLocation) {
            this.agentInfoWorkLocation = agentInfoWorkLocation;
        }

        /** 
         * Get the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @return value
         */
        public String getAgentInfoSine() {
            return agentInfoSine;
        }

        /** 
         * Set the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @param agentInfoSine
         */
        public void setAgentInfoSine(String agentInfoSine) {
            this.agentInfoSine = agentInfoSine;
        }

        /** 
         * Get the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @return value
         */
        public String getAgentInfoDuty() {
            return agentInfoDuty;
        }

        /** 
         * Set the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @param agentInfoDuty
         */
        public void setAgentInfoDuty(String agentInfoDuty) {
            this.agentInfoDuty = agentInfoDuty;
        }

        /** 
         * Get the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @return value
         */
        public Date getTransactionInfoCreateDateTime() {
            return transactionInfoCreateDateTime;
        }

        /** 
         * Set the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @param transactionInfoCreateDateTime
         */
        public void setTransactionInfoCreateDateTime(
                Date transactionInfoCreateDateTime) {
            this.transactionInfoCreateDateTime = transactionInfoCreateDateTime;
        }

        /** 
         * Get the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoUpdateDateTime() {
            return transactionInfoUpdateDateTime;
        }

        /** 
         * Set the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @param transactionInfoUpdateDateTime
         */
        public void setTransactionInfoUpdateDateTime(
                Date transactionInfoUpdateDateTime) {
            this.transactionInfoUpdateDateTime = transactionInfoUpdateDateTime;
        }

        /** 
         * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @return value
         */
        public Date getTransactionInfoLastDateToPurchase() {
            return transactionInfoLastDateToPurchase;
        }

        /** 
         * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @param transactionInfoLastDateToPurchase
         */
        public void setTransactionInfoLastDateToPurchase(
                Date transactionInfoLastDateToPurchase) {
            this.transactionInfoLastDateToPurchase = transactionInfoLastDateToPurchase;
        }

        /** 
         * Get the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @return value
         */
        public Date getTransactionInfoLocalCreateDateTime() {
            return transactionInfoLocalCreateDateTime;
        }

        /** 
         * Set the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @param transactionInfoLocalCreateDateTime
         */
        public void setTransactionInfoLocalCreateDateTime(
                Date transactionInfoLocalCreateDateTime) {
            this.transactionInfoLocalCreateDateTime = transactionInfoLocalCreateDateTime;
        }

        /** 
         * Get the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoLocalUpdateDateTime() {
            return transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Set the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @param transactionInfoLocalUpdateDateTime
         */
        public void setTransactionInfoLocalUpdateDateTime(
                Date transactionInfoLocalUpdateDateTime) {
            this.transactionInfoLocalUpdateDateTime = transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @return value
         */
        public Date getTransactionInfoExpiryDateTime() {
            return transactionInfoExpiryDateTime;
        }

        /** 
         * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @param transactionInfoExpiryDateTime
         */
        public void setTransactionInfoExpiryDateTime(
                Date transactionInfoExpiryDateTime) {
            this.transactionInfoExpiryDateTime = transactionInfoExpiryDateTime;
        }

        /** 
         * Get the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @return value
         */
        public String getTransactionInfoInputEntry() {
            return transactionInfoInputEntry;
        }

        /** 
         * Set the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @param transactionInfoInputEntry
         */
        public void setTransactionInfoInputEntry(
                String transactionInfoInputEntry) {
            this.transactionInfoInputEntry = transactionInfoInputEntry;
        }

        /** 
         * Get the list of 'NameAssociationInfo' element items.
         * 
         * @return list
         */
        public List<NameAssociationInfo> getNameAssociationInfoList() {
            return nameAssociationInfoList;
        }

        /** 
         * Set the list of 'NameAssociationInfo' element items.
         * 
         * @param list
         */
        public void setNameAssociationInfoList(List<NameAssociationInfo> list) {
            nameAssociationInfoList = list;
        }

        /** 
         * Get the list of 'SegmentInfo' element items.
         * 
         * @return list
         */
        public List<SegmentInfo> getSegmentInfoList() {
            return segmentInfoList;
        }

        /** 
         * Set the list of 'SegmentInfo' element items.
         * 
         * @param list
         */
        public void setSegmentInfoList(List<SegmentInfo> list) {
            segmentInfoList = list;
        }

        /** 
         * Get the 'FareInfo' element value.
         * 
         * @return value
         */
        public FareInfo getFareInfo() {
            return fareInfo;
        }

        /** 
         * Set the 'FareInfo' element value.
         * 
         * @param fareInfo
         */
        public void setFareInfo(FareInfo fareInfo) {
            this.fareInfo = fareInfo;
        }

        /** 
         * Get the 'AdditionalFareInfo' element value.
         * 
         * @return value
         */
        public AdditionalFareInfo getAdditionalFareInfo() {
            return additionalFareInfo;
        }

        /** 
         * Set the 'AdditionalFareInfo' element value.
         * 
         * @param additionalFareInfo
         */
        public void setAdditionalFareInfo(AdditionalFareInfo additionalFareInfo) {
            this.additionalFareInfo = additionalFareInfo;
        }

        /** 
         * Get the list of 'FeeInfo' element items.
         * 
         * @return list
         */
        public List<FeeInfo> getFeeInfoList() {
            return feeInfoList;
        }

        /** 
         * Set the list of 'FeeInfo' element items.
         * 
         * @param list
         */
        public void setFeeInfoList(List<FeeInfo> list) {
            feeInfoList = list;
        }

        /** 
         * Get the 'MiscellaneousInfo' element value.
         * 
         * @return value
         */
        public MiscellaneousInfo getMiscellaneousInfo() {
            return miscellaneousInfo;
        }

        /** 
         * Set the 'MiscellaneousInfo' element value.
         * 
         * @param miscellaneousInfo
         */
        public void setMiscellaneousInfo(MiscellaneousInfo miscellaneousInfo) {
            this.miscellaneousInfo = miscellaneousInfo;
        }

        /** 
         * Get the list of 'PaymentInfo' element items.
         * 
         * @return list
         */
        public List<PaymentInfo> getPaymentInfoList() {
            return paymentInfoList;
        }

        /** 
         * Set the list of 'PaymentInfo' element items.
         * 
         * @param list
         */
        public void setPaymentInfoList(List<PaymentInfo> list) {
            paymentInfoList = list;
        }

        /** 
         * Get the 'MessageInfo' element value.
         * 
         * @return value
         */
        public MessageInfo getMessageInfo() {
            return messageInfo;
        }

        /** 
         * Set the 'MessageInfo' element value.
         * 
         * @param messageInfo
         */
        public void setMessageInfo(MessageInfo messageInfo) {
            this.messageInfo = messageInfo;
        }

        /** 
         * Get the list of 'HistoryInfo' element items.
         * 
         * @return list
         */
        public List<HistoryInfo> getHistoryInfoList() {
            return historyInfoList;
        }

        /** 
         * Set the list of 'HistoryInfo' element items.
         * 
         * @param list
         */
        public void setHistoryInfoList(List<HistoryInfo> list) {
            historyInfoList = list;
        }

        /** 
         * Get the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ - Price Quote Record
                                                        PQR - Price Quote Reissue
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ - Price Quote Record
                                                        PQR - Price Quote Reissue
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }

        /** 
         * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
                                                        Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
         * 
         * @return value
         */
        public String getPassengerType() {
            return passengerType;
        }

        /** 
         * Set the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
                                                        Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
         * 
         * @param passengerType
         */
        public void setPassengerType(String passengerType) {
            this.passengerType = passengerType;
        }

        /** 
         * Get the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @return value
         */
        public String getStatus() {
            return status;
        }

        /** 
         * Set the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @param status
         */
        public void setStatus(String status) {
            this.status = status;
        }

        /** 
         * Get the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @return value
         */
        public String getPricingType() {
            return pricingType;
        }

        /** 
         * Set the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @param pricingType
         */
        public void setPricingType(String pricingType) {
            this.pricingType = pricingType;
        }

        /** 
         * Get the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @return value
         */
        public String getPricingStatus() {
            return pricingStatus;
        }

        /** 
         * Set the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @param pricingStatus
         */
        public void setPricingStatus(String pricingStatus) {
            this.pricingStatus = pricingStatus;
        }

        /** 
         * Get the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @return value
         */
        public Boolean getDisplayOnly() {
            return displayOnly;
        }

        /** 
         * Set the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @param displayOnly
         */
        public void setDisplayOnly(Boolean displayOnly) {
            this.displayOnly = displayOnly;
        }
        /** 
         * List of associated traveler names
                                                            for this PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="nameNumber"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="nameId"/>
         *     &lt;xs:attribute type="xs:string" name="firstName"/>
         *     &lt;xs:attribute type="xs:string" name="lastName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NameAssociationInfo implements Serializable
        {
            private String nameNumber;
            private BigInteger nameId;
            private String firstName;
            private String lastName;

            /** 
             * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }

            /** 
             * Get the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
             * 
             * @return value
             */
            public BigInteger getNameId() {
                return nameId;
            }

            /** 
             * Set the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
             * 
             * @param nameId
             */
            public void setNameId(BigInteger nameId) {
                this.nameId = nameId;
            }

            /** 
             * Get the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
             * 
             * @return value
             */
            public String getFirstName() {
                return firstName;
            }

            /** 
             * Set the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
             * 
             * @param firstName
             */
            public void setFirstName(String firstName) {
                this.firstName = firstName;
            }

            /** 
             * Get the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
             * 
             * @return value
             */
            public String getLastName() {
                return lastName;
            }

            /** 
             * Set the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
             * 
             * @param lastName
             */
            public void setLastName(String lastName) {
                this.lastName = lastName;
            }
        }
        /** 
         * Data associated to the segments priced within the PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentInfo" minOccurs="0" maxOccurs="30">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Flight" minOccurs="0">
         *         &lt;!-- Reference to inner class Flight -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="NotValidBefore" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="NotValidAfter" minOccurs="0"/>
         *       &lt;xs:element name="Baggage" minOccurs="0">
         *         &lt;!-- Reference to inner class Baggage -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="number"/>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *     &lt;xs:attribute type="xs:string" name="segmentStatus"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SegmentInfo implements Serializable
        {
            private Flight flight;
            private String fareBasis;
            private java.sql.Date notValidBefore;
            private java.sql.Date notValidAfter;
            private Baggage baggage;
            private BigInteger number;
            private String type;
            private String segmentStatus;

            /** 
             * Get the 'Flight' element value.
             * 
             * @return value
             */
            public Flight getFlight() {
                return flight;
            }

            /** 
             * Set the 'Flight' element value.
             * 
             * @param flight
             */
            public void setFlight(Flight flight) {
                this.flight = flight;
            }

            /** 
             * Get the 'FareBasis' element value. Ref: DM0Z_70_FBCD
             * 
             * @return value
             */
            public String getFareBasis() {
                return fareBasis;
            }

            /** 
             * Set the 'FareBasis' element value. Ref: DM0Z_70_FBCD
             * 
             * @param fareBasis
             */
            public void setFareBasis(String fareBasis) {
                this.fareBasis = fareBasis;
            }

            /** 
             * Get the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVBB
             * 
             * @return value
             */
            public java.sql.Date getNotValidBefore() {
                return notValidBefore;
            }

            /** 
             * Set the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVBB
             * 
             * @param notValidBefore
             */
            public void setNotValidBefore(java.sql.Date notValidBefore) {
                this.notValidBefore = notValidBefore;
            }

            /** 
             * Get the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVAB
             * 
             * @return value
             */
            public java.sql.Date getNotValidAfter() {
                return notValidAfter;
            }

            /** 
             * Set the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVAB
             * 
             * @param notValidAfter
             */
            public void setNotValidAfter(java.sql.Date notValidAfter) {
                this.notValidAfter = notValidAfter;
            }

            /** 
             * Get the 'Baggage' element value.
             * 
             * @return value
             */
            public Baggage getBaggage() {
                return baggage;
            }

            /** 
             * Set the 'Baggage' element value.
             * 
             * @param baggage
             */
            public void setBaggage(Baggage baggage) {
                this.baggage = baggage;
            }

            /** 
             * Get the 'number' attribute value. PNR Segment Number at PQ create.
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. PNR Segment Number at PQ create.
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'type' attribute value. Possible values:
                                                                      A = Arunk
                                                                      O = Open
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Possible values:
                                                                      A = Arunk
                                                                      O = Open
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'segmentStatus' attribute value. Possbile values:
                                                                      OK
                                                                      HQ
                                                                      Ref: DM0Z_70_STAT
             * 
             * @return value
             */
            public String getSegmentStatus() {
                return segmentStatus;
            }

            /** 
             * Set the 'segmentStatus' attribute value. Possbile values:
                                                                      OK
                                                                      HQ
                                                                      Ref: DM0Z_70_STAT
             * 
             * @param segmentStatus
             */
            public void setSegmentStatus(String segmentStatus) {
                this.segmentStatus = segmentStatus;
            }
            /** 
             * FlightInfo
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MarketingFlight" minOccurs="0">
             *         &lt;!-- Reference to inner class MarketingFlight -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
             *       &lt;xs:element name="Departure" minOccurs="0">
             *         &lt;!-- Reference to inner class Departure -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Arrival" minOccurs="0">
             *         &lt;!-- Reference to inner class Arrival -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="connectionIndicator"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Flight implements Serializable
            {
                private MarketingFlight marketingFlight;
                private String classOfService;
                private Departure departure;
                private Arrival arrival;
                private String connectionIndicator;

                /** 
                 * Get the 'MarketingFlight' element value.
                 * 
                 * @return value
                 */
                public MarketingFlight getMarketingFlight() {
                    return marketingFlight;
                }

                /** 
                 * Set the 'MarketingFlight' element value.
                 * 
                 * @param marketingFlight
                 */
                public void setMarketingFlight(MarketingFlight marketingFlight) {
                    this.marketingFlight = marketingFlight;
                }

                /** 
                 * Get the 'ClassOfService' element value. Booking class of service
                                                                                        Ref: DM0Z_70_CLSP
                 * 
                 * @return value
                 */
                public String getClassOfService() {
                    return classOfService;
                }

                /** 
                 * Set the 'ClassOfService' element value. Booking class of service
                                                                                        Ref: DM0Z_70_CLSP
                 * 
                 * @param classOfService
                 */
                public void setClassOfService(String classOfService) {
                    this.classOfService = classOfService;
                }

                /** 
                 * Get the 'Departure' element value.
                 * 
                 * @return value
                 */
                public Departure getDeparture() {
                    return departure;
                }

                /** 
                 * Set the 'Departure' element value.
                 * 
                 * @param departure
                 */
                public void setDeparture(Departure departure) {
                    this.departure = departure;
                }

                /** 
                 * Get the 'Arrival' element value.
                 * 
                 * @return value
                 */
                public Arrival getArrival() {
                    return arrival;
                }

                /** 
                 * Set the 'Arrival' element value.
                 * 
                 * @param arrival
                 */
                public void setArrival(Arrival arrival) {
                    this.arrival = arrival;
                }

                /** 
                 * Get the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
                                                                                    Ref: DM0Z_70_DCON. Possible values:
                                                                                    X = Transit
                                                                                    O = Stopover
                 * 
                 * @return value
                 */
                public String getConnectionIndicator() {
                    return connectionIndicator;
                }

                /** 
                 * Set the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
                                                                                    Ref: DM0Z_70_DCON. Possible values:
                                                                                    X = Transit
                                                                                    O = Stopover
                 * 
                 * @param connectionIndicator
                 */
                public void setConnectionIndicator(String connectionIndicator) {
                    this.connectionIndicator = connectionIndicator;
                }
                /** 
                 * Marketing Flight Info

                                                                                        Carrier Code
                                                                                        Ref: DM0Z_70_CXRM
                                                                                        Flight number
                                                                                        Ref: DM0Z_70_FLTM
                                                                                        Carrier name DM0Z_70_CXNM
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingFlight" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="number"/>
                 *         &lt;xs:attribute type="xs:string" name="name"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MarketingFlight implements Serializable
                {
                    private String string;
                    private String number;
                    private String name;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'number' attribute value. Flight  Number
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'number' attribute value. Flight  Number
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'name' attribute value. Carrier Name
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'name' attribute value. Carrier Name
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }
                }
                /** 
                 * Departure Info

                                                                                        Departure DateTime
                                                                                        Ref: DM0Z_70_FDDB
                                                                                        Ref:DM0Z_70_FDTB
                                                                                        Departure CityCode
                                                                                        Ref: DM0Z_70_DCTY
                                                                                        Departure City name
                                                                                        Ref: DM0Z_70_DCTN
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Departure" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:dateTime" name="DateTime" minOccurs="0"/>
                 *       &lt;xs:element name="CityCode">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:string">
                 *               &lt;xs:attribute type="xs:string" name="name"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Departure implements Serializable
                {
                    private Date dateTime;
                    private String cityCodeString;
                    private String cityCodeName;

                    /** 
                     * Get the 'DateTime' element value.
                     * 
                     * @return value
                     */
                    public Date getDateTime() {
                        return dateTime;
                    }

                    /** 
                     * Set the 'DateTime' element value.
                     * 
                     * @param dateTime
                     */
                    public void setDateTime(Date dateTime) {
                        this.dateTime = dateTime;
                    }

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getCityCodeString() {
                        return cityCodeString;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param cityCodeString
                     */
                    public void setCityCodeString(String cityCodeString) {
                        this.cityCodeString = cityCodeString;
                    }

                    /** 
                     * Get the 'name' attribute value.
                     * 
                     * @return value
                     */
                    public String getCityCodeName() {
                        return cityCodeName;
                    }

                    /** 
                     * Set the 'name' attribute value.
                     * 
                     * @param cityCodeName
                     */
                    public void setCityCodeName(String cityCodeName) {
                        this.cityCodeName = cityCodeName;
                    }
                }
                /** 
                 * Arrival Info

                                                                                        Arrival DateTime
                                                                                        Ref: DM0Z_70_FADB
                                                                                        Ref:DM0Z_70_FATB
                                                                                        Arrival CityCode
                                                                                        Ref: DM0Z_70_ACTY
                                                                                        Arrival City name
                                                                                        Ref:DM0Z_70_ACTN
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Arrival" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:dateTime" name="DateTime" minOccurs="0"/>
                 *       &lt;xs:element name="CityCode">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:string">
                 *               &lt;xs:attribute type="xs:string" name="name"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Arrival implements Serializable
                {
                    private Date dateTime;
                    private String cityCodeString;
                    private String cityCodeName;

                    /** 
                     * Get the 'DateTime' element value.
                     * 
                     * @return value
                     */
                    public Date getDateTime() {
                        return dateTime;
                    }

                    /** 
                     * Set the 'DateTime' element value.
                     * 
                     * @param dateTime
                     */
                    public void setDateTime(Date dateTime) {
                        this.dateTime = dateTime;
                    }

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getCityCodeString() {
                        return cityCodeString;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param cityCodeString
                     */
                    public void setCityCodeString(String cityCodeString) {
                        this.cityCodeString = cityCodeString;
                    }

                    /** 
                     * Get the 'name' attribute value.
                     * 
                     * @return value
                     */
                    public String getCityCodeName() {
                        return cityCodeName;
                    }

                    /** 
                     * Set the 'name' attribute value.
                     * 
                     * @param cityCodeName
                     */
                    public void setCityCodeName(String cityCodeName) {
                        this.cityCodeName = cityCodeName;
                    }
                }
            }
            /** 
             * Baggage information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Baggage" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="allowance"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Baggage implements Serializable
            {
                private String type;
                private String allowance;

                /** 
                 * Get the 'type' attribute value. Baggage type. Ref: DM0Z_70_BTYP
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Baggage type. Ref: DM0Z_70_BTYP
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'allowance' attribute value. Number of bags to be checked in. Ref: DM0Z_70_BAMT
                 * 
                 * @return value
                 */
                public String getAllowance() {
                    return allowance;
                }

                /** 
                 * Set the 'allowance' attribute value. Number of bags to be checked in. Ref: DM0Z_70_BAMT
                 * 
                 * @param allowance
                 */
                public void setAllowance(String allowance) {
                    this.allowance = allowance;
                }
            }
        }
        /** 
         * Fare details associated to the selling fare equivalent *PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FareIndicators" minOccurs="0">
         *         &lt;!-- Reference to inner class FareIndicators -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EquivalentFare" minOccurs="0">
         *         &lt;!-- Reference to inner class EquivalentFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalTax" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalTax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalFare" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TaxInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class TaxInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FareCalculation" minOccurs="0"/>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class HandlingFee -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OptionalServiceInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class OptionalServiceInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *     &lt;xs:attribute type="xs:string" name="source"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareInfo implements Serializable
        {
            private FareIndicators fareIndicators;
            private BaseFare baseFare;
            private EquivalentFare equivalentFare;
            private TotalTax totalTax;
            private TotalFare totalFare;
            private TaxInfo taxInfo;
            private String fareCalculation;
            private Commission commission;
            private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();
            private List<OptionalServiceInfo> optionalServiceInfoList = new ArrayList<OptionalServiceInfo>();
            private String type;
            private String source;

            /** 
             * Get the 'FareIndicators' element value.
             * 
             * @return value
             */
            public FareIndicators getFareIndicators() {
                return fareIndicators;
            }

            /** 
             * Set the 'FareIndicators' element value.
             * 
             * @param fareIndicators
             */
            public void setFareIndicators(FareIndicators fareIndicators) {
                this.fareIndicators = fareIndicators;
            }

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value.
             * 
             * @return value
             */
            public EquivalentFare getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value.
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(EquivalentFare equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value.
             * 
             * @return value
             */
            public TotalTax getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value.
             * 
             * @param totalTax
             */
            public void setTotalTax(TotalTax totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalFare' element value.
             * 
             * @return value
             */
            public TotalFare getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value.
             * 
             * @param totalFare
             */
            public void setTotalFare(TotalFare totalFare) {
                this.totalFare = totalFare;
            }

            /** 
             * Get the 'TaxInfo' element value.
             * 
             * @return value
             */
            public TaxInfo getTaxInfo() {
                return taxInfo;
            }

            /** 
             * Set the 'TaxInfo' element value.
             * 
             * @param taxInfo
             */
            public void setTaxInfo(TaxInfo taxInfo) {
                this.taxInfo = taxInfo;
            }

            /** 
             * Get the 'FareCalculation' element value. FareCalc line free Text

                                                                          Ref: DM0Z_A5_DATA
             * 
             * @return value
             */
            public String getFareCalculation() {
                return fareCalculation;
            }

            /** 
             * Set the 'FareCalculation' element value. FareCalc line free Text

                                                                          Ref: DM0Z_A5_DATA
             * 
             * @param fareCalculation
             */
            public void setFareCalculation(String fareCalculation) {
                this.fareCalculation = fareCalculation;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the list of 'HandlingFee' element items.
             * 
             * @return list
             */
            public List<HandlingFee> getHandlingFeeList() {
                return handlingFeeList;
            }

            /** 
             * Set the list of 'HandlingFee' element items.
             * 
             * @param list
             */
            public void setHandlingFeeList(List<HandlingFee> list) {
                handlingFeeList = list;
            }

            /** 
             * Get the list of 'OptionalServiceInfo' element items.
             * 
             * @return list
             */
            public List<OptionalServiceInfo> getOptionalServiceInfoList() {
                return optionalServiceInfoList;
            }

            /** 
             * Set the list of 'OptionalServiceInfo' element items.
             * 
             * @param list
             */
            public void setOptionalServiceInfoList(
                    List<OptionalServiceInfo> list) {
                optionalServiceInfoList = list;
            }

            /** 
             * Get the 'type' attribute value. Type associated to the primary selling fare.

                                                                      Possible Values:
                                                                      ASL - Adjusted Selling Fare
                                                                      MSL - Manual Adjusted Selling Fare

                                                                      Ref: DM0Z_85_FTY #DM0Z_85_NOR

                                                                      DM0Z_CA_FTYP
                                                                      #DM0Z_CA_ASL #DM0Z_CA_MSL
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Type associated to the primary selling fare.

                                                                      Possible Values:
                                                                      ASL - Adjusted Selling Fare
                                                                      MSL - Manual Adjusted Selling Fare

                                                                      Ref: DM0Z_85_FTY #DM0Z_85_NOR

                                                                      DM0Z_CA_FTYP
                                                                      #DM0Z_CA_ASL #DM0Z_CA_MSL
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'source' attribute value. Fare source/vendor
                                                                      Ref: DM0Z_85_FAR_SRCE
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'source' attribute value. Fare source/vendor
                                                                      Ref: DM0Z_85_FAR_SRCE
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }
            /** 
             * Fare level Indicators
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareIndicators" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" name="governmentApproval"/>
             *     &lt;xs:attribute type="xs:boolean" name="negotiatedFare"/>
             *     &lt;xs:attribute type="xs:boolean" name="NUC_Suppression"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareIndicators implements Serializable
            {
                private Boolean governmentApproval;
                private Boolean negotiatedFare;
                private Boolean NUCSuppression;

                /** 
                 * Get the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

                                                                                    Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
                 * 
                 * @return value
                 */
                public Boolean getGovernmentApproval() {
                    return governmentApproval;
                }

                /** 
                 * Set the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

                                                                                    Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
                 * 
                 * @param governmentApproval
                 */
                public void setGovernmentApproval(Boolean governmentApproval) {
                    this.governmentApproval = governmentApproval;
                }

                /** 
                 * Get the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

                                                                                    Ref:
                                                                                    Abacus
                                                                                    DM0Z_40_FSCI
                                                                                    #DM0Z_40_XFAR
                                                                                    DM0Z_E8_RMT_TYPE

                                                                                    Infini
                                                                                    DM0Z_40_RSTA #DM0Z_40_MAN
                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_BCAT
                 * 
                 * @return value
                 */
                public Boolean getNegotiatedFare() {
                    return negotiatedFare;
                }

                /** 
                 * Set the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

                                                                                    Ref:
                                                                                    Abacus
                                                                                    DM0Z_40_FSCI
                                                                                    #DM0Z_40_XFAR
                                                                                    DM0Z_E8_RMT_TYPE

                                                                                    Infini
                                                                                    DM0Z_40_RSTA #DM0Z_40_MAN
                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_BCAT
                 * 
                 * @param negotiatedFare
                 */
                public void setNegotiatedFare(Boolean negotiatedFare) {
                    this.negotiatedFare = negotiatedFare;
                }

                /** 
                 * Get the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

                                                                                    Ref: DM0Z_65_ID01
                                                                                    #DM0Z_65_NUC
                 * 
                 * @return value
                 */
                public Boolean getNUCSuppression() {
                    return NUCSuppression;
                }

                /** 
                 * Set the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

                                                                                    Ref: DM0Z_65_ID01
                                                                                    #DM0Z_65_NUC
                 * 
                 * @param NUCSuppression
                 */
                public void setNUCSuppression(Boolean NUCSuppression) {
                    this.NUCSuppression = NUCSuppression;
                }
            }
            /** 
             * Base fare per PQ type
                                                                          Ref: DM0Z_85_BFAR
                                                                          DM0Z_CA_BFAR
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Equivalent Fare per PQ type
                                                                          Ref: DM0Z_85_EFAR
                                                                          DM0Z_CA_EFAR
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EquivalentFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Tax Total per PQ type
                                                                          Ref: DM0Z_85_TTAC
                                                                          DM0Z_CA_TTAC
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalTax implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Total fare inclusive of taxes per PQ type
                                                                          Ref: DM0Z_85_TFAR
                                                                          DM0Z_CA_TFAR
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
             *         &lt;!-- Reference to inner class CombinedTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
             *         &lt;!-- Reference to inner class Tax -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TaxInfo implements Serializable
            {
                private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                private List<Tax> taxList = new ArrayList<Tax>();

                /** 
                 * Get the list of 'CombinedTax' element items.
                 * 
                 * @return list
                 */
                public List<CombinedTax> getCombinedTaxList() {
                    return combinedTaxList;
                }

                /** 
                 * Set the list of 'CombinedTax' element items.
                 * 
                 * @param list
                 */
                public void setCombinedTaxList(List<CombinedTax> list) {
                    combinedTaxList = list;
                }

                /** 
                 * Get the list of 'Tax' element items.
                 * 
                 * @return list
                 */
                public List<Tax> getTaxList() {
                    return taxList;
                }

                /** 
                 * Set the list of 'Tax' element items.
                 * 
                 * @param list
                 */
                public void setTaxList(List<Tax> list) {
                    taxList = list;
                }
                /** 
                 * Taxes combined and represented in tax boxes 1, 2, 3
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                 *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                 *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CombinedTax implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private String code;
                    private Boolean paid;
                    private Boolean exempt;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Get the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @return value
                     */
                    public Boolean getPaid() {
                        return paid;
                    }

                    /** 
                     * Set the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @param paid
                     */
                    public void setPaid(Boolean paid) {
                        this.paid = paid;
                    }

                    /** 
                     * Get the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @return value
                     */
                    public Boolean getExempt() {
                        return exempt;
                    }

                    /** 
                     * Set the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @param exempt
                     */
                    public void setExempt(Boolean exempt) {
                        this.exempt = exempt;
                    }
                }
                /** 
                 * Includes tax breakdown
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                 *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                 *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Tax implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private String code;
                    private Boolean paid;
                    private Boolean exempt;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Get the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @return value
                     */
                    public Boolean getPaid() {
                        return paid;
                    }

                    /** 
                     * Set the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @param paid
                     */
                    public void setPaid(Boolean paid) {
                        this.paid = paid;
                    }

                    /** 
                     * Get the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @return value
                     */
                    public Boolean getExempt() {
                        return exempt;
                    }

                    /** 
                     * Set the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @param exempt
                     */
                    public void setExempt(Boolean exempt) {
                        this.exempt = exempt;
                    }
                }
            }
            /** 
             * Commission at Farelevel
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount" minOccurs="0">
             *         &lt;!-- Reference to inner class Amount -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
             *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OtherCommission -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="source"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private Amount amount;
                private BigDecimal percentage;
                private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                private String source;
                private String type;

                /** 
                 * Get the 'Amount' element value.
                 * 
                 * @return value
                 */
                public Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value.
                 * 
                 * @param amount
                 */
                public void setAmount(Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Percentage' element value. Commision percentage
                 * 
                 * @return value
                 */
                public BigDecimal getPercentage() {
                    return percentage;
                }

                /** 
                 * Set the 'Percentage' element value. Commision percentage
                 * 
                 * @param percentage
                 */
                public void setPercentage(BigDecimal percentage) {
                    this.percentage = percentage;
                }

                /** 
                 * Get the list of 'OtherCommission' element items.
                 * 
                 * @return list
                 */
                public List<OtherCommission> getOtherCommissionList() {
                    return otherCommissionList;
                }

                /** 
                 * Set the list of 'OtherCommission' element items.
                 * 
                 * @param list
                 */
                public void setOtherCommissionList(List<OtherCommission> list) {
                    otherCommissionList = list;
                }

                /** 
                 * Get the 'source' attribute value. AGT - Agent-entered Commission
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'source' attribute value. AGT - Agent-entered Commission
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }

                /** 
                 * Get the 'type' attribute value. S - Special promo commission
                                                                                    N - Commission percent on NET
                                                                                    G - GRT commission
                                                                                    Ref:
                                                                                    DM0Z_85_COMI
                                                                                    DM0Z_86_COMI
                                                                                    #DM0Z_85_KPN
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. S - Special promo commission
                                                                                    N - Commission percent on NET
                                                                                    G - GRT commission
                                                                                    Ref:
                                                                                    DM0Z_85_COMI
                                                                                    DM0Z_86_COMI
                                                                                    #DM0Z_85_KPN
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Commision amount/penalty
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Amount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                 *         &lt;!-- Reference to inner class CommissionVerification -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="provider"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherCommission implements Serializable
                {
                    private Amount amount;
                    private CommissionVerification commissionVerification;
                    private String source;
                    private String provider;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CommissionVerification' element value.
                     * 
                     * @return value
                     */
                    public CommissionVerification getCommissionVerification() {
                        return commissionVerification;
                    }

                    /** 
                     * Set the 'CommissionVerification' element value.
                     * 
                     * @param commissionVerification
                     */
                    public void setCommissionVerification(
                            CommissionVerification commissionVerification) {
                        this.commissionVerification = commissionVerification;
                    }

                    /** 
                     * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'provider' attribute value.
                     * 
                     * @return value
                     */
                    public String getProvider() {
                        return provider;
                    }

                    /** 
                     * Set the 'provider' attribute value.
                     * 
                     * @param provider
                     */
                    public void setProvider(String provider) {
                        this.provider = provider;
                    }
                    /** 
                     * Commision amount based on type
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="type"/>
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String type;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                     *       &lt;xs:element name="Hierarchy" minOccurs="0">
                     *         &lt;!-- Reference to inner class Hierarchy -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="placement"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CommissionVerification implements
                        Serializable
                    {
                        private String controlQualifier;
                        private Hierarchy hierarchy;
                        private String verificationCode;
                        private String endorsement;
                        private String placement;

                        /** 
                         * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @return value
                         */
                        public String getControlQualifier() {
                            return controlQualifier;
                        }

                        /** 
                         * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @param controlQualifier
                         */
                        public void setControlQualifier(String controlQualifier) {
                            this.controlQualifier = controlQualifier;
                        }

                        /** 
                         * Get the 'Hierarchy' element value.
                         * 
                         * @return value
                         */
                        public Hierarchy getHierarchy() {
                            return hierarchy;
                        }

                        /** 
                         * Set the 'Hierarchy' element value.
                         * 
                         * @param hierarchy
                         */
                        public void setHierarchy(Hierarchy hierarchy) {
                            this.hierarchy = hierarchy;
                        }

                        /** 
                         * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @return value
                         */
                        public String getVerificationCode() {
                            return verificationCode;
                        }

                        /** 
                         * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @param verificationCode
                         */
                        public void setVerificationCode(String verificationCode) {
                            this.verificationCode = verificationCode;
                        }

                        /** 
                         * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @return value
                         */
                        public String getEndorsement() {
                            return endorsement;
                        }

                        /** 
                         * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @param endorsement
                         */
                        public void setEndorsement(String endorsement) {
                            this.endorsement = endorsement;
                        }

                        /** 
                         * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @return value
                         */
                        public String getPlacement() {
                            return placement;
                        }

                        /** 
                         * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @param placement
                         */
                        public void setPlacement(String placement) {
                            this.placement = placement;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Hierarchy implements Serializable
                        {
                            private BigInteger ticketDesignator;
                            private BigInteger tourNumber;
                            private BigInteger endorsement;

                            /** 
                             * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @return value
                             */
                            public BigInteger getTicketDesignator() {
                                return ticketDesignator;
                            }

                            /** 
                             * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @param ticketDesignator
                             */
                            public void setTicketDesignator(
                                    BigInteger ticketDesignator) {
                                this.ticketDesignator = ticketDesignator;
                            }

                            /** 
                             * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @return value
                             */
                            public BigInteger getTourNumber() {
                                return tourNumber;
                            }

                            /** 
                             * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @param tourNumber
                             */
                            public void setTourNumber(BigInteger tourNumber) {
                                this.tourNumber = tourNumber;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @return value
                             */
                            public BigInteger getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(BigInteger endorsement) {
                                this.endorsement = endorsement;
                            }
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="code"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HandlingFee implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private boolean description;
                private String code;
                private String type;
                private Boolean hidden;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Check if the 'Description' element is present.
                 * 
                 * @return <code>true</code> if present, <code>false</code> if not
                 */
                public boolean ifDescriptionPresent() {
                    return description;
                }

                /** 
                 * Set flag for 'Description' element present.
                 * 
                 * @param description
                 */
                public void flagDescriptionPresent(boolean description) {
                    this.description = description;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                    Possible Values:
                                                                                    A - Base Fare hidden fee
                                                                                    B - Base fare  unhidden fee

                                                                                    Ref: DM0Z_CF_ITYP
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                    Possible Values:
                                                                                    A - Base Fare hidden fee
                                                                                    B - Base fare  unhidden fee

                                                                                    Ref: DM0Z_CF_ITYP
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                    Possible Values:
                                                                                    BSE - Base Fare
                                                                                    PTK =Ticket Fare
                                                                                    TTL = Total Fare
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                    Possible Values:
                                                                                    BSE - Base Fare
                                                                                    PTK =Ticket Fare
                                                                                    TTL = Total Fare
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                 * 
                 * @return value
                 */
                public Boolean getHidden() {
                    return hidden;
                }

                /** 
                 * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                 * 
                 * @param hidden
                 */
                public void setHidden(Boolean hidden) {
                    this.hidden = hidden;
                }
            }
            /** 
             * Optional services bundled with the fare
                                                                          Ref: DM0Z_E7_...
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalServiceInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="quantity"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OptionalServiceInfo implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private String description;
                private String type;
                private BigInteger quantity;
                private String code;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Get the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E7_LCC_TXT
                 * 
                 * @return value
                 */
                public String getDescription() {
                    return description;
                }

                /** 
                 * Set the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E7_LCC_TXT
                 * 
                 * @param description
                 */
                public void setDescription(String description) {
                    this.description = description;
                }

                /** 
                 * Get the 'type' attribute value. Code representing the type of optional service

                                                                                    Ref: DM0Z_E7_LCC_TYP
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Code representing the type of optional service

                                                                                    Ref: DM0Z_E7_LCC_TYP
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'quantity' attribute value. total quantity of the optional service or charge

                                                                                    Ref: DM0Z_E7_LCC_ITM
                 * 
                 * @return value
                 */
                public BigInteger getQuantity() {
                    return quantity;
                }

                /** 
                 * Set the 'quantity' attribute value. total quantity of the optional service or charge

                                                                                    Ref: DM0Z_E7_LCC_ITM
                 * 
                 * @param quantity
                 */
                public void setQuantity(BigInteger quantity) {
                    this.quantity = quantity;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to optional service or charge.

                                                                                    For example:
                                                                                    BGAD
                                                                                    PRBD
                                                                                    SEAT
                                                                                    MEAL
                                                                                    JUMP...

                                                                                    Ref: DM0Z_E7_LCC_CHG
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to optional service or charge.

                                                                                    For example:
                                                                                    BGAD
                                                                                    PRBD
                                                                                    SEAT
                                                                                    MEAL
                                                                                    JUMP...

                                                                                    Ref: DM0Z_E7_LCC_CHG
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalFareInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OriginalSellingFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginalSellingFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PublishedFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class PublishedFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RetailerFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class RetailerFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class NetFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetRemitInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class NetRemitInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AdditionalFareInfo implements Serializable
        {
            private OriginalSellingFareInfo originalSellingFareInfo;
            private PublishedFareInfo publishedFareInfo;
            private RetailerFareInfo retailerFareInfo;
            private NetFareInfo netFareInfo;
            private NetRemitInfo netRemitInfo;

            /** 
             * Get the 'OriginalSellingFareInfo' element value.
             * 
             * @return value
             */
            public OriginalSellingFareInfo getOriginalSellingFareInfo() {
                return originalSellingFareInfo;
            }

            /** 
             * Set the 'OriginalSellingFareInfo' element value.
             * 
             * @param originalSellingFareInfo
             */
            public void setOriginalSellingFareInfo(
                    OriginalSellingFareInfo originalSellingFareInfo) {
                this.originalSellingFareInfo = originalSellingFareInfo;
            }

            /** 
             * Get the 'PublishedFareInfo' element value.
             * 
             * @return value
             */
            public PublishedFareInfo getPublishedFareInfo() {
                return publishedFareInfo;
            }

            /** 
             * Set the 'PublishedFareInfo' element value.
             * 
             * @param publishedFareInfo
             */
            public void setPublishedFareInfo(PublishedFareInfo publishedFareInfo) {
                this.publishedFareInfo = publishedFareInfo;
            }

            /** 
             * Get the 'RetailerFareInfo' element value.
             * 
             * @return value
             */
            public RetailerFareInfo getRetailerFareInfo() {
                return retailerFareInfo;
            }

            /** 
             * Set the 'RetailerFareInfo' element value.
             * 
             * @param retailerFareInfo
             */
            public void setRetailerFareInfo(RetailerFareInfo retailerFareInfo) {
                this.retailerFareInfo = retailerFareInfo;
            }

            /** 
             * Get the 'NetFareInfo' element value.
             * 
             * @return value
             */
            public NetFareInfo getNetFareInfo() {
                return netFareInfo;
            }

            /** 
             * Set the 'NetFareInfo' element value.
             * 
             * @param netFareInfo
             */
            public void setNetFareInfo(NetFareInfo netFareInfo) {
                this.netFareInfo = netFareInfo;
            }

            /** 
             * Get the 'NetRemitInfo' element value.
             * 
             * @return value
             */
            public NetRemitInfo getNetRemitInfo() {
                return netRemitInfo;
            }

            /** 
             * Set the 'NetRemitInfo' element value.
             * 
             * @param netRemitInfo
             */
            public void setNetRemitInfo(NetRemitInfo netRemitInfo) {
                this.netRemitInfo = netRemitInfo;
            }
            /** 
             * Original selling fare is returned when the user is authorized to view it
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalSellingFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TaxInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="FareCalculation" minOccurs="0"/>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AdjustedAmount" minOccurs="0">
             *         &lt;!-- Reference to inner class AdjustedAmount -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HandlingFee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginalSellingFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private TaxInfo taxInfo;
                private String fareCalculation;
                private Commission commission;
                private AdjustedAmount adjustedAmount;
                private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public TaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(TaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @return value
                 */
                public String getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(String fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'AdjustedAmount' element value.
                 * 
                 * @return value
                 */
                public AdjustedAmount getAdjustedAmount() {
                    return adjustedAmount;
                }

                /** 
                 * Set the 'AdjustedAmount' element value.
                 * 
                 * @param adjustedAmount
                 */
                public void setAdjustedAmount(AdjustedAmount adjustedAmount) {
                    this.adjustedAmount = adjustedAmount;
                }

                /** 
                 * Get the list of 'HandlingFee' element items.
                 * 
                 * @return list
                 */
                public List<HandlingFee> getHandlingFeeList() {
                    return handlingFeeList;
                }

                /** 
                 * Set the list of 'HandlingFee' element items.
                 * 
                 * @param list
                 */
                public void setHandlingFeeList(List<HandlingFee> list) {
                    handlingFeeList = list;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *         &lt;!-- Reference to inner class CombinedTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxInfo implements Serializable
                {
                    private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'CombinedTax' element items.
                     * 
                     * @return list
                     */
                    public List<CombinedTax> getCombinedTaxList() {
                        return combinedTaxList;
                    }

                    /** 
                     * Set the list of 'CombinedTax' element items.
                     * 
                     * @param list
                     */
                    public void setCombinedTaxList(List<CombinedTax> list) {
                        combinedTaxList = list;
                    }

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Taxes combined and represented in tax boxes 1, 2, 3
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CombinedTax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                    /** 
                     * Includes tax breakdown
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                }
                /** 
                 * Holds commission associated to Orginal fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherCommission -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                    private String source;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the list of 'OtherCommission' element items.
                     * 
                     * @return list
                     */
                    public List<OtherCommission> getOtherCommissionList() {
                        return otherCommissionList;
                    }

                    /** 
                     * Set the list of 'OtherCommission' element items.
                     * 
                     * @param list
                     */
                    public void setOtherCommissionList(
                            List<OtherCommission> list) {
                        otherCommissionList = list;
                    }

                    /** 
                     * Get the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount" minOccurs="0">
                     *         &lt;!-- Reference to inner class Amount -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                     *         &lt;!-- Reference to inner class CommissionVerification -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="source"/>
                     *     &lt;xs:attribute type="xs:string" name="provider"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherCommission implements Serializable
                    {
                        private Amount amount;
                        private CommissionVerification commissionVerification;
                        private String source;
                        private String provider;

                        /** 
                         * Get the 'Amount' element value.
                         * 
                         * @return value
                         */
                        public Amount getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' element value.
                         * 
                         * @param amount
                         */
                        public void setAmount(Amount amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CommissionVerification' element value.
                         * 
                         * @return value
                         */
                        public CommissionVerification getCommissionVerification() {
                            return commissionVerification;
                        }

                        /** 
                         * Set the 'CommissionVerification' element value.
                         * 
                         * @param commissionVerification
                         */
                        public void setCommissionVerification(
                                CommissionVerification commissionVerification) {
                            this.commissionVerification = commissionVerification;
                        }

                        /** 
                         * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @return value
                         */
                        public String getSource() {
                            return source;
                        }

                        /** 
                         * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @param source
                         */
                        public void setSource(String source) {
                            this.source = source;
                        }

                        /** 
                         * Get the 'provider' attribute value.
                         * 
                         * @return value
                         */
                        public String getProvider() {
                            return provider;
                        }

                        /** 
                         * Set the 'provider' attribute value.
                         * 
                         * @param provider
                         */
                        public void setProvider(String provider) {
                            this.provider = provider;
                        }
                        /** 
                         * Commision amount based on type
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:decimal">
                         *         &lt;xs:attribute type="xs:string" name="type"/>
                         *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                         *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Amount implements Serializable
                        {
                            private BigDecimal decimal;
                            private String type;
                            private String currencyCode;
                            private BigInteger decimalPlace;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public BigDecimal getDecimal() {
                                return decimal;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param decimal
                             */
                            public void setDecimal(BigDecimal decimal) {
                                this.decimal = decimal;
                            }

                            /** 
                             * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'currencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'currencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'decimalPlace' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getDecimalPlace() {
                                return decimalPlace;
                            }

                            /** 
                             * Set the 'decimalPlace' attribute value.
                             * 
                             * @param decimalPlace
                             */
                            public void setDecimalPlace(BigInteger decimalPlace) {
                                this.decimalPlace = decimalPlace;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                         *       &lt;xs:element name="Hierarchy" minOccurs="0">
                         *         &lt;!-- Reference to inner class Hierarchy -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="placement"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CommissionVerification implements
                            Serializable
                        {
                            private String controlQualifier;
                            private Hierarchy hierarchy;
                            private String verificationCode;
                            private String endorsement;
                            private String placement;

                            /** 
                             * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @return value
                             */
                            public String getControlQualifier() {
                                return controlQualifier;
                            }

                            /** 
                             * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @param controlQualifier
                             */
                            public void setControlQualifier(
                                    String controlQualifier) {
                                this.controlQualifier = controlQualifier;
                            }

                            /** 
                             * Get the 'Hierarchy' element value.
                             * 
                             * @return value
                             */
                            public Hierarchy getHierarchy() {
                                return hierarchy;
                            }

                            /** 
                             * Set the 'Hierarchy' element value.
                             * 
                             * @param hierarchy
                             */
                            public void setHierarchy(Hierarchy hierarchy) {
                                this.hierarchy = hierarchy;
                            }

                            /** 
                             * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @return value
                             */
                            public String getVerificationCode() {
                                return verificationCode;
                            }

                            /** 
                             * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @param verificationCode
                             */
                            public void setVerificationCode(
                                    String verificationCode) {
                                this.verificationCode = verificationCode;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @return value
                             */
                            public String getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(String endorsement) {
                                this.endorsement = endorsement;
                            }

                            /** 
                             * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @return value
                             */
                            public String getPlacement() {
                                return placement;
                            }

                            /** 
                             * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @param placement
                             */
                            public void setPlacement(String placement) {
                                this.placement = placement;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Hierarchy implements
                                Serializable
                            {
                                private BigInteger ticketDesignator;
                                private BigInteger tourNumber;
                                private BigInteger endorsement;

                                /** 
                                 * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTicketDesignator() {
                                    return ticketDesignator;
                                }

                                /** 
                                 * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @param ticketDesignator
                                 */
                                public void setTicketDesignator(
                                        BigInteger ticketDesignator) {
                                    this.ticketDesignator = ticketDesignator;
                                }

                                /** 
                                 * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTourNumber() {
                                    return tourNumber;
                                }

                                /** 
                                 * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @param tourNumber
                                 */
                                public void setTourNumber(BigInteger tourNumber) {
                                    this.tourNumber = tourNumber;
                                }

                                /** 
                                 * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getEndorsement() {
                                    return endorsement;
                                }

                                /** 
                                 * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @param endorsement
                                 */
                                public void setEndorsement(
                                        BigInteger endorsement) {
                                    this.endorsement = endorsement;
                                }
                            }
                        }
                    }
                }
                /** 
                 * The amount by which the original selling fare was adjusted
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdjustedAmount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AdjustedAmount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="code"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HandlingFee implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private boolean description;
                    private String code;
                    private String type;
                    private Boolean hidden;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Check if the 'Description' element is present.
                     * 
                     * @return <code>true</code> if present, <code>false</code> if not
                     */
                    public boolean ifDescriptionPresent() {
                        return description;
                    }

                    /** 
                     * Set flag for 'Description' element present.
                     * 
                     * @param description
                     */
                    public void flagDescriptionPresent(boolean description) {
                        this.description = description;
                    }

                    /** 
                     * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @return value
                     */
                    public Boolean getHidden() {
                        return hidden;
                    }

                    /** 
                     * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @param hidden
                     */
                    public void setHidden(Boolean hidden) {
                        this.hidden = hidden;
                    }
                }
            }
            /** 
             * Equivalent to *PQP

                                                                          Ref: DM0Z_85_PUB 'x 01
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PublishedFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TaxInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="FareCalculation" minOccurs="0"/>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PublishedFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private TaxInfo taxInfo;
                private String fareCalculation;
                private Commission commission;

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public TaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(TaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @return value
                 */
                public String getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(String fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Includes combinedTax and Tax breakdown.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *         &lt;!-- Reference to inner class CombinedTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxInfo implements Serializable
                {
                    private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'CombinedTax' element items.
                     * 
                     * @return list
                     */
                    public List<CombinedTax> getCombinedTaxList() {
                        return combinedTaxList;
                    }

                    /** 
                     * Set the list of 'CombinedTax' element items.
                     * 
                     * @param list
                     */
                    public void setCombinedTaxList(List<CombinedTax> list) {
                        combinedTaxList = list;
                    }

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Taxes combined and represented in tax boxes 1, 2, 3
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CombinedTax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                    /** 
                     * Includes tax breakdown
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                }
                /** 
                 * Holds commission associated to published fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherCommission -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                    private String source;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the list of 'OtherCommission' element items.
                     * 
                     * @return list
                     */
                    public List<OtherCommission> getOtherCommissionList() {
                        return otherCommissionList;
                    }

                    /** 
                     * Set the list of 'OtherCommission' element items.
                     * 
                     * @param list
                     */
                    public void setOtherCommissionList(
                            List<OtherCommission> list) {
                        otherCommissionList = list;
                    }

                    /** 
                     * Get the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount" minOccurs="0">
                     *         &lt;!-- Reference to inner class Amount -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                     *         &lt;!-- Reference to inner class CommissionVerification -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="source"/>
                     *     &lt;xs:attribute type="xs:string" name="provider"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherCommission implements Serializable
                    {
                        private Amount amount;
                        private CommissionVerification commissionVerification;
                        private String source;
                        private String provider;

                        /** 
                         * Get the 'Amount' element value.
                         * 
                         * @return value
                         */
                        public Amount getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' element value.
                         * 
                         * @param amount
                         */
                        public void setAmount(Amount amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CommissionVerification' element value.
                         * 
                         * @return value
                         */
                        public CommissionVerification getCommissionVerification() {
                            return commissionVerification;
                        }

                        /** 
                         * Set the 'CommissionVerification' element value.
                         * 
                         * @param commissionVerification
                         */
                        public void setCommissionVerification(
                                CommissionVerification commissionVerification) {
                            this.commissionVerification = commissionVerification;
                        }

                        /** 
                         * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @return value
                         */
                        public String getSource() {
                            return source;
                        }

                        /** 
                         * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @param source
                         */
                        public void setSource(String source) {
                            this.source = source;
                        }

                        /** 
                         * Get the 'provider' attribute value.
                         * 
                         * @return value
                         */
                        public String getProvider() {
                            return provider;
                        }

                        /** 
                         * Set the 'provider' attribute value.
                         * 
                         * @param provider
                         */
                        public void setProvider(String provider) {
                            this.provider = provider;
                        }
                        /** 
                         * Commision amount based on type
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:decimal">
                         *         &lt;xs:attribute type="xs:string" name="type"/>
                         *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                         *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Amount implements Serializable
                        {
                            private BigDecimal decimal;
                            private String type;
                            private String currencyCode;
                            private BigInteger decimalPlace;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public BigDecimal getDecimal() {
                                return decimal;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param decimal
                             */
                            public void setDecimal(BigDecimal decimal) {
                                this.decimal = decimal;
                            }

                            /** 
                             * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'currencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'currencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'decimalPlace' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getDecimalPlace() {
                                return decimalPlace;
                            }

                            /** 
                             * Set the 'decimalPlace' attribute value.
                             * 
                             * @param decimalPlace
                             */
                            public void setDecimalPlace(BigInteger decimalPlace) {
                                this.decimalPlace = decimalPlace;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                         *       &lt;xs:element name="Hierarchy" minOccurs="0">
                         *         &lt;!-- Reference to inner class Hierarchy -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="placement"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CommissionVerification implements
                            Serializable
                        {
                            private String controlQualifier;
                            private Hierarchy hierarchy;
                            private String verificationCode;
                            private String endorsement;
                            private String placement;

                            /** 
                             * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @return value
                             */
                            public String getControlQualifier() {
                                return controlQualifier;
                            }

                            /** 
                             * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @param controlQualifier
                             */
                            public void setControlQualifier(
                                    String controlQualifier) {
                                this.controlQualifier = controlQualifier;
                            }

                            /** 
                             * Get the 'Hierarchy' element value.
                             * 
                             * @return value
                             */
                            public Hierarchy getHierarchy() {
                                return hierarchy;
                            }

                            /** 
                             * Set the 'Hierarchy' element value.
                             * 
                             * @param hierarchy
                             */
                            public void setHierarchy(Hierarchy hierarchy) {
                                this.hierarchy = hierarchy;
                            }

                            /** 
                             * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @return value
                             */
                            public String getVerificationCode() {
                                return verificationCode;
                            }

                            /** 
                             * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @param verificationCode
                             */
                            public void setVerificationCode(
                                    String verificationCode) {
                                this.verificationCode = verificationCode;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @return value
                             */
                            public String getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(String endorsement) {
                                this.endorsement = endorsement;
                            }

                            /** 
                             * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @return value
                             */
                            public String getPlacement() {
                                return placement;
                            }

                            /** 
                             * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @param placement
                             */
                            public void setPlacement(String placement) {
                                this.placement = placement;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Hierarchy implements
                                Serializable
                            {
                                private BigInteger ticketDesignator;
                                private BigInteger tourNumber;
                                private BigInteger endorsement;

                                /** 
                                 * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTicketDesignator() {
                                    return ticketDesignator;
                                }

                                /** 
                                 * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @param ticketDesignator
                                 */
                                public void setTicketDesignator(
                                        BigInteger ticketDesignator) {
                                    this.ticketDesignator = ticketDesignator;
                                }

                                /** 
                                 * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTourNumber() {
                                    return tourNumber;
                                }

                                /** 
                                 * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @param tourNumber
                                 */
                                public void setTourNumber(BigInteger tourNumber) {
                                    this.tourNumber = tourNumber;
                                }

                                /** 
                                 * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getEndorsement() {
                                    return endorsement;
                                }

                                /** 
                                 * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @param endorsement
                                 */
                                public void setEndorsement(
                                        BigInteger endorsement) {
                                    this.endorsement = endorsement;
                                }
                            }
                        }
                    }
                }
            }
            /** 
             * Maps to *PQ#R
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TaxInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HandlingFee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RetailerFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private Commission commission;
                private TaxInfo taxInfo;
                private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public TaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(TaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the list of 'HandlingFee' element items.
                 * 
                 * @return list
                 */
                public List<HandlingFee> getHandlingFeeList() {
                    return handlingFeeList;
                }

                /** 
                 * Set the list of 'HandlingFee' element items.
                 * 
                 * @param list
                 */
                public void setHandlingFeeList(List<HandlingFee> list) {
                    handlingFeeList = list;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                                                                                        DM0Z_CA_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                                                                                        DM0Z_CA_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                                                                                        DM0Z_CA_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                                                                                        DM0Z_CA_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                 *         &lt;!-- Reference to inner class CommissionVerification -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="provider"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private CommissionVerification commissionVerification;
                    private String source;
                    private String provider;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CommissionVerification' element value.
                     * 
                     * @return value
                     */
                    public CommissionVerification getCommissionVerification() {
                        return commissionVerification;
                    }

                    /** 
                     * Set the 'CommissionVerification' element value.
                     * 
                     * @param commissionVerification
                     */
                    public void setCommissionVerification(
                            CommissionVerification commissionVerification) {
                        this.commissionVerification = commissionVerification;
                    }

                    /** 
                     * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'provider' attribute value.
                     * 
                     * @return value
                     */
                    public String getProvider() {
                        return provider;
                    }

                    /** 
                     * Set the 'provider' attribute value.
                     * 
                     * @param provider
                     */
                    public void setProvider(String provider) {
                        this.provider = provider;
                    }
                    /** 
                     * Commision amount based on type
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="type"/>
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String type;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                     *       &lt;xs:element name="Hierarchy" minOccurs="0">
                     *         &lt;!-- Reference to inner class Hierarchy -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="placement"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CommissionVerification implements
                        Serializable
                    {
                        private String controlQualifier;
                        private Hierarchy hierarchy;
                        private String verificationCode;
                        private String endorsement;
                        private String placement;

                        /** 
                         * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @return value
                         */
                        public String getControlQualifier() {
                            return controlQualifier;
                        }

                        /** 
                         * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @param controlQualifier
                         */
                        public void setControlQualifier(String controlQualifier) {
                            this.controlQualifier = controlQualifier;
                        }

                        /** 
                         * Get the 'Hierarchy' element value.
                         * 
                         * @return value
                         */
                        public Hierarchy getHierarchy() {
                            return hierarchy;
                        }

                        /** 
                         * Set the 'Hierarchy' element value.
                         * 
                         * @param hierarchy
                         */
                        public void setHierarchy(Hierarchy hierarchy) {
                            this.hierarchy = hierarchy;
                        }

                        /** 
                         * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @return value
                         */
                        public String getVerificationCode() {
                            return verificationCode;
                        }

                        /** 
                         * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @param verificationCode
                         */
                        public void setVerificationCode(String verificationCode) {
                            this.verificationCode = verificationCode;
                        }

                        /** 
                         * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @return value
                         */
                        public String getEndorsement() {
                            return endorsement;
                        }

                        /** 
                         * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @param endorsement
                         */
                        public void setEndorsement(String endorsement) {
                            this.endorsement = endorsement;
                        }

                        /** 
                         * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @return value
                         */
                        public String getPlacement() {
                            return placement;
                        }

                        /** 
                         * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @param placement
                         */
                        public void setPlacement(String placement) {
                            this.placement = placement;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Hierarchy implements Serializable
                        {
                            private BigInteger ticketDesignator;
                            private BigInteger tourNumber;
                            private BigInteger endorsement;

                            /** 
                             * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @return value
                             */
                            public BigInteger getTicketDesignator() {
                                return ticketDesignator;
                            }

                            /** 
                             * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @param ticketDesignator
                             */
                            public void setTicketDesignator(
                                    BigInteger ticketDesignator) {
                                this.ticketDesignator = ticketDesignator;
                            }

                            /** 
                             * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @return value
                             */
                            public BigInteger getTourNumber() {
                                return tourNumber;
                            }

                            /** 
                             * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @param tourNumber
                             */
                            public void setTourNumber(BigInteger tourNumber) {
                                this.tourNumber = tourNumber;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @return value
                             */
                            public BigInteger getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(BigInteger endorsement) {
                                this.endorsement = endorsement;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *         &lt;!-- Reference to inner class CombinedTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxInfo implements Serializable
                {
                    private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'CombinedTax' element items.
                     * 
                     * @return list
                     */
                    public List<CombinedTax> getCombinedTaxList() {
                        return combinedTaxList;
                    }

                    /** 
                     * Set the list of 'CombinedTax' element items.
                     * 
                     * @param list
                     */
                    public void setCombinedTaxList(List<CombinedTax> list) {
                        combinedTaxList = list;
                    }

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Taxes combined and represented in tax boxes 1, 2, 3
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CombinedTax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                    /** 
                     * Includes tax breakdown
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="code"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HandlingFee implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private boolean description;
                    private String code;
                    private String type;
                    private Boolean hidden;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Check if the 'Description' element is present.
                     * 
                     * @return <code>true</code> if present, <code>false</code> if not
                     */
                    public boolean ifDescriptionPresent() {
                        return description;
                    }

                    /** 
                     * Set flag for 'Description' element present.
                     * 
                     * @param description
                     */
                    public void flagDescriptionPresent(boolean description) {
                        this.description = description;
                    }

                    /** 
                     * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @return value
                     */
                    public Boolean getHidden() {
                        return hidden;
                    }

                    /** 
                     * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @param hidden
                     */
                    public void setHidden(Boolean hidden) {
                        this.hidden = hidden;
                    }
                }
            }
            /** 
             * Net fare data
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TaxInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="FareCalculation" minOccurs="0"/>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MarkUp" minOccurs="0">
             *         &lt;!-- Reference to inner class MarkUp -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="tourTicket"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private TaxInfo taxInfo;
                private String fareCalculation;
                private Commission commission;
                private MarkUp markUp;
                private Boolean tourTicket;

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public TaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(TaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value. Fare calculation information related to NetFare Ref: DM0Z_A6_DATA
                 * 
                 * @return value
                 */
                public String getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value. Fare calculation information related to NetFare Ref: DM0Z_A6_DATA
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(String fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'MarkUp' element value.
                 * 
                 * @return value
                 */
                public MarkUp getMarkUp() {
                    return markUp;
                }

                /** 
                 * Set the 'MarkUp' element value.
                 * 
                 * @param markUp
                 */
                public void setMarkUp(MarkUp markUp) {
                    this.markUp = markUp;
                }

                /** 
                 * Get the 'tourTicket' attribute value. Set to true if net fare is for IT/BT

                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_ITBT
                 * 
                 * @return value
                 */
                public Boolean getTourTicket() {
                    return tourTicket;
                }

                /** 
                 * Set the 'tourTicket' attribute value. Set to true if net fare is for IT/BT

                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_ITBT
                 * 
                 * @param tourTicket
                 */
                public void setTourTicket(Boolean tourTicket) {
                    this.tourTicket = tourTicket;
                }
                /** 
                 * Base amount for NetFare. Ref: DM0Z_86_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent amount for NetFare.
                                                                                        Ref: DM0Z_86_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total tax amount for NetFare.
                                                                                        Ref: DM0Z_86_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total amount for NetFare. Ref: DM0Z_86_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * This contains taxes that exist in the tax boxes 1, 2, 3 for NetFare.
                                                                                        Ref: DM0Z_86_TAXn

                                                                                        Tax Breakdown
                                                                                        Ref: DM0Z_91_ITEM
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *         &lt;!-- Reference to inner class CombinedTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxInfo implements Serializable
                {
                    private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'CombinedTax' element items.
                     * 
                     * @return list
                     */
                    public List<CombinedTax> getCombinedTaxList() {
                        return combinedTaxList;
                    }

                    /** 
                     * Set the list of 'CombinedTax' element items.
                     * 
                     * @param list
                     */
                    public void setCombinedTaxList(List<CombinedTax> list) {
                        combinedTaxList = list;
                    }

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Taxes combined and represented in tax boxes 1, 2, 3
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CombinedTax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                    /** 
                     * Includes tax breakdown
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                }
                /** 
                 * Holds commission associated to NetFare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                }
                /** 
                 * Difference between selling fare and net fare

                                                                                        Ref: DM0Z_C9_MKU_AMNT
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarkUp" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MarkUp implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
            }
            /** 
             * Global Net remit
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemitInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NetFare" minOccurs="0">
             *         &lt;!-- Reference to inner class NetFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SellingFare" minOccurs="0">
             *         &lt;!-- Reference to inner class SellingFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Discount" minOccurs="0">
             *         &lt;!-- Reference to inner class Discount -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="method"/>
             *     &lt;xs:attribute type="xs:string" name="valueCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetRemitInfo implements Serializable
            {
                private NetFare netFare;
                private SellingFare sellingFare;
                private Discount discount;
                private String method;
                private String valueCode;

                /** 
                 * Get the 'NetFare' element value.
                 * 
                 * @return value
                 */
                public NetFare getNetFare() {
                    return netFare;
                }

                /** 
                 * Set the 'NetFare' element value.
                 * 
                 * @param netFare
                 */
                public void setNetFare(NetFare netFare) {
                    this.netFare = netFare;
                }

                /** 
                 * Get the 'SellingFare' element value.
                 * 
                 * @return value
                 */
                public SellingFare getSellingFare() {
                    return sellingFare;
                }

                /** 
                 * Set the 'SellingFare' element value.
                 * 
                 * @param sellingFare
                 */
                public void setSellingFare(SellingFare sellingFare) {
                    this.sellingFare = sellingFare;
                }

                /** 
                 * Get the 'Discount' element value.
                 * 
                 * @return value
                 */
                public Discount getDiscount() {
                    return discount;
                }

                /** 
                 * Set the 'Discount' element value.
                 * 
                 * @param discount
                 */
                public void setDiscount(Discount discount) {
                    this.discount = discount;
                }

                /** 
                 * Get the 'method' attribute value. CAT35 Method Type
                                                                                    Ref: DM0Z_E8_RMT_TYPE
                 * 
                 * @return value
                 */
                public String getMethod() {
                    return method;
                }

                /** 
                 * Set the 'method' attribute value. CAT35 Method Type
                                                                                    Ref: DM0Z_E8_RMT_TYPE
                 * 
                 * @param method
                 */
                public void setMethod(String method) {
                    this.method = method;
                }

                /** 
                 * Get the 'valueCode' attribute value. CAT35 Net Remit Value Code
                                                                                    Ref: DM0Z_E8_REMT_CDE
                 * 
                 * @return value
                 */
                public String getValueCode() {
                    return valueCode;
                }

                /** 
                 * Set the 'valueCode' attribute value. CAT35 Net Remit Value Code
                                                                                    Ref: DM0Z_E8_REMT_CDE
                 * 
                 * @param valueCode
                 */
                public void setValueCode(String valueCode) {
                    this.valueCode = valueCode;
                }
                /** 
                 * Net fare details
                                                                                        Ref: DM0Z_E8_NET...
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivalentFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivalentFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalTax" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalFare -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NetFare implements Serializable
                {
                    private BaseFare baseFare;
                    private EquivalentFare equivalentFare;
                    private TotalTax totalTax;
                    private TotalFare totalFare;

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'EquivalentFare' element value.
                     * 
                     * @return value
                     */
                    public EquivalentFare getEquivalentFare() {
                        return equivalentFare;
                    }

                    /** 
                     * Set the 'EquivalentFare' element value.
                     * 
                     * @param equivalentFare
                     */
                    public void setEquivalentFare(EquivalentFare equivalentFare) {
                        this.equivalentFare = equivalentFare;
                    }

                    /** 
                     * Get the 'TotalTax' element value.
                     * 
                     * @return value
                     */
                    public TotalTax getTotalTax() {
                        return totalTax;
                    }

                    /** 
                     * Set the 'TotalTax' element value.
                     * 
                     * @param totalTax
                     */
                    public void setTotalTax(TotalTax totalTax) {
                        this.totalTax = totalTax;
                    }

                    /** 
                     * Get the 'TotalFare' element value.
                     * 
                     * @return value
                     */
                    public TotalFare getTotalFare() {
                        return totalFare;
                    }

                    /** 
                     * Set the 'TotalFare' element value.
                     * 
                     * @param totalFare
                     */
                    public void setTotalFare(TotalFare totalFare) {
                        this.totalFare = totalFare;
                    }
                    /** 
                     * Base fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Equivalent fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivalentFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total tax amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalTax implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                }
                /** 
                 * Selling fare details
                                                                                        Ref: DM0Z_E8_SEL_...
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivalentFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivalentFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalTax" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalFare -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SellingFare implements Serializable
                {
                    private BaseFare baseFare;
                    private EquivalentFare equivalentFare;
                    private TotalTax totalTax;
                    private TotalFare totalFare;

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'EquivalentFare' element value.
                     * 
                     * @return value
                     */
                    public EquivalentFare getEquivalentFare() {
                        return equivalentFare;
                    }

                    /** 
                     * Set the 'EquivalentFare' element value.
                     * 
                     * @param equivalentFare
                     */
                    public void setEquivalentFare(EquivalentFare equivalentFare) {
                        this.equivalentFare = equivalentFare;
                    }

                    /** 
                     * Get the 'TotalTax' element value.
                     * 
                     * @return value
                     */
                    public TotalTax getTotalTax() {
                        return totalTax;
                    }

                    /** 
                     * Set the 'TotalTax' element value.
                     * 
                     * @param totalTax
                     */
                    public void setTotalTax(TotalTax totalTax) {
                        this.totalTax = totalTax;
                    }

                    /** 
                     * Get the 'TotalFare' element value.
                     * 
                     * @return value
                     */
                    public TotalFare getTotalFare() {
                        return totalFare;
                    }

                    /** 
                     * Set the 'TotalFare' element value.
                     * 
                     * @param totalFare
                     */
                    public void setTotalFare(TotalFare totalFare) {
                        this.totalFare = totalFare;
                    }
                    /** 
                     * Base fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Equivalent fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivalentFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total tax amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalTax implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Total fare amount
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalFare implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                }
                /** 
                 * Discount Amount if applicable
                                                                                        Ref: DM0Z_E8_DISCOUNT
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Discount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
            }
        }
        /** 
         * Fee details defined in Price Quote
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Amount">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:decimal">
         *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
         *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Total" minOccurs="0">
         *         &lt;!-- Reference to inner class Total -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="BankIdentificationNumber" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
         *     &lt;xs:attribute type="xs:string" name="noChargeIndicator"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FeeInfo implements Serializable
        {
            private BigDecimal amountDecimal;
            private String amountCurrencyCode;
            private BigInteger amountDecimalPlace;
            private Total total;
            private String description;
            private String bankIdentificationNumber;
            private String type;
            private String code;
            private String noChargeIndicator;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public BigDecimal getAmountDecimal() {
                return amountDecimal;
            }

            /** 
             * Set the extension value.
             * 
             * @param amountDecimal
             */
            public void setAmountDecimal(BigDecimal amountDecimal) {
                this.amountDecimal = amountDecimal;
            }

            /** 
             * Get the 'currencyCode' attribute value.
             * 
             * @return value
             */
            public String getAmountCurrencyCode() {
                return amountCurrencyCode;
            }

            /** 
             * Set the 'currencyCode' attribute value.
             * 
             * @param amountCurrencyCode
             */
            public void setAmountCurrencyCode(String amountCurrencyCode) {
                this.amountCurrencyCode = amountCurrencyCode;
            }

            /** 
             * Get the 'decimalPlace' attribute value.
             * 
             * @return value
             */
            public BigInteger getAmountDecimalPlace() {
                return amountDecimalPlace;
            }

            /** 
             * Set the 'decimalPlace' attribute value.
             * 
             * @param amountDecimalPlace
             */
            public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                this.amountDecimalPlace = amountDecimalPlace;
            }

            /** 
             * Get the 'Total' element value.
             * 
             * @return value
             */
            public Total getTotal() {
                return total;
            }

            /** 
             * Set the 'Total' element value.
             * 
             * @param total
             */
            public void setTotal(Total total) {
                this.total = total;
            }

            /** 
             * Get the 'Description' element value. Description of a fee item

                                                                          Ref: DM0Z_E1_OB_DESP
             * 
             * @return value
             */
            public String getDescription() {
                return description;
            }

            /** 
             * Set the 'Description' element value. Description of a fee item

                                                                          Ref: DM0Z_E1_OB_DESP
             * 
             * @param description
             */
            public void setDescription(String description) {
                this.description = description;
            }

            /** 
             * Get the 'BankIdentificationNumber' element value. Ref: DM0Z_E1_OB_BIN
             * 
             * @return value
             */
            public String getBankIdentificationNumber() {
                return bankIdentificationNumber;
            }

            /** 
             * Set the 'BankIdentificationNumber' element value. Ref: DM0Z_E1_OB_BIN
             * 
             * @param bankIdentificationNumber
             */
            public void setBankIdentificationNumber(
                    String bankIdentificationNumber) {
                this.bankIdentificationNumber = bankIdentificationNumber;
            }

            /** 
             * Get the 'type' attribute value. Group or type which the fee belongs to.

                                                                      Possible Values:
                                                                      OB
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Group or type which the fee belongs to.

                                                                      Possible Values:
                                                                      OB
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'code' attribute value. Code associated to the fee.

                                                                      Possible values:
                                                                      R01
                                                                      R02-R12
                                                                      T01
                                                                      T02-T20
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'code' attribute value. Code associated to the fee.

                                                                      Possible values:
                                                                      R01
                                                                      R02-R12
                                                                      T01
                                                                      T02-T20
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'noChargeIndicator' attribute value. Possible Values:
                                                                      X
                                                                      Y
                                                                      0
                                                                      Ref: DM0Z_E1_OB_NCHR
             * 
             * @return value
             */
            public String getNoChargeIndicator() {
                return noChargeIndicator;
            }

            /** 
             * Set the 'noChargeIndicator' attribute value. Possible Values:
                                                                      X
                                                                      Y
                                                                      0
                                                                      Ref: DM0Z_E1_OB_NCHR
             * 
             * @param noChargeIndicator
             */
            public void setNoChargeIndicator(String noChargeIndicator) {
                this.noChargeIndicator = noChargeIndicator;
            }
            /** 
             * Total Fee Amount
                                                                          Ref:
                                                                          DM0ZAA_E1_TAMT
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Total implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
        }
        /** 
         * Miscellaneous details pertaining to this PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscellaneousInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="AlternateValidatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element name="TourNumber" minOccurs="0">
         *         &lt;!-- Reference to inner class TourNumber -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiscellaneousInfo implements Serializable
        {
            private List<String> validatingCarrierList = new ArrayList<String>();
            private List<String> alternateValidatingCarrierList = new ArrayList<String>();
            private TourNumber tourNumber;
            private String itineraryType;

            /** 
             * Get the list of 'ValidatingCarrier' element items. Validating Carrier.
                                                                          Ref: DM0Z_65_CRXC
             * 
             * @return list
             */
            public List<String> getValidatingCarrierList() {
                return validatingCarrierList;
            }

            /** 
             * Set the list of 'ValidatingCarrier' element items. Validating Carrier.
                                                                          Ref: DM0Z_65_CRXC
             * 
             * @param list
             */
            public void setValidatingCarrierList(List<String> list) {
                validatingCarrierList = list;
            }

            /** 
             * Get the list of 'AlternateValidatingCarrier' element items. Ref: DM0Z_E9_VLC_CXR
             * 
             * @return list
             */
            public List<String> getAlternateValidatingCarrierList() {
                return alternateValidatingCarrierList;
            }

            /** 
             * Set the list of 'AlternateValidatingCarrier' element items. Ref: DM0Z_E9_VLC_CXR
             * 
             * @param list
             */
            public void setAlternateValidatingCarrierList(List<String> list) {
                alternateValidatingCarrierList = list;
            }

            /** 
             * Get the 'TourNumber' element value.
             * 
             * @return value
             */
            public TourNumber getTourNumber() {
                return tourNumber;
            }

            /** 
             * Set the 'TourNumber' element value.
             * 
             * @param tourNumber
             */
            public void setTourNumber(TourNumber tourNumber) {
                this.tourNumber = tourNumber;
            }

            /** 
             * Get the 'ItineraryType' element value. Possible values
                                                                          I - International
                                                                          D- Domestic

                                                                          Ref:DM0Z_65_ID01
             * 
             * @return value
             */
            public String getItineraryType() {
                return itineraryType;
            }

            /** 
             * Set the 'ItineraryType' element value. Possible values
                                                                          I - International
                                                                          D- Domestic

                                                                          Ref:DM0Z_65_ID01
             * 
             * @param itineraryType
             */
            public void setItineraryType(String itineraryType) {
                this.itineraryType = itineraryType;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourNumber" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="code"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TourNumber implements Serializable
            {
                private String string;
                private String code;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'code' attribute value. Code type associated to the tour number
                                                                                            Possible values:
                                                                                            IT = inclusive tour
                                                                                            BT = bulk tour


                                                                                            Ref: DM0Z_65_ID02
                                                                                            #DM0Z_65_TOUI
                                                                                            #DM0Z_65_TOUB
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code type associated to the tour number
                                                                                            Possible values:
                                                                                            IT = inclusive tour
                                                                                            BT = bulk tour


                                                                                            Ref: DM0Z_65_ID02
                                                                                            #DM0Z_65_TOUI
                                                                                            #DM0Z_65_TOUB
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfo" minOccurs="0" maxOccurs="2">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Amount">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:decimal">
         *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
         *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="sequence"/>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaymentInfo implements Serializable
        {
            private BigDecimal amountDecimal;
            private String amountCurrencyCode;
            private BigInteger amountDecimalPlace;
            private BigInteger sequence;
            private String type;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public BigDecimal getAmountDecimal() {
                return amountDecimal;
            }

            /** 
             * Set the extension value.
             * 
             * @param amountDecimal
             */
            public void setAmountDecimal(BigDecimal amountDecimal) {
                this.amountDecimal = amountDecimal;
            }

            /** 
             * Get the 'currencyCode' attribute value.
             * 
             * @return value
             */
            public String getAmountCurrencyCode() {
                return amountCurrencyCode;
            }

            /** 
             * Set the 'currencyCode' attribute value.
             * 
             * @param amountCurrencyCode
             */
            public void setAmountCurrencyCode(String amountCurrencyCode) {
                this.amountCurrencyCode = amountCurrencyCode;
            }

            /** 
             * Get the 'decimalPlace' attribute value.
             * 
             * @return value
             */
            public BigInteger getAmountDecimalPlace() {
                return amountDecimalPlace;
            }

            /** 
             * Set the 'decimalPlace' attribute value.
             * 
             * @param amountDecimalPlace
             */
            public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                this.amountDecimalPlace = amountDecimalPlace;
            }

            /** 
             * Get the 'sequence' attribute value. Serial number of the FOP
                                                                      1,2
                                                                      Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
             * 
             * @return value
             */
            public BigInteger getSequence() {
                return sequence;
            }

            /** 
             * Set the 'sequence' attribute value. Serial number of the FOP
                                                                      1,2
                                                                      Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
             * 
             * @param sequence
             */
            public void setSequence(BigInteger sequence) {
                this.sequence = sequence;
            }

            /** 
             * Get the 'type' attribute value. Form of payment (e.g. CC, CA..)
                                                                      Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Form of payment (e.g. CC, CA..)
                                                                      Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Message" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Message -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Remarks" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Remarks -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="PricingParameters" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ManualInputMessage" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="BaggageDisclosure" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MessageInfo implements Serializable
        {
            private List<Message> messageList = new ArrayList<Message>();
            private List<Remarks> remarkList = new ArrayList<Remarks>();
            private String pricingParameters;
            private String manualInputMessage;
            private String baggageDisclosure;

            /** 
             * Get the list of 'Message' element items.
             * 
             * @return list
             */
            public List<Message> getMessageList() {
                return messageList;
            }

            /** 
             * Set the list of 'Message' element items.
             * 
             * @param list
             */
            public void setMessageList(List<Message> list) {
                messageList = list;
            }

            /** 
             * Get the list of 'Remarks' element items.
             * 
             * @return list
             */
            public List<Remarks> getRemarkList() {
                return remarkList;
            }

            /** 
             * Set the list of 'Remarks' element items.
             * 
             * @param list
             */
            public void setRemarkList(List<Remarks> list) {
                remarkList = list;
            }

            /** 
             * Get the 'PricingParameters' element value. Pricing parameter used to price PQ

                                                                          Ref: DM0Z_60_TYPE
                                                                          #DM0Z_60_PRI
             * 
             * @return value
             */
            public String getPricingParameters() {
                return pricingParameters;
            }

            /** 
             * Set the 'PricingParameters' element value. Pricing parameter used to price PQ

                                                                          Ref: DM0Z_60_TYPE
                                                                          #DM0Z_60_PRI
             * 
             * @param pricingParameters
             */
            public void setPricingParameters(String pricingParameters) {
                this.pricingParameters = pricingParameters;
            }

            /** 
             * Get the 'ManualInputMessage' element value. Manual input free Text

                                                                          Ref:
                                                                          DM0Z_60_TYPE
                                                                          #DM0Z_60_MAN
             * 
             * @return value
             */
            public String getManualInputMessage() {
                return manualInputMessage;
            }

            /** 
             * Set the 'ManualInputMessage' element value. Manual input free Text

                                                                          Ref:
                                                                          DM0Z_60_TYPE
                                                                          #DM0Z_60_MAN
             * 
             * @param manualInputMessage
             */
            public void setManualInputMessage(String manualInputMessage) {
                this.manualInputMessage = manualInputMessage;
            }

            /** 
             * Get the 'BaggageDisclosure' element value. Baggage disclosure free text

                                                                          Ref: DM0Z_60_TYPE
                                                                          #DM0Z_60_BAG
             * 
             * @return value
             */
            public String getBaggageDisclosure() {
                return baggageDisclosure;
            }

            /** 
             * Set the 'BaggageDisclosure' element value. Baggage disclosure free text

                                                                          Ref: DM0Z_60_TYPE
                                                                          #DM0Z_60_BAG
             * 
             * @param baggageDisclosure
             */
            public void setBaggageDisclosure(String baggageDisclosure) {
                this.baggageDisclosure = baggageDisclosure;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Message" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *         &lt;xs:attribute type="xs:integer" name="number"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Message implements Serializable
            {
                private String string;
                private String type;
                private BigInteger number;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ERROR
                                                                                            WARNING
                                                                                            INFO

                                                                                            Ref:  DM0Z_60_TYPE

                                                                                            x'0C,04,11,03,13
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ERROR
                                                                                            WARNING
                                                                                            INFO

                                                                                            Ref:  DM0Z_60_TYPE

                                                                                            x'0C,04,11,03,13
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'number' attribute value. Message number

                                                                                            Ref: DM0Z_60_MNBR
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'number' attribute value. Message number

                                                                                            Ref: DM0Z_60_MNBR
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
            }
            /** 
             * Remarks applicable on the ticket display
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remarks" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute use="required" name="type">
             *           &lt;xs:simpleType>
             *             &lt;!-- Reference to inner class Type -->
             *           &lt;/xs:simpleType>
             *         &lt;/xs:attribute>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Remarks implements Serializable
            {
                private String string;
                private Type type;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value. ENS - System-generated endorsement
                                                                                            END - Agent-generated endorsement
                                                                                            ENO - Endorsement override
                                                                                            EO1 - Endorsement override 1
                                                                                            EO2 -  Endorsement override 2
                                                                                            EOD  - Endorsement override with ED
                                                                                            RES -  System-generated restriction
                                                                                            RTE -  Reissue-type endorsement
                                                                                            MSK - Mask-entered endorsement
                                                                                            RMK - Mask-entered remark
                                                                                            Ref:  DM0Z_60_TYPE -
                                                                                            x' 05 - x'0F
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. ENS - System-generated endorsement
                                                                                            END - Agent-generated endorsement
                                                                                            ENO - Endorsement override
                                                                                            EO1 - Endorsement override 1
                                                                                            EO2 -  Endorsement override 2
                                                                                            EOD  - Endorsement override with ED
                                                                                            RES -  System-generated restriction
                                                                                            RTE -  Reissue-type endorsement
                                                                                            MSK - Mask-entered endorsement
                                                                                            RMK - Mask-entered remark
                                                                                            Ref:  DM0Z_60_TYPE -
                                                                                            x' 05 - x'0F
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="ENS"/>
                 *     &lt;xs:enumeration value="END"/>
                 *     &lt;xs:enumeration value="ENO"/>
                 *     &lt;xs:enumeration value="EO1"/>
                 *     &lt;xs:enumeration value="EOD"/>
                 *     &lt;xs:enumeration value="RES"/>
                 *     &lt;xs:enumeration value="ERR"/>
                 *     &lt;xs:enumeration value="RTE"/>
                 *     &lt;xs:enumeration value="MSK"/>
                 *     &lt;xs:enumeration value="RMK"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    ENS("ENS"), END("END"), ENO("ENO"), E_O1("EO1"), EOD("EOD"), RES(
                            "RES"), ERR("ERR"), RTE("RTE"), MSK("MSK"), RMK(
                            "RMK");
                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static Type convert(String value) {
                        for (Type inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AgentInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:all>
         *             &lt;xs:element type="xs:string" name="HomeLocation"/>
         *             &lt;xs:element type="xs:string" name="WorkLocation" minOccurs="0"/>
         *           &lt;/xs:all>
         *           &lt;xs:attribute type="xs:string" name="sine"/>
         *           &lt;xs:attribute type="xs:string" name="duty"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="TransactionInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="xs:dateTime" name="CreateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="UpdateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="LocalUpdateDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
         *             &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="ModificationDetails" minOccurs="0">
         *         &lt;!-- Reference to inner class ModificationDetails -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="sequence"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HistoryInfo implements Serializable
        {
            private String agentInfoHomeLocation;
            private String agentInfoWorkLocation;
            private String agentInfoSine;
            private String agentInfoDuty;
            private Date transactionInfoCreateDateTime;
            private Date transactionInfoUpdateDateTime;
            private Date transactionInfoLastDateToPurchase;
            private Date transactionInfoLocalCreateDateTime;
            private Date transactionInfoLocalUpdateDateTime;
            private Date transactionInfoExpiryDateTime;
            private String transactionInfoInputEntry;
            private ModificationDetails modificationDetails;
            private BigInteger sequence;

            /** 
             * Get the 'HomeLocation' element value. Agent home city code
                                                                                      Ref: DM0Z_65_CHOM
                                                                                      Ref: DM0Z_E0_CHOM for history
             * 
             * @return value
             */
            public String getAgentInfoHomeLocation() {
                return agentInfoHomeLocation;
            }

            /** 
             * Set the 'HomeLocation' element value. Agent home city code
                                                                                      Ref: DM0Z_65_CHOM
                                                                                      Ref: DM0Z_E0_CHOM for history
             * 
             * @param agentInfoHomeLocation
             */
            public void setAgentInfoHomeLocation(String agentInfoHomeLocation) {
                this.agentInfoHomeLocation = agentInfoHomeLocation;
            }

            /** 
             * Get the 'WorkLocation' element value. Pseudo City Code
                                                                                      Ref: DM0Z_65_CCTY
                                                                                      Ref: DM0Z_E0_CCTY for history
             * 
             * @return value
             */
            public String getAgentInfoWorkLocation() {
                return agentInfoWorkLocation;
            }

            /** 
             * Set the 'WorkLocation' element value. Pseudo City Code
                                                                                      Ref: DM0Z_65_CCTY
                                                                                      Ref: DM0Z_E0_CCTY for history
             * 
             * @param agentInfoWorkLocation
             */
            public void setAgentInfoWorkLocation(String agentInfoWorkLocation) {
                this.agentInfoWorkLocation = agentInfoWorkLocation;
            }

            /** 
             * Get the 'sine' attribute value. Agent sine-in code
                                                                                  Ref: DM0Z_65_CSIN
                                                                                  Ref: DM0Z_E0_CSIN for history
             * 
             * @return value
             */
            public String getAgentInfoSine() {
                return agentInfoSine;
            }

            /** 
             * Set the 'sine' attribute value. Agent sine-in code
                                                                                  Ref: DM0Z_65_CSIN
                                                                                  Ref: DM0Z_E0_CSIN for history
             * 
             * @param agentInfoSine
             */
            public void setAgentInfoSine(String agentInfoSine) {
                this.agentInfoSine = agentInfoSine;
            }

            /** 
             * Get the 'duty' attribute value. Agent duty code.
                                                                                  Ref: DM0Z_65_CDTY
                                                                                  Ref: DM0Z_E0_CDTY for history
             * 
             * @return value
             */
            public String getAgentInfoDuty() {
                return agentInfoDuty;
            }

            /** 
             * Set the 'duty' attribute value. Agent duty code.
                                                                                  Ref: DM0Z_65_CDTY
                                                                                  Ref: DM0Z_E0_CDTY for history
             * 
             * @param agentInfoDuty
             */
            public void setAgentInfoDuty(String agentInfoDuty) {
                this.agentInfoDuty = agentInfoDuty;
            }

            /** 
             * Get the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                                      Ref: DM0Z_65_CLDB and
                                                                                      DM0Z_65_CLTB
             * 
             * @return value
             */
            public Date getTransactionInfoCreateDateTime() {
                return transactionInfoCreateDateTime;
            }

            /** 
             * Set the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                                      Ref: DM0Z_65_CLDB and
                                                                                      DM0Z_65_CLTB
             * 
             * @param transactionInfoCreateDateTime
             */
            public void setTransactionInfoCreateDateTime(
                    Date transactionInfoCreateDateTime) {
                this.transactionInfoCreateDateTime = transactionInfoCreateDateTime;
            }

            /** 
             * Get the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                                      Ref: DM0Z_65_ULDB and
                                                                                      DM0Z_65_ULTB
             * 
             * @return value
             */
            public Date getTransactionInfoUpdateDateTime() {
                return transactionInfoUpdateDateTime;
            }

            /** 
             * Set the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                                      Ref: DM0Z_65_ULDB and
                                                                                      DM0Z_65_ULTB
             * 
             * @param transactionInfoUpdateDateTime
             */
            public void setTransactionInfoUpdateDateTime(
                    Date transactionInfoUpdateDateTime) {
                this.transactionInfoUpdateDateTime = transactionInfoUpdateDateTime;
            }

            /** 
             * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
             * 
             * @return value
             */
            public Date getTransactionInfoLastDateToPurchase() {
                return transactionInfoLastDateToPurchase;
            }

            /** 
             * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
             * 
             * @param transactionInfoLastDateToPurchase
             */
            public void setTransactionInfoLastDateToPurchase(
                    Date transactionInfoLastDateToPurchase) {
                this.transactionInfoLastDateToPurchase = transactionInfoLastDateToPurchase;
            }

            /** 
             * Get the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                                      Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @return value
             */
            public Date getTransactionInfoLocalCreateDateTime() {
                return transactionInfoLocalCreateDateTime;
            }

            /** 
             * Set the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                                      Ref: SR06PQ-20_CLDB/CTIM
             * 
             * @param transactionInfoLocalCreateDateTime
             */
            public void setTransactionInfoLocalCreateDateTime(
                    Date transactionInfoLocalCreateDateTime) {
                this.transactionInfoLocalCreateDateTime = transactionInfoLocalCreateDateTime;
            }

            /** 
             * Get the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                                      Ref: SR06PQ-20_ULDB/ULTB
             * 
             * @return value
             */
            public Date getTransactionInfoLocalUpdateDateTime() {
                return transactionInfoLocalUpdateDateTime;
            }

            /** 
             * Set the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                                      Ref: SR06PQ-20_ULDB/ULTB
             * 
             * @param transactionInfoLocalUpdateDateTime
             */
            public void setTransactionInfoLocalUpdateDateTime(
                    Date transactionInfoLocalUpdateDateTime) {
                this.transactionInfoLocalUpdateDateTime = transactionInfoLocalUpdateDateTime;
            }

            /** 
             * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
             * 
             * @return value
             */
            public Date getTransactionInfoExpiryDateTime() {
                return transactionInfoExpiryDateTime;
            }

            /** 
             * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
             * 
             * @param transactionInfoExpiryDateTime
             */
            public void setTransactionInfoExpiryDateTime(
                    Date transactionInfoExpiryDateTime) {
                this.transactionInfoExpiryDateTime = transactionInfoExpiryDateTime;
            }

            /** 
             * Get the 'InputEntry' element value. Entry made to update the price quote.
                                                                                      Ref: DM0Z_E0_IMGE
             * 
             * @return value
             */
            public String getTransactionInfoInputEntry() {
                return transactionInfoInputEntry;
            }

            /** 
             * Set the 'InputEntry' element value. Entry made to update the price quote.
                                                                                      Ref: DM0Z_E0_IMGE
             * 
             * @param transactionInfoInputEntry
             */
            public void setTransactionInfoInputEntry(
                    String transactionInfoInputEntry) {
                this.transactionInfoInputEntry = transactionInfoInputEntry;
            }

            /** 
             * Get the 'ModificationDetails' element value.
             * 
             * @return value
             */
            public ModificationDetails getModificationDetails() {
                return modificationDetails;
            }

            /** 
             * Set the 'ModificationDetails' element value.
             * 
             * @param modificationDetails
             */
            public void setModificationDetails(
                    ModificationDetails modificationDetails) {
                this.modificationDetails = modificationDetails;
            }

            /** 
             * Get the 'sequence' attribute value.
             * 
             * @return value
             */
            public BigInteger getSequence() {
                return sequence;
            }

            /** 
             * Set the 'sequence' attribute value.
             * 
             * @param sequence
             */
            public void setSequence(BigInteger sequence) {
                this.sequence = sequence;
            }
            /** 
             * Details of the updates made to the price quote.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModificationDetails" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ManualPricing" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ManualPricing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ModificationDetails implements Serializable
            {
                private List<ManualPricing> manualPricingList = new ArrayList<ManualPricing>();

                /** 
                 * Get the list of 'ManualPricing' element items.
                 * 
                 * @return list
                 */
                public List<ManualPricing> getManualPricingList() {
                    return manualPricingList;
                }

                /** 
                 * Set the list of 'ManualPricing' element items.
                 * 
                 * @param list
                 */
                public void setManualPricingList(List<ManualPricing> list) {
                    manualPricingList = list;
                }
                /** 
                 * Ref: DM0Z_E0_HTYP=#DM0Z_E0_WIC (history type x'0B')
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManualPricing" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Message" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ManualPricing implements Serializable
                {
                    private String message;
                    private String type;

                    /** 
                     * Get the 'Message' element value. Message
                                                                                                      Ref: DM0Z_E0_ICMG
                     * 
                     * @return value
                     */
                    public String getMessage() {
                        return message;
                    }

                    /** 
                     * Set the 'Message' element value. Message
                                                                                                      Ref: DM0Z_E0_ICMG
                     * 
                     * @param message
                     */
                    public void setMessage(String message) {
                        this.message = message;
                    }

                    /** 
                     * Get the 'type' attribute value. UpdateType

                                                                                                  Possible values:
                                                                                                  XPQ
                                                                                                  MPQ
                                                                                                  APQ

                                                                                                  Ref: DM0Z_E0_HPQS
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. UpdateType

                                                                                                  Possible values:
                                                                                                  XPQ
                                                                                                  MPQ
                                                                                                  APQ

                                                                                                  Ref: DM0Z_E0_HPQS
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="PQ"/>
         *     &lt;xs:enumeration value="PQR"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            PQ, PQR
        }
    }
    /** 
     * Price Quote Custom details. This information is equivalent to *PQ
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomDetails" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AgentInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="HomeLocation"/>
     *             &lt;xs:element type="xs:string" name="WorkLocation" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" name="sine"/>
     *           &lt;xs:attribute type="xs:string" name="duty"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="TransactionInfo">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:dateTime" name="CreateDateTime"/>
     *             &lt;xs:element type="xs:dateTime" name="UpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="LocalUpdateDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
     *             &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class NameAssociationInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SegmentInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SegmentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AdditionalFareInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AdditionalFareInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FeeInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FeeInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiscellaneousInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscellaneousInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaymentInfo" minOccurs="0" maxOccurs="2">
     *         &lt;!-- Reference to inner class PaymentInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MessageInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class MessageInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="HistoryInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HistoryInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute use="required" name="type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:integer" use="required" name="number"/>
     *     &lt;xs:attribute type="xs:string" name="passengerType"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="status"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
     *     &lt;xs:attribute type="xs:string" name="pricingStatus"/>
     *     &lt;xs:attribute type="xs:boolean" name="displayOnly"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CustomDetails implements Serializable
    {
        private String agentInfoHomeLocation;
        private String agentInfoWorkLocation;
        private String agentInfoSine;
        private String agentInfoDuty;
        private Date transactionInfoCreateDateTime;
        private Date transactionInfoUpdateDateTime;
        private Date transactionInfoLastDateToPurchase;
        private Date transactionInfoLocalCreateDateTime;
        private Date transactionInfoLocalUpdateDateTime;
        private Date transactionInfoExpiryDateTime;
        private String transactionInfoInputEntry;
        private List<NameAssociationInfo> nameAssociationInfoList = new ArrayList<NameAssociationInfo>();
        private List<SegmentInfo> segmentInfoList = new ArrayList<SegmentInfo>();
        private FareInfo fareInfo;
        private AdditionalFareInfo additionalFareInfo;
        private List<FeeInfo> feeInfoList = new ArrayList<FeeInfo>();
        private MiscellaneousInfo miscellaneousInfo;
        private List<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>();
        private MessageInfo messageInfo;
        private List<HistoryInfo> historyInfoList = new ArrayList<HistoryInfo>();
        private Type type;
        private BigInteger number;
        private String passengerType;
        private String status;
        private String pricingType;
        private String pricingStatus;
        private Boolean displayOnly;

        /** 
         * Get the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @return value
         */
        public String getAgentInfoHomeLocation() {
            return agentInfoHomeLocation;
        }

        /** 
         * Set the 'HomeLocation' element value. Agent home city code
                                                                        Ref: DM0Z_65_CHOM
                                                                        Ref: DM0Z_E0_CHOM for history
         * 
         * @param agentInfoHomeLocation
         */
        public void setAgentInfoHomeLocation(String agentInfoHomeLocation) {
            this.agentInfoHomeLocation = agentInfoHomeLocation;
        }

        /** 
         * Get the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @return value
         */
        public String getAgentInfoWorkLocation() {
            return agentInfoWorkLocation;
        }

        /** 
         * Set the 'WorkLocation' element value. Pseudo City Code
                                                                        Ref: DM0Z_65_CCTY
                                                                        Ref: DM0Z_E0_CCTY for history
         * 
         * @param agentInfoWorkLocation
         */
        public void setAgentInfoWorkLocation(String agentInfoWorkLocation) {
            this.agentInfoWorkLocation = agentInfoWorkLocation;
        }

        /** 
         * Get the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @return value
         */
        public String getAgentInfoSine() {
            return agentInfoSine;
        }

        /** 
         * Set the 'sine' attribute value. Agent sine-in code
                                                                    Ref: DM0Z_65_CSIN
                                                                    Ref: DM0Z_E0_CSIN for history
         * 
         * @param agentInfoSine
         */
        public void setAgentInfoSine(String agentInfoSine) {
            this.agentInfoSine = agentInfoSine;
        }

        /** 
         * Get the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @return value
         */
        public String getAgentInfoDuty() {
            return agentInfoDuty;
        }

        /** 
         * Set the 'duty' attribute value. Agent duty code.
                                                                    Ref: DM0Z_65_CDTY
                                                                    Ref: DM0Z_E0_CDTY for history
         * 
         * @param agentInfoDuty
         */
        public void setAgentInfoDuty(String agentInfoDuty) {
            this.agentInfoDuty = agentInfoDuty;
        }

        /** 
         * Get the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @return value
         */
        public Date getTransactionInfoCreateDateTime() {
            return transactionInfoCreateDateTime;
        }

        /** 
         * Set the 'CreateDateTime' element value. System Date/time the PQ was created
                                                                        Ref: DM0Z_65_CLDB and
                                                                        DM0Z_65_CLTB
         * 
         * @param transactionInfoCreateDateTime
         */
        public void setTransactionInfoCreateDateTime(
                Date transactionInfoCreateDateTime) {
            this.transactionInfoCreateDateTime = transactionInfoCreateDateTime;
        }

        /** 
         * Get the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoUpdateDateTime() {
            return transactionInfoUpdateDateTime;
        }

        /** 
         * Set the 'UpdateDateTime' element value. System Date/time the PQ was updated.
                                                                        Ref: DM0Z_65_ULDB and
                                                                        DM0Z_65_ULTB
         * 
         * @param transactionInfoUpdateDateTime
         */
        public void setTransactionInfoUpdateDateTime(
                Date transactionInfoUpdateDateTime) {
            this.transactionInfoUpdateDateTime = transactionInfoUpdateDateTime;
        }

        /** 
         * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @return value
         */
        public Date getTransactionInfoLastDateToPurchase() {
            return transactionInfoLastDateToPurchase;
        }

        /** 
         * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
         * 
         * @param transactionInfoLastDateToPurchase
         */
        public void setTransactionInfoLastDateToPurchase(
                Date transactionInfoLastDateToPurchase) {
            this.transactionInfoLastDateToPurchase = transactionInfoLastDateToPurchase;
        }

        /** 
         * Get the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @return value
         */
        public Date getTransactionInfoLocalCreateDateTime() {
            return transactionInfoLocalCreateDateTime;
        }

        /** 
         * Set the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_CLDB/CTIM
         * 
         * @param transactionInfoLocalCreateDateTime
         */
        public void setTransactionInfoLocalCreateDateTime(
                Date transactionInfoLocalCreateDateTime) {
            this.transactionInfoLocalCreateDateTime = transactionInfoLocalCreateDateTime;
        }

        /** 
         * Get the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @return value
         */
        public Date getTransactionInfoLocalUpdateDateTime() {
            return transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Set the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
                                                                        Ref: SR06PQ-20_ULDB/ULTB
         * 
         * @param transactionInfoLocalUpdateDateTime
         */
        public void setTransactionInfoLocalUpdateDateTime(
                Date transactionInfoLocalUpdateDateTime) {
            this.transactionInfoLocalUpdateDateTime = transactionInfoLocalUpdateDateTime;
        }

        /** 
         * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @return value
         */
        public Date getTransactionInfoExpiryDateTime() {
            return transactionInfoExpiryDateTime;
        }

        /** 
         * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
         * 
         * @param transactionInfoExpiryDateTime
         */
        public void setTransactionInfoExpiryDateTime(
                Date transactionInfoExpiryDateTime) {
            this.transactionInfoExpiryDateTime = transactionInfoExpiryDateTime;
        }

        /** 
         * Get the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @return value
         */
        public String getTransactionInfoInputEntry() {
            return transactionInfoInputEntry;
        }

        /** 
         * Set the 'InputEntry' element value. Entry made to update the price quote.
                                                                        Ref: DM0Z_60_TYPE
                                                                        #DM0Z_60_PRI
                                                                        #DM0Z_60_MAN
         * 
         * @param transactionInfoInputEntry
         */
        public void setTransactionInfoInputEntry(
                String transactionInfoInputEntry) {
            this.transactionInfoInputEntry = transactionInfoInputEntry;
        }

        /** 
         * Get the list of 'NameAssociationInfo' element items.
         * 
         * @return list
         */
        public List<NameAssociationInfo> getNameAssociationInfoList() {
            return nameAssociationInfoList;
        }

        /** 
         * Set the list of 'NameAssociationInfo' element items.
         * 
         * @param list
         */
        public void setNameAssociationInfoList(List<NameAssociationInfo> list) {
            nameAssociationInfoList = list;
        }

        /** 
         * Get the list of 'SegmentInfo' element items.
         * 
         * @return list
         */
        public List<SegmentInfo> getSegmentInfoList() {
            return segmentInfoList;
        }

        /** 
         * Set the list of 'SegmentInfo' element items.
         * 
         * @param list
         */
        public void setSegmentInfoList(List<SegmentInfo> list) {
            segmentInfoList = list;
        }

        /** 
         * Get the 'FareInfo' element value.
         * 
         * @return value
         */
        public FareInfo getFareInfo() {
            return fareInfo;
        }

        /** 
         * Set the 'FareInfo' element value.
         * 
         * @param fareInfo
         */
        public void setFareInfo(FareInfo fareInfo) {
            this.fareInfo = fareInfo;
        }

        /** 
         * Get the 'AdditionalFareInfo' element value.
         * 
         * @return value
         */
        public AdditionalFareInfo getAdditionalFareInfo() {
            return additionalFareInfo;
        }

        /** 
         * Set the 'AdditionalFareInfo' element value.
         * 
         * @param additionalFareInfo
         */
        public void setAdditionalFareInfo(AdditionalFareInfo additionalFareInfo) {
            this.additionalFareInfo = additionalFareInfo;
        }

        /** 
         * Get the list of 'FeeInfo' element items.
         * 
         * @return list
         */
        public List<FeeInfo> getFeeInfoList() {
            return feeInfoList;
        }

        /** 
         * Set the list of 'FeeInfo' element items.
         * 
         * @param list
         */
        public void setFeeInfoList(List<FeeInfo> list) {
            feeInfoList = list;
        }

        /** 
         * Get the 'MiscellaneousInfo' element value.
         * 
         * @return value
         */
        public MiscellaneousInfo getMiscellaneousInfo() {
            return miscellaneousInfo;
        }

        /** 
         * Set the 'MiscellaneousInfo' element value.
         * 
         * @param miscellaneousInfo
         */
        public void setMiscellaneousInfo(MiscellaneousInfo miscellaneousInfo) {
            this.miscellaneousInfo = miscellaneousInfo;
        }

        /** 
         * Get the list of 'PaymentInfo' element items.
         * 
         * @return list
         */
        public List<PaymentInfo> getPaymentInfoList() {
            return paymentInfoList;
        }

        /** 
         * Set the list of 'PaymentInfo' element items.
         * 
         * @param list
         */
        public void setPaymentInfoList(List<PaymentInfo> list) {
            paymentInfoList = list;
        }

        /** 
         * Get the 'MessageInfo' element value.
         * 
         * @return value
         */
        public MessageInfo getMessageInfo() {
            return messageInfo;
        }

        /** 
         * Set the 'MessageInfo' element value.
         * 
         * @param messageInfo
         */
        public void setMessageInfo(MessageInfo messageInfo) {
            this.messageInfo = messageInfo;
        }

        /** 
         * Get the list of 'HistoryInfo' element items.
         * 
         * @return list
         */
        public List<HistoryInfo> getHistoryInfoList() {
            return historyInfoList;
        }

        /** 
         * Set the list of 'HistoryInfo' element items.
         * 
         * @param list
         */
        public void setHistoryInfoList(List<HistoryInfo> list) {
            historyInfoList = list;
        }

        /** 
         * Get the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ   - Price Quote Record
                                                        PQR - Price Quote Reissue
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Price Quote Type

                                                        Possible values can be:
                                                        PQ   - Price Quote Record
                                                        PQR - Price Quote Reissue
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }

        /** 
         * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
         * 
         * @return value
         */
        public String getPassengerType() {
            return passengerType;
        }

        /** 
         * Set the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
         * 
         * @param passengerType
         */
        public void setPassengerType(String passengerType) {
            this.passengerType = passengerType;
        }

        /** 
         * Get the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @return value
         */
        public String getStatus() {
            return status;
        }

        /** 
         * Set the 'status' attribute value. PQ status
                                                        Possible values are:
                                                        A - Active
                                                        H - History
                                                        below values applicable only for airlines and not agencies
                                                        I - Inactive
                                                        M - Manual
                                                        X - Expired
                                                        U - Unretained
                                                        F - FSC Manual
         * 
         * @param status
         */
        public void setStatus(String status) {
            this.status = status;
        }

        /** 
         * Get the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @return value
         */
        public String getPricingType() {
            return pricingType;
        }

        /** 
         * Set the 'pricingType' attribute value. Airlines/agencies
                                                        S - System
                                                        A - Ammended
                                                        M - Manual
         * 
         * @param pricingType
         */
        public void setPricingType(String pricingType) {
            this.pricingType = pricingType;
        }

        /** 
         * Get the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @return value
         */
        public String getPricingStatus() {
            return pricingStatus;
        }

        /** 
         * Set the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

                                                        Possible values:

                                                        Abacus GDS
                                                        AUTO PRICED
                                                        MANUAL
                                                        RATE DESK

                                                        INFINI GDS
                                                        C-Guaranteed
                                                        W - With warning/Not guaranteed
                                                        M - amendments/Not guaranteed
                                                        A- overrides/Not guaranteed
         * 
         * @param pricingStatus
         */
        public void setPricingStatus(String pricingStatus) {
            this.pricingStatus = pricingStatus;
        }

        /** 
         * Get the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @return value
         */
        public Boolean getDisplayOnly() {
            return displayOnly;
        }

        /** 
         * Set the 'displayOnly' attribute value. Set to true on PQ display only

                                                        Ref: DM0Z_85_BC35,#DM0Z_85_DOP
         * 
         * @param displayOnly
         */
        public void setDisplayOnly(Boolean displayOnly) {
            this.displayOnly = displayOnly;
        }
        /** 
         * List of associated names
                                                            for this PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="nameNumber"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="nameId"/>
         *     &lt;xs:attribute type="xs:string" name="firstName"/>
         *     &lt;xs:attribute type="xs:string" name="lastName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NameAssociationInfo implements Serializable
        {
            private String nameNumber;
            private BigInteger nameId;
            private String firstName;
            private String lastName;

            /** 
             * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }

            /** 
             * Get the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
             * 
             * @return value
             */
            public BigInteger getNameId() {
                return nameId;
            }

            /** 
             * Set the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
             * 
             * @param nameId
             */
            public void setNameId(BigInteger nameId) {
                this.nameId = nameId;
            }

            /** 
             * Get the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
             * 
             * @return value
             */
            public String getFirstName() {
                return firstName;
            }

            /** 
             * Set the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
             * 
             * @param firstName
             */
            public void setFirstName(String firstName) {
                this.firstName = firstName;
            }

            /** 
             * Get the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
             * 
             * @return value
             */
            public String getLastName() {
                return lastName;
            }

            /** 
             * Set the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
             * 
             * @param lastName
             */
            public void setLastName(String lastName) {
                this.lastName = lastName;
            }
        }
        /** 
         * Data associated to the segments priced within the PQ
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Flight" minOccurs="0">
         *         &lt;!-- Reference to inner class Flight -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="NotValidBefore" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="NotValidAfter" minOccurs="0"/>
         *       &lt;xs:element name="Baggage" minOccurs="0">
         *         &lt;!-- Reference to inner class Baggage -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="number"/>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *     &lt;xs:attribute type="xs:string" name="segmentStatus"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SegmentInfo implements Serializable
        {
            private Flight flight;
            private String fareBasis;
            private java.sql.Date notValidBefore;
            private java.sql.Date notValidAfter;
            private Baggage baggage;
            private BigInteger number;
            private String type;
            private String segmentStatus;

            /** 
             * Get the 'Flight' element value.
             * 
             * @return value
             */
            public Flight getFlight() {
                return flight;
            }

            /** 
             * Set the 'Flight' element value.
             * 
             * @param flight
             */
            public void setFlight(Flight flight) {
                this.flight = flight;
            }

            /** 
             * Get the 'FareBasis' element value. Ref: DM0Z_70_FBCD
             * 
             * @return value
             */
            public String getFareBasis() {
                return fareBasis;
            }

            /** 
             * Set the 'FareBasis' element value. Ref: DM0Z_70_FBCD
             * 
             * @param fareBasis
             */
            public void setFareBasis(String fareBasis) {
                this.fareBasis = fareBasis;
            }

            /** 
             * Get the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVBB
             * 
             * @return value
             */
            public java.sql.Date getNotValidBefore() {
                return notValidBefore;
            }

            /** 
             * Set the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVBB
             * 
             * @param notValidBefore
             */
            public void setNotValidBefore(java.sql.Date notValidBefore) {
                this.notValidBefore = notValidBefore;
            }

            /** 
             * Get the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVAB
             * 
             * @return value
             */
            public java.sql.Date getNotValidAfter() {
                return notValidAfter;
            }

            /** 
             * Set the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
                                                                          Ref: DM0Z_70_NVAB
             * 
             * @param notValidAfter
             */
            public void setNotValidAfter(java.sql.Date notValidAfter) {
                this.notValidAfter = notValidAfter;
            }

            /** 
             * Get the 'Baggage' element value.
             * 
             * @return value
             */
            public Baggage getBaggage() {
                return baggage;
            }

            /** 
             * Set the 'Baggage' element value.
             * 
             * @param baggage
             */
            public void setBaggage(Baggage baggage) {
                this.baggage = baggage;
            }

            /** 
             * Get the 'number' attribute value. PNR Segment Number at PQ create.
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'number' attribute value. PNR Segment Number at PQ create.
                                                                      Ref: DM0Z_70_SEGI
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }

            /** 
             * Get the 'type' attribute value. Possible values:
                                                                      A = Arunk
                                                                      O = Open
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Possible values:
                                                                      A = Arunk
                                                                      O = Open
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'segmentStatus' attribute value. Possbile values:
                                                                      OK
                                                                      HQ
                                                                      Ref: DM0Z_70_STAT
             * 
             * @return value
             */
            public String getSegmentStatus() {
                return segmentStatus;
            }

            /** 
             * Set the 'segmentStatus' attribute value. Possbile values:
                                                                      OK
                                                                      HQ
                                                                      Ref: DM0Z_70_STAT
             * 
             * @param segmentStatus
             */
            public void setSegmentStatus(String segmentStatus) {
                this.segmentStatus = segmentStatus;
            }
            /** 
             * FlightInfo
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MarketingFlight" minOccurs="0">
             *         &lt;!-- Reference to inner class MarketingFlight -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
             *       &lt;xs:element name="Departure" minOccurs="0">
             *         &lt;!-- Reference to inner class Departure -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Arrival" minOccurs="0">
             *         &lt;!-- Reference to inner class Arrival -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="connectionIndicator"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Flight implements Serializable
            {
                private MarketingFlight marketingFlight;
                private String classOfService;
                private Departure departure;
                private Arrival arrival;
                private String connectionIndicator;

                /** 
                 * Get the 'MarketingFlight' element value.
                 * 
                 * @return value
                 */
                public MarketingFlight getMarketingFlight() {
                    return marketingFlight;
                }

                /** 
                 * Set the 'MarketingFlight' element value.
                 * 
                 * @param marketingFlight
                 */
                public void setMarketingFlight(MarketingFlight marketingFlight) {
                    this.marketingFlight = marketingFlight;
                }

                /** 
                 * Get the 'ClassOfService' element value. Booking class of service
                                                                                        Ref: DM0Z_70_CLSP
                 * 
                 * @return value
                 */
                public String getClassOfService() {
                    return classOfService;
                }

                /** 
                 * Set the 'ClassOfService' element value. Booking class of service
                                                                                        Ref: DM0Z_70_CLSP
                 * 
                 * @param classOfService
                 */
                public void setClassOfService(String classOfService) {
                    this.classOfService = classOfService;
                }

                /** 
                 * Get the 'Departure' element value.
                 * 
                 * @return value
                 */
                public Departure getDeparture() {
                    return departure;
                }

                /** 
                 * Set the 'Departure' element value.
                 * 
                 * @param departure
                 */
                public void setDeparture(Departure departure) {
                    this.departure = departure;
                }

                /** 
                 * Get the 'Arrival' element value.
                 * 
                 * @return value
                 */
                public Arrival getArrival() {
                    return arrival;
                }

                /** 
                 * Set the 'Arrival' element value.
                 * 
                 * @param arrival
                 */
                public void setArrival(Arrival arrival) {
                    this.arrival = arrival;
                }

                /** 
                 * Get the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
                                                                                    Ref: DM0Z_70_DCON. Possible values:
                                                                                    X = Transit
                                                                                    O = Stopover
                 * 
                 * @return value
                 */
                public String getConnectionIndicator() {
                    return connectionIndicator;
                }

                /** 
                 * Set the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
                                                                                    Ref: DM0Z_70_DCON. Possible values:
                                                                                    X = Transit
                                                                                    O = Stopover
                 * 
                 * @param connectionIndicator
                 */
                public void setConnectionIndicator(String connectionIndicator) {
                    this.connectionIndicator = connectionIndicator;
                }
                /** 
                 * Marketing Flight Info

                                                                                        Carrier Code
                                                                                        Ref: DM0Z_70_CXRM
                                                                                        Flight number
                                                                                        Ref: DM0Z_70_FLTM
                                                                                        Carrier name DM0Z_70_CXNM
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingFlight" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="number"/>
                 *         &lt;xs:attribute type="xs:string" name="name"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MarketingFlight implements Serializable
                {
                    private String string;
                    private String number;
                    private String name;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'number' attribute value. Flight  Number
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'number' attribute value. Flight  Number
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'name' attribute value. Carrier Name
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'name' attribute value. Carrier Name
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }
                }
                /** 
                 * Departure Info

                                                                                        Departure DateTime
                                                                                        Ref: DM0Z_70_FDDB
                                                                                        Ref:DM0Z_70_FDTB
                                                                                        Departure CityCode
                                                                                        Ref: DM0Z_70_DCTY
                                                                                        Departure City name
                                                                                        Ref: DM0Z_70_DCTN
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Departure" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:dateTime" name="DateTime" minOccurs="0"/>
                 *       &lt;xs:element name="CityCode">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:string">
                 *               &lt;xs:attribute type="xs:string" name="name"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Departure implements Serializable
                {
                    private Date dateTime;
                    private String cityCodeString;
                    private String cityCodeName;

                    /** 
                     * Get the 'DateTime' element value.
                     * 
                     * @return value
                     */
                    public Date getDateTime() {
                        return dateTime;
                    }

                    /** 
                     * Set the 'DateTime' element value.
                     * 
                     * @param dateTime
                     */
                    public void setDateTime(Date dateTime) {
                        this.dateTime = dateTime;
                    }

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getCityCodeString() {
                        return cityCodeString;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param cityCodeString
                     */
                    public void setCityCodeString(String cityCodeString) {
                        this.cityCodeString = cityCodeString;
                    }

                    /** 
                     * Get the 'name' attribute value.
                     * 
                     * @return value
                     */
                    public String getCityCodeName() {
                        return cityCodeName;
                    }

                    /** 
                     * Set the 'name' attribute value.
                     * 
                     * @param cityCodeName
                     */
                    public void setCityCodeName(String cityCodeName) {
                        this.cityCodeName = cityCodeName;
                    }
                }
                /** 
                 * Arrival Info

                                                                                        Arrival DateTime
                                                                                        Ref: DM0Z_70_FADB
                                                                                        Ref:DM0Z_70_FATB
                                                                                        Arrival CityCode
                                                                                        Ref: DM0Z_70_ACTY
                                                                                        Arrival City name
                                                                                        Ref:DM0Z_70_ACTN
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Arrival" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:dateTime" name="DateTime" minOccurs="0"/>
                 *       &lt;xs:element name="CityCode">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:string">
                 *               &lt;xs:attribute type="xs:string" name="name"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Arrival implements Serializable
                {
                    private Date dateTime;
                    private String cityCodeString;
                    private String cityCodeName;

                    /** 
                     * Get the 'DateTime' element value.
                     * 
                     * @return value
                     */
                    public Date getDateTime() {
                        return dateTime;
                    }

                    /** 
                     * Set the 'DateTime' element value.
                     * 
                     * @param dateTime
                     */
                    public void setDateTime(Date dateTime) {
                        this.dateTime = dateTime;
                    }

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getCityCodeString() {
                        return cityCodeString;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param cityCodeString
                     */
                    public void setCityCodeString(String cityCodeString) {
                        this.cityCodeString = cityCodeString;
                    }

                    /** 
                     * Get the 'name' attribute value.
                     * 
                     * @return value
                     */
                    public String getCityCodeName() {
                        return cityCodeName;
                    }

                    /** 
                     * Set the 'name' attribute value.
                     * 
                     * @param cityCodeName
                     */
                    public void setCityCodeName(String cityCodeName) {
                        this.cityCodeName = cityCodeName;
                    }
                }
            }
            /** 
             * Baggage information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Baggage" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="allowance"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Baggage implements Serializable
            {
                private String type;
                private String allowance;

                /** 
                 * Get the 'type' attribute value. Baggage type. Ref: DM0Z_70_BTYP
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Baggage type. Ref: DM0Z_70_BTYP
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'allowance' attribute value. Number of bags to be checked in. Ref: DM0Z_70_BAMT
                 * 
                 * @return value
                 */
                public String getAllowance() {
                    return allowance;
                }

                /** 
                 * Set the 'allowance' attribute value. Number of bags to be checked in. Ref: DM0Z_70_BAMT
                 * 
                 * @param allowance
                 */
                public void setAllowance(String allowance) {
                    this.allowance = allowance;
                }
            }
        }
        /** 
         * Fare details in the PriceQuote
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FareIndicators" minOccurs="0">
         *         &lt;!-- Reference to inner class FareIndicators -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EquivalentFare" minOccurs="0">
         *         &lt;!-- Reference to inner class EquivalentFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalTax" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalTax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalFare" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TaxInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class TaxInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FareCalculation" minOccurs="0"/>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class HandlingFee -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OptionalServiceInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class OptionalServiceInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="type"/>
         *     &lt;xs:attribute type="xs:string" name="source"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareInfo implements Serializable
        {
            private FareIndicators fareIndicators;
            private BaseFare baseFare;
            private EquivalentFare equivalentFare;
            private TotalTax totalTax;
            private TotalFare totalFare;
            private TaxInfo taxInfo;
            private String fareCalculation;
            private Commission commission;
            private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();
            private List<OptionalServiceInfo> optionalServiceInfoList = new ArrayList<OptionalServiceInfo>();
            private String type;
            private String source;

            /** 
             * Get the 'FareIndicators' element value.
             * 
             * @return value
             */
            public FareIndicators getFareIndicators() {
                return fareIndicators;
            }

            /** 
             * Set the 'FareIndicators' element value.
             * 
             * @param fareIndicators
             */
            public void setFareIndicators(FareIndicators fareIndicators) {
                this.fareIndicators = fareIndicators;
            }

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivalentFare' element value.
             * 
             * @return value
             */
            public EquivalentFare getEquivalentFare() {
                return equivalentFare;
            }

            /** 
             * Set the 'EquivalentFare' element value.
             * 
             * @param equivalentFare
             */
            public void setEquivalentFare(EquivalentFare equivalentFare) {
                this.equivalentFare = equivalentFare;
            }

            /** 
             * Get the 'TotalTax' element value.
             * 
             * @return value
             */
            public TotalTax getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value.
             * 
             * @param totalTax
             */
            public void setTotalTax(TotalTax totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalFare' element value.
             * 
             * @return value
             */
            public TotalFare getTotalFare() {
                return totalFare;
            }

            /** 
             * Set the 'TotalFare' element value.
             * 
             * @param totalFare
             */
            public void setTotalFare(TotalFare totalFare) {
                this.totalFare = totalFare;
            }

            /** 
             * Get the 'TaxInfo' element value.
             * 
             * @return value
             */
            public TaxInfo getTaxInfo() {
                return taxInfo;
            }

            /** 
             * Set the 'TaxInfo' element value.
             * 
             * @param taxInfo
             */
            public void setTaxInfo(TaxInfo taxInfo) {
                this.taxInfo = taxInfo;
            }

            /** 
             * Get the 'FareCalculation' element value. FareCalc line free Text

                                                                          Ref: DM0Z_A5_DATA
             * 
             * @return value
             */
            public String getFareCalculation() {
                return fareCalculation;
            }

            /** 
             * Set the 'FareCalculation' element value. FareCalc line free Text

                                                                          Ref: DM0Z_A5_DATA
             * 
             * @param fareCalculation
             */
            public void setFareCalculation(String fareCalculation) {
                this.fareCalculation = fareCalculation;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the list of 'HandlingFee' element items.
             * 
             * @return list
             */
            public List<HandlingFee> getHandlingFeeList() {
                return handlingFeeList;
            }

            /** 
             * Set the list of 'HandlingFee' element items.
             * 
             * @param list
             */
            public void setHandlingFeeList(List<HandlingFee> list) {
                handlingFeeList = list;
            }

            /** 
             * Get the list of 'OptionalServiceInfo' element items.
             * 
             * @return list
             */
            public List<OptionalServiceInfo> getOptionalServiceInfoList() {
                return optionalServiceInfoList;
            }

            /** 
             * Set the list of 'OptionalServiceInfo' element items.
             * 
             * @param list
             */
            public void setOptionalServiceInfoList(
                    List<OptionalServiceInfo> list) {
                optionalServiceInfoList = list;
            }

            /** 
             * Get the 'type' attribute value. Type associated to the primary selling fare.

                                                                      Possible Values:
                                                                      ASL - Adjusted Selling Fare
                                                                      MSL - Manual Adjusted Selling Fare

                                                                      Ref: DM0Z_85_FTY #DM0Z_85_NOR

                                                                      DM0Z_CA_FTYP
                                                                      #DM0Z_CA_ASL #DM0Z_CA_MSL
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value. Type associated to the primary selling fare.

                                                                      Possible Values:
                                                                      ASL - Adjusted Selling Fare
                                                                      MSL - Manual Adjusted Selling Fare

                                                                      Ref: DM0Z_85_FTY #DM0Z_85_NOR

                                                                      DM0Z_CA_FTYP
                                                                      #DM0Z_CA_ASL #DM0Z_CA_MSL
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'source' attribute value. Fare source/vendor
                                                                      Ref: DM0Z_85_FAR_SRCE
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'source' attribute value. Fare source/vendor
                                                                      Ref: DM0Z_85_FAR_SRCE
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }
            /** 
             * Fare level Indicators
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareIndicators" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" name="governmentApproval"/>
             *     &lt;xs:attribute type="xs:boolean" name="negotiatedFare"/>
             *     &lt;xs:attribute type="xs:boolean" name="NUC_Suppression"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareIndicators implements Serializable
            {
                private Boolean governmentApproval;
                private Boolean negotiatedFare;
                private Boolean NUCSuppression;

                /** 
                 * Get the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

                                                                                    Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
                 * 
                 * @return value
                 */
                public Boolean getGovernmentApproval() {
                    return governmentApproval;
                }

                /** 
                 * Set the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

                                                                                    Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
                 * 
                 * @param governmentApproval
                 */
                public void setGovernmentApproval(Boolean governmentApproval) {
                    this.governmentApproval = governmentApproval;
                }

                /** 
                 * Get the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

                                                                                    Ref:
                                                                                    Abacus
                                                                                    DM0Z_40_FSCI
                                                                                    #DM0Z_40_XFAR
                                                                                    DM0Z_E8_RMT_TYPE

                                                                                    Infini
                                                                                    DM0Z_40_RSTA #DM0Z_40_MAN
                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_BCAT
                 * 
                 * @return value
                 */
                public Boolean getNegotiatedFare() {
                    return negotiatedFare;
                }

                /** 
                 * Set the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

                                                                                    Ref:
                                                                                    Abacus
                                                                                    DM0Z_40_FSCI
                                                                                    #DM0Z_40_XFAR
                                                                                    DM0Z_E8_RMT_TYPE

                                                                                    Infini
                                                                                    DM0Z_40_RSTA #DM0Z_40_MAN
                                                                                    DM0Z_85_BC35
                                                                                    #DM0Z_85_BCAT
                 * 
                 * @param negotiatedFare
                 */
                public void setNegotiatedFare(Boolean negotiatedFare) {
                    this.negotiatedFare = negotiatedFare;
                }

                /** 
                 * Get the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

                                                                                    Ref: DM0Z_65_ID01
                                                                                    #DM0Z_65_NUC
                 * 
                 * @return value
                 */
                public Boolean getNUCSuppression() {
                    return NUCSuppression;
                }

                /** 
                 * Set the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

                                                                                    Ref: DM0Z_65_ID01
                                                                                    #DM0Z_65_NUC
                 * 
                 * @param NUCSuppression
                 */
                public void setNUCSuppression(Boolean NUCSuppression) {
                    this.NUCSuppression = NUCSuppression;
                }
            }
            /** 
             * Base fare per PQ type
                                                                          Ref: DM0Z_85_BFAR
                                                                          DM0Z_CA_BFAR
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Equivalent Fare per PQ type
                                                                          Ref: DM0Z_85_EFAR
                                                                          DM0Z_CA_EFAR
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EquivalentFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Tax Total per PQ type
                                                                          Ref: DM0Z_85_TTAC
                                                                          DM0Z_CA_TTAC
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalTax implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Total fare inclusive of taxes per PQ type
                                                                          Ref: DM0Z_85_TFAR
                                                                          DM0Z_CA_TFAR
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalFare implements Serializable
            {
                private BigDecimal decimal;
                private String currencyCode;
                private BigInteger decimalPlace;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getDecimalPlace() {
                    return decimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param decimalPlace
                 */
                public void setDecimalPlace(BigInteger decimalPlace) {
                    this.decimalPlace = decimalPlace;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
             *         &lt;!-- Reference to inner class CombinedTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
             *         &lt;!-- Reference to inner class Tax -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TaxInfo implements Serializable
            {
                private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                private List<Tax> taxList = new ArrayList<Tax>();

                /** 
                 * Get the list of 'CombinedTax' element items.
                 * 
                 * @return list
                 */
                public List<CombinedTax> getCombinedTaxList() {
                    return combinedTaxList;
                }

                /** 
                 * Set the list of 'CombinedTax' element items.
                 * 
                 * @param list
                 */
                public void setCombinedTaxList(List<CombinedTax> list) {
                    combinedTaxList = list;
                }

                /** 
                 * Get the list of 'Tax' element items.
                 * 
                 * @return list
                 */
                public List<Tax> getTaxList() {
                    return taxList;
                }

                /** 
                 * Set the list of 'Tax' element items.
                 * 
                 * @param list
                 */
                public void setTaxList(List<Tax> list) {
                    taxList = list;
                }
                /** 
                 * Taxes combined and represented in tax boxes 1, 2, 3
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                 *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                 *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CombinedTax implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private String code;
                    private Boolean paid;
                    private Boolean exempt;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Get the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @return value
                     */
                    public Boolean getPaid() {
                        return paid;
                    }

                    /** 
                     * Set the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @param paid
                     */
                    public void setPaid(Boolean paid) {
                        this.paid = paid;
                    }

                    /** 
                     * Get the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @return value
                     */
                    public Boolean getExempt() {
                        return exempt;
                    }

                    /** 
                     * Set the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @param exempt
                     */
                    public void setExempt(Boolean exempt) {
                        this.exempt = exempt;
                    }
                }
                /** 
                 * Includes tax breakdown
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                 *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                 *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Tax implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private String code;
                    private Boolean paid;
                    private Boolean exempt;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Get the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Tax box identifier

                                                                                                  Ref: DM0Z_CA_TID1
                                                                                                  DM0Z_CA_TID2
                                                                                                  DM0Z_CA_TID3

                                                                                                  DM0Z_85_TID1
                                                                                                  DM0Z_85_TID2
                                                                                                  DM0Z_85_TID3
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @return value
                     */
                    public Boolean getPaid() {
                        return paid;
                    }

                    /** 
                     * Set the 'paid' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_PDT

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_PDT
                     * 
                     * @param paid
                     */
                    public void setPaid(Boolean paid) {
                        this.paid = paid;
                    }

                    /** 
                     * Get the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @return value
                     */
                    public Boolean getExempt() {
                        return exempt;
                    }

                    /** 
                     * Set the 'exempt' attribute value. Ref:
                                                                                                  DM0Z_CA_TXN1
                                                                                                  #DM0Z_CA_ADC

                                                                                                  DM0Z_85_TXN1
                                                                                                  #DM0Z_85_ADC
                     * 
                     * @param exempt
                     */
                    public void setExempt(Boolean exempt) {
                        this.exempt = exempt;
                    }
                }
            }
            /** 
             * Commission at Farelevel
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount" minOccurs="0">
             *         &lt;!-- Reference to inner class Amount -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
             *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OtherCommission -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="source"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private Amount amount;
                private BigDecimal percentage;
                private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                private String source;
                private String type;

                /** 
                 * Get the 'Amount' element value.
                 * 
                 * @return value
                 */
                public Amount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value.
                 * 
                 * @param amount
                 */
                public void setAmount(Amount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Percentage' element value. Commision percentage
                 * 
                 * @return value
                 */
                public BigDecimal getPercentage() {
                    return percentage;
                }

                /** 
                 * Set the 'Percentage' element value. Commision percentage
                 * 
                 * @param percentage
                 */
                public void setPercentage(BigDecimal percentage) {
                    this.percentage = percentage;
                }

                /** 
                 * Get the list of 'OtherCommission' element items.
                 * 
                 * @return list
                 */
                public List<OtherCommission> getOtherCommissionList() {
                    return otherCommissionList;
                }

                /** 
                 * Set the list of 'OtherCommission' element items.
                 * 
                 * @param list
                 */
                public void setOtherCommissionList(List<OtherCommission> list) {
                    otherCommissionList = list;
                }

                /** 
                 * Get the 'source' attribute value. AGT - Agent-entered Commission
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'source' attribute value. AGT - Agent-entered Commission
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }

                /** 
                 * Get the 'type' attribute value. S - Special promo commission
                                                                                    N - Commission percent on NET
                                                                                    G - GRT commission
                                                                                    Ref:
                                                                                    DM0Z_85_COMI
                                                                                    DM0Z_86_COMI
                                                                                    #DM0Z_85_KPN
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. S - Special promo commission
                                                                                    N - Commission percent on NET
                                                                                    G - GRT commission
                                                                                    Ref:
                                                                                    DM0Z_85_COMI
                                                                                    DM0Z_86_COMI
                                                                                    #DM0Z_85_KPN
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Commision amount/penalty
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Amount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                 *         &lt;!-- Reference to inner class CommissionVerification -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="provider"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherCommission implements Serializable
                {
                    private Amount amount;
                    private CommissionVerification commissionVerification;
                    private String source;
                    private String provider;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CommissionVerification' element value.
                     * 
                     * @return value
                     */
                    public CommissionVerification getCommissionVerification() {
                        return commissionVerification;
                    }

                    /** 
                     * Set the 'CommissionVerification' element value.
                     * 
                     * @param commissionVerification
                     */
                    public void setCommissionVerification(
                            CommissionVerification commissionVerification) {
                        this.commissionVerification = commissionVerification;
                    }

                    /** 
                     * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                  AMC - Agency Managed commission

                                                                                                  Ref:
                                                                                                  DM0Z_C9_TYPE
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'provider' attribute value.
                     * 
                     * @return value
                     */
                    public String getProvider() {
                        return provider;
                    }

                    /** 
                     * Set the 'provider' attribute value.
                     * 
                     * @param provider
                     */
                    public void setProvider(String provider) {
                        this.provider = provider;
                    }
                    /** 
                     * Commision amount based on type
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="type"/>
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String type;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                        if source='C35', values can be: 'markup'
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                     *       &lt;xs:element name="Hierarchy" minOccurs="0">
                     *         &lt;!-- Reference to inner class Hierarchy -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="placement"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CommissionVerification implements
                        Serializable
                    {
                        private String controlQualifier;
                        private Hierarchy hierarchy;
                        private String verificationCode;
                        private String endorsement;
                        private String placement;

                        /** 
                         * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @return value
                         */
                        public String getControlQualifier() {
                            return controlQualifier;
                        }

                        /** 
                         * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CCQ_CCOQ
                         * 
                         * @param controlQualifier
                         */
                        public void setControlQualifier(String controlQualifier) {
                            this.controlQualifier = controlQualifier;
                        }

                        /** 
                         * Get the 'Hierarchy' element value.
                         * 
                         * @return value
                         */
                        public Hierarchy getHierarchy() {
                            return hierarchy;
                        }

                        /** 
                         * Set the 'Hierarchy' element value.
                         * 
                         * @param hierarchy
                         */
                        public void setHierarchy(Hierarchy hierarchy) {
                            this.hierarchy = hierarchy;
                        }

                        /** 
                         * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @return value
                         */
                        public String getVerificationCode() {
                            return verificationCode;
                        }

                        /** 
                         * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_TKI_CVC
                         * 
                         * @param verificationCode
                         */
                        public void setVerificationCode(String verificationCode) {
                            this.verificationCode = verificationCode;
                        }

                        /** 
                         * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @return value
                         */
                        public String getEndorsement() {
                            return endorsement;
                        }

                        /** 
                         * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                    Ref: DM0Z_C9_CVH_EDMG
                         * 
                         * @param endorsement
                         */
                        public void setEndorsement(String endorsement) {
                            this.endorsement = endorsement;
                        }

                        /** 
                         * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @return value
                         */
                        public String getPlacement() {
                            return placement;
                        }

                        /** 
                         * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                Ref: DMOZ_C9_TKI_CVP
                         * 
                         * @param placement
                         */
                        public void setPlacement(String placement) {
                            this.placement = placement;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                         *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Hierarchy implements Serializable
                        {
                            private BigInteger ticketDesignator;
                            private BigInteger tourNumber;
                            private BigInteger endorsement;

                            /** 
                             * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @return value
                             */
                            public BigInteger getTicketDesignator() {
                                return ticketDesignator;
                            }

                            /** 
                             * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TDH
                             * 
                             * @param ticketDesignator
                             */
                            public void setTicketDesignator(
                                    BigInteger ticketDesignator) {
                                this.ticketDesignator = ticketDesignator;
                            }

                            /** 
                             * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @return value
                             */
                            public BigInteger getTourNumber() {
                                return tourNumber;
                            }

                            /** 
                             * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_TCH
                             * 
                             * @param tourNumber
                             */
                            public void setTourNumber(BigInteger tourNumber) {
                                this.tourNumber = tourNumber;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @return value
                             */
                            public BigInteger getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDH
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(BigInteger endorsement) {
                                this.endorsement = endorsement;
                            }
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="code"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HandlingFee implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private boolean description;
                private String code;
                private String type;
                private Boolean hidden;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Check if the 'Description' element is present.
                 * 
                 * @return <code>true</code> if present, <code>false</code> if not
                 */
                public boolean ifDescriptionPresent() {
                    return description;
                }

                /** 
                 * Set flag for 'Description' element present.
                 * 
                 * @param description
                 */
                public void flagDescriptionPresent(boolean description) {
                    this.description = description;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                    Possible Values:
                                                                                    A - Base Fare hidden fee
                                                                                    B - Base fare  unhidden fee

                                                                                    Ref: DM0Z_CF_ITYP
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                    Possible Values:
                                                                                    A - Base Fare hidden fee
                                                                                    B - Base fare  unhidden fee

                                                                                    Ref: DM0Z_CF_ITYP
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                    Possible Values:
                                                                                    BSE - Base Fare
                                                                                    PTK =Ticket Fare
                                                                                    TTL = Total Fare
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                    Possible Values:
                                                                                    BSE - Base Fare
                                                                                    PTK =Ticket Fare
                                                                                    TTL = Total Fare
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                 * 
                 * @return value
                 */
                public Boolean getHidden() {
                    return hidden;
                }

                /** 
                 * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                 * 
                 * @param hidden
                 */
                public void setHidden(Boolean hidden) {
                    this.hidden = hidden;
                }
            }
            /** 
             * Optional services bundled with the fare
                                                                          Ref: DM0Z_E7_...
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalServiceInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:decimal">
             *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="quantity"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OptionalServiceInfo implements Serializable
            {
                private BigDecimal amountDecimal;
                private String amountCurrencyCode;
                private BigInteger amountDecimalPlace;
                private String description;
                private String type;
                private BigInteger quantity;
                private String code;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmountDecimal() {
                    return amountDecimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param amountDecimal
                 */
                public void setAmountDecimal(BigDecimal amountDecimal) {
                    this.amountDecimal = amountDecimal;
                }

                /** 
                 * Get the 'currencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value.
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }

                /** 
                 * Get the 'decimalPlace' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getAmountDecimalPlace() {
                    return amountDecimalPlace;
                }

                /** 
                 * Set the 'decimalPlace' attribute value.
                 * 
                 * @param amountDecimalPlace
                 */
                public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
                    this.amountDecimalPlace = amountDecimalPlace;
                }

                /** 
                 * Get the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E7_LCC_TXT
                 * 
                 * @return value
                 */
                public String getDescription() {
                    return description;
                }

                /** 
                 * Set the 'Description' element value. Description of a fee item

                                                                                        Ref: DM0Z_E7_LCC_TXT
                 * 
                 * @param description
                 */
                public void setDescription(String description) {
                    this.description = description;
                }

                /** 
                 * Get the 'type' attribute value. Code representing the type of optional service

                                                                                    Ref: DM0Z_E7_LCC_TYP
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Code representing the type of optional service

                                                                                    Ref: DM0Z_E7_LCC_TYP
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'quantity' attribute value. total quantity of the optional service or charge

                                                                                    Ref: DM0Z_E7_LCC_ITM
                 * 
                 * @return value
                 */
                public BigInteger getQuantity() {
                    return quantity;
                }

                /** 
                 * Set the 'quantity' attribute value. total quantity of the optional service or charge

                                                                                    Ref: DM0Z_E7_LCC_ITM
                 * 
                 * @param quantity
                 */
                public void setQuantity(BigInteger quantity) {
                    this.quantity = quantity;
                }

                /** 
                 * Get the 'code' attribute value. Code associated to optional service or charge.

                                                                                    For example:
                                                                                    BGAD
                                                                                    PRBD
                                                                                    SEAT
                                                                                    MEAL
                                                                                    JUMP...

                                                                                    Ref: DM0Z_E7_LCC_CHG
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'code' attribute value. Code associated to optional service or charge.

                                                                                    For example:
                                                                                    BGAD
                                                                                    PRBD
                                                                                    SEAT
                                                                                    MEAL
                                                                                    JUMP...

                                                                                    Ref: DM0Z_E7_LCC_CHG
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Additional Fares including OSL/Netfare/Published fares/Global NetRemit fares
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalFareInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OriginalSellingFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginalSellingFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PublishedFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class PublishedFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RetailerFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class RetailerFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetFareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class NetFareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetRemitInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class NetRemitInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AdditionalFareInfo implements Serializable
        {
            private OriginalSellingFareInfo originalSellingFareInfo;
            private PublishedFareInfo publishedFareInfo;
            private RetailerFareInfo retailerFareInfo;
            private NetFareInfo netFareInfo;
            private NetRemitInfo netRemitInfo;

            /** 
             * Get the 'OriginalSellingFareInfo' element value.
             * 
             * @return value
             */
            public OriginalSellingFareInfo getOriginalSellingFareInfo() {
                return originalSellingFareInfo;
            }

            /** 
             * Set the 'OriginalSellingFareInfo' element value.
             * 
             * @param originalSellingFareInfo
             */
            public void setOriginalSellingFareInfo(
                    OriginalSellingFareInfo originalSellingFareInfo) {
                this.originalSellingFareInfo = originalSellingFareInfo;
            }

            /** 
             * Get the 'PublishedFareInfo' element value.
             * 
             * @return value
             */
            public PublishedFareInfo getPublishedFareInfo() {
                return publishedFareInfo;
            }

            /** 
             * Set the 'PublishedFareInfo' element value.
             * 
             * @param publishedFareInfo
             */
            public void setPublishedFareInfo(PublishedFareInfo publishedFareInfo) {
                this.publishedFareInfo = publishedFareInfo;
            }

            /** 
             * Get the 'RetailerFareInfo' element value.
             * 
             * @return value
             */
            public RetailerFareInfo getRetailerFareInfo() {
                return retailerFareInfo;
            }

            /** 
             * Set the 'RetailerFareInfo' element value.
             * 
             * @param retailerFareInfo
             */
            public void setRetailerFareInfo(RetailerFareInfo retailerFareInfo) {
                this.retailerFareInfo = retailerFareInfo;
            }

            /** 
             * Get the 'NetFareInfo' element value.
             * 
             * @return value
             */
            public NetFareInfo getNetFareInfo() {
                return netFareInfo;
            }

            /** 
             * Set the 'NetFareInfo' element value.
             * 
             * @param netFareInfo
             */
            public void setNetFareInfo(NetFareInfo netFareInfo) {
                this.netFareInfo = netFareInfo;
            }

            /** 
             * Get the 'NetRemitInfo' element value.
             * 
             * @return value
             */
            public NetRemitInfo getNetRemitInfo() {
                return netRemitInfo;
            }

            /** 
             * Set the 'NetRemitInfo' element value.
             * 
             * @param netRemitInfo
             */
            public void setNetRemitInfo(NetRemitInfo netRemitInfo) {
                this.netRemitInfo = netRemitInfo;
            }
            /** 
             * Original selling fare is returned when the user is authorized to view it
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalSellingFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TaxInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="FareCalculation" minOccurs="0"/>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AdjustedAmount" minOccurs="0">
             *         &lt;!-- Reference to inner class AdjustedAmount -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HandlingFee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginalSellingFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private TaxInfo taxInfo;
                private String fareCalculation;
                private Commission commission;
                private AdjustedAmount adjustedAmount;
                private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public TaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(TaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @return value
                 */
                public String getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(String fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'AdjustedAmount' element value.
                 * 
                 * @return value
                 */
                public AdjustedAmount getAdjustedAmount() {
                    return adjustedAmount;
                }

                /** 
                 * Set the 'AdjustedAmount' element value.
                 * 
                 * @param adjustedAmount
                 */
                public void setAdjustedAmount(AdjustedAmount adjustedAmount) {
                    this.adjustedAmount = adjustedAmount;
                }

                /** 
                 * Get the list of 'HandlingFee' element items.
                 * 
                 * @return list
                 */
                public List<HandlingFee> getHandlingFeeList() {
                    return handlingFeeList;
                }

                /** 
                 * Set the list of 'HandlingFee' element items.
                 * 
                 * @param list
                 */
                public void setHandlingFeeList(List<HandlingFee> list) {
                    handlingFeeList = list;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *         &lt;!-- Reference to inner class CombinedTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxInfo implements Serializable
                {
                    private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'CombinedTax' element items.
                     * 
                     * @return list
                     */
                    public List<CombinedTax> getCombinedTaxList() {
                        return combinedTaxList;
                    }

                    /** 
                     * Set the list of 'CombinedTax' element items.
                     * 
                     * @param list
                     */
                    public void setCombinedTaxList(List<CombinedTax> list) {
                        combinedTaxList = list;
                    }

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Taxes combined and represented in tax boxes 1, 2, 3
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CombinedTax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                    /** 
                     * Includes tax breakdown
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                }
                /** 
                 * Holds commission associated to Orginal fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherCommission -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                    private String source;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the list of 'OtherCommission' element items.
                     * 
                     * @return list
                     */
                    public List<OtherCommission> getOtherCommissionList() {
                        return otherCommissionList;
                    }

                    /** 
                     * Set the list of 'OtherCommission' element items.
                     * 
                     * @param list
                     */
                    public void setOtherCommissionList(
                            List<OtherCommission> list) {
                        otherCommissionList = list;
                    }

                    /** 
                     * Get the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount" minOccurs="0">
                     *         &lt;!-- Reference to inner class Amount -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                     *         &lt;!-- Reference to inner class CommissionVerification -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="source"/>
                     *     &lt;xs:attribute type="xs:string" name="provider"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherCommission implements Serializable
                    {
                        private Amount amount;
                        private CommissionVerification commissionVerification;
                        private String source;
                        private String provider;

                        /** 
                         * Get the 'Amount' element value.
                         * 
                         * @return value
                         */
                        public Amount getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' element value.
                         * 
                         * @param amount
                         */
                        public void setAmount(Amount amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CommissionVerification' element value.
                         * 
                         * @return value
                         */
                        public CommissionVerification getCommissionVerification() {
                            return commissionVerification;
                        }

                        /** 
                         * Set the 'CommissionVerification' element value.
                         * 
                         * @param commissionVerification
                         */
                        public void setCommissionVerification(
                                CommissionVerification commissionVerification) {
                            this.commissionVerification = commissionVerification;
                        }

                        /** 
                         * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @return value
                         */
                        public String getSource() {
                            return source;
                        }

                        /** 
                         * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @param source
                         */
                        public void setSource(String source) {
                            this.source = source;
                        }

                        /** 
                         * Get the 'provider' attribute value.
                         * 
                         * @return value
                         */
                        public String getProvider() {
                            return provider;
                        }

                        /** 
                         * Set the 'provider' attribute value.
                         * 
                         * @param provider
                         */
                        public void setProvider(String provider) {
                            this.provider = provider;
                        }
                        /** 
                         * Commision amount based on type
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:decimal">
                         *         &lt;xs:attribute type="xs:string" name="type"/>
                         *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                         *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Amount implements Serializable
                        {
                            private BigDecimal decimal;
                            private String type;
                            private String currencyCode;
                            private BigInteger decimalPlace;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public BigDecimal getDecimal() {
                                return decimal;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param decimal
                             */
                            public void setDecimal(BigDecimal decimal) {
                                this.decimal = decimal;
                            }

                            /** 
                             * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'currencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'currencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'decimalPlace' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getDecimalPlace() {
                                return decimalPlace;
                            }

                            /** 
                             * Set the 'decimalPlace' attribute value.
                             * 
                             * @param decimalPlace
                             */
                            public void setDecimalPlace(BigInteger decimalPlace) {
                                this.decimalPlace = decimalPlace;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                         *       &lt;xs:element name="Hierarchy" minOccurs="0">
                         *         &lt;!-- Reference to inner class Hierarchy -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="placement"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CommissionVerification implements
                            Serializable
                        {
                            private String controlQualifier;
                            private Hierarchy hierarchy;
                            private String verificationCode;
                            private String endorsement;
                            private String placement;

                            /** 
                             * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @return value
                             */
                            public String getControlQualifier() {
                                return controlQualifier;
                            }

                            /** 
                             * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @param controlQualifier
                             */
                            public void setControlQualifier(
                                    String controlQualifier) {
                                this.controlQualifier = controlQualifier;
                            }

                            /** 
                             * Get the 'Hierarchy' element value.
                             * 
                             * @return value
                             */
                            public Hierarchy getHierarchy() {
                                return hierarchy;
                            }

                            /** 
                             * Set the 'Hierarchy' element value.
                             * 
                             * @param hierarchy
                             */
                            public void setHierarchy(Hierarchy hierarchy) {
                                this.hierarchy = hierarchy;
                            }

                            /** 
                             * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @return value
                             */
                            public String getVerificationCode() {
                                return verificationCode;
                            }

                            /** 
                             * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @param verificationCode
                             */
                            public void setVerificationCode(
                                    String verificationCode) {
                                this.verificationCode = verificationCode;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @return value
                             */
                            public String getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(String endorsement) {
                                this.endorsement = endorsement;
                            }

                            /** 
                             * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @return value
                             */
                            public String getPlacement() {
                                return placement;
                            }

                            /** 
                             * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @param placement
                             */
                            public void setPlacement(String placement) {
                                this.placement = placement;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Hierarchy implements
                                Serializable
                            {
                                private BigInteger ticketDesignator;
                                private BigInteger tourNumber;
                                private BigInteger endorsement;

                                /** 
                                 * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTicketDesignator() {
                                    return ticketDesignator;
                                }

                                /** 
                                 * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @param ticketDesignator
                                 */
                                public void setTicketDesignator(
                                        BigInteger ticketDesignator) {
                                    this.ticketDesignator = ticketDesignator;
                                }

                                /** 
                                 * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTourNumber() {
                                    return tourNumber;
                                }

                                /** 
                                 * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @param tourNumber
                                 */
                                public void setTourNumber(BigInteger tourNumber) {
                                    this.tourNumber = tourNumber;
                                }

                                /** 
                                 * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getEndorsement() {
                                    return endorsement;
                                }

                                /** 
                                 * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @param endorsement
                                 */
                                public void setEndorsement(
                                        BigInteger endorsement) {
                                    this.endorsement = endorsement;
                                }
                            }
                        }
                    }
                }
                /** 
                 * The amount by which the original selling fare was adjusted
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdjustedAmount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AdjustedAmount implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount">
                 *         &lt;xs:complexType>
                 *           &lt;xs:simpleContent>
                 *             &lt;xs:extension base="xs:decimal">
                 *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:simpleContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:anyType" name="Description" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="code"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *     &lt;xs:attribute type="xs:boolean" name="hidden"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HandlingFee implements Serializable
                {
                    private BigDecimal amountDecimal;
                    private String amountCurrencyCode;
                    private BigInteger amountDecimalPlace;
                    private boolean description;
                    private String code;
                    private String type;
                    private Boolean hidden;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmountDecimal() {
                        return amountDecimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param amountDecimal
                     */
                    public void setAmountDecimal(BigDecimal amountDecimal) {
                        this.amountDecimal = amountDecimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmountCurrencyCode() {
                        return amountCurrencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param amountCurrencyCode
                     */
                    public void setAmountCurrencyCode(String amountCurrencyCode) {
                        this.amountCurrencyCode = amountCurrencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getAmountDecimalPlace() {
                        return amountDecimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param amountDecimalPlace
                     */
                    public void setAmountDecimalPlace(
                            BigInteger amountDecimalPlace) {
                        this.amountDecimalPlace = amountDecimalPlace;
                    }

                    /** 
                     * Check if the 'Description' element is present.
                     * 
                     * @return <code>true</code> if present, <code>false</code> if not
                     */
                    public boolean ifDescriptionPresent() {
                        return description;
                    }

                    /** 
                     * Set flag for 'Description' element present.
                     * 
                     * @param description
                     */
                    public void flagDescriptionPresent(boolean description) {
                        this.description = description;
                    }

                    /** 
                     * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

                                                                                                  Possible Values:
                                                                                                  A - Base Fare hidden fee
                                                                                                  B - Base fare  unhidden fee

                                                                                                  Ref: DM0Z_CF_ITYP
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. Handling fee type based on the applicable fare
                                                                                                  Possible Values:
                                                                                                  BSE - Base Fare
                                                                                                  PTK =Ticket Fare
                                                                                                  TTL = Total Fare
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @return value
                     */
                    public Boolean getHidden() {
                        return hidden;
                    }

                    /** 
                     * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
                     * 
                     * @param hidden
                     */
                    public void setHidden(Boolean hidden) {
                        this.hidden = hidden;
                    }
                }
            }
            /** 
             * Equivalent to *PQP

                                                                          Ref: DM0Z_85_PUB 'x 01
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PublishedFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TaxInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="FareCalculation" minOccurs="0"/>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PublishedFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private TaxInfo taxInfo;
                private String fareCalculation;
                private Commission commission;

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public TaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(TaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @return value
                 */
                public String getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value. FareCalc line free Text

                                                                                        Ref: DM0Z_A5_DATA
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(String fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }
                /** 
                 * Base fare per PQ type
                                                                                        Ref: DM0Z_85_BFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Equivalent Fare per PQ type
                                                                                        Ref: DM0Z_85_EFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivalentFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Tax Total per PQ type
                                                                                        Ref: DM0Z_85_TTAC
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Total fare inclusive of taxes per PQ type
                                                                                        Ref: DM0Z_85_TFAR
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:decimal">
                 *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                 *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalFare implements Serializable
                {
                    private BigDecimal decimal;
                    private String currencyCode;
                    private BigInteger decimalPlace;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public BigDecimal getDecimal() {
                        return decimal;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param decimal
                     */
                    public void setDecimal(BigDecimal decimal) {
                        this.decimal = decimal;
                    }

                    /** 
                     * Get the 'currencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'currencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'decimalPlace' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getDecimalPlace() {
                        return decimalPlace;
                    }

                    /** 
                     * Set the 'decimalPlace' attribute value.
                     * 
                     * @param decimalPlace
                     */
                    public void setDecimalPlace(BigInteger decimalPlace) {
                        this.decimalPlace = decimalPlace;
                    }
                }
                /** 
                 * Includes combinedTax and Tax breakdown.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
                 *         &lt;!-- Reference to inner class CombinedTax -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxInfo implements Serializable
                {
                    private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'CombinedTax' element items.
                     * 
                     * @return list
                     */
                    public List<CombinedTax> getCombinedTaxList() {
                        return combinedTaxList;
                    }

                    /** 
                     * Set the list of 'CombinedTax' element items.
                     * 
                     * @param list
                     */
                    public void setCombinedTaxList(List<CombinedTax> list) {
                        combinedTaxList = list;
                    }

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Taxes combined and represented in tax boxes 1, 2, 3
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CombinedTax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                    /** 
                     * Includes tax breakdown
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:decimal">
                     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
                     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
                     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private BigDecimal amountDecimal;
                        private String amountCurrencyCode;
                        private BigInteger amountDecimalPlace;
                        private String code;
                        private Boolean paid;
                        private Boolean exempt;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountDecimal() {
                            return amountDecimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param amountDecimal
                         */
                        public void setAmountDecimal(BigDecimal amountDecimal) {
                            this.amountDecimal = amountDecimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmountCurrencyCode() {
                            return amountCurrencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param amountCurrencyCode
                         */
                        public void setAmountCurrencyCode(
                                String amountCurrencyCode) {
                            this.amountCurrencyCode = amountCurrencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getAmountDecimalPlace() {
                            return amountDecimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param amountDecimalPlace
                         */
                        public void setAmountDecimalPlace(
                                BigInteger amountDecimalPlace) {
                            this.amountDecimalPlace = amountDecimalPlace;
                        }

                        /** 
                         * Get the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'code' attribute value. Tax box identifier

                                                                                                                Ref: DM0Z_CA_TID1
                                                                                                                DM0Z_CA_TID2
                                                                                                                DM0Z_CA_TID3

                                                                                                                DM0Z_85_TID1
                                                                                                                DM0Z_85_TID2
                                                                                                                DM0Z_85_TID3
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @return value
                         */
                        public Boolean getPaid() {
                            return paid;
                        }

                        /** 
                         * Set the 'paid' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_PDT

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_PDT
                         * 
                         * @param paid
                         */
                        public void setPaid(Boolean paid) {
                            this.paid = paid;
                        }

                        /** 
                         * Get the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @return value
                         */
                        public Boolean getExempt() {
                            return exempt;
                        }

                        /** 
                         * Set the 'exempt' attribute value. Ref:
                                                                                                                DM0Z_CA_TXN1
                                                                                                                #DM0Z_CA_ADC

                                                                                                                DM0Z_85_TXN1
                                                                                                                #DM0Z_85_ADC
                         * 
                         * @param exempt
                         */
                        public void setExempt(Boolean exempt) {
                            this.exempt = exempt;
                        }
                    }
                }
                /** 
                 * Holds commission associated to published fare
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amount" minOccurs="0">
                 *         &lt;!-- Reference to inner class Amount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
                 *       &lt;xs:element name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class OtherCommission -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="source"/>
                 *     &lt;xs:attribute type="xs:string" name="type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private Amount amount;
                    private BigDecimal percentage;
                    private List<OtherCommission> otherCommissionList = new ArrayList<OtherCommission>();
                    private String source;
                    private String type;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public Amount getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(Amount amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percentage' element value. Commision percentage
                     * 
                     * @return value
                     */
                    public BigDecimal getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' element value. Commision percentage
                     * 
                     * @param percentage
                     */
                    public void setPercentage(BigDecimal percentage) {
                        this.percentage = percentage;
                    }

                    /** 
                     * Get the list of 'OtherCommission' element items.
                     * 
                     * @return list
                     */
                    public List<OtherCommission> getOtherCommissionList() {
                        return otherCommissionList;
                    }

                    /** 
                     * Set the list of 'OtherCommission' element items.
                     * 
                     * @param list
                     */
                    public void setOtherCommissionList(
                            List<OtherCommission> list) {
                        otherCommissionList = list;
                    }

                    /** 
                     * Get the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'source' attribute value. AGT - Agent-entered Commission
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }

                    /** 
                     * Get the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. S - Special promo commission
                                                                                                  N - Commission percent on NET
                                                                                                  G - GRT commission
                                                                                                  Ref:
                                                                                                  DM0Z_85_COMI
                                                                                                  DM0Z_86_COMI
                                                                                                  #DM0Z_85_KPN
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Commision amount/penalty
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:decimal">
                     *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                     *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amount implements Serializable
                    {
                        private BigDecimal decimal;
                        private String currencyCode;
                        private BigInteger decimalPlace;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public BigDecimal getDecimal() {
                            return decimal;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param decimal
                         */
                        public void setDecimal(BigDecimal decimal) {
                            this.decimal = decimal;
                        }

                        /** 
                         * Get the 'currencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'currencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'decimalPlace' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getDecimalPlace() {
                            return decimalPlace;
                        }

                        /** 
                         * Set the 'decimalPlace' attribute value.
                         * 
                         * @param decimalPlace
                         */
                        public void setDecimalPlace(BigInteger decimalPlace) {
                            this.decimalPlace = decimalPlace;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherCommission" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Amount" minOccurs="0">
                     *         &lt;!-- Reference to inner class Amount -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CommissionVerification" minOccurs="0">
                     *         &lt;!-- Reference to inner class CommissionVerification -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="source"/>
                     *     &lt;xs:attribute type="xs:string" name="provider"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OtherCommission implements Serializable
                    {
                        private Amount amount;
                        private CommissionVerification commissionVerification;
                        private String source;
                        private String provider;

                        /** 
                         * Get the 'Amount' element value.
                         * 
                         * @return value
                         */
                        public Amount getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' element value.
                         * 
                         * @param amount
                         */
                        public void setAmount(Amount amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CommissionVerification' element value.
                         * 
                         * @return value
                         */
                        public CommissionVerification getCommissionVerification() {
                            return commissionVerification;
                        }

                        /** 
                         * Set the 'CommissionVerification' element value.
                         * 
                         * @param commissionVerification
                         */
                        public void setCommissionVerification(
                                CommissionVerification commissionVerification) {
                            this.commissionVerification = commissionVerification;
                        }

                        /** 
                         * Get the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @return value
                         */
                        public String getSource() {
                            return source;
                        }

                        /** 
                         * Set the 'source' attribute value. C35 - Category 35 Net commission
                                                                                                                AMC - Agency Managed commission

                                                                                                                Ref:
                                                                                                                DM0Z_C9_TYPE
                         * 
                         * @param source
                         */
                        public void setSource(String source) {
                            this.source = source;
                        }

                        /** 
                         * Get the 'provider' attribute value.
                         * 
                         * @return value
                         */
                        public String getProvider() {
                            return provider;
                        }

                        /** 
                         * Set the 'provider' attribute value.
                         * 
                         * @param provider
                         */
                        public void setProvider(String provider) {
                            this.provider = provider;
                        }
                        /** 
                         * Commision amount based on type
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:decimal">
                         *         &lt;xs:attribute type="xs:string" name="type"/>
                         *         &lt;xs:attribute type="xs:string" name="currencyCode"/>
                         *         &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Amount implements Serializable
                        {
                            private BigDecimal decimal;
                            private String type;
                            private String currencyCode;
                            private BigInteger decimalPlace;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public BigDecimal getDecimal() {
                                return decimal;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param decimal
                             */
                            public void setDecimal(BigDecimal decimal) {
                                this.decimal = decimal;
                            }

                            /** 
                             * Get the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'type' attribute value. if source='AMC', values can be any of the following: 'agencyManaged', 'earned'
                                                                                                                                      if source='C35', values can be: 'markup'
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'currencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'currencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'decimalPlace' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getDecimalPlace() {
                                return decimalPlace;
                            }

                            /** 
                             * Set the 'decimalPlace' attribute value.
                             * 
                             * @param decimalPlace
                             */
                            public void setDecimalPlace(BigInteger decimalPlace) {
                                this.decimalPlace = decimalPlace;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
                         *       &lt;xs:element name="Hierarchy" minOccurs="0">
                         *         &lt;!-- Reference to inner class Hierarchy -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="placement"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CommissionVerification implements
                            Serializable
                        {
                            private String controlQualifier;
                            private Hierarchy hierarchy;
                            private String verificationCode;
                            private String endorsement;
                            private String placement;

                            /** 
                             * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @return value
                             */
                            public String getControlQualifier() {
                                return controlQualifier;
                            }

                            /** 
                             * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CCQ_CCOQ
                             * 
                             * @param controlQualifier
                             */
                            public void setControlQualifier(
                                    String controlQualifier) {
                                this.controlQualifier = controlQualifier;
                            }

                            /** 
                             * Get the 'Hierarchy' element value.
                             * 
                             * @return value
                             */
                            public Hierarchy getHierarchy() {
                                return hierarchy;
                            }

                            /** 
                             * Set the 'Hierarchy' element value.
                             * 
                             * @param hierarchy
                             */
                            public void setHierarchy(Hierarchy hierarchy) {
                                this.hierarchy = hierarchy;
                            }

                            /** 
                             * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @return value
                             */
                            public String getVerificationCode() {
                                return verificationCode;
                            }

                            /** 
                             * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_TKI_CVC
                             * 
                             * @param verificationCode
                             */
                            public void setVerificationCode(
                                    String verificationCode) {
                                this.verificationCode = verificationCode;
                            }

                            /** 
                             * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @return value
                             */
                            public String getEndorsement() {
                                return endorsement;
                            }

                            /** 
                             * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

                                                                                                                                  Ref: DM0Z_C9_CVH_EDMG
                             * 
                             * @param endorsement
                             */
                            public void setEndorsement(String endorsement) {
                                this.endorsement = endorsement;
                            }

                            /** 
                             * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @return value
                             */
                            public String getPlacement() {
                                return placement;
                            }

                            /** 
                             * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

                                                                                                                              Ref: DMOZ_C9_TKI_CVP
                             * 
                             * @param placement
                             */
                            public void setPlacement(String placement) {
                                this.placement = placement;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hierarchy" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
                             *       &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Hierarchy implements
                                Serializable
                            {
                                private BigInteger ticketDesignator;
                                private BigInteger tourNumber;
                                private BigInteger endorsement;

                                /** 
                                 * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTicketDesignator() {
                                    return ticketDesignator;
                                }

                                /** 
                                 * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TDH
                                 * 
                                 * @param ticketDesignator
                                 */
                                public void setTicketDesignator(
                                        BigInteger ticketDesignator) {
                                    this.ticketDesignator = ticketDesignator;
                                }

                                /** 
                                 * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getTourNumber() {
                                    return tourNumber;
                                }

                                /** 
                                 * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_TCH
                                 * 
                                 * @param tourNumber
                                 */
                                public void setTourNumber(BigInteger tourNumber) {
                                    this.tourNumber = tourNumber;
                                }

                                /** 
                                 * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @return value
                                 */
                                public BigInteger getEndorsement() {
                                    return endorsement;
                                }

                                /** 
                                 * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

                                                                                                                                                Ref: DM0Z_C9_CVH_EDH
                                 * 
                                 * @param endorsement
                                 */
                                public void setEndorsement(
                                        BigInteger endorsement) {
                                    this.endorsement = endorsement;
                                }
                            }
                        }
                    }
                }
            }
            /** 
             * Maps to *PQ#R
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerFareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivalentFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivalentFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TaxInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HandlingFee" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HandlingFee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RetailerFareInfo implements Serializable
            {
                private BaseFare baseFare;
                private EquivalentFare equivalentFare;
                private TotalTax totalTax;
                private TotalFare totalFare;
                private Commission commission;
                private TaxInfo taxInfo;
                private List<HandlingFee> handlingFeeList = new ArrayList<HandlingFee>();

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivalentFare' element value.
                 * 
                 * @return value
                 */
                public EquivalentFare getEquivalentFare() {
                    return equivalentFare;
                }

                /** 
                 * Set the 'EquivalentFare' element value.
                 * 
                 * @param equivalentFare
                 */
                public void setEquivalentFare(EquivalentFare equivalentFare) {
                    this.equivalentFare = equivalentFare;
                }

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalFare' element value.
                 * 
                 * @return value
                 */
                public TotalFare getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value.
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(TotalFare totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'TaxInfo' element value.
                 * 
                 * @return value
                 */
                public TaxInfo getTaxInfo() {
                    return taxInfo;
                }

                /** 
                 * Set the 'TaxInfo' element value.
                 * 
                 * @param taxInfo
                 */
                public void setTaxInfo(TaxInfo taxInfo) {
                    this.taxInfo = taxInfo;
                }

                /** 
                 * Get the list of 'HandlingFee' element items.
                 * 
                 * @return list
                 */
                public List<HandlingFee> getHandlingFeeList() {
                    return handlingFeeList;
                }

                /** 
                 * Set the list of 'HandlingFee' element items.
                 * 
                 * @param list
                 */
                public void setHandlingFeeList(List<HandlingFee> list) {
                    handlingFeeList = list;
                }
                /** 
                 * Base fare per PQ type
                                                             