
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * It can be used to indicate whether the fare is public or private.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestPricingSourceType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Published"/>
 *     &lt;xs:enumeration value="Private"/>
 *     &lt;xs:enumeration value="Both"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RequestPricingSourceType implements Serializable {
    PUBLISHED("Published"), PRIVATE("Private"), BOTH("Both");
    private final String value;

    private RequestPricingSourceType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RequestPricingSourceType convert(String value) {
        for (RequestPricingSourceType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
