
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingTransaction">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element type="xs:string" name="Status"/>
 *     &lt;xs:element type="xs:dateTime" name="Date"/>
 *     &lt;xs:element type="xs:string" name="OriginatingLocator" minOccurs="0"/>
 *     &lt;xs:element type="ns:POSType" name="POS" minOccurs="0"/>
 *     &lt;xs:element type="ns:AccountingTransactionItem" name="Item" maxOccurs="unbounded"/>
 *     &lt;xs:element name="Payment" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Payment -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AccountingTransaction implements Serializable
{
    private String type;
    private String status;
    private Date date;
    private String originatingLocator;
    private POSType POS;
    private List<AccountingTransactionItem> itemList = new ArrayList<AccountingTransactionItem>();
    private List<Payment> paymentList = new ArrayList<Payment>();

    /** 
     * Get the 'Type' element value.
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Status' element value.
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value.
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'Date' element value.
     * 
     * @return value
     */
    public Date getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value.
     * 
     * @param date
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /** 
     * Get the 'OriginatingLocator' element value.
     * 
     * @return value
     */
    public String getOriginatingLocator() {
        return originatingLocator;
    }

    /** 
     * Set the 'OriginatingLocator' element value.
     * 
     * @param originatingLocator
     */
    public void setOriginatingLocator(String originatingLocator) {
        this.originatingLocator = originatingLocator;
    }

    /** 
     * Get the 'POS' element value.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the list of 'Item' element items.
     * 
     * @return list
     */
    public List<AccountingTransactionItem> getItemList() {
        return itemList;
    }

    /** 
     * Set the list of 'Item' element items.
     * 
     * @param list
     */
    public void setItemList(List<AccountingTransactionItem> list) {
        itemList = list;
    }

    /** 
     * Get the list of 'Payment' element items.
     * 
     * @return list
     */
    public List<Payment> getPaymentList() {
        return paymentList;
    }

    /** 
     * Set the list of 'Payment' element items.
     * 
     * @param list
     */
    public void setPaymentList(List<Payment> list) {
        paymentList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TransactionId" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="SupplierId" minOccurs="0"/>
     *       &lt;xs:element type="ns:AccountingTransactionAmount" name="ApprovalAmount" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="ApprovalCode" minOccurs="0"/>
     *       &lt;xs:element type="ns:FormOfPayment" name="FormOfPayment"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payment implements Serializable
    {
        private String transactionId;
        private String supplierId;
        private AccountingTransactionAmount approvalAmount;
        private String approvalCode;
        private FormOfPayment formOfPayment;

        /** 
         * Get the 'TransactionId' element value.
         * 
         * @return value
         */
        public String getTransactionId() {
            return transactionId;
        }

        /** 
         * Set the 'TransactionId' element value.
         * 
         * @param transactionId
         */
        public void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        /** 
         * Get the 'SupplierId' element value.
         * 
         * @return value
         */
        public String getSupplierId() {
            return supplierId;
        }

        /** 
         * Set the 'SupplierId' element value.
         * 
         * @param supplierId
         */
        public void setSupplierId(String supplierId) {
            this.supplierId = supplierId;
        }

        /** 
         * Get the 'ApprovalAmount' element value.
         * 
         * @return value
         */
        public AccountingTransactionAmount getApprovalAmount() {
            return approvalAmount;
        }

        /** 
         * Set the 'ApprovalAmount' element value.
         * 
         * @param approvalAmount
         */
        public void setApprovalAmount(AccountingTransactionAmount approvalAmount) {
            this.approvalAmount = approvalAmount;
        }

        /** 
         * Get the 'ApprovalCode' element value.
         * 
         * @return value
         */
        public String getApprovalCode() {
            return approvalCode;
        }

        /** 
         * Set the 'ApprovalCode' element value.
         * 
         * @param approvalCode
         */
        public void setApprovalCode(String approvalCode) {
            this.approvalCode = approvalCode;
        }

        /** 
         * Get the 'FormOfPayment' element value.
         * 
         * @return value
         */
        public FormOfPayment getFormOfPayment() {
            return formOfPayment;
        }

        /** 
         * Set the 'FormOfPayment' element value.
         * 
         * @param formOfPayment
         */
        public void setFormOfPayment(FormOfPayment formOfPayment) {
            this.formOfPayment = formOfPayment;
        }
    }
}
