
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DepartureAirport" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartureAirportCodeContext" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartureTerminalName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartureTerminalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalAirport" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalAirportCodeContext" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalTerminalName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalTerminalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingAirlineCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingAirlineShortName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EquipmentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingAirlineCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CodeShareOperatingRecordLocator" minOccurs="0"/>
 *     &lt;xs:element name="MarriageGrp" minOccurs="0">
 *       &lt;!-- Reference to inner class MarriageGrp -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CabinType" name="Cabin" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MealCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:boolean" name="SmokingAllowed" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="StopQuantity" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ElapsedTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="AirMilesFlown" minOccurs="0"/>
 *     &lt;xs:element name="HiddenStop" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class HiddenStop -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="FunnelFlight" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ChangeOfGauge" minOccurs="0"/>
 *     &lt;xs:element name="DisclosureCarrier" minOccurs="0">
 *       &lt;!-- Reference to inner class DisclosureCarrier -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="AirlineRefId" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Eticket" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ArrivalDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="inboundConnection" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="outboundConnection" minOccurs="0"/>
 *     &lt;xs:element name="AncillaryServices" minOccurs="0">
 *       &lt;!-- Reference to inner class AncillaryServices -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="BSGIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BSGPNRRecordLocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="BSGPNRCreatedDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PassiveSegmentIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ScheduleChangeIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="SegmentBookedDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UpdatedDepartureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UpdatedDepartureTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UpdatedArrivalTime" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirPosType" name="Pos" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OALocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DirectConnectDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="InstantPurchase" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BrandID" minOccurs="0"/>
 *     &lt;xs:element type="ns:FareComponentWithId" name="FareComponent" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="xs:short" name="sequence"/>
 *   &lt;xs:attribute type="xs:short" name="segmentAssociationId"/>
 *   &lt;xs:attribute type="xs:boolean" name="isPast"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirType implements Serializable
{
    private String departureAirport;
    private String departureAirportCodeContext;
    private String departureTerminalName;
    private String departureTerminalCode;
    private String arrivalAirport;
    private String arrivalAirportCodeContext;
    private String arrivalTerminalName;
    private String arrivalTerminalCode;
    private String operatingAirlineCode;
    private String operatingAirlineShortName;
    private String operatingFlightNumber;
    private String equipmentType;
    private String marketingAirlineCode;
    private String marketingFlightNumber;
    private String operatingClassOfService;
    private String marketingClassOfService;
    private String codeShareOperatingRecordLocator;
    private MarriageGrp marriageGrp;
    private CabinType cabin;
    private List<String> mealCodeList = new ArrayList<String>();
    private Boolean smokingAllowed;
    private Integer stopQuantity;
    private Integer elapsedTime;
    private Integer airMilesFlown;
    private List<HiddenStop> hiddenStopList = new ArrayList<HiddenStop>();
    private Boolean funnelFlight;
    private Boolean changeOfGauge;
    private DisclosureCarrier disclosureCarrier;
    private String airlineRefId;
    private Boolean eticket;
    private Date departureDateTime;
    private Date arrivalDateTime;
    private String flightNumber;
    private String classOfService;
    private String actionCode;
    private BigInteger numberInParty;
    private Boolean inboundConnection;
    private Boolean outboundConnection;
    private AncillaryServices ancillaryServices;
    private Boolean BSGIndicator;
    private String BSGPNRRecordLocator;
    private Date BSGPNRCreatedDate;
    private Boolean passiveSegmentIndicator;
    private Boolean scheduleChangeIndicator;
    private Date segmentBookedDate;
    private String updatedDepartureDate;
    private String updatedDepartureTime;
    private String updatedArrivalTime;
    private AirPosType pos;
    private String OALocator;
    private Date directConnectDate;
    private Boolean instantPurchase;
    private String brandID;
    private List<FareComponentWithId> fareComponentList = new ArrayList<FareComponentWithId>();
    private BigInteger index;
    private Short sequence;
    private Short segmentAssociationId;
    private Boolean isPast;

    /** 
     * Get the 'DepartureAirport' element value. Departure point of flight segment.
     * 
     * @return value
     */
    public String getDepartureAirport() {
        return departureAirport;
    }

    /** 
     * Set the 'DepartureAirport' element value. Departure point of flight segment.
     * 
     * @param departureAirport
     */
    public void setDepartureAirport(String departureAirport) {
        this.departureAirport = departureAirport;
    }

    /** 
     * Get the 'DepartureAirportCodeContext' element value. Indicates which international standard of coding is used to describe departure airport. IATA. Ex."IATA".
     * 
     * @return value
     */
    public String getDepartureAirportCodeContext() {
        return departureAirportCodeContext;
    }

    /** 
     * Set the 'DepartureAirportCodeContext' element value. Indicates which international standard of coding is used to describe departure airport. IATA. Ex."IATA".
     * 
     * @param departureAirportCodeContext
     */
    public void setDepartureAirportCodeContext(
            String departureAirportCodeContext) {
        this.departureAirportCodeContext = departureAirportCodeContext;
    }

    /** 
     * Get the 'DepartureTerminalName' element value. Indicates terminal name of flight segment's departure airport.
     * 
     * @return value
     */
    public String getDepartureTerminalName() {
        return departureTerminalName;
    }

    /** 
     * Set the 'DepartureTerminalName' element value. Indicates terminal name of flight segment's departure airport.
     * 
     * @param departureTerminalName
     */
    public void setDepartureTerminalName(String departureTerminalName) {
        this.departureTerminalName = departureTerminalName;
    }

    /** 
     * Get the 'DepartureTerminalCode' element value. Indicates the gate number of flight segment's departure airport terminal.
     * 
     * @return value
     */
    public String getDepartureTerminalCode() {
        return departureTerminalCode;
    }

    /** 
     * Set the 'DepartureTerminalCode' element value. Indicates the gate number of flight segment's departure airport terminal.
     * 
     * @param departureTerminalCode
     */
    public void setDepartureTerminalCode(String departureTerminalCode) {
        this.departureTerminalCode = departureTerminalCode;
    }

    /** 
     * Get the 'ArrivalAirport' element value. Arrival point of flight segment.
     * 
     * @return value
     */
    public String getArrivalAirport() {
        return arrivalAirport;
    }

    /** 
     * Set the 'ArrivalAirport' element value. Arrival point of flight segment.
     * 
     * @param arrivalAirport
     */
    public void setArrivalAirport(String arrivalAirport) {
        this.arrivalAirport = arrivalAirport;
    }

    /** 
     * Get the 'ArrivalAirportCodeContext' element value. Indicates which international standard of coding is used to describe arrival airport. IATA. Ex."IATA".
     * 
     * @return value
     */
    public String getArrivalAirportCodeContext() {
        return arrivalAirportCodeContext;
    }

    /** 
     * Set the 'ArrivalAirportCodeContext' element value. Indicates which international standard of coding is used to describe arrival airport. IATA. Ex."IATA".
     * 
     * @param arrivalAirportCodeContext
     */
    public void setArrivalAirportCodeContext(String arrivalAirportCodeContext) {
        this.arrivalAirportCodeContext = arrivalAirportCodeContext;
    }

    /** 
     * Get the 'ArrivalTerminalName' element value. Indicates terminal name of flight segment's arrival airport.
     * 
     * @return value
     */
    public String getArrivalTerminalName() {
        return arrivalTerminalName;
    }

    /** 
     * Set the 'ArrivalTerminalName' element value. Indicates terminal name of flight segment's arrival airport.
     * 
     * @param arrivalTerminalName
     */
    public void setArrivalTerminalName(String arrivalTerminalName) {
        this.arrivalTerminalName = arrivalTerminalName;
    }

    /** 
     * Get the 'ArrivalTerminalCode' element value. Indicates the gate number of flight segment's arrival airport terminal.
     * 
     * @return value
     */
    public String getArrivalTerminalCode() {
        return arrivalTerminalCode;
    }

    /** 
     * Set the 'ArrivalTerminalCode' element value. Indicates the gate number of flight segment's arrival airport terminal.
     * 
     * @param arrivalTerminalCode
     */
    public void setArrivalTerminalCode(String arrivalTerminalCode) {
        this.arrivalTerminalCode = arrivalTerminalCode;
    }

    /** 
     * Get the 'OperatingAirlineCode' element value. Indicates carrier operating the flight in the context of codeshare.
     * 
     * @return value
     */
    public String getOperatingAirlineCode() {
        return operatingAirlineCode;
    }

    /** 
     * Set the 'OperatingAirlineCode' element value. Indicates carrier operating the flight in the context of codeshare.
     * 
     * @param operatingAirlineCode
     */
    public void setOperatingAirlineCode(String operatingAirlineCode) {
        this.operatingAirlineCode = operatingAirlineCode;
    }

    /** 
     * Get the 'OperatingAirlineShortName' element value. Indicates operating carrier's short name.
     * 
     * @return value
     */
    public String getOperatingAirlineShortName() {
        return operatingAirlineShortName;
    }

    /** 
     * Set the 'OperatingAirlineShortName' element value. Indicates operating carrier's short name.
     * 
     * @param operatingAirlineShortName
     */
    public void setOperatingAirlineShortName(String operatingAirlineShortName) {
        this.operatingAirlineShortName = operatingAirlineShortName;
    }

    /** 
     * Get the 'OperatingFlightNumber' element value. The operating carrier flight in the context of codeshare.
     * 
     * @return value
     */
    public String getOperatingFlightNumber() {
        return operatingFlightNumber;
    }

    /** 
     * Set the 'OperatingFlightNumber' element value. The operating carrier flight in the context of codeshare.
     * 
     * @param operatingFlightNumber
     */
    public void setOperatingFlightNumber(String operatingFlightNumber) {
        this.operatingFlightNumber = operatingFlightNumber;
    }

    /** 
     * Get the 'EquipmentType' element value. Aircraft type used for the flight as per IATA standard. Example "73H".
     * 
     * @return value
     */
    public String getEquipmentType() {
        return equipmentType;
    }

    /** 
     * Set the 'EquipmentType' element value. Aircraft type used for the flight as per IATA standard. Example "73H".
     * 
     * @param equipmentType
     */
    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    /** 
     * Get the 'MarketingAirlineCode' element value. Indicates carrier who marketed the flight in the context of codeshare. In case of codeshare "MarketingAirlineCode" may be different than "OperatingAirlineCode."
     * 
     * @return value
     */
    public String getMarketingAirlineCode() {
        return marketingAirlineCode;
    }

    /** 
     * Set the 'MarketingAirlineCode' element value. Indicates carrier who marketed the flight in the context of codeshare. In case of codeshare "MarketingAirlineCode" may be different than "OperatingAirlineCode."
     * 
     * @param marketingAirlineCode
     */
    public void setMarketingAirlineCode(String marketingAirlineCode) {
        this.marketingAirlineCode = marketingAirlineCode;
    }

    /** 
     * Get the 'MarketingFlightNumber' element value. Indicates flight number marketed by carrier being in the codeshare agreement with operating carrier.
     * 
     * @return value
     */
    public String getMarketingFlightNumber() {
        return marketingFlightNumber;
    }

    /** 
     * Set the 'MarketingFlightNumber' element value. Indicates flight number marketed by carrier being in the codeshare agreement with operating carrier.
     * 
     * @param marketingFlightNumber
     */
    public void setMarketingFlightNumber(String marketingFlightNumber) {
        this.marketingFlightNumber = marketingFlightNumber;
    }

    /** 
     * Get the 'OperatingClassOfService' element value. Indicates class of service offered by operating carrier in the context of codeshare. Example "Y".
     * 
     * @return value
     */
    public String getOperatingClassOfService() {
        return operatingClassOfService;
    }

    /** 
     * Set the 'OperatingClassOfService' element value. Indicates class of service offered by operating carrier in the context of codeshare. Example "Y".
     * 
     * @param operatingClassOfService
     */
    public void setOperatingClassOfService(String operatingClassOfService) {
        this.operatingClassOfService = operatingClassOfService;
    }

    /** 
     * Get the 'MarketingClassOfService' element value. Indicates class of service marketed by carrier being in the codeshare agreement with operating carrier. Example "Y". In case of codeshare "MarketingClassOfService" may be different than "OperatingClassOfservice".
     * 
     * @return value
     */
    public String getMarketingClassOfService() {
        return marketingClassOfService;
    }

    /** 
     * Set the 'MarketingClassOfService' element value. Indicates class of service marketed by carrier being in the codeshare agreement with operating carrier. Example "Y". In case of codeshare "MarketingClassOfService" may be different than "OperatingClassOfservice".
     * 
     * @param marketingClassOfService
     */
    public void setMarketingClassOfService(String marketingClassOfService) {
        this.marketingClassOfService = marketingClassOfService;
    }

    /** 
     * Get the 'CodeShareOperatingRecordLocator' element value. RecordLocator issued by Codeshare Operating Carrier.
     * 
     * @return value
     */
    public String getCodeShareOperatingRecordLocator() {
        return codeShareOperatingRecordLocator;
    }

    /** 
     * Set the 'CodeShareOperatingRecordLocator' element value. RecordLocator issued by Codeshare Operating Carrier.
     * 
     * @param codeShareOperatingRecordLocator
     */
    public void setCodeShareOperatingRecordLocator(
            String codeShareOperatingRecordLocator) {
        this.codeShareOperatingRecordLocator = codeShareOperatingRecordLocator;
    }

    /** 
     * Get the 'MarriageGrp' element value.
     * 
     * @return value
     */
    public MarriageGrp getMarriageGrp() {
        return marriageGrp;
    }

    /** 
     * Set the 'MarriageGrp' element value.
     * 
     * @param marriageGrp
     */
    public void setMarriageGrp(MarriageGrp marriageGrp) {
        this.marriageGrp = marriageGrp;
    }

    /** 
     * Get the 'Cabin' element value. Generic cabin description data.
     * 
     * @return value
     */
    public CabinType getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value. Generic cabin description data.
     * 
     * @param cabin
     */
    public void setCabin(CabinType cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the list of 'MealCode' element items. Meal code associated with the particular flight segment.
     * 
     * @return list
     */
    public List<String> getMealCodeList() {
        return mealCodeList;
    }

    /** 
     * Set the list of 'MealCode' element items. Meal code associated with the particular flight segment.
     * 
     * @param list
     */
    public void setMealCodeList(List<String> list) {
        mealCodeList = list;
    }

    /** 
     * Get the 'SmokingAllowed' element value. Indicates whether or not smoking is permitted on the particular flight segment.
     * 
     * @return value
     */
    public Boolean getSmokingAllowed() {
        return smokingAllowed;
    }

    /** 
     * Set the 'SmokingAllowed' element value. Indicates whether or not smoking is permitted on the particular flight segment.
     * 
     * @param smokingAllowed
     */
    public void setSmokingAllowed(Boolean smokingAllowed) {
        this.smokingAllowed = smokingAllowed;
    }

    /** 
     * Get the 'StopQuantity' element value. Number of stops associated with the particular flight segment.
     * 
     * @return value
     */
    public Integer getStopQuantity() {
        return stopQuantity;
    }

    /** 
     * Set the 'StopQuantity' element value. Number of stops associated with the particular flight segment.
     * 
     * @param stopQuantity
     */
    public void setStopQuantity(Integer stopQuantity) {
        this.stopQuantity = stopQuantity;
    }

    /** 
     * Get the 'ElapsedTime' element value. The elapsed time in minutes associated with the particular flight segment.
     * 
     * @return value
     */
    public Integer getElapsedTime() {
        return elapsedTime;
    }

    /** 
     * Set the 'ElapsedTime' element value. The elapsed time in minutes associated with the particular flight segment.
     * 
     * @param elapsedTime
     */
    public void setElapsedTime(Integer elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    /** 
     * Get the 'AirMilesFlown' element value. Air miles flown associated with the particular flight segment.
     * 
     * @return value
     */
    public Integer getAirMilesFlown() {
        return airMilesFlown;
    }

    /** 
     * Set the 'AirMilesFlown' element value. Air miles flown associated with the particular flight segment.
     * 
     * @param airMilesFlown
     */
    public void setAirMilesFlown(Integer airMilesFlown) {
        this.airMilesFlown = airMilesFlown;
    }

    /** 
     * Get the list of 'HiddenStop' element items.
     * 
     * @return list
     */
    public List<HiddenStop> getHiddenStopList() {
        return hiddenStopList;
    }

    /** 
     * Set the list of 'HiddenStop' element items.
     * 
     * @param list
     */
    public void setHiddenStopList(List<HiddenStop> list) {
        hiddenStopList = list;
    }

    /** 
     * Get the 'FunnelFlight' element value. "FunnelFlight" is used to determine a funnel flight type for flight segment.
     * 
     * @return value
     */
    public Boolean getFunnelFlight() {
        return funnelFlight;
    }

    /** 
     * Set the 'FunnelFlight' element value. "FunnelFlight" is used to determine a funnel flight type for flight segment.
     * 
     * @param funnelFlight
     */
    public void setFunnelFlight(Boolean funnelFlight) {
        this.funnelFlight = funnelFlight;
    }

    /** 
     * Get the 'ChangeOfGauge' element value. "ChangeOfGauge" is used to determine a change of gauge for flight segment.
     * 
     * @return value
     */
    public Boolean getChangeOfGauge() {
        return changeOfGauge;
    }

    /** 
     * Set the 'ChangeOfGauge' element value. "ChangeOfGauge" is used to determine a change of gauge for flight segment.
     * 
     * @param changeOfGauge
     */
    public void setChangeOfGauge(Boolean changeOfGauge) {
        this.changeOfGauge = changeOfGauge;
    }

    /** 
     * Get the 'DisclosureCarrier' element value.
     * 
     * @return value
     */
    public DisclosureCarrier getDisclosureCarrier() {
        return disclosureCarrier;
    }

    /** 
     * Set the 'DisclosureCarrier' element value.
     * 
     * @param disclosureCarrier
     */
    public void setDisclosureCarrier(DisclosureCarrier disclosureCarrier) {
        this.disclosureCarrier = disclosureCarrier;
    }

    /** 
     * Get the 'AirlineRefId' element value. 2 char code indicating method other airlines segment was added.
                          Example "VA*XBZVGY"
     * 
     * @return value
     */
    public String getAirlineRefId() {
        return airlineRefId;
    }

    /** 
     * Set the 'AirlineRefId' element value. 2 char code indicating method other airlines segment was added.
                          Example "VA*XBZVGY"
     * 
     * @param airlineRefId
     */
    public void setAirlineRefId(String airlineRefId) {
        this.airlineRefId = airlineRefId;
    }

    /** 
     * Get the 'Eticket' element value. True/False indicator. Example "TRUE"
     * 
     * @return value
     */
    public Boolean getEticket() {
        return eticket;
    }

    /** 
     * Set the 'Eticket' element value. True/False indicator. Example "TRUE"
     * 
     * @param eticket
     */
    public void setEticket(Boolean eticket) {
        this.eticket = eticket;
    }

    /** 
     * Get the 'DepartureDateTime' element value.
     * 
     * @return value
     */
    public Date getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' element value.
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(Date departureDateTime) {
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Get the 'ArrivalDateTime' element value.
     * 
     * @return value
     */
    public Date getArrivalDateTime() {
        return arrivalDateTime;
    }

    /** 
     * Set the 'ArrivalDateTime' element value.
     * 
     * @param arrivalDateTime
     */
    public void setArrivalDateTime(Date arrivalDateTime) {
        this.arrivalDateTime = arrivalDateTime;
    }

    /** 
     * Get the 'FlightNumber' element value. The flight number of the flight.
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. The flight number of the flight.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'ClassOfService' element value. Specific Booking Class for this segment.
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. Specific Booking Class for this segment.
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'ActionCode' element value. Current status of booked segment.
                          Example "HK"
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Current status of booked segment.
                          Example "HK"
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' element value. Booked seats. Example "2"
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Booked seats. Example "2"
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'inboundConnection' element value. Indicates if connection from previous flight segment.
                          Example "FALSE"
     * 
     * @return value
     */
    public Boolean getInboundConnection() {
        return inboundConnection;
    }

    /** 
     * Set the 'inboundConnection' element value. Indicates if connection from previous flight segment.
                          Example "FALSE"
     * 
     * @param inboundConnection
     */
    public void setInboundConnection(Boolean inboundConnection) {
        this.inboundConnection = inboundConnection;
    }

    /** 
     * Get the 'outboundConnection' element value. Indicates if connection to the following flight segment.
                          Example "FALSE"
     * 
     * @return value
     */
    public Boolean getOutboundConnection() {
        return outboundConnection;
    }

    /** 
     * Set the 'outboundConnection' element value. Indicates if connection to the following flight segment.
                          Example "FALSE"
     * 
     * @param outboundConnection
     */
    public void setOutboundConnection(Boolean outboundConnection) {
        this.outboundConnection = outboundConnection;
    }

    /** 
     * Get the 'AncillaryServices' element value.
     * 
     * @return value
     */
    public AncillaryServices getAncillaryServices() {
        return ancillaryServices;
    }

    /** 
     * Set the 'AncillaryServices' element value.
     * 
     * @param ancillaryServices
     */
    public void setAncillaryServices(AncillaryServices ancillaryServices) {
        this.ancillaryServices = ancillaryServices;
    }

    /** 
     * Get the 'BSGIndicator' element value. Used to indicate group bookings.
     * 
     * @return value
     */
    public Boolean getBSGIndicator() {
        return BSGIndicator;
    }

    /** 
     * Set the 'BSGIndicator' element value. Used to indicate group bookings.
     * 
     * @param BSGIndicator
     */
    public void setBSGIndicator(Boolean BSGIndicator) {
        this.BSGIndicator = BSGIndicator;
    }

    /** 
     * Get the 'BSGPNRRecordLocator' element value. The Master or parent blocked space group PNR locator ID.
                          The PNR locator of the original blocked space group PNR.
                          Example "YOUZYG"
     * 
     * @return value
     */
    public String getBSGPNRRecordLocator() {
        return BSGPNRRecordLocator;
    }

    /** 
     * Set the 'BSGPNRRecordLocator' element value. The Master or parent blocked space group PNR locator ID.
                          The PNR locator of the original blocked space group PNR.
                          Example "YOUZYG"
     * 
     * @param BSGPNRRecordLocator
     */
    public void setBSGPNRRecordLocator(String BSGPNRRecordLocator) {
        this.BSGPNRRecordLocator = BSGPNRRecordLocator;
    }

    /** 
     * Get the 'BSGPNRCreatedDate' element value. The Master or parent blocked space group PNR create date.
                          The PNR create date of the original blocked space group PNR.
                          Example "2012-11-23"
     * 
     * @return value
     */
    public Date getBSGPNRCreatedDate() {
        return BSGPNRCreatedDate;
    }

    /** 
     * Set the 'BSGPNRCreatedDate' element value. The Master or parent blocked space group PNR create date.
                          The PNR create date of the original blocked space group PNR.
                          Example "2012-11-23"
     * 
     * @param BSGPNRCreatedDate
     */
    public void setBSGPNRCreatedDate(Date BSGPNRCreatedDate) {
        this.BSGPNRCreatedDate = BSGPNRCreatedDate;
    }

    /** 
     * Get the 'PassiveSegmentIndicator' element value. Passively booked segments notification.
     * 
     * @return value
     */
    public Boolean getPassiveSegmentIndicator() {
        return passiveSegmentIndicator;
    }

    /** 
     * Set the 'PassiveSegmentIndicator' element value. Passively booked segments notification.
     * 
     * @param passiveSegmentIndicator
     */
    public void setPassiveSegmentIndicator(Boolean passiveSegmentIndicator) {
        this.passiveSegmentIndicator = passiveSegmentIndicator;
    }

    /** 
     * Get the 'ScheduleChangeIndicator' element value. Notification regarding any schedule changes.
     * 
     * @return value
     */
    public Boolean getScheduleChangeIndicator() {
        return scheduleChangeIndicator;
    }

    /** 
     * Set the 'ScheduleChangeIndicator' element value. Notification regarding any schedule changes.
     * 
     * @param scheduleChangeIndicator
     */
    public void setScheduleChangeIndicator(Boolean scheduleChangeIndicator) {
        this.scheduleChangeIndicator = scheduleChangeIndicator;
    }

    /** 
     * Get the 'SegmentBookedDate' element value. Segment Booked date and time with format: YYYY-MM-DDThh:mm:ss
     * 
     * @return value
     */
    public Date getSegmentBookedDate() {
        return segmentBookedDate;
    }

    /** 
     * Set the 'SegmentBookedDate' element value. Segment Booked date and time with format: YYYY-MM-DDThh:mm:ss
     * 
     * @param segmentBookedDate
     */
    public void setSegmentBookedDate(Date segmentBookedDate) {
        this.segmentBookedDate = segmentBookedDate;
    }

    /** 
     * Get the 'UpdatedDepartureDate' element value. Updated departure information if applicable with format YYYY-MM-DD
     * 
     * @return value
     */
    public String getUpdatedDepartureDate() {
        return updatedDepartureDate;
    }

    /** 
     * Set the 'UpdatedDepartureDate' element value. Updated departure information if applicable with format YYYY-MM-DD
     * 
     * @param updatedDepartureDate
     */
    public void setUpdatedDepartureDate(String updatedDepartureDate) {
        this.updatedDepartureDate = updatedDepartureDate;
    }

    /** 
     * Get the 'UpdatedDepartureTime' element value. Updated departure information if applicable with format hh:mm
     * 
     * @return value
     */
    public String getUpdatedDepartureTime() {
        return updatedDepartureTime;
    }

    /** 
     * Set the 'UpdatedDepartureTime' element value. Updated departure information if applicable with format hh:mm
     * 
     * @param updatedDepartureTime
     */
    public void setUpdatedDepartureTime(String updatedDepartureTime) {
        this.updatedDepartureTime = updatedDepartureTime;
    }

    /** 
     * Get the 'UpdatedArrivalTime' element value. Updated arrival information if applicable with
                          format hh:mm
     * 
     * @return value
     */
    public String getUpdatedArrivalTime() {
        return updatedArrivalTime;
    }

    /** 
     * Set the 'UpdatedArrivalTime' element value. Updated arrival information if applicable with
                          format hh:mm
     * 
     * @param updatedArrivalTime
     */
    public void setUpdatedArrivalTime(String updatedArrivalTime) {
        this.updatedArrivalTime = updatedArrivalTime;
    }

    /** 
     * Get the 'Pos' element value.
     * 
     * @return value
     */
    public AirPosType getPos() {
        return pos;
    }

    /** 
     * Set the 'Pos' element value.
     * 
     * @param pos
     */
    public void setPos(AirPosType pos) {
        this.pos = pos;
    }

    /** 
     * Get the 'OALocator' element value.
     * 
     * @return value
     */
    public String getOALocator() {
        return OALocator;
    }

    /** 
     * Set the 'OALocator' element value.
     * 
     * @param OALocator
     */
    public void setOALocator(String OALocator) {
        this.OALocator = OALocator;
    }

    /** 
     * Get the 'DirectConnectDate' element value.
     * 
     * @return value
     */
    public Date getDirectConnectDate() {
        return directConnectDate;
    }

    /** 
     * Set the 'DirectConnectDate' element value.
     * 
     * @param directConnectDate
     */
    public void setDirectConnectDate(Date directConnectDate) {
        this.directConnectDate = directConnectDate;
    }

    /** 
     * Get the 'InstantPurchase' element value. Low cost segment indicator
     * 
     * @return value
     */
    public Boolean getInstantPurchase() {
        return instantPurchase;
    }

    /** 
     * Set the 'InstantPurchase' element value. Low cost segment indicator
     * 
     * @param instantPurchase
     */
    public void setInstantPurchase(Boolean instantPurchase) {
        this.instantPurchase = instantPurchase;
    }

    /** 
     * Get the 'BrandID' element value. 2 chars string representing sold brand.
     * 
     * @return value
     */
    public String getBrandID() {
        return brandID;
    }

    /** 
     * Set the 'BrandID' element value. 2 chars string representing sold brand.
     * 
     * @param brandID
     */
    public void setBrandID(String brandID) {
        this.brandID = brandID;
    }

    /** 
     * Get the list of 'FareComponent' element items. Fare Component information
     * 
     * @return list
     */
    public List<FareComponentWithId> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items. Fare Component information
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponentWithId> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'sequence' attribute value. Identifies sequence number of Itinerary
     * 
     * @return value
     */
    public Short getSequence() {
        return sequence;
    }

    /** 
     * Set the 'sequence' attribute value. Identifies sequence number of Itinerary
     * 
     * @param sequence
     */
    public void setSequence(Short sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'segmentAssociationId' attribute value. Unique segment tab for the segment the
                      association is processed.
     * 
     * @return value
     */
    public Short getSegmentAssociationId() {
        return segmentAssociationId;
    }

    /** 
     * Set the 'segmentAssociationId' attribute value. Unique segment tab for the segment the
                      association is processed.
     * 
     * @param segmentAssociationId
     */
    public void setSegmentAssociationId(Short segmentAssociationId) {
        this.segmentAssociationId = segmentAssociationId;
    }

    /** 
     * Get the 'isPast' attribute value. It returns information if current segment is past
                      or not.
     * 
     * @return value
     */
    public Boolean getIsPast() {
        return isPast;
    }

    /** 
     * Set the 'isPast' attribute value. It returns information if current segment is past
                      or not.
     * 
     * @param isPast
     */
    public void setIsPast(Boolean isPast) {
        this.isPast = isPast;
    }
    /** 
     * Indicates that married group number in case its married with another one.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarriageGrp" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Ind" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Group" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Sequence" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MarriageGrp implements Serializable
    {
        private String ind;
        private String group;
        private String sequence;

        /** 
         * Get the 'Ind' element value. An indicator which represents non-contiguous group segments.
                                        Out of sequence married segment will have one other airline in between two airline group segments.
         * 
         * @return value
         */
        public String getInd() {
            return ind;
        }

        /** 
         * Set the 'Ind' element value. An indicator which represents non-contiguous group segments.
                                        Out of sequence married segment will have one other airline in between two airline group segments.
         * 
         * @param ind
         */
        public void setInd(String ind) {
            this.ind = ind;
        }

        /** 
         * Get the 'Group' element value. A set of air segments that are considered "married" together.
                                        This is referred to as the new married group number.
                                        Married Group may contain up to 3 segments.
         * 
         * @return value
         */
        public String getGroup() {
            return group;
        }

        /** 
         * Set the 'Group' element value. A set of air segments that are considered "married" together.
                                        This is referred to as the new married group number.
                                        Married Group may contain up to 3 segments.
         * 
         * @param group
         */
        public void setGroup(String group) {
            this.group = group;
        }

        /** 
         * Get the 'Sequence' element value. The sequence number within the set/group of air segments that considered "married" together.
         * 
         * @return value
         */
        public String getSequence() {
            return sequence;
        }

        /** 
         * Set the 'Sequence' element value. The sequence number within the set/group of air segments that considered "married" together.
         * 
         * @param sequence
         */
        public void setSequence(String sequence) {
            this.sequence = sequence;
        }
    }
    /** 
     * Used to return hidden stop details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HiddenStop" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ArrivalDateTime" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="DepartureDateTime" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="Airport"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HiddenStop implements Serializable
    {
        private String arrivalDateTime;
        private String departureDateTime;
        private String airport;

        /** 
         * Get the 'ArrivalDateTime' element value. Arrival date and time to hidden stop
         * 
         * @return value
         */
        public String getArrivalDateTime() {
            return arrivalDateTime;
        }

        /** 
         * Set the 'ArrivalDateTime' element value. Arrival date and time to hidden stop
         * 
         * @param arrivalDateTime
         */
        public void setArrivalDateTime(String arrivalDateTime) {
            this.arrivalDateTime = arrivalDateTime;
        }

        /** 
         * Get the 'DepartureDateTime' element value. Departure date and time from hidden stop
         * 
         * @return value
         */
        public String getDepartureDateTime() {
            return departureDateTime;
        }

        /** 
         * Set the 'DepartureDateTime' element value. Departure date and time from hidden stop
         * 
         * @param departureDateTime
         */
        public void setDepartureDateTime(String departureDateTime) {
            this.departureDateTime = departureDateTime;
        }

        /** 
         * Get the 'Airport' attribute value. "Airport" is used to determine airport location code
         * 
         * @return value
         */
        public String getAirport() {
            return airport;
        }

        /** 
         * Set the 'Airport' attribute value. "Airport" is used to determine airport location code
         * 
         * @param airport
         */
        public void setAirport(String airport) {
            this.airport = airport;
        }
    }
    /** 
     * Disclosure Carrier is used to return operated flight data.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisclosureCarrier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Banner" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *     &lt;xs:attribute type="xs:boolean" name="DOT"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DisclosureCarrier implements Serializable
    {
        private String banner;
        private String code;
        private Boolean DOT;

        /** 
         * Get the 'Banner' element value. "DisclosureCarrier/Banner" is used to return the disclosure carrier name
         * 
         * @return value
         */
        public String getBanner() {
            return banner;
        }

        /** 
         * Set the 'Banner' element value. "DisclosureCarrier/Banner" is used to return the disclosure carrier name
         * 
         * @param banner
         */
        public void setBanner(String banner) {
            this.banner = banner;
        }

        /** 
         * Get the 'Code' attribute value. "Code" is used to return the disclosure carrier code associated with the particular vehicle segment
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value. "Code" is used to return the disclosure carrier code associated with the particular vehicle segment
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'DOT' attribute value. "DOT" is optional data from DSS (DOT) it determines Banner appearance
         * 
         * @return value
         */
        public Boolean getDOT() {
            return DOT;
        }

        /** 
         * Set the 'DOT' attribute value. "DOT" is optional data from DSS (DOT) it determines Banner appearance
         * 
         * @param DOT
         */
        public void setDOT(Boolean DOT) {
            this.DOT = DOT;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServices" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AncillaryService" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AncillaryService -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AncillaryServices implements Serializable
    {
        private List<AncillaryService> ancillaryServiceList = new ArrayList<AncillaryService>();

        /** 
         * Get the list of 'AncillaryService' element items.
         * 
         * @return list
         */
        public List<AncillaryService> getAncillaryServiceList() {
            return ancillaryServiceList;
        }

        /** 
         * Set the list of 'AncillaryService' element items.
         * 
         * @param list
         */
        public void setAncillaryServiceList(List<AncillaryService> list) {
            ancillaryServiceList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryService" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="ref"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AncillaryService implements Serializable
        {
            private String ref;

            /** 
             * Get the 'ref' attribute value.
             * 
             * @return value
             */
            public String getRef() {
                return ref;
            }

            /** 
             * Set the 'ref' attribute value.
             * 
             * @param ref
             */
            public void setRef(String ref) {
                this.ref = ref;
            }
        }
    }
}
