
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount.Discount">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Percent" name="PercentageRate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AmountDiscount implements Serializable
{
    private AmountPattern amount;
    private AmountPercent percentageRate;

    /** 
     * Get the 'Amount' element value. Discount amount
                          Ref: DM0Z_70_DAMT or DM0Z_70_FBDA
                      
     * 
     * @return value
     */
    public AmountPattern getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Discount amount
                          Ref: DM0Z_70_DAMT or DM0Z_70_FBDA
                      
     * 
     * @param amount
     */
    public void setAmount(AmountPattern amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'PercentageRate' element value. Discount percentage if applicable
                          Ref: DM0Z_70_FBDA
                      
     * 
     * @return value
     */
    public AmountPercent getPercentageRate() {
        return percentageRate;
    }

    /** 
     * Set the 'PercentageRate' element value. Discount percentage if applicable
                          Ref: DM0Z_70_FBDA
                      
     * 
     * @param percentageRate
     */
    public void setPercentageRate(AmountPercent percentageRate) {
        this.percentageRate = percentageRate;
    }
}
