
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:PriorityLegType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Carrier" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Carrier -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarrierType extends PriorityLegType implements Serializable
{
    private List<Carrier> carrierList = new ArrayList<Carrier>();

    /** 
     * Get the list of 'Carrier' element items.
     * 
     * @return list
     */
    public List<Carrier> getCarrierList() {
        return carrierList;
    }

    /** 
     * Set the list of 'Carrier' element items.
     * 
     * @param list
     */
    public void setCarrierList(List<Carrier> list) {
        carrierList = list;
    }
    /** 
     * Specifies desired order of carriers
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Carrier" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Carrier implements Serializable
    {
        private String code;

        /** 
         * Get the 'code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
}
