
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * .
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code.DifferentialType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Low"/>
 *     &lt;xs:enumeration value="High"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CodeDifferentialType implements Serializable {
    LOW("Low"), HIGH("High");
    private final String value;

    private CodeDifferentialType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CodeDifferentialType convert(String value) {
        for (CodeDifferentialType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
