
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceData">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="SnapshotId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InvoiceId" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="InvoiceNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="InvoiceCreateDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DkNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TravellerLastName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TravellerFirstName" minOccurs="0"/>
 *     &lt;xs:element type="ns:NameAssociationTag" name="TravellerName" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="AccountingLine" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="SegmentNumber" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InvoiceData implements Serializable
{
    private String snapshotId;
    private String invoiceId;
    private Integer invoiceNumber;
    private Date invoiceCreateDate;
    private String dkNumber;
    private String travellerLastName;
    private String travellerFirstName;
    private List<NameAssociationTag> travellerNameList = new ArrayList<NameAssociationTag>();
    private List<String> accountingLineList = new ArrayList<String>();
    private List<String> segmentNumberList = new ArrayList<String>();

    /** 
     * Get the 'SnapshotId' element value.
     * 
     * @return value
     */
    public String getSnapshotId() {
        return snapshotId;
    }

    /** 
     * Set the 'SnapshotId' element value.
     * 
     * @param snapshotId
     */
    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    /** 
     * Get the 'InvoiceId' element value.
     * 
     * @return value
     */
    public String getInvoiceId() {
        return invoiceId;
    }

    /** 
     * Set the 'InvoiceId' element value.
     * 
     * @param invoiceId
     */
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    /** 
     * Get the 'InvoiceNumber' element value.
     * 
     * @return value
     */
    public Integer getInvoiceNumber() {
        return invoiceNumber;
    }

    /** 
     * Set the 'InvoiceNumber' element value.
     * 
     * @param invoiceNumber
     */
    public void setInvoiceNumber(Integer invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    /** 
     * Get the 'InvoiceCreateDate' element value.
     * 
     * @return value
     */
    public Date getInvoiceCreateDate() {
        return invoiceCreateDate;
    }

    /** 
     * Set the 'InvoiceCreateDate' element value.
     * 
     * @param invoiceCreateDate
     */
    public void setInvoiceCreateDate(Date invoiceCreateDate) {
        this.invoiceCreateDate = invoiceCreateDate;
    }

    /** 
     * Get the 'DkNumber' element value.
     * 
     * @return value
     */
    public String getDkNumber() {
        return dkNumber;
    }

    /** 
     * Set the 'DkNumber' element value.
     * 
     * @param dkNumber
     */
    public void setDkNumber(String dkNumber) {
        this.dkNumber = dkNumber;
    }

    /** 
     * Get the 'TravellerLastName' element value.
     * 
     * @return value
     */
    public String getTravellerLastName() {
        return travellerLastName;
    }

    /** 
     * Set the 'TravellerLastName' element value.
     * 
     * @param travellerLastName
     */
    public void setTravellerLastName(String travellerLastName) {
        this.travellerLastName = travellerLastName;
    }

    /** 
     * Get the 'TravellerFirstName' element value.
     * 
     * @return value
     */
    public String getTravellerFirstName() {
        return travellerFirstName;
    }

    /** 
     * Set the 'TravellerFirstName' element value.
     * 
     * @param travellerFirstName
     */
    public void setTravellerFirstName(String travellerFirstName) {
        this.travellerFirstName = travellerFirstName;
    }

    /** 
     * Get the list of 'TravellerName' element items.
     * 
     * @return list
     */
    public List<NameAssociationTag> getTravellerNameList() {
        return travellerNameList;
    }

    /** 
     * Set the list of 'TravellerName' element items.
     * 
     * @param list
     */
    public void setTravellerNameList(List<NameAssociationTag> list) {
        travellerNameList = list;
    }

    /** 
     * Get the list of 'AccountingLine' element items.
     * 
     * @return list
     */
    public List<String> getAccountingLineList() {
        return accountingLineList;
    }

    /** 
     * Set the list of 'AccountingLine' element items.
     * 
     * @param list
     */
    public void setAccountingLineList(List<String> list) {
        accountingLineList = list;
    }

    /** 
     * Get the list of 'SegmentNumber' element items.
     * 
     * @return list
     */
    public List<String> getSegmentNumberList() {
        return segmentNumberList;
    }

    /** 
     * Set the list of 'SegmentNumber' element items.
     * 
     * @param list
     */
    public void setSegmentNumberList(List<String> list) {
        segmentNumberList = list;
    }
}
