
package com.sabre.services.sp.pd.v35;

import com.sabre.services.stlpayload.v0201.STLPayload1;
import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:ns1="http://services.sabre.com/STL_Payload/v02_01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerDetailsRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns1:STL_Payload">
 *         &lt;xs:sequence>
 *           &lt;xs:element name="MiscSegmentSellRQ" minOccurs="0">
 *             &lt;!-- Reference to inner class MiscSegmentSellRQ -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="PostProcessing" minOccurs="0">
 *             &lt;!-- Reference to inner class PostProcessing -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="PreProcessing" minOccurs="0">
 *             &lt;!-- Reference to inner class PreProcessing -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="PriceQuoteInfo" minOccurs="0">
 *             &lt;!-- Reference to inner class PriceQuoteInfo -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="ProfileRQ" minOccurs="0">
 *             &lt;!-- Reference to inner class ProfileRQ -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="SpecialReqDetails" minOccurs="0">
 *             &lt;!-- Reference to inner class SpecialReqDetails -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="TravelItineraryAddInfoRQ" minOccurs="0">
 *             &lt;!-- Reference to inner class TravelItineraryAddInfoRQ -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:attribute type="xs:boolean" name="haltOnError"/>
 *         &lt;xs:attribute type="xs:boolean" name="ignoreOnError"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PassengerDetailsRQ extends STLPayload1 implements Serializable
{
    private MiscSegmentSellRQ miscSegmentSellRQ;
    private PostProcessing postProcessing;
    private PreProcessing preProcessing;
    private PriceQuoteInfo priceQuoteInfo;
    private ProfileRQ profileRQ;
    private SpecialReqDetails specialReqDetails;
    private TravelItineraryAddInfoRQ travelItineraryAddInfoRQ;
    private Boolean haltOnError;
    private Boolean ignoreOnError;

    /** 
     * Get the 'MiscSegmentSellRQ' element value.
     * 
     * @return value
     */
    public MiscSegmentSellRQ getMiscSegmentSellRQ() {
        return miscSegmentSellRQ;
    }

    /** 
     * Set the 'MiscSegmentSellRQ' element value.
     * 
     * @param miscSegmentSellRQ
     */
    public void setMiscSegmentSellRQ(MiscSegmentSellRQ miscSegmentSellRQ) {
        this.miscSegmentSellRQ = miscSegmentSellRQ;
    }

    /** 
     * Get the 'PostProcessing' element value.
     * 
     * @return value
     */
    public PostProcessing getPostProcessing() {
        return postProcessing;
    }

    /** 
     * Set the 'PostProcessing' element value.
     * 
     * @param postProcessing
     */
    public void setPostProcessing(PostProcessing postProcessing) {
        this.postProcessing = postProcessing;
    }

    /** 
     * Get the 'PreProcessing' element value.
     * 
     * @return value
     */
    public PreProcessing getPreProcessing() {
        return preProcessing;
    }

    /** 
     * Set the 'PreProcessing' element value.
     * 
     * @param preProcessing
     */
    public void setPreProcessing(PreProcessing preProcessing) {
        this.preProcessing = preProcessing;
    }

    /** 
     * Get the 'PriceQuoteInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteInfo getPriceQuoteInfo() {
        return priceQuoteInfo;
    }

    /** 
     * Set the 'PriceQuoteInfo' element value.
     * 
     * @param priceQuoteInfo
     */
    public void setPriceQuoteInfo(PriceQuoteInfo priceQuoteInfo) {
        this.priceQuoteInfo = priceQuoteInfo;
    }

    /** 
     * Get the 'ProfileRQ' element value.
     * 
     * @return value
     */
    public ProfileRQ getProfileRQ() {
        return profileRQ;
    }

    /** 
     * Set the 'ProfileRQ' element value.
     * 
     * @param profileRQ
     */
    public void setProfileRQ(ProfileRQ profileRQ) {
        this.profileRQ = profileRQ;
    }

    /** 
     * Get the 'SpecialReqDetails' element value.
     * 
     * @return value
     */
    public SpecialReqDetails getSpecialReqDetails() {
        return specialReqDetails;
    }

    /** 
     * Set the 'SpecialReqDetails' element value.
     * 
     * @param specialReqDetails
     */
    public void setSpecialReqDetails(SpecialReqDetails specialReqDetails) {
        this.specialReqDetails = specialReqDetails;
    }

    /** 
     * Get the 'TravelItineraryAddInfoRQ' element value.
     * 
     * @return value
     */
    public TravelItineraryAddInfoRQ getTravelItineraryAddInfoRQ() {
        return travelItineraryAddInfoRQ;
    }

    /** 
     * Set the 'TravelItineraryAddInfoRQ' element value.
     * 
     * @param travelItineraryAddInfoRQ
     */
    public void setTravelItineraryAddInfoRQ(
            TravelItineraryAddInfoRQ travelItineraryAddInfoRQ) {
        this.travelItineraryAddInfoRQ = travelItineraryAddInfoRQ;
    }

    /** 
     * Get the 'haltOnError' attribute value. Tells the system (if true) to halt processing if any errors are returned from the low level invocation.
     * 
     * @return value
     */
    public Boolean getHaltOnError() {
        return haltOnError;
    }

    /** 
     * Set the 'haltOnError' attribute value. Tells the system (if true) to halt processing if any errors are returned from the low level invocation.
     * 
     * @param haltOnError
     */
    public void setHaltOnError(Boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    /** 
     * Get the 'ignoreOnError' attribute value. Tells the system (if true) to ignore the entire transaction if any errors are encountered.
     * 
     * @return value
     */
    public Boolean getIgnoreOnError() {
        return ignoreOnError;
    }

    /** 
     * Set the 'ignoreOnError' attribute value. Tells the system (if true) to ignore the entire transaction if any errors are encountered.
     * 
     * @param ignoreOnError
     */
    public void setIgnoreOnError(Boolean ignoreOnError) {
        this.ignoreOnError = ignoreOnError;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscSegmentSellRQ" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="MiscSegment">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="OriginLocation">
     *               &lt;xs:complexType>
     *                 &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element type="xs:string" name="Text"/>
     *             &lt;xs:element name="VendorPrefs">
     *               &lt;xs:complexType>
     *                 &lt;xs:sequence>
     *                   &lt;xs:element name="Airline">
     *                     &lt;xs:complexType>
     *                       &lt;xs:attribute type="xs:string" use="required" name="Code"/>
     *                     &lt;/xs:complexType>
     *                   &lt;/xs:element>
     *                 &lt;/xs:sequence>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" use="required" name="DepartureDateTime"/>
     *           &lt;xs:attribute type="xs:integer" name="InsertAfter"/>
     *           &lt;xs:attribute type="xs:integer" use="required" name="NumberInParty"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="Status"/>
     *           &lt;xs:attribute use="required" name="Type">
     *             &lt;xs:simpleType>
     *               &lt;!-- Reference to inner class Type -->
     *             &lt;/xs:simpleType>
     *           &lt;/xs:attribute>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MiscSegmentSellRQ implements Serializable
    {
        private String miscSegmentOriginLocation;
        private String miscSegmentText;
        private String miscSegmentVendorPrefs;
        private String miscSegmentDepartureDateTime;
        private BigInteger miscSegmentInsertAfter;
        private BigInteger miscSegmentNumberInParty;
        private String miscSegmentStatus;
        private Type miscSegmentType;

        /** 
         * Get the 'LocationCode' attribute value. Used to specify the location code to be associated with the miscellaneous segment.
         * 
         * @return value
         */
        public String getMiscSegmentOriginLocation() {
            return miscSegmentOriginLocation;
        }

        /** 
         * Set the 'LocationCode' attribute value. Used to specify the location code to be associated with the miscellaneous segment.
         * 
         * @param miscSegmentOriginLocation
         */
        public void setMiscSegmentOriginLocation(
                String miscSegmentOriginLocation) {
            this.miscSegmentOriginLocation = miscSegmentOriginLocation;
        }

        /** 
         * Get the 'Text' element value. Used to specify free text information to be associated with the miscellaneous segment.
         * 
         * @return value
         */
        public String getMiscSegmentText() {
            return miscSegmentText;
        }

        /** 
         * Set the 'Text' element value. Used to specify free text information to be associated with the miscellaneous segment.
         * 
         * @param miscSegmentText
         */
        public void setMiscSegmentText(String miscSegmentText) {
            this.miscSegmentText = miscSegmentText;
        }

        /** 
         * Get the 'Code' attribute value. Used to specify a particular vendor code.
         * 
         * @return value
         */
        public String getMiscSegmentVendorPrefs() {
            return miscSegmentVendorPrefs;
        }

        /** 
         * Set the 'Code' attribute value. Used to specify a particular vendor code.
         * 
         * @param miscSegmentVendorPrefs
         */
        public void setMiscSegmentVendorPrefs(String miscSegmentVendorPrefs) {
            this.miscSegmentVendorPrefs = miscSegmentVendorPrefs;
        }

        /** 
         * Get the 'DepartureDateTime' attribute value. Used to specify the date associated with the miscellaneous segment.
         * 
         * @return value
         */
        public String getMiscSegmentDepartureDateTime() {
            return miscSegmentDepartureDateTime;
        }

        /** 
         * Set the 'DepartureDateTime' attribute value. Used to specify the date associated with the miscellaneous segment.
         * 
         * @param miscSegmentDepartureDateTime
         */
        public void setMiscSegmentDepartureDateTime(
                String miscSegmentDepartureDateTime) {
            this.miscSegmentDepartureDateTime = miscSegmentDepartureDateTime;
        }

        /** 
         * Get the 'InsertAfter' attribute value. Used to denote a segment after which the miscellaneous segment needs to be placed.
         * 
         * @return value
         */
        public BigInteger getMiscSegmentInsertAfter() {
            return miscSegmentInsertAfter;
        }

        /** 
         * Set the 'InsertAfter' attribute value. Used to denote a segment after which the miscellaneous segment needs to be placed.
         * 
         * @param miscSegmentInsertAfter
         */
        public void setMiscSegmentInsertAfter(BigInteger miscSegmentInsertAfter) {
            this.miscSegmentInsertAfter = miscSegmentInsertAfter;
        }

        /** 
         * Get the 'NumberInParty' attribute value. Used to specify the number of parties associated with the miscellaneous segment.
         * 
         * @return value
         */
        public BigInteger getMiscSegmentNumberInParty() {
            return miscSegmentNumberInParty;
        }

        /** 
         * Set the 'NumberInParty' attribute value. Used to specify the number of parties associated with the miscellaneous segment.
         * 
         * @param miscSegmentNumberInParty
         */
        public void setMiscSegmentNumberInParty(
                BigInteger miscSegmentNumberInParty) {
            this.miscSegmentNumberInParty = miscSegmentNumberInParty;
        }

        /** 
         * Get the 'Status' attribute value. Used to specify the action code to be used to sell the segment. Example: "GK".
         * 
         * @return value
         */
        public String getMiscSegmentStatus() {
            return miscSegmentStatus;
        }

        /** 
         * Set the 'Status' attribute value. Used to specify the action code to be used to sell the segment. Example: "GK".
         * 
         * @param miscSegmentStatus
         */
        public void setMiscSegmentStatus(String miscSegmentStatus) {
            this.miscSegmentStatus = miscSegmentStatus;
        }

        /** 
         * Get the 'Type' attribute value. Used to specify the type of miscellaneous segment, i.e. OTH, MCO, PTA, or INS.
         * 
         * @return value
         */
        public Type getMiscSegmentType() {
            return miscSegmentType;
        }

        /** 
         * Set the 'Type' attribute value. Used to specify the type of miscellaneous segment, i.e. OTH, MCO, PTA, or INS.
         * 
         * @param miscSegmentType
         */
        public void setMiscSegmentType(Type miscSegmentType) {
            this.miscSegmentType = miscSegmentType;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="INS"/>
         *     &lt;xs:enumeration value="MCO"/>
         *     &lt;xs:enumeration value="OTH"/>
         *     &lt;xs:enumeration value="PTA"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            INS, MCO, OTH, PTA
        }
    }
    /** 
     * Used to specify additional variables used to commit changes to or create a passenger name record.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PostProcessing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="RedisplayReservation" minOccurs="0">
     *         &lt;!-- Reference to inner class RedisplayReservation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ARUNK_RQ" minOccurs="0"/>
     *       &lt;xs:element name="EndTransactionRQ" minOccurs="0">
     *         &lt;!-- Reference to inner class EndTransactionRQ -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="QueuePlaceRQ" minOccurs="0">
     *         &lt;!-- Reference to inner class QueuePlaceRQ -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" name="haltOnInvalidMCT"/>
     *     &lt;xs:attribute type="xs:boolean" name="ignoreAfter"/>
     *     &lt;xs:attribute type="xs:boolean" default="false" name="unmaskCreditCard"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PostProcessing implements Serializable
    {
        private RedisplayReservation redisplayReservation;
        private boolean ARUNKRQ;
        private EndTransactionRQ endTransactionRQ;
        private QueuePlaceRQ queuePlaceRQ;
        private Boolean haltOnInvalidMCT;
        private Boolean ignoreAfter;
        private Boolean unmaskCreditCard;

        /** 
         * Get the 'RedisplayReservation' element value.
         * 
         * @return value
         */
        public RedisplayReservation getRedisplayReservation() {
            return redisplayReservation;
        }

        /** 
         * Set the 'RedisplayReservation' element value.
         * 
         * @param redisplayReservation
         */
        public void setRedisplayReservation(
                RedisplayReservation redisplayReservation) {
            this.redisplayReservation = redisplayReservation;
        }

        /** 
         * Check if the 'ARUNK_RQ' element is present.
         * 
         * @return <code>true</code> if present, <code>false</code> if not
         */
        public boolean ifARUNKRQPresent() {
            return ARUNKRQ;
        }

        /** 
         * Set flag for 'ARUNK_RQ' element present.
         * 
         * @param ARUNKRQ
         */
        public void flagARUNKRQPresent(boolean ARUNKRQ) {
            this.ARUNKRQ = ARUNKRQ;
        }

        /** 
         * Get the 'EndTransactionRQ' element value.
         * 
         * @return value
         */
        public EndTransactionRQ getEndTransactionRQ() {
            return endTransactionRQ;
        }

        /** 
         * Set the 'EndTransactionRQ' element value.
         * 
         * @param endTransactionRQ
         */
        public void setEndTransactionRQ(EndTransactionRQ endTransactionRQ) {
            this.endTransactionRQ = endTransactionRQ;
        }

        /** 
         * Get the 'QueuePlaceRQ' element value.
         * 
         * @return value
         */
        public QueuePlaceRQ getQueuePlaceRQ() {
            return queuePlaceRQ;
        }

        /** 
         * Set the 'QueuePlaceRQ' element value.
         * 
         * @param queuePlaceRQ
         */
        public void setQueuePlaceRQ(QueuePlaceRQ queuePlaceRQ) {
            this.queuePlaceRQ = queuePlaceRQ;
        }

        /** 
         * Get the 'haltOnInvalidMCT' attribute value. Used to specify whether the service should check and stop processing upon encountering an error indicating that minimum connection time between air itinerary segments is not met.
         * 
         * @return value
         */
        public Boolean getHaltOnInvalidMCT() {
            return haltOnInvalidMCT;
        }

        /** 
         * Set the 'haltOnInvalidMCT' attribute value. Used to specify whether the service should check and stop processing upon encountering an error indicating that minimum connection time between air itinerary segments is not met.
         * 
         * @param haltOnInvalidMCT
         */
        public void setHaltOnInvalidMCT(Boolean haltOnInvalidMCT) {
            this.haltOnInvalidMCT = haltOnInvalidMCT;
        }

        /** 
         * Get the 'ignoreAfter' attribute value. Used to perform an ignore to clear out the AAA.
                                                Please note that it does not close the session.
         * 
         * @return value
         */
        public Boolean getIgnoreAfter() {
            return ignoreAfter;
        }

        /** 
         * Set the 'ignoreAfter' attribute value. Used to perform an ignore to clear out the AAA.
                                                Please note that it does not close the session.
         * 
         * @param ignoreAfter
         */
        public void setIgnoreAfter(Boolean ignoreAfter) {
            this.ignoreAfter = ignoreAfter;
        }

        /** 
         * Get the 'unmaskCreditCard' attribute value. Used to unmask credit card information in the TIR response.
                                                Please note that this attribute has effect only if a user has EPR keyword CCVIEW.
         * 
         * @return value
         */
        public Boolean getUnmaskCreditCard() {
            return unmaskCreditCard;
        }

        /** 
         * Set the 'unmaskCreditCard' attribute value. Used to unmask credit card information in the TIR response.
                                                Please note that this attribute has effect only if a user has EPR keyword CCVIEW.
         * 
         * @param unmaskCreditCard
         */
        public void setUnmaskCreditCard(Boolean unmaskCreditCard) {
            this.unmaskCreditCard = unmaskCreditCard;
        }
        /** 
         * Used to indicate whether or not to redisplay the PNR.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedisplayReservation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" name="waitInterval"/>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="returnExtendedPriceQuote"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RedisplayReservation implements Serializable
        {
            private BigInteger waitInterval;
            private Boolean returnExtendedPriceQuote;

            /** 
             * Get the 'waitInterval' attribute value. Used  to indicate the wait interval in milliseconds that the system should wait before redisplaying the reservation.
             * 
             * @return value
             */
            public BigInteger getWaitInterval() {
                return waitInterval;
            }

            /** 
             * Set the 'waitInterval' attribute value. Used  to indicate the wait interval in milliseconds that the system should wait before redisplaying the reservation.
             * 
             * @param waitInterval
             */
            public void setWaitInterval(BigInteger waitInterval) {
                this.waitInterval = waitInterval;
            }

            /** 
             * Get the 'returnExtendedPriceQuote' attribute value. Used to request extended price quote display in the service response. The extended content will be passed at .../TravelItineraryReadRS/PriceQuote.
             * 
             * @return value
             */
            public Boolean getReturnExtendedPriceQuote() {
                return returnExtendedPriceQuote;
            }

            /** 
             * Set the 'returnExtendedPriceQuote' attribute value. Used to request extended price quote display in the service response. The extended content will be passed at .../TravelItineraryReadRS/PriceQuote.
             * 
             * @param returnExtendedPriceQuote
             */
            public void setReturnExtendedPriceQuote(
                    Boolean returnExtendedPriceQuote) {
                this.returnExtendedPriceQuote = returnExtendedPriceQuote;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EndTransactionRQ" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="EndTransaction" minOccurs="0">
         *         &lt;!-- Reference to inner class EndTransaction -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Source" minOccurs="0">
         *         &lt;!-- Reference to inner class Source -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="shouldCheckRefId"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class EndTransactionRQ implements Serializable
        {
            private EndTransaction endTransaction;
            private Source source;
            private Boolean shouldCheckRefId;

            /** 
             * Get the 'EndTransaction' element value.
             * 
             * @return value
             */
            public EndTransaction getEndTransaction() {
                return endTransaction;
            }

            /** 
             * Set the 'EndTransaction' element value.
             * 
             * @param endTransaction
             */
            public void setEndTransaction(EndTransaction endTransaction) {
                this.endTransaction = endTransaction;
            }

            /** 
             * Get the 'Source' element value.
             * 
             * @return value
             */
            public Source getSource() {
                return source;
            }

            /** 
             * Set the 'Source' element value.
             * 
             * @param source
             */
            public void setSource(Source source) {
                this.source = source;
            }

            /** 
             * Get the 'shouldCheckRefId' attribute value. "shouldCheckRefId" is used to indicate that API will verify whether the service response contains the record locator of the reservation. If the record locator is not returned, system will retry by means of sending another end transaction request this time without .../Source/@ReceivedFrom.
             * 
             * @return value
             */
            public Boolean getShouldCheckRefId() {
                return shouldCheckRefId;
            }

            /** 
             * Set the 'shouldCheckRefId' attribute value. "shouldCheckRefId" is used to indicate that API will verify whether the service response contains the record locator of the reservation. If the record locator is not returned, system will retry by means of sending another end transaction request this time without .../Source/@ReceivedFrom.
             * 
             * @param shouldCheckRefId
             */
            public void setShouldCheckRefId(Boolean shouldCheckRefId) {
                this.shouldCheckRefId = shouldCheckRefId;
            }
            /** 
             * Used to end the transaction and finalize the record.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EndTransaction" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Email" minOccurs="0">
             *         &lt;!-- Reference to inner class Email -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ScheduleChange" minOccurs="0">
             *         &lt;!-- Reference to inner class ScheduleChange -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EndTransaction implements Serializable
            {
                private Email email;
                private ScheduleChange scheduleChange;
                private boolean ind;

                /** 
                 * Get the 'Email' element value.
                 * 
                 * @return value
                 */
                public Email getEmail() {
                    return email;
                }

                /** 
                 * Set the 'Email' element value.
                 * 
                 * @param email
                 */
                public void setEmail(Email email) {
                    this.email = email;
                }

                /** 
                 * Get the 'ScheduleChange' element value.
                 * 
                 * @return value
                 */
                public ScheduleChange getScheduleChange() {
                    return scheduleChange;
                }

                /** 
                 * Set the 'ScheduleChange' element value.
                 * 
                 * @param scheduleChange
                 */
                public void setScheduleChange(ScheduleChange scheduleChange) {
                    this.scheduleChange = scheduleChange;
                }

                /** 
                 * Get the 'Ind' attribute value. Indicates whether the `E` host command should be sent or only the `6` (Source) host command.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Indicates whether the `E` host command should be sent or only the `6` (Source) host command.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * Used to send an email notification upon end transaction to any email addresses contained within the particular record.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Email" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="eTicket" minOccurs="0">
                 *         &lt;!-- Reference to inner class ETicket -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Invoice" minOccurs="0">
                 *         &lt;!-- Reference to inner class Invoice -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Itinerary" minOccurs="0">
                 *         &lt;!-- Reference to inner class Itinerary -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PersonName" minOccurs="0">
                 *         &lt;!-- Reference to inner class PersonName -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Email implements Serializable
                {
                    private ETicket ETicket;
                    private Invoice invoice;
                    private Itinerary itinerary;
                    private PersonName personName;
                    private boolean ind;

                    /** 
                     * Get the 'eTicket' element value.
                     * 
                     * @return value
                     */
                    public ETicket getETicket() {
                        return ETicket;
                    }

                    /** 
                     * Set the 'eTicket' element value.
                     * 
                     * @param eTicket
                     */
                    public void setETicket(ETicket eTicket) {
                        ETicket = eTicket;
                    }

                    /** 
                     * Get the 'Invoice' element value.
                     * 
                     * @return value
                     */
                    public Invoice getInvoice() {
                        return invoice;
                    }

                    /** 
                     * Set the 'Invoice' element value.
                     * 
                     * @param invoice
                     */
                    public void setInvoice(Invoice invoice) {
                        this.invoice = invoice;
                    }

                    /** 
                     * Get the 'Itinerary' element value.
                     * 
                     * @return value
                     */
                    public Itinerary getItinerary() {
                        return itinerary;
                    }

                    /** 
                     * Set the 'Itinerary' element value.
                     * 
                     * @param itinerary
                     */
                    public void setItinerary(Itinerary itinerary) {
                        this.itinerary = itinerary;
                    }

                    /** 
                     * Get the 'PersonName' element value.
                     * 
                     * @return value
                     */
                    public PersonName getPersonName() {
                        return personName;
                    }

                    /** 
                     * Set the 'PersonName' element value.
                     * 
                     * @param personName
                     */
                    public void setPersonName(PersonName personName) {
                        this.personName = personName;
                    }

                    /** 
                     * Get the 'Ind' attribute value. Enables the functionality when set to `true`.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Enables the functionality when set to `true`.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                    /** 
                     * Used to send an email notification containing a text-based copy of the eTicket.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="eTicket" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PDF" minOccurs="0">
                     *         &lt;!-- Reference to inner class PDF -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ETicket implements Serializable
                    {
                        private PDF PDF1;
                        private boolean ind;

                        /** 
                         * Get the 'PDF' element value.
                         * 
                         * @return value
                         */
                        public PDF getPDF1() {
                            return PDF1;
                        }

                        /** 
                         * Set the 'PDF' element value.
                         * 
                         * @param PDF1
                         */
                        public void setPDF1(PDF PDF1) {
                            this.PDF1 = PDF1;
                        }

                        /** 
                         * Get the 'Ind' attribute value. Enables the functionality when set to `true`.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Enables the functionality when set to `true`.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                        /** 
                         * Used to send an email notification containing a PDF-based copy of the eTicket.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PDF implements Serializable
                        {
                            private boolean ind;

                            /** 
                             * Get the 'Ind' attribute value. Enables the functionality when set to `true`.
                             * 
                             * @return value
                             */
                            public boolean isInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value. Enables the functionality when set to `true`.
                             * 
                             * @param ind
                             */
                            public void setInd(boolean ind) {
                                this.ind = ind;
                            }
                        }
                    }
                    /** 
                     * Used to send an email notification containing a text-based copy of the invoice.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Invoice implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value. Enables the functionality when set to `true`.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Enables the functionality when set to `true`.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Used to send an email notification containing a text-based copy of the itinerary.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Itinerary" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PDF" minOccurs="0">
                     *         &lt;!-- Reference to inner class PDF -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Segment -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Itinerary implements Serializable
                    {
                        private PDF PDF1;
                        private List<Segment> segmentList = new ArrayList<Segment>();
                        private boolean ind;

                        /** 
                         * Get the 'PDF' element value.
                         * 
                         * @return value
                         */
                        public PDF getPDF1() {
                            return PDF1;
                        }

                        /** 
                         * Set the 'PDF' element value.
                         * 
                         * @param PDF1
                         */
                        public void setPDF1(PDF PDF1) {
                            this.PDF1 = PDF1;
                        }

                        /** 
                         * Get the list of 'Segment' element items.
                         * 
                         * @return list
                         */
                        public List<Segment> getSegmentList() {
                            return segmentList;
                        }

                        /** 
                         * Set the list of 'Segment' element items.
                         * 
                         * @param list
                         */
                        public void setSegmentList(List<Segment> list) {
                            segmentList = list;
                        }

                        /** 
                         * Get the 'Ind' attribute value. Enables the functionality when set to `true`.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value. Enables the functionality when set to `true`.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                        /** 
                         * Used to send an email notification containing a PDF-based copy of the itinerary.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PDF implements Serializable
                        {
                            private boolean ind;

                            /** 
                             * Get the 'Ind' attribute value. Enables the functionality when set to `true`.
                             * 
                             * @return value
                             */
                            public boolean isInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value. Enables the functionality when set to `true`.
                             * 
                             * @param ind
                             */
                            public void setInd(boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:integer" name="EndNumber"/>
                         *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Segment implements Serializable
                        {
                            private BigInteger endNumber;
                            private BigInteger number;

                            /** 
                             * Get the 'EndNumber' attribute value. Used to specify an ending segment in the range to include in the email message.
                             * 
                             * @return value
                             */
                            public BigInteger getEndNumber() {
                                return endNumber;
                            }

                            /** 
                             * Set the 'EndNumber' attribute value. Used to specify an ending segment in the range to include in the email message.
                             * 
                             * @param endNumber
                             */
                            public void setEndNumber(BigInteger endNumber) {
                                this.endNumber = endNumber;
                            }

                            /** 
                             * Get the 'Number' attribute value. Used to specify a segment number to include in the email message.
                             * 
                             * @return value
                             */
                            public BigInteger getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value. Used to specify a segment number to include in the email message.
                             * 
                             * @param number
                             */
                            public void setNumber(BigInteger number) {
                                this.number = number;
                            }
                        }
                    }
                    /** 
                     * Used to specify a particular passenger name to send the email notification to.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PersonName implements Serializable
                    {
                        private String nameNumber;

                        /** 
                         * Get the 'NameNumber' attribute value. Used to specify a particular passenger name number to send the email notification to.
                                                                                                        Please note that the email address in the PNR`s email field must be name associated to the specified name number.
                         * 
                         * @return value
                         */
                        public String getNameNumber() {
                            return nameNumber;
                        }

                        /** 
                         * Set the 'NameNumber' attribute value. Used to specify a particular passenger name number to send the email notification to.
                                                                                                        Please note that the email address in the PNR`s email field must be name associated to the specified name number.
                         * 
                         * @param nameNumber
                         */
                        public void setNameNumber(String nameNumber) {
                            this.nameNumber = nameNumber;
                        }
                    }
                }
                /** 
                 * Used to update schedule changes.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ScheduleChange" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ScheduleChange implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value. The schedule change indicator.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. The schedule change indicator.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
            }
            /** 
             * Used to identify the entity that authorized the changes in a Passenger Name Record.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="ReceivedFrom"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Source implements Serializable
            {
                private String receivedFrom;

                /** 
                 * Get the 'ReceivedFrom' attribute value. Used to pass the source name.
                 * 
                 * @return value
                 */
                public String getReceivedFrom() {
                    return receivedFrom;
                }

                /** 
                 * Set the 'ReceivedFrom' attribute value. Used to pass the source name.
                 * 
                 * @param receivedFrom
                 */
                public void setReceivedFrom(String receivedFrom) {
                    this.receivedFrom = receivedFrom;
                }
            }
        }
        /** 
         * Used to request to place the newly created PNR on a queue.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueuePlaceRQ" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="MultiQueuePlace" minOccurs="0">
         *         &lt;!-- Reference to inner class MultiQueuePlace -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="QueueInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class QueueInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" name="NumResponses"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QueuePlaceRQ implements Serializable
        {
            private MultiQueuePlace multiQueuePlace;
            private QueueInfo queueInfo;
            private BigInteger numResponses;

            /** 
             * Get the 'MultiQueuePlace' element value.
             * 
             * @return value
             */
            public MultiQueuePlace getMultiQueuePlace() {
                return multiQueuePlace;
            }

            /** 
             * Set the 'MultiQueuePlace' element value.
             * 
             * @param multiQueuePlace
             */
            public void setMultiQueuePlace(MultiQueuePlace multiQueuePlace) {
                this.multiQueuePlace = multiQueuePlace;
            }

            /** 
             * Get the 'QueueInfo' element value.
             * 
             * @return value
             */
            public QueueInfo getQueueInfo() {
                return queueInfo;
            }

            /** 
             * Set the 'QueueInfo' element value.
             * 
             * @param queueInfo
             */
            public void setQueueInfo(QueueInfo queueInfo) {
                this.queueInfo = queueInfo;
            }

            /** 
             * Get the 'NumResponses' attribute value. Specifies the number of additional messages expected from host response.
             * 
             * @return value
             */
            public BigInteger getNumResponses() {
                return numResponses;
            }

            /** 
             * Set the 'NumResponses' attribute value. Specifies the number of additional messages expected from host response.
             * 
             * @param numResponses
             */
            public void setNumResponses(BigInteger numResponses) {
                this.numResponses = numResponses;
            }
            /** 
             * Used to request to place the newly created PNR on multiple queues.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiQueuePlace" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="QueueIdentifier" maxOccurs="20">
             *         &lt;!-- Reference to inner class QueueIdentifier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MultiQueuePlace implements Serializable
            {
                private List<QueueIdentifier> queueIdentifierList = new ArrayList<QueueIdentifier>();

                /** 
                 * Get the list of 'QueueIdentifier' element items.
                 * 
                 * @return list
                 */
                public List<QueueIdentifier> getQueueIdentifierList() {
                    return queueIdentifierList;
                }

                /** 
                 * Set the list of 'QueueIdentifier' element items.
                 * 
                 * @param list
                 */
                public void setQueueIdentifierList(List<QueueIdentifier> list) {
                    queueIdentifierList = list;
                }
                /** 
                 * Used to pass a single queue details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" maxOccurs="20">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PseudoCityCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class QueueIdentifier implements Serializable
                {
                    private String number;
                    private String prefatoryInstructionCode;
                    private String pseudoCityCode;

                    /** 
                     * Get the 'Number' attribute value. Used to pass the queue number.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Used to pass the queue number.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'PrefatoryInstructionCode' attribute value. Used to pass the prefatory instruction code (PIC).
                     * 
                     * @return value
                     */
                    public String getPrefatoryInstructionCode() {
                        return prefatoryInstructionCode;
                    }

                    /** 
                     * Set the 'PrefatoryInstructionCode' attribute value. Used to pass the prefatory instruction code (PIC).
                     * 
                     * @param prefatoryInstructionCode
                     */
                    public void setPrefatoryInstructionCode(
                            String prefatoryInstructionCode) {
                        this.prefatoryInstructionCode = prefatoryInstructionCode;
                    }

                    /** 
                     * Get the 'PseudoCityCode' attribute value. Used to pass the pseudo city code (PCC).
                     * 
                     * @return value
                     */
                    public String getPseudoCityCode() {
                        return pseudoCityCode;
                    }

                    /** 
                     * Set the 'PseudoCityCode' attribute value. Used to pass the pseudo city code (PCC).
                     * 
                     * @param pseudoCityCode
                     */
                    public void setPseudoCityCode(String pseudoCityCode) {
                        this.pseudoCityCode = pseudoCityCode;
                    }
                }
            }
            /** 
             * Used to request to place the newly created PNR on a single queue.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="QueueIdentifier" maxOccurs="10">
             *         &lt;!-- Reference to inner class QueueIdentifier -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="UniqueID" minOccurs="0" maxOccurs="6">
             *         &lt;!-- Reference to inner class UniqueID -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class QueueInfo implements Serializable
            {
                private List<QueueIdentifier> queueIdentifierList = new ArrayList<QueueIdentifier>();
                private List<UniqueID> uniqueIDList = new ArrayList<UniqueID>();

                /** 
                 * Get the list of 'QueueIdentifier' element items.
                 * 
                 * @return list
                 */
                public List<QueueIdentifier> getQueueIdentifierList() {
                    return queueIdentifierList;
                }

                /** 
                 * Set the list of 'QueueIdentifier' element items.
                 * 
                 * @param list
                 */
                public void setQueueIdentifierList(List<QueueIdentifier> list) {
                    queueIdentifierList = list;
                }

                /** 
                 * Get the list of 'UniqueID' element items.
                 * 
                 * @return list
                 */
                public List<UniqueID> getUniqueIDList() {
                    return uniqueIDList;
                }

                /** 
                 * Set the list of 'UniqueID' element items.
                 * 
                 * @param list
                 */
                public void setUniqueIDList(List<UniqueID> list) {
                    uniqueIDList = list;
                }
                /** 
                 * Used to pass a single queue details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" maxOccurs="10">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="Name"/>
                 *     &lt;xs:attribute type="xs:string" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" name="PrefatoryInstructionCode"/>
                 *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class QueueIdentifier implements Serializable
                {
                    private String name;
                    private String number;
                    private String prefatoryInstructionCode;
                    private String pseudoCityCode;

                    /** 
                     * Get the 'Name' attribute value. Used to specify the queue name where the record is to be placed.
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value. Used to specify the queue name where the record is to be placed.
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }

                    /** 
                     * Get the 'Number' attribute value. Used to specify the queue number where the record is to be placed.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Used to specify the queue number where the record is to be placed.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'PrefatoryInstructionCode' attribute value. Used to specify a prefatory instruction code.
                     * 
                     * @return value
                     */
                    public String getPrefatoryInstructionCode() {
                        return prefatoryInstructionCode;
                    }

                    /** 
                     * Set the 'PrefatoryInstructionCode' attribute value. Used to specify a prefatory instruction code.
                     * 
                     * @param prefatoryInstructionCode
                     */
                    public void setPrefatoryInstructionCode(
                            String prefatoryInstructionCode) {
                        this.prefatoryInstructionCode = prefatoryInstructionCode;
                    }

                    /** 
                     * Get the 'PseudoCityCode' attribute value. Used to specify a pseudo city code.
                     * 
                     * @return value
                     */
                    public String getPseudoCityCode() {
                        return pseudoCityCode;
                    }

                    /** 
                     * Set the 'PseudoCityCode' attribute value. Used to specify a pseudo city code.
                     * 
                     * @param pseudoCityCode
                     */
                    public void setPseudoCityCode(String pseudoCityCode) {
                        this.pseudoCityCode = pseudoCityCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID" minOccurs="0" maxOccurs="6">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ID"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class UniqueID implements Serializable
                {
                    private String ID;

                    /** 
                     * Get the 'ID' attribute value. Used to specify a record locator to be queue placed.
                     * 
                     * @return value
                     */
                    public String getID() {
                        return ID;
                    }

                    /** 
                     * Set the 'ID' attribute value. Used to specify a record locator to be queue placed.
                     * 
                     * @param ID
                     */
                    public void setID(String ID) {
                        this.ID = ID;
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreProcessing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="UniqueID" minOccurs="0">
     *         &lt;!-- Reference to inner class UniqueID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" name="ignoreBefore"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PreProcessing implements Serializable
    {
        private UniqueID uniqueID;
        private Boolean ignoreBefore;

        /** 
         * Get the 'UniqueID' element value.
         * 
         * @return value
         */
        public UniqueID getUniqueID() {
            return uniqueID;
        }

        /** 
         * Set the 'UniqueID' element value.
         * 
         * @param uniqueID
         */
        public void setUniqueID(UniqueID uniqueID) {
            this.uniqueID = uniqueID;
        }

        /** 
         * Get the 'ignoreBefore' attribute value. Used to perform an ignore to clear out the AAA.
                                                Please note that it does not close the session.
         * 
         * @return value
         */
        public Boolean getIgnoreBefore() {
            return ignoreBefore;
        }

        /** 
         * Set the 'ignoreBefore' attribute value. Used to perform an ignore to clear out the AAA.
                                                Please note that it does not close the session.
         * 
         * @param ignoreBefore
         */
        public void setIgnoreBefore(Boolean ignoreBefore) {
            this.ignoreBefore = ignoreBefore;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="id"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UniqueID implements Serializable
        {
            private String id;

            /** 
             * Get the 'id' attribute value. Used to specify a record locator.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'id' attribute value. Used to specify a record locator.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }
        }
    }
    /** 
     * Used to associate price quote records stored as a result of a previous Enhanced_AirBookRQ, or Enhanced_AirBookWithTaxRQ with passenger names in the PassengerDetailsRQ.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Link" maxOccurs="98">
     *         &lt;!-- Reference to inner class Link -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PriceQuoteInfo implements Serializable
    {
        private List<Link> linkList = new ArrayList<Link>();

        /** 
         * Get the list of 'Link' element items.
         * 
         * @return list
         */
        public List<Link> getLinkList() {
            return linkList;
        }

        /** 
         * Set the list of 'Link' element items.
         * 
         * @param list
         */
        public void setLinkList(List<Link> list) {
            linkList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Link" maxOccurs="98">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="hostedCarrier"/>
         *     &lt;xs:attribute type="xs:string" name="nameNumber"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="record"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Link implements Serializable
        {
            private Boolean hostedCarrier;
            private String nameNumber;
            private String record;

            /** 
             * Get the 'hostedCarrier' attribute value. Used to tell the system that the request is coming from a hosted carrier, since the method of linking price quote records to names is slightly different between SabreSonic-hosted carriers, and Sabre Travel Network-based users.
             * 
             * @return value
             */
            public Boolean getHostedCarrier() {
                return hostedCarrier;
            }

            /** 
             * Set the 'hostedCarrier' attribute value. Used to tell the system that the request is coming from a hosted carrier, since the method of linking price quote records to names is slightly different between SabreSonic-hosted carriers, and Sabre Travel Network-based users.
             * 
             * @param hostedCarrier
             */
            public void setHostedCarrier(Boolean hostedCarrier) {
                this.hostedCarrier = hostedCarrier;
            }

            /** 
             * Get the 'nameNumber' attribute value. Used to specify a passenger name number.
                                                              SabreSonic-hosted carriers can omit `NameNumber` if all passengers need to be associated with a single price quote record.
                                                              Sabre Travel Network-based users:
                                                              If you want to associate all passengers with a single price quote record omit the `NameNumber` attribute.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'nameNumber' attribute value. Used to specify a passenger name number.
                                                              SabreSonic-hosted carriers can omit `NameNumber` if all passengers need to be associated with a single price quote record.
                                                              Sabre Travel Network-based users:
                                                              If you want to associate all passengers with a single price quote record omit the `NameNumber` attribute.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }

            /** 
             * Get the 'record' attribute value. Used to specify a price quote record.
             * 
             * @return value
             */
            public String getRecord() {
                return record;
            }

            /** 
             * Set the 'record' attribute value. Used to specify a price quote record.
             * 
             * @param record
             */
            public void setRecord(String record) {
                this.record = record;
            }
        }
    }
    /** 
     * Used to add profile information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileRQ" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="UniqueID">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="id"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProfileRQ implements Serializable
    {
        private String uniqueID;

        /** 
         * Get the 'id' attribute value. Used to specify a profile name that is to be moved into the AAA to create the PNR.
         * 
         * @return value
         */
        public String getUniqueID() {
            return uniqueID;
        }

        /** 
         * Set the 'id' attribute value. Used to specify a profile name that is to be moved into the AAA to create the PNR.
         * 
         * @param uniqueID
         */
        public void setUniqueID(String uniqueID) {
            this.uniqueID = uniqueID;
        }
    }
    /** 
     * Used to add additional special requests such as seats, remarks, SSRs.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialReqDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AddRemarkRQ" minOccurs="0">
     *         &lt;!-- Reference to inner class AddRemarkRQ -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AirSeatRQ" minOccurs="0">
     *         &lt;!-- Reference to inner class AirSeatRQ -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SpecialServiceRQ" minOccurs="0">
     *         &lt;!-- Reference to inner class SpecialServiceRQ -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpecialReqDetails implements Serializable
    {
        private AddRemarkRQ addRemarkRQ;
        private AirSeatRQ airSeatRQ;
        private SpecialServiceRQ specialServiceRQ;

        /** 
         * Get the 'AddRemarkRQ' element value.
         * 
         * @return value
         */
        public AddRemarkRQ getAddRemarkRQ() {
            return addRemarkRQ;
        }

        /** 
         * Set the 'AddRemarkRQ' element value.
         * 
         * @param addRemarkRQ
         */
        public void setAddRemarkRQ(AddRemarkRQ addRemarkRQ) {
            this.addRemarkRQ = addRemarkRQ;
        }

        /** 
         * Get the 'AirSeatRQ' element value.
         * 
         * @return value
         */
        public AirSeatRQ getAirSeatRQ() {
            return airSeatRQ;
        }

        /** 
         * Set the 'AirSeatRQ' element value.
         * 
         * @param airSeatRQ
         */
        public void setAirSeatRQ(AirSeatRQ airSeatRQ) {
            this.airSeatRQ = airSeatRQ;
        }

        /** 
         * Get the 'SpecialServiceRQ' element value.
         * 
         * @return value
         */
        public SpecialServiceRQ getSpecialServiceRQ() {
            return specialServiceRQ;
        }

        /** 
         * Set the 'SpecialServiceRQ' element value.
         * 
         * @param specialServiceRQ
         */
        public void setSpecialServiceRQ(SpecialServiceRQ specialServiceRQ) {
            this.specialServiceRQ = specialServiceRQ;
        }
        /** 
         * Used to add remarks.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddRemarkRQ" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RemarkInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="FOP_Remark" minOccurs="0" maxOccurs="10">
         *               &lt;!-- Reference to inner class FOPRemark -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="FOP_Remark_Association" minOccurs="0" maxOccurs="99">
         *               &lt;!-- Reference to inner class FOPRemarkAssociation -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="FutureQueuePlaceRemark" minOccurs="0">
         *               &lt;!-- Reference to inner class FutureQueuePlaceRemark -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="Remark" minOccurs="0" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class Remark -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AddRemarkRQ implements Serializable
        {
            private List<FOPRemark> FOPRemarkList = new ArrayList<FOPRemark>();
            private List<FOPRemarkAssociation> FOPRemarkAssociationList = new ArrayList<FOPRemarkAssociation>();
            private FutureQueuePlaceRemark futureQueuePlaceRemark;
            private List<Remark> remarkList = new ArrayList<Remark>();

            /** 
             * Get the list of 'FOP_Remark' element items. Used to add details of the remark.
             * 
             * @return list
             */
            public List<FOPRemark> getFOPRemarkList() {
                return FOPRemarkList;
            }

            /** 
             * Set the list of 'FOP_Remark' element items. Used to add details of the remark.
             * 
             * @param list
             */
            public void setFOPRemarkList(List<FOPRemark> list) {
                FOPRemarkList = list;
            }

            /** 
             * Get the list of 'FOP_Remark_Association' element items. Used to add details of the remark.
             * 
             * @return list
             */
            public List<FOPRemarkAssociation> getFOPRemarkAssociationList() {
                return FOPRemarkAssociationList;
            }

            /** 
             * Set the list of 'FOP_Remark_Association' element items. Used to add details of the remark.
             * 
             * @param list
             */
            public void setFOPRemarkAssociationList(
                    List<FOPRemarkAssociation> list) {
                FOPRemarkAssociationList = list;
            }

            /** 
             * Get the 'FutureQueuePlaceRemark' element value. Used to add details of the remark.
             * 
             * @return value
             */
            public FutureQueuePlaceRemark getFutureQueuePlaceRemark() {
                return futureQueuePlaceRemark;
            }

            /** 
             * Set the 'FutureQueuePlaceRemark' element value. Used to add details of the remark.
             * 
             * @param futureQueuePlaceRemark
             */
            public void setFutureQueuePlaceRemark(
                    FutureQueuePlaceRemark futureQueuePlaceRemark) {
                this.futureQueuePlaceRemark = futureQueuePlaceRemark;
            }

            /** 
             * Get the list of 'Remark' element items. Used to add details of the remark.
             * 
             * @return list
             */
            public List<Remark> getRemarkList() {
                return remarkList;
            }

            /** 
             * Set the list of 'Remark' element items. Used to add details of the remark.
             * 
             * @param list
             */
            public void setRemarkList(List<Remark> list) {
                remarkList = list;
            }
            /** 
             * Used to add a form of payment remark.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Remark" minOccurs="0" maxOccurs="10">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CC_Info" minOccurs="0">
             *         &lt;!-- Reference to inner class CCInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="Type"/>
             *     &lt;xs:attribute type="xs:integer" name="temporaryId"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FOPRemark implements Serializable
            {
                private CCInfo CCInfo1;
                private String type;
                private BigInteger temporaryId;

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo getCCInfo1() {
                    return CCInfo1;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCInfo1
                 */
                public void setCCInfo1(CCInfo CCInfo1) {
                    this.CCInfo1 = CCInfo1;
                }

                /** 
                 * Get the 'Type' attribute value. Used to specify the form of payment type.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify the form of payment type.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'temporaryId' attribute value. Used to provide an FOP association identifier. The value must match .../SpecialReqDetails/AddRemarkRQ/RemarkInfo/FOP_Remark_Association/Association_Info/Child/@temporaryId and is only used when a FOP remark is added together with its association during a single API call.
                 * 
                 * @return value
                 */
                public BigInteger getTemporaryId() {
                    return temporaryId;
                }

                /** 
                 * Set the 'temporaryId' attribute value. Used to provide an FOP association identifier. The value must match .../SpecialReqDetails/AddRemarkRQ/RemarkInfo/FOP_Remark_Association/Association_Info/Child/@temporaryId and is only used when a FOP remark is added together with its association during a single API call.
                 * 
                 * @param temporaryId
                 */
                public void setTemporaryId(BigInteger temporaryId) {
                    this.temporaryId = temporaryId;
                }
                /** 
                 * Used to add credit card details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" name="AirlineCode"/>
                 *           &lt;xs:attribute type="xs:string" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:string" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *           &lt;xs:attribute type="xs:boolean" name="SuppressApprovalCode"/>
                 *           &lt;xs:attribute type="xs:boolean" default="false" name="GenerateApprovalAtTicketing"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CardHolderName" minOccurs="0">
                 *         &lt;!-- Reference to inner class CardHolderName -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardAirlineCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardCode;
                    private String paymentCardExpireDate;
                    private String paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardNumber;
                    private Boolean paymentCardSuppressApprovalCode;
                    private Boolean paymentCardGenerateApprovalAtTicketing;
                    private CardHolderName cardHolderName;
                    private Boolean suppress;

                    /** 
                     * Get the 'AirlineCode' attribute value. Used to specify an airline code to be used in conjunction with a credit card security code.
                     * 
                     * @return value
                     */
                    public String getPaymentCardAirlineCode() {
                        return paymentCardAirlineCode;
                    }

                    /** 
                     * Set the 'AirlineCode' attribute value. Used to specify an airline code to be used in conjunction with a credit card security code.
                     * 
                     * @param paymentCardAirlineCode
                     */
                    public void setPaymentCardAirlineCode(
                            String paymentCardAirlineCode) {
                        this.paymentCardAirlineCode = paymentCardAirlineCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value. Used to specify a credit card security code.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value. Used to specify a credit card security code.
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'Code' attribute value. Used to specify a credit card vendor code.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value. Used to specify a credit card vendor code.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value. Used to specify a credit card expiration date.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value. Used to specify a credit card expiration date.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value. Used to define the number of months for extended payment.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value. Used to define the number of months for extended payment.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            String paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value. Used to pass a manual credit card approval code.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value. Used to pass a manual credit card approval code.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'Number' attribute value. Used to specify a credit card number.
                     * 
                     * @return value
                     */
                    public String getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value. Used to specify a credit card number.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(String paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'SuppressApprovalCode' attribute value. Used to specify to prevent the Sabre system from generating an approval code when the credit card number is input into the system.
                     * 
                     * @return value
                     */
                    public Boolean getPaymentCardSuppressApprovalCode() {
                        return paymentCardSuppressApprovalCode;
                    }

                    /** 
                     * Set the 'SuppressApprovalCode' attribute value. Used to specify to prevent the Sabre system from generating an approval code when the credit card number is input into the system.
                     * 
                     * @param paymentCardSuppressApprovalCode
                     */
                    public void setPaymentCardSuppressApprovalCode(
                            Boolean paymentCardSuppressApprovalCode) {
                        this.paymentCardSuppressApprovalCode = paymentCardSuppressApprovalCode;
                    }

                    /** 
                     * Get the 'GenerateApprovalAtTicketing' attribute value. Used to generate ticketing approval code upon adding new form of payment information.
                     * 
                     * @return value
                     */
                    public Boolean getPaymentCardGenerateApprovalAtTicketing() {
                        return paymentCardGenerateApprovalAtTicketing;
                    }

                    /** 
                     * Set the 'GenerateApprovalAtTicketing' attribute value. Used to generate ticketing approval code upon adding new form of payment information.
                     * 
                     * @param paymentCardGenerateApprovalAtTicketing
                     */
                    public void setPaymentCardGenerateApprovalAtTicketing(
                            Boolean paymentCardGenerateApprovalAtTicketing) {
                        this.paymentCardGenerateApprovalAtTicketing = paymentCardGenerateApprovalAtTicketing;
                    }

                    /** 
                     * Get the 'CardHolderName' element value.
                     * 
                     * @return value
                     */
                    public CardHolderName getCardHolderName() {
                        return cardHolderName;
                    }

                    /** 
                     * Set the 'CardHolderName' element value.
                     * 
                     * @param cardHolderName
                     */
                    public void setCardHolderName(CardHolderName cardHolderName) {
                        this.cardHolderName = cardHolderName;
                    }

                    /** 
                     * Get the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value. Used to specify whether or not to suppress credit card information on an itinerary.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                    /** 
                     * Used to specify payment cardholder names.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolderName" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CardHolderName implements Serializable
                    {
                        private String givenName;
                        private String surname;

                        /** 
                         * Get the 'GivenName' element value. Used to specify a credit card holder given name.
                         * 
                         * @return value
                         */
                        public String getGivenName() {
                            return givenName;
                        }

                        /** 
                         * Set the 'GivenName' element value. Used to specify a credit card holder given name.
                         * 
                         * @param givenName
                         */
                        public void setGivenName(String givenName) {
                            this.givenName = givenName;
                        }

                        /** 
                         * Get the 'Surname' element value. Used to specify a credit card holder surname.
                         * 
                         * @return value
                         */
                        public String getSurname() {
                            return surname;
                        }

                        /** 
                         * Set the 'Surname' element value. Used to specify a credit card holder surname.
                         * 
                         * @param surname
                         */
                        public void setSurname(String surname) {
                            this.surname = surname;
                        }
                    }
                }
            }
            /** 
             * Used to associate a newly added (by means of .../SpecialReqDetails/AddRemarkRQ/RemarkInfo/FOP_Remark) or existing form of payment to its specific use type(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Remark_Association" minOccurs="0" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Parent" minOccurs="0" maxOccurs="99">
             *         &lt;!-- Reference to inner class Parent -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Child" minOccurs="0" maxOccurs="99">
             *         &lt;!-- Reference to inner class Child -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FOPRemarkAssociation implements Serializable
            {
                private List<Parent> parentList = new ArrayList<Parent>();
                private List<Child> childList = new ArrayList<Child>();

                /** 
                 * Get the list of 'Parent' element items.
                 * 
                 * @return list
                 */
                public List<Parent> getParentList() {
                    return parentList;
                }

                /** 
                 * Set the list of 'Parent' element items.
                 * 
                 * @param list
                 */
                public void setParentList(List<Parent> list) {
                    parentList = list;
                }

                /** 
                 * Get the list of 'Child' element items.
                 * 
                 * @return list
                 */
                public List<Child> getChildList() {
                    return childList;
                }

                /** 
                 * Set the list of 'Child' element items.
                 * 
                 * @param list
                 */
                public void setChildList(List<Child> list) {
                    childList = list;
                }
                /** 
                 * Used to identify an existing 'parent' form of payment remark.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parent" minOccurs="0" maxOccurs="99">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" name="displayIndex"/>
                 *     &lt;xs:attribute name="referenceType">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class ReferenceType -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Parent implements Serializable
                {
                    private BigInteger displayIndex;
                    private ReferenceType referenceType;

                    /** 
                     * Get the 'displayIndex' attribute value. Used to identify an existing 'parent' form of payment remark. The value should be taken from .../TravelItineraryReadRS/TravelItinerary/OpenReservationElements/OpenReservationElement/@displayIndex.
                     * 
                     * @return value
                     */
                    public BigInteger getDisplayIndex() {
                        return displayIndex;
                    }

                    /** 
                     * Set the 'displayIndex' attribute value. Used to identify an existing 'parent' form of payment remark. The value should be taken from .../TravelItineraryReadRS/TravelItinerary/OpenReservationElements/OpenReservationElement/@displayIndex.
                     * 
                     * @param displayIndex
                     */
                    public void setDisplayIndex(BigInteger displayIndex) {
                        this.displayIndex = displayIndex;
                    }

                    /** 
                     * Get the 'referenceType' attribute value. It is the LREC Uky or index/sequence number of the item being associated to.
                     * 
                     * @return value
                     */
                    public ReferenceType getReferenceType() {
                        return referenceType;
                    }

                    /** 
                     * Set the 'referenceType' attribute value. It is the LREC Uky or index/sequence number of the item being associated to.
                     * 
                     * @param referenceType
                     */
                    public void setReferenceType(ReferenceType referenceType) {
                        this.referenceType = referenceType;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:string">
                     *     &lt;xs:enumeration value="Index"/>
                     *     &lt;xs:enumeration value="UkyId"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum ReferenceType implements Serializable {
                        INDEX("Index"), UKY_ID("UkyId");
                        private final String value;

                        private ReferenceType(String value) {
                            this.value = value;
                        }

                        public String xmlValue() {
                            return value;
                        }

                        public static ReferenceType convert(String value) {
                            for (ReferenceType inst : values()) {
                                if (inst.xmlValue().equals(value)) {
                                    return inst;
                                }
                            }
                            return null;
                        }
                    }
                }
                /** 
                 * Used to define form of payment use types to be associated to either a parent (stored form of payment) or a newly added form of payment remark
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Child" minOccurs="0" maxOccurs="99">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" name="temporaryId"/>
                 *     &lt;xs:attribute name="useType">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class UseType -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Child implements Serializable
                {
                    private BigInteger temporaryId;
                    private UseType useType;

                    /** 
                     * Get the 'temporaryId' attribute value. Used to provide an FOP association identifier. The value must match .../SpecialReqDetails/AddRemarkRQ/RemarkInfo/FOP_Remark/@temporaryId and is only used when a FOP remark is added together with its association during a single API call.
                     * 
                     * @return value
                     */
                    public BigInteger getTemporaryId() {
                        return temporaryId;
                    }

                    /** 
                     * Set the 'temporaryId' attribute value. Used to provide an FOP association identifier. The value must match .../SpecialReqDetails/AddRemarkRQ/RemarkInfo/FOP_Remark/@temporaryId and is only used when a FOP remark is added together with its association during a single API call.
                     * 
                     * @param temporaryId
                     */
                    public void setTemporaryId(BigInteger temporaryId) {
                        this.temporaryId = temporaryId;
                    }

                    /** 
                     * Get the 'useType' attribute value. Used to associate one or more use types to a form of payment.
                                                                                                      Valid use types are:
                                                                                                      "AZ" - All,
                                                                                                      "AN" - Ancillary,
                                                                                                      "AL" - Airline,
                                                                                                      "BU" - Bus/Ground Transportation,
                                                                                                      "CR" - Car,
                                                                                                      "CS" - Cruise,
                                                                                                      "HL" - Hotel,
                                                                                                      "IN" - Insurance,
                                                                                                      "LC" - Low-Cost Carrier,
                                                                                                      "OT" - Other,
                                                                                                      "RL" - Rail,
                                                                                                      "SS" - Specialty Service",
                                                                                                      "TR" - Tour,
                                                                                                      "IR" - Interface Record.
                     * 
                     * @return value
                     */
                    public UseType getUseType() {
                        return useType;
                    }

                    /** 
                     * Set the 'useType' attribute value. Used to associate one or more use types to a form of payment.
                                                                                                      Valid use types are:
                                                                                                      "AZ" - All,
                                                                                                      "AN" - Ancillary,
                                                                                                      "AL" - Airline,
                                                                                                      "BU" - Bus/Ground Transportation,
                                                                                                      "CR" - Car,
                                                                                                      "CS" - Cruise,
                                                                                                      "HL" - Hotel,
                                                                                                      "IN" - Insurance,
                                                                                                      "LC" - Low-Cost Carrier,
                                                                                                      "OT" - Other,
                                                                                                      "RL" - Rail,
                                                                                                      "SS" - Specialty Service",
                                                                                                      "TR" - Tour,
                                                                                                      "IR" - Interface Record.
                     * 
                     * @param useType
                     */
                    public void setUseType(UseType useType) {
                        this.useType = useType;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:string">
                     *     &lt;xs:enumeration value="AZ"/>
                     *     &lt;xs:enumeration value="AN"/>
                     *     &lt;xs:enumeration value="AL"/>
                     *     &lt;xs:enumeration value="BU"/>
                     *     &lt;xs:enumeration value="CR"/>
                     *     &lt;xs:enumeration value="CS"/>
                     *     &lt;xs:enumeration value="HL"/>
                     *     &lt;xs:enumeration value="IN"/>
                     *     &lt;xs:enumeration value="LC"/>
                     *     &lt;xs:enumeration value="OT"/>
                     *     &lt;xs:enumeration value="RL"/>
                     *     &lt;xs:enumeration value="SS"/>
                     *     &lt;xs:enumeration value="TR"/>
                     *     &lt;xs:enumeration value="IR"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum UseType implements Serializable {
                        AZ, AN, AL, BU, CR, CS, HL, IN, LC, OT, RL, SS, TR, IR
                    }
                }
            }
            /** 
             * Used to send a future queue place remark.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FutureQueuePlaceRemark" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Date"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
             *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="QueueIdentifier"/>
             *     &lt;xs:attribute type="xs:string" name="Time"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FutureQueuePlaceRemark implements Serializable
            {
                private String date;
                private String prefatoryInstructionCode;
                private String pseudoCityCode;
                private String queueIdentifier;
                private String time;

                /** 
                 * Get the 'Date' attribute value. Used to specify a queue placement date.
                 * 
                 * @return value
                 */
                public String getDate() {
                    return date;
                }

                /** 
                 * Set the 'Date' attribute value. Used to specify a queue placement date.
                 * 
                 * @param date
                 */
                public void setDate(String date) {
                    this.date = date;
                }

                /** 
                 * Get the 'PrefatoryInstructionCode' attribute value. Used to specify the prefatory instruction code.
                 * 
                 * @return value
                 */
                public String getPrefatoryInstructionCode() {
                    return prefatoryInstructionCode;
                }

                /** 
                 * Set the 'PrefatoryInstructionCode' attribute value. Used to specify the prefatory instruction code.
                 * 
                 * @param prefatoryInstructionCode
                 */
                public void setPrefatoryInstructionCode(
                        String prefatoryInstructionCode) {
                    this.prefatoryInstructionCode = prefatoryInstructionCode;
                }

                /** 
                 * Get the 'PseudoCityCode' attribute value. Used to specify a pseudo city code.
                 * 
                 * @return value
                 */
                public String getPseudoCityCode() {
                    return pseudoCityCode;
                }

                /** 
                 * Set the 'PseudoCityCode' attribute value. Used to specify a pseudo city code.
                 * 
                 * @param pseudoCityCode
                 */
                public void setPseudoCityCode(String pseudoCityCode) {
                    this.pseudoCityCode = pseudoCityCode;
                }

                /** 
                 * Get the 'QueueIdentifier' attribute value. Used to specify a queue name/number.
                 * 
                 * @return value
                 */
                public String getQueueIdentifier() {
                    return queueIdentifier;
                }

                /** 
                 * Set the 'QueueIdentifier' attribute value. Used to specify a queue name/number.
                 * 
                 * @param queueIdentifier
                 */
                public void setQueueIdentifier(String queueIdentifier) {
                    this.queueIdentifier = queueIdentifier;
                }

                /** 
                 * Get the 'Time' attribute value. Used to specify a queue placement time.
                                                                                        Please note that only whole hours can be specified, i.e. 12:00.
                 * 
                 * @return value
                 */
                public String getTime() {
                    return time;
                }

                /** 
                 * Set the 'Time' attribute value. Used to specify a queue placement time.
                                                                                        Please note that only whole hours can be specified, i.e. 12:00.
                 * 
                 * @param time
                 */
                public void setTime(String time) {
                    this.time = time;
                }
            }
            /** 
             * Used for multiple remark types.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="Code"/>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *     &lt;xs:attribute use="required" name="Type">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Type -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Remark implements Serializable
            {
                private String text;
                private String code;
                private String segmentNumber;
                private Type type;

                /** 
                 * Get the 'Text' element value. Used to specify remark-related text.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Used to specify remark-related text.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Code' attribute value. Used to specify an alpha sorting character such as: `H`.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Used to specify an alpha sorting character such as: `H`.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify a segment number.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify a segment number.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'Type' attribute value. Used to specify the type of remark.
                                                                                        Acceptable values are:
                                                                                        Alpha-Coded,
                                                                                        Client Address,
                                                                                        Corporate,
                                                                                        Delivery Address,
                                                                                        General,
                                                                                        Group Name,
                                                                                        Hidden,
                                                                                        Historical,
                                                                                        Invoice,
                                                                                        Itinerary.
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify the type of remark.
                                                                                        Acceptable values are:
                                                                                        Alpha-Coded,
                                                                                        Client Address,
                                                                                        Corporate,
                                                                                        Delivery Address,
                                                                                        General,
                                                                                        Group Name,
                                                                                        Hidden,
                                                                                        Historical,
                                                                                        Invoice,
                                                                                        Itinerary.
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="Alpha-Coded"/>
                 *     &lt;xs:enumeration value="Client Address"/>
                 *     &lt;xs:enumeration value="Corporate"/>
                 *     &lt;xs:enumeration value="Delivery Address"/>
                 *     &lt;xs:enumeration value="General"/>
                 *     &lt;xs:enumeration value="Group Name"/>
                 *     &lt;xs:enumeration value="Hidden"/>
                 *     &lt;xs:enumeration value="Historical"/>
                 *     &lt;xs:enumeration value="Invoice"/>
                 *     &lt;xs:enumeration value="Itinerary"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    ALPHA_CODED("Alpha-Coded"), CLIENT_ADDRESS("Client Address"), CORPORATE(
                            "Corporate"), DELIVERY_ADDRESS("Delivery Address"), GENERAL(
                            "General"), GROUP_NAME("Group Name"), HIDDEN(
                            "Hidden"), HISTORICAL("Historical"), INVOICE(
                            "Invoice"), ITINERARY("Itinerary");
                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static Type convert(String value) {
                        for (Type inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
        }
        /** 
         * Used to book seats.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirSeatRQ" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Seats">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="Seat" maxOccurs="98">
         *               &lt;!-- Reference to inner class Seat -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirSeatRQ implements Serializable
        {
            private List<Seat> seatList = new ArrayList<Seat>();

            /** 
             * Get the list of 'Seat' element items. Used to pass seat details.
             * 
             * @return list
             */
            public List<Seat> getSeatList() {
                return seatList;
            }

            /** 
             * Set the list of 'Seat' element items. Used to pass seat details.
             * 
             * @param list
             */
            public void setSeatList(List<Seat> list) {
                seatList = list;
            }
            /** 
             * Used for a single seat request.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat" maxOccurs="98">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" name="BoardingPass"/>
             *     &lt;xs:attribute type="xs:boolean" name="ChangeOfGauge"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" name="Number"/>
             *     &lt;xs:attribute type="xs:string" name="Preference"/>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Seat implements Serializable
            {
                private Boolean boardingPass;
                private Boolean changeOfGauge;
                private String nameNumber;
                private String number;
                private String preference;
                private String segmentNumber;

                /** 
                 * Get the 'BoardingPass' attribute value. Used to specify for the system to assign a seat and issue a boarding pass.
                 * 
                 * @return value
                 */
                public Boolean getBoardingPass() {
                    return boardingPass;
                }

                /** 
                 * Set the 'BoardingPass' attribute value. Used to specify for the system to assign a seat and issue a boarding pass.
                 * 
                 * @param boardingPass
                 */
                public void setBoardingPass(Boolean boardingPass) {
                    this.boardingPass = boardingPass;
                }

                /** 
                 * Get the 'ChangeOfGauge' attribute value. Used to specify a change of gauge of flight.
                 * 
                 * @return value
                 */
                public Boolean getChangeOfGauge() {
                    return changeOfGauge;
                }

                /** 
                 * Set the 'ChangeOfGauge' attribute value. Used to specify a change of gauge of flight.
                 * 
                 * @param changeOfGauge
                 */
                public void setChangeOfGauge(Boolean changeOfGauge) {
                    this.changeOfGauge = changeOfGauge;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'Number' attribute value. Used to specify a seat number.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. Used to specify a seat number.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'Preference' attribute value. Used to specify a seat preference.
                                                                                        Preference cannot combine with Number.
                 * 
                 * @return value
                 */
                public String getPreference() {
                    return preference;
                }

                /** 
                 * Set the 'Preference' attribute value. Used to specify a seat preference.
                                                                                        Preference cannot combine with Number.
                 * 
                 * @param preference
                 */
                public void setPreference(String preference) {
                    this.preference = preference;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify a segment number.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify a segment number.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }
            }
        }
        /** 
         * Used to add SSRs.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceRQ" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SpecialServiceInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AdvancePassenger" minOccurs="0" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class AdvancePassenger -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="SecureFlight" minOccurs="0" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class SecureFlight -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="Service" minOccurs="0" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class Service -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialServiceRQ implements Serializable
        {
            private List<AdvancePassenger> advancePassengerList = new ArrayList<AdvancePassenger>();
            private List<SecureFlight> secureFlightList = new ArrayList<SecureFlight>();
            private List<Service> serviceList = new ArrayList<Service>();

            /** 
             * Get the list of 'AdvancePassenger' element items. Used to pass SSR details.
             * 
             * @return list
             */
            public List<AdvancePassenger> getAdvancePassengerList() {
                return advancePassengerList;
            }

            /** 
             * Set the list of 'AdvancePassenger' element items. Used to pass SSR details.
             * 
             * @param list
             */
            public void setAdvancePassengerList(List<AdvancePassenger> list) {
                advancePassengerList = list;
            }

            /** 
             * Get the list of 'SecureFlight' element items. Used to pass SSR details.
             * 
             * @return list
             */
            public List<SecureFlight> getSecureFlightList() {
                return secureFlightList;
            }

            /** 
             * Set the list of 'SecureFlight' element items. Used to pass SSR details.
             * 
             * @param list
             */
            public void setSecureFlightList(List<SecureFlight> list) {
                secureFlightList = list;
            }

            /** 
             * Get the list of 'Service' element items. Used to pass SSR details.
             * 
             * @return list
             */
            public List<Service> getServiceList() {
                return serviceList;
            }

            /** 
             * Set the list of 'Service' element items. Used to pass SSR details.
             * 
             * @param list
             */
            public void setServiceList(List<Service> list) {
                serviceList = list;
            }
            /** 
             * Used to specify the APIS (Advance Passenger Information).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvancePassenger" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Document" minOccurs="0">
             *         &lt;!-- Reference to inner class Document -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PersonName" minOccurs="0">
             *         &lt;!-- Reference to inner class PersonName -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ResidentDestinationAddress" minOccurs="0">
             *         &lt;!-- Reference to inner class ResidentDestinationAddress -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AdvancePassenger implements Serializable
            {
                private Document document;
                private PersonName personName;
                private ResidentDestinationAddress residentDestinationAddress;
                private VendorPrefs vendorPrefs;
                private String segmentNumber;

                /** 
                 * Get the 'Document' element value.
                 * 
                 * @return value
                 */
                public Document getDocument() {
                    return document;
                }

                /** 
                 * Set the 'Document' element value.
                 * 
                 * @param document
                 */
                public void setDocument(Document document) {
                    this.document = document;
                }

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonName getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonName personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'ResidentDestinationAddress' element value.
                 * 
                 * @return value
                 */
                public ResidentDestinationAddress getResidentDestinationAddress() {
                    return residentDestinationAddress;
                }

                /** 
                 * Set the 'ResidentDestinationAddress' element value.
                 * 
                 * @param residentDestinationAddress
                 */
                public void setResidentDestinationAddress(
                        ResidentDestinationAddress residentDestinationAddress) {
                    this.residentDestinationAddress = residentDestinationAddress;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.
                                                                                        `A` can be specified to associate the SSR to all segments.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.
                                                                                        `A` can be specified to associate the SSR to all segments.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }
                /** 
                 * Used to specify document details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Document" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="IssueCountry" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="NationalityCountry" minOccurs="0"/>
                 *       &lt;xs:element name="Visa" minOccurs="0">
                 *         &lt;!-- Reference to inner class Visa -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:date" name="ExpirationDate"/>
                 *     &lt;xs:attribute type="xs:string" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Document implements Serializable
                {
                    private String issueCountry;
                    private String nationalityCountry;
                    private Visa visa;
                    private Date expirationDate;
                    private String number;
                    private String type;

                    /** 
                     * Get the 'IssueCountry' element value. Used to pass the document country of issue.
                     * 
                     * @return value
                     */
                    public String getIssueCountry() {
                        return issueCountry;
                    }

                    /** 
                     * Set the 'IssueCountry' element value. Used to pass the document country of issue.
                     * 
                     * @param issueCountry
                     */
                    public void setIssueCountry(String issueCountry) {
                        this.issueCountry = issueCountry;
                    }

                    /** 
                     * Get the 'NationalityCountry' element value. Used to pass the document nationality country.
                     * 
                     * @return value
                     */
                    public String getNationalityCountry() {
                        return nationalityCountry;
                    }

                    /** 
                     * Set the 'NationalityCountry' element value. Used to pass the document nationality country.
                     * 
                     * @param nationalityCountry
                     */
                    public void setNationalityCountry(String nationalityCountry) {
                        this.nationalityCountry = nationalityCountry;
                    }

                    /** 
                     * Get the 'Visa' element value.
                     * 
                     * @return value
                     */
                    public Visa getVisa() {
                        return visa;
                    }

                    /** 
                     * Set the 'Visa' element value.
                     * 
                     * @param visa
                     */
                    public void setVisa(Visa visa) {
                        this.visa = visa;
                    }

                    /** 
                     * Get the 'ExpirationDate' attribute value. Used to specify the document expiration date.
                     * 
                     * @return value
                     */
                    public Date getExpirationDate() {
                        return expirationDate;
                    }

                    /** 
                     * Set the 'ExpirationDate' attribute value. Used to specify the document expiration date.
                     * 
                     * @param expirationDate
                     */
                    public void setExpirationDate(Date expirationDate) {
                        this.expirationDate = expirationDate;
                    }

                    /** 
                     * Get the 'Number' attribute value. Used to specify the document number.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Used to specify the document number.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'Type' attribute value. Used to specify the document type.
                                                                                                      Acceptable values include:
                                                                                                      "A" - Alien resident card,
                                                                                                      "C" - Permanent resident card,
                                                                                                      "F" - Facilitation document,
                                                                                                      "I" - National ID card,
                                                                                                      "IN" - Nexus Card.
                                                                                                      Also:
                                                                                                      "M" - Military,
                                                                                                      "N" - Naturalization certificate,
                                                                                                      "P" - Passport,
                                                                                                      "T" - Refugee travel document and re-entry permit,
                                                                                                      US Travel document,
                                                                                                      "V" - Border crossing card.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Used to specify the document type.
                                                                                                      Acceptable values include:
                                                                                                      "A" - Alien resident card,
                                                                                                      "C" - Permanent resident card,
                                                                                                      "F" - Facilitation document,
                                                                                                      "I" - National ID card,
                                                                                                      "IN" - Nexus Card.
                                                                                                      Also:
                                                                                                      "M" - Military,
                                                                                                      "N" - Naturalization certificate,
                                                                                                      "P" - Passport,
                                                                                                      "T" - Refugee travel document and re-entry permit,
                                                                                                      US Travel document,
                                                                                                      "V" - Border crossing card.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Used to pass visa document details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Visa" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ApplicableCountry" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="PlaceOfBirth" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="PlaceOfIssue" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:date" name="ExpirationDate"/>
                     *     &lt;xs:attribute type="xs:date" name="IssueDate"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Visa implements Serializable
                    {
                        private String applicableCountry;
                        private String placeOfBirth;
                        private String placeOfIssue;
                        private Date expirationDate;
                        private Date issueDate;

                        /** 
                         * Get the 'ApplicableCountry' element value. Used to pass the visa document applicable country code.
                                                                                                                        You must use a valid 2 or 3 character country code (alpha characters only).
                         * 
                         * @return value
                         */
                        public String getApplicableCountry() {
                            return applicableCountry;
                        }

                        /** 
                         * Set the 'ApplicableCountry' element value. Used to pass the visa document applicable country code.
                                                                                                                        You must use a valid 2 or 3 character country code (alpha characters only).
                         * 
                         * @param applicableCountry
                         */
                        public void setApplicableCountry(
                                String applicableCountry) {
                            this.applicableCountry = applicableCountry;
                        }

                        /** 
                         * Get the 'PlaceOfBirth' element value. Used to pass the visa document place of birth.
                         * 
                         * @return value
                         */
                        public String getPlaceOfBirth() {
                            return placeOfBirth;
                        }

                        /** 
                         * Set the 'PlaceOfBirth' element value. Used to pass the visa document place of birth.
                         * 
                         * @param placeOfBirth
                         */
                        public void setPlaceOfBirth(String placeOfBirth) {
                            this.placeOfBirth = placeOfBirth;
                        }

                        /** 
                         * Get the 'PlaceOfIssue' element value. Used to pass the visa document place of issue.
                         * 
                         * @return value
                         */
                        public String getPlaceOfIssue() {
                            return placeOfIssue;
                        }

                        /** 
                         * Set the 'PlaceOfIssue' element value. Used to pass the visa document place of issue.
                         * 
                         * @param placeOfIssue
                         */
                        public void setPlaceOfIssue(String placeOfIssue) {
                            this.placeOfIssue = placeOfIssue;
                        }

                        /** 
                         * Get the 'ExpirationDate' attribute value. Used to specify the visa expiration date.
                         * 
                         * @return value
                         */
                        public Date getExpirationDate() {
                            return expirationDate;
                        }

                        /** 
                         * Set the 'ExpirationDate' attribute value. Used to specify the visa expiration date.
                         * 
                         * @param expirationDate
                         */
                        public void setExpirationDate(Date expirationDate) {
                            this.expirationDate = expirationDate;
                        }

                        /** 
                         * Get the 'IssueDate' attribute value. Used to specify the visa issue date.
                         * 
                         * @return value
                         */
                        public Date getIssueDate() {
                            return issueDate;
                        }

                        /** 
                         * Set the 'IssueDate' attribute value. Used to specify the visa issue date.
                         * 
                         * @param issueDate
                         */
                        public void setIssueDate(Date issueDate) {
                            this.issueDate = issueDate;
                        }
                    }
                }
                /** 
                 * Used to pass personal details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:date" name="DateOfBirth"/>
                 *     &lt;xs:attribute type="xs:boolean" name="DocumentHolder"/>
                 *     &lt;xs:attribute name="Gender">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class Gender -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *     &lt;xs:attribute type="xs:boolean" name="LapChild"/>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PersonName implements Serializable
                {
                    private String givenName;
                    private String middleName;
                    private String surname;
                    private Date dateOfBirth;
                    private Boolean documentHolder;
                    private Gender gender;
                    private Boolean lapChild;
                    private String nameNumber;

                    /** 
                     * Get the 'GivenName' element value. The person's first name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @return value
                     */
                    public String getGivenName() {
                        return givenName;
                    }

                    /** 
                     * Set the 'GivenName' element value. The person's first name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @param givenName
                     */
                    public void setGivenName(String givenName) {
                        this.givenName = givenName;
                    }

                    /** 
                     * Get the 'MiddleName' element value. Used to pass the middle name.
                     * 
                     * @return value
                     */
                    public String getMiddleName() {
                        return middleName;
                    }

                    /** 
                     * Set the 'MiddleName' element value. Used to pass the middle name.
                     * 
                     * @param middleName
                     */
                    public void setMiddleName(String middleName) {
                        this.middleName = middleName;
                    }

                    /** 
                     * Get the 'Surname' element value. The person's last name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @return value
                     */
                    public String getSurname() {
                        return surname;
                    }

                    /** 
                     * Set the 'Surname' element value. The person's last name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @param surname
                     */
                    public void setSurname(String surname) {
                        this.surname = surname;
                    }

                    /** 
                     * Get the 'DateOfBirth' attribute value. Used to pass the date of birth.
                                                                                                      It follows the YYYY-MM-DD format.
                     * 
                     * @return value
                     */
                    public Date getDateOfBirth() {
                        return dateOfBirth;
                    }

                    /** 
                     * Set the 'DateOfBirth' attribute value. Used to pass the date of birth.
                                                                                                      It follows the YYYY-MM-DD format.
                     * 
                     * @param dateOfBirth
                     */
                    public void setDateOfBirth(Date dateOfBirth) {
                        this.dateOfBirth = dateOfBirth;
                    }

                    /** 
                     * Get the 'DocumentHolder' attribute value. Used to identify the primary passport holder when the passport document is issued for multiple passengers.
                     * 
                     * @return value
                     */
                    public Boolean getDocumentHolder() {
                        return documentHolder;
                    }

                    /** 
                     * Set the 'DocumentHolder' attribute value. Used to identify the primary passport holder when the passport document is issued for multiple passengers.
                     * 
                     * @param documentHolder
                     */
                    public void setDocumentHolder(Boolean documentHolder) {
                        this.documentHolder = documentHolder;
                    }

                    /** 
                     * Get the 'Gender' attribute value. Used to pass the gender type code.
                     * 
                     * @return value
                     */
                    public Gender getGender() {
                        return gender;
                    }

                    /** 
                     * Set the 'Gender' attribute value. Used to pass the gender type code.
                     * 
                     * @param gender
                     */
                    public void setGender(Gender gender) {
                        this.gender = gender;
                    }

                    /** 
                     * Get the 'LapChild' attribute value. Used to identify information associated with a lap child.
                                                                                                      It can only be used together with .../SpecialServiceInfo/AdvancePassenger/Document/Visa
                                                                                                      and .../SpecialServiceInfo/AdvancePassenger/ResidentDestinationAddress.
                     * 
                     * @return value
                     */
                    public Boolean getLapChild() {
                        return lapChild;
                    }

                    /** 
                     * Set the 'LapChild' attribute value. Used to identify information associated with a lap child.
                                                                                                      It can only be used together with .../SpecialServiceInfo/AdvancePassenger/Document/Visa
                                                                                                      and .../SpecialServiceInfo/AdvancePassenger/ResidentDestinationAddress.
                     * 
                     * @param lapChild
                     */
                    public void setLapChild(Boolean lapChild) {
                        this.lapChild = lapChild;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Used to pass the name number. Example 1.1, 2.1. etc.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Used to pass the name number. Example 1.1, 2.1. etc.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:string">
                     *     &lt;xs:enumeration value="F"/>
                     *     &lt;xs:enumeration value="M"/>
                     *     &lt;xs:enumeration value="FI"/>
                     *     &lt;xs:enumeration value="MI"/>
                     *     &lt;xs:enumeration value="U"/>
                     *     &lt;xs:enumeration value="X"/>
                     *     &lt;xs:enumeration value="UI"/>
                     *     &lt;xs:enumeration value="XI"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum Gender implements Serializable {
                        F, M, FI, MI, U, X, UI, XI
                    }
                }
                /** 
                 * Used to pass residence or destination address.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResidentDestinationAddress" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Country"/>
                 *       &lt;xs:element type="xs:string" name="Street" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="State" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Zip" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ResidentDestinationAddress implements
                    Serializable
                {
                    private String city;
                    private String country;
                    private String street;
                    private String state;
                    private String zip;
                    private String type;

                    /** 
                     * Get the 'City' element value. Used to pass the city name.
                     * 
                     * @return value
                     */
                    public String getCity() {
                        return city;
                    }

                    /** 
                     * Set the 'City' element value. Used to pass the city name.
                     * 
                     * @param city
                     */
                    public void setCity(String city) {
                        this.city = city;
                    }

                    /** 
                     * Get the 'Country' element value. Used to pass the country code.
                     * 
                     * @return value
                     */
                    public String getCountry() {
                        return country;
                    }

                    /** 
                     * Set the 'Country' element value. Used to pass the country code.
                     * 
                     * @param country
                     */
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    /** 
                     * Get the 'Street' element value. Used to pass the street address.
                     * 
                     * @return value
                     */
                    public String getStreet() {
                        return street;
                    }

                    /** 
                     * Set the 'Street' element value. Used to pass the street address.
                     * 
                     * @param street
                     */
                    public void setStreet(String street) {
                        this.street = street;
                    }

                    /** 
                     * Get the 'State' element value. Used to pass the state code.
                     * 
                     * @return value
                     */
                    public String getState() {
                        return state;
                    }

                    /** 
                     * Set the 'State' element value. Used to pass the state code.
                     * 
                     * @param state
                     */
                    public void setState(String state) {
                        this.state = state;
                    }

                    /** 
                     * Get the 'Zip' element value. Used to specify zip or postal code.
                     * 
                     * @return value
                     */
                    public String getZip() {
                        return zip;
                    }

                    /** 
                     * Set the 'Zip' element value. Used to specify zip or postal code.
                     * 
                     * @param zip
                     */
                    public void setZip(String zip) {
                        this.zip = zip;
                    }

                    /** 
                     * Get the 'Type' attribute value. Used to specify the address type.
                                                                                                      Acceptable values are:
                                                                                                      "R" - residence address,
                                                                                                      "D" - destination address.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Used to specify the address type.
                                                                                                      Acceptable values are:
                                                                                                      "R" - residence address,
                                                                                                      "D" - destination address.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
                /** 
                 * Used to specify the vendor preferences.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:boolean" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private Boolean airline;

                    /** 
                     * Get the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier, and is required.
                                                                                                                  For Travel Network-based customers "Hosted" can be set to "false" unless the message is being sent to AA.
                                                                                                                  For SabreSonic RES-based customers "Hosted" can be set to "true" when communicating internally, and "false" when sending to any other carrier.
                     * 
                     * @return value
                     */
                    public Boolean getAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier, and is required.
                                                                                                                  For Travel Network-based customers "Hosted" can be set to "false" unless the message is being sent to AA.
                                                                                                                  For SabreSonic RES-based customers "Hosted" can be set to "true" when communicating internally, and "false" when sending to any other carrier.
                     * 
                     * @param airline
                     */
                    public void setAirline(Boolean airline) {
                        this.airline = airline;
                    }
                }
            }
            /** 
             * Used to specify Secure Flight Passenger Data (SFPD).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecureFlight" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="IssueCountry" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="KnownTravelerNumber" minOccurs="0"/>
             *       &lt;xs:element name="PersonName" minOccurs="0">
             *         &lt;!-- Reference to inner class PersonName -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="RedressNumber" minOccurs="0"/>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SecureFlight implements Serializable
            {
                private String issueCountry;
                private String knownTravelerNumber;
                private PersonName personName;
                private String redressNumber;
                private VendorPrefs vendorPrefs;
                private String segmentNumber;

                /** 
                 * Get the 'IssueCountry' element value. Used to pass country of issue for "KnownTravelerNumber" or "RedressNumber".
                 * 
                 * @return value
                 */
                public String getIssueCountry() {
                    return issueCountry;
                }

                /** 
                 * Set the 'IssueCountry' element value. Used to pass country of issue for "KnownTravelerNumber" or "RedressNumber".
                 * 
                 * @param issueCountry
                 */
                public void setIssueCountry(String issueCountry) {
                    this.issueCountry = issueCountry;
                }

                /** 
                 * Get the 'KnownTravelerNumber' element value. Used to pass the known traveler number.
                                                                                            "KnownTravelerNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender" and "RedressNumber".
                 * 
                 * @return value
                 */
                public String getKnownTravelerNumber() {
                    return knownTravelerNumber;
                }

                /** 
                 * Set the 'KnownTravelerNumber' element value. Used to pass the known traveler number.
                                                                                            "KnownTravelerNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender" and "RedressNumber".
                 * 
                 * @param knownTravelerNumber
                 */
                public void setKnownTravelerNumber(String knownTravelerNumber) {
                    this.knownTravelerNumber = knownTravelerNumber;
                }

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonName getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonName personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'RedressNumber' element value. Used to pass the redress number.
                                                                                            "RedressNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender" and "KnownTravelerNumber".
                 * 
                 * @return value
                 */
                public String getRedressNumber() {
                    return redressNumber;
                }

                /** 
                 * Set the 'RedressNumber' element value. Used to pass the redress number.
                                                                                            "RedressNumber" cannot combine with ".../PersonName@DateOfBirth" or ".../PersonName@Gender" and "KnownTravelerNumber".
                 * 
                 * @param redressNumber
                 */
                public void setRedressNumber(String redressNumber) {
                    this.redressNumber = redressNumber;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.
                                                                                        "A" can be specified to associate the SSR to all segments.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.
                                                                                        "A" can be specified to associate the SSR to all segments.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }
                /** 
                 * Used to pass personal details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="DateOfBirth"/>
                 *     &lt;xs:attribute name="Gender">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class Gender -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *     &lt;xs:attribute type="xs:boolean" name="LapChild"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PersonName implements Serializable
                {
                    private String givenName;
                    private String surname;
                    private String dateOfBirth;
                    private Gender gender;
                    private String nameNumber;
                    private Boolean lapChild;

                    /** 
                     * Get the 'GivenName' element value. The person's first name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @return value
                     */
                    public String getGivenName() {
                        return givenName;
                    }

                    /** 
                     * Set the 'GivenName' element value. The person's first name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @param givenName
                     */
                    public void setGivenName(String givenName) {
                        this.givenName = givenName;
                    }

                    /** 
                     * Get the 'Surname' element value. The person's last name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @return value
                     */
                    public String getSurname() {
                        return surname;
                    }

                    /** 
                     * Set the 'Surname' element value. The person's last name. The maximum number of characters accepted by Sabre is 29.
                     * 
                     * @param surname
                     */
                    public void setSurname(String surname) {
                        this.surname = surname;
                    }

                    /** 
                     * Get the 'DateOfBirth' attribute value. Used to pass a date of birth.
                                                                                                      "DateOfBirth" and "Gender" cannot combine with "RedressNumber" and "KnownTravelerNumber".
                                                                                                      "DateOfBirth" accepts dates formatted as: YYYY-MM-DD and YY-MM-DD.
                     * 
                     * @return value
                     */
                    public String getDateOfBirth() {
                        return dateOfBirth;
                    }

                    /** 
                     * Set the 'DateOfBirth' attribute value. Used to pass a date of birth.
                                                                                                      "DateOfBirth" and "Gender" cannot combine with "RedressNumber" and "KnownTravelerNumber".
                                                                                                      "DateOfBirth" accepts dates formatted as: YYYY-MM-DD and YY-MM-DD.
                     * 
                     * @param dateOfBirth
                     */
                    public void setDateOfBirth(String dateOfBirth) {
                        this.dateOfBirth = dateOfBirth;
                    }

                    /** 
                     * Get the 'Gender' attribute value. Used to pass the gender type code.
                     * 
                     * @return value
                     */
                    public Gender getGender() {
                        return gender;
                    }

                    /** 
                     * Set the 'Gender' attribute value. Used to pass the gender type code.
                     * 
                     * @param gender
                     */
                    public void setGender(Gender gender) {
                        this.gender = gender;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Used to pass the name number. Example 1.1, 2.1. etc.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Used to pass the name number. Example 1.1, 2.1. etc.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }

                    /** 
                     * Get the 'LapChild' attribute value. Used to identify information associated with a lap child.
                     * 
                     * @return value
                     */
                    public Boolean getLapChild() {
                        return lapChild;
                    }

                    /** 
                     * Set the 'LapChild' attribute value. Used to identify information associated with a lap child.
                     * 
                     * @param lapChild
                     */
                    public void setLapChild(Boolean lapChild) {
                        this.lapChild = lapChild;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:string">
                     *     &lt;xs:enumeration value="F"/>
                     *     &lt;xs:enumeration value="M"/>
                     *     &lt;xs:enumeration value="FI"/>
                     *     &lt;xs:enumeration value="MI"/>
                     *     &lt;xs:enumeration value="U"/>
                     *     &lt;xs:enumeration value="X"/>
                     *     &lt;xs:enumeration value="UI"/>
                     *     &lt;xs:enumeration value="XI"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum Gender implements Serializable {
                        F, M, FI, MI, U, X, UI, XI
                    }
                }
                /** 
                 * Used to specify the vendor preferences.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:boolean" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private Boolean airline;

                    /** 
                     * Get the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier, and is required.
                                                                                                                  For Travel Network-based customers "Hosted" can be set to "false" unless the message is being sent to AA.
                                                                                                                  For SabreSonic RES-based customers "Hosted" can be set to "true" when communicating internally, and "false" when sending to any other carrier.
                     * 
                     * @return value
                     */
                    public Boolean getAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier, and is required.
                                                                                                                  For Travel Network-based customers "Hosted" can be set to "false" unless the message is being sent to AA.
                                                                                                                  For SabreSonic RES-based customers "Hosted" can be set to "true" when communicating internally, and "false" when sending to any other carrier.
                     * 
                     * @param airline
                     */
                    public void setAirline(Boolean airline) {
                        this.airline = airline;
                    }
                }
            }
            /** 
             * Used to specify Special Service Request (SSR).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PersonName" minOccurs="0">
             *         &lt;!-- Reference to inner class PersonName -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="SSR_Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Service implements Serializable
            {
                private PersonName personName;
                private String text;
                private VendorPrefs vendorPrefs;
                private String segmentNumber;
                private String SSRCode;

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonName getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonName personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'Text' element value. Used to specify miscellaneous free text information.
                                                                                            Many SSR codes require text.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Used to specify miscellaneous free text information.
                                                                                            Many SSR codes require text.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.
                                                                                        If SSR_Code="OSI"  @SegmentNumber cannot be utilized.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to specify an itinerary segment to associate the SSR to.
                                                                                        If SSR_Code="OSI"  @SegmentNumber cannot be utilized.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'SSR_Code' attribute value. Used to specify an SSR code such as "WCHR", "WGML", etc.
                                                                                        Please note that it is no longer possible to specify SSR_Code="DOC*", please utilize either "AdvancePassenger" or "SecureFlight" to send document SSRs.
                 * 
                 * @return value
                 */
                public String getSSRCode() {
                    return SSRCode;
                }

                /** 
                 * Set the 'SSR_Code' attribute value. Used to specify an SSR code such as "WCHR", "WGML", etc.
                                                                                        Please note that it is no longer possible to specify SSR_Code="DOC*", please utilize either "AdvancePassenger" or "SecureFlight" to send document SSRs.
                 * 
                 * @param SSRCode
                 */
                public void setSSRCode(String SSRCode) {
                    this.SSRCode = SSRCode;
                }
                /** 
                 * Used to pass personal details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PersonName implements Serializable
                {
                    private String nameNumber;

                    /** 
                     * Get the 'NameNumber' attribute value. Used to specify a passenger name number.
                                                                                                      Some SSR codes require a name number.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Used to specify a passenger name number.
                                                                                                      Some SSR codes require a name number.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                }
                /** 
                 * Used to specify the vendor preferences.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" name="Code"/>
                 *           &lt;xs:attribute type="xs:boolean" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private String airlineCode;
                    private Boolean airlineHosted;

                    /** 
                     * Get the 'Code' attribute value. Only applicable to the "OSI" SSRCode, and is used to specify the airline that the SSR needs to be sent to.
                     * 
                     * @return value
                     */
                    public String getAirlineCode() {
                        return airlineCode;
                    }

                    /** 
                     * Set the 'Code' attribute value. Only applicable to the "OSI" SSRCode, and is used to specify the airline that the SSR needs to be sent to.
                     * 
                     * @param airlineCode
                     */
                    public void setAirlineCode(String airlineCode) {
                        this.airlineCode = airlineCode;
                    }

                    /** 
                     * Get the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier.
                                                                                                                  For Travel Network-based customers "HostedCarrier" can be set to "false" unless the message is being sent to AA.
                                                                                                                  For SabreSonic RES-based customers "HostedCarrier" should be set to "true" when communicating internally, and omitted when sending to any other carrier.
                     * 
                     * @return value
                     */
                    public Boolean getAirlineHosted() {
                        return airlineHosted;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier.
                                                                                                                  For Travel Network-based customers "HostedCarrier" can be set to "false" unless the message is being sent to AA.
                                                                                                                  For SabreSonic RES-based customers "HostedCarrier" should be set to "true" when communicating internally, and omitted when sending to any other carrier.
                     * 
                     * @param airlineHosted
                     */
                    public void setAirlineHosted(Boolean airlineHosted) {
                        this.airlineHosted = airlineHosted;
                    }
                }
            }
        }
    }
    /** 
     * Used to add passenger/agency information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItineraryAddInfoRQ" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AgencyInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AgencyInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CustomerInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class CustomerInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelItineraryAddInfoRQ implements Serializable
    {
        private AgencyInfo agencyInfo;
        private CustomerInfo customerInfo;

        /** 
         * Get the 'AgencyInfo' element value.
         * 
         * @return value
         */
        public AgencyInfo getAgencyInfo() {
            return agencyInfo;
        }

        /** 
         * Set the 'AgencyInfo' element value.
         * 
         * @param agencyInfo
         */
        public void setAgencyInfo(AgencyInfo agencyInfo) {
            this.agencyInfo = agencyInfo;
        }

        /** 
         * Get the 'CustomerInfo' element value.
         * 
         * @return value
         */
        public CustomerInfo getCustomerInfo() {
            return customerInfo;
        }

        /** 
         * Set the 'CustomerInfo' element value.
         * 
         * @param customerInfo
         */
        public void setCustomerInfo(CustomerInfo customerInfo) {
            this.customerInfo = customerInfo;
        }
        /** 
         * Used to pass agency details.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Address" minOccurs="0">
         *         &lt;!-- Reference to inner class Address -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Ticketing" minOccurs="0">
         *         &lt;!-- Reference to inner class Ticketing -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AgencyInfo implements Serializable
        {
            private Address address;
            private Ticketing ticketing;

            /** 
             * Get the 'Address' element value.
             * 
             * @return value
             */
            public Address getAddress() {
                return address;
            }

            /** 
             * Set the 'Address' element value.
             * 
             * @param address
             */
            public void setAddress(Address address) {
                this.address = address;
            }

            /** 
             * Get the 'Ticketing' element value.
             * 
             * @return value
             */
            public Ticketing getTicketing() {
                return ticketing;
            }

            /** 
             * Set the 'Ticketing' element value.
             * 
             * @param ticketing
             */
            public void setTicketing(Ticketing ticketing) {
                this.ticketing = ticketing;
            }
            /** 
             * Used to add an agency address into the record.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CityName"/>
             *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
             *       &lt;xs:element name="StateCountyProv" minOccurs="0">
             *         &lt;!-- Reference to inner class StateCountyProv -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="StreetNmbr" minOccurs="0"/>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Address implements Serializable
            {
                private String addressLine;
                private String cityName;
                private String countryCode;
                private String postalCode;
                private StateCountyProv stateCountyProv;
                private String streetNmbr;
                private VendorPrefs vendorPrefs;

                /** 
                 * Get the 'AddressLine' element value. Used to pass the agency address.
                 * 
                 * @return value
                 */
                public String getAddressLine() {
                    return addressLine;
                }

                /** 
                 * Set the 'AddressLine' element value. Used to pass the agency address.
                 * 
                 * @param addressLine
                 */
                public void setAddressLine(String addressLine) {
                    this.addressLine = addressLine;
                }

                /** 
                 * Get the 'CityName' element value. Used to pass the agency city name.
                 * 
                 * @return value
                 */
                public String getCityName() {
                    return cityName;
                }

                /** 
                 * Set the 'CityName' element value. Used to pass the agency city name.
                 * 
                 * @param cityName
                 */
                public void setCityName(String cityName) {
                    this.cityName = cityName;
                }

                /** 
                 * Get the 'CountryCode' element value. Used to pass the agency country code.
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' element value. Used to pass the agency country code.
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }

                /** 
                 * Get the 'PostalCode' element value. Used to pass the agency postal code.
                 * 
                 * @return value
                 */
                public String getPostalCode() {
                    return postalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. Used to pass the agency postal code.
                 * 
                 * @param postalCode
                 */
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                /** 
                 * Get the 'StateCountyProv' element value.
                 * 
                 * @return value
                 */
                public StateCountyProv getStateCountyProv() {
                    return stateCountyProv;
                }

                /** 
                 * Set the 'StateCountyProv' element value.
                 * 
                 * @param stateCountyProv
                 */
                public void setStateCountyProv(StateCountyProv stateCountyProv) {
                    this.stateCountyProv = stateCountyProv;
                }

                /** 
                 * Get the 'StreetNmbr' element value. Used to pass the agency street number.
                 * 
                 * @return value
                 */
                public String getStreetNmbr() {
                    return streetNmbr;
                }

                /** 
                 * Set the 'StreetNmbr' element value. Used to pass the agency street number.
                 * 
                 * @param streetNmbr
                 */
                public void setStreetNmbr(String streetNmbr) {
                    this.streetNmbr = streetNmbr;
                }

                /** 
                 * Get the 'VendorPrefs' element value.
                 * 
                 * @return value
                 */
                public VendorPrefs getVendorPrefs() {
                    return vendorPrefs;
                }

                /** 
                 * Set the 'VendorPrefs' element value.
                 * 
                 * @param vendorPrefs
                 */
                public void setVendorPrefs(VendorPrefs vendorPrefs) {
                    this.vendorPrefs = vendorPrefs;
                }
                /** 
                 * Used to pass the state or country province details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateCountyProv" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="StateCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class StateCountyProv implements Serializable
                {
                    private String stateCode;

                    /** 
                     * Get the 'StateCode' attribute value. Used to pass the state or province code.
                     * 
                     * @return value
                     */
                    public String getStateCode() {
                        return stateCode;
                    }

                    /** 
                     * Set the 'StateCode' attribute value. Used to pass the state or province code.
                     * 
                     * @param stateCode
                     */
                    public void setStateCode(String stateCode) {
                        this.stateCode = stateCode;
                    }
                }
                /** 
                 * Used to specify the vendor preferences.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:boolean" use="required" name="Hosted"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private boolean airline;

                    /** 
                     * Get the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier.
                                                                                                      For Travel Network customers "Hosted" should be set to "false".
                                                                                                      For SabreSonic RES hosted customers "Hosted" should be set to "true".
                     * 
                     * @return value
                     */
                    public boolean isAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Hosted' attribute value. Used to specify if the request is based upon a hosted or a non-hosted carrier.
                                                                                                      For Travel Network customers "Hosted" should be set to "false".
                                                                                                      For SabreSonic RES hosted customers "Hosted" should be set to "true".
                     * 
                     * @param airline
                     */
                    public void setAirline(boolean airline) {
                        this.airline = airline;
                    }
                }
            }
            /** 
             * Used to pass ticketing information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
             *     &lt;xs:attribute type="xs:integer" name="QueueNumber"/>
             *     &lt;xs:attribute type="xs:string" name="QueueName"/>
             *     &lt;xs:attribute type="xs:string" name="ShortText"/>
             *     &lt;xs:attribute type="xs:string" name="TicketTimeLimit"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="TicketType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Ticketing implements Serializable
            {
                private String pseudoCityCode;
                private BigInteger queueNumber;
                private String queueName;
                private String shortText;
                private String ticketTimeLimit;
                private String ticketType;

                /** 
                 * Get the 'PseudoCityCode' attribute value. Used to specify a pseudo city code.
                 * 
                 * @return value
                 */
                public String getPseudoCityCode() {
                    return pseudoCityCode;
                }

                /** 
                 * Set the 'PseudoCityCode' attribute value. Used to specify a pseudo city code.
                 * 
                 * @param pseudoCityCode
                 */
                public void setPseudoCityCode(String pseudoCityCode) {
                    this.pseudoCityCode = pseudoCityCode;
                }

                /** 
                 * Get the 'QueueNumber' attribute value. Used to specify a queue number.
                 * 
                 * @return value
                 */
                public BigInteger getQueueNumber() {
                    return queueNumber;
                }

                /** 
                 * Set the 'QueueNumber' attribute value. Used to specify a queue number.
                 * 
                 * @param queueNumber
                 */
                public void setQueueNumber(BigInteger queueNumber) {
                    this.queueNumber = queueNumber;
                }

                /** 
                 * Get the 'QueueName' attribute value. Used to specify a special name queue.
                 * 
                 * @return value
                 */
                public String getQueueName() {
                    return queueName;
                }

                /** 
                 * Set the 'QueueName' attribute value. Used to specify a special name queue.
                 * 
                 * @param queueName
                 */
                public void setQueueName(String queueName) {
                    this.queueName = queueName;
                }

                /** 
                 * Get the 'ShortText' attribute value. Used to specify miscellaneous free text.
                 * 
                 * @return value
                 */
                public String getShortText() {
                    return shortText;
                }

                /** 
                 * Set the 'ShortText' attribute value. Used to specify miscellaneous free text.
                 * 
                 * @param shortText
                 */
                public void setShortText(String shortText) {
                    this.shortText = shortText;
                }

                /** 
                 * Get the 'TicketTimeLimit' attribute value. Used to specify the ticket time limit.
                                                                            "TicketTimeLimit" follows this format: MM-DDTHH:00.
                                                                            "TicketTimeLimit" must be at the top of the hour.
                 * 
                 * @return value
                 */
                public String getTicketTimeLimit() {
                    return ticketTimeLimit;
                }

                /** 
                 * Set the 'TicketTimeLimit' attribute value. Used to specify the ticket time limit.
                                                                            "TicketTimeLimit" follows this format: MM-DDTHH:00.
                                                                            "TicketTimeLimit" must be at the top of the hour.
                 * 
                 * @param ticketTimeLimit
                 */
                public void setTicketTimeLimit(String ticketTimeLimit) {
                    this.ticketTimeLimit = ticketTimeLimit;
                }

                /** 
                 * Get the 'TicketType' attribute value. Used to specify the ticket type.
                                                                            Acceptable values are: "7TAW", "7TAX", "7T-A", 8(time), or 8(time/(date).
                 * 
                 * @return value
                 */
                public String getTicketType() {
                    return ticketType;
                }

                /** 
                 * Set the 'TicketType' attribute value. Used to specify the ticket type.
                                                                            Acceptable values are: "7TAW", "7TAX", "7T-A", 8(time), or 8(time/(date).
                 * 
                 * @param ticketType
                 */
                public void setTicketType(String ticketType) {
                    this.ticketType = ticketType;
                }
            }
        }
        /** 
         * Used to pass passenger details.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ContactNumbers" minOccurs="0">
         *         &lt;!-- Reference to inner class ContactNumbers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Corporate" minOccurs="0">
         *         &lt;!-- Reference to inner class Corporate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class CustLoyalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="CustomerIdentifier" minOccurs="0"/>
         *       &lt;xs:element name="Email" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Email -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PersonName" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CustomerInfo implements Serializable
        {
            private ContactNumbers contactNumbers;
            private Corporate corporate;
            private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
            private String customerIdentifier;
            private List<Email> emailList = new ArrayList<Email>();
            private List<PersonName> personNameList = new ArrayList<PersonName>();

            /** 
             * Get the 'ContactNumbers' element value.
             * 
             * @return value
             */
            public ContactNumbers getContactNumbers() {
                return contactNumbers;
            }

            /** 
             * Set the 'ContactNumbers' element value.
             * 
             * @param contactNumbers
             */
            public void setContactNumbers(ContactNumbers contactNumbers) {
                this.contactNumbers = contactNumbers;
            }

            /** 
             * Get the 'Corporate' element value.
             * 
             * @return value
             */
            public Corporate getCorporate() {
                return corporate;
            }

            /** 
             * Set the 'Corporate' element value.
             * 
             * @param corporate
             */
            public void setCorporate(Corporate corporate) {
                this.corporate = corporate;
            }

            /** 
             * Get the list of 'CustLoyalty' element items.
             * 
             * @return list
             */
            public List<CustLoyalty> getCustLoyaltyList() {
                return custLoyaltyList;
            }

            /** 
             * Set the list of 'CustLoyalty' element items.
             * 
             * @param list
             */
            public void setCustLoyaltyList(List<CustLoyalty> list) {
                custLoyaltyList = list;
            }

            /** 
             * Get the 'CustomerIdentifier' element value. Used to add a customer number into the record.
                                                                  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                                                                  The value of identifier can be 6,7, or 10 alphanumeric.
             * 
             * @return value
             */
            public String getCustomerIdentifier() {
                return customerIdentifier;
            }

            /** 
             * Set the 'CustomerIdentifier' element value. Used to add a customer number into the record.
                                                                  Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                                                                  The value of identifier can be 6,7, or 10 alphanumeric.
             * 
             * @param customerIdentifier
             */
            public void setCustomerIdentifier(String customerIdentifier) {
                this.customerIdentifier = customerIdentifier;
            }

            /** 
             * Get the list of 'Email' element items.
             * 
             * @return list
             */
            public List<Email> getEmailList() {
                return emailList;
            }

            /** 
             * Set the list of 'Email' element items.
             * 
             * @param list
             */
            public void setEmailList(List<Email> list) {
                emailList = list;
            }

            /** 
             * Get the list of 'PersonName' element items.
             * 
             * @return list
             */
            public List<PersonName> getPersonNameList() {
                return personNameList;
            }

            /** 
             * Set the list of 'PersonName' element items.
             * 
             * @param list
             */
            public void setPersonNameList(List<PersonName> list) {
                personNameList = list;
            }
            /** 
             * Used to pass passenger contact numbers.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ContactNumber" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ContactNumber -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ContactNumbers implements Serializable
            {
                private List<ContactNumber> contactNumberList = new ArrayList<ContactNumber>();

                /** 
                 * Get the list of 'ContactNumber' element items.
                 * 
                 * @return list
                 */
                public List<ContactNumber> getContactNumberList() {
                    return contactNumberList;
                }

                /** 
                 * Set the list of 'ContactNumber' element items.
                 * 
                 * @param list
                 */
                public void setContactNumberList(List<ContactNumber> list) {
                    contactNumberList = list;
                }
                /** 
                 * Used to pass contact details for a specific passenger.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" name="InsertAfter"/>
                 *     &lt;xs:attribute type="xs:string" name="LocationCode"/>
                 *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Phone"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PhoneUseType"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ContactNumber implements Serializable
                {
                    private BigInteger insertAfter;
                    private String locationCode;
                    private String nameNumber;
                    private String phone;
                    private String phoneUseType;

                    /** 
                     * Get the 'InsertAfter' attribute value. Used to add a phone number after or before an existing phone number.
                     * 
                     * @return value
                     */
                    public BigInteger getInsertAfter() {
                        return insertAfter;
                    }

                    /** 
                     * Set the 'InsertAfter' attribute value. Used to add a phone number after or before an existing phone number.
                     * 
                     * @param insertAfter
                     */
                    public void setInsertAfter(BigInteger insertAfter) {
                        this.insertAfter = insertAfter;
                    }

                    /** 
                     * Get the 'LocationCode' attribute value. Used to override the default city in the application`s Travel Journal Record.
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value. Used to override the default city in the application`s Travel Journal Record.
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value. Used to specify a passenger name number.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value. Used to specify a passenger name number.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }

                    /** 
                     * Get the 'Phone' attribute value. Used to add customer telephone numbers into the record.
                     * 
                     * @return value
                     */
                    public String getPhone() {
                        return phone;
                    }

                    /** 
                     * Set the 'Phone' attribute value. Used to add customer telephone numbers into the record.
                     * 
                     * @param phone
                     */
                    public void setPhone(String phone) {
                        this.phone = phone;
                    }

                    /** 
                     * Get the 'PhoneUseType' attribute value. Used to specify the phone type.
                                                                                          Values:
                                                                                          `A` - agency.
                                                                                          `H` - home.
                                                                                          `B` - business.
                                                                                          `F` - fax.
                     * 
                     * @return value
                     */
                    public String getPhoneUseType() {
                        return phoneUseType;
                    }

                    /** 
                     * Set the 'PhoneUseType' attribute value. Used to specify the phone type.
                                                                                          Values:
                                                                                          `A` - agency.
                                                                                          `H` - home.
                                                                                          `B` - business.
                                                                                          `F` - fax.
                     * 
                     * @param phoneUseType
                     */
                    public void setPhoneUseType(String phoneUseType) {
                        this.phoneUseType = phoneUseType;
                    }
                }
            }
            /** 
             * Used to pass corporate ID into the record.
                                                                  "Corporate" cannot combine with any other qualifier.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ID"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Corporate implements Serializable
            {
                private String ID;

                /** 
                 * Get the 'ID' element value. Used to add a corporate ID into the record.
                                                                                Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                                                                                Furthermore, Sabre Travel Network-based customers need to first have this functionality activated for their particular location by their account representative prior to attempting to utilize this element.
                 * 
                 * @return value
                 */
                public String getID() {
                    return ID;
                }

                /** 
                 * Set the 'ID' element value. Used to add a corporate ID into the record.
                                                                                Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                                                                                Furthermore, Sabre Travel Network-based customers need to first have this functionality activated for their particular location by their account representative prior to attempting to utilize this element.
                 * 
                 * @param ID
                 */
                public void setID(String ID) {
                    this.ID = ID;
                }
            }
            /** 
             * Used to pass frequent flyer number information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="MembershipID"/>
             *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="ProgramID"/>
             *     &lt;xs:attribute type="xs:string" name="SegmentNumber"/>
             *     &lt;xs:attribute type="xs:string" name="TravelingCarrierCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CustLoyalty implements Serializable
            {
                private String membershipID;
                private String nameNumber;
                private String programID;
                private String segmentNumber;
                private String travelingCarrierCode;

                /** 
                 * Get the 'MembershipID' attribute value. Used to add a frequent traveler number into the record.
                 * 
                 * @return value
                 */
                public String getMembershipID() {
                    return membershipID;
                }

                /** 
                 * Set the 'MembershipID' attribute value. Used to add a frequent traveler number into the record.
                 * 
                 * @param membershipID
                 */
                public void setMembershipID(String membershipID) {
                    this.membershipID = membershipID;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'ProgramID' attribute value. Used to add the carrier code associated with the frequent traveler number.
                 * 
                 * @return value
                 */
                public String getProgramID() {
                    return programID;
                }

                /** 
                 * Set the 'ProgramID' attribute value. Used to add the carrier code associated with the frequent traveler number.
                 * 
                 * @param programID
                 */
                public void setProgramID(String programID) {
                    this.programID = programID;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. Used to add a segment number to associate the frequent traveler number to.
                                                                            "SegmentNumber" and "TravelingCarrierCode" cannot combine.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. Used to add a segment number to associate the frequent traveler number to.
                                                                            "SegmentNumber" and "TravelingCarrierCode" cannot combine.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'TravelingCarrierCode' attribute value. Used to transmit the frequent traveler number of one airline to accrue mileage on another carrier.
                                                                            "SegmentNumber" and "TravelingCarrierCode" cannot combine.
                 * 
                 * @return value
                 */
                public String getTravelingCarrierCode() {
                    return travelingCarrierCode;
                }

                /** 
                 * Set the 'TravelingCarrierCode' attribute value. Used to transmit the frequent traveler number of one airline to accrue mileage on another carrier.
                                                                            "SegmentNumber" and "TravelingCarrierCode" cannot combine.
                 * 
                 * @param travelingCarrierCode
                 */
                public void setTravelingCarrierCode(String travelingCarrierCode) {
                    this.travelingCarrierCode = travelingCarrierCode;
                }
            }
            /** 
             * Used to pass e-mail details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Email" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Address"/>
             *     &lt;xs:attribute type="xs:string" name="LanguageOverride"/>
             *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" name="ShortText"/>
             *     &lt;xs:attribute name="Type">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Type -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Email implements Serializable
            {
                private String address;
                private String languageOverride;
                private String nameNumber;
                private String shortText;
                private Type type;

                /** 
                 * Get the 'Address' attribute value. Used to add an email address into the record.
                 * 
                 * @return value
                 */
                public String getAddress() {
                    return address;
                }

                /** 
                 * Set the 'Address' attribute value. Used to add an email address into the record.
                 * 
                 * @param address
                 */
                public void setAddress(String address) {
                    this.address = address;
                }

                /** 
                 * Get the 'LanguageOverride' attribute value. Used to override the language in the agency`s Travel Journal Record (TJR).
                 * 
                 * @return value
                 */
                public String getLanguageOverride() {
                    return languageOverride;
                }

                /** 
                 * Set the 'LanguageOverride' attribute value. Used to override the language in the agency`s Travel Journal Record (TJR).
                 * 
                 * @param languageOverride
                 */
                public void setLanguageOverride(String languageOverride) {
                    this.languageOverride = languageOverride;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'ShortText' attribute value. Used to specify miscellaneous email address-related free text information.
                 * 
                 * @return value
                 */
                public String getShortText() {
                    return shortText;
                }

                /** 
                 * Set the 'ShortText' attribute value. Used to specify miscellaneous email address-related free text information.
                 * 
                 * @param shortText
                 */
                public void setShortText(String shortText) {
                    this.shortText = shortText;
                }

                /** 
                 * Get the 'Type' attribute value. Used to specify the type of email address.
                                                                            Acceptable values for "Type" are:
                                                                            `BC` - blind copy.
                                                                            `CC` - carbon copy.
                                                                            `FR` - from.
                                                                            `To` - to.
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Used to specify the type of email address.
                                                                            Acceptable values for "Type" are:
                                                                            `BC` - blind copy.
                                                                            `CC` - carbon copy.
                                                                            `FR` - from.
                                                                            `To` - to.
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="BC"/>
                 *     &lt;xs:enumeration value="CC"/>
                 *     &lt;xs:enumeration value="FR"/>
                 *     &lt;xs:enumeration value="TO"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    BC, CC, FR, TO
                }
            }
            /** 
             * Used to add passenger names.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
             *       &lt;xs:element name="GroupInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class GroupInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="Infant"/>
             *     &lt;xs:attribute type="xs:string" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" name="NameReference"/>
             *     &lt;xs:attribute type="xs:string" name="PassengerType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private String givenName;
                private GroupInfo groupInfo;
                private String surname;
                private Boolean infant;
                private String nameNumber;
                private String nameReference;
                private String passengerType;

                /** 
                 * Get the 'GivenName' element value. Passenger first name.
                 * 
                 * @return value
                 */
                public String getGivenName() {
                    return givenName;
                }

                /** 
                 * Set the 'GivenName' element value. Passenger first name.
                 * 
                 * @param givenName
                 */
                public void setGivenName(String givenName) {
                    this.givenName = givenName;
                }

                /** 
                 * Get the 'GroupInfo' element value.
                 * 
                 * @return value
                 */
                public GroupInfo getGroupInfo() {
                    return groupInfo;
                }

                /** 
                 * Set the 'GroupInfo' element value.
                 * 
                 * @param groupInfo
                 */
                public void setGroupInfo(GroupInfo groupInfo) {
                    this.groupInfo = groupInfo;
                }

                /** 
                 * Get the 'Surname' element value. Passenger surname.
                 * 
                 * @return value
                 */
                public String getSurname() {
                    return surname;
                }

                /** 
                 * Set the 'Surname' element value. Passenger surname.
                 * 
                 * @param surname
                 */
                public void setSurname(String surname) {
                    this.surname = surname;
                }

                /** 
                 * Get the 'Infant' attribute value. Used to specify that the particular passenger is an infant.
                 * 
                 * @return value
                 */
                public Boolean getInfant() {
                    return infant;
                }

                /** 
                 * Set the 'Infant' attribute value. Used to specify that the particular passenger is an infant.
                 * 
                 * @param infant
                 */
                public void setInfant(Boolean infant) {
                    this.infant = infant;
                }

                /** 
                 * Get the 'NameNumber' attribute value. Used to specify a passenger name number, and is only applicable when used in conjunction with @PassengerType.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. Used to specify a passenger name number, and is only applicable when used in conjunction with @PassengerType.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'NameReference' attribute value. Used to specify miscellaneous name reference-related information.
                 * 
                 * @return value
                 */
                public String getNameReference() {
                    return nameReference;
                }

                /** 
                 * Set the 'NameReference' attribute value. Used to specify miscellaneous name reference-related information.
                 * 
                 * @param nameReference
                 */
                public void setNameReference(String nameReference) {
                    this.nameReference = nameReference;
                }

                /** 
                 * Get the 'PassengerType' attribute value. Used to add a passenger type code into the record.
                                                                            Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                 * 
                 * @return value
                 */
                public String getPassengerType() {
                    return passengerType;
                }

                /** 
                 * Set the 'PassengerType' attribute value. Used to add a passenger type code into the record.
                                                                            Please note that this qualifier is not applicable to Sabre Sonic Res-based clients.
                 * 
                 * @param passengerType
                 */
                public void setPassengerType(String passengerType) {
                    this.passengerType = passengerType;
                }
                /** 
                 * Group details.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="VendorPrefs" minOccurs="0">
                 *         &lt;!-- Reference to inner class VendorPrefs -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Name"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="NumSeatsRemaining"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GroupInfo implements Serializable
                {
                    private VendorPrefs vendorPrefs;
                    private String name;
                    private BigInteger numSeatsRemaining;

                    /** 
                     * Get the 'VendorPrefs' element value.
                     * 
                     * @return value
                     */
                    public VendorPrefs getVendorPrefs() {
                        return vendorPrefs;
                    }

                    /** 
                     * Set the 'VendorPrefs' element value.
                     * 
                     * @param vendorPrefs
                     */
                    public void setVendorPrefs(VendorPrefs vendorPrefs) {
                        this.vendorPrefs = vendorPrefs;
                    }

                    /** 
                     * Get the 'Name' attribute value. Used to specify miscellaneous group booking-related free text title information.
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value. Used to specify miscellaneous group booking-related free text title information.
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }

                    /** 
                     * Get the 'NumSeatsRemaining' attribute value. Used to specify the number of passengers travelling in a group.
                     * 
                     * @return value
                     */
                    public BigInteger getNumSeatsRemaining() {
                        return numSeatsRemaining;
                    }

                    /** 
                     * Set the 'NumSeatsRemaining' attribute value. Used to specify the number of passengers travelling in a group.
                     * 
                     * @param numSeatsRemaining
                     */
                    public void setNumSeatsRemaining(
                            BigInteger numSeatsRemaining) {
                        this.numSeatsRemaining = numSeatsRemaining;
                    }
                    /** 
                     * Used to specify the vendor preferences.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Airline">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class VendorPrefs implements Serializable
                    {
                        private String airline;

                        /** 
                         * Get the 'Code' attribute value. Used to specify the airline that the group is travelling on.
                                                                                                                    Please note that this qualifier is not applicable to Sabre Sonic Res-based subscribers, or Sabre Travel Network-based subscribers.
                         * 
                         * @return value
                         */
                        public String getAirline() {
                            return airline;
                        }

                        /** 
                         * Set the 'Code' attribute value. Used to specify the airline that the group is travelling on.
                                                                                                                    Please note that this qualifier is not applicable to Sabre Sonic Res-based subscribers, or Sabre Travel Network-based subscribers.
                         * 
                         * @param airline
                         */
                        public void setAirline(String airline) {
                            this.airline = airline;
                        }
                    }
                }
            }
        }
    }
}
