
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PaymentType"/>
 *     &lt;xs:element type="xs:string" name="TripCategory" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardCode"/>
 *     &lt;xs:element name="CardNumber">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:boolean" name="tokenized"/>
 *             &lt;xs:attribute type="xs:boolean" name="masked"/>
 *             &lt;xs:attribute type="xs:string" name="token"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ExpiryMonth"/>
 *     &lt;xs:element type="xs:string" name="ExpiryYear"/>
 *     &lt;xs:element type="xs:string" name="ExtendPayment" minOccurs="0"/>
 *     &lt;xs:element name="ApprovalList" minOccurs="0">
 *       &lt;!-- Reference to inner class ApprovalList -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="DeferredPaymentID" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="DefaultExtendPayment" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="SuppressFromInvoice" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="GenerateApprovalAtTicketing" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CSCResultCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CSCRemark" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AVSResultCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AVSRemark" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardHolderName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CSC" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CSCValidatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="ns:StrongCustomerAuthentication" name="StrongCustomerAuthentication" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="reconcileAsCash"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCard implements Serializable
{
    private String paymentType;
    private String tripCategory;
    private String cardType;
    private String cardCode;
    private String cardNumberString;
    private Boolean cardNumberTokenized;
    private Boolean cardNumberMasked;
    private String cardNumberToken;
    private String expiryMonth;
    private String expiryYear;
    private String extendPayment;
    private ApprovalList approvalList;
    private String deferredPaymentID;
    private Boolean defaultExtendPayment;
    private Boolean suppressFromInvoice;
    private Boolean generateApprovalAtTicketing;
    private String CSCResultCode;
    private String CSCRemark;
    private String AVSResultCode;
    private String AVSRemark;
    private String BNumber;
    private String cardHolderName;
    private String CSC;
    private String CSCValidatingCarrier;
    private List<StrongCustomerAuthentication> strongCustomerAuthenticationList = new ArrayList<StrongCustomerAuthentication>();
    private Boolean reconcileAsCash;

    /** 
     * Get the 'PaymentType' element value.
     * 
     * @return value
     */
    public String getPaymentType() {
        return paymentType;
    }

    /** 
     * Set the 'PaymentType' element value.
     * 
     * @param paymentType
     */
    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    /** 
     * Get the 'TripCategory' element value.
     * 
     * @return value
     */
    public String getTripCategory() {
        return tripCategory;
    }

    /** 
     * Set the 'TripCategory' element value.
     * 
     * @param tripCategory
     */
    public void setTripCategory(String tripCategory) {
        this.tripCategory = tripCategory;
    }

    /** 
     * Get the 'CardType' element value. Indicates the type of magnetic striped card. Refer to OTA Code ListCard Type (CDT).
     * 
     * @return value
     */
    public String getCardType() {
        return cardType;
    }

    /** 
     * Set the 'CardType' element value. Indicates the type of magnetic striped card. Refer to OTA Code ListCard Type (CDT).
     * 
     * @param cardType
     */
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    /** 
     * Get the 'CardCode' element value. The 2 character code of the credit card issuer
     * 
     * @return value
     */
    public String getCardCode() {
        return cardCode;
    }

    /** 
     * Set the 'CardCode' element value. The 2 character code of the credit card issuer
     * 
     * @param cardCode
     */
    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getCardNumberString() {
        return cardNumberString;
    }

    /** 
     * Set the extension value.
     * 
     * @param cardNumberString
     */
    public void setCardNumberString(String cardNumberString) {
        this.cardNumberString = cardNumberString;
    }

    /** 
     * Get the 'tokenized' attribute value.
     * 
     * @return value
     */
    public Boolean getCardNumberTokenized() {
        return cardNumberTokenized;
    }

    /** 
     * Set the 'tokenized' attribute value.
     * 
     * @param cardNumberTokenized
     */
    public void setCardNumberTokenized(Boolean cardNumberTokenized) {
        this.cardNumberTokenized = cardNumberTokenized;
    }

    /** 
     * Get the 'masked' attribute value.
     * 
     * @return value
     */
    public Boolean getCardNumberMasked() {
        return cardNumberMasked;
    }

    /** 
     * Set the 'masked' attribute value.
     * 
     * @param cardNumberMasked
     */
    public void setCardNumberMasked(Boolean cardNumberMasked) {
        this.cardNumberMasked = cardNumberMasked;
    }

    /** 
     * Get the 'token' attribute value.
     * 
     * @return value
     */
    public String getCardNumberToken() {
        return cardNumberToken;
    }

    /** 
     * Set the 'token' attribute value.
     * 
     * @param cardNumberToken
     */
    public void setCardNumberToken(String cardNumberToken) {
        this.cardNumberToken = cardNumberToken;
    }

    /** 
     * Get the 'ExpiryMonth' element value.
     * 
     * @return value
     */
    public String getExpiryMonth() {
        return expiryMonth;
    }

    /** 
     * Set the 'ExpiryMonth' element value.
     * 
     * @param expiryMonth
     */
    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    /** 
     * Get the 'ExpiryYear' element value.
     * 
     * @return value
     */
    public String getExpiryYear() {
        return expiryYear;
    }

    /** 
     * Set the 'ExpiryYear' element value.
     * 
     * @param expiryYear
     */
    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    /** 
     * Get the 'ExtendPayment' element value.
     * 
     * @return value
     */
    public String getExtendPayment() {
        return extendPayment;
    }

    /** 
     * Set the 'ExtendPayment' element value.
     * 
     * @param extendPayment
     */
    public void setExtendPayment(String extendPayment) {
        this.extendPayment = extendPayment;
    }

    /** 
     * Get the 'ApprovalList' element value.
     * 
     * @return value
     */
    public ApprovalList getApprovalList() {
        return approvalList;
    }

    /** 
     * Set the 'ApprovalList' element value.
     * 
     * @param approvalList
     */
    public void setApprovalList(ApprovalList approvalList) {
        this.approvalList = approvalList;
    }

    /** 
     * Get the 'DeferredPaymentID' element value. Used to store Deferred Payment ID from ticketing transaction
     * 
     * @return value
     */
    public String getDeferredPaymentID() {
        return deferredPaymentID;
    }

    /** 
     * Set the 'DeferredPaymentID' element value. Used to store Deferred Payment ID from ticketing transaction
     * 
     * @param deferredPaymentID
     */
    public void setDeferredPaymentID(String deferredPaymentID) {
        this.deferredPaymentID = deferredPaymentID;
    }

    /** 
     * Get the 'DefaultExtendPayment' element value.
     * 
     * @return value
     */
    public Boolean getDefaultExtendPayment() {
        return defaultExtendPayment;
    }

    /** 
     * Set the 'DefaultExtendPayment' element value.
     * 
     * @param defaultExtendPayment
     */
    public void setDefaultExtendPayment(Boolean defaultExtendPayment) {
        this.defaultExtendPayment = defaultExtendPayment;
    }

    /** 
     * Get the 'SuppressFromInvoice' element value.
     * 
     * @return value
     */
    public Boolean getSuppressFromInvoice() {
        return suppressFromInvoice;
    }

    /** 
     * Set the 'SuppressFromInvoice' element value.
     * 
     * @param suppressFromInvoice
     */
    public void setSuppressFromInvoice(Boolean suppressFromInvoice) {
        this.suppressFromInvoice = suppressFromInvoice;
    }

    /** 
     * Get the 'GenerateApprovalAtTicketing' element value.
     * 
     * @return value
     */
    public Boolean getGenerateApprovalAtTicketing() {
        return generateApprovalAtTicketing;
    }

    /** 
     * Set the 'GenerateApprovalAtTicketing' element value.
     * 
     * @param generateApprovalAtTicketing
     */
    public void setGenerateApprovalAtTicketing(
            Boolean generateApprovalAtTicketing) {
        this.generateApprovalAtTicketing = generateApprovalAtTicketing;
    }

    /** 
     * Get the 'CSCResultCode' element value.
     * 
     * @return value
     */
    public String getCSCResultCode() {
        return CSCResultCode;
    }

    /** 
     * Set the 'CSCResultCode' element value.
     * 
     * @param CSCResultCode
     */
    public void setCSCResultCode(String CSCResultCode) {
        this.CSCResultCode = CSCResultCode;
    }

    /** 
     * Get the 'CSCRemark' element value.
     * 
     * @return value
     */
    public String getCSCRemark() {
        return CSCRemark;
    }

    /** 
     * Set the 'CSCRemark' element value.
     * 
     * @param CSCRemark
     */
    public void setCSCRemark(String CSCRemark) {
        this.CSCRemark = CSCRemark;
    }

    /** 
     * Get the 'AVSResultCode' element value.
     * 
     * @return value
     */
    public String getAVSResultCode() {
        return AVSResultCode;
    }

    /** 
     * Set the 'AVSResultCode' element value.
     * 
     * @param AVSResultCode
     */
    public void setAVSResultCode(String AVSResultCode) {
        this.AVSResultCode = AVSResultCode;
    }

    /** 
     * Get the 'AVSRemark' element value.
     * 
     * @return value
     */
    public String getAVSRemark() {
        return AVSRemark;
    }

    /** 
     * Set the 'AVSRemark' element value.
     * 
     * @param AVSRemark
     */
    public void setAVSRemark(String AVSRemark) {
        this.AVSRemark = AVSRemark;
    }

    /** 
     * Get the 'BNumber' element value.
     * 
     * @return value
     */
    public String getBNumber() {
        return BNumber;
    }

    /** 
     * Set the 'BNumber' element value.
     * 
     * @param BNumber
     */
    public void setBNumber(String BNumber) {
        this.BNumber = BNumber;
    }

    /** 
     * Get the 'CardHolderName' element value.
     * 
     * @return value
     */
    public String getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value.
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'CSC' element value.
     * 
     * @return value
     */
    public String getCSC() {
        return CSC;
    }

    /** 
     * Set the 'CSC' element value.
     * 
     * @param CSC
     */
    public void setCSC(String CSC) {
        this.CSC = CSC;
    }

    /** 
     * Get the 'CSCValidatingCarrier' element value.
     * 
     * @return value
     */
    public String getCSCValidatingCarrier() {
        return CSCValidatingCarrier;
    }

    /** 
     * Set the 'CSCValidatingCarrier' element value.
     * 
     * @param CSCValidatingCarrier
     */
    public void setCSCValidatingCarrier(String CSCValidatingCarrier) {
        this.CSCValidatingCarrier = CSCValidatingCarrier;
    }

    /** 
     * Get the list of 'StrongCustomerAuthentication' element items.
     * 
     * @return list
     */
    public List<StrongCustomerAuthentication> getStrongCustomerAuthenticationList() {
        return strongCustomerAuthenticationList;
    }

    /** 
     * Set the list of 'StrongCustomerAuthentication' element items.
     * 
     * @param list
     */
    public void setStrongCustomerAuthenticationList(
            List<StrongCustomerAuthentication> list) {
        strongCustomerAuthenticationList = list;
    }

    /** 
     * Get the 'reconcileAsCash' attribute value.
     * 
     * @return value
     */
    public Boolean getReconcileAsCash() {
        return reconcileAsCash;
    }

    /** 
     * Set the 'reconcileAsCash' attribute value.
     * 
     * @param reconcileAsCash
     */
    public void setReconcileAsCash(Boolean reconcileAsCash) {
        this.reconcileAsCash = reconcileAsCash;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApprovalList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PaymentCardApproval" name="Approval" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ApprovalList implements Serializable
    {
        private List<PaymentCardApproval> approvalList = new ArrayList<PaymentCardApproval>();

        /** 
         * Get the list of 'Approval' element items.
         * 
         * @return list
         */
        public List<PaymentCardApproval> getApprovalList() {
            return approvalList;
        }

        /** 
         * Set the list of 'Approval' element items.
         * 
         * @param list
         */
        public void setApprovalList(List<PaymentCardApproval> list) {
            approvalList = list;
        }
    }
}
