
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.FareComponent.FlightSegment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="SegmentNumber"/>
 *     &lt;xs:element type="ns:Amount" name="StopoverOrTransferCharge" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComponent.Surcharge" name="Surcharge" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComponent.Mileage" name="Mileage" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="fareBreakPoint"/>
 *   &lt;xs:attribute type="xs:boolean" name="turnAroundPoint"/>
 *   &lt;xs:attribute type="xs:boolean" name="noBreakPoint"/>
 *   &lt;xs:attribute type="xs:boolean" name="zeroFareAmount"/>
 *   &lt;xs:attribute type="xs:boolean" name="stopOverConnOverride"/>
 *   &lt;xs:attribute type="xs:boolean" name="unChargeableSurface"/>
 *   &lt;xs:attribute type="xs:boolean" name="sideTripStart"/>
 *   &lt;xs:attribute type="xs:boolean" name="sideTripEnd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsFareComponentFlightSegment implements
    Serializable
{
    private BigInteger segmentNumber;
    private List<Amount> stopoverOrTransferChargeList = new ArrayList<Amount>();
    private List<PriceQuoteDetailsFareComponentSurcharge> surchargeList = new ArrayList<PriceQuoteDetailsFareComponentSurcharge>();
    private PriceQuoteDetailsFareComponentMileage mileage;
    private Amount amount;
    private Boolean fareBreakPoint;
    private Boolean turnAroundPoint;
    private Boolean noBreakPoint;
    private Boolean zeroFareAmount;
    private Boolean stopOverConnOverride;
    private Boolean unChargeableSurface;
    private Boolean sideTripStart;
    private Boolean sideTripEnd;

    /** 
     * Get the 'SegmentNumber' element value.
     * 
     * @return value
     */
    public BigInteger getSegmentNumber() {
        return segmentNumber;
    }

    /** 
     * Set the 'SegmentNumber' element value.
     * 
     * @param segmentNumber
     */
    public void setSegmentNumber(BigInteger segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    /** 
     * Get the list of 'StopoverOrTransferCharge' element items. Stopover charge or Transfer charge

                          Ref:
                          if DM0Z_A0_SKEY=x'10'
                          DM0Z_A0_AMNT
     * 
     * @return list
     */
    public List<Amount> getStopoverOrTransferChargeList() {
        return stopoverOrTransferChargeList;
    }

    /** 
     * Set the list of 'StopoverOrTransferCharge' element items. Stopover charge or Transfer charge

                          Ref:
                          if DM0Z_A0_SKEY=x'10'
                          DM0Z_A0_AMNT
     * 
     * @param list
     */
    public void setStopoverOrTransferChargeList(List<Amount> list) {
        stopoverOrTransferChargeList = list;
    }

    /** 
     * Get the list of 'Surcharge' element items. Surcharge
     * 
     * @return list
     */
    public List<PriceQuoteDetailsFareComponentSurcharge> getSurchargeList() {
        return surchargeList;
    }

    /** 
     * Set the list of 'Surcharge' element items. Surcharge
     * 
     * @param list
     */
    public void setSurchargeList(
            List<PriceQuoteDetailsFareComponentSurcharge> list) {
        surchargeList = list;
    }

    /** 
     * Get the 'Mileage' element value. Mileage
     * 
     * @return value
     */
    public PriceQuoteDetailsFareComponentMileage getMileage() {
        return mileage;
    }

    /** 
     * Set the 'Mileage' element value. Mileage
     * 
     * @param mileage
     */
    public void setMileage(PriceQuoteDetailsFareComponentMileage mileage) {
        this.mileage = mileage;
    }

    /** 
     * Get the 'Amount' element value. Amount by segment

                          Ref: DM0Z_70_FBAM

                          Decimal position

                          Ref: DM0Z_70_FBDP

                          Currency code

                          Ref: DM0Z_70_FBAC
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Amount by segment

                          Ref: DM0Z_70_FBAM

                          Decimal position

                          Ref: DM0Z_70_FBDP

                          Currency code

                          Ref: DM0Z_70_FBAC
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'fareBreakPoint' attribute value. Fare Break Point
                      Ref: DM0Z_70_FARI #DM0Z_70_FBK
     * 
     * @return value
     */
    public Boolean getFareBreakPoint() {
        return fareBreakPoint;
    }

    /** 
     * Set the 'fareBreakPoint' attribute value. Fare Break Point
                      Ref: DM0Z_70_FARI #DM0Z_70_FBK
     * 
     * @param fareBreakPoint
     */
    public void setFareBreakPoint(Boolean fareBreakPoint) {
        this.fareBreakPoint = fareBreakPoint;
    }

    /** 
     * Get the 'turnAroundPoint' attribute value. Turn Around Point
                      Ref: DM0Z_70_FARI #DM0Z_70_TAP
     * 
     * @return value
     */
    public Boolean getTurnAroundPoint() {
        return turnAroundPoint;
    }

    /** 
     * Set the 'turnAroundPoint' attribute value. Turn Around Point
                      Ref: DM0Z_70_FARI #DM0Z_70_TAP
     * 
     * @param turnAroundPoint
     */
    public void setTurnAroundPoint(Boolean turnAroundPoint) {
        this.turnAroundPoint = turnAroundPoint;
    }

    /** 
     * Get the 'noBreakPoint' attribute value. No break point
                      Ref: DM0Z_70_FARI #DM0Z_70_NBK
     * 
     * @return value
     */
    public Boolean getNoBreakPoint() {
        return noBreakPoint;
    }

    /** 
     * Set the 'noBreakPoint' attribute value. No break point
                      Ref: DM0Z_70_FARI #DM0Z_70_NBK
     * 
     * @param noBreakPoint
     */
    public void setNoBreakPoint(Boolean noBreakPoint) {
        this.noBreakPoint = noBreakPoint;
    }

    /** 
     * Get the 'zeroFareAmount' attribute value. Zero fare amount
                      Ref: DM0Z_70_FARI #DM0Z_70_ZER
     * 
     * @return value
     */
    public Boolean getZeroFareAmount() {
        return zeroFareAmount;
    }

    /** 
     * Set the 'zeroFareAmount' attribute value. Zero fare amount
                      Ref: DM0Z_70_FARI #DM0Z_70_ZER
     * 
     * @param zeroFareAmount
     */
    public void setZeroFareAmount(Boolean zeroFareAmount) {
        this.zeroFareAmount = zeroFareAmount;
    }

    /** 
     * Get the 'stopOverConnOverride' attribute value. Stopover connection override
                      Ref: DM0Z_70_FARI #DM0Z_70_FSN
     * 
     * @return value
     */
    public Boolean getStopOverConnOverride() {
        return stopOverConnOverride;
    }

    /** 
     * Set the 'stopOverConnOverride' attribute value. Stopover connection override
                      Ref: DM0Z_70_FARI #DM0Z_70_FSN
     * 
     * @param stopOverConnOverride
     */
    public void setStopOverConnOverride(Boolean stopOverConnOverride) {
        this.stopOverConnOverride = stopOverConnOverride;
    }

    /** 
     * Get the 'unChargeableSurface' attribute value. Uncheargable surface
                      Ref: DM0Z_70_FARI #DM0Z_70_SUR
     * 
     * @return value
     */
    public Boolean getUnChargeableSurface() {
        return unChargeableSurface;
    }

    /** 
     * Set the 'unChargeableSurface' attribute value. Uncheargable surface
                      Ref: DM0Z_70_FARI #DM0Z_70_SUR
     * 
     * @param unChargeableSurface
     */
    public void setUnChargeableSurface(Boolean unChargeableSurface) {
        this.unChargeableSurface = unChargeableSurface;
    }

    /** 
     * Get the 'sideTripStart' attribute value. Sidetrip start
                      Ref: DM0Z_70_FARI #DM0Z_70_STS
     * 
     * @return value
     */
    public Boolean getSideTripStart() {
        return sideTripStart;
    }

    /** 
     * Set the 'sideTripStart' attribute value. Sidetrip start
                      Ref: DM0Z_70_FARI #DM0Z_70_STS
     * 
     * @param sideTripStart
     */
    public void setSideTripStart(Boolean sideTripStart) {
        this.sideTripStart = sideTripStart;
    }

    /** 
     * Get the 'sideTripEnd' attribute value. Sidetrip end
                      Ref: DM0Z_70_FARI #DM0Z_70_STE
     * 
     * @return value
     */
    public Boolean getSideTripEnd() {
        return sideTripEnd;
    }

    /** 
     * Set the 'sideTripEnd' attribute value. Sidetrip end
                      Ref: DM0Z_70_FARI #DM0Z_70_STE
     * 
     * @param sideTripEnd
     */
    public void setSideTripEnd(Boolean sideTripEnd) {
        this.sideTripEnd = sideTripEnd;
    }
}
