
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.FareComponent.Surcharge">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Extended.CityCode" name="ArrivalCityCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:Extended.CityCode" name="DepartureCityCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="Fare" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="nature"/>
 *   &lt;xs:attribute type="xs:string" name="natureType"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsFareComponentSurcharge implements Serializable
{
    private ExtendedCityCode arrivalCityCode;
    private ExtendedCityCode departureCityCode;
    private Amount fare;
    private String description;
    private String nature;
    private String natureType;

    /** 
     * Get the 'ArrivalCityCode' element value. Arrival city code

                          Ref:
                          DM0Z_A0_CTY1
     * 
     * @return value
     */
    public ExtendedCityCode getArrivalCityCode() {
        return arrivalCityCode;
    }

    /** 
     * Set the 'ArrivalCityCode' element value. Arrival city code

                          Ref:
                          DM0Z_A0_CTY1
     * 
     * @param arrivalCityCode
     */
    public void setArrivalCityCode(ExtendedCityCode arrivalCityCode) {
        this.arrivalCityCode = arrivalCityCode;
    }

    /** 
     * Get the 'DepartureCityCode' element value. Departure city code

                          Ref:
                          DM0Z_A0_CTY2
     * 
     * @return value
     */
    public ExtendedCityCode getDepartureCityCode() {
        return departureCityCode;
    }

    /** 
     * Set the 'DepartureCityCode' element value. Departure city code

                          Ref:
                          DM0Z_A0_CTY2
     * 
     * @param departureCityCode
     */
    public void setDepartureCityCode(ExtendedCityCode departureCityCode) {
        this.departureCityCode = departureCityCode;
    }

    /** 
     * Get the 'Fare' element value. Surcharge fare

                          Ref: DM0Z_A0_AMNT
     * 
     * @return value
     */
    public Amount getFare() {
        return fare;
    }

    /** 
     * Set the 'Fare' element value. Surcharge fare

                          Ref: DM0Z_A0_AMNT
     * 
     * @param fare
     */
    public void setFare(Amount fare) {
        this.fare = fare;
    }

    /** 
     * Get the 'Description' element value. Surcharge description

                          Ref: DM0Z_A0_SUR_SCD
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Surcharge description

                          Ref: DM0Z_A0_SUR_SCD
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'nature' attribute value. nature
                      Ref: DM0Z_A0_SKEY
                      Possible values:
                      S - Segment surcharge

                      C - Fare component surcharge

                      J - Journey surcharge
                  
     * 
     * @return value
     */
    public String getNature() {
        return nature;
    }

    /** 
     * Set the 'nature' attribute value. nature
                      Ref: DM0Z_A0_SKEY
                      Possible values:
                      S - Segment surcharge

                      C - Fare component surcharge

                      J - Journey surcharge
                  
     * 
     * @param nature
     */
    public void setNature(String nature) {
        this.nature = nature;
    }

    /** 
     * Get the 'natureType' attribute value. nature type
                      Ref:  DM0Z_A0_SKEY

                      Possible value:
                      Q - Q surcharge
     * 
     * @return value
     */
    public String getNatureType() {
        return natureType;
    }

    /** 
     * Set the 'natureType' attribute value. nature type
                      Ref:  DM0Z_A0_SKEY

                      Possible value:
                      Q - Q surcharge
     * 
     * @param natureType
     */
    public void setNatureType(String natureType) {
        this.natureType = natureType;
    }
}
