
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.RelatedDoc.Payment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount.Pattern" name="Amount" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="sequence"/>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteRelatedDocPayment implements Serializable
{
    private AmountPattern amount;
    private Choice choice;
    private BigInteger sequence;
    private String type;

    /** 
     * Get the 'Amount' element value. Amount associated to FOP	Ref: DM0Z_B0_FAMT for Exchange
                      
     * 
     * @return value
     */
    public AmountPattern getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Amount associated to FOP	Ref: DM0Z_B0_FAMT for Exchange
                      
     * 
     * @param amount
     */
    public void setAmount(AmountPattern amount) {
        this.amount = amount;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'sequence' attribute value. Serial number of the FOP
                      1,2
                      Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
                  
     * 
     * @return value
     */
    public BigInteger getSequence() {
        return sequence;
    }

    /** 
     * Set the 'sequence' attribute value. Serial number of the FOP
                      1,2
                      Ref: DM0Z_C2_FOPS, DM0Z_B0_DFPN for Exchange
                  
     * 
     * @param sequence
     */
    public void setSequence(BigInteger sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'type' attribute value. Form of payment (e.g. CC, CA..)
                      Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
                  
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Form of payment (e.g. CC, CA..)
                      Ref: DM0Z_C2_FOPT, DM0Z_B0_FTYP for Exchange
                  
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="xs:string" name="Virtual"/>
     *   &lt;xs:element type="ns:Payment.Credit" name="Card"/>
     *   &lt;xs:element type="xs:string" name="NumberOrDetail"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int VIRTUAL_CHOICE = 0;
        private static final int CARD_CHOICE = 1;
        private static final int NUMBER_OR_DETAIL_CHOICE = 2;
        private String virtual;
        private PaymentCredit card;
        private String numberOrDetail;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Virtual is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifVirtual() {
            return choiceSelect == VIRTUAL_CHOICE;
        }

        /** 
         * Get the 'Virtual' element value. Ref: DM0Z_B0_FOPL 
         * 
         * @return value
         */
        public String getVirtual() {
            return virtual;
        }

        /** 
         * Set the 'Virtual' element value. Ref: DM0Z_B0_FOPL 
         * 
         * @param virtual
         */
        public void setVirtual(String virtual) {
            setChoiceSelect(VIRTUAL_CHOICE);
            this.virtual = virtual;
        }

        /** 
         * Check if Card is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCard() {
            return choiceSelect == CARD_CHOICE;
        }

        /** 
         * Get the 'Card' element value.
         * 
         * @return value
         */
        public PaymentCredit getCard() {
            return card;
        }

        /** 
         * Set the 'Card' element value.
         * 
         * @param card
         */
        public void setCard(PaymentCredit card) {
            setChoiceSelect(CARD_CHOICE);
            this.card = card;
        }

        /** 
         * Check if NumberOrDetail is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifNumberOrDetail() {
            return choiceSelect == NUMBER_OR_DETAIL_CHOICE;
        }

        /** 
         * Get the 'NumberOrDetail' element value.
         * 
         * @return value
         */
        public String getNumberOrDetail() {
            return numberOrDetail;
        }

        /** 
         * Set the 'NumberOrDetail' element value.
         * 
         * @param numberOrDetail
         */
        public void setNumberOrDetail(String numberOrDetail) {
            setChoiceSelect(NUMBER_OR_DETAIL_CHOICE);
            this.numberOrDetail = numberOrDetail;
        }
    }
}
