
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Common pricing elements
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingElementsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Deposit" minOccurs="0">
 *       &lt;!-- Reference to inner class Deposit -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Discount" minOccurs="0" maxOccurs="99">
 *       &lt;!-- Reference to inner class Discount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Payment" minOccurs="0">
 *       &lt;!-- Reference to inner class Payment -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricingElementsType implements Serializable
{
    private Deposit deposit;
    private List<Discount> discountList = new ArrayList<Discount>();
    private Payment payment;

    /** 
     * Get the 'Deposit' element value.
     * 
     * @return value
     */
    public Deposit getDeposit() {
        return deposit;
    }

    /** 
     * Set the 'Deposit' element value.
     * 
     * @param deposit
     */
    public void setDeposit(Deposit deposit) {
        this.deposit = deposit;
    }

    /** 
     * Get the list of 'Discount' element items.
     * 
     * @return list
     */
    public List<Discount> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discount' element items.
     * 
     * @param list
     */
    public void setDiscountList(List<Discount> list) {
        discountList = list;
    }

    /** 
     * Get the 'Payment' element value.
     * 
     * @return value
     */
    public Payment getPayment() {
        return payment;
    }

    /** 
     * Set the 'Payment' element value.
     * 
     * @param payment
     */
    public void setPayment(Payment payment) {
        this.payment = payment;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deposit" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:date" name="DueDate" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:decimal" name="amount"/>
     *     &lt;xs:attribute type="xs:string" name="currencyCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Deposit implements Serializable
    {
        private Date dueDate;
        private BigDecimal amount;
        private String currencyCode;

        /** 
         * Get the 'DueDate' element value. Deposit due date
         * 
         * @return value
         */
        public Date getDueDate() {
            return dueDate;
        }

        /** 
         * Set the 'DueDate' element value. Deposit due date
         * 
         * @param dueDate
         */
        public void setDueDate(Date dueDate) {
            this.dueDate = dueDate;
        }

        /** 
         * Get the 'amount' attribute value. Amount to pay
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'amount' attribute value. Amount to pay
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'currencyCode' attribute value. Currency code
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value. Currency code
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="DiscountDescription" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:decimal" name="amount"/>
     *     &lt;xs:attribute type="xs:string" name="currencyCode"/>
     *     &lt;xs:attribute type="xs:string" name="type"/>
     *     &lt;xs:attribute type="xs:string" name="category"/>
     *     &lt;xs:attribute type="xs:string" name="promoType"/>
     *     &lt;xs:attribute type="xs:string" name="promoCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Discount implements Serializable
    {
        private String discountDescription;
        private BigDecimal amount;
        private String currencyCode;
        private String type;
        private String category;
        private String promoType;
        private String promoCode;

        /** 
         * Get the 'DiscountDescription' element value. Discount description
         * 
         * @return value
         */
        public String getDiscountDescription() {
            return discountDescription;
        }

        /** 
         * Set the 'DiscountDescription' element value. Discount description
         * 
         * @param discountDescription
         */
        public void setDiscountDescription(String discountDescription) {
            this.discountDescription = discountDescription;
        }

        /** 
         * Get the 'amount' attribute value. Discount amount
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'amount' attribute value. Discount amount
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'currencyCode' attribute value. Currency code
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value. Currency code
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'type' attribute value. Discount type
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Discount type
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'category' attribute value.
         * 
         * @return value
         */
        public String getCategory() {
            return category;
        }

        /** 
         * Set the 'category' attribute value.
         * 
         * @param category
         */
        public void setCategory(String category) {
            this.category = category;
        }

        /** 
         * Get the 'promoType' attribute value.
         * 
         * @return value
         */
        public String getPromoType() {
            return promoType;
        }

        /** 
         * Set the 'promoType' attribute value.
         * 
         * @param promoType
         */
        public void setPromoType(String promoType) {
            this.promoType = promoType;
        }

        /** 
         * Get the 'promoCode' attribute value.
         * 
         * @return value
         */
        public String getPromoCode() {
            return promoCode;
        }

        /** 
         * Set the 'promoCode' attribute value.
         * 
         * @param promoCode
         */
        public void setPromoCode(String promoCode) {
            this.promoCode = promoCode;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SubTotal" minOccurs="0">
     *         &lt;!-- Reference to inner class SubTotal -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Total" minOccurs="0">
     *         &lt;!-- Reference to inner class Total -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payment implements Serializable
    {
        private SubTotal subTotal;
        private Total total;

        /** 
         * Get the 'SubTotal' element value.
         * 
         * @return value
         */
        public SubTotal getSubTotal() {
            return subTotal;
        }

        /** 
         * Set the 'SubTotal' element value.
         * 
         * @param subTotal
         */
        public void setSubTotal(SubTotal subTotal) {
            this.subTotal = subTotal;
        }

        /** 
         * Get the 'Total' element value.
         * 
         * @return value
         */
        public Total getTotal() {
            return total;
        }

        /** 
         * Set the 'Total' element value.
         * 
         * @param total
         */
        public void setTotal(Total total) {
            this.total = total;
        }
        /** 
         * Total payment without discount
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubTotal" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:decimal" name="amount"/>
         *     &lt;xs:attribute type="xs:string" name="currency"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SubTotal implements Serializable
        {
            private BigDecimal amount;
            private String currency;

            /** 
             * Get the 'amount' attribute value. Amount to pay
             * 
             * @return value
             */
            public BigDecimal getAmount() {
                return amount;
            }

            /** 
             * Set the 'amount' attribute value. Amount to pay
             * 
             * @param amount
             */
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'currency' attribute value. Currency
             * 
             * @return value
             */
            public String getCurrency() {
                return currency;
            }

            /** 
             * Set the 'currency' attribute value. Currency
             * 
             * @param currency
             */
            public void setCurrency(String currency) {
                this.currency = currency;
            }
        }
        /** 
         * Total payment after discount
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:date" name="DueDate" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:decimal" name="amount"/>
         *     &lt;xs:attribute type="xs:string" name="currency"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Total implements Serializable
        {
            private Date dueDate;
            private BigDecimal amount;
            private String currency;

            /** 
             * Get the 'DueDate' element value. Payment due date
             * 
             * @return value
             */
            public Date getDueDate() {
                return dueDate;
            }

            /** 
             * Set the 'DueDate' element value. Payment due date
             * 
             * @param dueDate
             */
            public void setDueDate(Date dueDate) {
                this.dueDate = dueDate;
            }

            /** 
             * Get the 'amount' attribute value. Amount to pay
             * 
             * @return value
             */
            public BigDecimal getAmount() {
                return amount;
            }

            /** 
             * Set the 'amount' attribute value. Amount to pay
             * 
             * @param amount
             */
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'currency' attribute value. Currency
             * 
             * @return value
             */
            public String getCurrency() {
                return currency;
            }

            /** 
             * Set the 'currency' attribute value. Currency
             * 
             * @param currency
             */
            public void setCurrency(String currency) {
                this.currency = currency;
            }
        }
    }
}
