
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductBaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ProductType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VendorCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StartPoint" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="StartDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EndPoint" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="EndDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:int" name="SegmentReference" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProductBaseType implements Serializable
{
    private String productType;
    private String vendorCode;
    private String statusCode;
    private String startPoint;
    private Date startDateTime;
    private String endPoint;
    private Date endDateTime;
    private List<String> textList = new ArrayList<String>();
    private Integer segmentReference;

    /** 
     * Get the 'ProductType' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public String getProductType() {
        return productType;
    }

    /** 
     * Set the 'ProductType' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param productType
     */
    public void setProductType(String productType) {
        this.productType = productType;
    }

    /** 
     * Get the 'VendorCode' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'StatusCode' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'StartPoint' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public String getStartPoint() {
        return startPoint;
    }

    /** 
     * Set the 'StartPoint' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param startPoint
     */
    public void setStartPoint(String startPoint) {
        this.startPoint = startPoint;
    }

    /** 
     * Get the 'StartDateTime' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public Date getStartDateTime() {
        return startDateTime;
    }

    /** 
     * Set the 'StartDateTime' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param startDateTime
     */
    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    /** 
     * Get the 'EndPoint' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public String getEndPoint() {
        return endPoint;
    }

    /** 
     * Set the 'EndPoint' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param endPoint
     */
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    /** 
     * Get the 'EndDateTime' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public Date getEndDateTime() {
        return endDateTime;
    }

    /** 
     * Set the 'EndDateTime' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param endDateTime
     */
    public void setEndDateTime(Date endDateTime) {
        this.endDateTime = endDateTime;
    }

    /** 
     * Get the list of 'Text' element items. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return list
     */
    public List<String> getTextList() {
        return textList;
    }

    /** 
     * Set the list of 'Text' element items. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param list
     */
    public void setTextList(List<String> list) {
        textList = list;
    }

    /** 
     * Get the 'SegmentReference' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public Integer getSegmentReference() {
        return segmentReference;
    }

    /** 
     * Set the 'SegmentReference' element value. SegmentReference or a sequence of multiple product related elements are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param segmentReference
     */
    public void setSegmentReference(Integer segmentReference) {
        this.segmentReference = segmentReference;
    }
}
