
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
 this was simplified for easier xsd -&gt; JSON conversion.
 For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductDetailsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProductNameType" name="ProductName"/>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Hotel" minOccurs="0">
 *         &lt;!-- Reference to inner class Hotel -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Lodging" minOccurs="0">
 *         &lt;!-- Reference to inner class Lodging -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:GroundTransportationType" name="GroundTransportation" minOccurs="0"/>
 *       &lt;xs:element type="ns:RailType" name="Rail" minOccurs="0"/>
 *       &lt;xs:element type="ns:TourType" name="Tour" minOccurs="0"/>
 *       &lt;xs:element type="ns:AirType" name="Air" minOccurs="0"/>
 *       &lt;xs:element type="ns:VisaType" name="Visa" minOccurs="0"/>
 *       &lt;xs:element type="ns:VehicleType" name="Vehicle" minOccurs="0"/>
 *       &lt;xs:element type="ns:SkiType" name="Ski" minOccurs="0"/>
 *       &lt;xs:element type="ns:OtherType" name="Other" minOccurs="0"/>
 *       &lt;xs:element type="ns:InsuranceType" name="Insurance" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="ns:ExternalSystemReferenceType" name="ExternalSystemReference" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element name="TransactionInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class TransactionInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BillingInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class BillingInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CO2ValueType" name="CO2Value" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:SegmentCommonAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProductDetailsType implements Serializable
{
    private ProductNameType productName;
    private Hotel hotel;
    private Lodging lodging;
    private GroundTransportationType groundTransportation;
    private RailType rail;
    private TourType tour;
    private AirType air;
    private VisaType visa;
    private VehicleType vehicle;
    private SkiType ski;
    private OtherType other;
    private InsuranceType insurance;
    private List<ExternalSystemReferenceType> externalSystemReferenceList = new ArrayList<ExternalSystemReferenceType>();
    private TransactionInfo transactionInfo;
    private BillingInfo billingInfo;
    private CO2ValueType CO2Value;
    private String comment;
    private SegmentCommonAttributes segmentCommonAttributes;

    /** 
     * Get the 'ProductName' element value. ''ProductName'' returns the name of non-air product.
     * 
     * @return value
     */
    public ProductNameType getProductName() {
        return productName;
    }

    /** 
     * Set the 'ProductName' element value. ''ProductName'' returns the name of non-air product.
     * 
     * @param productName
     */
    public void setProductName(ProductNameType productName) {
        this.productName = productName;
    }

    /** 
     * Get the 'Hotel' element value.
     * 
     * @return value
     */
    public Hotel getHotel() {
        return hotel;
    }

    /** 
     * Set the 'Hotel' element value.
     * 
     * @param hotel
     */
    public void setHotel(Hotel hotel) {
        this.hotel = hotel;
    }

    /** 
     * Get the 'Lodging' element value.
     * 
     * @return value
     */
    public Lodging getLodging() {
        return lodging;
    }

    /** 
     * Set the 'Lodging' element value.
     * 
     * @param lodging
     */
    public void setLodging(Lodging lodging) {
        this.lodging = lodging;
    }

    /** 
     * Get the 'GroundTransportation' element value.
     * 
     * @return value
     */
    public GroundTransportationType getGroundTransportation() {
        return groundTransportation;
    }

    /** 
     * Set the 'GroundTransportation' element value.
     * 
     * @param groundTransportation
     */
    public void setGroundTransportation(
            GroundTransportationType groundTransportation) {
        this.groundTransportation = groundTransportation;
    }

    /** 
     * Get the 'Rail' element value.
     * 
     * @return value
     */
    public RailType getRail() {
        return rail;
    }

    /** 
     * Set the 'Rail' element value.
     * 
     * @param rail
     */
    public void setRail(RailType rail) {
        this.rail = rail;
    }

    /** 
     * Get the 'Tour' element value.
     * 
     * @return value
     */
    public TourType getTour() {
        return tour;
    }

    /** 
     * Set the 'Tour' element value.
     * 
     * @param tour
     */
    public void setTour(TourType tour) {
        this.tour = tour;
    }

    /** 
     * Get the 'Air' element value.
     * 
     * @return value
     */
    public AirType getAir() {
        return air;
    }

    /** 
     * Set the 'Air' element value.
     * 
     * @param air
     */
    public void setAir(AirType air) {
        this.air = air;
    }

    /** 
     * Get the 'Visa' element value.
     * 
     * @return value
     */
    public VisaType getVisa() {
        return visa;
    }

    /** 
     * Set the 'Visa' element value.
     * 
     * @param visa
     */
    public void setVisa(VisaType visa) {
        this.visa = visa;
    }

    /** 
     * Get the 'Vehicle' element value.
     * 
     * @return value
     */
    public VehicleType getVehicle() {
        return vehicle;
    }

    /** 
     * Set the 'Vehicle' element value.
     * 
     * @param vehicle
     */
    public void setVehicle(VehicleType vehicle) {
        this.vehicle = vehicle;
    }

    /** 
     * Get the 'Ski' element value.
     * 
     * @return value
     */
    public SkiType getSki() {
        return ski;
    }

    /** 
     * Set the 'Ski' element value.
     * 
     * @param ski
     */
    public void setSki(SkiType ski) {
        this.ski = ski;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public OtherType getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param other
     */
    public void setOther(OtherType other) {
        this.other = other;
    }

    /** 
     * Get the 'Insurance' element value.
     * 
     * @return value
     */
    public InsuranceType getInsurance() {
        return insurance;
    }

    /** 
     * Set the 'Insurance' element value.
     * 
     * @param insurance
     */
    public void setInsurance(InsuranceType insurance) {
        this.insurance = insurance;
    }

    /** 
     * Get the list of 'ExternalSystemReference' element items. Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
     * 
     * @return list
     */
    public List<ExternalSystemReferenceType> getExternalSystemReferenceList() {
        return externalSystemReferenceList;
    }

    /** 
     * Set the list of 'ExternalSystemReference' element items. Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
     * 
     * @param list
     */
    public void setExternalSystemReferenceList(
            List<ExternalSystemReferenceType> list) {
        externalSystemReferenceList = list;
    }

    /** 
     * Get the 'TransactionInfo' element value.
     * 
     * @return value
     */
    public TransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value.
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the 'BillingInfo' element value.
     * 
     * @return value
     */
    public BillingInfo getBillingInfo() {
        return billingInfo;
    }

    /** 
     * Set the 'BillingInfo' element value.
     * 
     * @param billingInfo
     */
    public void setBillingInfo(BillingInfo billingInfo) {
        this.billingInfo = billingInfo;
    }

    /** 
     * Get the 'CO2Value' element value.
     * 
     * @return value
     */
    public CO2ValueType getCO2Value() {
        return CO2Value;
    }

    /** 
     * Set the 'CO2Value' element value.
     * 
     * @param CO2Value
     */
    public void setCO2Value(CO2ValueType CO2Value) {
        this.CO2Value = CO2Value;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @return value
     */
    public SegmentCommonAttributes getSegmentCommonAttributes() {
        return segmentCommonAttributes;
    }

    /** 
     * Set the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @param segmentCommonAttributes
     */
    public void setSegmentCommonAttributes(
            SegmentCommonAttributes segmentCommonAttributes) {
        this.segmentCommonAttributes = segmentCommonAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hotel" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Reservation" minOccurs="0">
     *         &lt;!-- Reference to inner class Reservation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AdditionalInformation" minOccurs="0">
     *         &lt;!-- Reference to inner class AdditionalInformation -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="SegmentText" minOccurs="0"/>
     *       &lt;xs:element name="RateDescription" minOccurs="0">
     *         &lt;!-- Reference to inner class RateDescription -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="HotelPolicy" minOccurs="0">
     *         &lt;!-- Reference to inner class HotelPolicy -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="SupplementalInformation" minOccurs="0"/>
     *       &lt;xs:element name="PricingElements" minOccurs="0">
     *         &lt;!-- Reference to inner class PricingElements -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:integer" name="index"/>
     *     &lt;xs:attribute type="xs:string" name="id"/>
     *     &lt;xs:attribute type="xs:short" name="sequence"/>
     *     &lt;xs:attribute type="xs:boolean" name="isPast"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Hotel implements Serializable
    {
        private Reservation reservation;
        private AdditionalInformation additionalInformation;
        private String segmentText;
        private RateDescription rateDescription;
        private HotelPolicy hotelPolicy;
        private String supplementalInformation;
        private PricingElements pricingElements;
        private BigInteger index;
        private String id;
        private Short sequence;
        private Boolean isPast;

        /** 
         * Get the 'Reservation' element value.
         * 
         * @return value
         */
        public Reservation getReservation() {
            return reservation;
        }

        /** 
         * Set the 'Reservation' element value.
         * 
         * @param reservation
         */
        public void setReservation(Reservation reservation) {
            this.reservation = reservation;
        }

        /** 
         * Get the 'AdditionalInformation' element value.
         * 
         * @return value
         */
        public AdditionalInformation getAdditionalInformation() {
            return additionalInformation;
        }

        /** 
         * Set the 'AdditionalInformation' element value.
         * 
         * @param additionalInformation
         */
        public void setAdditionalInformation(
                AdditionalInformation additionalInformation) {
            this.additionalInformation = additionalInformation;
        }

        /** 
         * Get the 'SegmentText' element value. Raw sabre system hotel segment text.
         * 
         * @return value
         */
        public String getSegmentText() {
            return segmentText;
        }

        /** 
         * Set the 'SegmentText' element value. Raw sabre system hotel segment text.
         * 
         * @param segmentText
         */
        public void setSegmentText(String segmentText) {
            this.segmentText = segmentText;
        }

        /** 
         * Get the 'RateDescription' element value.
         * 
         * @return value
         */
        public RateDescription getRateDescription() {
            return rateDescription;
        }

        /** 
         * Set the 'RateDescription' element value.
         * 
         * @param rateDescription
         */
        public void setRateDescription(RateDescription rateDescription) {
            this.rateDescription = rateDescription;
        }

        /** 
         * Get the 'HotelPolicy' element value.
         * 
         * @return value
         */
        public HotelPolicy getHotelPolicy() {
            return hotelPolicy;
        }

        /** 
         * Set the 'HotelPolicy' element value.
         * 
         * @param hotelPolicy
         */
        public void setHotelPolicy(HotelPolicy hotelPolicy) {
            this.hotelPolicy = hotelPolicy;
        }

        /** 
         * Get the 'SupplementalInformation' element value. Supplemental information.
         * 
         * @return value
         */
        public String getSupplementalInformation() {
            return supplementalInformation;
        }

        /** 
         * Set the 'SupplementalInformation' element value. Supplemental information.
         * 
         * @param supplementalInformation
         */
        public void setSupplementalInformation(String supplementalInformation) {
            this.supplementalInformation = supplementalInformation;
        }

        /** 
         * Get the 'PricingElements' element value.
         * 
         * @return value
         */
        public PricingElements getPricingElements() {
            return pricingElements;
        }

        /** 
         * Set the 'PricingElements' element value.
         * 
         * @param pricingElements
         */
        public void setPricingElements(PricingElements pricingElements) {
            this.pricingElements = pricingElements;
        }

        /** 
         * Get the 'index' attribute value. Hotel product index.
         * 
         * @return value
         */
        public BigInteger getIndex() {
            return index;
        }

        /** 
         * Set the 'index' attribute value. Hotel product index.
         * 
         * @param index
         */
        public void setIndex(BigInteger index) {
            this.index = index;
        }

        /** 
         * Get the 'id' attribute value. Hotel product identifier.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' attribute value. Hotel product identifier.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }

        /** 
         * Get the 'sequence' attribute value. Identifies sequence number of itinerary.
         * 
         * @return value
         */
        public Short getSequence() {
            return sequence;
        }

        /** 
         * Set the 'sequence' attribute value. Identifies sequence number of itinerary.
         * 
         * @param sequence
         */
        public void setSequence(Short sequence) {
            this.sequence = sequence;
        }

        /** 
         * Get the 'isPast' attribute value. It returns information if current element is past or not.
         * 
         * @return value
         */
        public Boolean getIsPast() {
            return isPast;
        }

        /** 
         * Set the 'isPast' attribute value. It returns information if current element is past or not.
         * 
         * @param isPast
         */
        public void setIsPast(Boolean isPast) {
            this.isPast = isPast;
        }
        /** 
         * Hotel reservation  information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reservation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:integer" name="LineNumber" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="LineType" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="LineStatus" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="POSRequestorID" minOccurs="0"/>
         *       &lt;xs:element name="SpecialPrefs" minOccurs="0">
         *         &lt;!-- Reference to inner class SpecialPrefs -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RoomType" minOccurs="0">
         *         &lt;!-- Reference to inner class RoomType -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Services" minOccurs="0">
         *         &lt;!-- Reference to inner class Services -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RoomRates" minOccurs="0">
         *         &lt;!-- Reference to inner class RoomRates -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RateAccessCodeBooked" minOccurs="0">
         *         &lt;!-- Reference to inner class RateAccessCodeBooked -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="GuestCounts" minOccurs="0">
         *         &lt;!-- Reference to inner class GuestCounts -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:dateTime" name="TimeSpanStart" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="TimeSpanDuration" minOccurs="0"/>
         *       &lt;xs:element type="xs:dateTime" name="TimeSpanEnd" minOccurs="0"/>
         *       &lt;xs:element name="Guarantee" minOccurs="0">
         *         &lt;!-- Reference to inner class Guarantee -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ChainCode" minOccurs="0"/>
         *       &lt;xs:element name="HotelCode" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class HotelCode -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="HotelCityCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="HotelName" minOccurs="0"/>
         *       &lt;xs:element name="HotelTotalPricing" minOccurs="0">
         *         &lt;!-- Reference to inner class HotelTotalPricing -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="HotelReplyText" minOccurs="0"/>
         *       &lt;xs:element name="HotelUniqueID" minOccurs="0" maxOccurs="5">
         *         &lt;!-- Reference to inner class HotelUniqueID -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Reservation implements Serializable
        {
            private BigInteger lineNumber;
            private String lineType;
            private String lineStatus;
            private String POSRequestorID;
            private SpecialPrefs specialPrefs;
            private RoomType roomType;
            private Services services;
            private RoomRates roomRates;
            private RateAccessCodeBooked rateAccessCodeBooked;
            private GuestCounts guestCounts;
            private Date timeSpanStart;
            private String timeSpanDuration;
            private Date timeSpanEnd;
            private Guarantee guarantee;
            private String chainCode;
            private List<HotelCode> hotelCodeList = new ArrayList<HotelCode>();
            private String hotelCityCode;
            private String hotelName;
            private HotelTotalPricing hotelTotalPricing;
            private String hotelReplyText;
            private List<HotelUniqueID> hotelUniqueIDList = new ArrayList<HotelUniqueID>();

            /** 
             * Get the 'LineNumber' element value. Segment number.
             * 
             * @return value
             */
            public BigInteger getLineNumber() {
                return lineNumber;
            }

            /** 
             * Set the 'LineNumber' element value. Segment number.
             * 
             * @param lineNumber
             */
            public void setLineNumber(BigInteger lineNumber) {
                this.lineNumber = lineNumber;
            }

            /** 
             * Get the 'LineType' element value. Segment Type (Type 10).
             * 
             * @return value
             */
            public String getLineType() {
                return lineType;
            }

            /** 
             * Set the 'LineType' element value. Segment Type (Type 10).
             * 
             * @param lineType
             */
            public void setLineType(String lineType) {
                this.lineType = lineType;
            }

            /** 
             * Get the 'LineStatus' element value. Current action code.
             * 
             * @return value
             */
            public String getLineStatus() {
                return lineStatus;
            }

            /** 
             * Set the 'LineStatus' element value. Current action code.
             * 
             * @param lineStatus
             */
            public void setLineStatus(String lineStatus) {
                this.lineStatus = lineStatus;
            }

            /** 
             * Get the 'POSRequestorID' element value. Agency IATA or ARC number.
             * 
             * @return value
             */
            public String getPOSRequestorID() {
                return POSRequestorID;
            }

            /** 
             * Set the 'POSRequestorID' element value. Agency IATA or ARC number.
             * 
             * @param POSRequestorID
             */
            public void setPOSRequestorID(String POSRequestorID) {
                this.POSRequestorID = POSRequestorID;
            }

            /** 
             * Get the 'SpecialPrefs' element value.
             * 
             * @return value
             */
            public SpecialPrefs getSpecialPrefs() {
                return specialPrefs;
            }

            /** 
             * Set the 'SpecialPrefs' element value.
             * 
             * @param specialPrefs
             */
            public void setSpecialPrefs(SpecialPrefs specialPrefs) {
                this.specialPrefs = specialPrefs;
            }

            /** 
             * Get the 'RoomType' element value.
             * 
             * @return value
             */
            public RoomType getRoomType() {
                return roomType;
            }

            /** 
             * Set the 'RoomType' element value.
             * 
             * @param roomType
             */
            public void setRoomType(RoomType roomType) {
                this.roomType = roomType;
            }

            /** 
             * Get the 'Services' element value.
             * 
             * @return value
             */
            public Services getServices() {
                return services;
            }

            /** 
             * Set the 'Services' element value.
             * 
             * @param services
             */
            public void setServices(Services services) {
                this.services = services;
            }

            /** 
             * Get the 'RoomRates' element value.
             * 
             * @return value
             */
            public RoomRates getRoomRates() {
                return roomRates;
            }

            /** 
             * Set the 'RoomRates' element value.
             * 
             * @param roomRates
             */
            public void setRoomRates(RoomRates roomRates) {
                this.roomRates = roomRates;
            }

            /** 
             * Get the 'RateAccessCodeBooked' element value.
             * 
             * @return value
             */
            public RateAccessCodeBooked getRateAccessCodeBooked() {
                return rateAccessCodeBooked;
            }

            /** 
             * Set the 'RateAccessCodeBooked' element value.
             * 
             * @param rateAccessCodeBooked
             */
            public void setRateAccessCodeBooked(
                    RateAccessCodeBooked rateAccessCodeBooked) {
                this.rateAccessCodeBooked = rateAccessCodeBooked;
            }

            /** 
             * Get the 'GuestCounts' element value.
             * 
             * @return value
             */
            public GuestCounts getGuestCounts() {
                return guestCounts;
            }

            /** 
             * Set the 'GuestCounts' element value.
             * 
             * @param guestCounts
             */
            public void setGuestCounts(GuestCounts guestCounts) {
                this.guestCounts = guestCounts;
            }

            /** 
             * Get the 'TimeSpanStart' element value. Sabre hotel reservation in date.
             * 
             * @return value
             */
            public Date getTimeSpanStart() {
                return timeSpanStart;
            }

            /** 
             * Set the 'TimeSpanStart' element value. Sabre hotel reservation in date.
             * 
             * @param timeSpanStart
             */
            public void setTimeSpanStart(Date timeSpanStart) {
                this.timeSpanStart = timeSpanStart;
            }

            /** 
             * Get the 'TimeSpanDuration' element value. The lexical representation for timeDuration is the [ISO 8601] extended format PnYnMnDTnHnMnS, where:
                                                          `nY` - represents the number of years,
                                                          `nM` - the number of months,
                                                          `nD` - the number of days,
                                                          `T`  - is the date/time separator,
                                                          `nH` - the number of hours,
                                                          `nM` - the number of minutes,
                                                          `nS` - the number of seconds.
                                                          The number  of seconds can include decimal digits to arbitrary precision.
                                                          As an example, 7 months, 2 days, 2hours and 30 minutes would be expressed as P0Y7M2DT2H30M0S.
                                                          Truncated representations are allowed provided they conform to ISO 8601 format.
             * 
             * @return value
             */
            public String getTimeSpanDuration() {
                return timeSpanDuration;
            }

            /** 
             * Set the 'TimeSpanDuration' element value. The lexical representation for timeDuration is the [ISO 8601] extended format PnYnMnDTnHnMnS, where:
                                                          `nY` - represents the number of years,
                                                          `nM` - the number of months,
                                                          `nD` - the number of days,
                                                          `T`  - is the date/time separator,
                                                          `nH` - the number of hours,
                                                          `nM` - the number of minutes,
                                                          `nS` - the number of seconds.
                                                          The number  of seconds can include decimal digits to arbitrary precision.
                                                          As an example, 7 months, 2 days, 2hours and 30 minutes would be expressed as P0Y7M2DT2H30M0S.
                                                          Truncated representations are allowed provided they conform to ISO 8601 format.
             * 
             * @param timeSpanDuration
             */
            public void setTimeSpanDuration(String timeSpanDuration) {
                this.timeSpanDuration = timeSpanDuration;
            }

            /** 
             * Get the 'TimeSpanEnd' element value. Sabre hotel reservation out date.
             * 
             * @return value
             */
            public Date getTimeSpanEnd() {
                return timeSpanEnd;
            }

            /** 
             * Set the 'TimeSpanEnd' element value. Sabre hotel reservation out date.
             * 
             * @param timeSpanEnd
             */
            public void setTimeSpanEnd(Date timeSpanEnd) {
                this.timeSpanEnd = timeSpanEnd;
            }

            /** 
             * Get the 'Guarantee' element value.
             * 
             * @return value
             */
            public Guarantee getGuarantee() {
                return guarantee;
            }

            /** 
             * Set the 'Guarantee' element value.
             * 
             * @param guarantee
             */
            public void setGuarantee(Guarantee guarantee) {
                this.guarantee = guarantee;
            }

            /** 
             * Get the 'ChainCode' element value. The code that identifies a hotel chain or management group.
                                                          The hotel chain code is decided between vendors.
                                                          This attribute is optional if the hotel is an independent property that can be identified by the HotelCode attribute.
             * 
             * @return value
             */
            public String getChainCode() {
                return chainCode;
            }

            /** 
             * Set the 'ChainCode' element value. The code that identifies a hotel chain or management group.
                                                          The hotel chain code is decided between vendors.
                                                          This attribute is optional if the hotel is an independent property that can be identified by the HotelCode attribute.
             * 
             * @param chainCode
             */
            public void setChainCode(String chainCode) {
                this.chainCode = chainCode;
            }

            /** 
             * Get the list of 'HotelCode' element items.
             * 
             * @return list
             */
            public List<HotelCode> getHotelCodeList() {
                return hotelCodeList;
            }

            /** 
             * Set the list of 'HotelCode' element items.
             * 
             * @param list
             */
            public void setHotelCodeList(List<HotelCode> list) {
                hotelCodeList = list;
            }

            /** 
             * Get the 'HotelCityCode' element value. Sabre hotel airport city.
             * 
             * @return value
             */
            public String getHotelCityCode() {
                return hotelCityCode;
            }

            /** 
             * Set the 'HotelCityCode' element value. Sabre hotel airport city.
             * 
             * @param hotelCityCode
             */
            public void setHotelCityCode(String hotelCityCode) {
                this.hotelCityCode = hotelCityCode;
            }

            /** 
             * Get the 'HotelName' element value. Sabre hotel property name.
             * 
             * @return value
             */
            public String getHotelName() {
                return hotelName;
            }

            /** 
             * Set the 'HotelName' element value. Sabre hotel property name.
             * 
             * @param hotelName
             */
            public void setHotelName(String hotelName) {
                this.hotelName = hotelName;
            }

            /** 
             * Get the 'HotelTotalPricing' element value.
             * 
             * @return value
             */
            public HotelTotalPricing getHotelTotalPricing() {
                return hotelTotalPricing;
            }

            /** 
             * Set the 'HotelTotalPricing' element value.
             * 
             * @param hotelTotalPricing
             */
            public void setHotelTotalPricing(HotelTotalPricing hotelTotalPricing) {
                this.hotelTotalPricing = hotelTotalPricing;
            }

            /** 
             * Get the 'HotelReplyText' element value. A text field with info received from the hotel at the time of booking.
             * 
             * @return value
             */
            public String getHotelReplyText() {
                return hotelReplyText;
            }

            /** 
             * Set the 'HotelReplyText' element value. A text field with info received from the hotel at the time of booking.
             * 
             * @param hotelReplyText
             */
            public void setHotelReplyText(String hotelReplyText) {
                this.hotelReplyText = hotelReplyText;
            }

            /** 
             * Get the list of 'HotelUniqueID' element items.
             * 
             * @return list
             */
            public List<HotelUniqueID> getHotelUniqueIDList() {
                return hotelUniqueIDList;
            }

            /** 
             * Set the list of 'HotelUniqueID' element items.
             * 
             * @param list
             */
            public void setHotelUniqueIDList(List<HotelUniqueID> list) {
                hotelUniqueIDList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialPrefs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:boolean" name="LateDepartureRequired" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SpecialPrefs implements Serializable
            {
                private List<String> textList = new ArrayList<String>();
                private Boolean lateDepartureRequired;

                /** 
                 * Get the list of 'Text' element items. Special preferences text.
                 * 
                 * @return list
                 */
                public List<String> getTextList() {
                    return textList;
                }

                /** 
                 * Set the list of 'Text' element items. Special preferences text.
                 * 
                 * @param list
                 */
                public void setTextList(List<String> list) {
                    textList = list;
                }

                /** 
                 * Get the 'LateDepartureRequired' element value. Late departure required indicator.
                 * 
                 * @return value
                 */
                public Boolean getLateDepartureRequired() {
                    return lateDepartureRequired;
                }

                /** 
                 * Set the 'LateDepartureRequired' element value. Late departure required indicator.
                 * 
                 * @param lateDepartureRequired
                 */
                public void setLateDepartureRequired(
                        Boolean lateDepartureRequired) {
                    this.lateDepartureRequired = lateDepartureRequired;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="RoomTypeCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:integer" name="NumberOfUnits" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ShortText" minOccurs="0"/>
             *       &lt;xs:element type="xs:unsignedShort" name="RateOccupancyPerRoom" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="BedTypeDesc" minOccurs="0"/>
             *       &lt;xs:element type="xs:unsignedShort" name="NumOfBeds" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RoomType implements Serializable
            {
                private String roomTypeCode;
                private BigInteger numberOfUnits;
                private String shortText;
                private String rateOccupancyPerRoom;
                private String bedTypeDesc;
                private String numOfBeds;

                /** 
                 * Get the 'RoomTypeCode' element value. Specific system room type code, ex: A1K, A1Q etc.
                 * 
                 * @return value
                 */
                public String getRoomTypeCode() {
                    return roomTypeCode;
                }

                /** 
                 * Set the 'RoomTypeCode' element value. Specific system room type code, ex: A1K, A1Q etc.
                 * 
                 * @param roomTypeCode
                 */
                public void setRoomTypeCode(String roomTypeCode) {
                    this.roomTypeCode = roomTypeCode;
                }

                /** 
                 * Get the 'NumberOfUnits' element value. Number of rooms.
                 * 
                 * @return value
                 */
                public BigInteger getNumberOfUnits() {
                    return numberOfUnits;
                }

                /** 
                 * Set the 'NumberOfUnits' element value. Number of rooms.
                 * 
                 * @param numberOfUnits
                 */
                public void setNumberOfUnits(BigInteger numberOfUnits) {
                    this.numberOfUnits = numberOfUnits;
                }

                /** 
                 * Get the 'ShortText' element value. Room type short text information.
                 * 
                 * @return value
                 */
                public String getShortText() {
                    return shortText;
                }

                /** 
                 * Set the 'ShortText' element value. Room type short text information.
                 * 
                 * @param shortText
                 */
                public void setShortText(String shortText) {
                    this.shortText = shortText;
                }

                /** 
                 * Get the 'RateOccupancyPerRoom' element value. Indicates how many guests the room can accommodate for the provided rate.
                 * 
                 * @return value
                 */
                public String getRateOccupancyPerRoom() {
                    return rateOccupancyPerRoom;
                }

                /** 
                 * Set the 'RateOccupancyPerRoom' element value. Indicates how many guests the room can accommodate for the provided rate.
                 * 
                 * @param rateOccupancyPerRoom
                 */
                public void setRateOccupancyPerRoom(String rateOccupancyPerRoom) {
                    this.rateOccupancyPerRoom = rateOccupancyPerRoom;
                }

                /** 
                 * Get the 'BedTypeDesc' element value. Specifies the type of bed.
                 * 
                 * @return value
                 */
                public String getBedTypeDesc() {
                    return bedTypeDesc;
                }

                /** 
                 * Set the 'BedTypeDesc' element value. Specifies the type of bed.
                 * 
                 * @param bedTypeDesc
                 */
                public void setBedTypeDesc(String bedTypeDesc) {
                    this.bedTypeDesc = bedTypeDesc;
                }

                /** 
                 * Get the 'NumOfBeds' element value. Specifies the number of beds requested.
                 * 
                 * @return value
                 */
                public String getNumOfBeds() {
                    return numOfBeds;
                }

                /** 
                 * Set the 'NumOfBeds' element value. Specifies the number of beds requested.
                 * 
                 * @param numOfBeds
                 */
                public void setNumOfBeds(String numOfBeds) {
                    this.numOfBeds = numOfBeds;
                }
            }
            /** 
             * Specifies additional services to be provided by hotel.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MealType" minOccurs="0">
             *         &lt;!-- Reference to inner class MealType -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Services implements Serializable
            {
                private MealType mealType;

                /** 
                 * Get the 'MealType' element value.
                 * 
                 * @return value
                 */
                public MealType getMealType() {
                    return mealType;
                }

                /** 
                 * Set the 'MealType' element value.
                 * 
                 * @param mealType
                 */
                public void setMealType(MealType mealType) {
                    this.mealType = mealType;
                }
                /** 
                 * Type of meal (e.g. breakfast, dinner etc.).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealType" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="mealTypeCode"/>
                 *     &lt;xs:attribute type="xs:string" name="mealTypeDescription"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MealType implements Serializable
                {
                    private String mealTypeCode;
                    private String mealTypeDescription;

                    /** 
                     * Get the 'mealTypeCode' attribute value. Meal type code (e.g. BB, HB, AI).
                     * 
                     * @return value
                     */
                    public String getMealTypeCode() {
                        return mealTypeCode;
                    }

                    /** 
                     * Set the 'mealTypeCode' attribute value. Meal type code (e.g. BB, HB, AI).
                     * 
                     * @param mealTypeCode
                     */
                    public void setMealTypeCode(String mealTypeCode) {
                        this.mealTypeCode = mealTypeCode;
                    }

                    /** 
                     * Get the 'mealTypeDescription' attribute value. Meal type description.
                     * 
                     * @return value
                     */
                    public String getMealTypeDescription() {
                        return mealTypeDescription;
                    }

                    /** 
                     * Set the 'mealTypeDescription' attribute value. Meal type description.
                     * 
                     * @param mealTypeDescription
                     */
                    public void setMealTypeDescription(
                            String mealTypeDescription) {
                        this.mealTypeDescription = mealTypeDescription;
                    }
                }
            }
            /** 
             * Rate information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomRates" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="AmountBeforeTax" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:boolean" name="Override" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RoomRates implements Serializable
            {
                private String amountBeforeTax;
                private String currencyCode;
                private Boolean override;

                /** 
                 * Get the 'AmountBeforeTax' element value. Room rate amount before tax.
                 * 
                 * @return value
                 */
                public String getAmountBeforeTax() {
                    return amountBeforeTax;
                }

                /** 
                 * Set the 'AmountBeforeTax' element value. Room rate amount before tax.
                 * 
                 * @param amountBeforeTax
                 */
                public void setAmountBeforeTax(String amountBeforeTax) {
                    this.amountBeforeTax = amountBeforeTax;
                }

                /** 
                 * Get the 'CurrencyCode' element value. Room rate currency before tax.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' element value. Room rate currency before tax.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'Override' element value. Room rate override indicator.
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'Override' element value. Room rate override indicator.
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateAccessCodeBooked" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ClientIdentificationCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="RateAccessCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CategoryTypeCode" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RateAccessCodeBooked implements Serializable
            {
                private String clientIdentificationCode;
                private String rateAccessCode;
                private String categoryTypeCode;

                /** 
                 * Get the 'ClientIdentificationCode' element value. ''ClientIdentificationCode'' is used to return the identification code for the vendor associated with the particular hotel reservation.
                 * 
                 * @return value
                 */
                public String getClientIdentificationCode() {
                    return clientIdentificationCode;
                }

                /** 
                 * Set the 'ClientIdentificationCode' element value. ''ClientIdentificationCode'' is used to return the identification code for the vendor associated with the particular hotel reservation.
                 * 
                 * @param clientIdentificationCode
                 */
                public void setClientIdentificationCode(
                        String clientIdentificationCode) {
                    this.clientIdentificationCode = clientIdentificationCode;
                }

                /** 
                 * Get the 'RateAccessCode' element value. ''RateAccessCode'' is used to return the rate access code of the agency.
                 * 
                 * @return value
                 */
                public String getRateAccessCode() {
                    return rateAccessCode;
                }

                /** 
                 * Set the 'RateAccessCode' element value. ''RateAccessCode'' is used to return the rate access code of the agency.
                 * 
                 * @param rateAccessCode
                 */
                public void setRateAccessCode(String rateAccessCode) {
                    this.rateAccessCode = rateAccessCode;
                }

                /** 
                 * Get the 'CategoryTypeCode' element value. ''CategoryTypeCode'' is used to return the category type code associated with the particular hotel when applicable.
                 * 
                 * @return value
                 */
                public String getCategoryTypeCode() {
                    return categoryTypeCode;
                }

                /** 
                 * Set the 'CategoryTypeCode' element value. ''CategoryTypeCode'' is used to return the category type code associated with the particular hotel when applicable.
                 * 
                 * @param categoryTypeCode
                 */
                public void setCategoryTypeCode(String categoryTypeCode) {
                    this.categoryTypeCode = categoryTypeCode;
                }
            }
            /** 
             * Number of guests associated with this reservation.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuestCounts" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:integer" name="GuestCount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ExtraGuestCount" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="RollAwayCount" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:integer" name="CribCount" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="ReserveUnderName" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:unsignedShort" name="ChildGuestCount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ChildAges" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class GuestCounts implements Serializable
            {
                private BigInteger guestCount;
                private List<String> extraGuestCountList = new ArrayList<String>();
                private List<String> rollAwayCountList = new ArrayList<String>();
                private List<BigInteger> cribCountList = new ArrayList<BigInteger>();
                private List<String> reserveUnderNameList = new ArrayList<String>();
                private List<String> nameList = new ArrayList<String>();
                private String childGuestCount;
                private String childAges;

                /** 
                 * Get the 'GuestCount' element value. Number of persons.
                 * 
                 * @return value
                 */
                public BigInteger getGuestCount() {
                    return guestCount;
                }

                /** 
                 * Set the 'GuestCount' element value. Number of persons.
                 * 
                 * @param guestCount
                 */
                public void setGuestCount(BigInteger guestCount) {
                    this.guestCount = guestCount;
                }

                /** 
                 * Get the list of 'ExtraGuestCount' element items. Number of extra beds.
                 * 
                 * @return list
                 */
                public List<String> getExtraGuestCountList() {
                    return extraGuestCountList;
                }

                /** 
                 * Set the list of 'ExtraGuestCount' element items. Number of extra beds.
                 * 
                 * @param list
                 */
                public void setExtraGuestCountList(List<String> list) {
                    extraGuestCountList = list;
                }

                /** 
                 * Get the list of 'RollAwayCount' element items. Number of roll-away beds.
                 * 
                 * @return list
                 */
                public List<String> getRollAwayCountList() {
                    return rollAwayCountList;
                }

                /** 
                 * Set the list of 'RollAwayCount' element items. Number of roll-away beds.
                 * 
                 * @param list
                 */
                public void setRollAwayCountList(List<String> list) {
                    rollAwayCountList = list;
                }

                /** 
                 * Get the list of 'CribCount' element items. Number of cribs.
                 * 
                 * @return list
                 */
                public List<BigInteger> getCribCountList() {
                    return cribCountList;
                }

                /** 
                 * Set the list of 'CribCount' element items. Number of cribs.
                 * 
                 * @param list
                 */
                public void setCribCountList(List<BigInteger> list) {
                    cribCountList = list;
                }

                /** 
                 * Get the list of 'ReserveUnderName' element items. Name under which the hotel room is reserved.
                 * 
                 * @return list
                 */
                public List<String> getReserveUnderNameList() {
                    return reserveUnderNameList;
                }

                /** 
                 * Set the list of 'ReserveUnderName' element items. Name under which the hotel room is reserved.
                 * 
                 * @param list
                 */
                public void setReserveUnderNameList(List<String> list) {
                    reserveUnderNameList = list;
                }

                /** 
                 * Get the list of 'Name' element items. Guest name.
                 * 
                 * @return list
                 */
                public List<String> getNameList() {
                    return nameList;
                }

                /** 
                 * Set the list of 'Name' element items. Guest name.
                 * 
                 * @param list
                 */
                public void setNameList(List<String> list) {
                    nameList = list;
                }

                /** 
                 * Get the 'ChildGuestCount' element value. Child guest count for the room.
                                                                        Required for all properties.
                                                                        Used in combination with ChildAges to determine availability and rates.
                 * 
                 * @return value
                 */
                public String getChildGuestCount() {
                    return childGuestCount;
                }

                /** 
                 * Set the 'ChildGuestCount' element value. Child guest count for the room.
                                                                        Required for all properties.
                                                                        Used in combination with ChildAges to determine availability and rates.
                 * 
                 * @param childGuestCount
                 */
                public void setChildGuestCount(String childGuestCount) {
                    this.childGuestCount = childGuestCount;
                }

                /** 
                 * Get the 'ChildAges' element value. The individual ages of the children in the room as a comma-separated list.
                 * 
                 * @return value
                 */
                public String getChildAges() {
                    return childAges;
                }

                /** 
                 * Set the 'ChildAges' element value. The individual ages of the children in the room as a comma-separated list.
                 * 
                 * @param childAges
                 */
                public void setChildAges(String childAges) {
                    this.childAges = childAges;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guarantee" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="PaymentCardNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Guarantee implements Serializable
            {
                private String paymentCardNumber;
                private String text;

                /** 
                 * Get the 'PaymentCardNumber' element value. Payment card number.
                 * 
                 * @return value
                 */
                public String getPaymentCardNumber() {
                    return paymentCardNumber;
                }

                /** 
                 * Set the 'PaymentCardNumber' element value. Payment card number.
                 * 
                 * @param paymentCardNumber
                 */
                public void setPaymentCardNumber(String paymentCardNumber) {
                    this.paymentCardNumber = paymentCardNumber;
                }

                /** 
                 * Get the 'Text' element value. Guarantee/text or payment card number.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. Guarantee/text or payment card number.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }
            }
            /** 
             * The code that uniquely identifies a single hotel property.
                                                          The hotel code is decided between vendors.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelCode" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="Source"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HotelCode implements Serializable
            {
                private String string;
                private String source;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Source' attribute value. Source of the Hotel Code.
                                                                            Can be a external application or system.
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'Source' attribute value. Source of the Hotel Code.
                                                                            Can be a external application or system.
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelTotalPricing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TotalTax" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalSurcharge" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalSurcharge -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ApproximateTotal" minOccurs="0">
             *         &lt;!-- Reference to inner class ApproximateTotal -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="RateChange" minOccurs="0" maxOccurs="8">
             *         &lt;!-- Reference to inner class RateChange -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Disclaimer" minOccurs="0" maxOccurs="2">
             *         &lt;!-- Reference to inner class Disclaimer -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HotelFees" minOccurs="0">
             *         &lt;!-- Reference to inner class HotelFees -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:float" name="NightlyRateTotal" minOccurs="0"/>
             *       &lt;xs:element type="xs:float" name="MaxNightlyRate" minOccurs="0"/>
             *       &lt;xs:element type="xs:float" name="CommissionableUsdTotal" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HotelTotalPricing implements Serializable
            {
                private TotalTax totalTax;
                private TotalSurcharge totalSurcharge;
                private ApproximateTotal approximateTotal;
                private List<RateChange> rateChangeList = new ArrayList<RateChange>();
                private List<Disclaimer> disclaimerList = new ArrayList<Disclaimer>();
                private HotelFees hotelFees;
                private Float nightlyRateTotal;
                private Float maxNightlyRate;
                private Float commissionableUsdTotal;
                private String currencyCode;

                /** 
                 * Get the 'TotalTax' element value.
                 * 
                 * @return value
                 */
                public TotalTax getTotalTax() {
                    return totalTax;
                }

                /** 
                 * Set the 'TotalTax' element value.
                 * 
                 * @param totalTax
                 */
                public void setTotalTax(TotalTax totalTax) {
                    this.totalTax = totalTax;
                }

                /** 
                 * Get the 'TotalSurcharge' element value.
                 * 
                 * @return value
                 */
                public TotalSurcharge getTotalSurcharge() {
                    return totalSurcharge;
                }

                /** 
                 * Set the 'TotalSurcharge' element value.
                 * 
                 * @param totalSurcharge
                 */
                public void setTotalSurcharge(TotalSurcharge totalSurcharge) {
                    this.totalSurcharge = totalSurcharge;
                }

                /** 
                 * Get the 'ApproximateTotal' element value.
                 * 
                 * @return value
                 */
                public ApproximateTotal getApproximateTotal() {
                    return approximateTotal;
                }

                /** 
                 * Set the 'ApproximateTotal' element value.
                 * 
                 * @param approximateTotal
                 */
                public void setApproximateTotal(
                        ApproximateTotal approximateTotal) {
                    this.approximateTotal = approximateTotal;
                }

                /** 
                 * Get the list of 'RateChange' element items.
                 * 
                 * @return list
                 */
                public List<RateChange> getRateChangeList() {
                    return rateChangeList;
                }

                /** 
                 * Set the list of 'RateChange' element items.
                 * 
                 * @param list
                 */
                public void setRateChangeList(List<RateChange> list) {
                    rateChangeList = list;
                }

                /** 
                 * Get the list of 'Disclaimer' element items.
                 * 
                 * @return list
                 */
                public List<Disclaimer> getDisclaimerList() {
                    return disclaimerList;
                }

                /** 
                 * Set the list of 'Disclaimer' element items.
                 * 
                 * @param list
                 */
                public void setDisclaimerList(List<Disclaimer> list) {
                    disclaimerList = list;
                }

                /** 
                 * Get the 'HotelFees' element value.
                 * 
                 * @return value
                 */
                public HotelFees getHotelFees() {
                    return hotelFees;
                }

                /** 
                 * Set the 'HotelFees' element value.
                 * 
                 * @param hotelFees
                 */
                public void setHotelFees(HotelFees hotelFees) {
                    this.hotelFees = hotelFees;
                }

                /** 
                 * Get the 'NightlyRateTotal' element value. Total of all nightly rate values.
                 * 
                 * @return value
                 */
                public Float getNightlyRateTotal() {
                    return nightlyRateTotal;
                }

                /** 
                 * Set the 'NightlyRateTotal' element value. Total of all nightly rate values.
                 * 
                 * @param nightlyRateTotal
                 */
                public void setNightlyRateTotal(Float nightlyRateTotal) {
                    this.nightlyRateTotal = nightlyRateTotal;
                }

                /** 
                 * Get the 'MaxNightlyRate' element value. The highest nightly rate of all rates.
                 * 
                 * @return value
                 */
                public Float getMaxNightlyRate() {
                    return maxNightlyRate;
                }

                /** 
                 * Set the 'MaxNightlyRate' element value. The highest nightly rate of all rates.
                 * 
                 * @param maxNightlyRate
                 */
                public void setMaxNightlyRate(Float maxNightlyRate) {
                    this.maxNightlyRate = maxNightlyRate;
                }

                /** 
                 * Get the 'CommissionableUsdTotal' element value. Amount used to calculate partner commissions, in USD.
                                                                        Total of nightly rates less surcharges.
                 * 
                 * @return value
                 */
                public Float getCommissionableUsdTotal() {
                    return commissionableUsdTotal;
                }

                /** 
                 * Set the 'CommissionableUsdTotal' element value. Amount used to calculate partner commissions, in USD.
                                                                        Total of nightly rates less surcharges.
                 * 
                 * @param commissionableUsdTotal
                 */
                public void setCommissionableUsdTotal(
                        Float commissionableUsdTotal) {
                    this.commissionableUsdTotal = commissionableUsdTotal;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. The ISO 4217 three alpha code specifying a monetary unit.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. The ISO 4217 three alpha code specifying a monetary unit.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="4">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalTax implements Serializable
                {
                    private List<Tax> taxList = new ArrayList<Tax>();
                    private String amount;

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }

                    /** 
                     * Get the 'Amount' attribute value. Total tax amount.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Total tax amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }
                    /** 
                     * Free text tax field.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="4">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" name="Id"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private String string;
                        private String id;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Id' attribute value. Tax identifier.
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. Tax identifier.
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalSurcharge" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Surcharge" minOccurs="0" maxOccurs="4">
                 *         &lt;!-- Reference to inner class Surcharge -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalSurcharge implements Serializable
                {
                    private List<Surcharge> surchargeList = new ArrayList<Surcharge>();
                    private String amount;

                    /** 
                     * Get the list of 'Surcharge' element items.
                     * 
                     * @return list
                     */
                    public List<Surcharge> getSurchargeList() {
                        return surchargeList;
                    }

                    /** 
                     * Set the list of 'Surcharge' element items.
                     * 
                     * @param list
                     */
                    public void setSurchargeList(List<Surcharge> list) {
                        surchargeList = list;
                    }

                    /** 
                     * Get the 'Amount' attribute value. Total surcharge amount.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Total surcharge amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }
                    /** 
                     * Free text surcharge field.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharge" minOccurs="0" maxOccurs="4">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" name="Id"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Surcharge implements Serializable
                    {
                        private String string;
                        private String id;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Id' attribute value. Surcharge identifier.
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. Surcharge identifier.
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApproximateTotal" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="AmountAndCurrency"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ApproximateTotal implements Serializable
                {
                    private String amountAndCurrency;

                    /** 
                     * Get the 'AmountAndCurrency' attribute value. Approximate total price.
                     * 
                     * @return value
                     */
                    public String getAmountAndCurrency() {
                        return amountAndCurrency;
                    }

                    /** 
                     * Set the 'AmountAndCurrency' attribute value. Approximate total price.
                     * 
                     * @param amountAndCurrency
                     */
                    public void setAmountAndCurrency(String amountAndCurrency) {
                        this.amountAndCurrency = amountAndCurrency;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateChange" minOccurs="0" maxOccurs="8">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="Id"/>
                 *     &lt;xs:attribute type="xs:string" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" name="Effective"/>
                 *     &lt;xs:attribute type="xs:string" name="Surcharge"/>
                 *     &lt;xs:attribute type="xs:string" name="Tax"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RateChange implements Serializable
                {
                    private String id;
                    private String amount;
                    private String effective;
                    private String surcharge;
                    private String tax;

                    /** 
                     * Get the 'Id' attribute value. Rate change identifier.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value. Rate change identifier.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }

                    /** 
                     * Get the 'Amount' attribute value. Rate change amount.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Rate change amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Effective' attribute value. Effective date range.
                     * 
                     * @return value
                     */
                    public String getEffective() {
                        return effective;
                    }

                    /** 
                     * Set the 'Effective' attribute value. Effective date range.
                     * 
                     * @param effective
                     */
                    public void setEffective(String effective) {
                        this.effective = effective;
                    }

                    /** 
                     * Get the 'Surcharge' attribute value. Associated surcharge.
                     * 
                     * @return value
                     */
                    public String getSurcharge() {
                        return surcharge;
                    }

                    /** 
                     * Set the 'Surcharge' attribute value. Associated surcharge.
                     * 
                     * @param surcharge
                     */
                    public void setSurcharge(String surcharge) {
                        this.surcharge = surcharge;
                    }

                    /** 
                     * Get the 'Tax' attribute value. Associated tax.
                     * 
                     * @return value
                     */
                    public String getTax() {
                        return tax;
                    }

                    /** 
                     * Set the 'Tax' attribute value. Associated tax.
                     * 
                     * @param tax
                     */
                    public void setTax(String tax) {
                        this.tax = tax;
                    }
                }
                /** 
                 * Disclaimer free text.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Disclaimer" minOccurs="0" maxOccurs="2">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="Id"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Disclaimer implements Serializable
                {
                    private String string;
                    private String id;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'Id' attribute value. Disclaimer identifier.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value. Disclaimer identifier.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }
                }
                /** 
                 * This element breaks out certain taxes and fees collected by the hotel that are otherwise not specifically detailed in the Surcharges array.
                                                                        Contains size attribute to indicate the number of charges contained.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelFees" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="HotelFee" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class HotelFee -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HotelFees implements Serializable
                {
                    private List<HotelFee> hotelFeeList = new ArrayList<HotelFee>();

                    /** 
                     * Get the list of 'HotelFee' element items.
                     * 
                     * @return list
                     */
                    public List<HotelFee> getHotelFeeList() {
                        return hotelFeeList;
                    }

                    /** 
                     * Set the list of 'HotelFee' element items.
                     * 
                     * @param list
                     */
                    public void setHotelFeeList(List<HotelFee> list) {
                        hotelFeeList = list;
                    }
                    /** 
                     * Contains attributes for the description, amount, and currency of a single fee.
                                                                                      Details any VAT, state/city tax, resort fees, or any other fees collected that cannot be reasonably avoided.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelFee" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="Description"/>
                     *     &lt;xs:attribute type="xs:float" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class HotelFee implements Serializable
                    {
                        private String description;
                        private Float amount;

                        /** 
                         * Get the 'Description' attribute value. The type of charge.
                         * 
                         * @return value
                         */
                        public String getDescription() {
                            return description;
                        }

                        /** 
                         * Set the 'Description' attribute value. The type of charge.
                         * 
                         * @param description
                         */
                        public void setDescription(String description) {
                            this.description = description;
                        }

                        /** 
                         * Get the 'Amount' attribute value. Value for the charge.
                         * 
                         * @return value
                         */
                        public Float getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. Value for the charge.
                         * 
                         * @param amount
                         */
                        public void setAmount(Float amount) {
                            this.amount = amount;
                        }
                    }
                }
            }
            /** 
             * Hotel information that can be used as a reference to other systems.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelUniqueID" minOccurs="0" maxOccurs="5">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="Source"/>
             *     &lt;xs:attribute type="xs:string" name="ID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HotelUniqueID implements Serializable
            {
                private String source;
                private String ID;

                /** 
                 * Get the 'Source' attribute value. Application/System that is the source of this Hotel ID.
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'Source' attribute value. Application/System that is the source of this Hotel ID.
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }

                /** 
                 * Get the 'ID' attribute value. Hotel ID.
                 * 
                 * @return value
                 */
                public String getID() {
                    return ID;
                }

                /** 
                 * Set the 'ID' attribute value. Hotel ID.
                 * 
                 * @param ID
                 */
                public void setID(String ID) {
                    this.ID = ID;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ConfirmationNumber -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Address" minOccurs="0">
         *         &lt;!-- Reference to inner class Address -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ContactNumbers" minOccurs="0">
         *         &lt;!-- Reference to inner class ContactNumbers -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="CancelPenaltyPolicyCode" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="CustLoyaltyMembershipID" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="IDNumber" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="CorporateIDNumber" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:boolean" name="WrittenConfirmation" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AdditionalInformation implements Serializable
        {
            private List<ConfirmationNumber> confirmationNumberList = new ArrayList<ConfirmationNumber>();
            private Address address;
            private ContactNumbers contactNumbers;
            private List<String> cancelPenaltyPolicyCodeList = new ArrayList<String>();
            private List<String> custLoyaltyMembershipIDList = new ArrayList<String>();
            private List<String> IDNumberList = new ArrayList<String>();
            private List<String> corporateIDNumberList = new ArrayList<String>();
            private List<String> textList = new ArrayList<String>();
            private Commission commission;
            private Boolean writtenConfirmation;

            /** 
             * Get the list of 'ConfirmationNumber' element items.
             * 
             * @return list
             */
            public List<ConfirmationNumber> getConfirmationNumberList() {
                return confirmationNumberList;
            }

            /** 
             * Set the list of 'ConfirmationNumber' element items.
             * 
             * @param list
             */
            public void setConfirmationNumberList(List<ConfirmationNumber> list) {
                confirmationNumberList = list;
            }

            /** 
             * Get the 'Address' element value.
             * 
             * @return value
             */
            public Address getAddress() {
                return address;
            }

            /** 
             * Set the 'Address' element value.
             * 
             * @param address
             */
            public void setAddress(Address address) {
                this.address = address;
            }

            /** 
             * Get the 'ContactNumbers' element value.
             * 
             * @return value
             */
            public ContactNumbers getContactNumbers() {
                return contactNumbers;
            }

            /** 
             * Set the 'ContactNumbers' element value.
             * 
             * @param contactNumbers
             */
            public void setContactNumbers(ContactNumbers contactNumbers) {
                this.contactNumbers = contactNumbers;
            }

            /** 
             * Get the list of 'CancelPenaltyPolicyCode' element items. Cancellation penalty policy code.
             * 
             * @return list
             */
            public List<String> getCancelPenaltyPolicyCodeList() {
                return cancelPenaltyPolicyCodeList;
            }

            /** 
             * Set the list of 'CancelPenaltyPolicyCode' element items. Cancellation penalty policy code.
             * 
             * @param list
             */
            public void setCancelPenaltyPolicyCodeList(List<String> list) {
                cancelPenaltyPolicyCodeList = list;
            }

            /** 
             * Get the list of 'CustLoyaltyMembershipID' element items. Frequent traveler identifier.
             * 
             * @return list
             */
            public List<String> getCustLoyaltyMembershipIDList() {
                return custLoyaltyMembershipIDList;
            }

            /** 
             * Set the list of 'CustLoyaltyMembershipID' element items. Frequent traveler identifier.
             * 
             * @param list
             */
            public void setCustLoyaltyMembershipIDList(List<String> list) {
                custLoyaltyMembershipIDList = list;
            }

            /** 
             * Get the list of 'IDNumber' element items. Hotel frequent guest identifier.
             * 
             * @return list
             */
            public List<String> getIDNumberList() {
                return IDNumberList;
            }

            /** 
             * Set the list of 'IDNumber' element items. Hotel frequent guest identifier.
             * 
             * @param list
             */
            public void setIDNumberList(List<String> list) {
                IDNumberList = list;
            }

            /** 
             * Get the list of 'CorporateIDNumber' element items. Corporate identifier number.
             * 
             * @return list
             */
            public List<String> getCorporateIDNumberList() {
                return corporateIDNumberList;
            }

            /** 
             * Set the list of 'CorporateIDNumber' element items. Corporate identifier number.
             * 
             * @param list
             */
            public void setCorporateIDNumberList(List<String> list) {
                corporateIDNumberList = list;
            }

            /** 
             * Get the list of 'Text' element items. ''Text'' returns the additional information text.
             * 
             * @return list
             */
            public List<String> getTextList() {
                return textList;
            }

            /** 
             * Set the list of 'Text' element items. ''Text'' returns the additional information text.
             * 
             * @param list
             */
            public void setTextList(List<String> list) {
                textList = list;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the 'WrittenConfirmation' element value. Written confirmation request indicator.
             * 
             * @return value
             */
            public Boolean getWrittenConfirmation() {
                return writtenConfirmation;
            }

            /** 
             * Set the 'WrittenConfirmation' element value. Written confirmation request indicator.
             * 
             * @param writtenConfirmation
             */
            public void setWrittenConfirmation(Boolean writtenConfirmation) {
                this.writtenConfirmation = writtenConfirmation;
            }
            /** 
             * Confirmation number.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="Source"/>
             *         &lt;xs:attribute type="xs:boolean" default="false" name="DirectConnect"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ConfirmationNumber implements Serializable
            {
                private String string;
                private String source;
                private Boolean directConnect;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Source' attribute value. Source of this confirmation Number.
                 * 
                 * @return value
                 */
                public String getSource() {
                    return source;
                }

                /** 
                 * Set the 'Source' attribute value. Source of this confirmation Number.
                 * 
                 * @param source
                 */
                public void setSource(String source) {
                    this.source = source;
                }

                /** 
                 * Get the 'DirectConnect' attribute value. Set if hotel was sold via DirectConnect.
                 * 
                 * @return value
                 */
                public Boolean getDirectConnect() {
                    return directConnect;
                }

                /** 
                 * Set the 'DirectConnect' attribute value. Set if hotel was sold via DirectConnect.
                 * 
                 * @param directConnect
                 */
                public void setDirectConnect(Boolean directConnect) {
                    this.directConnect = directConnect;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="State" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ZipCode" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Address implements Serializable
            {
                private List<String> addressLineList = new ArrayList<String>();
                private String countryCode;
                private String city;
                private String state;
                private String zipCode;

                /** 
                 * Get the list of 'AddressLine' element items. Hotel address line.
                 * 
                 * @return list
                 */
                public List<String> getAddressLineList() {
                    return addressLineList;
                }

                /** 
                 * Set the list of 'AddressLine' element items. Hotel address line.
                 * 
                 * @param list
                 */
                public void setAddressLineList(List<String> list) {
                    addressLineList = list;
                }

                /** 
                 * Get the 'CountryCode' element value. Hotel country code.
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' element value. Hotel country code.
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }

                /** 
                 * Get the 'City' element value. Hotel city.
                 * 
                 * @return value
                 */
                public String getCity() {
                    return city;
                }

                /** 
                 * Set the 'City' element value. Hotel city.
                 * 
                 * @param city
                 */
                public void setCity(String city) {
                    this.city = city;
                }

                /** 
                 * Get the 'State' element value. Hotel state.
                 * 
                 * @return value
                 */
                public String getState() {
                    return state;
                }

                /** 
                 * Set the 'State' element value. Hotel state.
                 * 
                 * @param state
                 */
                public void setState(String state) {
                    this.state = state;
                }

                /** 
                 * Get the 'ZipCode' element value. Hotel postal code.
                 * 
                 * @return value
                 */
                public String getZipCode() {
                    return zipCode;
                }

                /** 
                 * Set the 'ZipCode' element value. Hotel postal code.
                 * 
                 * @param zipCode
                 */
                public void setZipCode(String zipCode) {
                    this.zipCode = zipCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="PhoneNumber" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="FaxNumber" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ContactNumbers implements Serializable
            {
                private List<String> phoneNumberList = new ArrayList<String>();
                private String faxNumber;

                /** 
                 * Get the list of 'PhoneNumber' element items. Hotel phone number.
                 * 
                 * @return list
                 */
                public List<String> getPhoneNumberList() {
                    return phoneNumberList;
                }

                /** 
                 * Set the list of 'PhoneNumber' element items. Hotel phone number.
                 * 
                 * @param list
                 */
                public void setPhoneNumberList(List<String> list) {
                    phoneNumberList = list;
                }

                /** 
                 * Get the 'FaxNumber' element value. Hotel fax number.
                 * 
                 * @return value
                 */
                public String getFaxNumber() {
                    return faxNumber;
                }

                /** 
                 * Set the 'FaxNumber' element value. Hotel fax number.
                 * 
                 * @param faxNumber
                 */
                public void setFaxNumber(String faxNumber) {
                    this.faxNumber = faxNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Indicator" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="PerNight" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private String indicator;
                private String perNight;
                private String text;

                /** 
                 * Get the 'Indicator' element value. HOD Commission indicator.
                 * 
                 * @return value
                 */
                public String getIndicator() {
                    return indicator;
                }

                /** 
                 * Set the 'Indicator' element value. HOD Commission indicator.
                 * 
                 * @param indicator
                 */
                public void setIndicator(String indicator) {
                    this.indicator = indicator;
                }

                /** 
                 * Get the 'PerNight' element value. Travel agent commission.
                 * 
                 * @return value
                 */
                public String getPerNight() {
                    return perNight;
                }

                /** 
                 * Set the 'PerNight' element value. Travel agent commission.
                 * 
                 * @param perNight
                 */
                public void setPerNight(String perNight) {
                    this.perNight = perNight;
                }

                /** 
                 * Get the 'Text' element value. HRD commission free text.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value. HRD commission free text.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateDescription" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="TextLine" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RateDescription implements Serializable
        {
            private List<String> textLineList = new ArrayList<String>();

            /** 
             * Get the list of 'TextLine' element items. Rate description.
             * 
             * @return list
             */
            public List<String> getTextLineList() {
                return textLineList;
            }

            /** 
             * Set the list of 'TextLine' element items. Rate description.
             * 
             * @param list
             */
            public void setTextLineList(List<String> list) {
                textLineList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelPolicy" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="DepositPolicy" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="GuaranteePolicy" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="LateArrivalPolicy" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="LateDeparturePolicy" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CancellationPolicy" minOccurs="0"/>
         *       &lt;xs:element name="CancellationPolicyInfoList" minOccurs="0">
         *         &lt;!-- Reference to inner class CancellationPolicyInfoList -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="AdditionalPolicy" minOccurs="0">
         *         &lt;!-- Reference to inner class AdditionalPolicy -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CheckInCheckOutPolicy" minOccurs="0">
         *         &lt;!-- Reference to inner class CheckInCheckOutPolicy -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HotelPolicy implements Serializable
        {
            private String depositPolicy;
            private String guaranteePolicy;
            private String lateArrivalPolicy;
            private String lateDeparturePolicy;
            private String cancellationPolicy;
            private CancellationPolicyInfoList cancellationPolicyInfoList;
            private AdditionalPolicy additionalPolicy;
            private CheckInCheckOutPolicy checkInCheckOutPolicy;

            /** 
             * Get the 'DepositPolicy' element value. Deposit policy.
             * 
             * @return value
             */
            public String getDepositPolicy() {
                return depositPolicy;
            }

            /** 
             * Set the 'DepositPolicy' element value. Deposit policy.
             * 
             * @param depositPolicy
             */
            public void setDepositPolicy(String depositPolicy) {
                this.depositPolicy = depositPolicy;
            }

            /** 
             * Get the 'GuaranteePolicy' element value. Guarantee policy.
             * 
             * @return value
             */
            public String getGuaranteePolicy() {
                return guaranteePolicy;
            }

            /** 
             * Set the 'GuaranteePolicy' element value. Guarantee policy.
             * 
             * @param guaranteePolicy
             */
            public void setGuaranteePolicy(String guaranteePolicy) {
                this.guaranteePolicy = guaranteePolicy;
            }

            /** 
             * Get the 'LateArrivalPolicy' element value. Late arrival policy.
             * 
             * @return value
             */
            public String getLateArrivalPolicy() {
                return lateArrivalPolicy;
            }

            /** 
             * Set the 'LateArrivalPolicy' element value. Late arrival policy.
             * 
             * @param lateArrivalPolicy
             */
            public void setLateArrivalPolicy(String lateArrivalPolicy) {
                this.lateArrivalPolicy = lateArrivalPolicy;
            }

            /** 
             * Get the 'LateDeparturePolicy' element value. Late departure policy.
             * 
             * @return value
             */
            public String getLateDeparturePolicy() {
                return lateDeparturePolicy;
            }

            /** 
             * Set the 'LateDeparturePolicy' element value. Late departure policy.
             * 
             * @param lateDeparturePolicy
             */
            public void setLateDeparturePolicy(String lateDeparturePolicy) {
                this.lateDeparturePolicy = lateDeparturePolicy;
            }

            /** 
             * Get the 'CancellationPolicy' element value. Cancellation policy.
             * 
             * @return value
             */
            public String getCancellationPolicy() {
                return cancellationPolicy;
            }

            /** 
             * Set the 'CancellationPolicy' element value. Cancellation policy.
             * 
             * @param cancellationPolicy
             */
            public void setCancellationPolicy(String cancellationPolicy) {
                this.cancellationPolicy = cancellationPolicy;
            }

            /** 
             * Get the 'CancellationPolicyInfoList' element value.
             * 
             * @return value
             */
            public CancellationPolicyInfoList getCancellationPolicyInfoList() {
                return cancellationPolicyInfoList;
            }

            /** 
             * Set the 'CancellationPolicyInfoList' element value.
             * 
             * @param cancellationPolicyInfoList
             */
            public void setCancellationPolicyInfoList(
                    CancellationPolicyInfoList cancellationPolicyInfoList) {
                this.cancellationPolicyInfoList = cancellationPolicyInfoList;
            }

            /** 
             * Get the 'AdditionalPolicy' element value.
             * 
             * @return value
             */
            public AdditionalPolicy getAdditionalPolicy() {
                return additionalPolicy;
            }

            /** 
             * Set the 'AdditionalPolicy' element value.
             * 
             * @param additionalPolicy
             */
            public void setAdditionalPolicy(AdditionalPolicy additionalPolicy) {
                this.additionalPolicy = additionalPolicy;
            }

            /** 
             * Get the 'CheckInCheckOutPolicy' element value.
             * 
             * @return value
             */
            public CheckInCheckOutPolicy getCheckInCheckOutPolicy() {
                return checkInCheckOutPolicy;
            }

            /** 
             * Set the 'CheckInCheckOutPolicy' element value.
             * 
             * @param checkInCheckOutPolicy
             */
            public void setCheckInCheckOutPolicy(
                    CheckInCheckOutPolicy checkInCheckOutPolicy) {
                this.checkInCheckOutPolicy = checkInCheckOutPolicy;
            }
            /** 
             * Details specifics of the cancellation policy.
                                                          Typically the times determining the penalty period and the penalties incurred for cancellation.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancellationPolicyInfoList" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CancelPolicyInfo" maxOccurs="2">
             *         &lt;!-- Reference to inner class CancelPolicyInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CancellationPolicyInfoList implements
                Serializable
            {
                private List<CancelPolicyInfo> cancelPolicyInfoList = new ArrayList<CancelPolicyInfo>();

                /** 
                 * Get the list of 'CancelPolicyInfo' element items.
                 * 
                 * @return list
                 */
                public List<CancelPolicyInfo> getCancelPolicyInfoList() {
                    return cancelPolicyInfoList;
                }

                /** 
                 * Set the list of 'CancelPolicyInfo' element items.
                 * 
                 * @param list
                 */
                public void setCancelPolicyInfoList(List<CancelPolicyInfo> list) {
                    cancelPolicyInfoList = list;
                }
                /** 
                 * Contains cancellation information, e.g. additional charges.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPolicyInfo" maxOccurs="2">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:int" name="VersionId" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="CancelTime" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="StartWindowHours" minOccurs="0"/>
                 *       &lt;xs:element type="xs:unsignedShort" name="NightCount" minOccurs="0"/>
                 *       &lt;xs:element type="xs:float" name="Percent" minOccurs="0"/>
                 *       &lt;xs:element type="xs:float" name="Amount" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="TimeZoneDescription" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CancelPolicyInfo implements Serializable
                {
                    private Integer versionId;
                    private String cancelTime;
                    private String startWindowHours;
                    private String nightCount;
                    private Float percent;
                    private Float amount;
                    private String currencyCode;
                    private String timeZoneDescription;

                    /** 
                     * Get the 'VersionId' element value. Version ID value.
                     * 
                     * @return value
                     */
                    public Integer getVersionId() {
                        return versionId;
                    }

                    /** 
                     * Set the 'VersionId' element value. Version ID value.
                     * 
                     * @param versionId
                     */
                    public void setVersionId(Integer versionId) {
                        this.versionId = versionId;
                    }

                    /** 
                     * Get the 'CancelTime' element value. The time of day the policy window begins/ends.
                     * 
                     * @return value
                     */
                    public String getCancelTime() {
                        return cancelTime;
                    }

                    /** 
                     * Set the 'CancelTime' element value. The time of day the policy window begins/ends.
                     * 
                     * @param cancelTime
                     */
                    public void setCancelTime(String cancelTime) {
                        this.cancelTime = cancelTime;
                    }

                    /** 
                     * Get the 'StartWindowHours' element value. Hours before the day of check-in that the policy window begins, counting back from the specific time returned in CancelTime.
                                                                                      This will return as 0 within the first instance of CancelPolicyInfo (since the window extends up until the actual check-in time) and then the actual number of hours the policy window spans for the second instance.
                                                                                      Returns with a value of 999 for nonrefundable rooms.
                     * 
                     * @return value
                     */
                    public String getStartWindowHours() {
                        return startWindowHours;
                    }

                    /** 
                     * Set the 'StartWindowHours' element value. Hours before the day of check-in that the policy window begins, counting back from the specific time returned in CancelTime.
                                                                                      This will return as 0 within the first instance of CancelPolicyInfo (since the window extends up until the actual check-in time) and then the actual number of hours the policy window spans for the second instance.
                                                                                      Returns with a value of 999 for nonrefundable rooms.
                     * 
                     * @param startWindowHours
                     */
                    public void setStartWindowHours(String startWindowHours) {
                        this.startWindowHours = startWindowHours;
                    }

                    /** 
                     * Get the 'NightCount' element value. The number of nights charged as a penalty for cancelling within the policy window.
                                                                                      A value of 1 corresponds to the first night's value plus tax.
                                                                                      A value of 2 corresponds to first  and second night's individual values plus tax (do not multiply the first night's value).
                     * 
                     * @return value
                     */
                    public String getNightCount() {
                        return nightCount;
                    }

                    /** 
                     * Set the 'NightCount' element value. The number of nights charged as a penalty for cancelling within the policy window.
                                                                                      A value of 1 corresponds to the first night's value plus tax.
                                                                                      A value of 2 corresponds to first  and second night's individual values plus tax (do not multiply the first night's value).
                     * 
                     * @param nightCount
                     */
                    public void setNightCount(String nightCount) {
                        this.nightCount = nightCount;
                    }

                    /** 
                     * Get the 'Percent' element value. Percentage of the value of the total cost of stay (less taxes and fees) that will be charged as a penalty for cancelling within the policy window.
                     * 
                     * @return value
                     */
                    public Float getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' element value. Percentage of the value of the total cost of stay (less taxes and fees) that will be charged as a penalty for cancelling within the policy window.
                     * 
                     * @param percent
                     */
                    public void setPercent(Float percent) {
                        this.percent = percent;
                    }

                    /** 
                     * Get the 'Amount' element value. Flat fee to be charged as a penalty for cancelling within the policy window.
                     * 
                     * @return value
                     */
                    public Float getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value. Flat fee to be charged as a penalty for cancelling within the policy window.
                     * 
                     * @param amount
                     */
                    public void setAmount(Float amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' element value. Currency penalties will be charged in.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' element value. Currency penalties will be charged in.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'TimeZoneDescription' element value. Time zone the property applies to the stated policy period.
                     * 
                     * @return value
                     */
                    public String getTimeZoneDescription() {
                        return timeZoneDescription;
                    }

                    /** 
                     * Set the 'TimeZoneDescription' element value. Time zone the property applies to the stated policy period.
                     * 
                     * @param timeZoneDescription
                     */
                    public void setTimeZoneDescription(
                            String timeZoneDescription) {
                        this.timeZoneDescription = timeZoneDescription;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalPolicy" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="TextLine" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AdditionalPolicy implements Serializable
            {
                private List<String> textLineList = new ArrayList<String>();

                /** 
                 * Get the list of 'TextLine' element items. Additional policy text.
                 * 
                 * @return list
                 */
                public List<String> getTextLineList() {
                    return textLineList;
                }

                /** 
                 * Set the list of 'TextLine' element items. Additional policy text.
                 * 
                 * @param list
                 */
                public void setTextLineList(List<String> list) {
                    textLineList = list;
                }
            }
            /** 
             * ''CheckInCheckOutPolicy'' returns check in or check out policy information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckInCheckOutPolicy" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:time" name="CheckIn"/>
             *         &lt;xs:attribute type="xs:time" name="CheckOut"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CheckInCheckOutPolicy implements Serializable
            {
                private String string;
                private Time checkIn;
                private Time checkOut;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'CheckIn' attribute value. The checkin time policy used to inform guest should check in after this check-in time.
                 * 
                 * @return value
                 */
                public Time getCheckIn() {
                    return checkIn;
                }

                /** 
                 * Set the 'CheckIn' attribute value. The checkin time policy used to inform guest should check in after this check-in time.
                 * 
                 * @param checkIn
                 */
                public void setCheckIn(Time checkIn) {
                    this.checkIn = checkIn;
                }

                /** 
                 * Get the 'CheckOut' attribute value. The checkout time policy used to inform that guest needs to check-out by this time.
                 * 
                 * @return value
                 */
                public Time getCheckOut() {
                    return checkOut;
                }

                /** 
                 * Set the 'CheckOut' attribute value. The checkout time policy used to inform that guest needs to check-out by this time.
                 * 
                 * @param checkOut
                 */
                public void setCheckOut(Time checkOut) {
                    this.checkOut = checkOut;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingElements" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Deposit" minOccurs="0">
         *         &lt;!-- Reference to inner class Deposit -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Discount" minOccurs="0" maxOccurs="99">
         *         &lt;!-- Reference to inner class Discount -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Payment" minOccurs="0">
         *         &lt;!-- Reference to inner class Payment -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingElements implements Serializable
        {
            private Deposit deposit;
            private List<Discount> discountList = new ArrayList<Discount>();
            private Payment payment;

            /** 
             * Get the 'Deposit' element value.
             * 
             * @return value
             */
            public Deposit getDeposit() {
                return deposit;
            }

            /** 
             * Set the 'Deposit' element value.
             * 
             * @param deposit
             */
            public void setDeposit(Deposit deposit) {
                this.deposit = deposit;
            }

            /** 
             * Get the list of 'Discount' element items.
             * 
             * @return list
             */
            public List<Discount> getDiscountList() {
                return discountList;
            }

            /** 
             * Set the list of 'Discount' element items.
             * 
             * @param list
             */
            public void setDiscountList(List<Discount> list) {
                discountList = list;
            }

            /** 
             * Get the 'Payment' element value.
             * 
             * @return value
             */
            public Payment getPayment() {
                return payment;
            }

            /** 
             * Set the 'Payment' element value.
             * 
             * @param payment
             */
            public void setPayment(Payment payment) {
                this.payment = payment;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deposit" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:date" name="DueDate" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:decimal" name="amount"/>
             *     &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Deposit implements Serializable
            {
                private java.sql.Date dueDate;
                private BigDecimal amount;
                private String currencyCode;

                /** 
                 * Get the 'DueDate' element value. Deposit due date.
                 * 
                 * @return value
                 */
                public java.sql.Date getDueDate() {
                    return dueDate;
                }

                /** 
                 * Set the 'DueDate' element value. Deposit due date.
                 * 
                 * @param dueDate
                 */
                public void setDueDate(java.sql.Date dueDate) {
                    this.dueDate = dueDate;
                }

                /** 
                 * Get the 'amount' attribute value. Amount to pay.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'amount' attribute value. Amount to pay.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'currencyCode' attribute value. Currency code.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value. Currency code.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="DiscountDescription" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:decimal" name="amount"/>
             *     &lt;xs:attribute type="xs:string" name="currencyCode"/>
             *     &lt;xs:attribute type="xs:string" name="type"/>
             *     &lt;xs:attribute type="xs:string" name="category"/>
             *     &lt;xs:attribute type="xs:string" name="promoType"/>
             *     &lt;xs:attribute type="xs:string" name="promoCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Discount implements Serializable
            {
                private String discountDescription;
                private BigDecimal amount;
                private String currencyCode;
                private String type;
                private String category;
                private String promoType;
                private String promoCode;

                /** 
                 * Get the 'DiscountDescription' element value. Discount description.
                 * 
                 * @return value
                 */
                public String getDiscountDescription() {
                    return discountDescription;
                }

                /** 
                 * Set the 'DiscountDescription' element value. Discount description.
                 * 
                 * @param discountDescription
                 */
                public void setDiscountDescription(String discountDescription) {
                    this.discountDescription = discountDescription;
                }

                /** 
                 * Get the 'amount' attribute value. Discount amount.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'amount' attribute value. Discount amount.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'currencyCode' attribute value. Currency code.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'currencyCode' attribute value. Currency code.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'type' attribute value. Discount type.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value. Discount type.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'category' attribute value. Discount category.
                 * 
                 * @return value
                 */
                public String getCategory() {
                    return category;
                }

                /** 
                 * Set the 'category' attribute value. Discount category.
                 * 
                 * @param category
                 */
                public void setCategory(String category) {
                    this.category = category;
                }

                /** 
                 * Get the 'promoType' attribute value. Discount promotion type.
                 * 
                 * @return value
                 */
                public String getPromoType() {
                    return promoType;
                }

                /** 
                 * Set the 'promoType' attribute value. Discount promotion type.
                 * 
                 * @param promoType
                 */
                public void setPromoType(String promoType) {
                    this.promoType = promoType;
                }

                /** 
                 * Get the 'promoCode' attribute value. Discount promotion code.
                 * 
                 * @return value
                 */
                public String getPromoCode() {
                    return promoCode;
                }

                /** 
                 * Set the 'promoCode' attribute value. Discount promotion code.
                 * 
                 * @param promoCode
                 */
                public void setPromoCode(String promoCode) {
                    this.promoCode = promoCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SubTotal" minOccurs="0">
             *         &lt;!-- Reference to inner class SubTotal -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Total" minOccurs="0">
             *         &lt;!-- Reference to inner class Total -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Payment implements Serializable
            {
                private SubTotal subTotal;
                private Total total;

                /** 
                 * Get the 'SubTotal' element value.
                 * 
                 * @return value
                 */
                public SubTotal getSubTotal() {
                    return subTotal;
                }

                /** 
                 * Set the 'SubTotal' element value.
                 * 
                 * @param subTotal
                 */
                public void setSubTotal(SubTotal subTotal) {
                    this.subTotal = subTotal;
                }

                /** 
                 * Get the 'Total' element value.
                 * 
                 * @return value
                 */
                public Total getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value.
                 * 
                 * @param total
                 */
                public void setTotal(Total total) {
                    this.total = total;
                }
                /** 
                 * Total payment without discount.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubTotal" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:decimal" name="amount"/>
                 *     &lt;xs:attribute type="xs:string" name="currency"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SubTotal implements Serializable
                {
                    private BigDecimal amount;
                    private String currency;

                    /** 
                     * Get the 'amount' attribute value. Amount to pay.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'amount' attribute value. Amount to pay.
                     * 
                     * @param amount
                     */
                    public void setAmount(BigDecimal amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'currency' attribute value. Currency.
                     * 
                     * @return value
                     */
                    public String getCurrency() {
                        return currency;
                    }

                    /** 
                     * Set the 'currency' attribute value. Currency.
                     * 
                     * @param currency
                     */
                    public void setCurrency(String currency) {
                        this.currency = currency;
                    }
                }
                /** 
                 * Total payment after discount.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:date" name="DueDate" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:decimal" name="amount"/>
                 *     &lt;xs:attribute type="xs:string" name="currency"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Total implements Serializable
                {
                    private java.sql.Date dueDate;
                    private BigDecimal amount;
                    private String currency;

                    /** 
                     * Get the 'DueDate' element value. Payment due date.
                     * 
                     * @return value
                     */
                    public java.sql.Date getDueDate() {
                        return dueDate;
                    }

                    /** 
                     * Set the 'DueDate' element value. Payment due date.
                     * 
                     * @param dueDate
                     */
                    public void setDueDate(java.sql.Date dueDate) {
                        this.dueDate = dueDate;
                    }

                    /** 
                     * Get the 'amount' attribute value. Amount to pay.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'amount' attribute value. Amount to pay.
                     * 
                     * @param amount
                     */
                    public void setAmount(BigDecimal amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'currency' attribute value. Currency.
                     * 
                     * @return value
                     */
                    public String getCurrency() {
                        return currency;
                    }

                    /** 
                     * Set the 'currency' attribute value. Currency.
                     * 
                     * @param currency
                     */
                    public void setCurrency(String currency) {
                        this.currency = currency;
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Lodging" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ResGlobalInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class ResGlobalInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Rooms" minOccurs="0">
     *         &lt;!-- Reference to inner class Rooms -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SpecialInstructions" minOccurs="0">
     *         &lt;!-- Reference to inner class SpecialInstructions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaymentInformation" minOccurs="0">
     *         &lt;!-- Reference to inner class PaymentInformation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ArrivalDepartureInformation" minOccurs="0">
     *         &lt;!-- Reference to inner class ArrivalDepartureInformation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="POS" minOccurs="0">
     *         &lt;!-- Reference to inner class POS -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ValueAdds" minOccurs="0">
     *         &lt;!-- Reference to inner class ValueAdds -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="VoucherInformation" minOccurs="0">
     *         &lt;!-- Reference to inner class VoucherInformation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Lodging implements Serializable
    {
        private ResGlobalInfo resGlobalInfo;
        private Rooms rooms;
        private SpecialInstructions specialInstructions;
        private PaymentInformation paymentInformation;
        private ArrivalDepartureInformation arrivalDepartureInformation;
        private POS POS1;
        private ValueAdds valueAdds;
        private VoucherInformation voucherInformation;

        /** 
         * Get the 'ResGlobalInfo' element value.
         * 
         * @return value
         */
        public ResGlobalInfo getResGlobalInfo() {
            return resGlobalInfo;
        }

        /** 
         * Set the 'ResGlobalInfo' element value.
         * 
         * @param resGlobalInfo
         */
        public void setResGlobalInfo(ResGlobalInfo resGlobalInfo) {
            this.resGlobalInfo = resGlobalInfo;
        }

        /** 
         * Get the 'Rooms' element value.
         * 
         * @return value
         */
        public Rooms getRooms() {
            return rooms;
        }

        /** 
         * Set the 'Rooms' element value.
         * 
         * @param rooms
         */
        public void setRooms(Rooms rooms) {
            this.rooms = rooms;
        }

        /** 
         * Get the 'SpecialInstructions' element value.
         * 
         * @return value
         */
        public SpecialInstructions getSpecialInstructions() {
            return specialInstructions;
        }

        /** 
         * Set the 'SpecialInstructions' element value.
         * 
         * @param specialInstructions
         */
        public void setSpecialInstructions(
                SpecialInstructions specialInstructions) {
            this.specialInstructions = specialInstructions;
        }

        /** 
         * Get the 'PaymentInformation' element value.
         * 
         * @return value
         */
        public PaymentInformation getPaymentInformation() {
            return paymentInformation;
        }

        /** 
         * Set the 'PaymentInformation' element value.
         * 
         * @param paymentInformation
         */
        public void setPaymentInformation(PaymentInformation paymentInformation) {
            this.paymentInformation = paymentInformation;
        }

        /** 
         * Get the 'ArrivalDepartureInformation' element value.
         * 
         * @return value
         */
        public ArrivalDepartureInformation getArrivalDepartureInformation() {
            return arrivalDepartureInformation;
        }

        /** 
         * Set the 'ArrivalDepartureInformation' element value.
         * 
         * @param arrivalDepartureInformation
         */
        public void setArrivalDepartureInformation(
                ArrivalDepartureInformation arrivalDepartureInformation) {
            this.arrivalDepartureInformation = arrivalDepartureInformation;
        }

        /** 
         * Get the 'POS' element value.
         * 
         * @return value
         */
        public POS getPOS1() {
            return POS1;
        }

        /** 
         * Set the 'POS' element value.
         * 
         * @param POS1
         */
        public void setPOS1(POS POS1) {
            this.POS1 = POS1;
        }

        /** 
         * Get the 'ValueAdds' element value.
         * 
         * @return value
         */
        public ValueAdds getValueAdds() {
            return valueAdds;
        }

        /** 
         * Set the 'ValueAdds' element value.
         * 
         * @param valueAdds
         */
        public void setValueAdds(ValueAdds valueAdds) {
            this.valueAdds = valueAdds;
        }

        /** 
         * Get the 'VoucherInformation' element value.
         * 
         * @return value
         */
        public VoucherInformation getVoucherInformation() {
            return voucherInformation;
        }

        /** 
         * Set the 'VoucherInformation' element value.
         * 
         * @param voucherInformation
         */
        public void setVoucherInformation(VoucherInformation voucherInformation) {
            this.voucherInformation = voucherInformation;
        }
        /** 
         * Reservation Information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResGlobalInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BookingInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class BookingInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="HotelInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class HotelInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="StayDateRange" minOccurs="0">
         *         &lt;!-- Reference to inner class StayDateRange -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Total" minOccurs="0">
         *         &lt;!-- Reference to inner class Total -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="AdditionalDetails" minOccurs="0">
         *         &lt;!-- Reference to inner class AdditionalDetails -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Fees" minOccurs="0">
         *         &lt;!-- Reference to inner class Fees -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Taxes" minOccurs="0">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CancelPenalties" minOccurs="0">
         *         &lt;!-- Reference to inner class CancelPenalties -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Guarantee" minOccurs="0">
         *         &lt;!-- Reference to inner class Guarantee -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Discounts" minOccurs="0">
         *         &lt;!-- Reference to inner class Discounts -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ResGlobalInfo implements Serializable
        {
            private BookingInfo bookingInfo;
            private HotelInfo hotelInfo;
            private StayDateRange stayDateRange;
            private Total total;
            private AdditionalDetails additionalDetails;
            private Fees fees;
            private Taxes taxes;
            private CancelPenalties cancelPenalties;
            private Guarantee guarantee;
            private Commission commission;
            private Discounts discounts;

            /** 
             * Get the 'BookingInfo' element value.
             * 
             * @return value
             */
            public BookingInfo getBookingInfo() {
                return bookingInfo;
            }

            /** 
             * Set the 'BookingInfo' element value.
             * 
             * @param bookingInfo
             */
            public void setBookingInfo(BookingInfo bookingInfo) {
                this.bookingInfo = bookingInfo;
            }

            /** 
             * Get the 'HotelInfo' element value.
             * 
             * @return value
             */
            public HotelInfo getHotelInfo() {
                return hotelInfo;
            }

            /** 
             * Set the 'HotelInfo' element value.
             * 
             * @param hotelInfo
             */
            public void setHotelInfo(HotelInfo hotelInfo) {
                this.hotelInfo = hotelInfo;
            }

            /** 
             * Get the 'StayDateRange' element value.
             * 
             * @return value
             */
            public StayDateRange getStayDateRange() {
                return stayDateRange;
            }

            /** 
             * Set the 'StayDateRange' element value.
             * 
             * @param stayDateRange
             */
            public void setStayDateRange(StayDateRange stayDateRange) {
                this.stayDateRange = stayDateRange;
            }

            /** 
             * Get the 'Total' element value.
             * 
             * @return value
             */
            public Total getTotal() {
                return total;
            }

            /** 
             * Set the 'Total' element value.
             * 
             * @param total
             */
            public void setTotal(Total total) {
                this.total = total;
            }

            /** 
             * Get the 'AdditionalDetails' element value.
             * 
             * @return value
             */
            public AdditionalDetails getAdditionalDetails() {
                return additionalDetails;
            }

            /** 
             * Set the 'AdditionalDetails' element value.
             * 
             * @param additionalDetails
             */
            public void setAdditionalDetails(AdditionalDetails additionalDetails) {
                this.additionalDetails = additionalDetails;
            }

            /** 
             * Get the 'Fees' element value.
             * 
             * @return value
             */
            public Fees getFees() {
                return fees;
            }

            /** 
             * Set the 'Fees' element value.
             * 
             * @param fees
             */
            public void setFees(Fees fees) {
                this.fees = fees;
            }

            /** 
             * Get the 'Taxes' element value.
             * 
             * @return value
             */
            public Taxes getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value.
             * 
             * @param taxes
             */
            public void setTaxes(Taxes taxes) {
                this.taxes = taxes;
            }

            /** 
             * Get the 'CancelPenalties' element value.
             * 
             * @return value
             */
            public CancelPenalties getCancelPenalties() {
                return cancelPenalties;
            }

            /** 
             * Set the 'CancelPenalties' element value.
             * 
             * @param cancelPenalties
             */
            public void setCancelPenalties(CancelPenalties cancelPenalties) {
                this.cancelPenalties = cancelPenalties;
            }

            /** 
             * Get the 'Guarantee' element value.
             * 
             * @return value
             */
            public Guarantee getGuarantee() {
                return guarantee;
            }

            /** 
             * Set the 'Guarantee' element value.
             * 
             * @param guarantee
             */
            public void setGuarantee(Guarantee guarantee) {
                this.guarantee = guarantee;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the 'Discounts' element value.
             * 
             * @return value
             */
            public Discounts getDiscounts() {
                return discounts;
            }

            /** 
             * Set the 'Discounts' element value.
             * 
             * @param discounts
             */
            public void setDiscounts(Discounts discounts) {
                this.discounts = discounts;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="BookingKey" minOccurs="0"/>
             *       &lt;xs:element name="BookingRef" minOccurs="0">
             *         &lt;!-- Reference to inner class BookingRef -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="CancellationReason" minOccurs="0"/>
             *       &lt;xs:element name="HotelReservationIds" minOccurs="0">
             *         &lt;!-- Reference to inner class HotelReservationIds -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="Status"/>
             *     &lt;xs:attribute type="xs:string" name="RequestorID"/>
             *     &lt;xs:attribute type="xs:string" name="CorpDiscount"/>
             *     &lt;xs:attribute type="xs:string" name="PromotionalCode"/>
             *     &lt;xs:attribute type="xs:date" name="CreationDate"/>
             *     &lt;xs:attribute type="xs:boolean" name="ExistingItinerary"/>
             *     &lt;xs:attribute type="xs:string" name="InfoSource"/>
             *     &lt;xs:attribute type="xs:string" name="RateKey"/>
             *     &lt;xs:attribute type="xs:string" name="TransactionId"/>
             *     &lt;xs:attribute type="xs:boolean" name="RetransmissionIndicator"/>
             *     &lt;xs:attribute type="xs:string" name="Email"/>
             *     &lt;xs:attribute type="xs:string" name="FrequentFlyerNumber"/>
             *     &lt;xs:attribute type="xs:string" name="LoyaltyId"/>
             *     &lt;xs:attribute type="xs:boolean" name="PartialCancelAllowed"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BookingInfo implements Serializable
            {
                private String bookingKey;
                private BookingRef bookingRef;
                private String cancellationReason;
                private HotelReservationIds hotelReservationIds;
                private String status;
                private String requestorID;
                private String corpDiscount;
                private String promotionalCode;
                private java.sql.Date creationDate;
                private Boolean existingItinerary;
                private String infoSource;
                private String rateKey;
                private String transactionId;
                private Boolean retransmissionIndicator;
                private String email;
                private String frequentFlyerNumber;
                private String loyaltyId;
                private Boolean partialCancelAllowed;

                /** 
                 * Get the 'BookingKey' element value. ''BookingKey'' returns the hotel booking key.
                 * 
                 * @return value
                 */
                public String getBookingKey() {
                    return bookingKey;
                }

                /** 
                 * Set the 'BookingKey' element value. ''BookingKey'' returns the hotel booking key.
                 * 
                 * @param bookingKey
                 */
                public void setBookingKey(String bookingKey) {
                    this.bookingKey = bookingKey;
                }

                /** 
                 * Get the 'BookingRef' element value.
                 * 
                 * @return value
                 */
                public BookingRef getBookingRef() {
                    return bookingRef;
                }

                /** 
                 * Set the 'BookingRef' element value.
                 * 
                 * @param bookingRef
                 */
                public void setBookingRef(BookingRef bookingRef) {
                    this.bookingRef = bookingRef;
                }

                /** 
                 * Get the 'CancellationReason' element value. ''CancellationReason'' returns the cancellation reason.
                 * 
                 * @return value
                 */
                public String getCancellationReason() {
                    return cancellationReason;
                }

                /** 
                 * Set the 'CancellationReason' element value. ''CancellationReason'' returns the cancellation reason.
                 * 
                 * @param cancellationReason
                 */
                public void setCancellationReason(String cancellationReason) {
                    this.cancellationReason = cancellationReason;
                }

                /** 
                 * Get the 'HotelReservationIds' element value.
                 * 
                 * @return value
                 */
                public HotelReservationIds getHotelReservationIds() {
                    return hotelReservationIds;
                }

                /** 
                 * Set the 'HotelReservationIds' element value.
                 * 
                 * @param hotelReservationIds
                 */
                public void setHotelReservationIds(
                        HotelReservationIds hotelReservationIds) {
                    this.hotelReservationIds = hotelReservationIds;
                }

                /** 
                 * Get the 'Status' attribute value. ''Status'' returns booking status codes taken from STS OTA table.
                                                                    `39` - confirmed.
                                                                    `16` - cancelled.
                                                                    `22` - unconfirmed.
                 * 
                 * @return value
                 */
                public String getStatus() {
                    return status;
                }

                /** 
                 * Set the 'Status' attribute value. ''Status'' returns booking status codes taken from STS OTA table.
                                                                    `39` - confirmed.
                                                                    `16` - cancelled.
                                                                    `22` - unconfirmed.
                 * 
                 * @param status
                 */
                public void setStatus(String status) {
                    this.status = status;
                }

                /** 
                 * Get the 'RequestorID' attribute value. ''RequestorID'' returns the IATA code of the hotel semgnet.
                 * 
                 * @return value
                 */
                public String getRequestorID() {
                    return requestorID;
                }

                /** 
                 * Set the 'RequestorID' attribute value. ''RequestorID'' returns the IATA code of the hotel semgnet.
                 * 
                 * @param requestorID
                 */
                public void setRequestorID(String requestorID) {
                    this.requestorID = requestorID;
                }

                /** 
                 * Get the 'CorpDiscount' attribute value. ''CorpDiscount'' returns the corporate id.
                 * 
                 * @return value
                 */
                public String getCorpDiscount() {
                    return corpDiscount;
                }

                /** 
                 * Set the 'CorpDiscount' attribute value. ''CorpDiscount'' returns the corporate id.
                 * 
                 * @param corpDiscount
                 */
                public void setCorpDiscount(String corpDiscount) {
                    this.corpDiscount = corpDiscount;
                }

                /** 
                 * Get the 'PromotionalCode' attribute value. ''PromotionalCode'' returns the promotional code.
                 * 
                 * @return value
                 */
                public String getPromotionalCode() {
                    return promotionalCode;
                }

                /** 
                 * Set the 'PromotionalCode' attribute value. ''PromotionalCode'' returns the promotional code.
                 * 
                 * @param promotionalCode
                 */
                public void setPromotionalCode(String promotionalCode) {
                    this.promotionalCode = promotionalCode;
                }

                /** 
                 * Get the 'CreationDate' attribute value. ''CreationDate'' returns booking creation date returned from hotel supplier.
                 * 
                 * @return value
                 */
                public java.sql.Date getCreationDate() {
                    return creationDate;
                }

                /** 
                 * Set the 'CreationDate' attribute value. ''CreationDate'' returns booking creation date returned from hotel supplier.
                 * 
                 * @param creationDate
                 */
                public void setCreationDate(java.sql.Date creationDate) {
                    this.creationDate = creationDate;
                }

                /** 
                 * Get the 'ExistingItinerary' attribute value. ''ExistingItinerary'' indicates if this is an existing itinerary as returned by hotel supplier.
                 * 
                 * @return value
                 */
                public Boolean getExistingItinerary() {
                    return existingItinerary;
                }

                /** 
                 * Set the 'ExistingItinerary' attribute value. ''ExistingItinerary'' indicates if this is an existing itinerary as returned by hotel supplier.
                 * 
                 * @param existingItinerary
                 */
                public void setExistingItinerary(Boolean existingItinerary) {
                    this.existingItinerary = existingItinerary;
                }

                /** 
                 * Get the 'InfoSource' attribute value. ''InfoSource'' returns three letter numeric code indicating booking source.
                                                                    `110` - Expedia Associate Network
                                                                    `100` - Sabre GDS
                                                                    `112` - HotelBeds.com
                                                                    `113` - Booking.com
                 * 
                 * @return value
                 */
                public String getInfoSource() {
                    return infoSource;
                }

                /** 
                 * Set the 'InfoSource' attribute value. ''InfoSource'' returns three letter numeric code indicating booking source.
                                                                    `110` - Expedia Associate Network
                                                                    `100` - Sabre GDS
                                                                    `112` - HotelBeds.com
                                                                    `113` - Booking.com
                 * 
                 * @param infoSource
                 */
                public void setInfoSource(String infoSource) {
                    this.infoSource = infoSource;
                }

                /** 
                 * Get the 'RateKey' attribute value. ''RateKey'' returns the RateKey of the product being booked.
                 * 
                 * @return value
                 */
                public String getRateKey() {
                    return rateKey;
                }

                /** 
                 * Set the 'RateKey' attribute value. ''RateKey'' returns the RateKey of the product being booked.
                 * 
                 * @param rateKey
                 */
                public void setRateKey(String rateKey) {
                    this.rateKey = rateKey;
                }

                /** 
                 * Get the 'TransactionId' attribute value. ''TransactionID'' returns a unique transaction generated by hotels and should be provided on retries.
                 * 
                 * @return value
                 */
                public String getTransactionId() {
                    return transactionId;
                }

                /** 
                 * Set the 'TransactionId' attribute value. ''TransactionID'' returns a unique transaction generated by hotels and should be provided on retries.
                 * 
                 * @param transactionId
                 */
                public void setTransactionId(String transactionId) {
                    this.transactionId = transactionId;
                }

                /** 
                 * Get the 'RetransmissionIndicator' attribute value. ''RetransmissionIndicator'' returns the retransmission indicator.
                 * 
                 * @return value
                 */
                public Boolean getRetransmissionIndicator() {
                    return retransmissionIndicator;
                }

                /** 
                 * Set the 'RetransmissionIndicator' attribute value. ''RetransmissionIndicator'' returns the retransmission indicator.
                 * 
                 * @param retransmissionIndicator
                 */
                public void setRetransmissionIndicator(
                        Boolean retransmissionIndicator) {
                    this.retransmissionIndicator = retransmissionIndicator;
                }

                /** 
                 * Get the 'Email' attribute value. ''Email'' returns a email address.
                 * 
                 * @return value
                 */
                public String getEmail() {
                    return email;
                }

                /** 
                 * Set the 'Email' attribute value. ''Email'' returns a email address.
                 * 
                 * @param email
                 */
                public void setEmail(String email) {
                    this.email = email;
                }

                /** 
                 * Get the 'FrequentFlyerNumber' attribute value. ''FrequentFlyerNumber'' returns the frequent flyer number.
                 * 
                 * @return value
                 */
                public String getFrequentFlyerNumber() {
                    return frequentFlyerNumber;
                }

                /** 
                 * Set the 'FrequentFlyerNumber' attribute value. ''FrequentFlyerNumber'' returns the frequent flyer number.
                 * 
                 * @param frequentFlyerNumber
                 */
                public void setFrequentFlyerNumber(String frequentFlyerNumber) {
                    this.frequentFlyerNumber = frequentFlyerNumber;
                }

                /** 
                 * Get the 'LoyaltyId' attribute value. ''LoyaltyId'' returns the loyalty program Id.
                 * 
                 * @return value
                 */
                public String getLoyaltyId() {
                    return loyaltyId;
                }

                /** 
                 * Set the 'LoyaltyId' attribute value. ''LoyaltyId'' returns the loyalty program Id.
                 * 
                 * @param loyaltyId
                 */
                public void setLoyaltyId(String loyaltyId) {
                    this.loyaltyId = loyaltyId;
                }

                /** 
                 * Get the 'PartialCancelAllowed' attribute value. ''PartialCancelAllowed'' returns the partial cancel allowed identifier.
                 * 
                 * @return value
                 */
                public Boolean getPartialCancelAllowed() {
                    return partialCancelAllowed;
                }

                /** 
                 * Set the 'PartialCancelAllowed' attribute value. ''PartialCancelAllowed'' returns the partial cancel allowed identifier.
                 * 
                 * @param partialCancelAllowed
                 */
                public void setPartialCancelAllowed(Boolean partialCancelAllowed) {
                    this.partialCancelAllowed = partialCancelAllowed;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingRef" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="InfoSource"/>
                 *     &lt;xs:attribute type="xs:string" name="Email"/>
                 *     &lt;xs:attribute type="xs:string" name="LastName"/>
                 *     &lt;xs:attribute type="xs:date" name="CreationDate"/>
                 *     &lt;xs:attribute type="xs:date" name="StayStartDate"/>
                 *     &lt;xs:attribute type="xs:date" name="StayEndDate"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="RateKey"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BookingRef implements Serializable
                {
                    private String infoSource;
                    private String email;
                    private String lastName;
                    private java.sql.Date creationDate;
                    private java.sql.Date stayStartDate;
                    private java.sql.Date stayEndDate;
                    private String rateKey;

                    /** 
                     * Get the 'InfoSource' attribute value. ''InfoSource'' returns a three letter numeric code indicating booking source.
                                                                                  `110` - Expedia Associate Network
                                                                                  `100` - Sabre GDS
                                                                                  `112` - HotelBeds.com
                                                                                  `113` - Booking.com
                     * 
                     * @return value
                     */
                    public String getInfoSource() {
                        return infoSource;
                    }

                    /** 
                     * Set the 'InfoSource' attribute value. ''InfoSource'' returns a three letter numeric code indicating booking source.
                                                                                  `110` - Expedia Associate Network
                                                                                  `100` - Sabre GDS
                                                                                  `112` - HotelBeds.com
                                                                                  `113` - Booking.com
                     * 
                     * @param infoSource
                     */
                    public void setInfoSource(String infoSource) {
                        this.infoSource = infoSource;
                    }

                    /** 
                     * Get the 'Email' attribute value. ''Email'' returns a email.
                     * 
                     * @return value
                     */
                    public String getEmail() {
                        return email;
                    }

                    /** 
                     * Set the 'Email' attribute value. ''Email'' returns a email.
                     * 
                     * @param email
                     */
                    public void setEmail(String email) {
                        this.email = email;
                    }

                    /** 
                     * Get the 'LastName' attribute value. ''LastName'' returns the last name.
                     * 
                     * @return value
                     */
                    public String getLastName() {
                        return lastName;
                    }

                    /** 
                     * Set the 'LastName' attribute value. ''LastName'' returns the last name.
                     * 
                     * @param lastName
                     */
                    public void setLastName(String lastName) {
                        this.lastName = lastName;
                    }

                    /** 
                     * Get the 'CreationDate' attribute value. ''CreationDate'' returns the creation date.
                     * 
                     * @return value
                     */
                    public java.sql.Date getCreationDate() {
                        return creationDate;
                    }

                    /** 
                     * Set the 'CreationDate' attribute value. ''CreationDate'' returns the creation date.
                     * 
                     * @param creationDate
                     */
                    public void setCreationDate(java.sql.Date creationDate) {
                        this.creationDate = creationDate;
                    }

                    /** 
                     * Get the 'StayStartDate' attribute value. ''StayStartDate'' returns the hotel stay start date.
                     * 
                     * @return value
                     */
                    public java.sql.Date getStayStartDate() {
                        return stayStartDate;
                    }

                    /** 
                     * Set the 'StayStartDate' attribute value. ''StayStartDate'' returns the hotel stay start date.
                     * 
                     * @param stayStartDate
                     */
                    public void setStayStartDate(java.sql.Date stayStartDate) {
                        this.stayStartDate = stayStartDate;
                    }

                    /** 
                     * Get the 'StayEndDate' attribute value. ''StayEndDate'' returns the hotel stay end date.
                     * 
                     * @return value
                     */
                    public java.sql.Date getStayEndDate() {
                        return stayEndDate;
                    }

                    /** 
                     * Set the 'StayEndDate' attribute value. ''StayEndDate'' returns the hotel stay end date.
                     * 
                     * @param stayEndDate
                     */
                    public void setStayEndDate(java.sql.Date stayEndDate) {
                        this.stayEndDate = stayEndDate;
                    }

                    /** 
                     * Get the 'RateKey' attribute value. ''RateKey'' returns the hotel rate key.
                     * 
                     * @return value
                     */
                    public String getRateKey() {
                        return rateKey;
                    }

                    /** 
                     * Set the 'RateKey' attribute value. ''RateKey'' returns the hotel rate key.
                     * 
                     * @param rateKey
                     */
                    public void setRateKey(String rateKey) {
                        this.rateKey = rateKey;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelReservationIds" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="HotelReservation" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class HotelReservation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HotelReservationIds implements Serializable
                {
                    private List<HotelReservation> hotelReservationList = new ArrayList<HotelReservation>();

                    /** 
                     * Get the list of 'HotelReservation' element items.
                     * 
                     * @return list
                     */
                    public List<HotelReservation> getHotelReservationList() {
                        return hotelReservationList;
                    }

                    /** 
                     * Set the list of 'HotelReservation' element items.
                     * 
                     * @param list
                     */
                    public void setHotelReservationList(
                            List<HotelReservation> list) {
                        hotelReservationList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelReservation" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Id"/>
                     *     &lt;xs:attribute type="xs:int" use="required" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class HotelReservation implements
                        Serializable
                    {
                        private String id;
                        private Integer type;

                        /** 
                         * Get the 'Id' attribute value. ''Id'' returns a hotel reservation identifier.
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. ''Id'' returns a hotel reservation identifier.
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }

                        /** 
                         * Get the 'Type' attribute value. ''Type'' uses OTA Table UIT Code.
                                                                                                `24` - PNR.
                                                                                                `40` - Confirmation Number.
                         * 
                         * @return value
                         */
                        public Integer getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. ''Type'' uses OTA Table UIT Code.
                                                                                                `24` - PNR.
                                                                                                `40` - Confirmation Number.
                         * 
                         * @param type
                         */
                        public void setType(Integer type) {
                            this.type = type;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TierLabels" minOccurs="0">
             *         &lt;!-- Reference to inner class TierLabels -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="LocationInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class LocationInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Amenities" minOccurs="0">
             *         &lt;!-- Reference to inner class Amenities -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PropertyTypeInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class PropertyTypeInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="HotelCode"/>
             *     &lt;xs:attribute name="CodeContext">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class CodeContext -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *     &lt;xs:attribute type="xs:string" name="GlobalChainCode"/>
             *     &lt;xs:attribute type="xs:string" name="HotelName"/>
             *     &lt;xs:attribute type="xs:string" name="BrandCode"/>
             *     &lt;xs:attribute type="xs:string" name="SabreRating"/>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:string" name="ChainName"/>
             *     &lt;xs:attribute type="xs:string" name="BrandName"/>
             *     &lt;xs:attribute type="xs:string" name="SupplierChainCode"/>
             *     &lt;xs:attribute type="xs:string" name="SourceHotelCode"/>
             *     &lt;xs:attribute type="xs:int" name="Ordinal"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HotelInfo implements Serializable
            {
                private TierLabels tierLabels;
                private LocationInfo locationInfo;
                private Amenities amenities;
                private PropertyTypeInfo propertyTypeInfo;
                private String hotelCode;
                private CodeContext codeContext;
                private String globalChainCode;
                private String hotelName;
                private String brandCode;
                private String sabreRating;
                private String currencyCode;
                private String chainName;
                private String brandName;
                private String supplierChainCode;
                private String sourceHotelCode;
                private Integer ordinal;

                /** 
                 * Get the 'TierLabels' element value.
                 * 
                 * @return value
                 */
                public TierLabels getTierLabels() {
                    return tierLabels;
                }

                /** 
                 * Set the 'TierLabels' element value.
                 * 
                 * @param tierLabels
                 */
                public void setTierLabels(TierLabels tierLabels) {
                    this.tierLabels = tierLabels;
                }

                /** 
                 * Get the 'LocationInfo' element value.
                 * 
                 * @return value
                 */
                public LocationInfo getLocationInfo() {
                    return locationInfo;
                }

                /** 
                 * Set the 'LocationInfo' element value.
                 * 
                 * @param locationInfo
                 */
                public void setLocationInfo(LocationInfo locationInfo) {
                    this.locationInfo = locationInfo;
                }

                /** 
                 * Get the 'Amenities' element value.
                 * 
                 * @return value
                 */
                public Amenities getAmenities() {
                    return amenities;
                }

                /** 
                 * Set the 'Amenities' element value.
                 * 
                 * @param amenities
                 */
                public void setAmenities(Amenities amenities) {
                    this.amenities = amenities;
                }

                /** 
                 * Get the 'PropertyTypeInfo' element value.
                 * 
                 * @return value
                 */
                public PropertyTypeInfo getPropertyTypeInfo() {
                    return propertyTypeInfo;
                }

                /** 
                 * Set the 'PropertyTypeInfo' element value.
                 * 
                 * @param propertyTypeInfo
                 */
                public void setPropertyTypeInfo(
                        PropertyTypeInfo propertyTypeInfo) {
                    this.propertyTypeInfo = propertyTypeInfo;
                }

                /** 
                 * Get the 'HotelCode' attribute value. ''HotelCode'' returns hotel Id from SABRE hotels platform.
                 * 
                 * @return value
                 */
                public String getHotelCode() {
                    return hotelCode;
                }

                /** 
                 * Set the 'HotelCode' attribute value. ''HotelCode'' returns hotel Id from SABRE hotels platform.
                 * 
                 * @param hotelCode
                 */
                public void setHotelCode(String hotelCode) {
                    this.hotelCode = hotelCode;
                }

                /** 
                 * Get the 'CodeContext' attribute value. ''CodeContext'' indicates whether the given HotelCode is Sabre property ID or Global property ID.
                 * 
                 * @return value
                 */
                public CodeContext getCodeContext() {
                    return codeContext;
                }

                /** 
                 * Set the 'CodeContext' attribute value. ''CodeContext'' indicates whether the given HotelCode is Sabre property ID or Global property ID.
                 * 
                 * @param codeContext
                 */
                public void setCodeContext(CodeContext codeContext) {
                    this.codeContext = codeContext;
                }

                /** 
                 * Get the 'GlobalChainCode' attribute value. ''GlobalChainCode'' returns actual chain code from hotel list.
                                                                    Two character code of the Chain to which the property belongs.
                 * 
                 * @return value
                 */
                public String getGlobalChainCode() {
                    return globalChainCode;
                }

                /** 
                 * Set the 'GlobalChainCode' attribute value. ''GlobalChainCode'' returns actual chain code from hotel list.
                                                                    Two character code of the Chain to which the property belongs.
                 * 
                 * @param globalChainCode
                 */
                public void setGlobalChainCode(String globalChainCode) {
                    this.globalChainCode = globalChainCode;
                }

                /** 
                 * Get the 'HotelName' attribute value. ''HotelName'' returns hotel property name.
                 * 
                 * @return value
                 */
                public String getHotelName() {
                    return hotelName;
                }

                /** 
                 * Set the 'HotelName' attribute value. ''HotelName'' returns hotel property name.
                 * 
                 * @param hotelName
                 */
                public void setHotelName(String hotelName) {
                    this.hotelName = hotelName;
                }

                /** 
                 * Get the 'BrandCode' attribute value. ''BrandCode'' returns the name of Brand to which the property belongs.
                 * 
                 * @return value
                 */
                public String getBrandCode() {
                    return brandCode;
                }

                /** 
                 * Set the 'BrandCode' attribute value. ''BrandCode'' returns the name of Brand to which the property belongs.
                 * 
                 * @param brandCode
                 */
                public void setBrandCode(String brandCode) {
                    this.brandCode = brandCode;
                }

                /** 
                 * Get the 'SabreRating' attribute value. ''SabreRating'' returns the Sabre property rating.
                 * 
                 * @return value
                 */
                public String getSabreRating() {
                    return sabreRating;
                }

                /** 
                 * Set the 'SabreRating' attribute value. ''SabreRating'' returns the Sabre property rating.
                 * 
                 * @param sabreRating
                 */
                public void setSabreRating(String sabreRating) {
                    this.sabreRating = sabreRating;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns the currency accepted for payments at the hotel.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns the currency accepted for payments at the hotel.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'ChainName' attribute value. ''ChainName'' returns the name of chain to which the property belongs.
                 * 
                 * @return value
                 */
                public String getChainName() {
                    return chainName;
                }

                /** 
                 * Set the 'ChainName' attribute value. ''ChainName'' returns the name of chain to which the property belongs.
                 * 
                 * @param chainName
                 */
                public void setChainName(String chainName) {
                    this.chainName = chainName;
                }

                /** 
                 * Get the 'BrandName' attribute value. ''BrandName'' returns the name of Brand to which the property belongs.
                 * 
                 * @return value
                 */
                public String getBrandName() {
                    return brandName;
                }

                /** 
                 * Set the 'BrandName' attribute value. ''BrandName'' returns the name of Brand to which the property belongs.
                 * 
                 * @param brandName
                 */
                public void setBrandName(String brandName) {
                    this.brandName = brandName;
                }

                /** 
                 * Get the 'SupplierChainCode' attribute value. ''SupplierChainCode'' returns the 2 character code of the supplier to be billed.
                 * 
                 * @return value
                 */
                public String getSupplierChainCode() {
                    return supplierChainCode;
                }

                /** 
                 * Set the 'SupplierChainCode' attribute value. ''SupplierChainCode'' returns the 2 character code of the supplier to be billed.
                 * 
                 * @param supplierChainCode
                 */
                public void setSupplierChainCode(String supplierChainCode) {
                    this.supplierChainCode = supplierChainCode;
                }

                /** 
                 * Get the 'SourceHotelCode' attribute value. ''SourceHotelCode'' returns the supplier/source Hotel Id taken from the rate key.
                 * 
                 * @return value
                 */
                public String getSourceHotelCode() {
                    return sourceHotelCode;
                }

                /** 
                 * Set the 'SourceHotelCode' attribute value. ''SourceHotelCode'' returns the supplier/source Hotel Id taken from the rate key.
                 * 
                 * @param sourceHotelCode
                 */
                public void setSourceHotelCode(String sourceHotelCode) {
                    this.sourceHotelCode = sourceHotelCode;
                }

                /** 
                 * Get the 'Ordinal' attribute value. ''Ordinal'' displays position at which preferred properties are shown in the response.
                 * 
                 * @return value
                 */
                public Integer getOrdinal() {
                    return ordinal;
                }

                /** 
                 * Set the 'Ordinal' attribute value. ''Ordinal'' displays position at which preferred properties are shown in the response.
                 * 
                 * @param ordinal
                 */
                public void setOrdinal(Integer ordinal) {
                    this.ordinal = ordinal;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TierLabels" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="TierLabel" maxOccurs="5">
                 *         &lt;!-- Reference to inner class TierLabel -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TierLabels implements Serializable
                {
                    private List<TierLabel> tierLabelList = new ArrayList<TierLabel>();

                    /** 
                     * Get the list of 'TierLabel' element items.
                     * 
                     * @return list
                     */
                    public List<TierLabel> getTierLabelList() {
                        return tierLabelList;
                    }

                    /** 
                     * Set the list of 'TierLabel' element items.
                     * 
                     * @param list
                     */
                    public void setTierLabelList(List<TierLabel> list) {
                        tierLabelList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TierLabel" maxOccurs="5">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" name="Value"/>
                     *     &lt;xs:attribute type="xs:string" name="ProgramId"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TierLabel implements Serializable
                    {
                        private String type;
                        private String value;
                        private String programId;

                        /** 
                         * Get the 'Type' attribute value. ''Type'' returns the tier label type.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. ''Type'' returns the tier label type.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'Value' attribute value. ''Value'' returns the tier label value.
                         * 
                         * @return value
                         */
                        public String getValue() {
                            return value;
                        }

                        /** 
                         * Set the 'Value' attribute value. ''Value'' returns the tier label value.
                         * 
                         * @param value
                         */
                        public void setValue(String value) {
                            this.value = value;
                        }

                        /** 
                         * Get the 'ProgramId' attribute value. ''ProgramId'' returns the tier label program identifier.
                         * 
                         * @return value
                         */
                        public String getProgramId() {
                            return programId;
                        }

                        /** 
                         * Set the 'ProgramId' attribute value. ''ProgramId'' returns the tier label program identifier.
                         * 
                         * @param programId
                         */
                        public void setProgramId(String programId) {
                            this.programId = programId;
                        }
                    }
                }
                /** 
                 * ''LocationInfo'' returns property location information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Address" minOccurs="0">
                 *         &lt;!-- Reference to inner class Address -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Contact" minOccurs="0">
                 *         &lt;!-- Reference to inner class Contact -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Latitude"/>
                 *     &lt;xs:attribute type="xs:string" name="Longitude"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class LocationInfo implements Serializable
                {
                    private Address address;
                    private Contact contact;
                    private String latitude;
                    private String longitude;

                    /** 
                     * Get the 'Address' element value.
                     * 
                     * @return value
                     */
                    public Address getAddress() {
                        return address;
                    }

                    /** 
                     * Set the 'Address' element value.
                     * 
                     * @param address
                     */
                    public void setAddress(Address address) {
                        this.address = address;
                    }

                    /** 
                     * Get the 'Contact' element value.
                     * 
                     * @return value
                     */
                    public Contact getContact() {
                        return contact;
                    }

                    /** 
                     * Set the 'Contact' element value.
                     * 
                     * @param contact
                     */
                    public void setContact(Contact contact) {
                        this.contact = contact;
                    }

                    /** 
                     * Get the 'Latitude' attribute value. ''Latitude'' returns the latitude GEO code of the property.
                     * 
                     * @return value
                     */
                    public String getLatitude() {
                        return latitude;
                    }

                    /** 
                     * Set the 'Latitude' attribute value. ''Latitude'' returns the latitude GEO code of the property.
                     * 
                     * @param latitude
                     */
                    public void setLatitude(String latitude) {
                        this.latitude = latitude;
                    }

                    /** 
                     * Get the 'Longitude' attribute value. ''Longitude'' returns the longitude GEO code of the property.
                     * 
                     * @return value
                     */
                    public String getLongitude() {
                        return longitude;
                    }

                    /** 
                     * Set the 'Longitude' attribute value. ''Longitude'' returns the longitude GEO code of the property.
                     * 
                     * @param longitude
                     */
                    public void setLongitude(String longitude) {
                        this.longitude = longitude;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="AddressLine1"/>
                     *       &lt;xs:element type="xs:string" name="AddressLine2" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="AddressLine3" minOccurs="0"/>
                     *       &lt;xs:element name="CityName" minOccurs="0">
                     *         &lt;!-- Reference to inner class CityName -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="StateProv" minOccurs="0">
                     *         &lt;!-- Reference to inner class StateProv -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
                     *       &lt;xs:element name="CountryName">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:string">
                     *               &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Address implements Serializable
                    {
                        private String addressLine1;
                        private String addressLine2;
                        private String addressLine3;
                        private CityName cityName;
                        private StateProv stateProv;
                        private String postalCode;
                        private String countryNameString;
                        private String countryNameCode;

                        /** 
                         * Get the 'AddressLine1' element value. ''AddressLine1'' returns the first hotel address line.
                         * 
                         * @return value
                         */
                        public String getAddressLine1() {
                            return addressLine1;
                        }

                        /** 
                         * Set the 'AddressLine1' element value. ''AddressLine1'' returns the first hotel address line.
                         * 
                         * @param addressLine1
                         */
                        public void setAddressLine1(String addressLine1) {
                            this.addressLine1 = addressLine1;
                        }

                        /** 
                         * Get the 'AddressLine2' element value. ''AddressLine2'' returns the second hotel address line.
                         * 
                         * @return value
                         */
                        public String getAddressLine2() {
                            return addressLine2;
                        }

                        /** 
                         * Set the 'AddressLine2' element value. ''AddressLine2'' returns the second hotel address line.
                         * 
                         * @param addressLine2
                         */
                        public void setAddressLine2(String addressLine2) {
                            this.addressLine2 = addressLine2;
                        }

                        /** 
                         * Get the 'AddressLine3' element value. ''AddressLine3'' returns the third hotel address line.
                         * 
                         * @return value
                         */
                        public String getAddressLine3() {
                            return addressLine3;
                        }

                        /** 
                         * Set the 'AddressLine3' element value. ''AddressLine3'' returns the third hotel address line.
                         * 
                         * @param addressLine3
                         */
                        public void setAddressLine3(String addressLine3) {
                            this.addressLine3 = addressLine3;
                        }

                        /** 
                         * Get the 'CityName' element value.
                         * 
                         * @return value
                         */
                        public CityName getCityName() {
                            return cityName;
                        }

                        /** 
                         * Set the 'CityName' element value.
                         * 
                         * @param cityName
                         */
                        public void setCityName(CityName cityName) {
                            this.cityName = cityName;
                        }

                        /** 
                         * Get the 'StateProv' element value.
                         * 
                         * @return value
                         */
                        public StateProv getStateProv() {
                            return stateProv;
                        }

                        /** 
                         * Set the 'StateProv' element value.
                         * 
                         * @param stateProv
                         */
                        public void setStateProv(StateProv stateProv) {
                            this.stateProv = stateProv;
                        }

                        /** 
                         * Get the 'PostalCode' element value. ''PostalCode'' returns the hotel postal code.
                         * 
                         * @return value
                         */
                        public String getPostalCode() {
                            return postalCode;
                        }

                        /** 
                         * Set the 'PostalCode' element value. ''PostalCode'' returns the hotel postal code.
                         * 
                         * @param postalCode
                         */
                        public void setPostalCode(String postalCode) {
                            this.postalCode = postalCode;
                        }

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getCountryNameString() {
                            return countryNameString;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param countryNameString
                         */
                        public void setCountryNameString(
                                String countryNameString) {
                            this.countryNameString = countryNameString;
                        }

                        /** 
                         * Get the 'Code' attribute value. ''Code'' returns the hotel country code.
                         * 
                         * @return value
                         */
                        public String getCountryNameCode() {
                            return countryNameCode;
                        }

                        /** 
                         * Set the 'Code' attribute value. ''Code'' returns the hotel country code.
                         * 
                         * @param countryNameCode
                         */
                        public void setCountryNameCode(String countryNameCode) {
                            this.countryNameCode = countryNameCode;
                        }
                        /** 
                         * ''CityName'' returns the hotel city name.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CityName" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" name="CityCode"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CityName implements Serializable
                        {
                            private String string;
                            private String cityCode;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'CityCode' attribute value. ''CityCode'' returns the hotel city code.
                             * 
                             * @return value
                             */
                            public String getCityCode() {
                                return cityCode;
                            }

                            /** 
                             * Set the 'CityCode' attribute value. ''CityCode'' returns the hotel city code.
                             * 
                             * @param cityCode
                             */
                            public void setCityCode(String cityCode) {
                                this.cityCode = cityCode;
                            }
                        }
                        /** 
                         * ''StateProv'' returns the hotel state or province name.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProv" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" name="StateCode"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class StateProv implements Serializable
                        {
                            private String string;
                            private String stateCode;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'StateCode' attribute value. ''StateCode'' returns the hotel state code.
                             * 
                             * @return value
                             */
                            public String getStateCode() {
                                return stateCode;
                            }

                            /** 
                             * Set the 'StateCode' attribute value. ''StateCode'' returns the hotel state code.
                             * 
                             * @param stateCode
                             */
                            public void setStateCode(String stateCode) {
                                this.stateCode = stateCode;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contact" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="Phone"/>
                     *     &lt;xs:attribute type="xs:string" name="Mobile"/>
                     *     &lt;xs:attribute type="xs:string" name="Fax"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Contact implements Serializable
                    {
                        private String phone;
                        private String mobile;
                        private String fax;

                        /** 
                         * Get the 'Phone' attribute value. ''Phone'' returns the hotel phone number.
                         * 
                         * @return value
                         */
                        public String getPhone() {
                            return phone;
                        }

                        /** 
                         * Set the 'Phone' attribute value. ''Phone'' returns the hotel phone number.
                         * 
                         * @param phone
                         */
                        public void setPhone(String phone) {
                            this.phone = phone;
                        }

                        /** 
                         * Get the 'Mobile' attribute value. ''Mobile'' returns the hotel mobile phone number.
                         * 
                         * @return value
                         */
                        public String getMobile() {
                            return mobile;
                        }

                        /** 
                         * Set the 'Mobile' attribute value. ''Mobile'' returns the hotel mobile phone number.
                         * 
                         * @param mobile
                         */
                        public void setMobile(String mobile) {
                            this.mobile = mobile;
                        }

                        /** 
                         * Get the 'Fax' attribute value. ''Fax'' returns the hotel fax number.
                         * 
                         * @return value
                         */
                        public String getFax() {
                            return fax;
                        }

                        /** 
                         * Set the 'Fax' attribute value. ''Fax'' returns the hotel fax number.
                         * 
                         * @param fax
                         */
                        public void setFax(String fax) {
                            this.fax = fax;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amenities" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Amenity" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Amenity -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Amenities implements Serializable
                {
                    private List<Amenity> amenityList = new ArrayList<Amenity>();

                    /** 
                     * Get the list of 'Amenity' element items.
                     * 
                     * @return list
                     */
                    public List<Amenity> getAmenityList() {
                        return amenityList;
                    }

                    /** 
                     * Set the list of 'Amenity' element items.
                     * 
                     * @param list
                     */
                    public void setAmenityList(List<Amenity> list) {
                        amenityList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amenity" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:int" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" name="Description"/>
                     *     &lt;xs:attribute type="xs:boolean" name="ComplimentaryInd"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Amenity implements Serializable
                    {
                        private Integer code;
                        private String description;
                        private Boolean complimentaryInd;

                        /** 
                         * Get the 'Code' attribute value. ''Code'' returns numeric OTA code for the Amenity.
                                                                                                Amenities in a Hotel are mapped to "HAC" OTA code.
                         * 
                         * @return value
                         */
                        public Integer getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value. ''Code'' returns numeric OTA code for the Amenity.
                                                                                                Amenities in a Hotel are mapped to "HAC" OTA code.
                         * 
                         * @param code
                         */
                        public void setCode(Integer code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'Description' attribute value. ''Description'' returns amenity description.
                                                                                                Ex- Free Breakfast, Free Wifi access for guests etc.
                         * 
                         * @return value
                         */
                        public String getDescription() {
                            return description;
                        }

                        /** 
                         * Set the 'Description' attribute value. ''Description'' returns amenity description.
                                                                                                Ex- Free Breakfast, Free Wifi access for guests etc.
                         * 
                         * @param description
                         */
                        public void setDescription(String description) {
                            this.description = description;
                        }

                        /** 
                         * Get the 'ComplimentaryInd' attribute value. ''ComplimentaryInd'' indicates if the corresponding Amenity is complimentary or charged extra.
                                                                                                `true` - The given Amenity has no additional charge and it is complimentary.
                                                                                                `false` - Amenity has additional charge and appropriately indicated.
                                                                                                When True the ComplimentaryInd attribute is not displayed in response.
                                                                                                It is displayed in API response only if it is False.
                         * 
                         * @return value
                         */
                        public Boolean getComplimentaryInd() {
                            return complimentaryInd;
                        }

                        /** 
                         * Set the 'ComplimentaryInd' attribute value. ''ComplimentaryInd'' indicates if the corresponding Amenity is complimentary or charged extra.
                                                                                                `true` - The given Amenity has no additional charge and it is complimentary.
                                                                                                `false` - Amenity has additional charge and appropriately indicated.
                                                                                                When True the ComplimentaryInd attribute is not displayed in response.
                                                                                                It is displayed in API response only if it is False.
                         * 
                         * @param complimentaryInd
                         */
                        public void setComplimentaryInd(Boolean complimentaryInd) {
                            this.complimentaryInd = complimentaryInd;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PropertyTypeInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PropertyType" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class PropertyType -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PropertyTypeInfo implements Serializable
                {
                    private List<PropertyType> propertyTypeList = new ArrayList<PropertyType>();

                    /** 
                     * Get the list of 'PropertyType' element items.
                     * 
                     * @return list
                     */
                    public List<PropertyType> getPropertyTypeList() {
                        return propertyTypeList;
                    }

                    /** 
                     * Set the list of 'PropertyType' element items.
                     * 
                     * @param list
                     */
                    public void setPropertyTypeList(List<PropertyType> list) {
                        propertyTypeList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PropertyType" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:int" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" name="Description"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PropertyType implements Serializable
                    {
                        private Integer code;
                        private String description;

                        /** 
                         * Get the 'Code' attribute value. ''Code'' returns numeric OTA code for the Property Class Type.
                                                                                                Property Types of  Hotel are mapped to "PCT" OTA code.
                         * 
                         * @return value
                         */
                        public Integer getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value. ''Code'' returns numeric OTA code for the Property Class Type.
                                                                                                Property Types of  Hotel are mapped to "PCT" OTA code.
                         * 
                         * @param code
                         */
                        public void setCode(Integer code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'Description' attribute value. ''Description'' returns property class type description.
                                                                                                Ex- Apartment, All Suites, Resort etc.
                         * 
                         * @return value
                         */
                        public String getDescription() {
                            return description;
                        }

                        /** 
                         * Set the 'Description' attribute value. ''Description'' returns property class type description.
                                                                                                Ex- Apartment, All Suites, Resort etc.
                         * 
                         * @param description
                         */
                        public void setDescription(String description) {
                            this.description = description;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="SABRE"/>
                 *     &lt;xs:enumeration value="GLOBAL"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum CodeContext implements Serializable {
                    SABRE, GLOBAL
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StayDateRange" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:date" name="StartDate"/>
             *     &lt;xs:attribute type="xs:date" name="EndDate"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class StayDateRange implements Serializable
            {
                private java.sql.Date startDate;
                private java.sql.Date endDate;

                /** 
                 * Get the 'StartDate' attribute value. ''StartDate'' returns hotel check in date.
                 * 
                 * @return value
                 */
                public java.sql.Date getStartDate() {
                    return startDate;
                }

                /** 
                 * Set the 'StartDate' attribute value. ''StartDate'' returns hotel check in date.
                 * 
                 * @param startDate
                 */
                public void setStartDate(java.sql.Date startDate) {
                    this.startDate = startDate;
                }

                /** 
                 * Get the 'EndDate' attribute value. ''EndDate'' returns hotel check out date.
                 * 
                 * @return value
                 */
                public java.sql.Date getEndDate() {
                    return endDate;
                }

                /** 
                 * Set the 'EndDate' attribute value. ''EndDate'' returns hotel check out date.
                 * 
                 * @param endDate
                 */
                public void setEndDate(java.sql.Date endDate) {
                    this.endDate = endDate;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:decimal" name="AmountAfterTax"/>
             *     &lt;xs:attribute type="xs:decimal" name="AmountBeforeTax"/>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:boolean" name="Changed"/>
             *     &lt;xs:attribute type="xs:decimal" name="BalanceAmount"/>
             *     &lt;xs:attribute type="xs:decimal" name="SupplierChangedAmount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Total implements Serializable
            {
                private BigDecimal amountAfterTax;
                private BigDecimal amountBeforeTax;
                private String currencyCode;
                private Boolean changed;
                private BigDecimal balanceAmount;
                private BigDecimal supplierChangedAmount;

                /** 
                 * Get the 'AmountAfterTax' attribute value. ''AmountAfterTax'' returns the total amount including all associated taxes (e.g., sales tax, VAT, GST).
                 * 
                 * @return value
                 */
                public BigDecimal getAmountAfterTax() {
                    return amountAfterTax;
                }

                /** 
                 * Set the 'AmountAfterTax' attribute value. ''AmountAfterTax'' returns the total amount including all associated taxes (e.g., sales tax, VAT, GST).
                 * 
                 * @param amountAfterTax
                 */
                public void setAmountAfterTax(BigDecimal amountAfterTax) {
                    this.amountAfterTax = amountAfterTax;
                }

                /** 
                 * Get the 'AmountBeforeTax' attribute value. ''AmountBeforeTax'' returns the total amount not including any associated tax (e.g., sales tax, VAT, GST).
                 * 
                 * @return value
                 */
                public BigDecimal getAmountBeforeTax() {
                    return amountBeforeTax;
                }

                /** 
                 * Set the 'AmountBeforeTax' attribute value. ''AmountBeforeTax'' returns the total amount not including any associated tax (e.g., sales tax, VAT, GST).
                 * 
                 * @param amountBeforeTax
                 */
                public void setAmountBeforeTax(BigDecimal amountBeforeTax) {
                    this.amountBeforeTax = amountBeforeTax;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'Changed' attribute value. ''Changed'' denotes that total amount is changed since shopping.
                 * 
                 * @return value
                 */
                public Boolean getChanged() {
                    return changed;
                }

                /** 
                 * Set the 'Changed' attribute value. ''Changed'' denotes that total amount is changed since shopping.
                 * 
                 * @param changed
                 */
                public void setChanged(Boolean changed) {
                    this.changed = changed;
                }

                /** 
                 * Get the 'BalanceAmount' attribute value. ''BalanceAmount'' returns amount that needs to be paid after cancellation.
                 * 
                 * @return value
                 */
                public BigDecimal getBalanceAmount() {
                    return balanceAmount;
                }

                /** 
                 * Set the 'BalanceAmount' attribute value. ''BalanceAmount'' returns amount that needs to be paid after cancellation.
                 * 
                 * @param balanceAmount
                 */
                public void setBalanceAmount(BigDecimal balanceAmount) {
                    this.balanceAmount = balanceAmount;
                }

                /** 
                 * Get the 'SupplierChangedAmount' attribute value. ''SupplierChangedAmount'' returns the amount changed by the supplier.
                 * 
                 * @return value
                 */
                public BigDecimal getSupplierChangedAmount() {
                    return supplierChangedAmount;
                }

                /** 
                 * Set the 'SupplierChangedAmount' attribute value. ''SupplierChangedAmount'' returns the amount changed by the supplier.
                 * 
                 * @param supplierChangedAmount
                 */
                public void setSupplierChangedAmount(
                        BigDecimal supplierChangedAmount) {
                    this.supplierChangedAmount = supplierChangedAmount;
                }
            }
            /** 
             * List of additional Detail.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalDetails" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AdditionalDetail" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class AdditionalDetail -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AdditionalDetails implements Serializable
            {
                private List<AdditionalDetail> additionalDetailList = new ArrayList<AdditionalDetail>();

                /** 
                 * Get the list of 'AdditionalDetail' element items.
                 * 
                 * @return list
                 */
                public List<AdditionalDetail> getAdditionalDetailList() {
                    return additionalDetailList;
                }

                /** 
                 * Set the list of 'AdditionalDetail' element items.
                 * 
                 * @param list
                 */
                public void setAdditionalDetailList(List<AdditionalDetail> list) {
                    additionalDetailList = list;
                }
                /** 
                 * ''AdditionalDetail'' is used for free text relating to check-in/check-out, surcharge and other details.
                                                                        Uses OTA ADT Table in Code Attribute.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalDetail" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:int" name="Code"/>
                 *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:int" name="GuestCount"/>
                 *     &lt;xs:attribute type="xs:date" name="StartDate"/>
                 *     &lt;xs:attribute type="xs:date" name="EndDate"/>
                 *     &lt;xs:attribute type="xs:int" name="NumberOfNights"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AdditionalDetail implements Serializable
                {
                    private List<String> textList = new ArrayList<String>();
                    private Integer code;
                    private BigDecimal amount;
                    private String currencyCode;
                    private Integer guestCount;
                    private java.sql.Date startDate;
                    private java.sql.Date endDate;
                    private Integer numberOfNights;

                    /** 
                     * Get the list of 'Text' element items. ''Text'' is used for free text relating to check-in/check-out, surcharge and other details.
                                                                                      Uses OTA ADT Table in Code Attribute.
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items. ''Text'' is used for free text relating to check-in/check-out, surcharge and other details.
                                                                                      Uses OTA ADT Table in Code Attribute.
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }

                    /** 
                     * Get the 'Code' attribute value. ''Code'' defines the type of information being returned (e.g., rate description, property description, room information).
                                                                                  Refer to OpenTravel Code List Additional Detail Type (ADT).
                     * 
                     * @return value
                     */
                    public Integer getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. ''Code'' defines the type of information being returned (e.g., rate description, property description, room information).
                                                                                  Refer to OpenTravel Code List Additional Detail Type (ADT).
                     * 
                     * @param code
                     */
                    public void setCode(Integer code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(BigDecimal amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'GuestCount' attribute value. ''GuestCount'' returns a positive integer indicating number of guest for whom additional detail is applicable.
                     * 
                     * @return value
                     */
                    public Integer getGuestCount() {
                        return guestCount;
                    }

                    /** 
                     * Set the 'GuestCount' attribute value. ''GuestCount'' returns a positive integer indicating number of guest for whom additional detail is applicable.
                     * 
                     * @param guestCount
                     */
                    public void setGuestCount(Integer guestCount) {
                        this.guestCount = guestCount;
                    }

                    /** 
                     * Get the 'StartDate' attribute value. ''StartDate'' returns the start date for the additional detail.
                     * 
                     * @return value
                     */
                    public java.sql.Date getStartDate() {
                        return startDate;
                    }

                    /** 
                     * Set the 'StartDate' attribute value. ''StartDate'' returns the start date for the additional detail.
                     * 
                     * @param startDate
                     */
                    public void setStartDate(java.sql.Date startDate) {
                        this.startDate = startDate;
                    }

                    /** 
                     * Get the 'EndDate' attribute value. ''EndDate'' returns the end date for the additional detail.
                     * 
                     * @return value
                     */
                    public java.sql.Date getEndDate() {
                        return endDate;
                    }

                    /** 
                     * Set the 'EndDate' attribute value. ''EndDate'' returns the end date for the additional detail.
                     * 
                     * @param endDate
                     */
                    public void setEndDate(java.sql.Date endDate) {
                        this.endDate = endDate;
                    }

                    /** 
                     * Get the 'NumberOfNights' attribute value. ''NumberOfNights'' returns the number of nights included for the additional detail.
                     * 
                     * @return value
                     */
                    public Integer getNumberOfNights() {
                        return numberOfNights;
                    }

                    /** 
                     * Set the 'NumberOfNights' attribute value. ''NumberOfNights'' returns the number of nights included for the additional detail.
                     * 
                     * @param numberOfNights
                     */
                    public void setNumberOfNights(Integer numberOfNights) {
                        this.numberOfNights = numberOfNights;
                    }
                }
            }
            /** 
             * ''Fees'' returns a list of hotel fees.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fees" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Fee" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Fee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fees implements Serializable
            {
                private List<Fee> feeList = new ArrayList<Fee>();
                private BigDecimal amount;
                private String currencyCode;

                /** 
                 * Get the list of 'Fee' element items.
                 * 
                 * @return list
                 */
                public List<Fee> getFeeList() {
                    return feeList;
                }

                /** 
                 * Set the list of 'Fee' element items.
                 * 
                 * @param list
                 */
                public void setFeeList(List<Fee> list) {
                    feeList = list;
                }

                /** 
                 * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FeeDescription" minOccurs="0">
                 *         &lt;!-- Reference to inner class FeeDescription -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:int" name="Code"/>
                 *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" name="ApplyAs"/>
                 *     &lt;xs:attribute type="xs:string" name="BasisType"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Fee implements Serializable
                {
                    private FeeDescription feeDescription;
                    private Integer code;
                    private BigDecimal amount;
                    private String currencyCode;
                    private String applyAs;
                    private String basisType;

                    /** 
                     * Get the 'FeeDescription' element value.
                     * 
                     * @return value
                     */
                    public FeeDescription getFeeDescription() {
                        return feeDescription;
                    }

                    /** 
                     * Set the 'FeeDescription' element value.
                     * 
                     * @param feeDescription
                     */
                    public void setFeeDescription(FeeDescription feeDescription) {
                        this.feeDescription = feeDescription;
                    }

                    /** 
                     * Get the 'Code' attribute value. ''Code'' returns the code identifying the fee (e.g.,agency fee, municipality fee).
                                                                                  Refer to OpenTravel Code List Fee Tax Type (FTT).
                     * 
                     * @return value
                     */
                    public Integer getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. ''Code'' returns the code identifying the fee (e.g.,agency fee, municipality fee).
                                                                                  Refer to OpenTravel Code List Fee Tax Type (FTT).
                     * 
                     * @param code
                     */
                    public void setCode(Integer code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(BigDecimal amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'ApplyAs' attribute value. ''ApplyAs'' is returned in order to support HotelFee breakdown.
                                                                                  Values - Person, Room, Accommodation, House, Apartment, Adult.
                     * 
                     * @return value
                     */
                    public String getApplyAs() {
                        return applyAs;
                    }

                    /** 
                     * Set the 'ApplyAs' attribute value. ''ApplyAs'' is returned in order to support HotelFee breakdown.
                                                                                  Values - Person, Room, Accommodation, House, Apartment, Adult.
                     * 
                     * @param applyAs
                     */
                    public void setApplyAs(String applyAs) {
                        this.applyAs = applyAs;
                    }

                    /** 
                     * Get the 'BasisType' attribute value. ''BasisType'' is returned in order to support HotelFee breakdown.
                                                                                  Values - Night, Day, Stay, Week.
                     * 
                     * @return value
                     */
                    public String getBasisType() {
                        return basisType;
                    }

                    /** 
                     * Set the 'BasisType' attribute value. ''BasisType'' is returned in order to support HotelFee breakdown.
                                                                                  Values - Night, Day, Stay, Week.
                     * 
                     * @param basisType
                     */
                    public void setBasisType(String basisType) {
                        this.basisType = basisType;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeDescription" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FeeDescription implements Serializable
                    {
                        private String text;

                        /** 
                         * Get the 'Text' element value. ''Text'' returns the hotel fee description text.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value. ''Text'' returns the hotel fee description text.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Tax -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" name="Code"/>
             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private List<Tax> taxList = new ArrayList<Tax>();
                private Integer code;
                private BigDecimal amount;
                private String currencyCode;

                /** 
                 * Get the list of 'Tax' element items.
                 * 
                 * @return list
                 */
                public List<Tax> getTaxList() {
                    return taxList;
                }

                /** 
                 * Set the list of 'Tax' element items.
                 * 
                 * @param list
                 */
                public void setTaxList(List<Tax> list) {
                    taxList = list;
                }

                /** 
                 * Get the 'Code' attribute value. ''Code'' returns the code identifying the tax.
                                                                    Refer to OpenTravel Code List Fee Tax Type (FTT).
                 * 
                 * @return value
                 */
                public Integer getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. ''Code'' returns the code identifying the tax.
                                                                    Refer to OpenTravel Code List Fee Tax Type (FTT).
                 * 
                 * @param code
                 */
                public void setCode(Integer code) {
                    this.code = code;
                }

                /** 
                 * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="TaxDescription">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element type="xs:string" name="Text"/>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Code"/>
                 *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Tax implements Serializable
                {
                    private String taxDescription;
                    private String code;
                    private BigDecimal amount;
                    private String currencyCode;

                    /** 
                     * Get the 'Text' element value. ''Text'' returns the tax description text.
                     * 
                     * @return value
                     */
                    public String getTaxDescription() {
                        return taxDescription;
                    }

                    /** 
                     * Set the 'Text' element value. ''Text'' returns the tax description text.
                     * 
                     * @param taxDescription
                     */
                    public void setTaxDescription(String taxDescription) {
                        this.taxDescription = taxDescription;
                    }

                    /** 
                     * Get the 'Code' attribute value. ''Code'' returns the code identifying the tax.
                                                                                  Refer to OpenTravel Code List Fee Tax Type (FTT).
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. ''Code'' returns the code identifying the tax.
                                                                                  Refer to OpenTravel Code List Fee Tax Type (FTT).
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(BigDecimal amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }
                }
            }
            /** 
             * ''CancelPenalties'' returns a collection of cancellation penalties.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPenalties" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CancelPenalty" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class CancelPenalty -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CancelPenalties implements Serializable
            {
                private List<CancelPenalty> cancelPenaltyList = new ArrayList<CancelPenalty>();

                /** 
                 * Get the list of 'CancelPenalty' element items.
                 * 
                 * @return list
                 */
                public List<CancelPenalty> getCancelPenaltyList() {
                    return cancelPenaltyList;
                }

                /** 
                 * Set the list of 'CancelPenalty' element items.
                 * 
                 * @param list
                 */
                public void setCancelPenaltyList(List<CancelPenalty> list) {
                    cancelPenaltyList = list;
                }
                /** 
                 * ''CancelPenalty'' provides details about penalties that will be applied when products are canceled.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPenalty" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Deadline" minOccurs="0">
                 *         &lt;!-- Reference to inner class Deadline -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="AmountPercent" minOccurs="0">
                 *         &lt;!-- Reference to inner class AmountPercent -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PenaltyDescription" minOccurs="0">
                 *         &lt;!-- Reference to inner class PenaltyDescription -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" name="Refundable"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CancelPenalty implements Serializable
                {
                    private Deadline deadline;
                    private AmountPercent amountPercent;
                    private PenaltyDescription penaltyDescription;
                    private Boolean refundable;

                    /** 
                     * Get the 'Deadline' element value.
                     * 
                     * @return value
                     */
                    public Deadline getDeadline() {
                        return deadline;
                    }

                    /** 
                     * Set the 'Deadline' element value.
                     * 
                     * @param deadline
                     */
                    public void setDeadline(Deadline deadline) {
                        this.deadline = deadline;
                    }

                    /** 
                     * Get the 'AmountPercent' element value.
                     * 
                     * @return value
                     */
                    public AmountPercent getAmountPercent() {
                        return amountPercent;
                    }

                    /** 
                     * Set the 'AmountPercent' element value.
                     * 
                     * @param amountPercent
                     */
                    public void setAmountPercent(AmountPercent amountPercent) {
                        this.amountPercent = amountPercent;
                    }

                    /** 
                     * Get the 'PenaltyDescription' element value.
                     * 
                     * @return value
                     */
                    public PenaltyDescription getPenaltyDescription() {
                        return penaltyDescription;
                    }

                    /** 
                     * Set the 'PenaltyDescription' element value.
                     * 
                     * @param penaltyDescription
                     */
                    public void setPenaltyDescription(
                            PenaltyDescription penaltyDescription) {
                        this.penaltyDescription = penaltyDescription;
                    }

                    /** 
                     * Get the 'Refundable' attribute value. ''Refundable'' specifies whether amount is refundable when booking is canceled.
                     * 
                     * @return value
                     */
                    public Boolean getRefundable() {
                        return refundable;
                    }

                    /** 
                     * Set the 'Refundable' attribute value. ''Refundable'' specifies whether amount is refundable when booking is canceled.
                     * 
                     * @param refundable
                     */
                    public void setRefundable(Boolean refundable) {
                        this.refundable = refundable;
                    }
                    /** 
                     * ''Deadline'' returns cancellation deadline, absolute or relative.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deadline" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:dateTime" name="AbsoluteDeadline"/>
                     *     &lt;xs:attribute type="xs:string" name="OffsetDropTime"/>
                     *     &lt;xs:attribute type="xs:string" name="OffsetTimeUnit"/>
                     *     &lt;xs:attribute type="xs:string" name="OffsetUnitMultiplier"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Deadline implements Serializable
                    {
                        private Date absoluteDeadline;
                        private String offsetDropTime;
                        private String offsetTimeUnit;
                        private String offsetUnitMultiplier;

                        /** 
                         * Get the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' defines the absolute deadline.
                                                                                                Either this or the offset attributes may be used.
                         * 
                         * @return value
                         */
                        public Date getAbsoluteDeadline() {
                            return absoluteDeadline;
                        }

                        /** 
                         * Set the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' defines the absolute deadline.
                                                                                                Either this or the offset attributes may be used.
                         * 
                         * @param absoluteDeadline
                         */
                        public void setAbsoluteDeadline(Date absoluteDeadline) {
                            this.absoluteDeadline = absoluteDeadline;
                        }

                        /** 
                         * Get the 'OffsetDropTime' attribute value. ''OffsetDropTime'' returns an enumerated type indicating when the deadline drop time goes into effect (BeforeArrival, AfterBooking, AfterConfirmation, AfterArrival, AfterDeparture).
                         * 
                         * @return value
                         */
                        public String getOffsetDropTime() {
                            return offsetDropTime;
                        }

                        /** 
                         * Set the 'OffsetDropTime' attribute value. ''OffsetDropTime'' returns an enumerated type indicating when the deadline drop time goes into effect (BeforeArrival, AfterBooking, AfterConfirmation, AfterArrival, AfterDeparture).
                         * 
                         * @param offsetDropTime
                         */
                        public void setOffsetDropTime(String offsetDropTime) {
                            this.offsetDropTime = offsetDropTime;
                        }

                        /** 
                         * Get the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                         * 
                         * @return value
                         */
                        public String getOffsetTimeUnit() {
                            return offsetTimeUnit;
                        }

                        /** 
                         * Set the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                         * 
                         * @param offsetTimeUnit
                         */
                        public void setOffsetTimeUnit(String offsetTimeUnit) {
                            this.offsetTimeUnit = offsetTimeUnit;
                        }

                        /** 
                         * Get the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of ''DeadlineTimeUnit''.
                         * 
                         * @return value
                         */
                        public String getOffsetUnitMultiplier() {
                            return offsetUnitMultiplier;
                        }

                        /** 
                         * Set the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of ''DeadlineTimeUnit''.
                         * 
                         * @param offsetUnitMultiplier
                         */
                        public void setOffsetUnitMultiplier(
                                String offsetUnitMultiplier) {
                            this.offsetUnitMultiplier = offsetUnitMultiplier;
                        }
                    }
                    /** 
                     * ''AmountPercent'' returns the cancellation fee expressed as a fixed amount, or percentage of room nights.
                                                                                      Defines the percentage basis for calculating the fee amount or the amount.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AmountPercent" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" name="TaxInclusive"/>
                     *     &lt;xs:attribute type="xs:boolean" name="FeesInclusive"/>
                     *     &lt;xs:attribute type="xs:int" name="NmbrOfNights"/>
                     *     &lt;xs:attribute type="xs:string" name="BasisType"/>
                     *     &lt;xs:attribute type="xs:decimal" name="Percent"/>
                     *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" name="ApplyAs"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AmountPercent implements Serializable
                    {
                        private Boolean taxInclusive;
                        private Boolean feesInclusive;
                        private Integer nmbrOfNights;
                        private String basisType;
                        private BigDecimal percent;
                        private BigDecimal amount;
                        private String currencyCode;
                        private String applyAs;

                        /** 
                         * Get the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                         * 
                         * @return value
                         */
                        public Boolean getTaxInclusive() {
                            return taxInclusive;
                        }

                        /** 
                         * Set the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                         * 
                         * @param taxInclusive
                         */
                        public void setTaxInclusive(Boolean taxInclusive) {
                            this.taxInclusive = taxInclusive;
                        }

                        /** 
                         * Get the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating cancel penalties.
                         * 
                         * @return value
                         */
                        public Boolean getFeesInclusive() {
                            return feesInclusive;
                        }

                        /** 
                         * Set the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating cancel penalties.
                         * 
                         * @param feesInclusive
                         */
                        public void setFeesInclusive(Boolean feesInclusive) {
                            this.feesInclusive = feesInclusive;
                        }

                        /** 
                         * Get the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the penalty amount.
                         * 
                         * @return value
                         */
                        public Integer getNmbrOfNights() {
                            return nmbrOfNights;
                        }

                        /** 
                         * Set the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the penalty amount.
                         * 
                         * @param nmbrOfNights
                         */
                        public void setNmbrOfNights(Integer nmbrOfNights) {
                            this.nmbrOfNights = nmbrOfNights;
                        }

                        /** 
                         * Get the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the cancellation penalty is calculated.
                         * 
                         * @return value
                         */
                        public String getBasisType() {
                            return basisType;
                        }

                        /** 
                         * Set the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the cancellation penalty is calculated.
                         * 
                         * @param basisType
                         */
                        public void setBasisType(String basisType) {
                            this.basisType = basisType;
                        }

                        /** 
                         * Get the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                         * 
                         * @return value
                         */
                        public BigDecimal getPercent() {
                            return percent;
                        }

                        /** 
                         * Set the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                         * 
                         * @param percent
                         */
                        public void setPercent(BigDecimal percent) {
                            this.percent = percent;
                        }

                        /** 
                         * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                         * 
                         * @param amount
                         */
                        public void setAmount(BigDecimal amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'ApplyAs' attribute value. ''ApplyAs'' returns how the amount that needs to be applied with respect to the stay.
                         * 
                         * @return value
                         */
                        public String getApplyAs() {
                            return applyAs;
                        }

                        /** 
                         * Set the 'ApplyAs' attribute value. ''ApplyAs'' returns how the amount that needs to be applied with respect to the stay.
                         * 
                         * @param applyAs
                         */
                        public void setApplyAs(String applyAs) {
                            this.applyAs = applyAs;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyDescription" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PenaltyDescription implements
                        Serializable
                    {
                        private String text;

                        /** 
                         * Get the 'Text' element value. ''Text'' provides description of penalties applicable.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value. ''Text'' provides description of penalties applicable.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }
                    }
                }
            }
            /** 
             * ''Guarantee'' returns guarantee information that applies to the rate plan.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guarantee" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="GuaranteesAccepted" minOccurs="0">
             *         &lt;!-- Reference to inner class GuaranteesAccepted -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Deadline" minOccurs="0">
             *         &lt;!-- Reference to inner class Deadline -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AmountPercent" minOccurs="0">
             *         &lt;!-- Reference to inner class AmountPercent -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="GuaranteeDescription" minOccurs="0">
             *         &lt;!-- Reference to inner class GuaranteeDescription -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="GuaranteeType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Guarantee implements Serializable
            {
                private GuaranteesAccepted guaranteesAccepted;
                private Deadline deadline;
                private AmountPercent amountPercent;
                private GuaranteeDescription guaranteeDescription;
                private String guaranteeType;

                /** 
                 * Get the 'GuaranteesAccepted' element value.
                 * 
                 * @return value
                 */
                public GuaranteesAccepted getGuaranteesAccepted() {
                    return guaranteesAccepted;
                }

                /** 
                 * Set the 'GuaranteesAccepted' element value.
                 * 
                 * @param guaranteesAccepted
                 */
                public void setGuaranteesAccepted(
                        GuaranteesAccepted guaranteesAccepted) {
                    this.guaranteesAccepted = guaranteesAccepted;
                }

                /** 
                 * Get the 'Deadline' element value.
                 * 
                 * @return value
                 */
                public Deadline getDeadline() {
                    return deadline;
                }

                /** 
                 * Set the 'Deadline' element value.
                 * 
                 * @param deadline
                 */
                public void setDeadline(Deadline deadline) {
                    this.deadline = deadline;
                }

                /** 
                 * Get the 'AmountPercent' element value.
                 * 
                 * @return value
                 */
                public AmountPercent getAmountPercent() {
                    return amountPercent;
                }

                /** 
                 * Set the 'AmountPercent' element value.
                 * 
                 * @param amountPercent
                 */
                public void setAmountPercent(AmountPercent amountPercent) {
                    this.amountPercent = amountPercent;
                }

                /** 
                 * Get the 'GuaranteeDescription' element value.
                 * 
                 * @return value
                 */
                public GuaranteeDescription getGuaranteeDescription() {
                    return guaranteeDescription;
                }

                /** 
                 * Set the 'GuaranteeDescription' element value.
                 * 
                 * @param guaranteeDescription
                 */
                public void setGuaranteeDescription(
                        GuaranteeDescription guaranteeDescription) {
                    this.guaranteeDescription = guaranteeDescription;
                }

                /** 
                 * Get the 'GuaranteeType' attribute value. ''GuaranteeType'' returns a enumerated type defining the guarantee to be applied to this reservation.
                 * 
                 * @return value
                 */
                public String getGuaranteeType() {
                    return guaranteeType;
                }

                /** 
                 * Set the 'GuaranteeType' attribute value. ''GuaranteeType'' returns a enumerated type defining the guarantee to be applied to this reservation.
                 * 
                 * @param guaranteeType
                 */
                public void setGuaranteeType(String guaranteeType) {
                    this.guaranteeType = guaranteeType;
                }
                /** 
                 * ''GuaranteesAccepted'' returns a collection of accepted guarantees.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteesAccepted" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="GuaranteeAccepted" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class GuaranteeAccepted -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GuaranteesAccepted implements Serializable
                {
                    private List<GuaranteeAccepted> guaranteeAcceptedList = new ArrayList<GuaranteeAccepted>();

                    /** 
                     * Get the list of 'GuaranteeAccepted' element items.
                     * 
                     * @return list
                     */
                    public List<GuaranteeAccepted> getGuaranteeAcceptedList() {
                        return guaranteeAcceptedList;
                    }

                    /** 
                     * Set the list of 'GuaranteeAccepted' element items.
                     * 
                     * @param list
                     */
                    public void setGuaranteeAcceptedList(
                            List<GuaranteeAccepted> list) {
                        guaranteeAcceptedList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteeAccepted" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCards" minOccurs="0">
                     *         &lt;!-- Reference to inner class PaymentCards -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:int" name="GuaranteeTypeCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class GuaranteeAccepted implements
                        Serializable
                    {
                        private PaymentCards paymentCards;
                        private Integer guaranteeTypeCode;

                        /** 
                         * Get the 'PaymentCards' element value.
                         * 
                         * @return value
                         */
                        public PaymentCards getPaymentCards() {
                            return paymentCards;
                        }

                        /** 
                         * Set the 'PaymentCards' element value.
                         * 
                         * @param paymentCards
                         */
                        public void setPaymentCards(PaymentCards paymentCards) {
                            this.paymentCards = paymentCards;
                        }

                        /** 
                         * Get the 'GuaranteeTypeCode' attribute value. ''GuaranteeTypeCode'' specifies the method of guarantee.
                                                                                                Refer to OpenTravel Code List Payment Type (PMT).
                                                                                                For PaymentCard type, PaymentCard element should be provided.
                         * 
                         * @return value
                         */
                        public Integer getGuaranteeTypeCode() {
                            return guaranteeTypeCode;
                        }

                        /** 
                         * Set the 'GuaranteeTypeCode' attribute value. ''GuaranteeTypeCode'' specifies the method of guarantee.
                                                                                                Refer to OpenTravel Code List Payment Type (PMT).
                                                                                                For PaymentCard type, PaymentCard element should be provided.
                         * 
                         * @param guaranteeTypeCode
                         */
                        public void setGuaranteeTypeCode(
                                Integer guaranteeTypeCode) {
                            this.guaranteeTypeCode = guaranteeTypeCode;
                        }
                        /** 
                         * ''PaymentCards'' specifies the cards, like credit card or debit card which were used to pay.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCards" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PaymentCard" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class PaymentCard -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PaymentCards implements
                            Serializable
                        {
                            private List<PaymentCard> paymentCardList = new ArrayList<PaymentCard>();

                            /** 
                             * Get the list of 'PaymentCard' element items.
                             * 
                             * @return list
                             */
                            public List<PaymentCard> getPaymentCardList() {
                                return paymentCardList;
                            }

                            /** 
                             * Set the list of 'PaymentCard' element items.
                             * 
                             * @param list
                             */
                            public void setPaymentCardList(
                                    List<PaymentCard> list) {
                                paymentCardList = list;
                            }
                            /** 
                             * ''PaymentCard'' specifies the card name.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:simpleContent>
                             *       &lt;xs:extension base="xs:string">
                             *         &lt;xs:attribute type="xs:string" use="required" name="CardCode"/>
                             *       &lt;/xs:extension>
                             *     &lt;/xs:simpleContent>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PaymentCard implements
                                Serializable
                            {
                                private String string;
                                private String cardCode;

                                /** 
                                 * Get the extension value.
                                 * 
                                 * @return value
                                 */
                                public String getString() {
                                    return string;
                                }

                                /** 
                                 * Set the extension value.
                                 * 
                                 * @param string
                                 */
                                public void setString(String string) {
                                    this.string = string;
                                }

                                /** 
                                 * Get the 'CardCode' attribute value. ''CardCode'' returns the code identifying the card type (AX, BC, BL, CB, DN etc).
                                 * 
                                 * @return value
                                 */
                                public String getCardCode() {
                                    return cardCode;
                                }

                                /** 
                                 * Set the 'CardCode' attribute value. ''CardCode'' returns the code identifying the card type (AX, BC, BL, CB, DN etc).
                                 * 
                                 * @param cardCode
                                 */
                                public void setCardCode(String cardCode) {
                                    this.cardCode = cardCode;
                                }
                            }
                        }
                    }
                }
                /** 
                 * ''Deadline'' returns guarantee deadline, absolute or relative.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deadline" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="AbsoluteDeadline"/>
                 *     &lt;xs:attribute type="xs:string" name="OffsetTimeUnit"/>
                 *     &lt;xs:attribute type="xs:string" name="OffsetUnitMultiplier"/>
                 *     &lt;xs:attribute type="xs:string" name="OffsetDropTime"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Deadline implements Serializable
                {
                    private String absoluteDeadline;
                    private String offsetTimeUnit;
                    private String offsetUnitMultiplier;
                    private String offsetDropTime;

                    /** 
                     * Get the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' defines the absolute deadline.
                                                                                  Either this or the offset attributes may be used.
                     * 
                     * @return value
                     */
                    public String getAbsoluteDeadline() {
                        return absoluteDeadline;
                    }

                    /** 
                     * Set the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' defines the absolute deadline.
                                                                                  Either this or the offset attributes may be used.
                     * 
                     * @param absoluteDeadline
                     */
                    public void setAbsoluteDeadline(String absoluteDeadline) {
                        this.absoluteDeadline = absoluteDeadline;
                    }

                    /** 
                     * Get the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                     * 
                     * @return value
                     */
                    public String getOffsetTimeUnit() {
                        return offsetTimeUnit;
                    }

                    /** 
                     * Set the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                     * 
                     * @param offsetTimeUnit
                     */
                    public void setOffsetTimeUnit(String offsetTimeUnit) {
                        this.offsetTimeUnit = offsetTimeUnit;
                    }

                    /** 
                     * Get the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of ''OffsetTimeUnit''.
                     * 
                     * @return value
                     */
                    public String getOffsetUnitMultiplier() {
                        return offsetUnitMultiplier;
                    }

                    /** 
                     * Set the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of ''OffsetTimeUnit''.
                     * 
                     * @param offsetUnitMultiplier
                     */
                    public void setOffsetUnitMultiplier(
                            String offsetUnitMultiplier) {
                        this.offsetUnitMultiplier = offsetUnitMultiplier;
                    }

                    /** 
                     * Get the 'OffsetDropTime' attribute value. ''OffsetDropTime'' returns an enumerated type indicating when the deadline drop time goes into effect (BeforeArrival, AfterBooking,   AfterConfirmation, AfterArrival, AfterDeparture).
                     * 
                     * @return value
                     */
                    public String getOffsetDropTime() {
                        return offsetDropTime;
                    }

                    /** 
                     * Set the 'OffsetDropTime' attribute value. ''OffsetDropTime'' returns an enumerated type indicating when the deadline drop time goes into effect (BeforeArrival, AfterBooking,   AfterConfirmation, AfterArrival, AfterDeparture).
                     * 
                     * @param offsetDropTime
                     */
                    public void setOffsetDropTime(String offsetDropTime) {
                        this.offsetDropTime = offsetDropTime;
                    }
                }
                /** 
                 * ''AmountPercent'' returns guarantee expressed as a fixed amount, or percentage of room nights.
                                                                        Defines the percentage basis for calculating the guarantee amount.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AmountPercent" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="TaxInclusive"/>
                 *     &lt;xs:attribute type="xs:boolean" name="FeesInclusive"/>
                 *     &lt;xs:attribute type="xs:int" name="NmbrOfNights"/>
                 *     &lt;xs:attribute type="xs:string" name="BasisType"/>
                 *     &lt;xs:attribute type="xs:decimal" name="Percent"/>
                 *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" name="ApplyAs"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AmountPercent implements Serializable
                {
                    private Boolean taxInclusive;
                    private Boolean feesInclusive;
                    private Integer nmbrOfNights;
                    private String basisType;
                    private BigDecimal percent;
                    private BigDecimal amount;
                    private String currencyCode;
                    private String applyAs;

                    /** 
                     * Get the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                     * 
                     * @return value
                     */
                    public Boolean getTaxInclusive() {
                        return taxInclusive;
                    }

                    /** 
                     * Set the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                     * 
                     * @param taxInclusive
                     */
                    public void setTaxInclusive(Boolean taxInclusive) {
                        this.taxInclusive = taxInclusive;
                    }

                    /** 
                     * Get the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating guarantee amount.
                     * 
                     * @return value
                     */
                    public Boolean getFeesInclusive() {
                        return feesInclusive;
                    }

                    /** 
                     * Set the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating guarantee amount.
                     * 
                     * @param feesInclusive
                     */
                    public void setFeesInclusive(Boolean feesInclusive) {
                        this.feesInclusive = feesInclusive;
                    }

                    /** 
                     * Get the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the guarantee amount.
                     * 
                     * @return value
                     */
                    public Integer getNmbrOfNights() {
                        return nmbrOfNights;
                    }

                    /** 
                     * Set the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the guarantee amount.
                     * 
                     * @param nmbrOfNights
                     */
                    public void setNmbrOfNights(Integer nmbrOfNights) {
                        this.nmbrOfNights = nmbrOfNights;
                    }

                    /** 
                     * Get the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the guarantee is calculated.
                     * 
                     * @return value
                     */
                    public String getBasisType() {
                        return basisType;
                    }

                    /** 
                     * Set the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the guarantee is calculated.
                     * 
                     * @param basisType
                     */
                    public void setBasisType(String basisType) {
                        this.basisType = basisType;
                    }

                    /** 
                     * Get the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                     * 
                     * @return value
                     */
                    public BigDecimal getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                     * 
                     * @param percent
                     */
                    public void setPercent(BigDecimal percent) {
                        this.percent = percent;
                    }

                    /** 
                     * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(BigDecimal amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'ApplyAs' attribute value. ''ApplyAs'' returns how the amount that needs to be applied with respect to the stay.
                     * 
                     * @return value
                     */
                    public String getApplyAs() {
                        return applyAs;
                    }

                    /** 
                     * Set the 'ApplyAs' attribute value. ''ApplyAs'' returns how the amount that needs to be applied with respect to the stay.
                     * 
                     * @param applyAs
                     */
                    public void setApplyAs(String applyAs) {
                        this.applyAs = applyAs;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteeDescription" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GuaranteeDescription implements
                    Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value. ''Text'' provides description of the guarantee.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. ''Text'' provides description of the guarantee.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
            }
            /** 
             * ''Commission'' returns commission information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CommissionDescription" minOccurs="0">
             *         &lt;!-- Reference to inner class CommissionDescription -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" name="CommissionIndicator"/>
             *     &lt;xs:attribute type="xs:decimal" name="Percent"/>
             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:string" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private CommissionDescription commissionDescription;
                private Boolean commissionIndicator;
                private BigDecimal percent;
                private BigDecimal amount;
                private String currencyCode;
                private String type;

                /** 
                 * Get the 'CommissionDescription' element value.
                 * 
                 * @return value
                 */
                public CommissionDescription getCommissionDescription() {
                    return commissionDescription;
                }

                /** 
                 * Set the 'CommissionDescription' element value.
                 * 
                 * @param commissionDescription
                 */
                public void setCommissionDescription(
                        CommissionDescription commissionDescription) {
                    this.commissionDescription = commissionDescription;
                }

                /** 
                 * Get the 'CommissionIndicator' attribute value. ''CommissionIndicator'' returns the commission indicator.
                 * 
                 * @return value
                 */
                public Boolean getCommissionIndicator() {
                    return commissionIndicator;
                }

                /** 
                 * Set the 'CommissionIndicator' attribute value. ''CommissionIndicator'' returns the commission indicator.
                 * 
                 * @param commissionIndicator
                 */
                public void setCommissionIndicator(Boolean commissionIndicator) {
                    this.commissionIndicator = commissionIndicator;
                }

                /** 
                 * Get the 'Percent' attribute value. ''Percent'' returns the percent applied to the commissionable amount to determine the commission payable amount.
                 * 
                 * @return value
                 */
                public BigDecimal getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' attribute value. ''Percent'' returns the percent applied to the commissionable amount to determine the commission payable amount.
                 * 
                 * @param percent
                 */
                public void setPercent(BigDecimal percent) {
                    this.percent = percent;
                }

                /** 
                 * Get the 'Amount' attribute value. ''Amount'' returns the commissionable amount.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. ''Amount'' returns the commissionable amount.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'Type' attribute value. ''Type'' returns commission type.
                                                                    Type can be `None` or `Variable`.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. ''Type'' returns commission type.
                                                                    Type can be `None` or `Variable`.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionDescription" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CommissionDescription implements
                    Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value. ''Text'' returns commission description text.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. ''Text'' returns commission description text.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
            }
            /** 
             * ''Discounts'' returns a list of discounts.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discounts" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Discount" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Discount -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Discounts implements Serializable
            {
                private List<Discount> discountList = new ArrayList<Discount>();

                /** 
                 * Get the list of 'Discount' element items.
                 * 
                 * @return list
                 */
                public List<Discount> getDiscountList() {
                    return discountList;
                }

                /** 
                 * Set the list of 'Discount' element items.
                 * 
                 * @param list
                 */
                public void setDiscountList(List<Discount> list) {
                    discountList = list;
                }
                /** 
                 * ''Discount'' describes a discount in a room rate.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="Code"/>
                 *     &lt;xs:attribute type="xs:string" name="Name"/>
                 *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Discount implements Serializable
                {
                    private String code;
                    private String name;
                    private BigDecimal amount;
                    private String currencyCode;

                    /** 
                     * Get the 'Code' attribute value. ''Code'' returns the discount code.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. ''Code'' returns the discount code.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Name' attribute value. ''Name'' returns the discount name.
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value. ''Name'' returns the discount name.
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }

                    /** 
                     * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @return value
                     */
                    public BigDecimal getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(BigDecimal amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }
                }
            }
        }
        /** 
         * ''Rooms'' returns a list of rooms.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rooms" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Room" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Room -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:int" name="NumberOfRooms"/>
         *     &lt;xs:attribute type="xs:int" name="GuestCount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rooms implements Serializable
        {
            private List<Room> roomList = new ArrayList<Room>();
            private Integer numberOfRooms;
            private Integer guestCount;

            /** 
             * Get the list of 'Room' element items.
             * 
             * @return list
             */
            public List<Room> getRoomList() {
                return roomList;
            }

            /** 
             * Set the list of 'Room' element items.
             * 
             * @param list
             */
            public void setRoomList(List<Room> list) {
                roomList = list;
            }

            /** 
             * Get the 'NumberOfRooms' attribute value. ''NumberOfRooms'' returns the number of rooms.
             * 
             * @return value
             */
            public Integer getNumberOfRooms() {
                return numberOfRooms;
            }

            /** 
             * Set the 'NumberOfRooms' attribute value. ''NumberOfRooms'' returns the number of rooms.
             * 
             * @param numberOfRooms
             */
            public void setNumberOfRooms(Integer numberOfRooms) {
                this.numberOfRooms = numberOfRooms;
            }

            /** 
             * Get the 'GuestCount' attribute value. ''GuestCount'' returns the count of guests.
             * 
             * @return value
             */
            public Integer getGuestCount() {
                return guestCount;
            }

            /** 
             * Set the 'GuestCount' attribute value. ''GuestCount'' returns the count of guests.
             * 
             * @param guestCount
             */
            public void setGuestCount(Integer guestCount) {
                this.guestCount = guestCount;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Room" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Guests" minOccurs="0">
             *         &lt;!-- Reference to inner class Guests -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="RoomDescription" minOccurs="0">
             *         &lt;!-- Reference to inner class RoomDescription -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="RoomExtras" minOccurs="0">
             *         &lt;!-- Reference to inner class RoomExtras -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ConfirmationCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CancellationCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="BookingStatus" minOccurs="0"/>
             *       &lt;xs:element name="RatePlan" minOccurs="0">
             *         &lt;!-- Reference to inner class RatePlan -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ValueAdds" minOccurs="0">
             *         &lt;!-- Reference to inner class ValueAdds -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SpecialInstructions" minOccurs="0">
             *         &lt;!-- Reference to inner class SpecialInstructions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SearchParameters" minOccurs="0">
             *         &lt;!-- Reference to inner class SearchParameters -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="RoomTypeCode"/>
             *     &lt;xs:attribute type="xs:string" name="RoomType"/>
             *     &lt;xs:attribute type="xs:string" name="InvBlockCode"/>
             *     &lt;xs:attribute type="xs:string" name="RoomCategory"/>
             *     &lt;xs:attribute type="xs:string" name="RoomId"/>
             *     &lt;xs:attribute type="xs:int" name="SegmentNumber"/>
             *     &lt;xs:attribute type="xs:string" name="Floor"/>
             *     &lt;xs:attribute type="xs:string" name="RoomViewCode"/>
             *     &lt;xs:attribute type="xs:boolean" name="SharedRoomInd"/>
             *     &lt;xs:attribute type="xs:int" name="GuestRoomInfo"/>
             *     &lt;xs:attribute name="Action">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Action -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *     &lt;xs:attribute type="xs:boolean" name="NonSmoking"/>
             *     &lt;xs:attribute type="xs:int" name="BedTypeCode"/>
             *     &lt;xs:attribute type="xs:int" name="AccessibilityInformation"/>
             *     &lt;xs:attribute type="xs:int" name="RoomIndex"/>
             *     &lt;xs:attribute type="xs:string" name="BedTypeDescription"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Room implements Serializable
            {
                private Guests guests;
                private RoomDescription roomDescription;
                private RoomExtras roomExtras;
                private String confirmationCode;
                private String cancellationCode;
                private String bookingStatus;
                private RatePlan ratePlan;
                private ValueAdds valueAdds;
                private SpecialInstructions specialInstructions;
                private SearchParameters searchParameters;
                private String roomTypeCode;
                private String roomType;
                private String invBlockCode;
                private String roomCategory;
                private String roomId;
                private Integer segmentNumber;
                private String floor;
                private String roomViewCode;
                private Boolean sharedRoomInd;
                private Integer guestRoomInfo;
                private Action action;
                private Boolean nonSmoking;
                private Integer bedTypeCode;
                private Integer accessibilityInformation;
                private Integer roomIndex;
                private String bedTypeDescription;

                /** 
                 * Get the 'Guests' element value.
                 * 
                 * @return value
                 */
                public Guests getGuests() {
                    return guests;
                }

                /** 
                 * Set the 'Guests' element value.
                 * 
                 * @param guests
                 */
                public void setGuests(Guests guests) {
                    this.guests = guests;
                }

                /** 
                 * Get the 'RoomDescription' element value.
                 * 
                 * @return value
                 */
                public RoomDescription getRoomDescription() {
                    return roomDescription;
                }

                /** 
                 * Set the 'RoomDescription' element value.
                 * 
                 * @param roomDescription
                 */
                public void setRoomDescription(RoomDescription roomDescription) {
                    this.roomDescription = roomDescription;
                }

                /** 
                 * Get the 'RoomExtras' element value.
                 * 
                 * @return value
                 */
                public RoomExtras getRoomExtras() {
                    return roomExtras;
                }

                /** 
                 * Set the 'RoomExtras' element value.
                 * 
                 * @param roomExtras
                 */
                public void setRoomExtras(RoomExtras roomExtras) {
                    this.roomExtras = roomExtras;
                }

                /** 
                 * Get the 'ConfirmationCode' element value. ''ConfirmationCode'' returns room specific confirmation code.
                 * 
                 * @return value
                 */
                public String getConfirmationCode() {
                    return confirmationCode;
                }

                /** 
                 * Set the 'ConfirmationCode' element value. ''ConfirmationCode'' returns room specific confirmation code.
                 * 
                 * @param confirmationCode
                 */
                public void setConfirmationCode(String confirmationCode) {
                    this.confirmationCode = confirmationCode;
                }

                /** 
                 * Get the 'CancellationCode' element value. ''CancellationCode'' returns room specific cancellation code.
                 * 
                 * @return value
                 */
                public String getCancellationCode() {
                    return cancellationCode;
                }

                /** 
                 * Set the 'CancellationCode' element value. ''CancellationCode'' returns room specific cancellation code.
                 * 
                 * @param cancellationCode
                 */
                public void setCancellationCode(String cancellationCode) {
                    this.cancellationCode = cancellationCode;
                }

                /** 
                 * Get the 'BookingStatus' element value. ''BookingStatus'' returns room specific booking status taken from STS OTA table.
                 * 
                 * @return value
                 */
                public String getBookingStatus() {
                    return bookingStatus;
                }

                /** 
                 * Set the 'BookingStatus' element value. ''BookingStatus'' returns room specific booking status taken from STS OTA table.
                 * 
                 * @param bookingStatus
                 */
                public void setBookingStatus(String bookingStatus) {
                    this.bookingStatus = bookingStatus;
                }

                /** 
                 * Get the 'RatePlan' element value.
                 * 
                 * @return value
                 */
                public RatePlan getRatePlan() {
                    return ratePlan;
                }

                /** 
                 * Set the 'RatePlan' element value.
                 * 
                 * @param ratePlan
                 */
                public void setRatePlan(RatePlan ratePlan) {
                    this.ratePlan = ratePlan;
                }

                /** 
                 * Get the 'ValueAdds' element value.
                 * 
                 * @return value
                 */
                public ValueAdds getValueAdds() {
                    return valueAdds;
                }

                /** 
                 * Set the 'ValueAdds' element value.
                 * 
                 * @param valueAdds
                 */
                public void setValueAdds(ValueAdds valueAdds) {
                    this.valueAdds = valueAdds;
                }

                /** 
                 * Get the 'SpecialInstructions' element value.
                 * 
                 * @return value
                 */
                public SpecialInstructions getSpecialInstructions() {
                    return specialInstructions;
                }

                /** 
                 * Set the 'SpecialInstructions' element value.
                 * 
                 * @param specialInstructions
                 */
                public void setSpecialInstructions(
                        SpecialInstructions specialInstructions) {
                    this.specialInstructions = specialInstructions;
                }

                /** 
                 * Get the 'SearchParameters' element value.
                 * 
                 * @return value
                 */
                public SearchParameters getSearchParameters() {
                    return searchParameters;
                }

                /** 
                 * Set the 'SearchParameters' element value.
                 * 
                 * @param searchParameters
                 */
                public void setSearchParameters(
                        SearchParameters searchParameters) {
                    this.searchParameters = searchParameters;
                }

                /** 
                 * Get the 'RoomTypeCode' attribute value. ''RoomTypeCode'' returns a specific system room type code, ex: A1K, A1Q etc.
                 * 
                 * @return value
                 */
                public String getRoomTypeCode() {
                    return roomTypeCode;
                }

                /** 
                 * Set the 'RoomTypeCode' attribute value. ''RoomTypeCode'' returns a specific system room type code, ex: A1K, A1Q etc.
                 * 
                 * @param roomTypeCode
                 */
                public void setRoomTypeCode(String roomTypeCode) {
                    this.roomTypeCode = roomTypeCode;
                }

                /** 
                 * Get the 'RoomType' attribute value. ''RoomType'' returns a code value that indicates the type of room, e.g.: double, king, etc.
                                                                    Values may use the Hotel Descriptive Content table or codes specific to the property or hotel brand.
                 * 
                 * @return value
                 */
                public String getRoomType() {
                    return roomType;
                }

                /** 
                 * Set the 'RoomType' attribute value. ''RoomType'' returns a code value that indicates the type of room, e.g.: double, king, etc.
                                                                    Values may use the Hotel Descriptive Content table or codes specific to the property or hotel brand.
                 * 
                 * @param roomType
                 */
                public void setRoomType(String roomType) {
                    this.roomType = roomType;
                }

                /** 
                 * Get the 'InvBlockCode' attribute value. ''InvBlockCode'' returns a RoomType code equivalent for GDS suppliers response.
                 * 
                 * @return value
                 */
                public String getInvBlockCode() {
                    return invBlockCode;
                }

                /** 
                 * Set the 'InvBlockCode' attribute value. ''InvBlockCode'' returns a RoomType code equivalent for GDS suppliers response.
                 * 
                 * @param invBlockCode
                 */
                public void setInvBlockCode(String invBlockCode) {
                    this.invBlockCode = invBlockCode;
                }

                /** 
                 * Get the 'RoomCategory' attribute value. ''RoomCategory'' returns the room category.
                 * 
                 * @return value
                 */
                public String getRoomCategory() {
                    return roomCategory;
                }

                /** 
                 * Set the 'RoomCategory' attribute value. ''RoomCategory'' returns the room category.
                 * 
                 * @param roomCategory
                 */
                public void setRoomCategory(String roomCategory) {
                    this.roomCategory = roomCategory;
                }

                /** 
                 * Get the 'RoomId' attribute value. ''RoomId'' returns the room identifier.
                 * 
                 * @return value
                 */
                public String getRoomId() {
                    return roomId;
                }

                /** 
                 * Set the 'RoomId' attribute value. ''RoomId'' returns the room identifier.
                 * 
                 * @param roomId
                 */
                public void setRoomId(String roomId) {
                    this.roomId = roomId;
                }

                /** 
                 * Get the 'SegmentNumber' attribute value. ''SegmentNumber'' returns the segment number.
                 * 
                 * @return value
                 */
                public Integer getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'SegmentNumber' attribute value. ''SegmentNumber'' returns the segment number.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(Integer segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'Floor' attribute value. ''Floor'' returns the floor.
                 * 
                 * @return value
                 */
                public String getFloor() {
                    return floor;
                }

                /** 
                 * Set the 'Floor' attribute value. ''Floor'' returns the floor.
                 * 
                 * @param floor
                 */
                public void setFloor(String floor) {
                    this.floor = floor;
                }

                /** 
                 * Get the 'RoomViewCode' attribute value. ''RoomViewCode'' returns the room view code.
                 * 
                 * @return value
                 */
                public String getRoomViewCode() {
                    return roomViewCode;
                }

                /** 
                 * Set the 'RoomViewCode' attribute value. ''RoomViewCode'' returns the room view code.
                 * 
                 * @param roomViewCode
                 */
                public void setRoomViewCode(String roomViewCode) {
                    this.roomViewCode = roomViewCode;
                }

                /** 
                 * Get the 'SharedRoomInd' attribute value. ''SharedRoomInd'' returns the shared room indicator.
                 * 
                 * @return value
                 */
                public Boolean getSharedRoomInd() {
                    return sharedRoomInd;
                }

                /** 
                 * Set the 'SharedRoomInd' attribute value. ''SharedRoomInd'' returns the shared room indicator.
                 * 
                 * @param sharedRoomInd
                 */
                public void setSharedRoomInd(Boolean sharedRoomInd) {
                    this.sharedRoomInd = sharedRoomInd;
                }

                /** 
                 * Get the 'GuestRoomInfo' attribute value. ''GuestRoomInfo'' returns the number of guests in a room.
                 * 
                 * @return value
                 */
                public Integer getGuestRoomInfo() {
                    return guestRoomInfo;
                }

                /** 
                 * Set the 'GuestRoomInfo' attribute value. ''GuestRoomInfo'' returns the number of guests in a room.
                 * 
                 * @param guestRoomInfo
                 */
                public void setGuestRoomInfo(Integer guestRoomInfo) {
                    this.guestRoomInfo = guestRoomInfo;
                }

                /** 
                 * Get the 'Action' attribute value. ''Action'' returns the Action Code For Update.
                 * 
                 * @return value
                 */
                public Action getAction() {
                    return action;
                }

                /** 
                 * Set the 'Action' attribute value. ''Action'' returns the Action Code For Update.
                 * 
                 * @param action
                 */
                public void setAction(Action action) {
                    this.action = action;
                }

                /** 
                 * Get the 'NonSmoking' attribute value. ''NonSmoking'' returns the non smoking indicator.
                                                                    `True` - Non Smoking.
                                                                    `False` - Smoking.
                 * 
                 * @return value
                 */
                public Boolean getNonSmoking() {
                    return nonSmoking;
                }

                /** 
                 * Set the 'NonSmoking' attribute value. ''NonSmoking'' returns the non smoking indicator.
                                                                    `True` - Non Smoking.
                                                                    `False` - Smoking.
                 * 
                 * @param nonSmoking
                 */
                public void setNonSmoking(Boolean nonSmoking) {
                    this.nonSmoking = nonSmoking;
                }

                /** 
                 * Get the 'BedTypeCode' attribute value. ''BedTypeCode'' indicates the type of bed(s) found in the room.
                                                                    Typical values would be Double, Twin, Queen, or King.
                                                                    Refer to OpenTravel Code List Bed Type Code (BED).
                 * 
                 * @return value
                 */
                public Integer getBedTypeCode() {
                    return bedTypeCode;
                }

                /** 
                 * Set the 'BedTypeCode' attribute value. ''BedTypeCode'' indicates the type of bed(s) found in the room.
                                                                    Typical values would be Double, Twin, Queen, or King.
                                                                    Refer to OpenTravel Code List Bed Type Code (BED).
                 * 
                 * @param bedTypeCode
                 */
                public void setBedTypeCode(Integer bedTypeCode) {
                    this.bedTypeCode = bedTypeCode;
                }

                /** 
                 * Get the 'AccessibilityInformation' attribute value. ''AccessibilityInformation'' returns OTA Types Code, Uses PHY table.
                 * 
                 * @return value
                 */
                public Integer getAccessibilityInformation() {
                    return accessibilityInformation;
                }

                /** 
                 * Set the 'AccessibilityInformation' attribute value. ''AccessibilityInformation'' returns OTA Types Code, Uses PHY table.
                 * 
                 * @param accessibilityInformation
                 */
                public void setAccessibilityInformation(
                        Integer accessibilityInformation) {
                    this.accessibilityInformation = accessibilityInformation;
                }

                /** 
                 * Get the 'RoomIndex' attribute value. ''RoomIndex'' returns the sequence number of the room.
                 * 
                 * @return value
                 */
                public Integer getRoomIndex() {
                    return roomIndex;
                }

                /** 
                 * Set the 'RoomIndex' attribute value. ''RoomIndex'' returns the sequence number of the room.
                 * 
                 * @param roomIndex
                 */
                public void setRoomIndex(Integer roomIndex) {
                    this.roomIndex = roomIndex;
                }

                /** 
                 * Get the 'BedTypeDescription' attribute value. ''BedTypeDescription'' is Used for NON OTA Bed Type.
                 * 
                 * @return value
                 */
                public String getBedTypeDescription() {
                    return bedTypeDescription;
                }

                /** 
                 * Set the 'BedTypeDescription' attribute value. ''BedTypeDescription'' is Used for NON OTA Bed Type.
                 * 
                 * @param bedTypeDescription
                 */
                public void setBedTypeDescription(String bedTypeDescription) {
                    this.bedTypeDescription = bedTypeDescription;
                }
                /** 
                 * ''Guests'' returns a list of Guests in a room.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guests" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Guest" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Guest -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:int" name="Count"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Guests implements Serializable
                {
                    private List<Guest> guestList = new ArrayList<Guest>();
                    private Integer count;

                    /** 
                     * Get the list of 'Guest' element items.
                     * 
                     * @return list
                     */
                    public List<Guest> getGuestList() {
                        return guestList;
                    }

                    /** 
                     * Set the list of 'Guest' element items.
                     * 
                     * @param list
                     */
                    public void setGuestList(List<Guest> list) {
                        guestList = list;
                    }

                    /** 
                     * Get the 'Count' attribute value. ''Count'' returns the guest count.
                     * 
                     * @return value
                     */
                    public Integer getCount() {
                        return count;
                    }

                    /** 
                     * Set the 'Count' attribute value. ''Count'' returns the guest count.
                     * 
                     * @param count
                     */
                    public void setCount(Integer count) {
                        this.count = count;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guest" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Contact" minOccurs="0">
                     *         &lt;!-- Reference to inner class Contact -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:int" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" name="FullName"/>
                     *     &lt;xs:attribute type="xs:string" name="Email"/>
                     *     &lt;xs:attribute type="xs:int" name="Age"/>
                     *     &lt;xs:attribute type="xs:int" name="Index"/>
                     *     &lt;xs:attribute type="xs:boolean" default="false" name="LeadGuest"/>
                     *     &lt;xs:attribute type="xs:string" name="FrequentFlyerNumber"/>
                     *     &lt;xs:attribute type="xs:string" name="LoyaltyId"/>
                     *     &lt;xs:attribute type="xs:string" name="Title"/>
                     *     &lt;xs:attribute type="xs:string" name="FirstName"/>
                     *     &lt;xs:attribute type="xs:string" name="LastName"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Guest implements Serializable
                    {
                        private Contact contact;
                        private Integer type;
                        private String fullName;
                        private String email;
                        private Integer age;
                        private Integer index;
                        private Boolean leadGuest;
                        private String frequentFlyerNumber;
                        private String loyaltyId;
                        private String title;
                        private String firstName;
                        private String lastName;

                        /** 
                         * Get the 'Contact' element value.
                         * 
                         * @return value
                         */
                        public Contact getContact() {
                            return contact;
                        }

                        /** 
                         * Set the 'Contact' element value.
                         * 
                         * @param contact
                         */
                        public void setContact(Contact contact) {
                            this.contact = contact;
                        }

                        /** 
                         * Get the 'Type' attribute value. ''Type'' returns the guest type.
                                                                                                AQC OTA Code table is used for Type.
                                                                                                `10` - Adult.
                                                                                                `8` - Child.
                                                                                                Valid values are only Adult and Child Types.
                         * 
                         * @return value
                         */
                        public Integer getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. ''Type'' returns the guest type.
                                                                                                AQC OTA Code table is used for Type.
                                                                                                `10` - Adult.
                                                                                                `8` - Child.
                                                                                                Valid values are only Adult and Child Types.
                         * 
                         * @param type
                         */
                        public void setType(Integer type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'FullName' attribute value. ''FullName'' is returned sometimes by aggregator when it does not return first name / last name.
                         * 
                         * @return value
                         */
                        public String getFullName() {
                            return fullName;
                        }

                        /** 
                         * Set the 'FullName' attribute value. ''FullName'' is returned sometimes by aggregator when it does not return first name / last name.
                         * 
                         * @param fullName
                         */
                        public void setFullName(String fullName) {
                            this.fullName = fullName;
                        }

                        /** 
                         * Get the 'Email' attribute value. ''Email'' returns email address.
                         * 
                         * @return value
                         */
                        public String getEmail() {
                            return email;
                        }

                        /** 
                         * Set the 'Email' attribute value. ''Email'' returns email address.
                         * 
                         * @param email
                         */
                        public void setEmail(String email) {
                            this.email = email;
                        }

                        /** 
                         * Get the 'Age' attribute value. ''Age'' returns guest age.
                                                                                                Age is mandatory for a child.
                         * 
                         * @return value
                         */
                        public Integer getAge() {
                            return age;
                        }

                        /** 
                         * Set the 'Age' attribute value. ''Age'' returns guest age.
                                                                                                Age is mandatory for a child.
                         * 
                         * @param age
                         */
                        public void setAge(Integer age) {
                            this.age = age;
                        }

                        /** 
                         * Get the 'Index' attribute value. ''Index'' returns guest index.
                         * 
                         * @return value
                         */
                        public Integer getIndex() {
                            return index;
                        }

                        /** 
                         * Set the 'Index' attribute value. ''Index'' returns guest index.
                         * 
                         * @param index
                         */
                        public void setIndex(Integer index) {
                            this.index = index;
                        }

                        /** 
                         * Get the 'LeadGuest' attribute value. ''LeadGuest'' returns the lead guest indicator.
                                                                                                Only one lead passenger can be present per booking.
                         * 
                         * @return value
                         */
                        public Boolean getLeadGuest() {
                            return leadGuest;
                        }

                        /** 
                         * Set the 'LeadGuest' attribute value. ''LeadGuest'' returns the lead guest indicator.
                                                                                                Only one lead passenger can be present per booking.
                         * 
                         * @param leadGuest
                         */
                        public void setLeadGuest(Boolean leadGuest) {
                            this.leadGuest = leadGuest;
                        }

                        /** 
                         * Get the 'FrequentFlyerNumber' attribute value. ''FrequentFlyerNumber'' returns the frequent flyer number.
                         * 
                         * @return value
                         */
                        public String getFrequentFlyerNumber() {
                            return frequentFlyerNumber;
                        }

                        /** 
                         * Set the 'FrequentFlyerNumber' attribute value. ''FrequentFlyerNumber'' returns the frequent flyer number.
                         * 
                         * @param frequentFlyerNumber
                         */
                        public void setFrequentFlyerNumber(
                                String frequentFlyerNumber) {
                            this.frequentFlyerNumber = frequentFlyerNumber;
                        }

                        /** 
                         * Get the 'LoyaltyId' attribute value. ''LoyaltyId'' returns the loyalty identifier.
                         * 
                         * @return value
                         */
                        public String getLoyaltyId() {
                            return loyaltyId;
                        }

                        /** 
                         * Set the 'LoyaltyId' attribute value. ''LoyaltyId'' returns the loyalty identifier.
                         * 
                         * @param loyaltyId
                         */
                        public void setLoyaltyId(String loyaltyId) {
                            this.loyaltyId = loyaltyId;
                        }

                        /** 
                         * Get the 'Title' attribute value. ''Title'' returns guest title.
                                                                                                Title can include MR./MS. etc.
                         * 
                         * @return value
                         */
                        public String getTitle() {
                            return title;
                        }

                        /** 
                         * Set the 'Title' attribute value. ''Title'' returns guest title.
                                                                                                Title can include MR./MS. etc.
                         * 
                         * @param title
                         */
                        public void setTitle(String title) {
                            this.title = title;
                        }

                        /** 
                         * Get the 'FirstName' attribute value. ''FirstName'' returns the first name of the guest.
                         * 
                         * @return value
                         */
                        public String getFirstName() {
                            return firstName;
                        }

                        /** 
                         * Set the 'FirstName' attribute value. ''FirstName'' returns the first name of the guest.
                         * 
                         * @param firstName
                         */
                        public void setFirstName(String firstName) {
                            this.firstName = firstName;
                        }

                        /** 
                         * Get the 'LastName' attribute value. ''LastName'' returns the last name of the guest.
                         * 
                         * @return value
                         */
                        public String getLastName() {
                            return lastName;
                        }

                        /** 
                         * Set the 'LastName' attribute value. ''LastName'' returns the last name of the guest.
                         * 
                         * @param lastName
                         */
                        public void setLastName(String lastName) {
                            this.lastName = lastName;
                        }
                        /** 
                         * ''Contact'' returns guest contact information.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contact" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" name="Phone"/>
                         *     &lt;xs:attribute type="xs:string" name="Mobile"/>
                         *     &lt;xs:attribute type="xs:string" name="Fax"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Contact implements Serializable
                        {
                            private String phone;
                            private String mobile;
                            private String fax;

                            /** 
                             * Get the 'Phone' attribute value. ''Phone'' returns the guest contact phone number.
                             * 
                             * @return value
                             */
                            public String getPhone() {
                                return phone;
                            }

                            /** 
                             * Set the 'Phone' attribute value. ''Phone'' returns the guest contact phone number.
                             * 
                             * @param phone
                             */
                            public void setPhone(String phone) {
                                this.phone = phone;
                            }

                            /** 
                             * Get the 'Mobile' attribute value. ''Mobile'' returns the guest contact mobile phone number.
                             * 
                             * @return value
                             */
                            public String getMobile() {
                                return mobile;
                            }

                            /** 
                             * Set the 'Mobile' attribute value. ''Mobile'' returns the guest contact mobile phone number.
                             * 
                             * @param mobile
                             */
                            public void setMobile(String mobile) {
                                this.mobile = mobile;
                            }

                            /** 
                             * Get the 'Fax' attribute value. ''Fax'' returns the guest contact fax number.
                             * 
                             * @return value
                             */
                            public String getFax() {
                                return fax;
                            }

                            /** 
                             * Set the 'Fax' attribute value. ''Fax'' returns the guest contact fax number.
                             * 
                             * @param fax
                             */
                            public void setFax(String fax) {
                                this.fax = fax;
                            }
                        }
                    }
                }
                /** 
                 * ''RoomDescription'' returns supplier provided room description.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomDescription" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="Name"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RoomDescription implements Serializable
                {
                    private String text;
                    private String name;

                    /** 
                     * Get the 'Text' element value. ''Text'' returns supplier provided room description text.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. ''Text'' returns supplier provided room description text.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'Name' attribute value. ''Name'' returns supplier provided text.
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value. ''Name'' returns supplier provided text.
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }
                }
                /** 
                 * ''RoomExtras'' returns a list of room extras.
                                                                        Only 3 supported crib/rollaway bed/extra per person.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomExtras" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="RoomExtra" maxOccurs="3">
                 *         &lt;!-- Reference to inner class RoomExtra -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RoomExtras implements Serializable
                {
                    private List<RoomExtra> roomExtraList = new ArrayList<RoomExtra>();

                    /** 
                     * Get the list of 'RoomExtra' element items.
                     * 
                     * @return list
                     */
                    public List<RoomExtra> getRoomExtraList() {
                        return roomExtraList;
                    }

                    /** 
                     * Set the list of 'RoomExtra' element items.
                     * 
                     * @param list
                     */
                    public void setRoomExtraList(List<RoomExtra> list) {
                        roomExtraList = list;
                    }
                    /** 
                     * ''RoomExtra'' returns a single room extra.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomExtra" maxOccurs="3">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:int" use="required" name="Type"/>
                     *     &lt;xs:attribute type="xs:int" name="Quantity"/>
                     *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RoomExtra implements Serializable
                    {
                        private Integer type;
                        private Integer quantity;
                        private BigDecimal amount;

                        /** 
                         * Get the 'Type' attribute value. ''Type'' returns OTA code (RMA) for corresponding room extra amenity.
                         * 
                         * @return value
                         */
                        public Integer getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. ''Type'' returns OTA code (RMA) for corresponding room extra amenity.
                         * 
                         * @param type
                         */
                        public void setType(Integer type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'Quantity' attribute value. ''Quantity'' returns the quantity of the room extra.
                         * 
                         * @return value
                         */
                        public Integer getQuantity() {
                            return quantity;
                        }

                        /** 
                         * Set the 'Quantity' attribute value. ''Quantity'' returns the quantity of the room extra.
                         * 
                         * @param quantity
                         */
                        public void setQuantity(Integer quantity) {
                            this.quantity = quantity;
                        }

                        /** 
                         * Get the 'Amount' attribute value. ''Amount'' returns the currency amount.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. ''Amount'' returns the currency amount.
                         * 
                         * @param amount
                         */
                        public void setAmount(BigDecimal amount) {
                            this.amount = amount;
                        }
                    }
                }
                /** 
                 * ''BookingStatus'' returns Describes a rate plan in response.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RatePlan" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="RatePlanDescription" minOccurs="0">
                 *         &lt;!-- Reference to inner class RatePlanDescription -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="RatePlanInclusions" minOccurs="0">
                 *         &lt;!-- Reference to inner class RatePlanInclusions -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="MealsIncluded" minOccurs="0">
                 *         &lt;!-- Reference to inner class MealsIncluded -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="RateInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class RateInfo -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" name="RatePlanName"/>
                 *     &lt;xs:attribute type="xs:string" name="RatePlanCode"/>
                 *     &lt;xs:attribute type="xs:string" name="SupplierRatePlanCode"/>
                 *     &lt;xs:attribute type="xs:string" name="RatePlanType"/>
                 *     &lt;xs:attribute type="xs:boolean" name="PrepaidIndicator"/>
                 *     &lt;xs:attribute type="xs:string" name="RateAssured"/>
                 *     &lt;xs:attribute type="xs:string" name="RateKey"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RatePlan implements Serializable
                {
                    private RatePlanDescription ratePlanDescription;
                    private RatePlanInclusions ratePlanInclusions;
                    private MealsIncluded mealsIncluded;
                    private RateInfo rateInfo;
                    private String ratePlanName;
                    private String ratePlanCode;
                    private String supplierRatePlanCode;
                    private String ratePlanType;
                    private Boolean prepaidIndicator;
                    private String rateAssured;
                    private String rateKey;

                    /** 
                     * Get the 'RatePlanDescription' element value.
                     * 
                     * @return value
                     */
                    public RatePlanDescription getRatePlanDescription() {
                        return ratePlanDescription;
                    }

                    /** 
                     * Set the 'RatePlanDescription' element value.
                     * 
                     * @param ratePlanDescription
                     */
                    public void setRatePlanDescription(
                            RatePlanDescription ratePlanDescription) {
                        this.ratePlanDescription = ratePlanDescription;
                    }

                    /** 
                     * Get the 'RatePlanInclusions' element value.
                     * 
                     * @return value
                     */
                    public RatePlanInclusions getRatePlanInclusions() {
                        return ratePlanInclusions;
                    }

                    /** 
                     * Set the 'RatePlanInclusions' element value.
                     * 
                     * @param ratePlanInclusions
                     */
                    public void setRatePlanInclusions(
                            RatePlanInclusions ratePlanInclusions) {
                        this.ratePlanInclusions = ratePlanInclusions;
                    }

                    /** 
                     * Get the 'MealsIncluded' element value.
                     * 
                     * @return value
                     */
                    public MealsIncluded getMealsIncluded() {
                        return mealsIncluded;
                    }

                    /** 
                     * Set the 'MealsIncluded' element value.
                     * 
                     * @param mealsIncluded
                     */
                    public void setMealsIncluded(MealsIncluded mealsIncluded) {
                        this.mealsIncluded = mealsIncluded;
                    }

                    /** 
                     * Get the 'RateInfo' element value.
                     * 
                     * @return value
                     */
                    public RateInfo getRateInfo() {
                        return rateInfo;
                    }

                    /** 
                     * Set the 'RateInfo' element value.
                     * 
                     * @param rateInfo
                     */
                    public void setRateInfo(RateInfo rateInfo) {
                        this.rateInfo = rateInfo;
                    }

                    /** 
                     * Get the 'RatePlanName' attribute value. ''RatePlanName'' returns the rate plan name.
                     * 
                     * @return value
                     */
                    public String getRatePlanName() {
                        return ratePlanName;
                    }

                    /** 
                     * Set the 'RatePlanName' attribute value. ''RatePlanName'' returns the rate plan name.
                     * 
                     * @param ratePlanName
                     */
                    public void setRatePlanName(String ratePlanName) {
                        this.ratePlanName = ratePlanName;
                    }

                    /** 
                     * Get the 'RatePlanCode' attribute value. ''RatePlanCode'' returns the client ID code (HIC table in PSS).
                     * 
                     * @return value
                     */
                    public String getRatePlanCode() {
                        return ratePlanCode;
                    }

                    /** 
                     * Set the 'RatePlanCode' attribute value. ''RatePlanCode'' returns the client ID code (HIC table in PSS).
                     * 
                     * @param ratePlanCode
                     */
                    public void setRatePlanCode(String ratePlanCode) {
                        this.ratePlanCode = ratePlanCode;
                    }

                    /** 
                     * Get the 'SupplierRatePlanCode' attribute value. ''SupplierRatePlanCode'' returns actual rate code (HST transaction in PSS).
                     * 
                     * @return value
                     */
                    public String getSupplierRatePlanCode() {
                        return supplierRatePlanCode;
                    }

                    /** 
                     * Set the 'SupplierRatePlanCode' attribute value. ''SupplierRatePlanCode'' returns actual rate code (HST transaction in PSS).
                     * 
                     * @param supplierRatePlanCode
                     */
                    public void setSupplierRatePlanCode(
                            String supplierRatePlanCode) {
                        this.supplierRatePlanCode = supplierRatePlanCode;
                    }

                    /** 
                     * Get the 'RatePlanType' attribute value. ''RatePlanType'' returns the rate plan type.
                     * 
                     * @return value
                     */
                    public String getRatePlanType() {
                        return ratePlanType;
                    }

                    /** 
                     * Set the 'RatePlanType' attribute value. ''RatePlanType'' returns the rate plan type.
                     * 
                     * @param ratePlanType
                     */
                    public void setRatePlanType(String ratePlanType) {
                        this.ratePlanType = ratePlanType;
                    }

                    /** 
                     * Get the 'PrepaidIndicator' attribute value. ''PrepaidIndicator'' returns the prepaid indicator.
                     * 
                     * @return value
                     */
                    public Boolean getPrepaidIndicator() {
                        return prepaidIndicator;
                    }

                    /** 
                     * Set the 'PrepaidIndicator' attribute value. ''PrepaidIndicator'' returns the prepaid indicator.
                     * 
                     * @param prepaidIndicator
                     */
                    public void setPrepaidIndicator(Boolean prepaidIndicator) {
                        this.prepaidIndicator = prepaidIndicator;
                    }

                    /** 
                     * Get the 'RateAssured' attribute value. ''RateAssured'' returns the rate assured information.
                     * 
                     * @return value
                     */
                    public String getRateAssured() {
                        return rateAssured;
                    }

                    /** 
                     * Set the 'RateAssured' attribute value. ''RateAssured'' returns the rate assured information.
                     * 
                     * @param rateAssured
                     */
                    public void setRateAssured(String rateAssured) {
                        this.rateAssured = rateAssured;
                    }

                    /** 
                     * Get the 'RateKey' attribute value. ''RateKey'' returns the rate key.
                     * 
                     * @return value
                     */
                    public String getRateKey() {
                        return rateKey;
                    }

                    /** 
                     * Set the 'RateKey' attribute value. ''RateKey'' returns the rate key.
                     * 
                     * @param rateKey
                     */
                    public void setRateKey(String rateKey) {
                        this.rateKey = rateKey;
                    }
                    /** 
                     * ''RatePlanDescription'' returns the rate plan description.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RatePlanDescription" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RatePlanDescription implements
                        Serializable
                    {
                        private List<String> textList = new ArrayList<String>();

                        /** 
                         * Get the list of 'Text' element items. ''Text'' returns the product description text.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items. ''Text'' returns the product description text.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }
                    }
                    /** 
                     * ''RatePlanInclusions'' returns charges that are included in this rate plan.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RatePlanInclusions" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="RatePlanInclusionDescription" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class RatePlanInclusionDescription -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RatePlanInclusions implements
                        Serializable
                    {
                        private List<RatePlanInclusionDescription> ratePlanInclusionDescriptionList = new ArrayList<RatePlanInclusionDescription>();

                        /** 
                         * Get the list of 'RatePlanInclusionDescription' element items.
                         * 
                         * @return list
                         */
                        public List<RatePlanInclusionDescription> getRatePlanInclusionDescriptionList() {
                            return ratePlanInclusionDescriptionList;
                        }

                        /** 
                         * Set the list of 'RatePlanInclusionDescription' element items.
                         * 
                         * @param list
                         */
                        public void setRatePlanInclusionDescriptionList(
                                List<RatePlanInclusionDescription> list) {
                            ratePlanInclusionDescriptionList = list;
                        }
                        /** 
                         * ''RatePlanInclusionDescription'' returns a description of what is included in the rate plan.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RatePlanInclusionDescription" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="Name"/>
                         *     &lt;xs:attribute type="xs:int" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class RatePlanInclusionDescription
                            implements Serializable
                        {
                            private String text;
                            private String name;
                            private Integer code;

                            /** 
                             * Get the 'Text' element value. ''Text'' returns product description text.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value. ''Text'' returns product description text.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }

                            /** 
                             * Get the 'Name' attribute value. ''Name'' returns rate plan inclusion description name.
                             * 
                             * @return value
                             */
                            public String getName() {
                                return name;
                            }

                            /** 
                             * Set the 'Name' attribute value. ''Name'' returns rate plan inclusion description name.
                             * 
                             * @param name
                             */
                            public void setName(String name) {
                                this.name = name;
                            }

                            /** 
                             * Get the 'Code' attribute value. ''Code'' returns rate plan inclusion description  code (OTA Code).
                             * 
                             * @return value
                             */
                            public Integer getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. ''Code'' returns rate plan inclusion description  code (OTA Code).
                             * 
                             * @param code
                             */
                            public void setCode(Integer code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * ''MealsIncluded'' returns which meals are included with this rate program.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealsIncluded" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="MealIncluded" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class MealIncluded -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MealsIncluded implements Serializable
                    {
                        private List<MealIncluded> mealIncludedList = new ArrayList<MealIncluded>();

                        /** 
                         * Get the list of 'MealIncluded' element items.
                         * 
                         * @return list
                         */
                        public List<MealIncluded> getMealIncludedList() {
                            return mealIncludedList;
                        }

                        /** 
                         * Set the list of 'MealIncluded' element items.
                         * 
                         * @param list
                         */
                        public void setMealIncludedList(List<MealIncluded> list) {
                            mealIncludedList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealIncluded" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" name="Breakfast"/>
                         *     &lt;xs:attribute type="xs:boolean" name="Lunch"/>
                         *     &lt;xs:attribute type="xs:boolean" name="Dinner"/>
                         *     &lt;xs:attribute type="xs:boolean" name="MealPlanIndicator"/>
                         *     &lt;xs:attribute type="xs:string" name="MealPlanCode"/>
                         *     &lt;xs:attribute type="xs:int" name="GuestCount"/>
                         *     &lt;xs:attribute type="xs:date" name="StartDate"/>
                         *     &lt;xs:attribute type="xs:date" name="EndDate"/>
                         *     &lt;xs:attribute type="xs:int" name="NumberOfNights"/>
                         *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MealIncluded implements
                            Serializable
                        {
                            private Boolean breakfast;
                            private Boolean lunch;
                            private Boolean dinner;
                            private Boolean mealPlanIndicator;
                            private String mealPlanCode;
                            private Integer guestCount;
                            private java.sql.Date startDate;
                            private java.sql.Date endDate;
                            private Integer numberOfNights;
                            private BigDecimal amount;
                            private String currencyCode;

                            /** 
                             * Get the 'Breakfast' attribute value. ''Breakfast'' indicates that a breakfast is included when true.
                             * 
                             * @return value
                             */
                            public Boolean getBreakfast() {
                                return breakfast;
                            }

                            /** 
                             * Set the 'Breakfast' attribute value. ''Breakfast'' indicates that a breakfast is included when true.
                             * 
                             * @param breakfast
                             */
                            public void setBreakfast(Boolean breakfast) {
                                this.breakfast = breakfast;
                            }

                            /** 
                             * Get the 'Lunch' attribute value. ''Lunch'' indicates that a lunch is included when true.
                             * 
                             * @return value
                             */
                            public Boolean getLunch() {
                                return lunch;
                            }

                            /** 
                             * Set the 'Lunch' attribute value. ''Lunch'' indicates that a lunch is included when true.
                             * 
                             * @param lunch
                             */
                            public void setLunch(Boolean lunch) {
                                this.lunch = lunch;
                            }

                            /** 
                             * Get the 'Dinner' attribute value. ''Dinner'' indicates that a dinner is included when true.
                             * 
                             * @return value
                             */
                            public Boolean getDinner() {
                                return dinner;
                            }

                            /** 
                             * Set the 'Dinner' attribute value. ''Dinner'' indicates that a dinner is included when true.
                             * 
                             * @param dinner
                             */
                            public void setDinner(Boolean dinner) {
                                this.dinner = dinner;
                            }

                            /** 
                             * Get the 'MealPlanIndicator' attribute value. ''MealPlanIndicator'' returns true  when a meal plan is included.
                                                                                                              Returns false when it isn't.
                             * 
                             * @return value
                             */
                            public Boolean getMealPlanIndicator() {
                                return mealPlanIndicator;
                            }

                            /** 
                             * Set the 'MealPlanIndicator' attribute value. ''MealPlanIndicator'' returns true  when a meal plan is included.
                                                                                                              Returns false when it isn't.
                             * 
                             * @param mealPlanIndicator
                             */
                            public void setMealPlanIndicator(
                                    Boolean mealPlanIndicator) {
                                this.mealPlanIndicator = mealPlanIndicator;
                            }

                            /** 
                             * Get the 'MealPlanCode' attribute value. ''MealPlanCode'' can be used to identify the types of meals included.
                                                                                                              Refer to open travel code list meal plan type (MPT) list of codes.
                             * 
                             * @return value
                             */
                            public String getMealPlanCode() {
                                return mealPlanCode;
                            }

                            /** 
                             * Set the 'MealPlanCode' attribute value. ''MealPlanCode'' can be used to identify the types of meals included.
                                                                                                              Refer to open travel code list meal plan type (MPT) list of codes.
                             * 
                             * @param mealPlanCode
                             */
                            public void setMealPlanCode(String mealPlanCode) {
                                this.mealPlanCode = mealPlanCode;
                            }

                            /** 
                             * Get the 'GuestCount' attribute value. ''GuestCount'' indicates the number of guests for whom the meal plan is applicable.
                             * 
                             * @return value
                             */
                            public Integer getGuestCount() {
                                return guestCount;
                            }

                            /** 
                             * Set the 'GuestCount' attribute value. ''GuestCount'' indicates the number of guests for whom the meal plan is applicable.
                             * 
                             * @param guestCount
                             */
                            public void setGuestCount(Integer guestCount) {
                                this.guestCount = guestCount;
                            }

                            /** 
                             * Get the 'StartDate' attribute value. ''StartDate'' returns the start date for the meal plan.
                             * 
                             * @return value
                             */
                            public java.sql.Date getStartDate() {
                                return startDate;
                            }

                            /** 
                             * Set the 'StartDate' attribute value. ''StartDate'' returns the start date for the meal plan.
                             * 
                             * @param startDate
                             */
                            public void setStartDate(java.sql.Date startDate) {
                                this.startDate = startDate;
                            }

                            /** 
                             * Get the 'EndDate' attribute value. ''EndDate'' returns the end date for the meal plan.
                             * 
                             * @return value
                             */
                            public java.sql.Date getEndDate() {
                                return endDate;
                            }

                            /** 
                             * Set the 'EndDate' attribute value. ''EndDate'' returns the end date for the meal plan.
                             * 
                             * @param endDate
                             */
                            public void setEndDate(java.sql.Date endDate) {
                                this.endDate = endDate;
                            }

                            /** 
                             * Get the 'NumberOfNights' attribute value. ''NumberOfNights'' returns the number of nights included for the meal plan.
                             * 
                             * @return value
                             */
                            public Integer getNumberOfNights() {
                                return numberOfNights;
                            }

                            /** 
                             * Set the 'NumberOfNights' attribute value. ''NumberOfNights'' returns the number of nights included for the meal plan.
                             * 
                             * @param numberOfNights
                             */
                            public void setNumberOfNights(Integer numberOfNights) {
                                this.numberOfNights = numberOfNights;
                            }

                            /** 
                             * Get the 'Amount' attribute value. ''Amount'' indicates charges for the meal plan.
                             * 
                             * @return value
                             */
                            public BigDecimal getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. ''Amount'' indicates charges for the meal plan.
                             * 
                             * @param amount
                             */
                            public void setAmount(BigDecimal amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }
                        }
                    }
                    /** 
                     * Rate for a Room. Used in Response.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Rates" minOccurs="0">
                     *         &lt;!-- Reference to inner class Rates -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="RatePlanDescription" minOccurs="0">
                     *         &lt;!-- Reference to inner class RatePlanDescription -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="AdditionalDetails" minOccurs="0">
                     *         &lt;!-- Reference to inner class AdditionalDetails -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Fees" minOccurs="0">
                     *         &lt;!-- Reference to inner class Fees -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Taxes" minOccurs="0">
                     *         &lt;!-- Reference to inner class Taxes -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CancelPenalties" minOccurs="0">
                     *         &lt;!-- Reference to inner class CancelPenalties -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Guarantee" minOccurs="0">
                     *         &lt;!-- Reference to inner class Guarantee -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Commission" minOccurs="0">
                     *         &lt;!-- Reference to inner class Commission -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Discounts" minOccurs="0">
                     *         &lt;!-- Reference to inner class Discounts -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:decimal" name="AmountBeforeTax"/>
                     *     &lt;xs:attribute type="xs:decimal" name="AmountAfterTax"/>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:boolean" name="AppliedDiscount"/>
                     *     &lt;xs:attribute type="xs:decimal" name="NightlyRate"/>
                     *     &lt;xs:attribute type="xs:decimal" name="SupplierChangedAmount"/>
                     *     &lt;xs:attribute type="xs:boolean" name="Changed"/>
                     *     &lt;xs:attribute type="xs:boolean" name="AdditionalFeesInclusive"/>
                     *     &lt;xs:attribute type="xs:boolean" name="TaxInclusive"/>
                     *     &lt;xs:attribute type="xs:boolean" name="LocalFeesInclusive"/>
                     *     &lt;xs:attribute type="xs:boolean" name="IncidentalsInclusive"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RateInfo implements Serializable
                    {
                        private Rates rates;
                        private RatePlanDescription ratePlanDescription;
                        private AdditionalDetails additionalDetails;
                        private Fees fees;
                        private Taxes taxes;
                        private CancelPenalties cancelPenalties;
                        private Guarantee guarantee;
                        private Commission commission;
                        private Discounts discounts;
                        private BigDecimal amountBeforeTax;
                        private BigDecimal amountAfterTax;
                        private String currencyCode;
                        private Boolean appliedDiscount;
                        private BigDecimal nightlyRate;
                        private BigDecimal supplierChangedAmount;
                        private Boolean changed;
                        private Boolean additionalFeesInclusive;
                        private Boolean taxInclusive;
                        private Boolean localFeesInclusive;
                        private Boolean incidentalsInclusive;

                        /** 
                         * Get the 'Rates' element value.
                         * 
                         * @return value
                         */
                        public Rates getRates() {
                            return rates;
                        }

                        /** 
                         * Set the 'Rates' element value.
                         * 
                         * @param rates
                         */
                        public void setRates(Rates rates) {
                            this.rates = rates;
                        }

                        /** 
                         * Get the 'RatePlanDescription' element value.
                         * 
                         * @return value
                         */
                        public RatePlanDescription getRatePlanDescription() {
                            return ratePlanDescription;
                        }

                        /** 
                         * Set the 'RatePlanDescription' element value.
                         * 
                         * @param ratePlanDescription
                         */
                        public void setRatePlanDescription(
                                RatePlanDescription ratePlanDescription) {
                            this.ratePlanDescription = ratePlanDescription;
                        }

                        /** 
                         * Get the 'AdditionalDetails' element value.
                         * 
                         * @return value
                         */
                        public AdditionalDetails getAdditionalDetails() {
                            return additionalDetails;
                        }

                        /** 
                         * Set the 'AdditionalDetails' element value.
                         * 
                         * @param additionalDetails
                         */
                        public void setAdditionalDetails(
                                AdditionalDetails additionalDetails) {
                            this.additionalDetails = additionalDetails;
                        }

                        /** 
                         * Get the 'Fees' element value.
                         * 
                         * @return value
                         */
                        public Fees getFees() {
                            return fees;
                        }

                        /** 
                         * Set the 'Fees' element value.
                         * 
                         * @param fees
                         */
                        public void setFees(Fees fees) {
                            this.fees = fees;
                        }

                        /** 
                         * Get the 'Taxes' element value.
                         * 
                         * @return value
                         */
                        public Taxes getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(Taxes taxes) {
                            this.taxes = taxes;
                        }

                        /** 
                         * Get the 'CancelPenalties' element value.
                         * 
                         * @return value
                         */
                        public CancelPenalties getCancelPenalties() {
                            return cancelPenalties;
                        }

                        /** 
                         * Set the 'CancelPenalties' element value.
                         * 
                         * @param cancelPenalties
                         */
                        public void setCancelPenalties(
                                CancelPenalties cancelPenalties) {
                            this.cancelPenalties = cancelPenalties;
                        }

                        /** 
                         * Get the 'Guarantee' element value.
                         * 
                         * @return value
                         */
                        public Guarantee getGuarantee() {
                            return guarantee;
                        }

                        /** 
                         * Set the 'Guarantee' element value.
                         * 
                         * @param guarantee
                         */
                        public void setGuarantee(Guarantee guarantee) {
                            this.guarantee = guarantee;
                        }

                        /** 
                         * Get the 'Commission' element value.
                         * 
                         * @return value
                         */
                        public Commission getCommission() {
                            return commission;
                        }

                        /** 
                         * Set the 'Commission' element value.
                         * 
                         * @param commission
                         */
                        public void setCommission(Commission commission) {
                            this.commission = commission;
                        }

                        /** 
                         * Get the 'Discounts' element value.
                         * 
                         * @return value
                         */
                        public Discounts getDiscounts() {
                            return discounts;
                        }

                        /** 
                         * Set the 'Discounts' element value.
                         * 
                         * @param discounts
                         */
                        public void setDiscounts(Discounts discounts) {
                            this.discounts = discounts;
                        }

                        /** 
                         * Get the 'AmountBeforeTax' attribute value. ''AmountBeforeTax'' returns the currency amount before tax.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountBeforeTax() {
                            return amountBeforeTax;
                        }

                        /** 
                         * Set the 'AmountBeforeTax' attribute value. ''AmountBeforeTax'' returns the currency amount before tax.
                         * 
                         * @param amountBeforeTax
                         */
                        public void setAmountBeforeTax(
                                BigDecimal amountBeforeTax) {
                            this.amountBeforeTax = amountBeforeTax;
                        }

                        /** 
                         * Get the 'AmountAfterTax' attribute value. ''AmountAfterTax'' returns the currency amount after tax.
                         * 
                         * @return value
                         */
                        public BigDecimal getAmountAfterTax() {
                            return amountAfterTax;
                        }

                        /** 
                         * Set the 'AmountAfterTax' attribute value. ''AmountAfterTax'' returns the currency amount after tax.
                         * 
                         * @param amountAfterTax
                         */
                        public void setAmountAfterTax(BigDecimal amountAfterTax) {
                            this.amountAfterTax = amountAfterTax;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'AppliedDiscount' attribute value. ''AppliedDiscount'' returns the applied discount indicator.
                         * 
                         * @return value
                         */
                        public Boolean getAppliedDiscount() {
                            return appliedDiscount;
                        }

                        /** 
                         * Set the 'AppliedDiscount' attribute value. ''AppliedDiscount'' returns the applied discount indicator.
                         * 
                         * @param appliedDiscount
                         */
                        public void setAppliedDiscount(Boolean appliedDiscount) {
                            this.appliedDiscount = appliedDiscount;
                        }

                        /** 
                         * Get the 'NightlyRate' attribute value. ''NightlyRate'' returns the nightly rate.
                                                                                                Can be avg(5% aprrox) or highest nightly (95% aprrox) rate for GDS.
                         * 
                         * @return value
                         */
                        public BigDecimal getNightlyRate() {
                            return nightlyRate;
                        }

                        /** 
                         * Set the 'NightlyRate' attribute value. ''NightlyRate'' returns the nightly rate.
                                                                                                Can be avg(5% aprrox) or highest nightly (95% aprrox) rate for GDS.
                         * 
                         * @param nightlyRate
                         */
                        public void setNightlyRate(BigDecimal nightlyRate) {
                            this.nightlyRate = nightlyRate;
                        }

                        /** 
                         * Get the 'SupplierChangedAmount' attribute value. ''SupplierChangedAmount'' returns monetary amount charged by the supplier.
                                                                                                If lower amount is returned by the supplier, then it is overwritten in total amount after/before tax.
                         * 
                         * @return value
                         */
                        public BigDecimal getSupplierChangedAmount() {
                            return supplierChangedAmount;
                        }

                        /** 
                         * Set the 'SupplierChangedAmount' attribute value. ''SupplierChangedAmount'' returns monetary amount charged by the supplier.
                                                                                                If lower amount is returned by the supplier, then it is overwritten in total amount after/before tax.
                         * 
                         * @param supplierChangedAmount
                         */
                        public void setSupplierChangedAmount(
                                BigDecimal supplierChangedAmount) {
                            this.supplierChangedAmount = supplierChangedAmount;
                        }

                        /** 
                         * Get the 'Changed' attribute value. ''Changed'' returns the changed indicator.
                                                                                                Returns true if supplier returns higher or lower nightly rate.
                         * 
                         * @return value
                         */
                        public Boolean getChanged() {
                            return changed;
                        }

                        /** 
                         * Set the 'Changed' attribute value. ''Changed'' returns the changed indicator.
                                                                                                Returns true if supplier returns higher or lower nightly rate.
                         * 
                         * @param changed
                         */
                        public void setChanged(Boolean changed) {
                            this.changed = changed;
                        }

                        /** 
                         * Get the 'AdditionalFeesInclusive' attribute value. ''AdditionalFeesInclusive'' returns the additional fees inclusive indicator.
                         * 
                         * @return value
                         */
                        public Boolean getAdditionalFeesInclusive() {
                            return additionalFeesInclusive;
                        }

                        /** 
                         * Set the 'AdditionalFeesInclusive' attribute value. ''AdditionalFeesInclusive'' returns the additional fees inclusive indicator.
                         * 
                         * @param additionalFeesInclusive
                         */
                        public void setAdditionalFeesInclusive(
                                Boolean additionalFeesInclusive) {
                            this.additionalFeesInclusive = additionalFeesInclusive;
                        }

                        /** 
                         * Get the 'TaxInclusive' attribute value. ''TaxInclusive'' returns the tax inclusive indicator.
                         * 
                         * @return value
                         */
                        public Boolean getTaxInclusive() {
                            return taxInclusive;
                        }

                        /** 
                         * Set the 'TaxInclusive' attribute value. ''TaxInclusive'' returns the tax inclusive indicator.
                         * 
                         * @param taxInclusive
                         */
                        public void setTaxInclusive(Boolean taxInclusive) {
                            this.taxInclusive = taxInclusive;
                        }

                        /** 
                         * Get the 'LocalFeesInclusive' attribute value. ''LocalFeesInclusive'' returns the local fees inclusive indicator.
                         * 
                         * @return value
                         */
                        public Boolean getLocalFeesInclusive() {
                            return localFeesInclusive;
                        }

                        /** 
                         * Set the 'LocalFeesInclusive' attribute value. ''LocalFeesInclusive'' returns the local fees inclusive indicator.
                         * 
                         * @param localFeesInclusive
                         */
                        public void setLocalFeesInclusive(
                                Boolean localFeesInclusive) {
                            this.localFeesInclusive = localFeesInclusive;
                        }

                        /** 
                         * Get the 'IncidentalsInclusive' attribute value. ''IncidentalsInclusive'' returns the incidentals inclusive indicator.
                         * 
                         * @return value
                         */
                        public Boolean getIncidentalsInclusive() {
                            return incidentalsInclusive;
                        }

                        /** 
                         * Set the 'IncidentalsInclusive' attribute value. ''IncidentalsInclusive'' returns the incidentals inclusive indicator.
                         * 
                         * @param incidentalsInclusive
                         */
                        public void setIncidentalsInclusive(
                                Boolean incidentalsInclusive) {
                            this.incidentalsInclusive = incidentalsInclusive;
                        }
                        /** 
                         * ''Rates'' returns a collection of nightly rates.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rates" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Rate" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class Rate -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Rates implements Serializable
                        {
                            private List<Rate> rateList = new ArrayList<Rate>();

                            /** 
                             * Get the list of 'Rate' element items.
                             * 
                             * @return list
                             */
                            public List<Rate> getRateList() {
                                return rateList;
                            }

                            /** 
                             * Set the list of 'Rate' element items.
                             * 
                             * @param list
                             */
                            public void setRateList(List<Rate> list) {
                                rateList = list;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rate" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:date" name="StartDate"/>
                             *     &lt;xs:attribute type="xs:date" name="EndDate"/>
                             *     &lt;xs:attribute type="xs:decimal" name="AmountBeforeTax"/>
                             *     &lt;xs:attribute type="xs:decimal" name="AmountAfterTax"/>
                             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Rate implements Serializable
                            {
                                private java.sql.Date startDate;
                                private java.sql.Date endDate;
                                private BigDecimal amountBeforeTax;
                                private BigDecimal amountAfterTax;
                                private String currencyCode;

                                /** 
                                 * Get the 'StartDate' attribute value. ''StartDate'' returns the date from which rate is applicable.
                                 * 
                                 * @return value
                                 */
                                public java.sql.Date getStartDate() {
                                    return startDate;
                                }

                                /** 
                                 * Set the 'StartDate' attribute value. ''StartDate'' returns the date from which rate is applicable.
                                 * 
                                 * @param startDate
                                 */
                                public void setStartDate(java.sql.Date startDate) {
                                    this.startDate = startDate;
                                }

                                /** 
                                 * Get the 'EndDate' attribute value. ''EndDate'' returns the date up to which the rate is applicable.
                                 * 
                                 * @return value
                                 */
                                public java.sql.Date getEndDate() {
                                    return endDate;
                                }

                                /** 
                                 * Set the 'EndDate' attribute value. ''EndDate'' returns the date up to which the rate is applicable.
                                 * 
                                 * @param endDate
                                 */
                                public void setEndDate(java.sql.Date endDate) {
                                    this.endDate = endDate;
                                }

                                /** 
                                 * Get the 'AmountBeforeTax' attribute value. ''AmountBeforeTax'' returns the total amount not including any associated tax (e.g., sales tax, VAT, GST).
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getAmountBeforeTax() {
                                    return amountBeforeTax;
                                }

                                /** 
                                 * Set the 'AmountBeforeTax' attribute value. ''AmountBeforeTax'' returns the total amount not including any associated tax (e.g., sales tax, VAT, GST).
                                 * 
                                 * @param amountBeforeTax
                                 */
                                public void setAmountBeforeTax(
                                        BigDecimal amountBeforeTax) {
                                    this.amountBeforeTax = amountBeforeTax;
                                }

                                /** 
                                 * Get the 'AmountAfterTax' attribute value. ''AmountAfterTax'' returns the total amount including all associated taxes (e.g., sales tax, VAT, GST).
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getAmountAfterTax() {
                                    return amountAfterTax;
                                }

                                /** 
                                 * Set the 'AmountAfterTax' attribute value. ''AmountAfterTax'' returns the total amount including all associated taxes (e.g., sales tax, VAT, GST).
                                 * 
                                 * @param amountAfterTax
                                 */
                                public void setAmountAfterTax(
                                        BigDecimal amountAfterTax) {
                                    this.amountAfterTax = amountAfterTax;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }
                            }
                        }
                        /** 
                         * ''RatePlanDescription'' describes the rate plan.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RatePlanDescription" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class RatePlanDescription implements
                            Serializable
                        {
                            private String text;

                            /** 
                             * Get the 'Text' element value. ''Text'' returns the product description text.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value. ''Text'' returns the product description text.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }
                        }
                        /** 
                         * "AdditionalDetails" returns the list of additional details.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalDetails" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="AdditionalDetail" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class AdditionalDetail -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class AdditionalDetails implements
                            Serializable
                        {
                            private List<AdditionalDetail> additionalDetailList = new ArrayList<AdditionalDetail>();

                            /** 
                             * Get the list of 'AdditionalDetail' element items.
                             * 
                             * @return list
                             */
                            public List<AdditionalDetail> getAdditionalDetailList() {
                                return additionalDetailList;
                            }

                            /** 
                             * Set the list of 'AdditionalDetail' element items.
                             * 
                             * @param list
                             */
                            public void setAdditionalDetailList(
                                    List<AdditionalDetail> list) {
                                additionalDetailList = list;
                            }
                            /** 
                             * "AdditionalDetail" are used for free text relating to check-in/check-out, surcharge and other details.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalDetail" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:int" name="Code"/>
                             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:int" name="GuestCount"/>
                             *     &lt;xs:attribute type="xs:date" name="StartDate"/>
                             *     &lt;xs:attribute type="xs:date" name="EndDate"/>
                             *     &lt;xs:attribute type="xs:int" name="NumberOfNights"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class AdditionalDetail implements
                                Serializable
                            {
                                private List<String> textList = new ArrayList<String>();
                                private Integer code;
                                private BigDecimal amount;
                                private String currencyCode;
                                private Integer guestCount;
                                private java.sql.Date startDate;
                                private java.sql.Date endDate;
                                private Integer numberOfNights;

                                /** 
                                 * Get the list of 'Text' element items. "Text" returns the additional detail description.
                                 * 
                                 * @return list
                                 */
                                public List<String> getTextList() {
                                    return textList;
                                }

                                /** 
                                 * Set the list of 'Text' element items. "Text" returns the additional detail description.
                                 * 
                                 * @param list
                                 */
                                public void setTextList(List<String> list) {
                                    textList = list;
                                }

                                /** 
                                 * Get the 'Code' attribute value. ''Code'' is used to define the type of information being sent (e.g., rate description, property description, room information).
                                                                                                                            Refer to OpenTravel Code List Additional Detail Type (ADT).
                                 * 
                                 * @return value
                                 */
                                public Integer getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value. ''Code'' is used to define the type of information being sent (e.g., rate description, property description, room information).
                                                                                                                            Refer to OpenTravel Code List Additional Detail Type (ADT).
                                 * 
                                 * @param code
                                 */
                                public void setCode(Integer code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(BigDecimal amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'GuestCount' attribute value. ''GuestCount'' indicates the number of guests for whom additional detail is applicable.
                                 * 
                                 * @return value
                                 */
                                public Integer getGuestCount() {
                                    return guestCount;
                                }

                                /** 
                                 * Set the 'GuestCount' attribute value. ''GuestCount'' indicates the number of guests for whom additional detail is applicable.
                                 * 
                                 * @param guestCount
                                 */
                                public void setGuestCount(Integer guestCount) {
                                    this.guestCount = guestCount;
                                }

                                /** 
                                 * Get the 'StartDate' attribute value. ''StartDate'' returns the start date for the additional detail.
                                 * 
                                 * @return value
                                 */
                                public java.sql.Date getStartDate() {
                                    return startDate;
                                }

                                /** 
                                 * Set the 'StartDate' attribute value. ''StartDate'' returns the start date for the additional detail.
                                 * 
                                 * @param startDate
                                 */
                                public void setStartDate(java.sql.Date startDate) {
                                    this.startDate = startDate;
                                }

                                /** 
                                 * Get the 'EndDate' attribute value. ''EndDate'' returns the end date for the additional detail.
                                 * 
                                 * @return value
                                 */
                                public java.sql.Date getEndDate() {
                                    return endDate;
                                }

                                /** 
                                 * Set the 'EndDate' attribute value. ''EndDate'' returns the end date for the additional detail.
                                 * 
                                 * @param endDate
                                 */
                                public void setEndDate(java.sql.Date endDate) {
                                    this.endDate = endDate;
                                }

                                /** 
                                 * Get the 'NumberOfNights' attribute value. ''NumberOfNights'' returns the number of nights included for the additional detail.
                                 * 
                                 * @return value
                                 */
                                public Integer getNumberOfNights() {
                                    return numberOfNights;
                                }

                                /** 
                                 * Set the 'NumberOfNights' attribute value. ''NumberOfNights'' returns the number of nights included for the additional detail.
                                 * 
                                 * @param numberOfNights
                                 */
                                public void setNumberOfNights(
                                        Integer numberOfNights) {
                                    this.numberOfNights = numberOfNights;
                                }
                            }
                        }
                        /** 
                         * ''Fees'' returns a collection of hotel fees.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fees" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Fee" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class Fee -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Fees implements Serializable
                        {
                            private List<Fee> feeList = new ArrayList<Fee>();
                            private BigDecimal amount;
                            private String currencyCode;

                            /** 
                             * Get the list of 'Fee' element items.
                             * 
                             * @return list
                             */
                            public List<Fee> getFeeList() {
                                return feeList;
                            }

                            /** 
                             * Set the list of 'Fee' element items.
                             * 
                             * @param list
                             */
                            public void setFeeList(List<Fee> list) {
                                feeList = list;
                            }

                            /** 
                             * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                             * 
                             * @return value
                             */
                            public BigDecimal getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                             * 
                             * @param amount
                             */
                            public void setAmount(BigDecimal amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }
                            /** 
                             * ''Fee'' returns a single fee.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="FeeDescription" minOccurs="0">
                             *         &lt;!-- Reference to inner class FeeDescription -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:int" name="Code"/>
                             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" name="ApplyAs"/>
                             *     &lt;xs:attribute type="xs:string" name="BasisType"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Fee implements Serializable
                            {
                                private FeeDescription feeDescription;
                                private Integer code;
                                private BigDecimal amount;
                                private String currencyCode;
                                private String applyAs;
                                private String basisType;

                                /** 
                                 * Get the 'FeeDescription' element value.
                                 * 
                                 * @return value
                                 */
                                public FeeDescription getFeeDescription() {
                                    return feeDescription;
                                }

                                /** 
                                 * Set the 'FeeDescription' element value.
                                 * 
                                 * @param feeDescription
                                 */
                                public void setFeeDescription(
                                        FeeDescription feeDescription) {
                                    this.feeDescription = feeDescription;
                                }

                                /** 
                                 * Get the 'Code' attribute value. ''Code'' returns the  code identifying the fee (e.g.,agency fee, municipality fee).
                                                                                                                            Refer to OpenTravel Code List Fee Tax Type (FTT).
                                 * 
                                 * @return value
                                 */
                                public Integer getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value. ''Code'' returns the  code identifying the fee (e.g.,agency fee, municipality fee).
                                                                                                                            Refer to OpenTravel Code List Fee Tax Type (FTT).
                                 * 
                                 * @param code
                                 */
                                public void setCode(Integer code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(BigDecimal amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'ApplyAs' attribute value. ''ApplyAs'' is used to support hotel fee breakdown.
                                                                                                                            Values - Person, Room, Accommodation, House, Apartment, Adult.
                                 * 
                                 * @return value
                                 */
                                public String getApplyAs() {
                                    return applyAs;
                                }

                                /** 
                                 * Set the 'ApplyAs' attribute value. ''ApplyAs'' is used to support hotel fee breakdown.
                                                                                                                            Values - Person, Room, Accommodation, House, Apartment, Adult.
                                 * 
                                 * @param applyAs
                                 */
                                public void setApplyAs(String applyAs) {
                                    this.applyAs = applyAs;
                                }

                                /** 
                                 * Get the 'BasisType' attribute value. ''BasisType'' is used to support hotel fee breakdown.
                                                                                                                            Values - Night, Day, Stay, Week.
                                 * 
                                 * @return value
                                 */
                                public String getBasisType() {
                                    return basisType;
                                }

                                /** 
                                 * Set the 'BasisType' attribute value. ''BasisType'' is used to support hotel fee breakdown.
                                                                                                                            Values - Night, Day, Stay, Week.
                                 * 
                                 * @param basisType
                                 */
                                public void setBasisType(String basisType) {
                                    this.basisType = basisType;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeDescription" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class FeeDescription implements
                                    Serializable
                                {
                                    private String text;

                                    /** 
                                     * Get the 'Text' element value. ''Text'' returns the fee description text.
                                     * 
                                     * @return value
                                     */
                                    public String getText() {
                                        return text;
                                    }

                                    /** 
                                     * Set the 'Text' element value. ''Text'' returns the fee description text.
                                     * 
                                     * @param text
                                     */
                                    public void setText(String text) {
                                        this.text = text;
                                    }
                                }
                            }
                        }
                        /** 
                         * ''Taxes'' returns a collection of taxes.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class Tax -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:int" name="Code"/>
                         *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Taxes implements Serializable
                        {
                            private List<Tax> taxList = new ArrayList<Tax>();
                            private Integer code;
                            private BigDecimal amount;
                            private String currencyCode;

                            /** 
                             * Get the list of 'Tax' element items.
                             * 
                             * @return list
                             */
                            public List<Tax> getTaxList() {
                                return taxList;
                            }

                            /** 
                             * Set the list of 'Tax' element items.
                             * 
                             * @param list
                             */
                            public void setTaxList(List<Tax> list) {
                                taxList = list;
                            }

                            /** 
                             * Get the 'Code' attribute value. ''Code'' returns a tax code identifying the tax from open travel code list fee tax type (FIT).
                             * 
                             * @return value
                             */
                            public Integer getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. ''Code'' returns a tax code identifying the tax from open travel code list fee tax type (FIT).
                             * 
                             * @param code
                             */
                            public void setCode(Integer code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                             * 
                             * @return value
                             */
                            public BigDecimal getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                             * 
                             * @param amount
                             */
                            public void setAmount(BigDecimal amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="TaxDescription">
                             *         &lt;xs:complexType>
                             *           &lt;xs:sequence>
                             *             &lt;xs:element type="xs:string" name="Text"/>
                             *           &lt;/xs:sequence>
                             *         &lt;/xs:complexType>
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" name="Code"/>
                             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Tax implements Serializable
                            {
                                private String taxDescription;
                                private String code;
                                private BigDecimal amount;
                                private String currencyCode;

                                /** 
                                 * Get the 'Text' element value. ''Text'' returns the tax description text.
                                 * 
                                 * @return value
                                 */
                                public String getTaxDescription() {
                                    return taxDescription;
                                }

                                /** 
                                 * Set the 'Text' element value. ''Text'' returns the tax description text.
                                 * 
                                 * @param taxDescription
                                 */
                                public void setTaxDescription(
                                        String taxDescription) {
                                    this.taxDescription = taxDescription;
                                }

                                /** 
                                 * Get the 'Code' attribute value. ''Code'' returns a tax code identifying the tax from open travel code list fee tax type (FIT).
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value. ''Code'' returns a tax code identifying the tax from open travel code list fee tax type (FIT).
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(BigDecimal amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }
                            }
                        }
                        /** 
                         * ''CancelPenalties'' returns a collection of cancellation penalties.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPenalties" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="CancelPenalty" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class CancelPenalty -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CancelPenalties implements
                            Serializable
                        {
                            private List<CancelPenalty> cancelPenaltyList = new ArrayList<CancelPenalty>();

                            /** 
                             * Get the list of 'CancelPenalty' element items.
                             * 
                             * @return list
                             */
                            public List<CancelPenalty> getCancelPenaltyList() {
                                return cancelPenaltyList;
                            }

                            /** 
                             * Set the list of 'CancelPenalty' element items.
                             * 
                             * @param list
                             */
                            public void setCancelPenaltyList(
                                    List<CancelPenalty> list) {
                                cancelPenaltyList = list;
                            }
                            /** 
                             * ''CancelPenalty'' provides details about penalties that will be applied when products are canceled.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPenalty" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="Deadline" minOccurs="0">
                             *         &lt;!-- Reference to inner class Deadline -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="AmountPercent" minOccurs="0">
                             *         &lt;!-- Reference to inner class AmountPercent -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="PenaltyDescription" minOccurs="0">
                             *         &lt;!-- Reference to inner class PenaltyDescription -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:boolean" name="Refundable"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class CancelPenalty implements
                                Serializable
                            {
                                private Deadline deadline;
                                private AmountPercent amountPercent;
                                private PenaltyDescription penaltyDescription;
                                private Boolean refundable;

                                /** 
                                 * Get the 'Deadline' element value.
                                 * 
                                 * @return value
                                 */
                                public Deadline getDeadline() {
                                    return deadline;
                                }

                                /** 
                                 * Set the 'Deadline' element value.
                                 * 
                                 * @param deadline
                                 */
                                public void setDeadline(Deadline deadline) {
                                    this.deadline = deadline;
                                }

                                /** 
                                 * Get the 'AmountPercent' element value.
                                 * 
                                 * @return value
                                 */
                                public AmountPercent getAmountPercent() {
                                    return amountPercent;
                                }

                                /** 
                                 * Set the 'AmountPercent' element value.
                                 * 
                                 * @param amountPercent
                                 */
                                public void setAmountPercent(
                                        AmountPercent amountPercent) {
                                    this.amountPercent = amountPercent;
                                }

                                /** 
                                 * Get the 'PenaltyDescription' element value.
                                 * 
                                 * @return value
                                 */
                                public PenaltyDescription getPenaltyDescription() {
                                    return penaltyDescription;
                                }

                                /** 
                                 * Set the 'PenaltyDescription' element value.
                                 * 
                                 * @param penaltyDescription
                                 */
                                public void setPenaltyDescription(
                                        PenaltyDescription penaltyDescription) {
                                    this.penaltyDescription = penaltyDescription;
                                }

                                /** 
                                 * Get the 'Refundable' attribute value. ''Refundable'' specifies whether amount is refundable when booking is canceled.
                                 * 
                                 * @return value
                                 */
                                public Boolean getRefundable() {
                                    return refundable;
                                }

                                /** 
                                 * Set the 'Refundable' attribute value. ''Refundable'' specifies whether amount is refundable when booking is canceled.
                                 * 
                                 * @param refundable
                                 */
                                public void setRefundable(Boolean refundable) {
                                    this.refundable = refundable;
                                }
                                /** 
                                 * ''Deadline'' returns the cancellation deadline, absolute or relative.
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deadline" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:dateTime" name="AbsoluteDeadline"/>
                                 *     &lt;xs:attribute type="xs:string" name="OffsetDropTime"/>
                                 *     &lt;xs:attribute type="xs:string" name="OffsetTimeUnit"/>
                                 *     &lt;xs:attribute type="xs:string" name="OffsetUnitMultiplier"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Deadline implements
                                    Serializable
                                {
                                    private Date absoluteDeadline;
                                    private String offsetDropTime;
                                    private String offsetTimeUnit;
                                    private String offsetUnitMultiplier;

                                    /** 
                                     * Get the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' defines the absolute deadline.
                                                                                                                                          Either this or the offset attributes may be used.
                                     * 
                                     * @return value
                                     */
                                    public Date getAbsoluteDeadline() {
                                        return absoluteDeadline;
                                    }

                                    /** 
                                     * Set the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' defines the absolute deadline.
                                                                                                                                          Either this or the offset attributes may be used.
                                     * 
                                     * @param absoluteDeadline
                                     */
                                    public void setAbsoluteDeadline(
                                            Date absoluteDeadline) {
                                        this.absoluteDeadline = absoluteDeadline;
                                    }

                                    /** 
                                     * Get the 'OffsetDropTime' attribute value. ''OffsetDropTime'' indicates when the deadline drop time goes into effect (BeforeArrival, AfterBooking, AfterConfirmation, AfterArrival, AfterDeparture).
                                     * 
                                     * @return value
                                     */
                                    public String getOffsetDropTime() {
                                        return offsetDropTime;
                                    }

                                    /** 
                                     * Set the 'OffsetDropTime' attribute value. ''OffsetDropTime'' indicates when the deadline drop time goes into effect (BeforeArrival, AfterBooking, AfterConfirmation, AfterArrival, AfterDeparture).
                                     * 
                                     * @param offsetDropTime
                                     */
                                    public void setOffsetDropTime(
                                            String offsetDropTime) {
                                        this.offsetDropTime = offsetDropTime;
                                    }

                                    /** 
                                     * Get the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                                     * 
                                     * @return value
                                     */
                                    public String getOffsetTimeUnit() {
                                        return offsetTimeUnit;
                                    }

                                    /** 
                                     * Set the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                                     * 
                                     * @param offsetTimeUnit
                                     */
                                    public void setOffsetTimeUnit(
                                            String offsetTimeUnit) {
                                        this.offsetTimeUnit = offsetTimeUnit;
                                    }

                                    /** 
                                     * Get the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of DeadlineTimeUnit.
                                     * 
                                     * @return value
                                     */
                                    public String getOffsetUnitMultiplier() {
                                        return offsetUnitMultiplier;
                                    }

                                    /** 
                                     * Set the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of DeadlineTimeUnit.
                                     * 
                                     * @param offsetUnitMultiplier
                                     */
                                    public void setOffsetUnitMultiplier(
                                            String offsetUnitMultiplier) {
                                        this.offsetUnitMultiplier = offsetUnitMultiplier;
                                    }
                                }
                                /** 
                                 * ''AmountPercent'' returns the cancellation fee expressed as a fixed amount, or percentage of room nights.
                                                                                                                                Defines the percentage basis for calculating the fee amount or the amount.
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AmountPercent" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:boolean" name="TaxInclusive"/>
                                 *     &lt;xs:attribute type="xs:boolean" name="FeesInclusive"/>
                                 *     &lt;xs:attribute type="xs:int" name="NmbrOfNights"/>
                                 *     &lt;xs:attribute type="xs:string" name="BasisType"/>
                                 *     &lt;xs:attribute type="xs:decimal" name="Percent"/>
                                 *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                                 *     &lt;xs:attribute type="xs:string" name="ApplyAs"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class AmountPercent implements
                                    Serializable
                                {
                                    private Boolean taxInclusive;
                                    private Boolean feesInclusive;
                                    private Integer nmbrOfNights;
                                    private String basisType;
                                    private BigDecimal percent;
                                    private BigDecimal amount;
                                    private String currencyCode;
                                    private String applyAs;

                                    /** 
                                     * Get the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                                     * 
                                     * @return value
                                     */
                                    public Boolean getTaxInclusive() {
                                        return taxInclusive;
                                    }

                                    /** 
                                     * Set the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                                     * 
                                     * @param taxInclusive
                                     */
                                    public void setTaxInclusive(
                                            Boolean taxInclusive) {
                                        this.taxInclusive = taxInclusive;
                                    }

                                    /** 
                                     * Get the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating cancel penalties.
                                     * 
                                     * @return value
                                     */
                                    public Boolean getFeesInclusive() {
                                        return feesInclusive;
                                    }

                                    /** 
                                     * Set the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating cancel penalties.
                                     * 
                                     * @param feesInclusive
                                     */
                                    public void setFeesInclusive(
                                            Boolean feesInclusive) {
                                        this.feesInclusive = feesInclusive;
                                    }

                                    /** 
                                     * Get the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the penalty amount.
                                     * 
                                     * @return value
                                     */
                                    public Integer getNmbrOfNights() {
                                        return nmbrOfNights;
                                    }

                                    /** 
                                     * Set the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the penalty amount.
                                     * 
                                     * @param nmbrOfNights
                                     */
                                    public void setNmbrOfNights(
                                            Integer nmbrOfNights) {
                                        this.nmbrOfNights = nmbrOfNights;
                                    }

                                    /** 
                                     * Get the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the cancellation penalty is calculated.
                                     * 
                                     * @return value
                                     */
                                    public String getBasisType() {
                                        return basisType;
                                    }

                                    /** 
                                     * Set the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the cancellation penalty is calculated.
                                     * 
                                     * @param basisType
                                     */
                                    public void setBasisType(String basisType) {
                                        this.basisType = basisType;
                                    }

                                    /** 
                                     * Get the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                                     * 
                                     * @return value
                                     */
                                    public BigDecimal getPercent() {
                                        return percent;
                                    }

                                    /** 
                                     * Set the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                                     * 
                                     * @param percent
                                     */
                                    public void setPercent(BigDecimal percent) {
                                        this.percent = percent;
                                    }

                                    /** 
                                     * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                     * 
                                     * @return value
                                     */
                                    public BigDecimal getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(BigDecimal amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }

                                    /** 
                                     * Get the 'ApplyAs' attribute value. ''ApplyAs'' is used to specify how the amount needs to be applied with respect to the stay.
                                     * 
                                     * @return value
                                     */
                                    public String getApplyAs() {
                                        return applyAs;
                                    }

                                    /** 
                                     * Set the 'ApplyAs' attribute value. ''ApplyAs'' is used to specify how the amount needs to be applied with respect to the stay.
                                     * 
                                     * @param applyAs
                                     */
                                    public void setApplyAs(String applyAs) {
                                        this.applyAs = applyAs;
                                    }
                                }
                                /** 
                                 * ''PenaltyDescription'' returns the penalty description.
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyDescription" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element type="xs:string" name="Text"/>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class PenaltyDescription
                                    implements Serializable
                                {
                                    private String text;

                                    /** 
                                     * Get the 'Text' element value. ''Text'' returns the penalty description text.
                                     * 
                                     * @return value
                                     */
                                    public String getText() {
                                        return text;
                                    }

                                    /** 
                                     * Set the 'Text' element value. ''Text'' returns the penalty description text.
                                     * 
                                     * @param text
                                     */
                                    public void setText(String text) {
                                        this.text = text;
                                    }
                                }
                            }
                        }
                        /** 
                         * ''Guarantee'' returns the guarantee information that applies to the rate plan.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guarantee" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="GuaranteesAccepted" minOccurs="0">
                         *         &lt;!-- Reference to inner class GuaranteesAccepted -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Deadline" minOccurs="0">
                         *         &lt;!-- Reference to inner class Deadline -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="AmountPercent" minOccurs="0">
                         *         &lt;!-- Reference to inner class AmountPercent -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="GuaranteeDescription" minOccurs="0">
                         *         &lt;!-- Reference to inner class GuaranteeDescription -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" name="GuaranteeType"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Guarantee implements Serializable
                        {
                            private GuaranteesAccepted guaranteesAccepted;
                            private Deadline deadline;
                            private AmountPercent amountPercent;
                            private GuaranteeDescription guaranteeDescription;
                            private String guaranteeType;

                            /** 
                             * Get the 'GuaranteesAccepted' element value.
                             * 
                             * @return value
                             */
                            public GuaranteesAccepted getGuaranteesAccepted() {
                                return guaranteesAccepted;
                            }

                            /** 
                             * Set the 'GuaranteesAccepted' element value.
                             * 
                             * @param guaranteesAccepted
                             */
                            public void setGuaranteesAccepted(
                                    GuaranteesAccepted guaranteesAccepted) {
                                this.guaranteesAccepted = guaranteesAccepted;
                            }

                            /** 
                             * Get the 'Deadline' element value.
                             * 
                             * @return value
                             */
                            public Deadline getDeadline() {
                                return deadline;
                            }

                            /** 
                             * Set the 'Deadline' element value.
                             * 
                             * @param deadline
                             */
                            public void setDeadline(Deadline deadline) {
                                this.deadline = deadline;
                            }

                            /** 
                             * Get the 'AmountPercent' element value.
                             * 
                             * @return value
                             */
                            public AmountPercent getAmountPercent() {
                                return amountPercent;
                            }

                            /** 
                             * Set the 'AmountPercent' element value.
                             * 
                             * @param amountPercent
                             */
                            public void setAmountPercent(
                                    AmountPercent amountPercent) {
                                this.amountPercent = amountPercent;
                            }

                            /** 
                             * Get the 'GuaranteeDescription' element value.
                             * 
                             * @return value
                             */
                            public GuaranteeDescription getGuaranteeDescription() {
                                return guaranteeDescription;
                            }

                            /** 
                             * Set the 'GuaranteeDescription' element value.
                             * 
                             * @param guaranteeDescription
                             */
                            public void setGuaranteeDescription(
                                    GuaranteeDescription guaranteeDescription) {
                                this.guaranteeDescription = guaranteeDescription;
                            }

                            /** 
                             * Get the 'GuaranteeType' attribute value. ''GuaranteeType'' defines the guarantee to be applied to this reservation.
                             * 
                             * @return value
                             */
                            public String getGuaranteeType() {
                                return guaranteeType;
                            }

                            /** 
                             * Set the 'GuaranteeType' attribute value. ''GuaranteeType'' defines the guarantee to be applied to this reservation.
                             * 
                             * @param guaranteeType
                             */
                            public void setGuaranteeType(String guaranteeType) {
                                this.guaranteeType = guaranteeType;
                            }
                            /** 
                             * ''GuaranteesAccepted'' returns a collection of guarantees accepted.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteesAccepted" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="GuaranteeAccepted" maxOccurs="unbounded">
                             *         &lt;!-- Reference to inner class GuaranteeAccepted -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class GuaranteesAccepted implements
                                Serializable
                            {
                                private List<GuaranteeAccepted> guaranteeAcceptedList = new ArrayList<GuaranteeAccepted>();

                                /** 
                                 * Get the list of 'GuaranteeAccepted' element items.
                                 * 
                                 * @return list
                                 */
                                public List<GuaranteeAccepted> getGuaranteeAcceptedList() {
                                    return guaranteeAcceptedList;
                                }

                                /** 
                                 * Set the list of 'GuaranteeAccepted' element items.
                                 * 
                                 * @param list
                                 */
                                public void setGuaranteeAcceptedList(
                                        List<GuaranteeAccepted> list) {
                                    guaranteeAcceptedList = list;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteeAccepted" maxOccurs="unbounded">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="PaymentCards" minOccurs="0">
                                 *         &lt;!-- Reference to inner class PaymentCards -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *     &lt;xs:attribute type="xs:int" name="GuaranteeTypeCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class GuaranteeAccepted implements
                                    Serializable
                                {
                                    private PaymentCards paymentCards;
                                    private Integer guaranteeTypeCode;

                                    /** 
                                     * Get the 'PaymentCards' element value.
                                     * 
                                     * @return value
                                     */
                                    public PaymentCards getPaymentCards() {
                                        return paymentCards;
                                    }

                                    /** 
                                     * Set the 'PaymentCards' element value.
                                     * 
                                     * @param paymentCards
                                     */
                                    public void setPaymentCards(
                                            PaymentCards paymentCards) {
                                        this.paymentCards = paymentCards;
                                    }

                                    /** 
                                     * Get the 'GuaranteeTypeCode' attribute value. ''GuaranteeTypeCode'' is used to specify the method of guarantee.
                                                                                                                                          Refer to open travel code list payment type (PMT).
                                     * 
                                     * @return value
                                     */
                                    public Integer getGuaranteeTypeCode() {
                                        return guaranteeTypeCode;
                                    }

                                    /** 
                                     * Set the 'GuaranteeTypeCode' attribute value. ''GuaranteeTypeCode'' is used to specify the method of guarantee.
                                                                                                                                          Refer to open travel code list payment type (PMT).
                                     * 
                                     * @param guaranteeTypeCode
                                     */
                                    public void setGuaranteeTypeCode(
                                            Integer guaranteeTypeCode) {
                                        this.guaranteeTypeCode = guaranteeTypeCode;
                                    }
                                    /** 
                                     * ''PaymentCards'' specifies the cards, like credit card or debit card which were used to pay.
                                     * 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCards" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="PaymentCard" maxOccurs="unbounded">
                                     *         &lt;!-- Reference to inner class PaymentCard -->
                                     *       &lt;/xs:element>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class PaymentCards implements
                                        Serializable
                                    {
                                        private List<PaymentCard> paymentCardList = new ArrayList<PaymentCard>();

                                        /** 
                                         * Get the list of 'PaymentCard' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<PaymentCard> getPaymentCardList() {
                                            return paymentCardList;
                                        }

                                        /** 
                                         * Set the list of 'PaymentCard' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setPaymentCardList(
                                                List<PaymentCard> list) {
                                            paymentCardList = list;
                                        }
                                        /** 
                                         * ''PaymentCard'' specifies the card name.
                                         * 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" maxOccurs="unbounded">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:simpleContent>
                                         *       &lt;xs:extension base="xs:string">
                                         *         &lt;xs:attribute type="xs:string" use="required" name="CardCode"/>
                                         *       &lt;/xs:extension>
                                         *     &lt;/xs:simpleContent>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class PaymentCard
                                            implements Serializable
                                        {
                                            private String string;
                                            private String cardCode;

                                            /** 
                                             * Get the extension value.
                                             * 
                                             * @return value
                                             */
                                            public String getString() {
                                                return string;
                                            }

                                            /** 
                                             * Set the extension value.
                                             * 
                                             * @param string
                                             */
                                            public void setString(String string) {
                                                this.string = string;
                                            }

                                            /** 
                                             * Get the 'CardCode' attribute value. ''CardCode'' returns the code identifying the card type (AX, BC, BL, CB, DN etc).
                                             * 
                                             * @return value
                                             */
                                            public String getCardCode() {
                                                return cardCode;
                                            }

                                            /** 
                                             * Set the 'CardCode' attribute value. ''CardCode'' returns the code identifying the card type (AX, BC, BL, CB, DN etc).
                                             * 
                                             * @param cardCode
                                             */
                                            public void setCardCode(
                                                    String cardCode) {
                                                this.cardCode = cardCode;
                                            }
                                        }
                                    }
                                }
                            }
                            /** 
                             * ''Deadline'' returns the guarantee deadline, absolute or relative.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deadline" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" name="AbsoluteDeadline"/>
                             *     &lt;xs:attribute type="xs:string" name="OffsetTimeUnit"/>
                             *     &lt;xs:attribute type="xs:string" name="OffsetUnitMultiplier"/>
                             *     &lt;xs:attribute type="xs:string" name="OffsetDropTime"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Deadline implements
                                Serializable
                            {
                                private String absoluteDeadline;
                                private String offsetTimeUnit;
                                private String offsetUnitMultiplier;
                                private String offsetDropTime;

                                /** 
                                 * Get the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' returns the absolute deadline.
                                                                                                                            Either this or the offset attributes may be used.
                                 * 
                                 * @return value
                                 */
                                public String getAbsoluteDeadline() {
                                    return absoluteDeadline;
                                }

                                /** 
                                 * Set the 'AbsoluteDeadline' attribute value. ''AbsoluteDeadline'' returns the absolute deadline.
                                                                                                                            Either this or the offset attributes may be used.
                                 * 
                                 * @param absoluteDeadline
                                 */
                                public void setAbsoluteDeadline(
                                        String absoluteDeadline) {
                                    this.absoluteDeadline = absoluteDeadline;
                                }

                                /** 
                                 * Get the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                                 * 
                                 * @return value
                                 */
                                public String getOffsetTimeUnit() {
                                    return offsetTimeUnit;
                                }

                                /** 
                                 * Set the 'OffsetTimeUnit' attribute value. ''OffsetTimeUnit'' returns the units of time, e.g.: days, hours, etc., that apply to the deadline.
                                 * 
                                 * @param offsetTimeUnit
                                 */
                                public void setOffsetTimeUnit(
                                        String offsetTimeUnit) {
                                    this.offsetTimeUnit = offsetTimeUnit;
                                }

                                /** 
                                 * Get the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of ''OffsetTimeUnit''.
                                 * 
                                 * @return value
                                 */
                                public String getOffsetUnitMultiplier() {
                                    return offsetUnitMultiplier;
                                }

                                /** 
                                 * Set the 'OffsetUnitMultiplier' attribute value. ''OffsetUnitMultiplier'' returns the number of units of ''OffsetTimeUnit''.
                                 * 
                                 * @param offsetUnitMultiplier
                                 */
                                public void setOffsetUnitMultiplier(
                                        String offsetUnitMultiplier) {
                                    this.offsetUnitMultiplier = offsetUnitMultiplier;
                                }

                                /** 
                                 * Get the 'OffsetDropTime' attribute value. ''OffsetDropTime'' indicates when the deadline drop time goes into effect (BeforeArrival, AfterBooking, AfterConfirmation, AfterArrival, AfterDeparture).
                                 * 
                                 * @return value
                                 */
                                public String getOffsetDropTime() {
                                    return offsetDropTime;
                                }

                                /** 
                                 * Set the 'OffsetDropTime' attribute value. ''OffsetDropTime'' indicates when the deadline drop time goes into effect (BeforeArrival, AfterBooking, AfterConfirmation, AfterArrival, AfterDeparture).
                                 * 
                                 * @param offsetDropTime
                                 */
                                public void setOffsetDropTime(
                                        String offsetDropTime) {
                                    this.offsetDropTime = offsetDropTime;
                                }
                            }
                            /** 
                             * ''AmountPercent'' returns the guarantee expressed as a fixed amount, or percentage of room nights.
                                                                                                                  Defines the percentage basis for calculating the guarantee amount.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AmountPercent" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:boolean" name="TaxInclusive"/>
                             *     &lt;xs:attribute type="xs:boolean" name="FeesInclusive"/>
                             *     &lt;xs:attribute type="xs:int" name="NmbrOfNights"/>
                             *     &lt;xs:attribute type="xs:string" name="BasisType"/>
                             *     &lt;xs:attribute type="xs:decimal" name="Percent"/>
                             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" name="ApplyAs"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class AmountPercent implements
                                Serializable
                            {
                                private Boolean taxInclusive;
                                private Boolean feesInclusive;
                                private Integer nmbrOfNights;
                                private String basisType;
                                private BigDecimal percent;
                                private BigDecimal amount;
                                private String currencyCode;
                                private String applyAs;

                                /** 
                                 * Get the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                                 * 
                                 * @return value
                                 */
                                public Boolean getTaxInclusive() {
                                    return taxInclusive;
                                }

                                /** 
                                 * Set the 'TaxInclusive' attribute value. ''TaxInclusive'' indicates whether taxes are included when calculating the base amount.
                                 * 
                                 * @param taxInclusive
                                 */
                                public void setTaxInclusive(Boolean taxInclusive) {
                                    this.taxInclusive = taxInclusive;
                                }

                                /** 
                                 * Get the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating the guarantee amount.
                                 * 
                                 * @return value
                                 */
                                public Boolean getFeesInclusive() {
                                    return feesInclusive;
                                }

                                /** 
                                 * Set the 'FeesInclusive' attribute value. ''FeesInclusive'' indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when calculating the guarantee amount.
                                 * 
                                 * @param feesInclusive
                                 */
                                public void setFeesInclusive(
                                        Boolean feesInclusive) {
                                    this.feesInclusive = feesInclusive;
                                }

                                /** 
                                 * Get the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the guarantee amount.
                                 * 
                                 * @return value
                                 */
                                public Integer getNmbrOfNights() {
                                    return nmbrOfNights;
                                }

                                /** 
                                 * Set the 'NmbrOfNights' attribute value. ''NmbrOfNights'' returns the number of nights of the hotel stay that are used to calculate the guarantee amount.
                                 * 
                                 * @param nmbrOfNights
                                 */
                                public void setNmbrOfNights(Integer nmbrOfNights) {
                                    this.nmbrOfNights = nmbrOfNights;
                                }

                                /** 
                                 * Get the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the guarantee amount is calculated.
                                 * 
                                 * @return value
                                 */
                                public String getBasisType() {
                                    return basisType;
                                }

                                /** 
                                 * Set the 'BasisType' attribute value. ''BasisType'' provides the basis for how the amount of the guarantee amount is calculated.
                                 * 
                                 * @param basisType
                                 */
                                public void setBasisType(String basisType) {
                                    this.basisType = basisType;
                                }

                                /** 
                                 * Get the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getPercent() {
                                    return percent;
                                }

                                /** 
                                 * Set the 'Percent' attribute value. ''Percent'' returns the percentage used to calculate the amount.
                                 * 
                                 * @param percent
                                 */
                                public void setPercent(BigDecimal percent) {
                                    this.percent = percent;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(BigDecimal amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'ApplyAs' attribute value. ''ApplyAs'' is used to specify how the amount needs to be applied with respect to the stay.
                                 * 
                                 * @return value
                                 */
                                public String getApplyAs() {
                                    return applyAs;
                                }

                                /** 
                                 * Set the 'ApplyAs' attribute value. ''ApplyAs'' is used to specify how the amount needs to be applied with respect to the stay.
                                 * 
                                 * @param applyAs
                                 */
                                public void setApplyAs(String applyAs) {
                                    this.applyAs = applyAs;
                                }
                            }
                            /** 
                             * ''GuaranteeDescription'' returns the guarantee description.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteeDescription" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Text"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class GuaranteeDescription implements
                                Serializable
                            {
                                private String text;

                                /** 
                                 * Get the 'Text' element value. ''Text'' returns the guarantee description text.
                                 * 
                                 * @return value
                                 */
                                public String getText() {
                                    return text;
                                }

                                /** 
                                 * Set the 'Text' element value. ''Text'' returns the guarantee description text.
                                 * 
                                 * @param text
                                 */
                                public void setText(String text) {
                                    this.text = text;
                                }
                            }
                        }
                        /** 
                         * ''Commission'' returns commission information.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="CommissionDescription" minOccurs="0">
                         *         &lt;!-- Reference to inner class CommissionDescription -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:boolean" name="CommissionIndicator"/>
                         *     &lt;xs:attribute type="xs:decimal" name="Percent"/>
                         *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                         *     &lt;xs:attribute type="xs:string" name="Type"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Commission implements Serializable
                        {
                            private CommissionDescription commissionDescription;
                            private Boolean commissionIndicator;
                            private BigDecimal percent;
                            private BigDecimal amount;
                            private String currencyCode;
                            private String type;

                            /** 
                             * Get the 'CommissionDescription' element value.
                             * 
                             * @return value
                             */
                            public CommissionDescription getCommissionDescription() {
                                return commissionDescription;
                            }

                            /** 
                             * Set the 'CommissionDescription' element value.
                             * 
                             * @param commissionDescription
                             */
                            public void setCommissionDescription(
                                    CommissionDescription commissionDescription) {
                                this.commissionDescription = commissionDescription;
                            }

                            /** 
                             * Get the 'CommissionIndicator' attribute value. ''CommissionIndicator'' returns the commission indicator.
                             * 
                             * @return value
                             */
                            public Boolean getCommissionIndicator() {
                                return commissionIndicator;
                            }

                            /** 
                             * Set the 'CommissionIndicator' attribute value. ''CommissionIndicator'' returns the commission indicator.
                             * 
                             * @param commissionIndicator
                             */
                            public void setCommissionIndicator(
                                    Boolean commissionIndicator) {
                                this.commissionIndicator = commissionIndicator;
                            }

                            /** 
                             * Get the 'Percent' attribute value. ''Percent'' returns the percent applied to the commissionable amount to determine the commission payable amount.
                             * 
                             * @return value
                             */
                            public BigDecimal getPercent() {
                                return percent;
                            }

                            /** 
                             * Set the 'Percent' attribute value. ''Percent'' returns the percent applied to the commissionable amount to determine the commission payable amount.
                             * 
                             * @param percent
                             */
                            public void setPercent(BigDecimal percent) {
                                this.percent = percent;
                            }

                            /** 
                             * Get the 'Amount' attribute value. ''Amount'' returns the commissionable amount.
                             * 
                             * @return value
                             */
                            public BigDecimal getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. ''Amount'' returns the commissionable amount.
                             * 
                             * @param amount
                             */
                            public void setAmount(BigDecimal amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'Type' attribute value. ''Type'' returns commission type.
                                                                                                              Type can be `None` or `Variable`.
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value. ''Type'' returns commission type.
                                                                                                              Type can be `None` or `Variable`.
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }
                            /** 
                             * ''CommissionDescription'' returns description of commission.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionDescription" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Text"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class CommissionDescription implements
                                Serializable
                            {
                                private String text;

                                /** 
                                 * Get the 'Text' element value. ''Text'' returns commission description text.
                                 * 
                                 * @return value
                                 */
                                public String getText() {
                                    return text;
                                }

                                /** 
                                 * Set the 'Text' element value. ''Text'' returns commission description text.
                                 * 
                                 * @param text
                                 */
                                public void setText(String text) {
                                    this.text = text;
                                }
                            }
                        }
                        /** 
                         * ''Discounts'' returns a list of discounts.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discounts" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Discount" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class Discount -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Discounts implements Serializable
                        {
                            private List<Discount> discountList = new ArrayList<Discount>();

                            /** 
                             * Get the list of 'Discount' element items.
                             * 
                             * @return list
                             */
                            public List<Discount> getDiscountList() {
                                return discountList;
                            }

                            /** 
                             * Set the list of 'Discount' element items.
                             * 
                             * @param list
                             */
                            public void setDiscountList(List<Discount> list) {
                                discountList = list;
                            }
                            /** 
                             * ''Discount'' describes a discount in a room rate.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" name="Name"/>
                             *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Discount implements
                                Serializable
                            {
                                private String code;
                                private String name;
                                private BigDecimal amount;
                                private String currencyCode;

                                /** 
                                 * Get the 'Code' attribute value. ''Code'' returns the discount code.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value. ''Code'' returns the discount code.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Name' attribute value. ''Name'' returns the discount name.
                                 * 
                                 * @return value
                                 */
                                public String getName() {
                                    return name;
                                }

                                /** 
                                 * Set the 'Name' attribute value. ''Name'' returns the discount name.
                                 * 
                                 * @param name
                                 */
                                public void setName(String name) {
                                    this.name = name;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @return value
                                 */
                                public BigDecimal getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. ''Amount'' returns a monetary amount.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(BigDecimal amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. ''CurrencyCode'' returns an ISO 4217 (3) alpha character code that specifies a monetary unit.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }
                            }
                        }
                    }
                }
                /** 
                 * ''ValueAdds'' returns value adds returned for EAN booking.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValueAdds" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="ValueAdd" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class ValueAdd -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValueAdds implements Serializable
                {
                    private List<ValueAdd> valueAddList = new ArrayList<ValueAdd>();

                    /** 
                     * Get the list of 'ValueAdd' element items.
                     * 
                     * @return list
                     */
                    public List<ValueAdd> getValueAddList() {
                        return valueAddList;
                    }

                    /** 
                     * Set the list of 'ValueAdd' element items.
                     * 
                     * @param list
                     */
                    public void setValueAddList(List<ValueAdd> list) {
                        valueAddList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValueAdd" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ValueAdd implements Serializable
                    {
                        private List<String> texts = new ArrayList<String>();

                        /** 
                         * Get the list of 'Text' element items.
                         * 
                         * @return list
                         */
                        public List<String> getTexts() {
                            return texts;
                        }

                        /** 
                         * Set the list of 'Text' element items.
                         * 
                         * @param list
                         */
                        public void setTexts(List<String> list) {
                            texts = list;
                        }
                    }
                }
                /** 
                 * ''SpecialInstructions'' returns free form or GTA special instructions.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialInstructions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="SpecialInstruction" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SpecialInstructions implements Serializable
                {
                    private List<String> specialInstructionList = new ArrayList<String>();

                    /** 
                     * Get the list of 'SpecialInstruction' element items. ''SpecialInstruction'' returns special instruction.
                     * 
                     * @return list
                     */
                    public List<String> getSpecialInstructionList() {
                        return specialInstructionList;
                    }

                    /** 
                     * Set the list of 'SpecialInstruction' element items. ''SpecialInstruction'' returns special instruction.
                     * 
                     * @param list
                     */
                    public void setSpecialInstructionList(List<String> list) {
                        specialInstructionList = list;
                    }
                }
                /** 
                 * ''SearchParameters'' returns search parameters.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchParameters" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="SearchParameter" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class SearchParameter -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SearchParameters implements Serializable
                {
                    private List<SearchParameter> searchParameterList = new ArrayList<SearchParameter>();

                    /** 
                     * Get the list of 'SearchParameter' element items.
                     * 
                     * @return list
                     */
                    public List<SearchParameter> getSearchParameterList() {
                        return searchParameterList;
                    }

                    /** 
                     * Set the list of 'SearchParameter' element items.
                     * 
                     * @param list
                     */
                    public void setSearchParameterList(
                            List<SearchParameter> list) {
                        searchParameterList = list;
                    }
                    /** 
                     * ''SearchParameter'' returns Type,Value pairs.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchParameter" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SearchParameter implements Serializable
                    {
                        private String type;
                        private String value;

                        /** 
                         * Get the 'Type' attribute value. ''Type'' returns the search parameter type.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. ''Type'' returns the search parameter type.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'Value' attribute value. ''Value'' returns the search parameter value.
                         * 
                         * @return value
                         */
                        public String getValue() {
                            return value;
                        }

                        /** 
                         * Set the 'Value' attribute value. ''Value'' returns the search parameter value.
                         * 
                         * @param value
                         */
                        public void setValue(String value) {
                            this.value = value;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="CREATE"/>
                 *     &lt;xs:enumeration value="CANCEL"/>
                 *     &lt;xs:enumeration value="MODIFY"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Action implements Serializable {
                    CREATE, CANCEL, MODIFY
                }
            }
        }
        /** 
         * ''SpecialInstructions'' returns free form or GTA special instructions.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialInstructions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="SpecialInstruction" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialInstructions implements Serializable
        {
            private List<String> specialInstructionList = new ArrayList<String>();

            /** 
             * Get the list of 'SpecialInstruction' element items. ''SpecialInstruction'' returns special instruction.
             * 
             * @return list
             */
            public List<String> getSpecialInstructionList() {
                return specialInstructionList;
            }

            /** 
             * Set the list of 'SpecialInstruction' element items. ''SpecialInstruction'' returns special instruction.
             * 
             * @param list
             */
            public void setSpecialInstructionList(List<String> list) {
                specialInstructionList = list;
            }
        }
        /** 
         * ''PaymentInformation'' returns payment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FormOfPaymentReference">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" name="ref"/>
         *           &lt;xs:attribute type="xs:string" name="newRef"/>
         *           &lt;xs:attribute type="xs:string" name="deploymentId"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute name="Type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaymentInformation implements Serializable
        {
            private String formOfPaymentReferenceRef;
            private String formOfPaymentReferenceNewRef;
            private String formOfPaymentReferenceDeploymentId;
            private Type type;

            /** 
             * Get the 'ref' attribute value. ''ref'' returns the form of payment reference.
             * 
             * @return value
             */
            public String getFormOfPaymentReferenceRef() {
                return formOfPaymentReferenceRef;
            }

            /** 
             * Set the 'ref' attribute value. ''ref'' returns the form of payment reference.
             * 
             * @param formOfPaymentReferenceRef
             */
            public void setFormOfPaymentReferenceRef(
                    String formOfPaymentReferenceRef) {
                this.formOfPaymentReferenceRef = formOfPaymentReferenceRef;
            }

            /** 
             * Get the 'newRef' attribute value. ''newRef'' returns the new form of payment reference.
             * 
             * @return value
             */
            public String getFormOfPaymentReferenceNewRef() {
                return formOfPaymentReferenceNewRef;
            }

            /** 
             * Set the 'newRef' attribute value. ''newRef'' returns the new form of payment reference.
             * 
             * @param formOfPaymentReferenceNewRef
             */
            public void setFormOfPaymentReferenceNewRef(
                    String formOfPaymentReferenceNewRef) {
                this.formOfPaymentReferenceNewRef = formOfPaymentReferenceNewRef;
            }

            /** 
             * Get the 'deploymentId' attribute value. ''deploymentId'' returns the deployment identifier.
             * 
             * @return value
             */
            public String getFormOfPaymentReferenceDeploymentId() {
                return formOfPaymentReferenceDeploymentId;
            }

            /** 
             * Set the 'deploymentId' attribute value. ''deploymentId'' returns the deployment identifier.
             * 
             * @param formOfPaymentReferenceDeploymentId
             */
            public void setFormOfPaymentReferenceDeploymentId(
                    String formOfPaymentReferenceDeploymentId) {
                this.formOfPaymentReferenceDeploymentId = formOfPaymentReferenceDeploymentId;
            }

            /** 
             * Get the 'Type' attribute value. ''Type'' returns the form of payment type.
                                                      ''Type'' can be DEPOSIT or GUARANTEE.
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. ''Type'' returns the form of payment type.
                                                      ''Type'' can be DEPOSIT or GUARANTEE.
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="DEPOSIT"/>
             *     &lt;xs:enumeration value="GUARANTEE"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                DEPOSIT, GUARANTEE
            }
        }
        /** 
         * ''ArrivalDepartureInformation'' returns arrival/departure information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ArrivalDepartureInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ArrivalFlight" minOccurs="0">
         *         &lt;!-- Reference to inner class ArrivalFlight -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DepartureFlight" minOccurs="0">
         *         &lt;!-- Reference to inner class DepartureFlight -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:time" name="ArrivalTime"/>
         *     &lt;xs:attribute type="xs:time" name="DepartureTime"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ArrivalDepartureInformation implements Serializable
        {
            private ArrivalFlight arrivalFlight;
            private DepartureFlight departureFlight;
            private Time arrivalTime;
            private Time departureTime;

            /** 
             * Get the 'ArrivalFlight' element value.
             * 
             * @return value
             */
            public ArrivalFlight getArrivalFlight() {
                return arrivalFlight;
            }

            /** 
             * Set the 'ArrivalFlight' element value.
             * 
             * @param arrivalFlight
             */
            public void setArrivalFlight(ArrivalFlight arrivalFlight) {
                this.arrivalFlight = arrivalFlight;
            }

            /** 
             * Get the 'DepartureFlight' element value.
             * 
             * @return value
             */
            public DepartureFlight getDepartureFlight() {
                return departureFlight;
            }

            /** 
             * Set the 'DepartureFlight' element value.
             * 
             * @param departureFlight
             */
            public void setDepartureFlight(DepartureFlight departureFlight) {
                this.departureFlight = departureFlight;
            }

            /** 
             * Get the 'ArrivalTime' attribute value. ''ArrivalTime'' returns the arrival time.
             * 
             * @return value
             */
            public Time getArrivalTime() {
                return arrivalTime;
            }

            /** 
             * Set the 'ArrivalTime' attribute value. ''ArrivalTime'' returns the arrival time.
             * 
             * @param arrivalTime
             */
            public void setArrivalTime(Time arrivalTime) {
                this.arrivalTime = arrivalTime;
            }

            /** 
             * Get the 'DepartureTime' attribute value. ''DepartureTime'' returns the departure time.
             * 
             * @return value
             */
            public Time getDepartureTime() {
                return departureTime;
            }

            /** 
             * Set the 'DepartureTime' attribute value. ''DepartureTime'' returns the departure time.
             * 
             * @param departureTime
             */
            public void setDepartureTime(Time departureTime) {
                this.departureTime = departureTime;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ArrivalFlight" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Carrier"/>
             *       &lt;xs:element type="xs:string" name="FlightNumber"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ArrivalFlight implements Serializable
            {
                private String carrier;
                private String flightNumber;

                /** 
                 * Get the 'Carrier' element value. ''Carrier'' returns the arrival flight carrier code.
                 * 
                 * @return value
                 */
                public String getCarrier() {
                    return carrier;
                }

                /** 
                 * Set the 'Carrier' element value. ''Carrier'' returns the arrival flight carrier code.
                 * 
                 * @param carrier
                 */
                public void setCarrier(String carrier) {
                    this.carrier = carrier;
                }

                /** 
                 * Get the 'FlightNumber' element value. ''FlightNumber'' returns the arrival flight number.
                 * 
                 * @return value
                 */
                public String getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'FlightNumber' element value. ''FlightNumber'' returns the arrival flight number.
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureFlight" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Carrier"/>
             *       &lt;xs:element type="xs:string" name="FlightNumber"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DepartureFlight implements Serializable
            {
                private String carrier;
                private String flightNumber;

                /** 
                 * Get the 'Carrier' element value. ''Carrier'' returns the departure flight carrier code.
                 * 
                 * @return value
                 */
                public String getCarrier() {
                    return carrier;
                }

                /** 
                 * Set the 'Carrier' element value. ''Carrier'' returns the departure flight carrier code.
                 * 
                 * @param carrier
                 */
                public void setCarrier(String carrier) {
                    this.carrier = carrier;
                }

                /** 
                 * Get the 'FlightNumber' element value. ''FlightNumber'' returns the departure flight number.
                 * 
                 * @return value
                 */
                public String getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'FlightNumber' element value. ''FlightNumber'' returns the departure flight number.
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }
            }
        }
        /** 
         * ''POS'' returns point of sale information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Source">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="RequestorID" minOccurs="0">
         *               &lt;!-- Reference to inner class RequestorID -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="AgencyAddress" minOccurs="0">
         *               &lt;!-- Reference to inner class AgencyAddress -->
         *             &lt;/xs:element>
         *             &lt;xs:element name="AgencyContact" minOccurs="0">
         *               &lt;!-- Reference to inner class AgencyContact -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *           &lt;xs:attribute type="xs:string" name="AgencyName"/>
         *           &lt;xs:attribute type="xs:string" name="AgentSine"/>
         *           &lt;xs:attribute type="xs:string" name="AgentDutyCode"/>
         *           &lt;xs:attribute type="xs:string" name="Lniata"/>
         *           &lt;xs:attribute type="xs:string" name="AgentOriginCity"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="ISOCountryCode"/>
         *           &lt;xs:attribute type="xs:string" name="ISOCurrencyCode"/>
         *           &lt;xs:attribute type="xs:string" name="AuxPlaceOfOrigin"/>
         *           &lt;xs:attribute type="xs:string" name="IATAOriginatorTypeCode"/>
         *           &lt;xs:attribute type="xs:date" name="CreationDate"/>
         *           &lt;xs:attribute type="xs:time" name="CreationTime"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="PseudoCityCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class POS implements Serializable
        {
            private RequestorID requestorID;
            private AgencyAddress agencyAddress;
            private AgencyContact agencyContact;
            private String sourceAgencyName;
            private String sourceAgentSine;
            private String sourceAgentDutyCode;
            private String sourceLniata;
            private String sourceAgentOriginCity;
            private String sourceISOCountryCode;
            private String sourceISOCurrencyCode;
            private String sourceAuxPlaceOfOrigin;
            private String sourceIATAOriginatorTypeCode;
            private java.sql.Date sourceCreationDate;
            private Time sourceCreationTime;
            private String sourcePseudoCityCode;

            /** 
             * Get the 'RequestorID' element value.
             * 
             * @return value
             */
            public RequestorID getRequestorID() {
                return requestorID;
            }

            /** 
             * Set the 'RequestorID' element value.
             * 
             * @param requestorID
             */
            public void setRequestorID(RequestorID requestorID) {
                this.requestorID = requestorID;
            }

            /** 
             * Get the 'AgencyAddress' element value.
             * 
             * @return value
             */
            public AgencyAddress getAgencyAddress() {
                return agencyAddress;
            }

            /** 
             * Set the 'AgencyAddress' element value.
             * 
             * @param agencyAddress
             */
            public void setAgencyAddress(AgencyAddress agencyAddress) {
                this.agencyAddress = agencyAddress;
            }

            /** 
             * Get the 'AgencyContact' element value.
             * 
             * @return value
             */
            public AgencyContact getAgencyContact() {
                return agencyContact;
            }

            /** 
             * Set the 'AgencyContact' element value.
             * 
             * @param agencyContact
             */
            public void setAgencyContact(AgencyContact agencyContact) {
                this.agencyContact = agencyContact;
            }

            /** 
             * Get the 'AgencyName' attribute value. ''AgencyName'' returns the travel agency name.
             * 
             * @return value
             */
            public String getSourceAgencyName() {
                return sourceAgencyName;
            }

            /** 
             * Set the 'AgencyName' attribute value. ''AgencyName'' returns the travel agency name.
             * 
             * @param sourceAgencyName
             */
            public void setSourceAgencyName(String sourceAgencyName) {
                this.sourceAgencyName = sourceAgencyName;
            }

            /** 
             * Get the 'AgentSine' attribute value. ''AgentSine'' returns the travel agent sabre system sine.
             * 
             * @return value
             */
            public String getSourceAgentSine() {
                return sourceAgentSine;
            }

            /** 
             * Set the 'AgentSine' attribute value. ''AgentSine'' returns the travel agent sabre system sine.
             * 
             * @param sourceAgentSine
             */
            public void setSourceAgentSine(String sourceAgentSine) {
                this.sourceAgentSine = sourceAgentSine;
            }

            /** 
             * Get the 'AgentDutyCode' attribute value. ''AgentDutyCode'' returns the travel agent sabre system duty code.
             * 
             * @return value
             */
            public String getSourceAgentDutyCode() {
                return sourceAgentDutyCode;
            }

            /** 
             * Set the 'AgentDutyCode' attribute value. ''AgentDutyCode'' returns the travel agent sabre system duty code.
             * 
             * @param sourceAgentDutyCode
             */
            public void setSourceAgentDutyCode(String sourceAgentDutyCode) {
                this.sourceAgentDutyCode = sourceAgentDutyCode;
            }

            /** 
             * Get the 'Lniata' attribute value. ''Lniata'' returns the sabre system session LNIATA.
             * 
             * @return value
             */
            public String getSourceLniata() {
                return sourceLniata;
            }

            /** 
             * Set the 'Lniata' attribute value. ''Lniata'' returns the sabre system session LNIATA.
             * 
             * @param sourceLniata
             */
            public void setSourceLniata(String sourceLniata) {
                this.sourceLniata = sourceLniata;
            }

            /** 
             * Get the 'AgentOriginCity' attribute value. ''AgentOriginCity'' returns the sabre system agent origin pseudo city code.
             * 
             * @return value
             */
            public String getSourceAgentOriginCity() {
                return sourceAgentOriginCity;
            }

            /** 
             * Set the 'AgentOriginCity' attribute value. ''AgentOriginCity'' returns the sabre system agent origin pseudo city code.
             * 
             * @param sourceAgentOriginCity
             */
            public void setSourceAgentOriginCity(String sourceAgentOriginCity) {
                this.sourceAgentOriginCity = sourceAgentOriginCity;
            }

            /** 
             * Get the 'ISOCountryCode' attribute value. ''ISOCountryCode'' returns the travel agency sabre system ISO country code.
             * 
             * @return value
             */
            public String getSourceISOCountryCode() {
                return sourceISOCountryCode;
            }

            /** 
             * Set the 'ISOCountryCode' attribute value. ''ISOCountryCode'' returns the travel agency sabre system ISO country code.
             * 
             * @param sourceISOCountryCode
             */
            public void setSourceISOCountryCode(String sourceISOCountryCode) {
                this.sourceISOCountryCode = sourceISOCountryCode;
            }

            /** 
             * Get the 'ISOCurrencyCode' attribute value. ''ISOCurrencyCode'' returns the travel agency sabre system ISO currency code.
             * 
             * @return value
             */
            public String getSourceISOCurrencyCode() {
                return sourceISOCurrencyCode;
            }

            /** 
             * Set the 'ISOCurrencyCode' attribute value. ''ISOCurrencyCode'' returns the travel agency sabre system ISO currency code.
             * 
             * @param sourceISOCurrencyCode
             */
            public void setSourceISOCurrencyCode(String sourceISOCurrencyCode) {
                this.sourceISOCurrencyCode = sourceISOCurrencyCode;
            }

            /** 
             * Get the 'AuxPlaceOfOrigin' attribute value. ''AuxPlaceOfOrigin'' returns the auxiliary place of origin.
             * 
             * @return value
             */
            public String getSourceAuxPlaceOfOrigin() {
                return sourceAuxPlaceOfOrigin;
            }

            /** 
             * Set the 'AuxPlaceOfOrigin' attribute value. ''AuxPlaceOfOrigin'' returns the auxiliary place of origin.
             * 
             * @param sourceAuxPlaceOfOrigin
             */
            public void setSourceAuxPlaceOfOrigin(String sourceAuxPlaceOfOrigin) {
                this.sourceAuxPlaceOfOrigin = sourceAuxPlaceOfOrigin;
            }

            /** 
             * Get the 'IATAOriginatorTypeCode' attribute value. ''IATAOriginatorTypeCode'' returns the IATA originator type code.
             * 
             * @return value
             */
            public String getSourceIATAOriginatorTypeCode() {
                return sourceIATAOriginatorTypeCode;
            }

            /** 
             * Set the 'IATAOriginatorTypeCode' attribute value. ''IATAOriginatorTypeCode'' returns the IATA originator type code.
             * 
             * @param sourceIATAOriginatorTypeCode
             */
            public void setSourceIATAOriginatorTypeCode(
                    String sourceIATAOriginatorTypeCode) {
                this.sourceIATAOriginatorTypeCode = sourceIATAOriginatorTypeCode;
            }

            /** 
             * Get the 'CreationDate' attribute value. ''CreationDate'' returns the lodging booking creation date.
             * 
             * @return value
             */
            public java.sql.Date getSourceCreationDate() {
                return sourceCreationDate;
            }

            /** 
             * Set the 'CreationDate' attribute value. ''CreationDate'' returns the lodging booking creation date.
             * 
             * @param sourceCreationDate
             */
            public void setSourceCreationDate(java.sql.Date sourceCreationDate) {
                this.sourceCreationDate = sourceCreationDate;
            }

            /** 
             * Get the 'CreationTime' attribute value. ''CreationTime'' returns the lodging booking creation time.
             * 
             * @return value
             */
            public Time getSourceCreationTime() {
                return sourceCreationTime;
            }

            /** 
             * Set the 'CreationTime' attribute value. ''CreationTime'' returns the lodging booking creation time.
             * 
             * @param sourceCreationTime
             */
            public void setSourceCreationTime(Time sourceCreationTime) {
                this.sourceCreationTime = sourceCreationTime;
            }

            /** 
             * Get the 'PseudoCityCode' attribute value. ''PseudoCityCode'' returns the sabre system agent pseudo city code.
             * 
             * @return value
             */
            public String getSourcePseudoCityCode() {
                return sourcePseudoCityCode;
            }

            /** 
             * Set the 'PseudoCityCode' attribute value. ''PseudoCityCode'' returns the sabre system agent pseudo city code.
             * 
             * @param sourcePseudoCityCode
             */
            public void setSourcePseudoCityCode(String sourcePseudoCityCode) {
                this.sourcePseudoCityCode = sourcePseudoCityCode;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestorID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" name="Type"/>
             *     &lt;xs:attribute type="xs:string" name="Id"/>
             *     &lt;xs:attribute type="xs:string" name="IdContext"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RequestorID implements Serializable
            {
                private Integer type;
                private String id;
                private String idContext;

                /** 
                 * Get the 'Type' attribute value. ''Type'' returns requestor identifier type.
                                                                                ''Type'' can be found in OTA Table UIT : value 5 for travel agency.
                 * 
                 * @return value
                 */
                public Integer getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. ''Type'' returns requestor identifier type.
                                                                                ''Type'' can be found in OTA Table UIT : value 5 for travel agency.
                 * 
                 * @param type
                 */
                public void setType(Integer type) {
                    this.type = type;
                }

                /** 
                 * Get the 'Id' attribute value. ''Id'' returns the agency IATA number.
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'Id' attribute value. ''Id'' returns the agency IATA number.
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }

                /** 
                 * Get the 'IdContext' attribute value. ''IdContext'' returns the agency IATA identifier context.
                 * 
                 * @return value
                 */
                public String getIdContext() {
                    return idContext;
                }

                /** 
                 * Set the 'IdContext' attribute value. ''IdContext'' returns the agency IATA identifier context.
                 * 
                 * @param idContext
                 */
                public void setIdContext(String idContext) {
                    this.idContext = idContext;
                }
            }
            /** 
             * ''AgencyAddress'' returns travel agency address information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyAddress" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="AddressLine1"/>
             *       &lt;xs:element type="xs:string" name="AddressLine2" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="AddressLine3" minOccurs="0"/>
             *       &lt;xs:element name="CityName" minOccurs="0">
             *         &lt;!-- Reference to inner class CityName -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="StateProv" minOccurs="0">
             *         &lt;!-- Reference to inner class StateProv -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
             *       &lt;xs:element name="CountryName">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:string">
             *               &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgencyAddress implements Serializable
            {
                private String addressLine1;
                private String addressLine2;
                private String addressLine3;
                private CityName cityName;
                private StateProv stateProv;
                private String postalCode;
                private String countryNameString;
                private String countryNameCode;

                /** 
                 * Get the 'AddressLine1' element value. ''AddressLine1'' returns the first agency address line.
                 * 
                 * @return value
                 */
                public String getAddressLine1() {
                    return addressLine1;
                }

                /** 
                 * Set the 'AddressLine1' element value. ''AddressLine1'' returns the first agency address line.
                 * 
                 * @param addressLine1
                 */
                public void setAddressLine1(String addressLine1) {
                    this.addressLine1 = addressLine1;
                }

                /** 
                 * Get the 'AddressLine2' element value. ''AddressLine2'' returns the second agency address line.
                 * 
                 * @return value
                 */
                public String getAddressLine2() {
                    return addressLine2;
                }

                /** 
                 * Set the 'AddressLine2' element value. ''AddressLine2'' returns the second agency address line.
                 * 
                 * @param addressLine2
                 */
                public void setAddressLine2(String addressLine2) {
                    this.addressLine2 = addressLine2;
                }

                /** 
                 * Get the 'AddressLine3' element value. ''AddressLine3'' returns the third agency address line.
                 * 
                 * @return value
                 */
                public String getAddressLine3() {
                    return addressLine3;
                }

                /** 
                 * Set the 'AddressLine3' element value. ''AddressLine3'' returns the third agency address line.
                 * 
                 * @param addressLine3
                 */
                public void setAddressLine3(String addressLine3) {
                    this.addressLine3 = addressLine3;
                }

                /** 
                 * Get the 'CityName' element value.
                 * 
                 * @return value
                 */
                public CityName getCityName() {
                    return cityName;
                }

                /** 
                 * Set the 'CityName' element value.
                 * 
                 * @param cityName
                 */
                public void setCityName(CityName cityName) {
                    this.cityName = cityName;
                }

                /** 
                 * Get the 'StateProv' element value.
                 * 
                 * @return value
                 */
                public StateProv getStateProv() {
                    return stateProv;
                }

                /** 
                 * Set the 'StateProv' element value.
                 * 
                 * @param stateProv
                 */
                public void setStateProv(StateProv stateProv) {
                    this.stateProv = stateProv;
                }

                /** 
                 * Get the 'PostalCode' element value. ''PostalCode'' returns the agency postal code.
                 * 
                 * @return value
                 */
                public String getPostalCode() {
                    return postalCode;
                }

                /** 
                 * Set the 'PostalCode' element value. ''PostalCode'' returns the agency postal code.
                 * 
                 * @param postalCode
                 */
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getCountryNameString() {
                    return countryNameString;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param countryNameString
                 */
                public void setCountryNameString(String countryNameString) {
                    this.countryNameString = countryNameString;
                }

                /** 
                 * Get the 'Code' attribute value. ''Code'' returns the agency country code.
                 * 
                 * @return value
                 */
                public String getCountryNameCode() {
                    return countryNameCode;
                }

                /** 
                 * Set the 'Code' attribute value. ''Code'' returns the agency country code.
                 * 
                 * @param countryNameCode
                 */
                public void setCountryNameCode(String countryNameCode) {
                    this.countryNameCode = countryNameCode;
                }
                /** 
                 * ''CityName'' returns the agency city name.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CityName" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="CityCode"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CityName implements Serializable
                {
                    private String string;
                    private String cityCode;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'CityCode' attribute value. ''CityCode'' returns the agency city code.
                     * 
                     * @return value
                     */
                    public String getCityCode() {
                        return cityCode;
                    }

                    /** 
                     * Set the 'CityCode' attribute value. ''CityCode'' returns the agency city code.
                     * 
                     * @param cityCode
                     */
                    public void setCityCode(String cityCode) {
                        this.cityCode = cityCode;
                    }
                }
                /** 
                 * ''StateProv'' returns the agency state or province name.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProv" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="StateCode"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class StateProv implements Serializable
                {
                    private String string;
                    private String stateCode;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'StateCode' attribute value. ''StateCode'' returns the agency state code.
                     * 
                     * @return value
                     */
                    public String getStateCode() {
                        return stateCode;
                    }

                    /** 
                     * Set the 'StateCode' attribute value. ''StateCode'' returns the agency state code.
                     * 
                     * @param stateCode
                     */
                    public void setStateCode(String stateCode) {
                        this.stateCode = stateCode;
                    }
                }
            }
            /** 
             * ''AgencyContact'' returns the travel agency contact information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyContact" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="Phone"/>
             *     &lt;xs:attribute type="xs:string" name="Mobile"/>
             *     &lt;xs:attribute type="xs:string" name="Fax"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgencyContact implements Serializable
            {
                private String phone;
                private String mobile;
                private String fax;

                /** 
                 * Get the 'Phone' attribute value. ''Phone'' returns the agency phone number.
                 * 
                 * @return value
                 */
                public String getPhone() {
                    return phone;
                }

                /** 
                 * Set the 'Phone' attribute value. ''Phone'' returns the agency phone number.
                 * 
                 * @param phone
                 */
                public void setPhone(String phone) {
                    this.phone = phone;
                }

                /** 
                 * Get the 'Mobile' attribute value. ''Mobile'' returns the agency mobile phone number.
                 * 
                 * @return value
                 */
                public String getMobile() {
                    return mobile;
                }

                /** 
                 * Set the 'Mobile' attribute value. ''Mobile'' returns the agency mobile phone number.
                 * 
                 * @param mobile
                 */
                public void setMobile(String mobile) {
                    this.mobile = mobile;
                }

                /** 
                 * Get the 'Fax' attribute value. ''Fax'' returns the agency fax number.
                 * 
                 * @return value
                 */
                public String getFax() {
                    return fax;
                }

                /** 
                 * Set the 'Fax' attribute value. ''Fax'' returns the agency fax number.
                 * 
                 * @param fax
                 */
                public void setFax(String fax) {
                    this.fax = fax;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValueAdds" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ValueAdd" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ValueAdd -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValueAdds implements Serializable
        {
            private List<ValueAdd> valueAddList = new ArrayList<ValueAdd>();

            /** 
             * Get the list of 'ValueAdd' element items.
             * 
             * @return list
             */
            public List<ValueAdd> getValueAddList() {
                return valueAddList;
            }

            /** 
             * Set the list of 'ValueAdd' element items.
             * 
             * @param list
             */
            public void setValueAddList(List<ValueAdd> list) {
                valueAddList = list;
            }
            /** 
             * ''ValueAdds'' returns value adds returned for EAN booking.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValueAdd" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Text" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ValueAdd implements Serializable
            {
                private List<String> texts = new ArrayList<String>();

                /** 
                 * Get the list of 'Text' element items.
                 * 
                 * @return list
                 */
                public List<String> getTexts() {
                    return texts;
                }

                /** 
                 * Set the list of 'Text' element items.
                 * 
                 * @param list
                 */
                public void setTexts(List<String> list) {
                    texts = list;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoucherInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="VoucherAttributes" minOccurs="0">
         *         &lt;!-- Reference to inner class VoucherAttributes -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="VoucherDetails" minOccurs="0">
         *         &lt;!-- Reference to inner class VoucherDetails -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="OfficialSupplierName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VoucherInformation implements Serializable
        {
            private VoucherAttributes voucherAttributes;
            private VoucherDetails voucherDetails;
            private String officialSupplierName;

            /** 
             * Get the 'VoucherAttributes' element value.
             * 
             * @return value
             */
            public VoucherAttributes getVoucherAttributes() {
                return voucherAttributes;
            }

            /** 
             * Set the 'VoucherAttributes' element value.
             * 
             * @param voucherAttributes
             */
            public void setVoucherAttributes(VoucherAttributes voucherAttributes) {
                this.voucherAttributes = voucherAttributes;
            }

            /** 
             * Get the 'VoucherDetails' element value.
             * 
             * @return value
             */
            public VoucherDetails getVoucherDetails() {
                return voucherDetails;
            }

            /** 
             * Set the 'VoucherDetails' element value.
             * 
             * @param voucherDetails
             */
            public void setVoucherDetails(VoucherDetails voucherDetails) {
                this.voucherDetails = voucherDetails;
            }

            /** 
             * Get the 'OfficialSupplierName' attribute value. ''OfficialSupplierName'' returns the official supplier name.
             * 
             * @return value
             */
            public String getOfficialSupplierName() {
                return officialSupplierName;
            }

            /** 
             * Set the 'OfficialSupplierName' attribute value. ''OfficialSupplierName'' returns the official supplier name.
             * 
             * @param officialSupplierName
             */
            public void setOfficialSupplierName(String officialSupplierName) {
                this.officialSupplierName = officialSupplierName;
            }
            /** 
             * ''VoucherAttributes'' returns voucher attributes.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoucherAttributes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="VoucherAttribute" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class VoucherAttribute -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class VoucherAttributes implements Serializable
            {
                private List<VoucherAttribute> voucherAttributeList = new ArrayList<VoucherAttribute>();

                /** 
                 * Get the list of 'VoucherAttribute' element items.
                 * 
                 * @return list
                 */
                public List<VoucherAttribute> getVoucherAttributeList() {
                    return voucherAttributeList;
                }

                /** 
                 * Set the list of 'VoucherAttribute' element items.
                 * 
                 * @param list
                 */
                public void setVoucherAttributeList(List<VoucherAttribute> list) {
                    voucherAttributeList = list;
                }
                /** 
                 * ''VoucherAttribute'' returns Type,Value pairs.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoucherAttribute" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VoucherAttribute implements Serializable
                {
                    private String type;
                    private String value;

                    /** 
                     * Get the 'Type' attribute value. ''Type'' returns the voucher attribute type.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. ''Type'' returns the voucher attribute type.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'Value' attribute value. ''Value'' returns the voucher attribute value.
                     * 
                     * @return value
                     */
                    public String getValue() {
                        return value;
                    }

                    /** 
                     * Set the 'Value' attribute value. ''Value'' returns the voucher attribute value.
                     * 
                     * @param value
                     */
                    public void setValue(String value) {
                        this.value = value;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoucherDetails" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="VoucherDetail" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class VoucherDetail -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class VoucherDetails implements Serializable
            {
                private List<VoucherDetail> voucherDetailList = new ArrayList<VoucherDetail>();

                /** 
                 * Get the list of 'VoucherDetail' element items.
                 * 
                 * @return list
                 */
                public List<VoucherDetail> getVoucherDetailList() {
                    return voucherDetailList;
                }

                /** 
                 * Set the list of 'VoucherDetail' element items.
                 * 
                 * @param list
                 */
                public void setVoucherDetailList(List<VoucherDetail> list) {
                    voucherDetailList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoucherDetail" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VoucherDetail implements Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value. ''Text'' returns the voucher detail text.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. ''Text'' returns the voucher detail text.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:RequestorSourceType" name="RequestorInfo"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:dateTime" name="LastUpdateTimeStamp"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TransactionInfo implements Serializable
    {
        private RequestorSourceType requestorInfo;
        private Date lastUpdateTimeStamp;

        /** 
         * Get the 'RequestorInfo' element value.
         * 
         * @return value
         */
        public RequestorSourceType getRequestorInfo() {
            return requestorInfo;
        }

        /** 
         * Set the 'RequestorInfo' element value.
         * 
         * @param requestorInfo
         */
        public void setRequestorInfo(RequestorSourceType requestorInfo) {
            this.requestorInfo = requestorInfo;
        }

        /** 
         * Get the 'LastUpdateTimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
         * 
         * @return value
         */
        public Date getLastUpdateTimeStamp() {
            return lastUpdateTimeStamp;
        }

        /** 
         * Set the 'LastUpdateTimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
         * 
         * @param lastUpdateTimeStamp
         */
        public void setLastUpdateTimeStamp(Date lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BillingInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="BillingCode"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BillingInfo implements Serializable
    {
        private String billingCode;

        /** 
         * Get the 'BillingCode' element value. Holds information about billing code for product
         * 
         * @return value
         */
        public String getBillingCode() {
            return billingCode;
        }

        /** 
         * Set the 'BillingCode' element value. Holds information about billing code for product
         * 
         * @param billingCode
         */
        public void setBillingCode(String billingCode) {
            this.billingCode = billingCode;
        }
    }
}
