
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailAccommodationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PassengerRef" minOccurs="0"/>
 *     &lt;xs:element name="Placement">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="Coach" maxOccurs="unbounded">
 *             &lt;!-- Reference to inner class Coach -->
 *           &lt;/xs:element>
 *           &lt;xs:element type="xs:string" name="Detail" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;/xs:sequence>
 *         &lt;xs:attribute type="xs:anySimpleType" name="code"/>
 *         &lt;xs:attribute type="xs:anySimpleType" name="type"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Meal" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailAccommodationType implements Serializable
{
    private String passengerRef;
    private List<Coach> coachList = new ArrayList<Coach>();
    private List<String> placementDetailList = new ArrayList<String>();
    private String placementCode;
    private String placementType;
    private String meal;

    /** 
     * Get the 'PassengerRef' element value.
     * 
     * @return value
     */
    public String getPassengerRef() {
        return passengerRef;
    }

    /** 
     * Set the 'PassengerRef' element value.
     * 
     * @param passengerRef
     */
    public void setPassengerRef(String passengerRef) {
        this.passengerRef = passengerRef;
    }

    /** 
     * Get the list of 'Coach' element items.
     * 
     * @return list
     */
    public List<Coach> getCoachList() {
        return coachList;
    }

    /** 
     * Set the list of 'Coach' element items.
     * 
     * @param list
     */
    public void setCoachList(List<Coach> list) {
        coachList = list;
    }

    /** 
     * Get the list of 'Detail' element items.
     * 
     * @return list
     */
    public List<String> getPlacementDetailList() {
        return placementDetailList;
    }

    /** 
     * Set the list of 'Detail' element items.
     * 
     * @param list
     */
    public void setPlacementDetailList(List<String> list) {
        placementDetailList = list;
    }

    /** 
     * Get the 'code' attribute value.
     * 
     * @return value
     */
    public String getPlacementCode() {
        return placementCode;
    }

    /** 
     * Set the 'code' attribute value.
     * 
     * @param placementCode
     */
    public void setPlacementCode(String placementCode) {
        this.placementCode = placementCode;
    }

    /** 
     * Get the 'type' attribute value.
     * 
     * @return value
     */
    public String getPlacementType() {
        return placementType;
    }

    /** 
     * Set the 'type' attribute value.
     * 
     * @param placementType
     */
    public void setPlacementType(String placementType) {
        this.placementType = placementType;
    }

    /** 
     * Get the 'Meal' element value.
     * 
     * @return value
     */
    public String getMeal() {
        return meal;
    }

    /** 
     * Set the 'Meal' element value.
     * 
     * @param meal
     */
    public void setMeal(String meal) {
        this.meal = meal;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coach" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="CoachNumber" minOccurs="0"/>
     *       &lt;xs:element name="PlacementNumber" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PlacementNumber -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="CompartmentNumber" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Coach implements Serializable
    {
        private String coachNumber;
        private List<PlacementNumber> placementNumberList = new ArrayList<PlacementNumber>();
        private String compartmentNumber;

        /** 
         * Get the 'CoachNumber' element value.
         * 
         * @return value
         */
        public String getCoachNumber() {
            return coachNumber;
        }

        /** 
         * Set the 'CoachNumber' element value.
         * 
         * @param coachNumber
         */
        public void setCoachNumber(String coachNumber) {
            this.coachNumber = coachNumber;
        }

        /** 
         * Get the list of 'PlacementNumber' element items.
         * 
         * @return list
         */
        public List<PlacementNumber> getPlacementNumberList() {
            return placementNumberList;
        }

        /** 
         * Set the list of 'PlacementNumber' element items.
         * 
         * @param list
         */
        public void setPlacementNumberList(List<PlacementNumber> list) {
            placementNumberList = list;
        }

        /** 
         * Get the 'CompartmentNumber' element value.
         * 
         * @return value
         */
        public String getCompartmentNumber() {
            return compartmentNumber;
        }

        /** 
         * Set the 'CompartmentNumber' element value.
         * 
         * @param compartmentNumber
         */
        public void setCompartmentNumber(String compartmentNumber) {
            this.compartmentNumber = compartmentNumber;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PlacementNumber" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:anySimpleType" name="compartmentRefId"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PlacementNumber implements Serializable
        {
            private String string;
            private String compartmentRefId;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'compartmentRefId' attribute value.
             * 
             * @return value
             */
            public String getCompartmentRefId() {
                return compartmentRefId;
            }

            /** 
             * Set the 'compartmentRefId' attribute value.
             * 
             * @param compartmentRefId
             */
            public void setCompartmentRefId(String compartmentRefId) {
                this.compartmentRefId = compartmentRefId;
            }
        }
    }
}
