
package com.sabre.services.sp.updatereservation.v11;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InsuranceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
 *     &lt;xs:element name="QuoteID" minOccurs="0">
 *       &lt;!-- Reference to inner class QuoteID -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Coverages" minOccurs="0">
 *       &lt;!-- Reference to inner class Coverages -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AddOns">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:InsuranceCoverAddOn" name="AddOn" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Excess" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Cancellation" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Commission" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PremiumAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PremiumGrossAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PremiumPerDay" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MaxDurationDays" minOccurs="0"/>
 *     &lt;xs:element name="DestinationLocation" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class DestinationLocation -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OriginLocation" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginLocation -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Payment" minOccurs="0">
 *       &lt;!-- Reference to inner class Payment -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Travelers" minOccurs="0">
 *       &lt;!-- Reference to inner class Travelers -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
 *     &lt;xs:element name="Vendor" minOccurs="0">
 *       &lt;!-- Reference to inner class Vendor -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PricingElementsType" name="PriceDetails" minOccurs="0"/>
 *     &lt;xs:element name="Declarations" minOccurs="0">
 *       &lt;!-- Reference to inner class Declarations -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="currencyCode"/>
 *   &lt;xs:attribute type="xs:dateTime" name="end"/>
 *   &lt;xs:attribute type="xs:string" name="numberOfPolicies"/>
 *   &lt;xs:attribute type="xs:string" name="productCode"/>
 *   &lt;xs:attribute type="xs:string" name="productName"/>
 *   &lt;xs:attribute type="xs:string" name="planType"/>
 *   &lt;xs:attribute type="xs:string" name="planName"/>
 *   &lt;xs:attribute type="xs:string" name="tripType"/>
 *   &lt;xs:attribute type="xs:int" name="minAge"/>
 *   &lt;xs:attribute type="xs:int" name="maxAge"/>
 *   &lt;xs:attribute type="xs:dateTime" name="purchaseDate"/>
 *   &lt;xs:attribute type="xs:dateTime" name="start"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InsuranceType implements Serializable
{
    private String confirmationNumber;
    private QuoteID quoteID;
    private Coverages coverages;
    private List<InsuranceCoverAddOn> addOnList = new ArrayList<InsuranceCoverAddOn>();
    private String excess;
    private String cancellation;
    private String commission;
    private String premiumAmount;
    private String premiumGrossAmount;
    private String premiumPerDay;
    private String maxDurationDays;
    private List<DestinationLocation> destinationLocationList = new ArrayList<DestinationLocation>();
    private OriginLocation originLocation;
    private Payment payment;
    private Travelers travelers;
    private String text;
    private Vendor vendor;
    private PricingElementsType priceDetails;
    private Declarations declarations;
    private String currencyCode;
    private Date end;
    private String numberOfPolicies;
    private String productCode;
    private String productName;
    private String planType;
    private String planName;
    private String tripType;
    private Integer minAge;
    private Integer maxAge;
    private Date purchaseDate;
    private Date start;

    /** 
     * Get the 'ConfirmationNumber' element value. "ConfirmationNumber" is used to return the confirmation number associated with the particular insurance segment.
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. "ConfirmationNumber" is used to return the confirmation number associated with the particular insurance segment.
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'QuoteID' element value.
     * 
     * @return value
     */
    public QuoteID getQuoteID() {
        return quoteID;
    }

    /** 
     * Set the 'QuoteID' element value.
     * 
     * @param quoteID
     */
    public void setQuoteID(QuoteID quoteID) {
        this.quoteID = quoteID;
    }

    /** 
     * Get the 'Coverages' element value.
     * 
     * @return value
     */
    public Coverages getCoverages() {
        return coverages;
    }

    /** 
     * Set the 'Coverages' element value.
     * 
     * @param coverages
     */
    public void setCoverages(Coverages coverages) {
        this.coverages = coverages;
    }

    /** 
     * Get the list of 'AddOn' element items.
     * 
     * @return list
     */
    public List<InsuranceCoverAddOn> getAddOnList() {
        return addOnList;
    }

    /** 
     * Set the list of 'AddOn' element items.
     * 
     * @param list
     */
    public void setAddOnList(List<InsuranceCoverAddOn> list) {
        addOnList = list;
    }

    /** 
     * Get the 'Excess' element value.
     * 
     * @return value
     */
    public String getExcess() {
        return excess;
    }

    /** 
     * Set the 'Excess' element value.
     * 
     * @param excess
     */
    public void setExcess(String excess) {
        this.excess = excess;
    }

    /** 
     * Get the 'Cancellation' element value.
     * 
     * @return value
     */
    public String getCancellation() {
        return cancellation;
    }

    /** 
     * Set the 'Cancellation' element value.
     * 
     * @param cancellation
     */
    public void setCancellation(String cancellation) {
        this.cancellation = cancellation;
    }

    /** 
     * Get the 'Commission' element value.
     * 
     * @return value
     */
    public String getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value.
     * 
     * @param commission
     */
    public void setCommission(String commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'PremiumAmount' element value. "PremiumAmount" is used to return the insurance premium amount associated with the particular insurance segment including discounts.
     * 
     * @return value
     */
    public String getPremiumAmount() {
        return premiumAmount;
    }

    /** 
     * Set the 'PremiumAmount' element value. "PremiumAmount" is used to return the insurance premium amount associated with the particular insurance segment including discounts.
     * 
     * @param premiumAmount
     */
    public void setPremiumAmount(String premiumAmount) {
        this.premiumAmount = premiumAmount;
    }

    /** 
     * Get the 'PremiumGrossAmount' element value. "PremiumGrossAmount" is used to return the insurance premium amount associated with the particular insurance segment before any discount applies.
     * 
     * @return value
     */
    public String getPremiumGrossAmount() {
        return premiumGrossAmount;
    }

    /** 
     * Set the 'PremiumGrossAmount' element value. "PremiumGrossAmount" is used to return the insurance premium amount associated with the particular insurance segment before any discount applies.
     * 
     * @param premiumGrossAmount
     */
    public void setPremiumGrossAmount(String premiumGrossAmount) {
        this.premiumGrossAmount = premiumGrossAmount;
    }

    /** 
     * Get the 'PremiumPerDay' element value.
     * 
     * @return value
     */
    public String getPremiumPerDay() {
        return premiumPerDay;
    }

    /** 
     * Set the 'PremiumPerDay' element value.
     * 
     * @param premiumPerDay
     */
    public void setPremiumPerDay(String premiumPerDay) {
        this.premiumPerDay = premiumPerDay;
    }

    /** 
     * Get the 'MaxDurationDays' element value. Max duration associated with annual multi trip product.
     * 
     * @return value
     */
    public String getMaxDurationDays() {
        return maxDurationDays;
    }

    /** 
     * Set the 'MaxDurationDays' element value. Max duration associated with annual multi trip product.
     * 
     * @param maxDurationDays
     */
    public void setMaxDurationDays(String maxDurationDays) {
        this.maxDurationDays = maxDurationDays;
    }

    /** 
     * Get the list of 'DestinationLocation' element items.
     * 
     * @return list
     */
    public List<DestinationLocation> getDestinationLocationList() {
        return destinationLocationList;
    }

    /** 
     * Set the list of 'DestinationLocation' element items.
     * 
     * @param list
     */
    public void setDestinationLocationList(List<DestinationLocation> list) {
        destinationLocationList = list;
    }

    /** 
     * Get the 'OriginLocation' element value.
     * 
     * @return value
     */
    public OriginLocation getOriginLocation() {
        return originLocation;
    }

    /** 
     * Set the 'OriginLocation' element value.
     * 
     * @param originLocation
     */
    public void setOriginLocation(OriginLocation originLocation) {
        this.originLocation = originLocation;
    }

    /** 
     * Get the 'Payment' element value.
     * 
     * @return value
     */
    public Payment getPayment() {
        return payment;
    }

    /** 
     * Set the 'Payment' element value.
     * 
     * @param payment
     */
    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    /** 
     * Get the 'Travelers' element value.
     * 
     * @return value
     */
    public Travelers getTravelers() {
        return travelers;
    }

    /** 
     * Set the 'Travelers' element value.
     * 
     * @param travelers
     */
    public void setTravelers(Travelers travelers) {
        this.travelers = travelers;
    }

    /** 
     * Get the 'Text' element value. "Text" is used to return specialized instructions associated with the particular insurance segment.
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' element value. "Text" is used to return specialized instructions associated with the particular insurance segment.
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public Vendor getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'PriceDetails' element value.
     * 
     * @return value
     */
    public PricingElementsType getPriceDetails() {
        return priceDetails;
    }

    /** 
     * Set the 'PriceDetails' element value.
     * 
     * @param priceDetails
     */
    public void setPriceDetails(PricingElementsType priceDetails) {
        this.priceDetails = priceDetails;
    }

    /** 
     * Get the 'Declarations' element value.
     * 
     * @return value
     */
    public Declarations getDeclarations() {
        return declarations;
    }

    /** 
     * Set the 'Declarations' element value.
     * 
     * @param declarations
     */
    public void setDeclarations(Declarations declarations) {
        this.declarations = declarations;
    }

    /** 
     * Get the 'currencyCode' attribute value. "CurrencyCode" is used to return the insurance premium currency code associated with the particular insurance segment.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value. "CurrencyCode" is used to return the insurance premium currency code associated with the particular insurance segment.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'end' attribute value. "End" is used to return the end date of the insurance coverage. The format is MM:DD
     * 
     * @return value
     */
    public Date getEnd() {
        return end;
    }

    /** 
     * Set the 'end' attribute value. "End" is used to return the end date of the insurance coverage. The format is MM:DD
     * 
     * @param end
     */
    public void setEnd(Date end) {
        this.end = end;
    }

    /** 
     * Get the 'numberOfPolicies' attribute value. "numberOfPolicies" is used to return the number of policies associated with the particular insurance segment.
     * 
     * @return value
     */
    public String getNumberOfPolicies() {
        return numberOfPolicies;
    }

    /** 
     * Set the 'numberOfPolicies' attribute value. "numberOfPolicies" is used to return the number of policies associated with the particular insurance segment.
     * 
     * @param numberOfPolicies
     */
    public void setNumberOfPolicies(String numberOfPolicies) {
        this.numberOfPolicies = numberOfPolicies;
    }

    /** 
     * Get the 'productCode' attribute value. "ProductType" is used to return the insurance plan type/code.
     * 
     * @return value
     */
    public String getProductCode() {
        return productCode;
    }

    /** 
     * Set the 'productCode' attribute value. "ProductType" is used to return the insurance plan type/code.
     * 
     * @param productCode
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    /** 
     * Get the 'productName' attribute value. "ProductType" is used to return the insurance plan type/code.
     * 
     * @return value
     */
    public String getProductName() {
        return productName;
    }

    /** 
     * Set the 'productName' attribute value. "ProductType" is used to return the insurance plan type/code.
     * 
     * @param productName
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /** 
     * Get the 'planType' attribute value. "PlanType" is used to return the insurance plan type/code.
     * 
     * @return value
     */
    public String getPlanType() {
        return planType;
    }

    /** 
     * Set the 'planType' attribute value. "PlanType" is used to return the insurance plan type/code.
     * 
     * @param planType
     */
    public void setPlanType(String planType) {
        this.planType = planType;
    }

    /** 
     * Get the 'planName' attribute value. "PlanType" is used to return the insurance plan type/code.
     * 
     * @return value
     */
    public String getPlanName() {
        return planName;
    }

    /** 
     * Set the 'planName' attribute value. "PlanType" is used to return the insurance plan type/code.
     * 
     * @param planName
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }

    /** 
     * Get the 'tripType' attribute value. "PlanType" is used to return the insurance plan type/code.
     * 
     * @return value
     */
    public String getTripType() {
        return tripType;
    }

    /** 
     * Set the 'tripType' attribute value. "PlanType" is used to return the insurance plan type/code.
     * 
     * @param tripType
     */
    public void setTripType(String tripType) {
        this.tripType = tripType;
    }

    /** 
     * Get the 'minAge' attribute value. Minimum age supported in the product.
     * 
     * @return value
     */
    public Integer getMinAge() {
        return minAge;
    }

    /** 
     * Set the 'minAge' attribute value. Minimum age supported in the product.
     * 
     * @param minAge
     */
    public void setMinAge(Integer minAge) {
        this.minAge = minAge;
    }

    /** 
     * Get the 'maxAge' attribute value. Maximum age supported in the product.
     * 
     * @return value
     */
    public Integer getMaxAge() {
        return maxAge;
    }

    /** 
     * Set the 'maxAge' attribute value. Maximum age supported in the product.
     * 
     * @param maxAge
     */
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    /** 
     * Get the 'purchaseDate' attribute value. "PurchaseDate" is used to return the purchase date of the insurance.
     * 
     * @return value
     */
    public Date getPurchaseDate() {
        return purchaseDate;
    }

    /** 
     * Set the 'purchaseDate' attribute value. "PurchaseDate" is used to return the purchase date of the insurance.
     * 
     * @param purchaseDate
     */
    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    /** 
     * Get the 'start' attribute value. "Start" is used to return the start date and time of the insurance coverage. The format is MM:DDTHH:MM
     * 
     * @return value
     */
    public Date getStart() {
        return start;
    }

    /** 
     * Set the 'start' attribute value. "Start" is used to return the start date and time of the insurance coverage. The format is MM:DDTHH:MM
     * 
     * @param start
     */
    public void setStart(Date start) {
        this.start = start;
    }
    /** 
     * Used to store the quote/offer id
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QuoteID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="sessionId"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class QuoteID implements Serializable
    {
        private String string;
        private String sessionId;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'sessionId' attribute value. The session identifier to which the quote is assigned to. It won't be persisted in the PNR
         * 
         * @return value
         */
        public String getSessionId() {
            return sessionId;
        }

        /** 
         * Set the 'sessionId' attribute value. The session identifier to which the quote is assigned to. It won't be persisted in the PNR
         * 
         * @param sessionId
         */
        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coverages" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:InsuranceCoverage" name="Coverage" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Coverages implements Serializable
    {
        private List<InsuranceCoverage> coverageList = new ArrayList<InsuranceCoverage>();

        /** 
         * Get the list of 'Coverage' element items.
         * 
         * @return list
         */
        public List<InsuranceCoverage> getCoverageList() {
            return coverageList;
        }

        /** 
         * Set the list of 'Coverage' element items.
         * 
         * @param list
         */
        public void setCoverageList(List<InsuranceCoverage> list) {
            coverageList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="locationCode"/>
     *     &lt;xs:attribute type="xs:string" name="countryCode"/>
     *     &lt;xs:attribute type="xs:string" name="areaCode"/>
     *     &lt;xs:attribute type="xs:string" name="areaName"/>
     *     &lt;xs:attribute type="xs:string" name="type"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DestinationLocation implements Serializable
    {
        private String locationCode;
        private String countryCode;
        private String areaCode;
        private String areaName;
        private String type;

        /** 
         * Get the 'locationCode' attribute value. "LocationCode" is used to return the arrival location code associated with the particular insurance segment.
         * 
         * @return value
         */
        public String getLocationCode() {
            return locationCode;
        }

        /** 
         * Set the 'locationCode' attribute value. "LocationCode" is used to return the arrival location code associated with the particular insurance segment.
         * 
         * @param locationCode
         */
        public void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        /** 
         * Get the 'countryCode' attribute value. "countryCode" is used to return the arrival country associated with the particular insurance segment.
         * 
         * @return value
         */
        public String getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'countryCode' attribute value. "countryCode" is used to return the arrival country associated with the particular insurance segment.
         * 
         * @param countryCode
         */
        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        /** 
         * Get the 'areaCode' attribute value. "area" is used to return the arrival area associated with the particular insurance segment.
         * 
         * @return value
         */
        public String getAreaCode() {
            return areaCode;
        }

        /** 
         * Set the 'areaCode' attribute value. "area" is used to return the arrival area associated with the particular insurance segment.
         * 
         * @param areaCode
         */
        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        /** 
         * Get the 'areaName' attribute value. "area" is used to return the arrival area associated with the particular insurance segment.
         * 
         * @return value
         */
        public String getAreaName() {
            return areaName;
        }

        /** 
         * Set the 'areaName' attribute value. "area" is used to return the arrival area associated with the particular insurance segment.
         * 
         * @param areaName
         */
        public void setAreaName(String areaName) {
            this.areaName = areaName;
        }

        /** 
         * Get the 'type' attribute value. International or domestic "type" of destination.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. International or domestic "type" of destination.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="locationCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginLocation implements Serializable
    {
        private String locationCode;

        /** 
         * Get the 'locationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular insurance segment.
         * 
         * @return value
         */
        public String getLocationCode() {
            return locationCode;
        }

        /** 
         * Set the 'locationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular insurance segment.
         * 
         * @param locationCode
         */
        public void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Form" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payment implements Serializable
    {
        private String form;

        /** 
         * Get the 'Form' element value. "Form" is used to return the form of payment used to purchase the insurance.
         * 
         * @return value
         */
        public String getForm() {
            return form;
        }

        /** 
         * Set the 'Form' element value. "Form" is used to return the form of payment used to purchase the insurance.
         * 
         * @param form
         */
        public void setForm(String form) {
            this.form = form;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Travelers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Traveler" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Traveler -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Travelers implements Serializable
    {
        private List<Traveler> travelerList = new ArrayList<Traveler>();

        /** 
         * Get the list of 'Traveler' element items.
         * 
         * @return list
         */
        public List<Traveler> getTravelerList() {
            return travelerList;
        }

        /** 
         * Set the list of 'Traveler' element items.
         * 
         * @param list
         */
        public void setTravelerList(List<Traveler> list) {
            travelerList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Traveler" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:PassengerType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="ns:InsuranceCoverAddOn" name="CoverAddOn" minOccurs="0" maxOccurs="unbounded"/>
         *         &lt;/xs:sequence>
         *         &lt;xs:attribute type="xs:boolean" name="treatAsAdult"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Traveler extends PassengerType implements
            Serializable
        {
            private List<InsuranceCoverAddOn> coverAddOnList = new ArrayList<InsuranceCoverAddOn>();
            private Boolean treatAsAdult;

            /** 
             * Get the list of 'CoverAddOn' element items.
             * 
             * @return list
             */
            public List<InsuranceCoverAddOn> getCoverAddOnList() {
                return coverAddOnList;
            }

            /** 
             * Set the list of 'CoverAddOn' element items.
             * 
             * @param list
             */
            public void setCoverAddOnList(List<InsuranceCoverAddOn> list) {
                coverAddOnList = list;
            }

            /** 
             * Get the 'treatAsAdult' attribute value.
             * 
             * @return value
             */
            public Boolean getTreatAsAdult() {
                return treatAsAdult;
            }

            /** 
             * Set the 'treatAsAdult' attribute value.
             * 
             * @param treatAsAdult
             */
            public void setTreatAsAdult(Boolean treatAsAdult) {
                this.treatAsAdult = treatAsAdult;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="code"/>
     *     &lt;xs:attribute type="xs:string" name="companyShortName"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Vendor implements Serializable
    {
        private String code;
        private String companyShortName;

        /** 
         * Get the 'code' attribute value. "Code" is used to return the vendor code associated with the particular insurance segment.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. "Code" is used to return the vendor code associated with the particular insurance segment.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'companyShortName' attribute value. "CompanyShortName" is used to return the vendor's name associated with the particular insurance segment.
         * 
         * @return value
         */
        public String getCompanyShortName() {
            return companyShortName;
        }

        /** 
         * Set the 'companyShortName' attribute value. "CompanyShortName" is used to return the vendor's name associated with the particular insurance segment.
         * 
         * @param companyShortName
         */
        public void setCompanyShortName(String companyShortName) {
            this.companyShortName = companyShortName;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Declarations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Declaration" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Declaration -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Declarations implements Serializable
    {
        private List<Declaration> declarationList = new ArrayList<Declaration>();

        /** 
         * Get the list of 'Declaration' element items.
         * 
         * @return list
         */
        public List<Declaration> getDeclarationList() {
            return declarationList;
        }

        /** 
         * Set the list of 'Declaration' element items.
         * 
         * @param list
         */
        public void setDeclarationList(List<Declaration> list) {
            declarationList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Declaration" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="id"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Declaration implements Serializable
        {
            private String string;
            private String id;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'id' attribute value.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'id' attribute value.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }
        }
    }
}
