
package com.sabre.services.sp.updatereservation.v11;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Validity" minOccurs="0">
 *       &lt;!-- Reference to inner class Validity -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Location" minOccurs="0">
 *       &lt;!-- Reference to inner class Location -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Contributor" minOccurs="0">
 *       &lt;!-- Reference to inner class Contributor -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Recipient" minOccurs="0">
 *       &lt;!-- Reference to inner class Recipient -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Document" minOccurs="0">
 *       &lt;!-- Reference to inner class Document -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PricingElementsType" name="PricingElements" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OtherType implements Serializable
{
    private Validity validity;
    private Location location;
    private Contributor contributor;
    private Recipient recipient;
    private Document document;
    private PricingElementsType pricingElements;
    private String text;

    /** 
     * Get the 'Validity' element value.
     * 
     * @return value
     */
    public Validity getValidity() {
        return validity;
    }

    /** 
     * Set the 'Validity' element value.
     * 
     * @param validity
     */
    public void setValidity(Validity validity) {
        this.validity = validity;
    }

    /** 
     * Get the 'Location' element value.
     * 
     * @return value
     */
    public Location getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value.
     * 
     * @param location
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /** 
     * Get the 'Contributor' element value.
     * 
     * @return value
     */
    public Contributor getContributor() {
        return contributor;
    }

    /** 
     * Set the 'Contributor' element value.
     * 
     * @param contributor
     */
    public void setContributor(Contributor contributor) {
        this.contributor = contributor;
    }

    /** 
     * Get the 'Recipient' element value.
     * 
     * @return value
     */
    public Recipient getRecipient() {
        return recipient;
    }

    /** 
     * Set the 'Recipient' element value.
     * 
     * @param recipient
     */
    public void setRecipient(Recipient recipient) {
        this.recipient = recipient;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public Document getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(Document document) {
        this.document = document;
    }

    /** 
     * Get the 'PricingElements' element value.
     * 
     * @return value
     */
    public PricingElementsType getPricingElements() {
        return pricingElements;
    }

    /** 
     * Set the 'PricingElements' element value.
     * 
     * @param pricingElements
     */
    public void setPricingElements(PricingElementsType pricingElements) {
        this.pricingElements = pricingElements;
    }

    /** 
     * Get the 'Text' element value. Free text to be stored in segment
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' element value. Free text to be stored in segment
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Validity" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:dateTime" name="from"/>
     *     &lt;xs:attribute type="xs:dateTime" name="to"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Validity implements Serializable
    {
        private Date from;
        private Date to;

        /** 
         * Get the 'from' attribute value.
         * 
         * @return value
         */
        public Date getFrom() {
            return from;
        }

        /** 
         * Set the 'from' attribute value.
         * 
         * @param from
         */
        public void setFrom(Date from) {
            this.from = from;
        }

        /** 
         * Get the 'to' attribute value.
         * 
         * @return value
         */
        public Date getTo() {
            return to;
        }

        /** 
         * Set the 'to' attribute value.
         * 
         * @param to
         */
        public void setTo(Date to) {
            this.to = to;
        }
    }
    /** 
     * Location information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="cityCode"/>
     *     &lt;xs:attribute type="xs:string" name="name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Location implements Serializable
    {
        private String cityCode;
        private String name;

        /** 
         * Get the 'cityCode' attribute value. Location city code e.g. DFW
         * 
         * @return value
         */
        public String getCityCode() {
            return cityCode;
        }

        /** 
         * Set the 'cityCode' attribute value. Location city code e.g. DFW
         * 
         * @param cityCode
         */
        public void setCityCode(String cityCode) {
            this.cityCode = cityCode;
        }

        /** 
         * Get the 'name' attribute value. Location name if city code unavailable
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value. Location name if city code unavailable
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * A person or institution that contributes money or awards, vouchers, etc.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contributor" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Contributor implements Serializable
    {
        private String name;

        /** 
         * Get the 'name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * A person or institution that receives or is awarded with e.g. voucher, money, etc.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Recipient" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Guest" minOccurs="0">
     *         &lt;!-- Reference to inner class Guest -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Recipient implements Serializable
    {
        private Guest guest;
        private String name;

        /** 
         * Get the 'Guest' element value.
         * 
         * @return value
         */
        public Guest getGuest() {
            return guest;
        }

        /** 
         * Set the 'Guest' element value.
         * 
         * @param guest
         */
        public void setGuest(Guest guest) {
            this.guest = guest;
        }

        /** 
         * Get the 'name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
        /** 
         * An accompanying person
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guest" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="name"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Guest implements Serializable
        {
            private String name;

            /** 
             * Get the 'name' attribute value.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'name' attribute value.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Document" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="number"/>
     *     &lt;xs:attribute type="xs:string" name="type"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Document implements Serializable
    {
        private String number;
        private String type;

        /** 
         * Get the 'number' attribute value.
         * 
         * @return value
         */
        public String getNumber() {
            return number;
        }

        /** 
         * Set the 'number' attribute value.
         * 
         * @param number
         */
        public void setNumber(String number) {
            this.number = number;
        }

        /** 
         * Get the 'type' attribute value.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }
    }
}
