
package com.sabre.services.sp.updatereservation.v11;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailFareType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Fare" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Fare -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailFareType implements Serializable
{
    private List<Fare> fareList = new ArrayList<Fare>();

    /** 
     * Get the list of 'Fare' element items.
     * 
     * @return list
     */
    public List<Fare> getFareList() {
        return fareList;
    }

    /** 
     * Set the list of 'Fare' element items.
     * 
     * @param list
     */
    public void setFareList(List<Fare> list) {
        fareList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerReferences" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerReferences -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SegmentReferences" minOccurs="0">
     *         &lt;!-- Reference to inner class SegmentReferences -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ClassOfService" minOccurs="0">
     *         &lt;!-- Reference to inner class ClassOfService -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ClassCode" minOccurs="0">
     *         &lt;!-- Reference to inner class ClassCode -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareDescription" minOccurs="0">
     *         &lt;!-- Reference to inner class FareDescription -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:PriceType" name="FarePrice" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Fare implements Serializable
    {
        private PassengerReferences passengerReferences;
        private SegmentReferences segmentReferences;
        private ClassOfService classOfService;
        private ClassCode classCode;
        private FareDescription fareDescription;
        private PriceType farePrice;

        /** 
         * Get the 'PassengerReferences' element value.
         * 
         * @return value
         */
        public PassengerReferences getPassengerReferences() {
            return passengerReferences;
        }

        /** 
         * Set the 'PassengerReferences' element value.
         * 
         * @param passengerReferences
         */
        public void setPassengerReferences(
                PassengerReferences passengerReferences) {
            this.passengerReferences = passengerReferences;
        }

        /** 
         * Get the 'SegmentReferences' element value.
         * 
         * @return value
         */
        public SegmentReferences getSegmentReferences() {
            return segmentReferences;
        }

        /** 
         * Set the 'SegmentReferences' element value.
         * 
         * @param segmentReferences
         */
        public void setSegmentReferences(SegmentReferences segmentReferences) {
            this.segmentReferences = segmentReferences;
        }

        /** 
         * Get the 'ClassOfService' element value.
         * 
         * @return value
         */
        public ClassOfService getClassOfService() {
            return classOfService;
        }

        /** 
         * Set the 'ClassOfService' element value.
         * 
         * @param classOfService
         */
        public void setClassOfService(ClassOfService classOfService) {
            this.classOfService = classOfService;
        }

        /** 
         * Get the 'ClassCode' element value.
         * 
         * @return value
         */
        public ClassCode getClassCode() {
            return classCode;
        }

        /** 
         * Set the 'ClassCode' element value.
         * 
         * @param classCode
         */
        public void setClassCode(ClassCode classCode) {
            this.classCode = classCode;
        }

        /** 
         * Get the 'FareDescription' element value.
         * 
         * @return value
         */
        public FareDescription getFareDescription() {
            return fareDescription;
        }

        /** 
         * Set the 'FareDescription' element value.
         * 
         * @param fareDescription
         */
        public void setFareDescription(FareDescription fareDescription) {
            this.fareDescription = fareDescription;
        }

        /** 
         * Get the 'FarePrice' element value.
         * 
         * @return value
         */
        public PriceType getFarePrice() {
            return farePrice;
        }

        /** 
         * Set the 'FarePrice' element value.
         * 
         * @param farePrice
         */
        public void setFarePrice(PriceType farePrice) {
            this.farePrice = farePrice;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerReferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PassengerRef" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PassengerRef -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerReferences implements Serializable
        {
            private List<PassengerRef> passengerRefList = new ArrayList<PassengerRef>();

            /** 
             * Get the list of 'PassengerRef' element items.
             * 
             * @return list
             */
            public List<PassengerRef> getPassengerRefList() {
                return passengerRefList;
            }

            /** 
             * Set the list of 'PassengerRef' element items.
             * 
             * @param list
             */
            public void setPassengerRefList(List<PassengerRef> list) {
                passengerRefList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerRef" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:anySimpleType" name="id"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PassengerRef implements Serializable
            {
                private String id;

                /** 
                 * Get the 'id' attribute value. Reference ID
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'id' attribute value. Reference ID
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }
            }
        }
        /** 
         * To be checked
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentReferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SegmentRef" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SegmentRef -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SegmentReferences implements Serializable
        {
            private List<SegmentRef> segmentRefList = new ArrayList<SegmentRef>();

            /** 
             * Get the list of 'SegmentRef' element items.
             * 
             * @return list
             */
            public List<SegmentRef> getSegmentRefList() {
                return segmentRefList;
            }

            /** 
             * Set the list of 'SegmentRef' element items.
             * 
             * @param list
             */
            public void setSegmentRefList(List<SegmentRef> list) {
                segmentRefList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentRef" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:anySimpleType" name="id"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SegmentRef implements Serializable
            {
                private String id;

                /** 
                 * Get the 'id' attribute value. Reference ID
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'id' attribute value. Reference ID
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ClassOfService" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="code"/>
         *         &lt;xs:attribute type="xs:string" name="type"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ClassOfService implements Serializable
        {
            private String string;
            private String code;
            private String type;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ClassCode" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="code"/>
         *         &lt;xs:attribute type="xs:string" name="type"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ClassCode implements Serializable
        {
            private String string;
            private String code;
            private String type;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareDescription" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
         *       &lt;xs:element name="Detail" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Detail -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Condition" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Condition -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Fees" minOccurs="0">
         *         &lt;!-- Reference to inner class Fees -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareDescription implements Serializable
        {
            private String name;
            private String code;
            private List<Detail> detailList = new ArrayList<Detail>();
            private List<Condition> conditionList = new ArrayList<Condition>();
            private Fees fees;

            /** 
             * Get the 'Name' element value.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' element value.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the 'Code' element value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' element value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the list of 'Detail' element items.
             * 
             * @return list
             */
            public List<Detail> getDetailList() {
                return detailList;
            }

            /** 
             * Set the list of 'Detail' element items.
             * 
             * @param list
             */
            public void setDetailList(List<Detail> list) {
                detailList = list;
            }

            /** 
             * Get the list of 'Condition' element items.
             * 
             * @return list
             */
            public List<Condition> getConditionList() {
                return conditionList;
            }

            /** 
             * Set the list of 'Condition' element items.
             * 
             * @param list
             */
            public void setConditionList(List<Condition> list) {
                conditionList = list;
            }

            /** 
             * Get the 'Fees' element value.
             * 
             * @return value
             */
            public Fees getFees() {
                return fees;
            }

            /** 
             * Set the 'Fees' element value.
             * 
             * @param fees
             */
            public void setFees(Fees fees) {
                this.fees = fees;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="type"/>
             *         &lt;xs:attribute type="xs:string" name="codeContext"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Detail implements Serializable
            {
                private String string;
                private String type;
                private String codeContext;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'type' attribute value.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'type' attribute value.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'codeContext' attribute value.
                 * 
                 * @return value
                 */
                public String getCodeContext() {
                    return codeContext;
                }

                /** 
                 * Set the 'codeContext' attribute value.
                 * 
                 * @param codeContext
                 */
                public void setCodeContext(String codeContext) {
                    this.codeContext = codeContext;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Condition" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="lang"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Condition implements Serializable
            {
                private String string;
                private String lang;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'lang' attribute value.
                 * 
                 * @return value
                 */
                public String getLang() {
                    return lang;
                }

                /** 
                 * Set the 'lang' attribute value.
                 * 
                 * @param lang
                 */
                public void setLang(String lang) {
                    this.lang = lang;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fees" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:FeeType" name="Fee" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fees implements Serializable
            {
                private List<FeeType> feeList = new ArrayList<FeeType>();

                /** 
                 * Get the list of 'Fee' element items.
                 * 
                 * @return list
                 */
                public List<FeeType> getFeeList() {
                    return feeList;
                }

                /** 
                 * Set the list of 'Fee' element items.
                 * 
                 * @param list
                 */
                public void setFeeList(List<FeeType> list) {
                    feeList = list;
                }
            }
        }
    }
}
