
package com.sabre.services.sp.updatereservation.v11;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SkiCommonElementsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Age" minOccurs="0"/>
 *     &lt;xs:element name="CostPP" minOccurs="0">
 *       &lt;!-- Reference to inner class CostPP -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Notes" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Level" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SkiCommonElementsType implements Serializable
{
    private String description;
    private String age;
    private CostPP costPP;
    private String duration;
    private String name;
    private String notes;
    private String level;

    /** 
     * Get the 'Description' element value. Ski booking element description
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Ski booking element description
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'Age' element value. Age in ski booking element
     * 
     * @return value
     */
    public String getAge() {
        return age;
    }

    /** 
     * Set the 'Age' element value. Age in ski booking element
     * 
     * @param age
     */
    public void setAge(String age) {
        this.age = age;
    }

    /** 
     * Get the 'CostPP' element value.
     * 
     * @return value
     */
    public CostPP getCostPP() {
        return costPP;
    }

    /** 
     * Set the 'CostPP' element value.
     * 
     * @param costPP
     */
    public void setCostPP(CostPP costPP) {
        this.costPP = costPP;
    }

    /** 
     * Get the 'Duration' element value. Ski booking element duration
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value. Ski booking element duration
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'Name' element value. Ski booking element name
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Ski booking element name
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Notes' element value. Ski booking element notes
     * 
     * @return value
     */
    public String getNotes() {
        return notes;
    }

    /** 
     * Set the 'Notes' element value. Ski booking element notes
     * 
     * @param notes
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /** 
     * Get the 'Level' element value. Level in Ski booking element
     * 
     * @return value
     */
    public String getLevel() {
        return level;
    }

    /** 
     * Set the 'Level' element value. Level in Ski booking element
     * 
     * @param level
     */
    public void setLevel(String level) {
        this.level = level;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CostPP" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
     *     &lt;xs:attribute type="xs:string" name="Currency"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CostPP implements Serializable
    {
        private BigDecimal amount;
        private String currency;

        /** 
         * Get the 'Amount' attribute value. Ski booking element cost amount
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value. Ski booking element cost amount
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'Currency' attribute value. Ski booking element cost currency
         * 
         * @return value
         */
        public String getCurrency() {
            return currency;
        }

        /** 
         * Set the 'Currency' attribute value. Ski booking element cost currency
         * 
         * @param currency
         */
        public void setCurrency(String currency) {
            this.currency = currency;
        }
    }
}
