
package com.sabre.services.sp.updatereservation.v11;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MessageStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TravelType" minOccurs="0"/>
 *     &lt;xs:element type="ns:CompanyType" name="Vendor" minOccurs="0"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="StartDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="EndDetails" minOccurs="0"/>
 *     &lt;xs:element name="Price" minOccurs="0">
 *       &lt;!-- Reference to inner class Price -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PassengerType" name="Customer" minOccurs="0"/>
 *     &lt;xs:element name="Passengers" minOccurs="0">
 *       &lt;!-- Reference to inner class Passengers -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Services" minOccurs="0">
 *       &lt;!-- Reference to inner class Services -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TourType implements Serializable
{
    private String statusCode;
    private String messageStatus;
    private String travelType;
    private CompanyType vendor;
    private LocationDetailsType startDetails;
    private LocationDetailsType endDetails;
    private Price price;
    private PassengerType customer;
    private Passengers passengers;
    private Services services;

    /** 
     * Get the 'StatusCode' element value.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'MessageStatus' element value.
     * 
     * @return value
     */
    public String getMessageStatus() {
        return messageStatus;
    }

    /** 
     * Set the 'MessageStatus' element value.
     * 
     * @param messageStatus
     */
    public void setMessageStatus(String messageStatus) {
        this.messageStatus = messageStatus;
    }

    /** 
     * Get the 'TravelType' element value.
     * 
     * @return value
     */
    public String getTravelType() {
        return travelType;
    }

    /** 
     * Set the 'TravelType' element value.
     * 
     * @param travelType
     */
    public void setTravelType(String travelType) {
        this.travelType = travelType;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public CompanyType getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(CompanyType vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'StartDetails' element value.
     * 
     * @return value
     */
    public LocationDetailsType getStartDetails() {
        return startDetails;
    }

    /** 
     * Set the 'StartDetails' element value.
     * 
     * @param startDetails
     */
    public void setStartDetails(LocationDetailsType startDetails) {
        this.startDetails = startDetails;
    }

    /** 
     * Get the 'EndDetails' element value.
     * 
     * @return value
     */
    public LocationDetailsType getEndDetails() {
        return endDetails;
    }

    /** 
     * Set the 'EndDetails' element value.
     * 
     * @param endDetails
     */
    public void setEndDetails(LocationDetailsType endDetails) {
        this.endDetails = endDetails;
    }

    /** 
     * Get the 'Price' element value.
     * 
     * @return value
     */
    public Price getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value.
     * 
     * @param price
     */
    public void setPrice(Price price) {
        this.price = price;
    }

    /** 
     * Get the 'Customer' element value.
     * 
     * @return value
     */
    public PassengerType getCustomer() {
        return customer;
    }

    /** 
     * Set the 'Customer' element value.
     * 
     * @param customer
     */
    public void setCustomer(PassengerType customer) {
        this.customer = customer;
    }

    /** 
     * Get the 'Passengers' element value.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'Services' element value.
     * 
     * @return value
     */
    public Services getServices() {
        return services;
    }

    /** 
     * Set the 'Services' element value.
     * 
     * @param services
     */
    public void setServices(Services services) {
        this.services = services;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Price" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PriceType" name="Total" minOccurs="0"/>
     *       &lt;xs:element name="Breakdown" minOccurs="0" maxOccurs="99">
     *         &lt;!-- Reference to inner class Breakdown -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Price implements Serializable
    {
        private PriceType total;
        private List<Breakdown> breakdownList = new ArrayList<Breakdown>();

        /** 
         * Get the 'Total' element value.
         * 
         * @return value
         */
        public PriceType getTotal() {
            return total;
        }

        /** 
         * Set the 'Total' element value.
         * 
         * @param total
         */
        public void setTotal(PriceType total) {
            this.total = total;
        }

        /** 
         * Get the list of 'Breakdown' element items.
         * 
         * @return list
         */
        public List<Breakdown> getBreakdownList() {
            return breakdownList;
        }

        /** 
         * Set the list of 'Breakdown' element items.
         * 
         * @param list
         */
        public void setBreakdownList(List<Breakdown> list) {
            breakdownList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Breakdown" minOccurs="0" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="References" minOccurs="0">
         *         &lt;!-- Reference to inner class References -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PriceType" name="Price" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Breakdown implements Serializable
        {
            private References references;
            private PriceType price;

            /** 
             * Get the 'References' element value.
             * 
             * @return value
             */
            public References getReferences() {
                return references;
            }

            /** 
             * Set the 'References' element value.
             * 
             * @param references
             */
            public void setReferences(References references) {
                this.references = references;
            }

            /** 
             * Get the 'Price' element value.
             * 
             * @return value
             */
            public PriceType getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' element value.
             * 
             * @param price
             */
            public void setPrice(PriceType price) {
                this.price = price;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="References" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PassengerRef" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PassengerRef -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class References implements Serializable
            {
                private List<PassengerRef> passengerRefList = new ArrayList<PassengerRef>();

                /** 
                 * Get the list of 'PassengerRef' element items.
                 * 
                 * @return list
                 */
                public List<PassengerRef> getPassengerRefList() {
                    return passengerRefList;
                }

                /** 
                 * Set the list of 'PassengerRef' element items.
                 * 
                 * @param list
                 */
                public void setPassengerRefList(List<PassengerRef> list) {
                    passengerRefList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerRef" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:anySimpleType" name="id"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerRef implements Serializable
                {
                    private String id;

                    /** 
                     * Get the 'id' attribute value. Reference ID
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'id' attribute value. Reference ID
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PassengerType" name="Passenger" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:int" name="quantity"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private List<PassengerType> passengerList = new ArrayList<PassengerType>();
        private Integer quantity;

        /** 
         * Get the list of 'Passenger' element items.
         * 
         * @return list
         */
        public List<PassengerType> getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the list of 'Passenger' element items.
         * 
         * @param list
         */
        public void setPassengerList(List<PassengerType> list) {
            passengerList = list;
        }

        /** 
         * Get the 'quantity' attribute value.
         * 
         * @return value
         */
        public Integer getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'quantity' attribute value.
         * 
         * @param quantity
         */
        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/updatereservation/v1_1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ServiceRefType" name="Service" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Services implements Serializable
    {
        private List<ServiceRefType> serviceList = new ArrayList<ServiceRefType>();

        /** 
         * Get the list of 'Service' element items.
         * 
         * @return list
         */
        public List<ServiceRefType> getServiceList() {
            return serviceList;
        }

        /** 
         * Set the list of 'Service' element items.
         * 
         * @param list
         */
        public void setServiceList(List<ServiceRefType> list) {
            serviceList = list;
        }
    }
}
