
package com.sabre.services.stl.v02;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opentravel.common.message.v02.ExtensionPointSummary;

/** 
 * An unstructured address. A collection of lines that
 describe an address. This is a legacy type ; a preferred way to
 capture unstructured address is with Address_Simple string. If you
 use specific lines, they should be mapped to the specific fields in
 the Address type.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address_FreeFormat">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Line" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element ref="ns1:ExtensionPoint_Summary" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressFreeFormat implements Serializable
{
    private List<String> lineList = new ArrayList<String>();
    private ExtensionPointSummary extensionPointSummary;

    /** 
     * Get the list of 'Line' element items. Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to255
                      
     * 
     * @return list
     */
    public List<String> getLineList() {
        return lineList;
    }

    /** 
     * Set the list of 'Line' element items. Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}StringLength1to255
                      
     * 
     * @param list
     */
    public void setLineList(List<String> list) {
        lineList = list;
    }

    /** 
     * Get the 'ExtensionPoint_Summary' element value.
     * 
     * @return value
     */
    public ExtensionPointSummary getExtensionPointSummary() {
        return extensionPointSummary;
    }

    /** 
     * Set the 'ExtensionPoint_Summary' element value.
     * 
     * @param extensionPointSummary
     */
    public void setExtensionPointSummary(
            ExtensionPointSummary extensionPointSummary) {
        this.extensionPointSummary = extensionPointSummary;
    }
}
