
package com.sabre.services.stl.v02;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A numeric monetary value.Assigned XSD Type:
 {http://services.sabre.com/STL/v01}_amount

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:decimal">
 *       &lt;xs:attribute type="xs:string" use="optional" name="currencyCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="currency"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="decimalPlaces"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Amount implements Serializable
{
    private BigDecimal decimal;
    private String currencyCode;
    private String currency;
    private String decimalPlaces;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public BigDecimal getDecimal() {
        return decimal;
    }

    /** 
     * Set the extension value.
     * 
     * @param decimal
     */
    public void setDecimal(BigDecimal decimal) {
        this.decimal = decimal;
    }

    /** 
     * Get the 'currencyCode' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}CurrencyCodeList
                          
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}CurrencyCodeList
                          
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'currency' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @return value
     */
    public String getCurrency() {
        return currency;
    }

    /** 
     * Set the 'currency' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @param currency
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /** 
     * Get the 'decimalPlaces' attribute value. Number of decimal places used with this currency.
     * 
     * @return value
     */
    public String getDecimalPlaces() {
        return decimalPlaces;
    }

    /** 
     * Set the 'decimalPlaces' attribute value. Number of decimal places used with this currency.
     * 
     * @param decimalPlaces
     */
    public void setDecimalPlaces(String decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }
}
