
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Name of a building or set of structures refered to by a
 single name.
 Assigned XSD Type:
 {http://services.sabre.com/STL/v01}StringLength0to64

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Building">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="bldgNumber"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="roomNumber"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Building implements Serializable
{
    private String string;
    private String bldgNumber;
    private String roomNumber;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'bldgNumber' attribute value. Identifier of a specific building in the group of
                              structures refered to by the building name.
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}NumericStringLength1to19
                          
     * 
     * @return value
     */
    public String getBldgNumber() {
        return bldgNumber;
    }

    /** 
     * Set the 'bldgNumber' attribute value. Identifier of a specific building in the group of
                              structures refered to by the building name.
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}NumericStringLength1to19
                          
     * 
     * @param bldgNumber
     */
    public void setBldgNumber(String bldgNumber) {
        this.bldgNumber = bldgNumber;
    }

    /** 
     * Get the 'roomNumber' attribute value. Identifier of a specific room in the building.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}NumericStringLength1to19
                          
     * 
     * @return value
     */
    public String getRoomNumber() {
        return roomNumber;
    }

    /** 
     * Set the 'roomNumber' attribute value. Identifier of a specific room in the building.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}NumericStringLength1to19
                          
     * 
     * @param roomNumber
     */
    public void setRoomNumber(String roomNumber) {
        this.roomNumber = roomNumber;
    }
}
