
package com.sabre.services.stl.v02;

import java.io.Serializable;
import org.opentravel.common.message.v02.ExtensionPointSummary;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FirstName" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LastName" minOccurs="1"/>
 *     &lt;xs:element ref="ns1:ExtensionPoint_Summary" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="customerId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Customer1 implements Serializable
{
    private String firstName;
    private String lastName;
    private ExtensionPointSummary extensionPointSummary;
    private String customerId;

    /** 
     * Get the 'FirstName' element value. The first name of the customer who purchased the
                          ticket or service. Mapped to: SR05_32_FNAM
                      Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}PNRName
                      
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. The first name of the customer who purchased the
                          ticket or service. Mapped to: SR05_32_FNAM
                      Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}PNRName
                      
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. The last name of the customer who purchased a ticket
                          or service. Mapped to: SR05_32_LNAM
                      Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}PNRName
                      
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. The last name of the customer who purchased a ticket
                          or service. Mapped to: SR05_32_LNAM
                      Assigned XSD Type:
                          {http://services.sabre.com/STL/v01}PNRName
                      
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'ExtensionPoint_Summary' element value.
     * 
     * @return value
     */
    public ExtensionPointSummary getExtensionPointSummary() {
        return extensionPointSummary;
    }

    /** 
     * Set the 'ExtensionPoint_Summary' element value.
     * 
     * @param extensionPointSummary
     */
    public void setExtensionPointSummary(
            ExtensionPointSummary extensionPointSummary) {
        this.extensionPointSummary = extensionPointSummary;
    }

    /** 
     * Get the 'customerId' attribute value. A unique XML id associated to the customer.Assigned XSD Type:
                      {http://services.sabre.com/STL/v01}NumericLength1to2
                  
     * 
     * @return value
     */
    public String getCustomerId() {
        return customerId;
    }

    /** 
     * Set the 'customerId' attribute value. A unique XML id associated to the customer.Assigned XSD Type:
                      {http://services.sabre.com/STL/v01}NumericLength1to2
                  
     * 
     * @param customerId
     */
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }
}
