
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_AddressRole_Open">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Home"/>
 *     &lt;xs:enumeration value="Billing"/>
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="Chain"/>
 *     &lt;xs:enumeration value="Collection"/>
 *     &lt;xs:enumeration value="Contact"/>
 *     &lt;xs:enumeration value="CreditCard"/>
 *     &lt;xs:enumeration value="Delivery"/>
 *     &lt;xs:enumeration value="Deposit"/>
 *     &lt;xs:enumeration value="Hotel"/>
 *     &lt;xs:enumeration value="Mailing"/>
 *     &lt;xs:enumeration value="OtherUse"/>
 *     &lt;xs:enumeration value="Permanent"/>
 *     &lt;xs:enumeration value="Physical"/>
 *     &lt;xs:enumeration value="PreOpeningOffice"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumAddressRoleOpen implements Serializable {
    HOME("Home"), BILLING("Billing"), BUSINESS("Business"), CHAIN("Chain"), COLLECTION(
            "Collection"), CONTACT("Contact"), CREDIT_CARD("CreditCard"), DELIVERY(
            "Delivery"), DEPOSIT("Deposit"), HOTEL("Hotel"), MAILING("Mailing"), OTHER_USE(
            "OtherUse"), PERMANENT("Permanent"), PHYSICAL("Physical"), PRE_OPENING_OFFICE(
            "PreOpeningOffice"), OTHER_("Other_");
    private final String value;

    private EnumAddressRoleOpen(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumAddressRoleOpen convert(String value) {
        for (EnumAddressRoleOpen inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
