
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * An identifier that describes a phone location,
 technology and/or use type.
 This is a string list of enumerations with an "Other_"
 literal to support an open enumeration list. Use the "Other_" value
 in combination with the @extension attribute to exchange a literal
 that is not in the list and is known to your trading partners.
 Table name(s): Phone Location Type (PLT) |
 Phone Technology Type (PTT) | Phone Use Type (PUT)

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_ContactType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Contact"/>
 *     &lt;xs:enumeration value="DaytimeContact"/>
 *     &lt;xs:enumeration value="EmergencyContact"/>
 *     &lt;xs:enumeration value="EveningContact"/>
 *     &lt;xs:enumeration value="PickupContact"/>
 *     &lt;xs:enumeration value="TravelArranger"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumContactTypeBase implements Serializable {
    CONTACT("Contact"), DAYTIME_CONTACT("DaytimeContact"), EMERGENCY_CONTACT(
            "EmergencyContact"), EVENING_CONTACT("EveningContact"), PICKUP_CONTACT(
            "PickupContact"), TRAVEL_ARRANGER("TravelArranger"), OTHER_(
            "Other_");
    private final String value;

    private EnumContactTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumContactTypeBase convert(String value) {
        for (EnumContactTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
