
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * An identifier that describes the type of a customer
 and/or traveler name.
 This is a string list of enumerations with an "Other_"
 literal to support an open enumeration list. Use the "Other_" value
 in combination with the @extension attribute to exchange a literal
 that is not in the list and is known to your trading partners.
 Table name(s): Name Type (NAM)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_NameType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Alternate"/>
 *     &lt;xs:enumeration value="Former"/>
 *     &lt;xs:enumeration value="Maiden"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumNameType implements Serializable {
    ALTERNATE("Alternate"), FORMER("Former"), MAIDEN("Maiden");
    private final String value;

    private EnumNameType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumNameType convert(String value) {
        for (EnumNameType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
