
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_PhoneRole_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Fax"/>
 *     &lt;xs:enumeration value="Home"/>
 *     &lt;xs:enumeration value="Mobile"/>
 *     &lt;xs:enumeration value="Work"/>
 *     &lt;xs:enumeration value="TollFree"/>
 *     &lt;xs:enumeration value="GuestUse"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumPhoneRoleBase implements Serializable {
    FAX("Fax"), HOME("Home"), MOBILE("Mobile"), WORK("Work"), TOLL_FREE(
            "TollFree"), GUEST_USE("GuestUse");
    private final String value;

    private EnumPhoneRoleBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumPhoneRoleBase convert(String value) {
        for (EnumPhoneRoleBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
