
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_PricingSource">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Published"/>
 *     &lt;xs:enumeration value="Private"/>
 *     &lt;xs:enumeration value="Both"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumPricingSource implements Serializable {
    /** 
     * Published fare.
     */
    PUBLISHED("Published"), /** 
                             * Private fare.
                             */
    PRIVATE("Private"), /** 
                         * Fare is both public and private.
                         */
    BOTH("Both");
    private final String value;

    private EnumPricingSource(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumPricingSource convert(String value) {
        for (EnumPricingSource inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
